/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetaxcertificate.from2016;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.deuv.PerfidiaResult;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.SexEnum;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntry;
import com.varial.personnel.domain.employee.carriedforward.entry.EECarriedForwardOfEntryComparator;
import com.varial.personnel.domain.employee.carriedforward.system.clauseofmarch.EECarriedForwardSystemCOM;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.carriedforward.zvk.EECarriedForwardZVK;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTP;
import com.varial.personnel.domain.employee.insurancehipiyear.InsuranceHIPIYearTPPersistencyManager;
import com.varial.personnel.domain.employee.mapper.SexEnumMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.global.federalstate.FederalState;
import com.varial.personnel.domain.global.federalstate.FederalStatePersistencyManager;
import com.varial.personnel.domain.global.federalstate.FederalStateTP;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.global.socialinsurance.lawarea.SocialInsuranceLawArea;
import com.varial.personnel.domain.global.state.State;
import com.varial.personnel.domain.global.state.StateTP;
import com.varial.personnel.domain.global.taxoffice.TaxOffice;
import com.varial.personnel.domain.global.taxoffice.TaxOfficePersistencyManager;
import com.varial.personnel.domain.global.taxoffice.TaxOfficeTP;
import com.varial.personnel.domain.lstb.LStB;
import com.varial.personnel.domain.lstb.TypeOfInstructionEnum;
import com.varial.personnel.domain.lstb.lstbaccount.ILStBAccountPersistencyManager;
import com.varial.personnel.domain.lstb.lstbaccount.LStBAccount;
import com.varial.personnel.domain.lstb.lstbmonat.LStBMonat;
import com.varial.personnel.domain.lstb.lstbwert.LStBWert;
import com.varial.personnel.domain.lstb.mapper.TypeOfInstructionEnumMapper;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.pcompany.foundations.SpecificEnum;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.plant.place.PlantPlaceTP;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportRespectValuateEnum;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.EmployerBean;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldBean;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldCreator;
import com.varial.personnel.domain.reports.library.addressfield.AddressFieldHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.ReportDataTransfer;
import com.varial.personnel.domain.reports.wagetaxcertificate.EmployeeWageTaxCertificateBean;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.LStBMonate;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateContainerQueries;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateDataSourceInterface;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateHelper;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateInsuranceSubBean;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateSortComparator;
import com.varial.personnel.domain.reports.wagetaxcertificate.WageTaxCertificateSubReport;
import com.varial.personnel.domain.reports.wagetaxcertificate.from2016.EmployeeWageTaxCertificateBeanCollection;
import com.varial.personnel.domain.reports.wagetaxcertificate.from2016.LStBCapitalLetters;
import com.varial.personnel.domain.reports.wagetaxcertificate.from2016.WageTaxCertificatePrintBean;
import com.varial.personnel.domain.reports.wagetaxcertificate.mapper.WTCExceptionMapper;
import com.varial.personnel.domain.reports.wagetaxcertificate.until2015.WageTaxCertificateDataSource;
import com.varial.personnel.domain.statisticalvalue.StatisticalValueTP;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.Period;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.personnel.framework.multikeymap.MultiKeyHashMap2;
import com.varial.personnel.framework.multikeymap.MultiKeyMap2;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.company.comptaxofficeall.ComptaxofficeallContainer;
import com.varial.personnel.persistency.company.comptaxofficeall.IComptaxofficeallDao;
import com.varial.personnel.persistency.employee.employmentall.EmploymentallContainer;
import com.varial.personnel.persistency.employee.employmentall.IEmploymentallDao;
import com.varial.personnel.persistency.employee.insuranceall.IInsuranceallDao;
import com.varial.personnel.persistency.employee.insuranceall.InsuranceallContainer;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.plant.plantfoundations.PlantfoundationsContainer;
import com.varial.personnel.persistency.plant.planttaofficeall.IPlanttaofficeallDao;
import com.varial.personnel.persistency.plant.planttaofficeall.PlanttaofficeallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.domain.user.User;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRField;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WageTaxCertificateDataSource2016
implements WageTaxCertificateDataSourceInterface {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);
    private static final ILStBAccountPersistencyManager lStBAccountPersistencyManager = (ILStBAccountPersistencyManager)UtilitiesManager.getBean((String)"lStBAccountPersistencyManager", ILStBAccountPersistencyManager.class);
    private static final ITaxDao daoTax = (ITaxDao)UtilitiesManager.getBean((String)"taxDao", ITaxDao.class);
    private static final IPlanttaofficeallDao daoPlanttaofficeall = (IPlanttaofficeallDao)UtilitiesManager.getBean((String)"planttaofficeallDao", IPlanttaofficeallDao.class);
    private static final IComptaxofficeallDao daoComptaxofficeall = (IComptaxofficeallDao)UtilitiesManager.getBean((String)"comptaxofficeallDao", IComptaxofficeallDao.class);
    private static final IEmploymentallDao daoEmploymentall = (IEmploymentallDao)UtilitiesManager.getBean((String)"employmentallDao", IEmploymentallDao.class);
    private static final IInsuranceallDao daoInsuranceall = (IInsuranceallDao)UtilitiesManager.getBean((String)"insuranceallDao", IInsuranceallDao.class);
    private static final ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)UtilitiesManager.getBean((String)"calculationbasicDao", ICalculationbasicDao.class);
    private static final IValuepositionDao daoValueposition = (IValuepositionDao)UtilitiesManager.getBean((String)"valuepositionDao", IValuepositionDao.class);
    private static final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private static final WageTaxCertificateHelper mWageTaxCertificateHelper = (WageTaxCertificateHelper)UtilitiesManager.getBean((String)"wageTaxCertificateHelper", WageTaxCertificateHelper.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(WageTaxCertificateDataSource.class);
    protected static final BigDecimal ZERO2 = BigDecimal.valueOf(0L, 2);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private final DateFormat DATEFORMAT_TTMM = new SimpleDateFormat("ddMM");
    private final Date mCalculationStartDate;
    private static final String NONBREAKING_SPACES = StringUtil.repeat((char)'\u00a0', (int)7);
    private final Map<String, List<TaxContainer>> mTaxMap;
    private final Map<String, List<EmploymentallContainer>> mEmploymentAllMap;
    private final Map<String, List<InsuranceallContainer>> mInsuranceAllMap;
    private Map<String, List<InsuranceallContainer>> mRCInsuranceAllMap = new HashMap<String, List<InsuranceallContainer>>();
    private final Map<String, List<PlantfoundationsContainer>> mPlantfoundationsMap;
    private final Map<String, List<PlanttaofficeallContainer>> mPlanttaofficeallMap;
    private LStBMonate mLStBMonate;
    private final MultiKeyMap2<String, Date, Date> mRRBeginnMap;
    protected final Iterator<EmployeeWageTaxCertificateBean> mEmployeeWageTaxEFRit;
    private final Map<String, TaxOffice> mTaxOfficeMap = new HashMap<String, TaxOffice>();
    private final Map<String, StateTP> mStateTPMap = new HashMap<String, StateTP>();
    private final Map<String, List<ComptaxofficeallContainer>> mComptaxofficeallMap;
    protected final boolean mInternalUse;
    private boolean mHasDBAorATE = false;
    private boolean mHasNurDBAorATE = false;
    protected int mEmployeeCountOfGroup = 0;
    private final List<String> mDbaOrAteVPList = new ArrayList<String>();
    private final List<EmployeeForReport> mListEmployeeForReport = new ArrayList<EmployeeForReport>();
    private List<ValuepositionContainer> mValuePositionsMKFJLi;
    private List<ValuepositionContainer> mValuePositionsMKFJSWLi;
    protected String mCurrentOidPlant;
    protected String mCurrentOidPlantTemp;
    protected String mPlantTaxNumber = "";
    protected String mPlantTaxNumberTemp = "";
    private static final String[] VALUETYPENUMBERS = new String[]{"220695", "103570", "103590", "102590", "102550", "102540", "110595", "110510", "110610", "110630", "220510", "220610", "220630", "760100", "760450", "223510", "223610", "223630", "760110", "760460", "226510", "226610", "226630", "760120", "760470", "227510", "227610", "227630", "760130", "760480", "102500", "102505", "102520", "220620", "223620", "226620", "227620", "103500", "400100", "400400", "230510", "695200", "695500", "150526", "103510", "103515", "103520", "103530", "101590", "220400", "102580", "103540", "103550", "322510", "322514", "322516", "322518", "322610", "322616", "322630", "322636", "322730", "322736", "351510", "351516", "750200", "750300", "770000", "770005", "334510", "334514", "334610", "334630", "334730", "340510", "340514", "340516", "340518", "340610", "340616", "340630", "340636", "340730", "340736", "355510", "355516", "771000", "329510", "329512", "329514", "329520", "329560", "329610", "329620", "329640", "329730", "329740", "775510", "775514", "775560", "775610", "775630", "775640", "775730", "774510", "774514", "774550", "774610", "774620", "774630", "774730", "103595", "328510", "328512", "328514", "328550", "328610", "328630", "328730", "130630", "130640", "102560", "102570", "770010", "771010", "770020", "770025", "770030", "770035", "770040", "770045", "103545", "770120", "770130", "770140", "771020", "771030", "771040", "771120", "771130", "771140", "250510", "250610", "103580", "111310", "111320", "104710", "104720", "104730", "760500", "103600", "111140", "111240", "111340", "111540", "321050", "327050", "773050", "333050", "339050"};
    private static final String[] VALUETYPENUMBERS_DBA_AND_ATE = new String[]{"103510", "103520"};
    private static final String[] VALUETYPENUMBERS_MK_FJ = new String[]{"322620", "322626", "334620", "340620", "340626", "328620", "329630"};
    private static final String[] VALUETYPENUMBERS_MK_FJ_SW = new String[]{"322630", "322636", "334630", "340630", "340636", "328630", "329640"};
    private static final String[] VALUETYPENUMBERS_RUECKRECHNUNG_SV = new String[]{"102500", "102505", "329510", "329512", "329514", "329520", "329560", "329610", "329620", "329640", "329730", "329740", "775510", "775514", "775560", "775610", "775630", "775640", "775730", "774510", "774514", "774550", "774610", "774620", "774630", "774730", "103595", "328510", "328512", "328514", "328550", "328610", "328630", "328730", "770020", "770025", "770030", "770035", "770040", "770045", "103545", "770120", "770130", "770140", "771020", "771030", "771040", "771120", "771130", "771140", "322510", "322514", "322516", "322518", "322610", "322616", "322630", "322636", "322730", "322736", "351510", "351516", "750200", "750300", "770000", "770005", "334510", "334514", "334610", "334630", "334730", "340510", "340514", "340516", "340518", "340610", "340616", "340630", "340636", "340730", "340736", "355510", "355516", "771000", "103500", "400100", "400400", "230510", "695200", "695500", "150526", "111310", "111320", "111140", "111240", "111340", "111540", "321050", "327050", "773050", "333050", "339050"};
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private final Date mListFirstDate;
    private final Date mListEndDate;
    protected final Date mActualDate;
    protected final User mUser;
    private final String mYear;
    protected final int mYearInt;
    private String mEmployerWageTaxOfficeDescription = "";
    private String mWageTaxOfficeNumber = "";
    private String mEmployeeWageTaxOfficeDescription = "";
    private String mEmployeeWageTaxOfficeNumber = "";
    private String mElsterEmployerNumber = "";
    private String mEmployerDescription = "";
    private String mEmployerStreetStreetNumber = "";
    private String mEmployerPostalCode = "";
    private String mEmployerCity = "";
    private String mEmployerStateTag = "";
    private String mEmployerStateDescription = "";
    private int mEmployerFederalStateKey = 0;
    private String mEmployerTaxNumber = "";
    private String mPlantKey = "";
    private final String mPCompanyKey;
    private String mEmployeeTitle = "";
    private String mEmployeeAdressAddition1 = "";
    private String mEmployeeAdressAddition2 = "";
    private String mEmployeeAdressAddition3 = "";
    private String mEmployeeNameAffix = "";
    private String mEmployeeNamePrefix = "";
    private String mEmployeeSex = "";
    protected String mEmployeeName = "";
    protected String mEmployeeFirstName = "";
    private final AddressFieldCreator mAddressFieldCreator;
    private List<AddressFieldBean> mAddressFieldBeans;
    private String mSortiermerkmal = "";
    private String mEmployeeDomicilStreet = "";
    private String mEmployeeDomicilStreetNumber = "";
    private String mEmployeeDomicilPostalCode = "";
    private String mEmployeeDomicile = "";
    private String mEmployeeAdressAddendum = "";
    private String mEmployeeDomicilStateTag = "";
    private int mEmployeePersonnelNumber = 0;
    private String mEmployeePersonnelNumberForPrint = "";
    private Date mEmployeeDateOfBirth = null;
    private String mEmployeeDateOfBirthELSTAM = null;
    private String mEmployeeETIN = "";
    private String mEmployeeIDENT = "";
    protected String mEmployeeShortDescSocialInsuranceLaw = "";
    protected String mEmployeeShortDescSocialInsuranceLawTemp = "";
    protected Date mEmploymentStartDate;
    protected Date mEmploymentEndDate;
    private String mEmployerHolidaysCount = "";
    private BigDecimal FIELD_u_anz_bigdecimal = ZERO2;
    private LStBCapitalLetters mCapitalLetters = new LStBCapitalLetters();
    private BigDecimal FIELD_z_3_arbeitslohn_brutto = ZERO2;
    private BigDecimal FIELD_LSteuer = ZERO2;
    private BigDecimal FIELD_SolZ = ZERO2;
    private BigDecimal FIELD_KiStAN = ZERO2;
    private BigDecimal FIELD_KiStEG = ZERO2;
    protected BigDecimal FIELD_StBegVBez = ZERO2;
    protected BigDecimal FIELD_StBegVBezMKalJahr = ZERO2;
    private BigDecimal FIELD_ErmStBetrMKalJahr = ZERO2;
    private BigDecimal FIELD_LSteuerMKalendJahr = ZERO2;
    private BigDecimal FIELD_SolZMKalJahr = ZERO2;
    private BigDecimal FIELD_KiStANMKalJahr = ZERO2;
    private BigDecimal FIELD_KiStEGMKalJahr = ZERO2;
    private BigDecimal FIELD_KurzArbGeld = ZERO2;
    private BigDecimal FIELD_KurzArbGeldAnteilig = ZERO2;
    private BigDecimal FIELD_StFreiArbLohnDBA = ZERO2;
    private BigDecimal FIELD_StFreiArbLohnATE = ZERO2;
    private BigDecimal FIELD_StFreiAGLeistg = ZERO2;
    private BigDecimal FIELD_PauschAGLsitg = ZERO2;
    private BigDecimal FIELD_StPflichtEntschArbLohnMKalJahr = ZERO2;
    private BigDecimal FIELD_StFreiVerpfleg = ZERO2;
    private BigDecimal FIELD_StFreiDopHaushalt = ZERO2;
    private BigDecimal FIELD_AGAGesRV = ZERO2;
    private BigDecimal FIELD_AGABerufVersorg = ZERO2;
    private BigDecimal FIELD_ANAGesRV = ZERO2;
    private BigDecimal FIELD_ANABerufVersorg = ZERO2;
    private BigDecimal FIELD_StFreiArbgZuschGesKV = ZERO2;
    private BigDecimal FIELD_StFreiArbgZuschPrivKV = ZERO2;
    private BigDecimal FIELD_StFreiArbgZuschGesPV = ZERO2;
    private BigDecimal FIELD_KV_ANA = ZERO2;
    private BigDecimal mKVFreiwBeitrag = ZERO2;
    private BigDecimal FIELD_PV_ANA = ZERO2;
    private BigDecimal mPVFreiwBeitrag = ZERO2;
    private BigDecimal FIELD_AV_ANA = ZERO2;
    private BigDecimal FIELD_Priv_KV_PV = ZERO2;
    protected BigDecimal FIELD_BemGrundVersFreiBetrag = ZERO2;
    protected String FIELD_VersBezMonatKalJahr = "";
    protected String FIELD_VBZBeginnPerfidia = "";
    protected String FIELD_VBZEndePerfidia = "";
    protected String FIELD_VBZBeginnEnde = "";
    protected BigDecimal FIELD_SterbegeldVBZNachzahl = ZERO2;
    private BigDecimal FIELD_AusgezKiGeld = ZERO2;
    private BigDecimal FIELD_FreibetragDBATuerkei = ZERO2;
    private BigDecimal FIELD_Kammerbeitrag_Bremen = ZERO2;
    private BigDecimal FIELD_Kammerbeitrag_Saarland = ZERO2;
    private BigDecimal FIELD_Fahrtkosten_Auswaertstaetigkeit = ZERO2;
    private BigDecimal FIELD_AGA_Zusatzversorgung = ZERO2;
    private BigDecimal FIELD_ANA_Zusatzversorgung = ZERO2;
    private List<String> FIELD_Zusatztext = new ArrayList<String>();
    private List<String> FIELD_Zusatzbetrag = new ArrayList<String>();
    private BigDecimal mBeitragspflichtigZVKUmlageAGA = BigDecimal.ZERO;
    private BigDecimal mSteuerfreiZVKUmlageAGA = BigDecimal.ZERO;
    private BigDecimal mPauschalsteuerpflichtigZVKUmlageAGA = BigDecimal.ZERO;
    private BigDecimal mSteuerpflichtigZVKUmlageAGA = BigDecimal.ZERO;
    private BigDecimal mGesamtesKVEntgelt = BigDecimal.ZERO;
    private BigDecimal mGesamtesRVEntgelt = BigDecimal.ZERO;
    private BigDecimal mGesamtesAVEntgelt = BigDecimal.ZERO;
    private BigDecimal mGesamtesPVEntgelt = BigDecimal.ZERO;
    protected WageTaxCertificateSubReport mSubReport;
    protected ReportDataTransfer mReportDataTransfer;
    protected BufferedWriter mDateiEinschreiben;
    protected final boolean mUsePerfidia;
    private final String mVersion;
    private final Foundations mCompanyFoundations;
    private final PCompany mPCompany;
    private final PCompany mPCompanyForFoundations;
    private final PCompany mPCompanyForSettings;
    private final boolean mIsSuperiorForConsolidation;
    private static final String LSTB_PRODUKTNAME = "Varial World Edition Personalwirtschaft";
    private static final String LSTB_HERSTELLERID = "20260";
    private static final String LSTB_KENNUNG_VORLAUFSATZ = "VOSZ";
    private static final String LSTB_VERSION_VORLAUFSATZ = "01";
    private final String LSTB_MERKER;
    private final String LSTB_VERSION;
    private static final String LSTB_ART = "ELStAM";
    private static final String LSTB_VERSION_PersonalSatz = "02";
    protected static final String mSendQuePath = "\\ofd\\sendq\\";
    protected static final String mWageTaxCertificateReportFilePrefix = "elstb0_";
    private boolean mValueTypeNumber220400 = false;
    private final ReportValues mReportValues = new ReportValues();
    private final ReportSortStruct mSort;
    protected String mPerfidiaPath;
    private boolean mVorjahr = false;
    protected final AllCallback mCallback;
    protected final PerfidiaResult mPerfidiaResult;
    private final List<Integer> mFileNumbers;
    private final ProgressBarUpdater mProgressBar;
    private final int mCountEmployeeWageTaxEFRit;
    private boolean mHasCFFofEntryZVK = false;
    private final List<StatisticalValueTP> mStatisticalValueTPs;
    private List<BigDecimal> mStatisticalValues = new ArrayList<BigDecimal>();
    protected final boolean mIsForCarriedForward;
    protected WageTaxCertificatePrintBean currentBean;

    public WageTaxCertificateDataSource2016(AllCallback callback, ISpecialAccessPersistencyContext specialAccessPersistencyContext, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date listFirstDate, Date listEndDate, boolean usePerfidia, boolean internalUse, List<StatisticalValueTP> statisticalValueTPs, PerfidiaResult perfidiaResult, List<Integer> fileNumbers, List<String> errorList, ReportRespectValuateEnum reportRespectValuate, boolean isForCarriedForward, ProgressBarUpdater progressBar) throws BusinessDomainException, PutDataException {
        List ewtcbs;
        BusinessDomainException de;
        String[] messages;
        this.mCallback = callback;
        this.mUser = userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode());
        this.mVersion = Version.getVersion();
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = listEndDate;
        this.mListEndDate = listEndDate;
        this.mInternalUse = internalUse;
        this.mUsePerfidia = usePerfidia;
        this.mStatisticalValueTPs = statisticalValueTPs;
        this.mPerfidiaResult = perfidiaResult;
        this.mFileNumbers = fileNumbers;
        this.mIsForCarriedForward = isForCarriedForward;
        this.mProgressBar = progressBar;
        this.mYearInt = WageTaxCertificateDataSource2016.getYear(listFirstDate);
        this.mYear = Integer.toString(this.mYearInt);
        this.LSTB_VERSION = this.mYear + LSTB_VERSION_VORLAUFSATZ;
        this.mActualDate = DateHelper.max((Date)new Date(), (Date)this.mListEndDate);
        this.mAddressFieldCreator = AddressFieldHelper.getInstance().createAddressFieldCreator(this.mActualDate);
        EmployeeForReportGenerator generator = new EmployeeForReportGenerator(specialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, DateHelper.getFirstDayOfMonth((Date)this.mListEndDate), DateHelper.getLastDayOfMonth((Date)this.mListEndDate), forEffectiveDate, this.mForValidDate, errorList, reportRespectValuate);
        this.mSort = sorts.length > 0 ? sorts[0] : null;
        EmployeeForReport[] efrs = generator.getEmployeesForReport();
        if (!errorList.isEmpty()) {
            BusinessDomainException de2 = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport(errorList);
            if (this.mInternalUse && this.mCallback != null) {
                this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de2));
            } else {
                throw de2;
            }
        }
        this.mIsSuperiorForConsolidation = generator.isSuperiorForConsolidation();
        this.mPCompany = generator.getPCompany();
        this.mPCompanyForFoundations = generator.getPCompanyForFoundations();
        this.mPCompanyForSettings = generator.getPCompanyForSettings();
        CompanyFoundations companyFoundations = (CompanyFoundations)this.mPCompanyForFoundations.getCompanyFoundationsHistory().getItemOrNull(this.mForEffectiveDate, this.mListEndDate);
        if (companyFoundations == null) {
            String message = "Aus Sicht: " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate) + " und G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mListEndDate);
            throw ReportExceptionMapper.makeCompanyFoundationsMissingDomainException((String)message);
        }
        this.LSTB_MERKER = companyFoundations.getSpecific() == SpecificEnum.SE_Musterfirma ? "220000000" : "000000000";
        this.mCompanyFoundations = companyFoundations.getFoundations();
        this.mCalculationStartDate = mReportHelper.getCalculationStartDate(companyFoundations);
        this.mPCompanyKey = this.mPCompany.getPCompanyKey();
        try {
            this.mPCompanyForSettings.getCompanySettings(this.mForEffectiveDate, this.mListEndDate);
        }
        catch (BusinessDomainException e) {
            String message = "Aus Sicht: " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate) + " und G\u00fcltig f\u00fcr: " + DateMapper.toDDMMYYYYPointSeparationString((Date)this.mListEndDate);
            throw ReportExceptionMapper.makeCompanySettingsMissingDomainException((String)message);
        }
        this.mListFirstDate = DateHelper.max((Date)listFirstDate, (Date)this.mCalculationStartDate);
        if (this.mUsePerfidia) {
            this.mPerfidiaPath = this.mReportValues.getCompanyTaxOfficePerfidiaPath(this.mPCompanyForSettings.getObjectid(), this.mForEffectiveDate, this.mForValidDate);
        }
        HashMap<String, ArrayList<EmployeeForReport>> employeesMap = new HashMap<String, ArrayList<EmployeeForReport>>();
        HashMap<String, Date> employeeEntryHashMap = new HashMap<String, Date>();
        for (EmployeeForReport efr : efrs) {
            String oidEmployee = efr.getOidEmployee();
            efr.setDateOfEntry(mWageTaxCertificateHelper.getDateOfEntry(oidEmployee, efr.getDateOfEntry(), this.mForEffectiveDate, this.mForValidDate));
            efr.setDateOfWithDrawal(mWageTaxCertificateHelper.getDateOfWithDrawal(oidEmployee, efr.getDateOfWithDrawal(), this.mForEffectiveDate, this.mForValidDate));
            ArrayList<EmployeeForReport> liste = (List)employeesMap.get(oidEmployee);
            if (liste == null) {
                liste = new ArrayList<EmployeeForReport>();
                employeesMap.put(oidEmployee, liste);
            }
            liste.add(efr);
            Date dateOfEntry = (Date)employeeEntryHashMap.get(oidEmployee);
            if (dateOfEntry != null && (!DateHelper.after((Date)efr.getDateOfEntry(), (Date)dateOfEntry) || !DateHelper.beforeOrEqual((Date)efr.getDateOfEntry(), (Date)this.mListEndDate))) continue;
            employeeEntryHashMap.put(oidEmployee, efr.getDateOfEntry());
        }
        ArrayList<EmployeeForReport> employeesList = new ArrayList<EmployeeForReport>();
        for (List employeeForReportlist : employeesMap.values()) {
            if (employeeForReportlist.size() > 1) {
                ArrayList<Date> employeesValidUntilDateList = new ArrayList<Date>();
                ArrayList<EmployeeForReport> employeeForReportOfDatelist = new ArrayList<EmployeeForReport>();
                for (EmployeeForReport efr : employeeForReportlist) {
                    if (!DateHelper.equal((Date)((Date)employeeEntryHashMap.get(efr.getOidEmployee())), (Date)efr.getDateOfEntry()) || !DateHelper.after((Date)efr.getEmploymentValidUntil(), (Date)this.mListFirstDate) || !DateHelper.before((Date)efr.getEmploymentValidFrom(), (Date)this.mListEndDate)) continue;
                    employeesValidUntilDateList.add(efr.getEmploymentValidUntil());
                    employeeForReportOfDatelist.add(efr);
                }
                Date minValidUntil = DateHelper.min((Date[])employeesValidUntilDateList.toArray(new Date[0]));
                if (employeeForReportOfDatelist.size() > 1) {
                    EmployeeForReport oldEAC = null;
                    for (EmployeeForReport eFRDate : employeeForReportOfDatelist) {
                        if (!DateHelper.equal((Date)eFRDate.getEmploymentValidUntil(), (Date)minValidUntil)) continue;
                        oldEAC = eFRDate;
                        break;
                    }
                    Date nextValidFromDate = DateHelper.tomorrow((Date)minValidUntil);
                    EmployeeForReport newEAC = WageTaxCertificateDataSource2016.getEmployeeForReportWithValidFromDate(employeeForReportOfDatelist, nextValidFromDate);
                    while (newEAC != null) {
                        if (!WageTaxCertificateDataSource2016.equalOldNewEmployeeForReport(oldEAC, newEAC)) {
                            employeesList.add(oldEAC);
                        }
                        if ((newEAC = WageTaxCertificateDataSource2016.getEmployeeForReportWithValidFromDate(employeeForReportOfDatelist, nextValidFromDate = DateHelper.tomorrow((Date)(oldEAC = EmployeeForReportGenerator.createNew((EmployeeForReport)newEAC)).getEmploymentValidUntil()))) != null) continue;
                        employeesList.add(oldEAC);
                    }
                    continue;
                }
                for (EmployeeForReport efr : employeeForReportlist) {
                    if (!DateHelper.between((Date)minValidUntil, (Date)efr.getEmploymentValidFrom(), (Date)efr.getEmploymentValidUntil())) continue;
                    employeesList.add(efr);
                }
                continue;
            }
            employeesList.add((EmployeeForReport)employeeForReportlist.get(0));
        }
        if (employeesList.isEmpty()) {
            throw WTCExceptionMapper.makeNoLStBsToCreateException();
        }
        Date[] effectiveDates = new Date[]{this.mForEffectiveDate, mReportHelper.getRueckrechnungssperre(this.mYearInt), mReportHelper.getRueckrechnungssperre(this.mYearInt - 1)};
        this.mRRBeginnMap = this.queryRRBeginnMap(WageTaxCertificateDataSource2016.getOidEmployees(employeesList), effectiveDates);
        Collections.sort(employeesList, new WageTaxCertificateSortComparator(sorts));
        for (EmployeeForReport efr : employeesList) {
            Date date = (Date)this.mRRBeginnMap.get((Object)efr.getOidEmployee(), (Object)this.mForEffectiveDate);
            Date returnCalculationDate = date != null ? date : DateHelper.getFirstDayOfMonth((Date)this.mListEndDate);
            Date dateOfWithDrawal = efr.getDateOfWithDrawal();
            Date dateOfEntry = efr.getDateOfEntry();
            if (!this.mInternalUse) {
                if (!mWageTaxCertificateHelper.isRelevantForReport(efr, this.mForEffectiveDate, dateOfWithDrawal, returnCalculationDate, this.mListEndDate)) continue;
                Employee successor = this.mReportValues.getEmployee(efr.getOidEmployee()).getSuccessor();
                if (this.mYearInt > 2018 && successor != null && WageTaxCertificateDataSource2016.getYear(successor.getMinimumDateOfEntry()) == this.mYearInt && !this.isSuccessorGfB(successor, efr.getDateOfWithDrawal())) continue;
                if (!DateHelper.equal((Date)dateOfWithDrawal, (Date)dateOfEntry)) {
                    this.mListEmployeeForReport.add(efr);
                    continue;
                }
                Employee employee = this.mReportValues.getEmployee(efr.getOidEmployee());
                BigDecimal bg = employee.sumOfValueTypeByResult(this.mForEffectiveDate, dateOfEntry, dateOfWithDrawal, 110000);
                if (BigDecimalMapper.isZero((BigDecimal)bg)) continue;
                this.mListEmployeeForReport.add(efr);
                continue;
            }
            if (dateOfWithDrawal != null && !DateHelper.afterOrEqual((Date)dateOfWithDrawal, (Date)this.mListFirstDate) && !DateHelper.beforeOrEqual((Date)returnCalculationDate, (Date)dateOfWithDrawal)) continue;
            this.mListEmployeeForReport.add(efr);
        }
        if (this.mListEmployeeForReport.isEmpty()) {
            throw WTCExceptionMapper.makeNoLStBsToCreateException();
        }
        Collection<String> oidEmployees = WageTaxCertificateDataSource2016.getOidEmployees(this.mListEmployeeForReport);
        Collection<String> oidPCompanys = WageTaxCertificateDataSource2016.getOidPCompanys(this.mListEmployeeForReport);
        String[] oidPlants = WageTaxCertificateDataSource2016.getOidPlants(this.mListEmployeeForReport).toArray(new String[0]);
        this.mComptaxofficeallMap = WageTaxCertificateDataSource2016.queryHashMapCompanyTaxOfficeAll(oidPCompanys, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
        this.mPlantfoundationsMap = WageTaxCertificateContainerQueries.queryMapPlantFoundations((String[])oidPlants, (Date)this.mForEffectiveDate, (Date)this.mListFirstDate, (Date)this.mListEndDate);
        this.mPlanttaofficeallMap = WageTaxCertificateContainerQueries.queryMapPlantTaxOfficeAll((String[])oidPlants, (Date)this.mForEffectiveDate, (Date)this.mListFirstDate, (Date)this.mListEndDate);
        this.mTaxMap = WageTaxCertificateDataSource2016.queryHashMapTax(oidEmployees, this.mForEffectiveDate, this.mListFirstDate, this.mActualDate);
        this.mEmploymentAllMap = WageTaxCertificateDataSource2016.queryHashMapEmploymentAll(oidEmployees, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
        this.mInsuranceAllMap = WageTaxCertificateDataSource2016.queryHashMapInsuranceall(oidEmployees, this.mForEffectiveDate, this.mListFirstDate, this.mActualDate);
        EmployeeWageTaxCertificateBeanCollection employeeWageTaxCertificateBeanCollection = new EmployeeWageTaxCertificateBeanCollection(this.mUsePerfidia);
        ArrayList<CallSite> employeeNoTaxData = new ArrayList<CallSite>();
        ArrayList<CallSite> employeesNotJournalized = new ArrayList<CallSite>();
        for (EmployeeForReport efr : this.mListEmployeeForReport) {
            String oidEmployee = efr.getOidEmployee();
            String oidPCompany = efr.getOidPCompany();
            String oidPlant = efr.getOidPlant();
            Employee employee = this.mReportValues.getEmployee(oidEmployee);
            Date firstDate = mWageTaxCertificateHelper.getCurrentEmployeeFirstDate(efr, this.mListFirstDate, this.mListEndDate);
            Date endDate = efr.getDateOfWithDrawal() == null ? efr.getEmploymentValidUntil() : efr.getDateOfWithDrawal();
            endDate = DateHelper.min((Date)endDate, (Date)this.mListEndDate);
            endDate = DateHelper.afterOrEqual((Date)endDate, (Date)firstDate) ? endDate : this.mListEndDate;
            List<TaxContainer> listeTax = this.mTaxMap.get(oidEmployee);
            if (listeTax == null || listeTax.isEmpty()) {
                employeeNoTaxData.add((CallSite)((Object)("Personalnummer: " + efr.getPersonnelNumber() + " Name: " + efr.getSurname())));
                continue;
            }
            if (!this.mInternalUse && !this.isJournalized(employee)) {
                employeesNotJournalized.add((CallSite)((Object)("Personalnummer: " + (String)(this.mIsSuperiorForConsolidation ? employee.getPCompany().getPCompanyKey() + "/" + efr.getPersonnelNumber() : efr.getPersonnelNumber()) + " Name: " + efr.getSurname())));
                continue;
            }
            Map<Boolean, List<Period>> periodMap = this.getPeriodMap(listeTax, new Period(firstDate, endDate));
            for (Boolean isRelevant : periodMap.keySet()) {
                if (!isRelevant.booleanValue() && !this.mUsePerfidia) continue;
                for (Period period : periodMap.get(isRelevant)) {
                    Date currentEmployeeEndDateTemp = DateHelper.min((Date)endDate, (Date)period.until);
                    EmployeeWageTaxCertificateBean eWT = new EmployeeWageTaxCertificateBean(EmployeeForReportGenerator.createNew((EmployeeForReport)efr));
                    if (!StringMapper.isNullString((String)oidPlant)) {
                        this.getPlantTax(eWT, currentEmployeeEndDateTemp, oidPlant);
                    }
                    if (this.mUsePerfidia) {
                        String oidTaxOffice = null;
                        if (!StringMapper.isNullString((String)oidPlant)) {
                            oidTaxOffice = WageTaxCertificateDataSource2016.queryPlantTaxOffice(oidPlant, this.mForEffectiveDate, this.mForValidDate);
                        }
                        if (StringMapper.isNullString(oidTaxOffice)) {
                            oidTaxOffice = WageTaxCertificateDataSource2016.queryCompanyTaxOffice(oidPCompany, this.mForEffectiveDate, this.mForValidDate);
                        }
                        String taxOfficeNumber = this.getTaxOfficeTP(oidTaxOffice, this.mForValidDate).getTaxOffice().getTaxOffice();
                        eWT.setEmployeeShortDescSocialInsuranceLaw(WageTaxCertificateDataSource2016.getEmployeeShortDescSocialInsuranceLawByTaxOfficeNumber(taxOfficeNumber));
                    }
                    Date employeeStartDateTemp = DateHelper.max((Date)firstDate, (Date)period.from);
                    eWT.setOidEmployee(oidEmployee);
                    eWT.setOidPCompany(oidPCompany);
                    eWT.setOidPlant(oidPlant);
                    eWT.setDateOfEntery(efr.getDateOfEntry());
                    eWT.setEmployeeStartDate(employeeStartDateTemp);
                    eWT.setEmployeeEndDate(currentEmployeeEndDateTemp);
                    eWT.setSortiermerkmal(this.getPerfidiaSortiermerkmal(efr));
                    eWT.setShouldStorno(isRelevant == false);
                    employeeWageTaxCertificateBeanCollection.add(eWT);
                }
            }
        }
        if (!employeeNoTaxData.isEmpty() && !this.mIsForCarriedForward) {
            messages = new String[employeeNoTaxData.size()];
            employeeNoTaxData.toArray(messages);
            de = ReportExceptionMapper.makeNoTaxData((String[])messages);
            LOGGER.debug(ExceptionMapper.toString((Throwable)de));
            if (this.mCallback != null) {
                this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
            } else {
                throw de;
            }
        }
        if (!employeesNotJournalized.isEmpty()) {
            messages = new String[employeesNotJournalized.size()];
            employeesNotJournalized.toArray(messages);
            de = ReportExceptionMapper.makeEmployeeNotJournalized((String[])messages);
            LOGGER.debug(ExceptionMapper.toString((Throwable)de));
            if (this.mCallback != null) {
                this.mCallback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
            } else {
                throw de;
            }
        }
        if ((ewtcbs = employeeWageTaxCertificateBeanCollection.getSortedList()).isEmpty() && !this.mIsForCarriedForward) {
            throw WTCExceptionMapper.makeNoLStBsToCreateException();
        }
        this.mCountEmployeeWageTaxEFRit = ewtcbs.size();
        this.mEmployeeWageTaxEFRit = ewtcbs.iterator();
        if (this.mProgressBar != null) {
            this.mProgressBar.setTotal(ewtcbs.size());
        }
    }

    private boolean isSuccessorGfB(Employee successor, Date validDate) throws BusinessDomainException {
        Tax tax;
        if (validDate != null && (tax = successor.getTaxOrNull(this.mForEffectiveDate, DateHelper.tomorrow((Date)validDate))) != null) {
            return WageTaxCertificateHelper.isGfB((TaxacationEnum)tax.getTaxacation());
        }
        return false;
    }

    private String getPerfidiaSortiermerkmal(EmployeeForReport efr) {
        if (this.mSort != null) {
            switch (this.mSort.criteria.value()) {
                case 0: {
                    return this.mSort.key ? efr.getPCompanyKey() : efr.getPCompanyDescription();
                }
                case 1: {
                    return this.mSort.key ? efr.getPersonnelNumber() : efr.getSurname() + ", " + efr.getFirstname();
                }
                case 2: {
                    return this.mSort.key ? efr.getPlantKey() : efr.getPlantDescription();
                }
                case 3: {
                    return this.mSort.key ? efr.getEmployeeCircleKey() : efr.getEmployeeCircleDescription();
                }
                case 4: {
                    return this.mSort.key ? efr.getEmployeeGroupKey() : efr.getEmployeeGroupDescription();
                }
                case 5: {
                    return this.mSort.key ? efr.getEmployeeFunctionKey() : efr.getEmployeeFunctionDescription();
                }
                case 6: {
                    return this.mSort.key ? efr.getCostCenterKey() : efr.getCostCenterDescription();
                }
                case 7: {
                    return this.mSort.key ? efr.getCostUnitKey() : efr.getCostUnitDescription();
                }
                case 8: {
                    return this.mSort.key ? efr.getDepartmentKey() : efr.getDepartmentDescription();
                }
                case 9: {
                    return this.mSort.key ? efr.getOrgUnitKey() : efr.getOrgUnitDescription();
                }
                case 10: {
                    return this.mSort.key ? efr.getPersonInCharge1Key() : efr.getPersonInCharge1Description();
                }
                case 11: {
                    return this.mSort.key ? efr.getPersonInCharge2Key() : efr.getPersonInCharge2Description();
                }
            }
        }
        return "";
    }

    private static Collection<String> getOidEmployees(Collection<EmployeeForReport> employeesForReport) {
        HashSet<String> oidEmployees = new HashSet<String>();
        for (EmployeeForReport employeeForReport : employeesForReport) {
            oidEmployees.add(employeeForReport.getOidEmployee());
        }
        return oidEmployees;
    }

    private static Collection<String> getOidPCompanys(Collection<EmployeeForReport> employeesForReport) {
        HashSet<String> oidPCompanys = new HashSet<String>();
        for (EmployeeForReport employeeForReport : employeesForReport) {
            oidPCompanys.add(employeeForReport.getOidPCompany());
        }
        return oidPCompanys;
    }

    private static Collection<String> getOidPlants(Collection<EmployeeForReport> employeesForReport) {
        HashSet<String> oidPlants = new HashSet<String>();
        for (EmployeeForReport employeeForReport : employeesForReport) {
            String oidPlant = employeeForReport.getOidPlant();
            if (StringMapper.isNullString((String)oidPlant)) continue;
            oidPlants.add(oidPlant);
        }
        return oidPlants;
    }

    private static int getYear(Date date) {
        return new VDate(date).getYear();
    }

    private static int getMonth(Date date) {
        return new VDate(date).getMonth();
    }

    private static boolean isDecember(Date date) {
        return WageTaxCertificateDataSource2016.getMonth(date) == 11;
    }

    private void getPlantTax(EmployeeWageTaxCertificateBean eWT, Date validDate, String oidPlant) {
        List<PlanttaofficeallContainer> listePlanttaofficeall = this.mPlanttaofficeallMap.get(oidPlant);
        if (listePlanttaofficeall != null) {
            for (PlanttaofficeallContainer planttaofficeall : listePlanttaofficeall) {
                if (!DateHelper.between((Date)validDate, (Date)planttaofficeall.validfrom, (Date)planttaofficeall.validuntil)) continue;
                eWT.setPlanttaofficeallContainer(planttaofficeall);
                eWT.setPlantTaxNumber(planttaofficeall.taxnumber);
                eWT.setLicense(planttaofficeall.license);
                return;
            }
        }
    }

    private Map<Boolean, List<Period>> getPeriodMap(List<TaxContainer> taxContainers, Period period) {
        HashMap<Boolean, List<Period>> result = new HashMap<Boolean, List<Period>>();
        result.put(false, new ArrayList());
        result.put(true, new ArrayList());
        for (TaxContainer taxContainer : taxContainers) {
            if (!DateHelper.beforeOrEqual((Date)taxContainer.validfrom, (Date)period.until) || !DateHelper.afterOrEqual((Date)taxContainer.validuntil, (Date)period.from)) continue;
            Period taxPeriod = new Period(DateHelper.max((Date)period.from, (Date)taxContainer.validfrom), DateHelper.min((Date)period.until, (Date)taxContainer.validuntil));
            boolean relevant = this.isRelevantTax(taxContainer, period.from, period.until);
            List periods = (List)result.get(relevant);
            if (periods.isEmpty()) {
                periods.add(taxPeriod);
                continue;
            }
            int lastIndex = periods.size() - 1;
            Period lastPeriod = (Period)periods.get(lastIndex);
            if (DateHelper.equal((Date)DateHelper.tomorrow((Date)lastPeriod.until), (Date)taxPeriod.from)) {
                Period newPeriod = new Period(lastPeriod.from, DateHelper.min((Date)period.until, (Date)taxContainer.validuntil));
                periods.set(lastIndex, newPeriod);
                continue;
            }
            periods.add(taxPeriod);
        }
        return result;
    }

    private List<TaxContainer> filterRelevantTax(List<TaxContainer> taxes, Date employeeStartDate, Date employeeEndDate) {
        ArrayList<TaxContainer> result = new ArrayList<TaxContainer>();
        for (TaxContainer taxContainer : taxes) {
            if (!DateHelper.beforeOrEqual((Date)taxContainer.validfrom, (Date)employeeEndDate) || !DateHelper.afterOrEqual((Date)taxContainer.validuntil, (Date)employeeStartDate) || !this.isRelevantTax(taxContainer, employeeStartDate, employeeEndDate)) continue;
            result.add(taxContainer);
        }
        return result;
    }

    private List<InsuranceallContainer> filterRelevantInsurance(List<InsuranceallContainer> insurances, Date employeeStartDate, Date employeeEndDate) {
        ArrayList<InsuranceallContainer> result = new ArrayList<InsuranceallContainer>();
        for (InsuranceallContainer insuranceContainer : insurances) {
            if (!DateHelper.beforeOrEqual((Date)insuranceContainer.validfrom, (Date)employeeEndDate) || !DateHelper.afterOrEqual((Date)insuranceContainer.validuntil, (Date)employeeStartDate) || !this.isRelevantInsurance(insuranceContainer, employeeStartDate, employeeEndDate)) continue;
            result.add(insuranceContainer);
        }
        return result;
    }

    protected abstract boolean isRelevantTax(TaxContainer var1, Date var2, Date var3);

    protected abstract boolean isRelevantInsurance(InsuranceallContainer var1, Date var2, Date var3);

    protected boolean isSteuerfreiAndDBAOrATE(TaxContainer taxContainer, Date employeeStartDate, Date employeeEndDate) {
        if (taxContainer.taxacation == 1 || taxContainer.taxacation == 13) {
            List valuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)taxContainer.oidemployee, (String[])VALUETYPENUMBERS_DBA_AND_ATE, (Date)this.mForEffectiveDate, (Date)employeeStartDate, (Date)employeeEndDate);
            BigDecimal valueposition103510 = BigDecimal.ZERO;
            BigDecimal valueposition103520 = BigDecimal.ZERO;
            for (ValuepositionContainer valuepositionContainer : valuePositionli) {
                if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)employeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)employeeStartDate)) continue;
                Date beginDate = DateHelper.max((Date)valuepositionContainer.validfrom, (Date)employeeStartDate);
                Date endDate = DateHelper.getLastDayOfMonth((Date)DateHelper.min((Date)valuepositionContainer.validuntil, (Date)employeeEndDate));
                BigDecimal result = valuepositionContainer.results.multiply(new BigDecimal(WageTaxCertificateDataSource2016.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
                switch (valuepositionContainer.valuetypenumber) {
                    case 103510: {
                        valueposition103510 = valueposition103510.add(result);
                        break;
                    }
                    case 103520: {
                        valueposition103520 = valueposition103520.add(result);
                    }
                }
            }
            if (BigDecimalMapper.isZero((BigDecimal)valueposition103510) || BigDecimalMapper.isZero((BigDecimal)valueposition103520)) {
                return true;
            }
        }
        return false;
    }

    private static EmployeeForReport getEmployeeForReportWithValidFromDate(List<EmployeeForReport> employeeForReports, Date neededValidFromDate) {
        for (EmployeeForReport eFR : employeeForReports) {
            if (!DateHelper.equal((Date)eFR.getEmploymentValidFrom(), (Date)neededValidFromDate)) continue;
            return eFR;
        }
        return null;
    }

    private static boolean equalOldNewEmployeeForReport(EmployeeForReport oldEFR, EmployeeForReport newEFR) {
        if (oldEFR == null || newEFR == null) {
            return false;
        }
        if (oldEFR.getDateOfWithDrawal() != null && newEFR.getDateOfWithDrawal() != null && !DateHelper.equal((Date)oldEFR.getDateOfWithDrawal(), (Date)newEFR.getDateOfWithDrawal()) && !DateHelper.equal((Date)oldEFR.getEmploymentEffectiveFrom(), (Date)newEFR.getEmploymentEffectiveFrom())) {
            return false;
        }
        return oldEFR.getDateOfWithDrawal() == null || !DateHelper.beforeOrEqual((Date)oldEFR.getDateOfWithDrawal(), (Date)oldEFR.getEmploymentValidUntil()) || newEFR.getDateOfWithDrawal() != null;
    }

    private void setEmployeeProperties(EmployeeWageTaxCertificateBean eWT) throws BusinessDomainException {
        EmploymentallContainer employment;
        InsuranceallContainer insurance;
        ComptaxofficeallContainer comptaxoffice;
        String oidEmployee = eWT.getOidEmployee();
        Date employeeEndDate = eWT.getEmployeeEndDate();
        PlantfoundationsContainer plantFoundations = this.getPlantFoundations(eWT.getOidPlant(), employeeEndDate);
        if (plantFoundations != null) {
            eWT.setPlantfoundationsContainer(plantFoundations);
        }
        if ((comptaxoffice = this.getComptaxofficeall(eWT.getOidPCompany(), employeeEndDate)) != null) {
            eWT.setComptaxofficeallContainer(comptaxoffice);
            eWT.setPCompanyTaxNumber(comptaxoffice.taxnumber);
        }
        if ((insurance = this.getInsurance(oidEmployee, this.mActualDate)) != null) {
            eWT.setInsuranceallContainer(insurance);
        }
        if ((employment = this.getEmployment(oidEmployee, employeeEndDate)) != null) {
            eWT.setEmploymentallContainer(employment);
        }
    }

    private boolean isVersicherungsfreierAltersvollrentner(String oidEmployee, Date validDate) {
        InsuranceallContainer insurance = DateHelper.afterOrEqual((Date)validDate, (Date)this.mListFirstDate) ? this.getInsurance(oidEmployee, validDate) : this.getRCInsurance(oidEmployee, validDate);
        return insurance != null && (insurance.persongroup == 119 || insurance.duesgrouppi == 5 && insurance.typeofpension == 4);
    }

    private InsuranceallContainer getInsurance(String oidEmployee, Date validDate) {
        List<InsuranceallContainer> listeInsurance = this.mInsuranceAllMap.get(oidEmployee);
        if (listeInsurance != null) {
            for (InsuranceallContainer insurance : listeInsurance) {
                if (!DateHelper.between((Date)validDate, (Date)insurance.validfrom, (Date)insurance.validuntil)) continue;
                return insurance;
            }
        }
        return null;
    }

    private InsuranceallContainer getRCInsurance(String oidEmployee, Date validDate) {
        List<InsuranceallContainer> listeInsurance = this.mRCInsuranceAllMap.get(oidEmployee);
        if (listeInsurance != null) {
            for (InsuranceallContainer insurance : listeInsurance) {
                if (!DateHelper.between((Date)validDate, (Date)insurance.validfrom, (Date)insurance.validuntil)) continue;
                return insurance;
            }
        }
        return null;
    }

    private EmploymentallContainer getEmployment(String oidEmployee, Date validDate) {
        List<EmploymentallContainer> listeEmploymentAll = this.mEmploymentAllMap.get(oidEmployee);
        if (listeEmploymentAll != null) {
            for (EmploymentallContainer employment : listeEmploymentAll) {
                if (!DateHelper.between((Date)validDate, (Date)employment.validfrom, (Date)employment.validuntil)) continue;
                return employment;
            }
        }
        return null;
    }

    private ComptaxofficeallContainer getComptaxofficeall(String oidPCompany, Date validDate) {
        List<ComptaxofficeallContainer> listeComptaoffice = this.mComptaxofficeallMap.get(oidPCompany);
        if (listeComptaoffice != null) {
            for (ComptaxofficeallContainer comptaxoffice : listeComptaoffice) {
                if (!DateHelper.between((Date)validDate, (Date)comptaxoffice.validfrom, (Date)comptaxoffice.validuntil)) continue;
                return comptaxoffice;
            }
        }
        return null;
    }

    private PlantfoundationsContainer getPlantFoundations(String oidPlant, Date validDate) {
        List<PlantfoundationsContainer> listePlantFoundations;
        if (!StringMapper.isNullString((String)oidPlant) && (listePlantFoundations = this.mPlantfoundationsMap.get(oidPlant)) != null) {
            for (PlantfoundationsContainer plantFoundations : listePlantFoundations) {
                if (!DateHelper.between((Date)validDate, (Date)plantFoundations.validfrom, (Date)plantFoundations.validuntil)) continue;
                return plantFoundations;
            }
        }
        return null;
    }

    protected void getTaxValuesSubreport(List<TaxContainer> taxContainers, List<WageTaxCertificateInsuranceSubBean> insuranceSubBeans, Date employeeBeginDate, Date employeeEndDate) throws BusinessDomainException {
        this.mSubReport.add(taxContainers, insuranceSubBeans, employeeBeginDate, employeeEndDate, this.mForValidDate, this.mVorjahr, this.mListFirstDate, this.mLStBMonate);
    }

    protected void getDataFor(EmployeeWageTaxCertificateBean eWT) throws BusinessDomainException, PutDataException {
        BigDecimal steuerfreiesEntgelt;
        BigDecimal steuerpflichtigesEntgelt;
        BigDecimal gesamtesEntgelt;
        String oidEmployee = WageTaxCertificateDataSource2016.toString(eWT.getOidEmployee());
        String oidPlant = WageTaxCertificateDataSource2016.toString(eWT.getOidPlant());
        String oidPCompany = this.mIsSuperiorForConsolidation ? this.mPCompany.getObjectid() : WageTaxCertificateDataSource2016.toString(eWT.getOidPCompany());
        this.mCurrentOidPlant = this.mIsSuperiorForConsolidation ? "" : oidPlant;
        Date employeeStartDate = eWT.getEmployeeStartDate();
        Date employeeEndDate = eWT.getEmployeeEndDate();
        Employee employee = this.mReportValues.getEmployee(oidEmployee);
        this.setEmployeeProperties(eWT);
        Master master = this.getMaster(employee);
        if (this.mProgressBar != null) {
            this.mProgressBar.update(employee.getPersonnelnumber() + " / " + master.getSurname() + ", " + master.getFirstname());
        }
        Foundations foundation = !StringMapper.isNullString((String)oidPlant) ? this.mReportValues.getPlant(oidPlant).getPlantFoundations(this.mForEffectiveDate, this.mForValidDate).getFoundations() : this.mReportValues.getPCompany(eWT.getOidPCompany()).getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate).getFoundations();
        this.mEmployerFederalStateKey = foundation.getFederalState().getFederalState();
        this.mPlantTaxNumber = StringMapper.equal((String)eWT.getLicense(), (String)"AK") ? "" : WageTaxCertificateDataSource2016.toString(eWT.getPlantTaxNumber());
        ComptaxofficeallContainer comptaxofficeallContainer = eWT.getComptaxofficeallContainer();
        EmploymentallContainer employmentallContainer = eWT.getEmploymentallContainer();
        if (employmentallContainer == null || master == null || comptaxofficeallContainer == null) {
            LOGGER.error("Could not get required value from {}", (Object)eWT);
        }
        this.mPlantKey = "";
        EmployerBean employerBean = (EmployerBean)UtilitiesManager.getBean((String)"employerBean", EmployerBean.class);
        employerBean.setOidEmployee(oidEmployee);
        employerBean.setOidPCompany(oidPCompany);
        employerBean.setOidPlant(this.mCurrentOidPlant);
        employerBean.setEffectiveDate(this.mForEffectiveDate);
        employerBean.setValidDate(this.mListEndDate);
        if (this.mIsSuperiorForConsolidation) {
            employerBean.setOidPCompanyForFoundations(this.mPCompanyForFoundations.getObjectid());
            employerBean.setOidPCompanyForSettings(this.mPCompanyForSettings.getObjectid());
        }
        employerBean.createEmployerBeanWithoutPlantPlace();
        if (StringMapper.isNullString((String)this.mPlantTaxNumber)) {
            String oidTaxOffice;
            this.mEmployerWageTaxOfficeDescription = "";
            this.mWageTaxOfficeNumber = "";
            this.mEmployerDescription = employerBean.getCompanyLongDescription();
            this.mEmployerStreetStreetNumber = employerBean.getCompanyStreet();
            this.mEmployerPostalCode = employerBean.getCompanyPostalcode();
            this.mEmployerCity = employerBean.getCompanyCity();
            this.mEmployerStateTag = this.getStateTag(this.mCompanyFoundations.getState());
            this.mEmployerStateDescription = employerBean.getCompanyFederalstateLongdescription();
            if (comptaxofficeallContainer != null && !StringMapper.isNullString((String)(oidTaxOffice = comptaxofficeallContainer.oidtaxoffice))) {
                TaxOfficeTP taxOfficeTP = this.getTaxOfficeTP(oidTaxOffice, comptaxofficeallContainer.validfrom);
                this.mEmployerWageTaxOfficeDescription = taxOfficeTP.getLongDescription();
                this.mWageTaxOfficeNumber = taxOfficeTP.getTaxOffice().getTaxOffice();
            }
            this.mEmployerTaxNumber = WageTaxCertificateDataSource2016.toString(eWT.getPCompanyTaxNumber());
            int bundesland = StringMapper.isNullString((String)this.mWageTaxOfficeNumber) ? 0 : Integer.parseInt(this.mWageTaxOfficeNumber.substring(0, 2));
            String employerTaxNumber = ReportDataTransfer.getEmployerPartElsterTaxNumber((String)this.mEmployerTaxNumber, (int)bundesland);
            this.mElsterEmployerNumber = this.mWageTaxOfficeNumber + "0" + employerTaxNumber;
        } else {
            PlanttaofficeallContainer planttaofficeallContainer = eWT.getPlanttaofficeallContainer();
            String string = this.mPlantKey = StringMapper.isNullString((String)planttaofficeallContainer.plantkey) ? "" : planttaofficeallContainer.plantkey + " / ";
            if (!StringMapper.equal((String)oidPlant, (String)this.mCurrentOidPlantTemp)) {
                PlantfoundationsContainer plantfoundationsContainer = eWT.getPlantfoundationsContainer();
                Plant plant = this.mReportValues.getPlant(plantfoundationsContainer.oidplant);
                Foundations foundations = plant.getPlantFoundations(this.mForEffectiveDate, this.mListEndDate).getFoundations();
                this.mEmployerDescription = mWageTaxCertificateHelper.getPlantDescription(employerBean);
                this.mEmployerStreetStreetNumber = mWageTaxCertificateHelper.getPlantStreetStreetNumber(employerBean);
                this.mEmployerPostalCode = mWageTaxCertificateHelper.getPlantPostalCode(employerBean);
                this.mEmployerCity = mWageTaxCertificateHelper.getPlantCity(employerBean);
                this.mEmployerTaxNumber = WageTaxCertificateDataSource2016.toString(this.mPlantTaxNumber);
                TaxOfficeTP taxOfficeTP = StringMapper.isNullString((String)planttaofficeallContainer.oidtaxoffice) ? null : this.getTaxOfficeTP(planttaofficeallContainer.oidtaxoffice, planttaofficeallContainer.validfrom);
                this.mEmployerWageTaxOfficeDescription = taxOfficeTP == null ? "" : taxOfficeTP.getLongDescription();
                this.mWageTaxOfficeNumber = taxOfficeTP == null ? "" : taxOfficeTP.getTaxOffice().getTaxOffice();
                int bundesland = StringMapper.isNullString((String)this.mWageTaxOfficeNumber) ? 0 : Integer.parseInt(this.mWageTaxOfficeNumber.substring(0, 2));
                String employerTaxNumber = ReportDataTransfer.getEmployerPartElsterTaxNumber((String)this.mEmployerTaxNumber, (int)bundesland);
                this.mElsterEmployerNumber = this.mWageTaxOfficeNumber + "0" + employerTaxNumber;
                this.mEmployerStateTag = this.getStateTag(foundations.getState());
                this.mEmployerStateDescription = StringMapper.isNullString((String)plantfoundationsContainer.oidfederalstate) ? "" : FederalStatePersistencyManager.getFederalState((String)plantfoundationsContainer.oidfederalstate).getFederalStateTP(this.mForEffectiveDate, this.mListEndDate).getLongDescription();
            }
        }
        this.resetDataEmployee();
        this.mEmployeeAdressAddition1 = eWT.getEmployeeForReport().getAnschriftenZusatzKurz1();
        this.mEmployeeAdressAddition2 = eWT.getEmployeeForReport().getAnschriftenZusatzKurz2();
        this.mEmployeeAdressAddition3 = eWT.getEmployeeForReport().getAnschriftenZusatzKurz3();
        this.mEmployeeShortDescSocialInsuranceLaw = eWT.getEmployeeShortDescSocialInsuranceLaw();
        Date myBeginnDate = new Date();
        this.mSortiermerkmal = eWT.getSortiermerkmal();
        if (master != null) {
            this.mEmployeeTitle = WageTaxCertificateDataSource2016.toString(master.getTitle());
            this.mEmployeeNameAffix = WageTaxCertificateDataSource2016.toString(master.getNameAffix());
            this.mEmployeeNamePrefix = WageTaxCertificateDataSource2016.toString(master.getNamePrefix());
            this.mEmployeeSex = SexEnumMapper.toUpperCaseLetter((SexEnum)master.getSex());
            this.mEmployeeName = WageTaxCertificateDataSource2016.toString(master.getSurname());
            this.mEmployeeFirstName = WageTaxCertificateDataSource2016.toString(master.getFirstname());
            this.mEmployeeDomicilStreet = WageTaxCertificateDataSource2016.toString(master.getStreet());
            this.mEmployeeDomicilStreetNumber = WageTaxCertificateDataSource2016.toString(master.getStreetNumber());
            this.mEmployeeDomicilPostalCode = WageTaxCertificateDataSource2016.toString(master.getPostalCode());
            this.mEmployeeDomicilStateTag = this.getStateTag(master.getState());
            String domicile = master.getDomicile();
            this.mEmployeeDomicile = StringMapper.isNullString((String)domicile) ? "" : ("D".equals(this.mEmployeeDomicilStateTag) ? domicile : domicile.toUpperCase());
            this.mEmployeeAdressAddendum = WageTaxCertificateDataSource2016.toString(master.getAddressAddendum());
            this.mEmployeePersonnelNumber = employee.getPersonnelnumber();
            this.mEmployeePersonnelNumberForPrint = this.mIsSuperiorForConsolidation ? employee.getPCompany().getPCompanyKey() + "/" + Integer.toString(this.mEmployeePersonnelNumber) : Integer.toString(this.mEmployeePersonnelNumber);
            this.mEmployeeDateOfBirth = master.getDateOfBirth();
            this.mEmployeeDateOfBirthELSTAM = master.getDateOfBirthELSTAM();
            myBeginnDate = DateHelper.max((Date)eWT.getDateOfEntery(), (Date)employeeStartDate);
            this.mEmployeeETIN = this.getETIN(employee, myBeginnDate);
        }
        this.mAddressFieldBeans = Arrays.asList(this.mAddressFieldCreator.createAddressFieldBean(employee));
        Date endOfEmployment = employmentallContainer == null || employmentallContainer.dateofwithdrawal == null ? employeeEndDate : employmentallContainer.dateofwithdrawal;
        Date myEndDate = employeeEndDate;
        if (DateHelper.after((Date)endOfEmployment, (Date)myBeginnDate)) {
            myEndDate = DateHelper.min((Date)endOfEmployment, (Date)employeeEndDate);
        }
        this.mVorjahr = DateHelper.before((Date)myEndDate, (Date)this.mListFirstDate);
        if (this.mVorjahr) {
            myBeginnDate = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
            myEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        }
        this.mEmploymentStartDate = myBeginnDate;
        this.mEmploymentEndDate = myEndDate;
        Tax eETax = employee.getTaxOrNull(VDate.getDateMax(), myEndDate);
        if (eETax != null) {
            this.mEmployeeIDENT = eETax.getTin();
        }
        if ((eETax = employee.getTaxOrNull(this.mForEffectiveDate, myEndDate)) != null) {
            TaxOffice taxOffice;
            if (eETax.getCrossBorderEmployeeFrance() && this.mYearInt >= 2017) {
                this.mCapitalLetters.setFR(this.mEmployerFederalStateKey);
            }
            if ((taxOffice = eETax.getTaxOffice()) != null) {
                this.mEmployeeWageTaxOfficeNumber = taxOffice.getTaxOffice();
                this.mEmployeeWageTaxOfficeDescription = taxOffice.getTaxOfficeTP(this.mForEffectiveDate, myEndDate).getLongDescription();
            }
        }
        Date startDate = myBeginnDate;
        while (DateHelper.beforeOrEqual((Date)startDate, (Date)myEndDate)) {
            Date endDate = DateHelper.min((Date)DateHelper.getLastDayOfMonth((Date)startDate), (Date)myEndDate);
            List valuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)eWT.getOidEmployee(), (String[])VALUETYPENUMBERS, (Date)this.mForEffectiveDate, (Date)startDate, (Date)endDate);
            this.mValueTypeNumber220400 = false;
            for (Object valuepositionContainer : valuePositionli) {
                if (((ValuepositionContainer)valuepositionContainer).valuetypenumber != 220400) continue;
                this.mValueTypeNumber220400 = true;
                break;
            }
            if (DateHelper.before((Date)myBeginnDate, (Date)new VDate(2020, 0, 1).getDate())) {
                Object stpflEntgelt = BigDecimal.ZERO;
                this.mHasDBAorATE = false;
                this.mDbaOrAteVPList.clear();
                for (Object valuepositionContainer : valuePositionli) {
                    switch (((ValuepositionContainer)valuepositionContainer).valuetypenumber) {
                        case 103510: 
                        case 103520: {
                            this.mHasDBAorATE = true;
                            this.mDbaOrAteVPList.add(((ValuepositionContainer)valuepositionContainer).oidgenesisparent);
                            break;
                        }
                        case 110510: 
                        case 110610: 
                        case 110630: {
                            stpflEntgelt = ((BigDecimal)stpflEntgelt).add(((ValuepositionContainer)valuepositionContainer).results);
                        }
                    }
                }
                if (this.mHasDBAorATE && BigDecimalMapper.isZero((BigDecimal)stpflEntgelt)) {
                    this.mHasNurDBAorATE = true;
                }
            }
            for (Object valuepositionContainer : valuePositionli) {
                this.getValuesFromValuePositionData(startDate, endDate, (ValuepositionContainer)valuepositionContainer);
            }
            this.calculate23b(valuePositionli, new Period(startDate, endDate), true);
            if (this.mYearInt < 2025) {
                this.getValuesFromVPDataForErmaessigtSBZ(eWT.getOidEmployee(), startDate, endDate);
            }
            this.FIELD_ErmStBetrMKalJahr = this.FIELD_ErmStBetrMKalJahr.compareTo(this.FIELD_StBegVBezMKalJahr) > 0 ? this.FIELD_ErmStBetrMKalJahr.subtract(this.FIELD_StBegVBezMKalJahr) : ZERO2;
            startDate = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)startDate));
        }
        if (DateHelper.after((Date)this.mForValidDate, (Date)eWT.getEmployeeEndDate())) {
            String[] valueTypeNumbers = new String[]{"110630", "220630", "223630", "226630", "227630"};
            startDate = DateHelper.tomorrow((Date)myEndDate);
            Date tempEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
            while (DateHelper.beforeOrEqual((Date)startDate, (Date)tempEndDate)) {
                Date endDate = DateHelper.getLastDayOfMonth((Date)startDate);
                List valuePositionli = ReportEmployeesHandlingHelper.getValuePositionsLi((String)eWT.getOidEmployee(), (String[])valueTypeNumbers, (Date)this.mForEffectiveDate, (Date)startDate, (Date)endDate);
                for (ValuepositionContainer valuepositionContainer : valuePositionli) {
                    this.getValuesFromValuePositionData(startDate, endDate, valuepositionContainer);
                }
                startDate = DateHelper.tomorrow((Date)endDate);
            }
        }
        this.mLStBMonate = new LStBMonate();
        if (this.mValuePositionsMKFJLi != null && !this.mValuePositionsMKFJLi.isEmpty()) {
            for (ValuepositionContainer vPContainer : this.mValuePositionsMKFJLi) {
                this.getValuesFromValuePositionDataMaerzKlausel(vPContainer);
            }
            this.mValuePositionsMKFJLi = null;
        }
        if (this.mValuePositionsMKFJSWLi != null && !this.mValuePositionsMKFJSWLi.isEmpty()) {
            for (ValuepositionContainer vPContainer : this.mValuePositionsMKFJSWLi) {
                this.getValuesFromValuePositionDataMaerzKlausel(vPContainer);
            }
            this.mValuePositionsMKFJSWLi = null;
        }
        if (DateHelper.afterOrEqual((Date)myBeginnDate, (Date)new VDate(2020, 0, 1).getDate()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)(gesamtesEntgelt = (steuerpflichtigesEntgelt = this.FIELD_z_3_arbeitslohn_brutto.subtract(this.FIELD_StBegVBez)).add(steuerfreiesEntgelt = this.FIELD_StFreiArbLohnDBA.add(this.FIELD_StFreiArbLohnATE))))) {
            BigDecimal faktorSteuerpflichtig = steuerpflichtigesEntgelt.divide(gesamtesEntgelt, 2, RoundingMode.HALF_UP);
            this.FIELD_AGAGesRV = this.FIELD_AGAGesRV.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_AGABerufVersorg = this.FIELD_AGABerufVersorg.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_ANAGesRV = this.FIELD_ANAGesRV.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_AV_ANA = this.FIELD_AV_ANA.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_KV_ANA = this.FIELD_KV_ANA.subtract(this.mKVFreiwBeitrag);
            this.FIELD_KV_ANA = this.FIELD_KV_ANA.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(this.mKVFreiwBeitrag);
            this.FIELD_PV_ANA = this.FIELD_PV_ANA.subtract(this.mPVFreiwBeitrag);
            this.FIELD_PV_ANA = this.FIELD_PV_ANA.multiply(faktorSteuerpflichtig).setScale(2, RoundingMode.HALF_UP);
            this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(this.mPVFreiwBeitrag);
        }
        this.calculateSVRueckrechnungDifferenzen(eWT);
        if (!this.mIsForCarriedForward) {
            boolean generateEECarriedForwardOfEntry = false;
            Date eeCarriedForwardOfEntryDate = this.mCalculationStartDate;
            if (DateHelper.before((Date)eWT.getDateOfEntery(), (Date)this.mCalculationStartDate)) {
                generateEECarriedForwardOfEntry = true;
            }
            if (employee.getPredecessor() != null) {
                generateEECarriedForwardOfEntry = true;
                eeCarriedForwardOfEntryDate = DateHelper.getFirstDayOfYear((Date)this.mForValidDate);
            }
            if (generateEECarriedForwardOfEntry) {
                this.generateEECarriedForwardOfEntry(eWT, myBeginnDate, eeCarriedForwardOfEntryDate);
            }
        }
        List<TaxContainer> listeTax = this.mTaxMap.get(oidEmployee);
        List<WageTaxCertificateInsuranceSubBean> insuranceSubBeans = this.createWageTaxCertificateInsuranceSubBeanList(employee, myBeginnDate, myEndDate);
        if (listeTax != null && insuranceSubBeans != null) {
            this.getTaxValues(this.filterRelevantTax(listeTax, myBeginnDate, myEndDate), insuranceSubBeans, myBeginnDate, myEndDate);
        }
        for (StatisticalValueTP statisticalValueTP : this.mStatisticalValueTPs) {
            BigDecimal[] statisticalValues = statisticalValueTP.calculateStatisticalValue(oidEmployee, this.mForEffectiveDate, this.mListFirstDate, this.mListEndDate);
            this.mStatisticalValues.add(statisticalValues[1]);
        }
        this.createZusatzzeilen();
        this.checkBeitragspflichtigAusSteuerfreienBezuegen();
    }

    private List<WageTaxCertificateInsuranceSubBean> createWageTaxCertificateInsuranceSubBeanList(Employee employee, Date myBeginnDate, Date myEndDate) {
        LinkedList<WageTaxCertificateInsuranceSubBean> wageTaxCertificateInsuranceSubBeanList = new LinkedList<WageTaxCertificateInsuranceSubBean>();
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            if (DateHelper.before((Date)myBeginnDate, (Date)new VDate(2026, 0, 1).getDate())) {
                List<InsuranceallContainer> listeInsurance = this.filterRelevantInsurance(this.mInsuranceAllMap.get(employee.getObjectid()), myBeginnDate, myEndDate);
                for (InsuranceallContainer insuranceContainer : listeInsurance) {
                    wageTaxCertificateInsuranceSubBeanList.add(new WageTaxCertificateInsuranceSubBean(insuranceContainer.oidemployee, insuranceContainer.validfrom, insuranceContainer.validuntil, insuranceContainer.totalratetophi, insuranceContainer.baseratephi, insuranceContainer.totalratetopni, BigDecimal.ZERO));
                }
            } else {
                Date searchDate = myBeginnDate;
                while (DateHelper.beforeOrEqual((Date)searchDate, (Date)myEndDate)) {
                    Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)searchDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)searchDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)searchDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)searchDate))), Restrictions.eq((String)"oidemployee", (String)employee.getObjectid())});
                    InsuranceHIPIYearTP[] insuranceHIPIYearTPs = InsuranceHIPIYearTPPersistencyManager.queryAll(null, (Criterion)filter, (boolean)true);
                    if (insuranceHIPIYearTPs != null && insuranceHIPIYearTPs.length > 0) {
                        for (InsuranceHIPIYearTP insuranceHIPIYearTP : insuranceHIPIYearTPs) {
                            if (!this.isPKV(employee.getObjectid(), insuranceHIPIYearTP.getValidFrom(), insuranceHIPIYearTP.getValidUntil())) continue;
                            wageTaxCertificateInsuranceSubBeanList.add(new WageTaxCertificateInsuranceSubBean(employee.getObjectid(), insuranceHIPIYearTP.getValidFrom(), insuranceHIPIYearTP.getValidUntil(), insuranceHIPIYearTP.getTotalRateToPHI(), insuranceHIPIYearTP.getBaseRatePHI(), insuranceHIPIYearTP.getTotalRateToPNI(), insuranceHIPIYearTP.getBaseRatePNI()));
                        }
                    } else {
                        List<InsuranceallContainer> listeInsurance = this.filterRelevantInsurance(this.mInsuranceAllMap.get(employee.getObjectid()), DateHelper.getFirstDayOfMonth((Date)searchDate), DateHelper.getLastDayOfMonth((Date)searchDate));
                        for (InsuranceallContainer insuranceContainer : listeInsurance) {
                            wageTaxCertificateInsuranceSubBeanList.add(new WageTaxCertificateInsuranceSubBean(insuranceContainer.oidemployee, insuranceContainer.validfrom, insuranceContainer.validuntil, insuranceContainer.totalratetophi, insuranceContainer.baseratephi, insuranceContainer.totalratetopni, BigDecimal.ZERO));
                        }
                    }
                    searchDate = DateHelper.addMonths((Date)searchDate, (int)1);
                }
            }
            if (wageTaxCertificateInsuranceSubBeanList.isEmpty()) {
                wageTaxCertificateInsuranceSubBeanList.add(new WageTaxCertificateInsuranceSubBean(employee.getObjectid(), myBeginnDate, myEndDate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
            }
        }
        return wageTaxCertificateInsuranceSubBeanList;
    }

    private boolean isPKV(String oidEmployee, Date validFrom, Date validUntil) {
        boolean isPKV = false;
        List<InsuranceallContainer> listeInsurance = this.filterRelevantInsurance(this.mInsuranceAllMap.get(oidEmployee), validFrom, validUntil);
        for (InsuranceallContainer insuranceContainer : listeInsurance) {
            if (!insuranceContainer.privatehi || !insuranceContainer.privateni) continue;
            isPKV = true;
        }
        return isPKV;
    }

    private String getETIN(Employee employee, Date validDate) throws BusinessDomainException {
        Master master = employee.getMaster(this.mForEffectiveDate, validDate);
        String etin = master.getEtinNumber();
        if ((!this.mInternalUse || this.mUsePerfidia) && StringMapper.isNullString((String)etin)) {
            String message = "Mitarbeiter: " + this.mEmployeeName + ", " + this.mEmployeeFirstName + "\nG\u00fcltig f\u00fcr " + DateMapper.toDDMMYYYYPointSeparationString((Date)validDate) + " aus Sicht " + DateMapper.toDDMMYYYYString((Date)this.mForEffectiveDate);
            throw WTCExceptionMapper.makeNoETINforEmployee((String)message);
        }
        return etin;
    }

    private void checkBeitragspflichtigAusSteuerfreienBezuegen() {
        if (this.mBeitragspflichtigZVKUmlageAGA.signum() == 1 && this.mSteuerfreiZVKUmlageAGA.signum() == 1) {
            BigDecimal basisbetragSVBerechnungZVKUmlage = this.mSteuerfreiZVKUmlageAGA.add(this.mPauschalsteuerpflichtigZVKUmlageAGA);
            BigDecimal svHinzurechnungsbetrag = this.mBeitragspflichtigZVKUmlageAGA.subtract(this.mSteuerpflichtigZVKUmlageAGA);
            BigDecimal anteilAusSteuerfrei = WageTaxCertificateDataSource2016.divideToPercentage(this.mSteuerfreiZVKUmlageAGA, basisbetragSVBerechnungZVKUmlage);
            BigDecimal beitragspflEntgeltAufSteuerfreiebBezug = WageTaxCertificateDataSource2016.multiplyPercentage(svHinzurechnungsbetrag, anteilAusSteuerfrei);
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mGesamtesKVEntgelt)) {
                BigDecimal anteilStFreiZVKAmKVEntgelt = WageTaxCertificateDataSource2016.divideToPercentage(beitragspflEntgeltAufSteuerfreiebBezug, this.mGesamtesKVEntgelt);
                this.FIELD_KV_ANA = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_KV_ANA, anteilStFreiZVKAmKVEntgelt);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mGesamtesRVEntgelt)) {
                BigDecimal anteilStFreiZVKAmRVEntgelt = WageTaxCertificateDataSource2016.divideToPercentage(beitragspflEntgeltAufSteuerfreiebBezug, this.mGesamtesRVEntgelt);
                this.FIELD_AGAGesRV = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_AGAGesRV, anteilStFreiZVKAmRVEntgelt);
                this.FIELD_ANAGesRV = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_ANAGesRV, anteilStFreiZVKAmRVEntgelt);
                this.FIELD_AGABerufVersorg = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_AGABerufVersorg, anteilStFreiZVKAmRVEntgelt);
                this.FIELD_ANABerufVersorg = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_ANABerufVersorg, anteilStFreiZVKAmRVEntgelt);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mGesamtesAVEntgelt)) {
                BigDecimal anteilStFreiZVKAmAVEntgelt = WageTaxCertificateDataSource2016.divideToPercentage(beitragspflEntgeltAufSteuerfreiebBezug, this.mGesamtesAVEntgelt);
                this.FIELD_AV_ANA = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_AV_ANA, anteilStFreiZVKAmAVEntgelt);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mGesamtesPVEntgelt)) {
                BigDecimal anteilStFreiZVKAmPVEntgelt = WageTaxCertificateDataSource2016.divideToPercentage(beitragspflEntgeltAufSteuerfreiebBezug, this.mGesamtesPVEntgelt);
                this.FIELD_PV_ANA = WageTaxCertificateDataSource2016.subtractPercentage(this.FIELD_PV_ANA, anteilStFreiZVKAmPVEntgelt);
            }
        }
    }

    private static BigDecimal divideToPercentage(BigDecimal value, BigDecimal divisor) {
        return value.multiply(EINHUNDERT).divide(divisor, 4, RoundingMode.HALF_UP);
    }

    private static BigDecimal multiplyPercentage(BigDecimal value, BigDecimal percentage) {
        return value.multiply(percentage).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
    }

    private static BigDecimal subtractPercentage(BigDecimal value, BigDecimal percentage) {
        return value.subtract(WageTaxCertificateDataSource2016.multiplyPercentage(value, percentage));
    }

    private void createZusatzzeilen() {
        this.addZusatzzeile("Kammerbeitrag Bremen", this.FIELD_Kammerbeitrag_Bremen);
        this.addZusatzzeile("Kammerbeitrag Saarland", this.FIELD_Kammerbeitrag_Saarland);
        this.addZusatzzeile("Stpfl. AG-Anteil zur Zusatzversorgung", this.FIELD_AGA_Zusatzversorgung);
        if (!this.mHasCFFofEntryZVK) {
            this.addZusatzzeile("Stpfl. AN-Anteil zur Zusatzversorgung", this.FIELD_ANA_Zusatzversorgung);
        }
        this.addZusatzzeile("steuerfreie Fahrtkosten bei Ausw\u00e4rtst\u00e4tigkeit", this.FIELD_Fahrtkosten_Auswaertstaetigkeit);
        int n = this.mStatisticalValueTPs.size();
        assert (n == this.mStatisticalValues.size());
        for (int i = 0; i < n; ++i) {
            StatisticalValueTP statisticalValueTP = this.mStatisticalValueTPs.get(i);
            BigDecimal statisticalValue = this.mStatisticalValues.get(i);
            this.addZusatzzeile(statisticalValueTP.getLongDescription(), statisticalValue);
        }
        while (this.FIELD_Zusatztext.size() < 9) {
            this.FIELD_Zusatztext.add("");
            this.FIELD_Zusatzbetrag.add("");
        }
    }

    private void addZusatzzeile(String text, BigDecimal betrag) {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)betrag)) {
            this.FIELD_Zusatztext.add(text);
            this.FIELD_Zusatzbetrag.add(LStBHelper.toCurrencyFormatCentEuroSeparated((BigDecimal)betrag));
        }
    }

    private void generateEECarriedForwardOfEntry(EmployeeWageTaxCertificateBean eWT, Date startDate, Date eeCarriedForwardOfEntryDate) throws BusinessDomainException {
        EECarriedForwardSystemSI[] eECarriedForwardSystemSI;
        EECarriedForwardZVK[] eECarriedForwardOfEntrysZVK;
        String oidEmployee = eWT.getOidEmployee();
        Employee ee = this.mReportValues.getEmployee(oidEmployee);
        this.mHasCFFofEntryZVK = false;
        for (EECarriedForwardZVK entry : eECarriedForwardOfEntrysZVK = ee.getEECarriedForwardZVK()) {
            if (WageTaxCertificateDataSource2016.getYear(startDate) != WageTaxCertificateDataSource2016.getYear(entry.getValidFrom())) continue;
            if (WageTaxCertificateDataSource2016.getYear(startDate) < 2017) {
                this.FIELD_AGA_Zusatzversorgung = this.FIELD_AGA_Zusatzversorgung.add(entry.getTaxableAdditionalContributionER());
                this.mHasCFFofEntryZVK = true;
            }
            this.mBeitragspflichtigZVKUmlageAGA = this.mBeitragspflichtigZVKUmlageAGA.add(entry.getContributoryAssessmentER());
            this.mSteuerfreiZVKUmlageAGA = this.mSteuerfreiZVKUmlageAGA.add(entry.getTaxfreeAssessmentER());
            this.mPauschalsteuerpflichtigZVKUmlageAGA = this.mPauschalsteuerpflichtigZVKUmlageAGA.add(entry.getLumpsumAssessmentER());
            this.mSteuerpflichtigZVKUmlageAGA = this.mSteuerpflichtigZVKUmlageAGA.add(entry.getTaxableAdditionalContributionER());
        }
        for (EECarriedForwardSystemSI entry : eECarriedForwardSystemSI = ee.getEECarriedForwardSystemSI()) {
            if (WageTaxCertificateDataSource2016.getYear(startDate) != WageTaxCertificateDataSource2016.getYear(entry.getValidFrom())) continue;
            this.mGesamtesKVEntgelt = this.mGesamtesKVEntgelt.add(entry.getHIPayment());
            this.mGesamtesRVEntgelt = this.mGesamtesRVEntgelt.add(entry.getPIPayment());
            this.mGesamtesAVEntgelt = this.mGesamtesAVEntgelt.add(entry.getUIPayment());
            this.mGesamtesPVEntgelt = this.mGesamtesPVEntgelt.add(entry.getNIPayment());
        }
        Date employmentStartDate = null;
        Date firstDayOfYear = DateHelper.getFirstDayOfYear((Date)startDate);
        EECarriedForwardOfEntry[] eECarriedForwardOfEntrys = ee.getEECarriedForwardOfEntry();
        Date letztesAustrittsDatum = firstDayOfYear;
        if (eECarriedForwardOfEntrys.length > 0) {
            Employment[] empls;
            Employment[] employmentArray = empls = ee.getEmploymentHistory(this.mForEffectiveDate, firstDayOfYear, DateHelper.yesterday((Date)this.mEmploymentStartDate));
            int n = employmentArray.length;
            for (int i = 0; i < n; ++i) {
                Employment empl = employmentArray[i];
                Date tempAustritt = empl.getDateOfWithDrawal();
                if (tempAustritt == null || !DateHelper.before((Date)tempAustritt, (Date)this.mEmploymentStartDate)) continue;
                letztesAustrittsDatum = DateHelper.after((Date)tempAustritt, (Date)letztesAustrittsDatum) ? tempAustritt : letztesAustrittsDatum;
            }
        }
        Arrays.sort(eECarriedForwardOfEntrys, new EECarriedForwardOfEntryComparator());
        for (EECarriedForwardOfEntry eECarriedForwardOfEntry : eECarriedForwardOfEntrys) {
            if (eECarriedForwardOfEntry.getNoSignificance() || !DateHelper.after((Date)eECarriedForwardOfEntry.getEmploymentUntil(), (Date)letztesAustrittsDatum)) continue;
            EmployeeForReport efr = eWT.getEmployeeForReport();
            String message = "Personalnummer: " + efr.getPersonnelNumberForPrint() + "; Name, Vorname: " + efr.getSurname() + ", " + efr.getFirstname();
            if (eECarriedForwardOfEntry.getYearOfCertificateOfWageTaxDeducation() == 0) {
                throw ReportExceptionMapper.makeEECarriedForwardOfEntryMissingYearOfCertificateOfWageTaxDeducation((String)message);
            }
            if (eECarriedForwardOfEntry.getYearOfCertificateOfWageTaxDeducation() != WageTaxCertificateDataSource2016.getYear(eeCarriedForwardOfEntryDate)) {
                throw ReportExceptionMapper.makeEECarriedForwardOfEntryYearOfCertificateOfWageTaxDeducationNotCorrect((String)message);
            }
            Date dienstverhaeltnisVon = eECarriedForwardOfEntry.getEmploymentFrom();
            Date dienstverhaeltnisBis = eECarriedForwardOfEntry.getEmploymentUntil();
            if (dienstverhaeltnisVon == null || dienstverhaeltnisBis == null) {
                throw ReportExceptionMapper.makeEECarriedForwardOfEntryMissingEmploymentFromOrUntil((String)message);
            }
            if (!DateHelper.beforeOrEqual((Date)firstDayOfYear, (Date)dienstverhaeltnisBis)) continue;
            if (DateHelper.before((Date)dienstverhaeltnisVon, (Date)firstDayOfYear)) {
                if (employmentStartDate == null || DateHelper.after((Date)employmentStartDate, (Date)firstDayOfYear)) {
                    this.mEmploymentStartDate = employmentStartDate = firstDayOfYear;
                }
            } else if (DateHelper.before((Date)dienstverhaeltnisVon, (Date)startDate) && (employmentStartDate == null || DateHelper.after((Date)employmentStartDate, (Date)dienstverhaeltnisVon))) {
                this.mEmploymentStartDate = employmentStartDate = dienstverhaeltnisVon;
            }
            this.addSteuerVortraegeValues(eECarriedForwardOfEntry);
            if (eECarriedForwardOfEntry.getTaxBracket() != 0) {
                this.mSubReport.add(eECarriedForwardOfEntry);
            } else {
                Date taxDate = DateHelper.max((Date)eeCarriedForwardOfEntryDate, (Date)ee.getMinimumDateOfEntry());
                TaxContainer taxContainer = WageTaxCertificateContainerQueries.queryTaxContainer((String)oidEmployee, (Date)taxDate, (Date)taxDate);
                if (taxContainer != null) {
                    eECarriedForwardOfEntry.setTaxBracket(taxContainer.taxbracket);
                    eECarriedForwardOfEntry.setChildRelief(taxContainer.childrelief);
                    eECarriedForwardOfEntry.setFreeAllowanceYY(taxContainer.freeallowanceyy);
                    eECarriedForwardOfEntry.setAddAmountYY(taxContainer.addamountyy);
                    eECarriedForwardOfEntry.setTypeOfChurchTaxEmployee(ChurchTaxEnum.from_int((int)taxContainer.churchtaxee));
                    eECarriedForwardOfEntry.setTypeOfChurchTaxSpouse(ChurchTaxEnum.from_int((int)taxContainer.churchtaxspouse));
                    this.mSubReport.add(eECarriedForwardOfEntry);
                }
            }
            this.mLStBMonate.add(eECarriedForwardOfEntry, this.mForEffectiveDate);
        }
    }

    private void addSteuerVortraegeValues(EECarriedForwardOfEntry eECarriedForwardOfEntry) {
        this.FIELD_u_anz_bigdecimal = this.FIELD_u_anz_bigdecimal.add(BigDecimal.valueOf(eECarriedForwardOfEntry.getNumberOfU()));
        this.mEmployerHolidaysCount = this.FIELD_u_anz_bigdecimal.intValue() == 0 ? "" : Integer.toString(this.FIELD_u_anz_bigdecimal.intValue());
        this.mCapitalLetters.setLetters(eECarriedForwardOfEntry);
        this.FIELD_z_3_arbeitslohn_brutto = WageTaxCertificateDataSource2016.add(this.FIELD_z_3_arbeitslohn_brutto, eECarriedForwardOfEntry.getGrossPay());
        this.FIELD_LSteuer = WageTaxCertificateDataSource2016.add(this.FIELD_LSteuer, eECarriedForwardOfEntry.getIncomeTax());
        this.FIELD_SolZ = WageTaxCertificateDataSource2016.add(this.FIELD_SolZ, eECarriedForwardOfEntry.getSolidarityCharge());
        this.FIELD_KiStAN = WageTaxCertificateDataSource2016.add(this.FIELD_KiStAN, eECarriedForwardOfEntry.getChurchTaxEE());
        this.FIELD_KiStEG = WageTaxCertificateDataSource2016.add(this.FIELD_KiStEG, eECarriedForwardOfEntry.getChurchTaxSpouse());
        this.FIELD_StBegVBez = WageTaxCertificateDataSource2016.add(this.FIELD_StBegVBez, eECarriedForwardOfEntry.getTaxPrivilegedPensionsOfOneYear());
        this.FIELD_StBegVBezMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_StBegVBezMKalJahr, eECarriedForwardOfEntry.getTaxPrivilegedPensionsDiverseYears());
        this.FIELD_ErmStBetrMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_ErmStBetrMKalJahr, eECarriedForwardOfEntry.getReducedTaxedPayDiverseYears());
        this.FIELD_LSteuerMKalendJahr = WageTaxCertificateDataSource2016.add(this.FIELD_LSteuerMKalendJahr, eECarriedForwardOfEntry.getIncomeTaxDiverseYears());
        this.FIELD_SolZMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_SolZMKalJahr, eECarriedForwardOfEntry.getSolidarityChargeDiverseYears());
        this.FIELD_KiStANMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_KiStANMKalJahr, eECarriedForwardOfEntry.getChurchTaxEEDiverseYears());
        this.FIELD_KiStEGMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_KiStEGMKalJahr, eECarriedForwardOfEntry.getChurchTaxSpouseDiverseYears());
        this.FIELD_KurzArbGeld = WageTaxCertificateDataSource2016.add(this.FIELD_KurzArbGeld, eECarriedForwardOfEntry.getWageReplacementBenefit());
        this.FIELD_KurzArbGeldAnteilig = WageTaxCertificateDataSource2016.add(this.FIELD_KurzArbGeldAnteilig, eECarriedForwardOfEntry.getRedHHCompensation());
        this.FIELD_StFreiArbLohnDBA = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiArbLohnDBA, eECarriedForwardOfEntry.getTaxfreeWageDBA());
        this.FIELD_StFreiArbLohnATE = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiArbLohnATE, eECarriedForwardOfEntry.getTaxfreeWageATE());
        this.FIELD_StFreiAGLeistg = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiAGLeistg, eECarriedForwardOfEntry.getTaxfreeERWorkOfDrive());
        this.FIELD_PauschAGLsitg = WageTaxCertificateDataSource2016.add(this.FIELD_PauschAGLsitg, eECarriedForwardOfEntry.getLumpSumTaxationERWorkOfDrive());
        this.FIELD_StPflichtEntschArbLohnMKalJahr = WageTaxCertificateDataSource2016.add(this.FIELD_StPflichtEntschArbLohnMKalJahr, eECarriedForwardOfEntry.getTaxableCompensation());
        this.FIELD_StFreiVerpfleg = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiVerpfleg, eECarriedForwardOfEntry.getTaxfreeAllowanceOfBoard());
        this.FIELD_StFreiDopHaushalt = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiDopHaushalt, eECarriedForwardOfEntry.getTaxfreeERWorkOfHausehold());
        this.FIELD_AGAGesRV = WageTaxCertificateDataSource2016.add(this.FIELD_AGAGesRV, eECarriedForwardOfEntry.getERPI());
        this.FIELD_ANAGesRV = WageTaxCertificateDataSource2016.add(this.FIELD_ANAGesRV, eECarriedForwardOfEntry.getEEPI());
        this.FIELD_StFreiArbgZuschGesKV = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiArbgZuschGesKV, eECarriedForwardOfEntry.getTaxfreeERAllowanceHIandNI());
        this.FIELD_StFreiArbgZuschPrivKV = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiArbgZuschPrivKV, eECarriedForwardOfEntry.getTaxfreeERAllowanceVHI());
        this.FIELD_StFreiArbgZuschGesPV = WageTaxCertificateDataSource2016.add(this.FIELD_StFreiArbgZuschGesPV, eECarriedForwardOfEntry.getTaxfreeERAllowanceNIandPNI());
        this.FIELD_KV_ANA = WageTaxCertificateDataSource2016.add(this.FIELD_KV_ANA, eECarriedForwardOfEntry.getEETotalSI());
        this.FIELD_PV_ANA = WageTaxCertificateDataSource2016.add(this.FIELD_PV_ANA, eECarriedForwardOfEntry.getEENI());
        this.FIELD_AV_ANA = WageTaxCertificateDataSource2016.add(this.FIELD_AV_ANA, eECarriedForwardOfEntry.getEEUI());
        if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2026, 0, 1).getDate())) {
            this.FIELD_Priv_KV_PV = WageTaxCertificateDataSource2016.add(this.FIELD_Priv_KV_PV, eECarriedForwardOfEntry.getRateToPHIandPNIevidenced());
        }
        this.FIELD_SterbegeldVBZNachzahl = WageTaxCertificateDataSource2016.add(this.FIELD_SterbegeldVBZNachzahl, eECarriedForwardOfEntry.getDeathInServiceBenefit());
        this.FIELD_ANABerufVersorg = WageTaxCertificateDataSource2016.add(this.FIELD_ANABerufVersorg, eECarriedForwardOfEntry.getEEBV());
        this.FIELD_AGABerufVersorg = WageTaxCertificateDataSource2016.add(this.FIELD_AGABerufVersorg, eECarriedForwardOfEntry.getERBV());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)eECarriedForwardOfEntry.getDuesOfEmployeeAssociation())) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Kammerbeitrag_Bremen)) {
                this.FIELD_Kammerbeitrag_Bremen = this.FIELD_Kammerbeitrag_Bremen.add(eECarriedForwardOfEntry.getDuesOfEmployeeAssociation());
            } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Kammerbeitrag_Saarland)) {
                this.FIELD_Kammerbeitrag_Saarland = this.FIELD_Kammerbeitrag_Saarland.add(eECarriedForwardOfEntry.getDuesOfEmployeeAssociation());
            } else if (this.mEmployerFederalStateKey == 4) {
                this.FIELD_Kammerbeitrag_Bremen = this.FIELD_Kammerbeitrag_Bremen.add(eECarriedForwardOfEntry.getDuesOfEmployeeAssociation());
            } else if (this.mEmployerFederalStateKey == 10) {
                this.FIELD_Kammerbeitrag_Saarland = this.FIELD_Kammerbeitrag_Saarland.add(eECarriedForwardOfEntry.getDuesOfEmployeeAssociation());
            }
        }
        if (DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2024, 0, 1).getDate())) {
            this.FIELD_AusgezKiGeld = WageTaxCertificateDataSource2016.add(this.FIELD_AusgezKiGeld, eECarriedForwardOfEntry.getChildAllowance());
        }
        this.FIELD_FreibetragDBATuerkei = WageTaxCertificateDataSource2016.add(this.FIELD_FreibetragDBATuerkei, eECarriedForwardOfEntry.getDoubleTaxacationAgreementTurkey());
        this.FIELD_Fahrtkosten_Auswaertstaetigkeit = WageTaxCertificateDataSource2016.add(this.FIELD_Fahrtkosten_Auswaertstaetigkeit, eECarriedForwardOfEntry.getTaxfreeCarFares());
        this.FIELD_ANA_Zusatzversorgung = WageTaxCertificateDataSource2016.add(this.FIELD_ANA_Zusatzversorgung, eECarriedForwardOfEntry.getTaxableEEAdditionalPension());
        if (!this.mHasCFFofEntryZVK) {
            this.FIELD_AGA_Zusatzversorgung = WageTaxCertificateDataSource2016.add(this.FIELD_AGA_Zusatzversorgung, eECarriedForwardOfEntry.getTaxableERAdditionalPension());
        }
    }

    private static BigDecimal add(BigDecimal summand1, BigDecimal summand2) {
        return BigDecimalMapper.isZeroOrNull((BigDecimal)summand2) ? summand1 : summand1.add(summand2);
    }

    public void fill(EECarriedForwardOfEntry eeCarriedForwardOfEntry) {
        eeCarriedForwardOfEntry.setNumberOfU(this.FIELD_u_anz_bigdecimal.intValue());
        eeCarriedForwardOfEntry.setLetterS(this.mCapitalLetters.isS());
        eeCarriedForwardOfEntry.setLetterF(this.mCapitalLetters.isF());
        eeCarriedForwardOfEntry.setLetterM(this.mCapitalLetters.isM());
        eeCarriedForwardOfEntry.setLetterE(this.mCapitalLetters.isE());
        eeCarriedForwardOfEntry.setGrossPay(this.FIELD_z_3_arbeitslohn_brutto);
        eeCarriedForwardOfEntry.setIncomeTax(this.FIELD_LSteuer);
        eeCarriedForwardOfEntry.setSolidarityCharge(this.FIELD_SolZ);
        eeCarriedForwardOfEntry.setChurchTaxEE(this.FIELD_KiStAN);
        eeCarriedForwardOfEntry.setChurchTaxSpouse(this.FIELD_KiStEG);
        eeCarriedForwardOfEntry.setTaxPrivilegedPensionsOfOneYear(this.FIELD_StBegVBez);
        eeCarriedForwardOfEntry.setTaxPrivilegedPensionsDiverseYears(this.FIELD_StBegVBezMKalJahr);
        eeCarriedForwardOfEntry.setReducedTaxedPayDiverseYears(this.FIELD_ErmStBetrMKalJahr);
        eeCarriedForwardOfEntry.setIncomeTaxDiverseYears(this.FIELD_LSteuerMKalendJahr);
        eeCarriedForwardOfEntry.setSolidarityChargeDiverseYears(this.FIELD_SolZMKalJahr);
        eeCarriedForwardOfEntry.setChurchTaxEEDiverseYears(this.FIELD_KiStANMKalJahr);
        eeCarriedForwardOfEntry.setChurchTaxSpouseDiverseYears(this.FIELD_KiStEGMKalJahr);
        eeCarriedForwardOfEntry.setWageReplacementBenefit(this.FIELD_KurzArbGeld);
        eeCarriedForwardOfEntry.setRedHHCompensation(this.FIELD_KurzArbGeldAnteilig);
        eeCarriedForwardOfEntry.setTaxfreeWageDBA(this.FIELD_StFreiArbLohnDBA);
        eeCarriedForwardOfEntry.setTaxfreeWageATE(this.FIELD_StFreiArbLohnATE);
        eeCarriedForwardOfEntry.setTaxfreeERWorkOfDrive(this.FIELD_StFreiAGLeistg);
        eeCarriedForwardOfEntry.setLumpSumTaxationERWorkOfDrive(this.FIELD_PauschAGLsitg);
        eeCarriedForwardOfEntry.setTaxableCompensation(this.FIELD_StPflichtEntschArbLohnMKalJahr);
        eeCarriedForwardOfEntry.setTaxfreeAllowanceOfBoard(this.FIELD_StFreiVerpfleg);
        eeCarriedForwardOfEntry.setTaxfreeERWorkOfHausehold(this.FIELD_StFreiDopHaushalt);
        eeCarriedForwardOfEntry.setERPI(this.FIELD_AGAGesRV);
        eeCarriedForwardOfEntry.setEEPI(this.FIELD_ANAGesRV);
        eeCarriedForwardOfEntry.setTaxfreeERAllowanceHIandNI(this.FIELD_StFreiArbgZuschGesKV);
        eeCarriedForwardOfEntry.setTaxfreeERAllowanceVHI(this.FIELD_StFreiArbgZuschPrivKV);
        eeCarriedForwardOfEntry.setTaxfreeERAllowanceNIandPNI(this.FIELD_StFreiArbgZuschGesPV);
        eeCarriedForwardOfEntry.setEETotalSI(this.FIELD_KV_ANA);
        eeCarriedForwardOfEntry.setEENI(this.FIELD_PV_ANA);
        eeCarriedForwardOfEntry.setEEUI(this.FIELD_AV_ANA);
        eeCarriedForwardOfEntry.setRateToPHIandPNIevidenced(this.FIELD_Priv_KV_PV);
        eeCarriedForwardOfEntry.setDeathInServiceBenefit(this.FIELD_SterbegeldVBZNachzahl);
        eeCarriedForwardOfEntry.setERBV(this.FIELD_AGABerufVersorg);
        eeCarriedForwardOfEntry.setEEBV(this.FIELD_ANABerufVersorg);
        eeCarriedForwardOfEntry.setDuesOfEmployeeAssociation(WageTaxCertificateDataSource2016.add(this.FIELD_Kammerbeitrag_Bremen, this.FIELD_Kammerbeitrag_Saarland));
        eeCarriedForwardOfEntry.setChildAllowance(this.FIELD_AusgezKiGeld);
        eeCarriedForwardOfEntry.setDoubleTaxacationAgreementTurkey(this.FIELD_FreibetragDBATuerkei);
        eeCarriedForwardOfEntry.setTaxfreeCarFares(this.FIELD_Fahrtkosten_Auswaertstaetigkeit);
        eeCarriedForwardOfEntry.setTaxableEEAdditionalPension(this.FIELD_ANA_Zusatzversorgung);
        eeCarriedForwardOfEntry.setTaxableERAdditionalPension(this.FIELD_AGA_Zusatzversorgung);
        List lStBMonate = this.mLStBMonate.getLStBMonate();
        LStBMonat lStBMonat = (LStBMonat)lStBMonate.get(lStBMonate.size() - 1);
        eeCarriedForwardOfEntry.setTaxBracket(lStBMonat.getSteuerklasse());
        eeCarriedForwardOfEntry.setPercentageSplit(lStBMonat.getFaktor());
        eeCarriedForwardOfEntry.setChildRelief(lStBMonat.getKinder());
        eeCarriedForwardOfEntry.setTypeOfChurchTaxEmployee(lStBMonat.getKiStAbzugChurchTax());
        eeCarriedForwardOfEntry.setTypeOfChurchTaxSpouse(lStBMonat.getKiStAbzugEhegatteChurchTax());
        eeCarriedForwardOfEntry.setFreeAllowanceYY(lStBMonat.getSteuerfreibetragJahr());
        eeCarriedForwardOfEntry.setAddAmountYY(lStBMonat.getHinzurechnungsbetragJahr());
        try {
            Employee employee = eeCarriedForwardOfEntry.getEmployee();
            Employment[] empls = employee.getEmploymentHistory(this.mForEffectiveDate);
            Date eintritt = VDate.getDateMax();
            for (Employment empl : empls) {
                eintritt = DateHelper.before((Date)empl.getDateOfEntry(), (Date)eintritt) ? empl.getDateOfEntry() : eintritt;
            }
            eeCarriedForwardOfEntry.setNoSignificance(this.isSuccessorGfB(employee, eintritt));
        }
        catch (BusinessDomainException e) {
            eeCarriedForwardOfEntry.setNoSignificance(false);
        }
    }

    private void getValuesFromValuePositionDataMaerzKlausel(ValuepositionContainer vPContainer) {
        switch (vPContainer.valuetypenumber) {
            case 322620: 
            case 322626: 
            case 322630: 
            case 322636: {
                this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(vPContainer.results);
                break;
            }
            case 334620: 
            case 334630: {
                this.FIELD_AV_ANA = this.FIELD_AV_ANA.add(vPContainer.results);
                break;
            }
            case 340620: 
            case 340626: 
            case 340630: 
            case 340636: {
                this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(vPContainer.results);
                break;
            }
            case 328620: 
            case 328630: {
                this.FIELD_ANAGesRV = this.FIELD_ANAGesRV.add(vPContainer.results);
                break;
            }
            case 329630: 
            case 329640: {
                if (this.isVersicherungsfreierAltersvollrentner(vPContainer.oidemployee, vPContainer.effectivefrom)) break;
                this.FIELD_AGAGesRV = this.FIELD_AGAGesRV.add(vPContainer.results);
            }
        }
    }

    private void getValuesFromValuePositionData(Date myBeginnDate, Date myEndDate, ValuepositionContainer valuepositionContainer) {
        if (DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)myEndDate) && DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)myBeginnDate)) {
            Date beginDate = DateHelper.max((Date)valuepositionContainer.validfrom, (Date)myBeginnDate);
            Date endDate = DateHelper.getLastDayOfMonth((Date)DateHelper.min((Date)valuepositionContainer.validuntil, (Date)myEndDate));
            BigDecimal months = new BigDecimal(WageTaxCertificateDataSource2016.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate));
            BigDecimal result1Month = valuepositionContainer.results;
            BigDecimal result = result1Month.multiply(months);
            switch (valuepositionContainer.valuetypenumber) {
                case 130630: {
                    this.mValuePositionsMKFJLi = ReportEmployeesHandlingHelper.getValuePositionsLi((String)valuepositionContainer.oidemployee, (String[])VALUETYPENUMBERS_MK_FJ, (Date)this.mForEffectiveDate, (Date)DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)myBeginnDate))), (Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)myBeginnDate)));
                    break;
                }
                case 130640: {
                    EECarriedForwardSystemCOM eECFSystemCOM;
                    Employee employee;
                    EECarriedForwardSystemCOM[] eECFSystemCOMs;
                    if (BigDecimalMapper.compareTo((BigDecimal)valuepositionContainer.results, (BigDecimal)ZERO2) == 0 || (eECFSystemCOMs = (employee = this.mReportValues.getEmployee(valuepositionContainer.oidemployee)).getEECarriedForwardSystemCOM()).length <= 0 || WageTaxCertificateDataSource2016.getYear((eECFSystemCOM = eECFSystemCOMs[0]).getLastCalcPeriodFrom()) - WageTaxCertificateDataSource2016.getYear(this.mListFirstDate) != 1 || !DateHelper.between((Date)this.mCalculationStartDate, (Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)this.mListFirstDate)), (Date)new VDate(this.mYearInt, 3, 1).getDate())) break;
                    this.mValuePositionsMKFJSWLi = ReportEmployeesHandlingHelper.getValuePositionsLi((String)valuepositionContainer.oidemployee, (String[])VALUETYPENUMBERS_MK_FJ_SW, (Date)this.mForEffectiveDate, (Date)myBeginnDate, (Date)DateMapper.toDate((String)(this.mYear + "-03-31")));
                    break;
                }
                case 103570: {
                    this.mCapitalLetters.setF();
                    break;
                }
                case 103590: {
                    this.mCapitalLetters.setM();
                    break;
                }
                case 220695: {
                    this.mCapitalLetters.setS();
                    break;
                }
                case 102590: {
                    this.mCapitalLetters.setE();
                    break;
                }
                case 110595: {
                    this.FIELD_u_anz_bigdecimal = this.FIELD_u_anz_bigdecimal.add(WageTaxCertificateDataSource2016.toScale(0, valuepositionContainer.factor1));
                    this.mEmployerHolidaysCount = this.FIELD_u_anz_bigdecimal.intValue() == 0 ? "" : Integer.toString(this.FIELD_u_anz_bigdecimal.intValue());
                    break;
                }
                case 110510: 
                case 110610: 
                case 110630: {
                    this.FIELD_z_3_arbeitslohn_brutto = this.FIELD_z_3_arbeitslohn_brutto.add(result);
                    break;
                }
                case 220510: 
                case 220610: 
                case 220630: {
                    this.FIELD_LSteuer = this.FIELD_LSteuer.add(result);
                    break;
                }
                case 760100: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate)) break;
                    this.FIELD_LSteuer = this.FIELD_LSteuer.subtract(result);
                    break;
                }
                case 760450: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate) || valuepositionContainer.category != 22) break;
                    this.FIELD_LSteuer = this.FIELD_LSteuer.add(result);
                    break;
                }
                case 223510: 
                case 223610: 
                case 223630: {
                    this.FIELD_SolZ = this.FIELD_SolZ.add(result);
                    break;
                }
                case 760110: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate)) break;
                    this.FIELD_SolZ = this.FIELD_SolZ.subtract(result);
                    break;
                }
                case 760460: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate) || valuepositionContainer.category != 22) break;
                    this.FIELD_SolZ = this.FIELD_SolZ.add(result);
                    break;
                }
                case 226510: 
                case 226610: 
                case 226630: {
                    this.FIELD_KiStAN = this.FIELD_KiStAN.add(result);
                    break;
                }
                case 760120: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate)) break;
                    this.FIELD_KiStAN = this.FIELD_KiStAN.subtract(result);
                    break;
                }
                case 760470: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate) || valuepositionContainer.category != 22) break;
                    this.FIELD_KiStAN = this.FIELD_KiStAN.add(result);
                    break;
                }
                case 227510: 
                case 227610: 
                case 227630: {
                    this.FIELD_KiStEG = this.FIELD_KiStEG.add(result);
                    break;
                }
                case 760130: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate)) break;
                    this.FIELD_KiStEG = this.FIELD_KiStEG.subtract(result);
                    break;
                }
                case 760480: {
                    if (!WageTaxCertificateDataSource2016.isDecember(beginDate) || valuepositionContainer.category != 22) break;
                    this.FIELD_KiStEG = this.FIELD_KiStEG.add(result);
                    break;
                }
                case 102500: 
                case 102505: {
                    this.FIELD_StBegVBez = this.FIELD_StBegVBez.add(result);
                    break;
                }
                case 102520: {
                    if (!this.mValueTypeNumber220400) {
                        this.FIELD_StBegVBezMKalJahr = this.FIELD_StBegVBezMKalJahr.add(result);
                        break;
                    }
                    this.FIELD_z_3_arbeitslohn_brutto = this.FIELD_z_3_arbeitslohn_brutto.add(result);
                    break;
                }
                case 102540: 
                case 102550: {
                    if (this.mYearInt < 2025 || !this.isSteuerpflichtig(valuepositionContainer)) break;
                    this.FIELD_ErmStBetrMKalJahr = this.FIELD_ErmStBetrMKalJahr.add(result);
                    break;
                }
                case 220620: {
                    if (!this.mValueTypeNumber220400) {
                        if (this.mYearInt >= 2025) break;
                        this.FIELD_LSteuerMKalendJahr = this.FIELD_LSteuerMKalendJahr.add(result);
                        break;
                    }
                    this.FIELD_LSteuer = this.FIELD_LSteuer.add(result);
                    break;
                }
                case 223620: {
                    if (!this.mValueTypeNumber220400) {
                        if (this.mYearInt >= 2025) break;
                        this.FIELD_SolZMKalJahr = this.FIELD_SolZMKalJahr.add(result);
                        break;
                    }
                    this.FIELD_SolZ = this.FIELD_SolZ.add(result);
                    break;
                }
                case 226620: {
                    if (!this.mValueTypeNumber220400) {
                        if (this.mYearInt >= 2025) break;
                        this.FIELD_KiStANMKalJahr = this.FIELD_KiStANMKalJahr.add(result);
                        break;
                    }
                    this.FIELD_KiStAN = this.FIELD_KiStAN.add(result);
                    break;
                }
                case 227620: {
                    if (!this.mValueTypeNumber220400) {
                        if (this.mYearInt >= 2025) break;
                        this.FIELD_KiStEGMKalJahr = this.FIELD_KiStEGMKalJahr.add(result);
                        break;
                    }
                    this.FIELD_KiStEG = this.FIELD_KiStEG.add(result);
                    break;
                }
                case 230510: {
                    this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                    if (this.mYearInt < 2025) break;
                    this.FIELD_KurzArbGeldAnteilig = this.FIELD_KurzArbGeldAnteilig.add(result);
                    break;
                }
                case 150526: {
                    if (!DateHelper.before((Date)myEndDate, (Date)new VDate(2022, 0, 1).getDate())) break;
                    this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                    break;
                }
                case 103500: 
                case 400100: 
                case 400400: 
                case 695200: 
                case 695500: {
                    this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                    break;
                }
                case 103510: 
                case 103515: {
                    this.FIELD_StFreiArbLohnDBA = this.FIELD_StFreiArbLohnDBA.add(result);
                    break;
                }
                case 103520: {
                    this.FIELD_StFreiArbLohnATE = this.FIELD_StFreiArbLohnATE.add(result);
                    break;
                }
                case 103530: {
                    this.FIELD_StFreiAGLeistg = this.FIELD_StFreiAGLeistg.add(result);
                    break;
                }
                case 101590: {
                    this.FIELD_PauschAGLsitg = this.FIELD_PauschAGLsitg.add(result);
                    break;
                }
                case 102580: {
                    if (this.mYearInt < 2025) {
                        this.FIELD_StPflichtEntschArbLohnMKalJahr = this.FIELD_StPflichtEntschArbLohnMKalJahr.add(result);
                        break;
                    }
                    if (!this.isSteuerpflichtig(valuepositionContainer)) break;
                    this.FIELD_ErmStBetrMKalJahr = this.FIELD_ErmStBetrMKalJahr.add(result);
                    break;
                }
                case 220400: {
                    if (this.mYearInt >= 2025) break;
                    this.FIELD_StPflichtEntschArbLohnMKalJahr = this.FIELD_StPflichtEntschArbLohnMKalJahr.add(result);
                    break;
                }
                case 103540: {
                    this.FIELD_StFreiVerpfleg = this.FIELD_StFreiVerpfleg.add(result);
                    break;
                }
                case 103550: {
                    this.FIELD_StFreiDopHaushalt = this.FIELD_StFreiDopHaushalt.add(result);
                    break;
                }
                case 103545: 
                case 770020: 
                case 770025: 
                case 770030: 
                case 770035: 
                case 770040: 
                case 770045: {
                    this.FIELD_StFreiArbgZuschGesKV = this.FIELD_StFreiArbgZuschGesKV.add(result);
                    break;
                }
                case 770120: 
                case 770130: 
                case 770140: {
                    this.FIELD_StFreiArbgZuschPrivKV = this.FIELD_StFreiArbgZuschPrivKV.add(result);
                    break;
                }
                case 771020: 
                case 771030: 
                case 771040: 
                case 771120: 
                case 771130: 
                case 771140: {
                    this.FIELD_StFreiArbgZuschGesPV = this.FIELD_StFreiArbgZuschGesPV.add(result);
                    break;
                }
                case 329510: 
                case 329512: 
                case 329514: 
                case 329520: 
                case 329560: 
                case 329610: 
                case 329620: 
                case 329640: 
                case 329730: 
                case 329740: {
                    if (!this.check100PercentAGBeitrag(valuepositionContainer, beginDate) || this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    for (Period period : new Period(beginDate, endDate)) {
                        if (this.isVersicherungsfreierAltersvollrentner(valuepositionContainer.oidemployee, period.from)) continue;
                        this.FIELD_AGAGesRV = this.FIELD_AGAGesRV.add(result1Month);
                    }
                    break;
                }
                case 775510: 
                case 775514: 
                case 775560: 
                case 775610: 
                case 775630: 
                case 775640: 
                case 775730: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    for (Period period : new Period(beginDate, endDate)) {
                        if (this.isVersicherungsfreierAltersvollrentner(valuepositionContainer.oidemployee, period.from)) continue;
                        this.FIELD_AGABerufVersorg = this.FIELD_AGABerufVersorg.add(result1Month);
                    }
                    break;
                }
                case 103595: 
                case 328510: 
                case 328512: 
                case 328514: 
                case 328550: 
                case 328610: 
                case 328630: 
                case 328730: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.FIELD_ANAGesRV = this.FIELD_ANAGesRV.add(result);
                    break;
                }
                case 322510: 
                case 322514: 
                case 322516: 
                case 322518: 
                case 322610: 
                case 322616: 
                case 322630: 
                case 322636: 
                case 322730: 
                case 322736: 
                case 351510: 
                case 351516: 
                case 750300: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(result);
                    break;
                }
                case 770000: 
                case 770005: {
                    this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(result);
                    this.mKVFreiwBeitrag = this.mKVFreiwBeitrag.add(result);
                    break;
                }
                case 750200: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.FIELD_KV_ANA = this.FIELD_KV_ANA.subtract(result);
                    break;
                }
                case 334510: 
                case 334514: 
                case 334610: 
                case 334630: 
                case 334730: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.FIELD_AV_ANA = this.FIELD_AV_ANA.add(result);
                    break;
                }
                case 340510: 
                case 340514: 
                case 340516: 
                case 340518: 
                case 340610: 
                case 340616: 
                case 340630: 
                case 340636: 
                case 340730: 
                case 340736: 
                case 355510: 
                case 355516: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(result);
                    break;
                }
                case 771000: {
                    this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(result);
                    this.mPVFreiwBeitrag = this.mPVFreiwBeitrag.add(result);
                    break;
                }
                case 102560: 
                case 102570: {
                    this.FIELD_SterbegeldVBZNachzahl = this.FIELD_SterbegeldVBZNachzahl.add(result);
                    break;
                }
                case 250510: {
                    this.FIELD_Kammerbeitrag_Bremen = this.FIELD_Kammerbeitrag_Bremen.add(result);
                    break;
                }
                case 250610: {
                    this.FIELD_Kammerbeitrag_Saarland = this.FIELD_Kammerbeitrag_Saarland.add(result);
                    break;
                }
                case 111320: {
                    this.FIELD_ANA_Zusatzversorgung = this.FIELD_ANA_Zusatzversorgung.add(result);
                    break;
                }
                case 111310: {
                    this.FIELD_AGA_Zusatzversorgung = this.FIELD_AGA_Zusatzversorgung.add(result);
                    break;
                }
                case 103580: {
                    this.FIELD_Fahrtkosten_Auswaertstaetigkeit = this.FIELD_Fahrtkosten_Auswaertstaetigkeit.add(result);
                    break;
                }
                case 104710: 
                case 104720: 
                case 104730: {
                    if (!DateHelper.before((Date)myEndDate, (Date)new VDate(2026, 0, 1).getDate())) break;
                    this.FIELD_Priv_KV_PV = this.FIELD_Priv_KV_PV.add(result);
                    break;
                }
                case 760500: {
                    if (!DateHelper.before((Date)this.mForValidDate, (Date)new VDate(2024, 0, 1).getDate())) break;
                    this.FIELD_AusgezKiGeld = this.FIELD_AusgezKiGeld.add(result);
                    break;
                }
                case 103600: {
                    this.FIELD_FreibetragDBATuerkei = this.FIELD_FreibetragDBATuerkei.add(result);
                    break;
                }
                case 111140: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mSteuerfreiZVKUmlageAGA = this.mSteuerfreiZVKUmlageAGA.add(result);
                    break;
                }
                case 111240: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mPauschalsteuerpflichtigZVKUmlageAGA = this.mPauschalsteuerpflichtigZVKUmlageAGA.add(result);
                    break;
                }
                case 111340: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mSteuerpflichtigZVKUmlageAGA = this.mSteuerpflichtigZVKUmlageAGA.add(result);
                    break;
                }
                case 111540: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mBeitragspflichtigZVKUmlageAGA = this.mBeitragspflichtigZVKUmlageAGA.add(result);
                    break;
                }
                case 321050: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mGesamtesKVEntgelt = this.mGesamtesKVEntgelt.add(result);
                    break;
                }
                case 327050: 
                case 773050: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mGesamtesRVEntgelt = this.mGesamtesRVEntgelt.add(result);
                    break;
                }
                case 333050: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mGesamtesAVEntgelt = this.mGesamtesAVEntgelt.add(result);
                    break;
                }
                case 339050: {
                    if (this.mHasDBAorATE && this.isDbaOrAteVP(valuepositionContainer)) break;
                    this.mGesamtesPVEntgelt = this.mGesamtesPVEntgelt.add(result);
                }
            }
        }
    }

    private boolean isSteuerpflichtig(ValuepositionContainer valuepositionContainer) {
        boolean isSteuerpflichtig = true;
        PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidgenesisparent", (String)valuepositionContainer.oidgenesisparent)}));
        if (valuePositionDatas != null) {
            while (isSteuerpflichtig && valuePositionDatas.hasNext()) {
                ValuepositionContainer valuePositionContainer = (ValuepositionContainer)valuePositionDatas.getNext();
                switch (valuePositionContainer.valuetypenumber) {
                    case 103510: 
                    case 103515: 
                    case 103520: 
                    case 104600: {
                        isSteuerpflichtig = false;
                    }
                }
            }
        }
        return isSteuerpflichtig;
    }

    private boolean check100PercentAGBeitrag(ValuepositionContainer valuepositionContainer, Date beginDate) {
        if (valuepositionContainer.valuetypenumber == 329740) {
            if (DateHelper.afterOrEqual((Date)beginDate, (Date)new VDate(2024, 0, 1).getDate())) {
                InsuranceallContainer insurance = this.getInsurance(valuepositionContainer.oidemployee, beginDate);
                return insurance != null && (insurance.persongroup == 107 || insurance.persongroup == 111 || insurance.persongroup != 127);
            }
            return false;
        }
        return true;
    }

    private void getValuesFromVPDataForErmaessigtSBZ(String oidemployee, Date myBeginnDate, Date myEndDate) {
        ValuePosition[] valuePositions;
        for (ValuePosition vp : valuePositions = ValuePosition.getValuePositions((String)oidemployee, (Date)this.mForEffectiveDate, (Date)this.mForEffectiveDate, (Date)myBeginnDate, (Date)myEndDate, (int)110620)) {
            Date beginDate = DateHelper.max((Date)vp.getValidFrom(), (Date)myBeginnDate);
            Date endDate = DateHelper.getLastDayOfMonth((Date)DateHelper.min((Date)vp.getValidUntil(), (Date)myEndDate));
            BigDecimal months = new BigDecimal(WageTaxCertificateDataSource2016.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate));
            BigDecimal result = vp.getResult().multiply(months);
            if (this.mValueTypeNumber220400) {
                this.FIELD_z_3_arbeitslohn_brutto = this.FIELD_z_3_arbeitslohn_brutto.add(result);
                continue;
            }
            this.FIELD_ErmStBetrMKalJahr = this.FIELD_ErmStBetrMKalJahr.add(result);
        }
    }

    private void calculateSVRueckrechnungDifferenzen(EmployeeWageTaxCertificateBean eWT) throws BusinessDomainException {
        this.calculateSVRueckrechnungDifferenzen(eWT, this.mYearInt, false);
        this.calculateSVRueckrechnungDifferenzen(eWT, this.mYearInt - 1, true);
    }

    private void calculateSVRueckrechnungDifferenzen(EmployeeWageTaxCertificateBean eWT, int year, boolean add) throws BusinessDomainException {
        Date effectiveDateEnd;
        String oidEmployee = eWT.getOidEmployee();
        Date rueckrechnungssperre = mReportHelper.getRueckrechnungssperre(year);
        if (DateHelper.after((Date)this.mCalculationStartDate, (Date)rueckrechnungssperre)) {
            return;
        }
        if (DateHelper.afterOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)rueckrechnungssperre), (Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))) {
            return;
        }
        Date effectiveDateBegin = WageTaxCertificateDataSource2016.calculateEffectiveDateForSVRueckrechnung(eWT, DateHelper.tomorrow((Date)rueckrechnungssperre));
        if (DateHelper.after((Date)eWT.getEmployeeStartDate(), (Date)effectiveDateBegin)) {
            effectiveDateBegin = DateHelper.getFirstDayOfMonth((Date)eWT.getEmployeeStartDate());
        }
        if (this.mIsForCarriedForward) {
            effectiveDateEnd = DateHelper.getLastDayOfMonth((Date)eWT.getEmployeeEndDate());
        } else {
            effectiveDateEnd = mReportHelper.getRueckrechnungssperre(WageTaxCertificateDataSource2016.getYear(effectiveDateBegin));
            if (DateHelper.before((Date)this.mForEffectiveDate, (Date)effectiveDateEnd)) {
                effectiveDateEnd = this.mForEffectiveDate;
            }
        }
        if (DateHelper.beforeOrEqual((Date)effectiveDateEnd, (Date)effectiveDateBegin)) {
            return;
        }
        Date rueckrechnungsbeginn = this.getReturnCalculationDate(eWT.getOidEmployee(), effectiveDateBegin, effectiveDateEnd);
        if (rueckrechnungsbeginn == null || WageTaxCertificateDataSource2016.getYear(rueckrechnungsbeginn) > year) {
            return;
        }
        Date validFrom = rueckrechnungsbeginn;
        Date validUntil = new VDate(year, 11, 31).getDate();
        Period period = new Period(validFrom, validUntil);
        this.calculateSVRueckrechnung(oidEmployee, DateHelper.getFirstDayOfMonth((Date)effectiveDateEnd), period, add);
        this.calculateSVRueckrechnung(oidEmployee, DateHelper.addMonths((Date)effectiveDateBegin, (int)-1), period, !add);
    }

    private Date getReturnCalculationDate(String oidEmployee, Date effectiveDateBegin, Date effectiveDateEnd) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDateBegin)), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveDateEnd)), Restrictions.lt((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)effectiveDateBegin))), Restrictions.eq((String)"oidemployee", (String)oidEmployee)});
        Date validFrom = null;
        PersistencyDataSet calculationbasicDatas = daoCalculationbasic.getDataSet(null, (Criterion)filter);
        while (calculationbasicDatas.hasNext()) {
            CalculationbasicContainer container = (CalculationbasicContainer)calculationbasicDatas.getNext();
            if (validFrom != null && !DateHelper.before((Date)container.validfrom, (Date)validFrom)) continue;
            validFrom = container.validfrom;
        }
        return validFrom;
    }

    private static Date calculateEffectiveDateForSVRueckrechnung(EmployeeWageTaxCertificateBean eWT, Date rueckrechnungssperre) {
        Date dateOfWithdrawal = eWT.getEmployeeForReport().getDateOfWithDrawal();
        if (dateOfWithdrawal != null && DateHelper.beforeOrEqual((Date)dateOfWithdrawal, (Date)rueckrechnungssperre)) {
            Date validUntil = DateHelper.getFirstDayOfMonth((Date)eWT.getEmployeeEndDate());
            LStBAccount[] lStBAccounts = lStBAccountPersistencyManager.query(new Order[]{Order.desc((String)"VALIDFROM")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDEMPLOYEE", (String)eWT.getOidEmployee()), Restrictions.gt((String)"VALIDFROM", (String)DateMapper.toString((Date)rueckrechnungssperre)), Restrictions.lt((String)"VALIDUNTIL", (String)DateMapper.toString((Date)validUntil)), Restrictions.eq((String)"TRANSMITTED", (String)BooleanMapper.toString((boolean)true)), Restrictions.eq((String)"DELETED", (String)BooleanMapper.toString((boolean)false)), Restrictions.eq((String)"ACKNOWLEDGED", (String)BooleanMapper.toString((boolean)true)), Restrictions.eq((String)"INCORRECT", (String)BooleanMapper.toString((boolean)false)), Restrictions.in((String)"TYPEOFINSTRUCTION", (String[])new String[]{Integer.toString(1), Integer.toString(2)}), Restrictions.eq((String)"CANCELED", (String)LStBAccount.CancelFlag.Normal.toDBString())}), true);
            if (lStBAccounts.length > 0) {
                return lStBAccounts[0].getEffectiveFrom();
            }
        }
        return rueckrechnungssperre;
    }

    private void calculateSVRueckrechnung(String oidEmployee, Date effectiveDate, Period period, boolean add) throws BusinessDomainException {
        List valuePositions = ReportEmployeesHandlingHelper.getValuePositionsLi((String)oidEmployee, (String[])VALUETYPENUMBERS_RUECKRECHNUNG_SV, (Date)effectiveDate, (Date)period.from, (Date)period.until);
        LinkedList<String> employees = new LinkedList<String>();
        employees.add(oidEmployee);
        this.mRCInsuranceAllMap = WageTaxCertificateDataSource2016.queryHashMapInsuranceall(employees, effectiveDate, period.from, period.until);
        for (ValuepositionContainer vp : valuePositions) {
            this.calculateSVRueckrechnung(vp, period, add);
        }
        this.calculate23b(valuePositions, period, add);
    }

    private void calculate23b(List<ValuepositionContainer> valuePositions, Period period, boolean add) {
        if (valuePositions.isEmpty()) {
            return;
        }
        String oidEmployee = valuePositions.get((int)0).oidemployee;
        for (Period month : period) {
            Date validDate = month.until;
            if (this.isVersicherungsfreierAltersvollrentner(oidEmployee, validDate)) continue;
            this.calculate23b(valuePositions, validDate, add, 774510, 775510);
            this.calculate23b(valuePositions, validDate, add, 774514, 775514);
            this.calculate23b(valuePositions, validDate, add, 774550, 775560);
            this.calculate23b(valuePositions, validDate, add, 774610, 775610);
            this.calculate23b(valuePositions, validDate, add, 774620, 775630);
            this.calculate23b(valuePositions, validDate, add, 774630, 775640);
            this.calculate23b(valuePositions, validDate, add, 774730, 775730);
        }
    }

    private void calculate23b(List<ValuepositionContainer> valuePositions, Date validDate, boolean add, int valueTypeNumberBVBeitrag, int valueTypeNumberBVAGZ) {
        List<ValuepositionContainer> valuePositionsBVBeitrag = this.getValuePositions(valuePositions, validDate, valueTypeNumberBVBeitrag);
        if (valuePositionsBVBeitrag.isEmpty()) {
            return;
        }
        List<ValuepositionContainer> valuePositionsBVAGZ = this.getValuePositions(valuePositions, validDate, valueTypeNumberBVAGZ);
        BigDecimal sumBVBeitrag = WageTaxCertificateDataSource2016.getSum(valuePositionsBVBeitrag);
        BigDecimal sumBVAGZ = WageTaxCertificateDataSource2016.getSum(valuePositionsBVAGZ);
        this.FIELD_ANABerufVersorg = add ? this.FIELD_ANABerufVersorg.add(sumBVBeitrag).subtract(sumBVAGZ) : this.FIELD_ANABerufVersorg.subtract(sumBVBeitrag).add(sumBVAGZ);
    }

    private List<ValuepositionContainer> getValuePositions(List<ValuepositionContainer> valuePositions, Date validDate, int valueTypeNumber) {
        ArrayList<ValuepositionContainer> result = new ArrayList<ValuepositionContainer>();
        for (ValuepositionContainer valuePosition : valuePositions) {
            if (valuePosition.valuetypenumber != valueTypeNumber || !DateHelper.between((Date)validDate, (Date)valuePosition.validfrom, (Date)valuePosition.validuntil) || this.mHasDBAorATE && this.isDbaOrAteVP(valuePosition)) continue;
            result.add(valuePosition);
        }
        return result;
    }

    private static BigDecimal getSum(List<ValuepositionContainer> valuePositions) {
        BigDecimal result = BigDecimal.ZERO;
        for (ValuepositionContainer valuePosition : valuePositions) {
            result = result.add(valuePosition.results);
        }
        return result;
    }

    private void calculateSVRueckrechnung(ValuepositionContainer valueposition, Period period, boolean add) {
        Date endDate;
        Date beginDate = DateHelper.max((Date)valueposition.validfrom, (Date)period.from);
        if (DateHelper.after((Date)beginDate, (Date)(endDate = DateHelper.min((Date)valueposition.validuntil, (Date)period.until)))) {
            return;
        }
        BigDecimal result1Month = add ? valueposition.results : valueposition.results.negate();
        BigDecimal months = new BigDecimal(WageTaxCertificateDataSource2016.getDiffInMonths(endDate, beginDate) + 1);
        BigDecimal result = result1Month.multiply(months);
        switch (valueposition.valuetypenumber) {
            case 102500: 
            case 102505: {
                this.FIELD_StBegVBez = this.FIELD_StBegVBez.add(result);
                break;
            }
            case 103545: 
            case 770020: 
            case 770025: 
            case 770030: 
            case 770035: 
            case 770040: 
            case 770045: {
                this.FIELD_StFreiArbgZuschGesKV = this.FIELD_StFreiArbgZuschGesKV.add(result);
                break;
            }
            case 770120: 
            case 770130: 
            case 770140: {
                this.FIELD_StFreiArbgZuschPrivKV = this.FIELD_StFreiArbgZuschPrivKV.add(result);
                break;
            }
            case 771020: 
            case 771030: 
            case 771040: 
            case 771120: 
            case 771130: 
            case 771140: {
                this.FIELD_StFreiArbgZuschGesPV = this.FIELD_StFreiArbgZuschGesPV.add(result);
                break;
            }
            case 329510: 
            case 329512: 
            case 329514: 
            case 329520: 
            case 329560: 
            case 329610: 
            case 329620: 
            case 329640: 
            case 329730: 
            case 329740: {
                if (!this.check100PercentAGBeitrag(valueposition, beginDate) || this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                for (Period month : new Period(beginDate, endDate)) {
                    if (this.isVersicherungsfreierAltersvollrentner(valueposition.oidemployee, month.from)) continue;
                    this.FIELD_AGAGesRV = this.FIELD_AGAGesRV.add(result1Month);
                }
                break;
            }
            case 775510: 
            case 775514: 
            case 775560: 
            case 775610: 
            case 775630: 
            case 775640: 
            case 775730: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                for (Period month : new Period(beginDate, endDate)) {
                    if (this.isVersicherungsfreierAltersvollrentner(valueposition.oidemployee, month.from)) continue;
                    this.FIELD_AGABerufVersorg = this.FIELD_AGABerufVersorg.add(result1Month);
                }
                break;
            }
            case 103595: 
            case 328510: 
            case 328512: 
            case 328514: 
            case 328550: 
            case 328610: 
            case 328630: 
            case 328730: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.FIELD_ANAGesRV = this.FIELD_ANAGesRV.add(result);
                break;
            }
            case 322510: 
            case 322514: 
            case 322516: 
            case 322518: 
            case 322610: 
            case 322616: 
            case 322630: 
            case 322636: 
            case 322730: 
            case 322736: 
            case 351510: 
            case 351516: 
            case 750300: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(result);
                break;
            }
            case 770000: 
            case 770005: {
                this.FIELD_KV_ANA = this.FIELD_KV_ANA.add(result);
                this.mKVFreiwBeitrag = this.mKVFreiwBeitrag.add(result);
                break;
            }
            case 750200: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.FIELD_KV_ANA = this.FIELD_KV_ANA.subtract(result);
                break;
            }
            case 334510: 
            case 334514: 
            case 334610: 
            case 334630: 
            case 334730: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.FIELD_AV_ANA = this.FIELD_AV_ANA.add(result);
                break;
            }
            case 340510: 
            case 340514: 
            case 340516: 
            case 340518: 
            case 340610: 
            case 340616: 
            case 340630: 
            case 340636: 
            case 340730: 
            case 340736: 
            case 355510: 
            case 355516: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(result);
                break;
            }
            case 771000: {
                this.FIELD_PV_ANA = this.FIELD_PV_ANA.add(result);
                this.mPVFreiwBeitrag = this.mPVFreiwBeitrag.add(result);
                break;
            }
            case 230510: {
                this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                if (this.mYearInt < 2025) break;
                this.FIELD_KurzArbGeldAnteilig = this.FIELD_KurzArbGeldAnteilig.add(result);
                break;
            }
            case 150526: {
                if (!DateHelper.before((Date)endDate, (Date)new VDate(2022, 0, 1).getDate())) break;
                this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                break;
            }
            case 103500: 
            case 400100: 
            case 400400: 
            case 695200: 
            case 695500: {
                this.FIELD_KurzArbGeld = this.FIELD_KurzArbGeld.add(result);
                break;
            }
            case 104710: 
            case 104720: 
            case 104730: {
                if (!DateHelper.before((Date)endDate, (Date)new VDate(2026, 0, 1).getDate())) break;
                this.FIELD_Priv_KV_PV = this.FIELD_Priv_KV_PV.add(result);
                break;
            }
            case 250610: {
                this.FIELD_Kammerbeitrag_Saarland = this.FIELD_Kammerbeitrag_Saarland.add(result);
                break;
            }
            case 111320: {
                this.FIELD_ANA_Zusatzversorgung = this.FIELD_ANA_Zusatzversorgung.add(result);
                break;
            }
            case 111310: {
                this.FIELD_AGA_Zusatzversorgung = this.FIELD_AGA_Zusatzversorgung.add(result);
                break;
            }
            case 111140: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mSteuerfreiZVKUmlageAGA = this.mSteuerfreiZVKUmlageAGA.add(result);
                break;
            }
            case 111240: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mPauschalsteuerpflichtigZVKUmlageAGA = this.mPauschalsteuerpflichtigZVKUmlageAGA.add(result);
                break;
            }
            case 111340: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mSteuerpflichtigZVKUmlageAGA = this.mSteuerpflichtigZVKUmlageAGA.add(result);
                break;
            }
            case 111540: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mBeitragspflichtigZVKUmlageAGA = this.mBeitragspflichtigZVKUmlageAGA.add(result);
                break;
            }
            case 321050: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mGesamtesKVEntgelt = this.mGesamtesKVEntgelt.add(result);
                break;
            }
            case 327050: 
            case 773050: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mGesamtesRVEntgelt = this.mGesamtesRVEntgelt.add(result);
                break;
            }
            case 333050: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mGesamtesAVEntgelt = this.mGesamtesAVEntgelt.add(result);
                break;
            }
            case 339050: {
                if (this.mHasDBAorATE && this.isDbaOrAteVP(valueposition)) break;
                this.mGesamtesPVEntgelt = this.mGesamtesPVEntgelt.add(result);
            }
        }
    }

    private static BigDecimal toScale2(BigDecimal bigDecimal) {
        return LStBHelper.toScale2((BigDecimal)bigDecimal);
    }

    private static BigDecimal toScale(int scale, BigDecimal bigDecimal) {
        return LStBHelper.toScale((int)scale, (BigDecimal)bigDecimal);
    }

    protected abstract void getTaxValues(List<TaxContainer> var1, List<WageTaxCertificateInsuranceSubBean> var2, Date var3, Date var4) throws BusinessDomainException;

    private static Map<String, List<EmploymentallContainer>> queryHashMapEmploymentAll(Collection<String> oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<EmploymentallContainer>> employmentAllMap = new HashMap<String, List<EmploymentallContainer>>();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
        List inRestrictions = PRestrictions.in((String)"oidemployee", oidEmployees);
        for (Criterion inRestriction : inRestrictions) {
            PersistencyDataSet employmentAllDatas = daoEmploymentall.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
            while (employmentAllDatas.hasNext()) {
                EmploymentallContainer employmentAllContainer = (EmploymentallContainer)employmentAllDatas.getNext();
                ArrayList<EmploymentallContainer> liste = (ArrayList<EmploymentallContainer>)employmentAllMap.get(employmentAllContainer.oidemployee);
                if (liste == null) {
                    liste = new ArrayList<EmploymentallContainer>();
                    employmentAllMap.put(employmentAllContainer.oidemployee, liste);
                }
                liste.add(employmentAllContainer);
            }
        }
        return employmentAllMap;
    }

    private static Map<String, List<InsuranceallContainer>> queryHashMapInsuranceall(Collection<String> oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<InsuranceallContainer>> insuranceAllMap = new HashMap<String, List<InsuranceallContainer>>();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
        List inRestrictions = PRestrictions.in((String)"oidemployee", oidEmployees);
        for (Criterion inRestriction : inRestrictions) {
            PersistencyDataSet insuranceAllDatas = daoInsuranceall.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
            while (insuranceAllDatas.hasNext()) {
                InsuranceallContainer insuranceAllContainer = (InsuranceallContainer)insuranceAllDatas.getNext();
                ArrayList<InsuranceallContainer> liste = (ArrayList<InsuranceallContainer>)insuranceAllMap.get(insuranceAllContainer.oidemployee);
                if (liste == null) {
                    liste = new ArrayList<InsuranceallContainer>();
                    insuranceAllMap.put(insuranceAllContainer.oidemployee, liste);
                }
                liste.add(insuranceAllContainer);
            }
        }
        return insuranceAllMap;
    }

    private static Map<String, List<ComptaxofficeallContainer>> queryHashMapCompanyTaxOfficeAll(Collection<String> oidPCompanys, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<ComptaxofficeallContainer>> comptaxofficeallMap = new HashMap<String, List<ComptaxofficeallContainer>>();
        PersistencyDataSet comptaxofficeallDatas = daoComptaxofficeall.getDataSet(new Order[]{Order.asc((String)"oidpcompany"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidpcompany", oidPCompanys), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))}));
        while (comptaxofficeallDatas.hasNext()) {
            ComptaxofficeallContainer comptaxofficeallContainer = (ComptaxofficeallContainer)comptaxofficeallDatas.getNext();
            ArrayList<ComptaxofficeallContainer> liste = (ArrayList<ComptaxofficeallContainer>)comptaxofficeallMap.get(comptaxofficeallContainer.oidpcompany);
            if (liste == null) {
                liste = new ArrayList<ComptaxofficeallContainer>();
                comptaxofficeallMap.put(comptaxofficeallContainer.oidpcompany, liste);
            }
            liste.add(comptaxofficeallContainer);
        }
        return comptaxofficeallMap;
    }

    private static Map<String, List<TaxContainer>> queryHashMapTax(Collection<String> oidEmployees, Date forEffectiveDate, Date listFirstDate, Date listEndDate) {
        HashMap<String, List<TaxContainer>> taxMap = new HashMap<String, List<TaxContainer>>();
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)forEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)forEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)listEndDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)listFirstDate))});
        List inRestrictions = PRestrictions.in((String)"oidemployee", oidEmployees);
        for (Criterion inRestriction : inRestrictions) {
            PersistencyDataSet taxDatas = daoTax.getDataSet(new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"validfrom")}, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
            while (taxDatas.hasNext()) {
                TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                ArrayList<TaxContainer> liste = (ArrayList<TaxContainer>)taxMap.get(taxContainer.oidemployee);
                if (liste == null) {
                    liste = new ArrayList<TaxContainer>();
                    taxMap.put(taxContainer.oidemployee, liste);
                }
                liste.add(taxContainer);
            }
        }
        return taxMap;
    }

    private MultiKeyMap2<String, Date, Date> queryRRBeginnMap(Collection<String> oidEmployees, Date[] effectiveDates) {
        MultiKeyHashMap2 rrBeginnMap = new MultiKeyHashMap2();
        Date minEffectiveDate = DateHelper.min((Date[])effectiveDates);
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)minEffectiveDate))), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.lt((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate)))});
        List inRestrictions = PRestrictions.in((String)"oidemployee", oidEmployees);
        for (Criterion inRestriction : inRestrictions) {
            PersistencyDataSet calculationbasicDatas = daoCalculationbasic.getDataSet(null, Restrictions.and((Criterion)inRestriction, (Criterion)filter));
            while (calculationbasicDatas.hasNext()) {
                CalculationbasicContainer container = (CalculationbasicContainer)calculationbasicDatas.getNext();
                Date validFrom = container.validfrom;
                if (!DateHelper.before((Date)validFrom, (Date)container.effectivefrom)) continue;
                String oidEmployee = container.oidemployee;
                for (Date effectiveDate : effectiveDates) {
                    if (!DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)container.effectivefrom), (Date)effectiveDate)) continue;
                    Date date = (Date)rrBeginnMap.get((Object)oidEmployee, (Object)effectiveDate);
                    rrBeginnMap.put((Object)oidEmployee, (Object)effectiveDate, (Object)PDateHelper.minIgnoringNulls((Date[])new Date[]{date, validFrom}));
                }
            }
        }
        return rrBeginnMap;
    }

    public abstract Map<String, Object> getParameters();

    protected WageTaxCertificatePrintBean createPrintBean() {
        WageTaxCertificatePrintBean bean = new WageTaxCertificatePrintBean();
        bean.Field_WageTaxCertificateSubReport = this.mSubReport.getSubReportList();
        bean.addressFieldBeans = this.mAddressFieldBeans;
        bean.Field_EmployeeETIN = this.mEmployeeETIN;
        bean.Field_EmployeeIdentNr = this.mEmployeeIDENT;
        bean.pcompanykey = this.mPCompanyKey;
        bean.plantkey = this.mPlantKey;
        bean.datum = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mActualDate);
        bean.pers_nr = this.mEmployeePersonnelNumberForPrint;
        bean.geb_dat = StringMapper.isNullString((String)this.mEmployeeDateOfBirthELSTAM) ? DateMapper.toDDMMYYYYPointSeparationString((Date)this.mEmployeeDateOfBirth) : this.mEmployeeDateOfBirthELSTAM;
        bean.dienst_dat_von = DateMapper.toDDMMPointSeparationString((Date)this.mEmploymentStartDate) + ".";
        bean.dienst_dat_bis = DateMapper.toDDMMPointSeparationString((Date)this.mEmploymentEndDate) + ".";
        bean.u_anz = this.mEmployerHolidaysCount;
        bean.z_2B = this.mCapitalLetters.toString();
        bean.z_3 = this.FIELD_z_3_arbeitslohn_brutto;
        bean.z_4 = this.FIELD_LSteuer;
        bean.z_5 = this.FIELD_SolZ;
        bean.z_6 = this.FIELD_KiStAN;
        bean.z_7 = this.FIELD_KiStEG;
        bean.z_8 = this.FIELD_StBegVBez;
        bean.z_9 = this.FIELD_StBegVBezMKalJahr;
        bean.z_10 = this.FIELD_ErmStBetrMKalJahr;
        bean.z_11 = this.FIELD_LSteuerMKalendJahr;
        bean.z_12 = this.FIELD_SolZMKalJahr;
        bean.z_13 = this.FIELD_KiStANMKalJahr;
        bean.z_14 = this.FIELD_KiStEGMKalJahr;
        bean.z_15 = this.FIELD_KurzArbGeld;
        bean.z_15a = this.FIELD_KurzArbGeldAnteilig;
        bean.z_16A = this.FIELD_StFreiArbLohnDBA;
        bean.z_16B = this.FIELD_StFreiArbLohnATE;
        bean.z_17 = this.FIELD_StFreiAGLeistg;
        bean.z_18 = this.FIELD_PauschAGLsitg;
        bean.z_19 = this.FIELD_StPflichtEntschArbLohnMKalJahr;
        bean.z_20 = this.FIELD_StFreiVerpfleg;
        bean.z_21 = this.FIELD_StFreiDopHaushalt;
        bean.z_22a = this.FIELD_AGAGesRV;
        bean.z_22b = this.FIELD_AGABerufVersorg;
        bean.z_23a = this.FIELD_ANAGesRV;
        bean.z_23b = this.FIELD_ANABerufVersorg;
        bean.z_24a = this.FIELD_StFreiArbgZuschGesKV;
        bean.z_24b = this.FIELD_StFreiArbgZuschPrivKV;
        bean.z_24c = this.FIELD_StFreiArbgZuschGesPV;
        bean.z_25 = this.FIELD_KV_ANA;
        bean.z_26 = this.FIELD_PV_ANA;
        bean.z_27 = this.FIELD_AV_ANA;
        bean.z_28 = this.FIELD_Priv_KV_PV;
        bean.z_29 = this.getZ29();
        bean.z_30 = this.getZ30();
        bean.z_31 = this.getZ31();
        bean.z_32 = this.getZ32();
        bean.z_33 = this.FIELD_AusgezKiGeld;
        bean.z_34 = this.FIELD_FreibetragDBATuerkei;
        bean.zusatz_betrag = this.FIELD_Zusatzbetrag;
        bean.zusatz_text = this.FIELD_Zusatztext;
        bean.ag_bez = this.mEmployerDescription;
        bean.ag_str_nr = this.mEmployerStreetStreetNumber;
        bean.ag_plz = this.mEmployerPostalCode;
        bean.ag_ort = this.mEmployerCity;
        bean.Field_EmployerTaxNumber = this.mEmployerTaxNumber;
        bean.Field_EmployerStateTag = this.mEmployerStateTag;
        bean.finanzamt_bez = this.mEmployerWageTaxOfficeDescription;
        bean.Field_EmployeeWageTaxOfficeDescription = this.mEmployeeWageTaxOfficeDescription;
        bean.Field_EmployeeWageTaxOfficeNumber = this.mEmployeeWageTaxOfficeNumber;
        bean.finanzamt_nr = this.mWageTaxOfficeNumber;
        bean.Field_Year = this.mYear;
        bean.archi_string = this.getArchiString();
        bean.transferticket = "";
        bean.stornoKorrektur = "";
        return bean;
    }

    public Object getFieldValue(JRField field) {
        String fieldName = field.getName();
        Object value = this.currentBean.getField(fieldName);
        if (value instanceof BigDecimal) {
            value = LStBHelper.toCurrencyFormatCentEuroSeparated((BigDecimal)((BigDecimal)value));
        }
        return value;
    }

    protected BigDecimal getZ29() {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_BemGrundVersFreiBetrag) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez)) {
            return this.FIELD_BemGrundVersFreiBetrag;
        }
        return null;
    }

    protected String getZ30() {
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_BemGrundVersFreiBetrag) || BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBezMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez))) {
            return this.FIELD_VersBezMonatKalJahr + NONBREAKING_SPACES;
        }
        return null;
    }

    protected String getZ31() {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_BemGrundVersFreiBetrag) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez)) {
            return this.FIELD_VBZBeginnEnde + NONBREAKING_SPACES;
        }
        return null;
    }

    protected BigDecimal getZ32() {
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_BemGrundVersFreiBetrag) && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez)) {
            return this.FIELD_SterbegeldVBZNachzahl;
        }
        return null;
    }

    protected String getArchiString() {
        ArchivingMetadata am = new ArchivingMetadata();
        am.setCompanyKey(this.mPCompanyKey);
        am.setValidFrom(this.mListFirstDate);
        am.setValidUntil(this.mListEndDate);
        am.setName(this.mEmployeeName + ", " + this.mEmployeeFirstName);
        am.setPersonnelNumber(this.mEmployeePersonnelNumber);
        am.setTaxNumber(this.mEmployerTaxNumber);
        am.setReportName(WageTaxCertificateDataSource2016.getReportName());
        am.setUserID(SessionContext.getInstance().getSession().getUserCode());
        return am.getArchiString();
    }

    protected void perfidiaWriteWhileIsNext() throws BusinessDomainException, IOException {
        String LstbNachlaufSatz = this.writeLstbNachlaufSatz();
        this.mDateiEinschreiben.write(LstbNachlaufSatz);
        this.mDateiEinschreiben.close();
        SessionContext.getInstance().getPersistencySession().flush();
        this.mReportDataTransfer.setValue();
        this.perfidiaCreateNewFileAndVorlaufSatz();
        this.mEmployeeCountOfGroup = 0;
    }

    protected void perfidiaCreateNewFileAndVorlaufSatz() throws BusinessDomainException, IOException {
        this.initNewFile();
        this.mDateiEinschreiben.write(this.writeLstbVorlaufSatz());
    }

    private void initNewFile() throws BusinessDomainException {
        String fileNumber = this.mReportDataTransfer.getWageTaxCertificateFileNumber();
        int fileNum = Integer.parseInt(fileNumber);
        File destinationFile = this.mReportDataTransfer.createFile(fileNum);
        this.mFileNumbers.add(fileNum + 1);
        this.mDateiEinschreiben = this.mPerfidiaResult.initPerfidiaFile(destinationFile);
    }

    private String writeLstbVorlaufSatz() throws BusinessDomainException {
        if (this.mUser == null || StringMapper.isNullString((String)this.mUser.getEmail())) {
            throw WTCExceptionMapper.makeUserEmailMissedDomainException();
        }
        if (StringMapper.isNullString((String)this.mUser.getPhone())) {
            throw WTCExceptionMapper.makeUserPhoneMissedDomainException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)LSTB_KENNUNG_VORLAUFSATZ, (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)LSTB_VERSION_VORLAUFSATZ, (int)2));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)this.LSTB_MERKER, (int)9));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)LSTB_HERSTELLERID, (int)5));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)LSTB_PRODUKTNAME, (int)50));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mVersion, (int)50));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerDescription, (int)60));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerStreetStreetNumber, (int)33));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerPostalCode, (int)10));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerCity, (int)34));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerStateDescription, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getName(), (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getPhone(), (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getEmail(), (int)64));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerDescription, (int)60));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerStreetStreetNumber, (int)33));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerPostalCode, (int)10));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerCity, (int)34));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mEmployerStateDescription, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getName(), (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getPhone(), (int)20));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)this.mUser.getEmail(), (int)64));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)this.mReportDataTransfer.getEncodingNumeric(this.mPerfidiaResult.getEncoding()), (int)2));
        String fileContent = this.mPCompanyKey + " / " + DateMapper.toYYYYString((Date)this.mListEndDate) + "." + DateMapper.toDDMMYYYYString((Date)this.mListEndDate).substring(2, 4);
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)fileContent, (int)30));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)7478));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    protected static String writeLstbPersonnelSatz(LStB lStB) {
        StringBuilder stringBuilder = new StringBuilder();
        WageTaxCertificateDataSource2016.append(stringBuilder, 6, PerfidiaTyp.an, lStB.getKennung());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVersionsNr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.an, lStB.getEmpfaenger());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getLStBArt());
        WageTaxCertificateDataSource2016.append(stringBuilder, 6, PerfidiaTyp.n, lStB.getLStBVersion());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getDauerJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getDauerVon());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getDauerBis());
        WageTaxCertificateDataSource2016.append(stringBuilder, 14, PerfidiaTyp.an, lStB.getETIN());
        WageTaxCertificateDataSource2016.append(stringBuilder, 11, PerfidiaTyp.an, lStB.getIdNr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getOrdnungsmerkmal());
        WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.an, lStB.getPersGeschlecht());
        WageTaxCertificateDataSource2016.append(stringBuilder, 30, PerfidiaTyp.an, lStB.getPersNachname());
        WageTaxCertificateDataSource2016.append(stringBuilder, 30, PerfidiaTyp.an, lStB.getPersVorname());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getPersNamensvorsatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getPersNamenszusatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getPersTitel());
        WageTaxCertificateDataSource2016.append(stringBuilder, 30, PerfidiaTyp.an, lStB.getPersGebName());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getPersGebNamensvorsatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getPersGebNamenszusatz());
        String geburtsdatum = StringMapper.isNullString((String)lStB.getPersMelderechtlichesGeburtsdatum()) ? DateMapper.toYYYYMMDDString((Date)lStB.getPersGeburtsdatum()) : WageTaxCertificateDataSource2016.toYYYYMMDDString(lStB.getPersMelderechtlichesGeburtsdatum());
        WageTaxCertificateDataSource2016.append(stringBuilder, 8, PerfidiaTyp.n, geburtsdatum);
        WageTaxCertificateDataSource2016.append(stringBuilder, 33, PerfidiaTyp.an, lStB.getPersAdrStr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 9, PerfidiaTyp.n, lStB.getPersAdrHausnummer());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.an, lStB.getPersAdrHNrZusatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 40, PerfidiaTyp.an, lStB.getPersAdrAnschriftenzusatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 34, PerfidiaTyp.an, lStB.getPersAdrOrt());
        WageTaxCertificateDataSource2016.append(stringBuilder, 5, PerfidiaTyp.n, lStB.getPersAdrPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 3, PerfidiaTyp.an, lStB.getPersAdrAuslandLaenderkennzeichen());
        WageTaxCertificateDataSource2016.append(stringBuilder, 10, PerfidiaTyp.an, lStB.getPersAdrAuslandPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 8, PerfidiaTyp.n, lStB.getPersAdrPostfach());
        WageTaxCertificateDataSource2016.append(stringBuilder, 5, PerfidiaTyp.n, lStB.getPersAdrPostfachPLZ());
        BigDecimal[] beitrPKV = new BigDecimal[12];
        BigDecimal[] beitrbasisPKV = new BigDecimal[12];
        LStBMonat[] lStBMonate = lStB.getLStBMonate();
        for (int i = 0; i <= 11; ++i) {
            if (i < lStBMonate.length) {
                LStBMonat lStBMonat = lStBMonate[i];
                WageTaxCertificateDataSource2016.append(stringBuilder, 8, PerfidiaTyp.n, DateMapper.toYYYYMMDDString((Date)lStBMonat.getElstamGueltigAb()));
                WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.n, lStBMonat.getSteuerklasse());
                WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.d3, lStBMonat.getFaktor());
                WageTaxCertificateDataSource2016.append(stringBuilder, 3, PerfidiaTyp.d1, lStBMonat.getKinder());
                WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.an, lStBMonat.getKiStAbzugKonfession());
                WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.an, lStBMonat.getKiStAbzugEhegatteKonfession());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getSteuerfreibetragJahr());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getSteuerfreibetragMonat());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getSteuerfreibetragWoche());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getSteuerfreibetragTag());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getHinzurechnungsbetragJahr());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getHinzurechnungsbetragMonat());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getHinzurechnungsbetragWoche());
                WageTaxCertificateDataSource2016.append(stringBuilder, 12, PerfidiaTyp.d2, lStBMonat.getHinzurechnungsbetragTag());
                beitrPKV[i] = lStBMonat.getBeitragpkvppv();
                beitrbasisPKV[i] = lStBMonat.getBeitragbasispkvppv();
                continue;
            }
            WageTaxCertificateDataSource2016.append(stringBuilder, 8, PerfidiaTyp.n, 0);
            WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.an, "");
            WageTaxCertificateDataSource2016.append(stringBuilder, 107, PerfidiaTyp.n, 0);
            beitrPKV[i] = BigDecimal.ZERO;
            beitrbasisPKV[i] = BigDecimal.ZERO;
        }
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getAnzahlU());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getBruttoArbLohn());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getLSteuer());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getSoli());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnKiSteuer());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getEhegKiSteuer());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getErmStBetrMKalJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getLSteuerMKalJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getSoliMKalJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKiSteuerArbnMKalJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKiSteuerEhegMKalJahr());
        if (Integer.parseInt(lStB.getDauerJahr()) >= 2025) {
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKurzArbGeldAnteilig());
        } else {
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKurzArbGeld());
        }
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiArbLohnDBA());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiArbLohnATE());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiArbgLeistg());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getPauschArbgLeistg());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStPflichtArbLohnMKalJahr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiVerpfleg());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiDopHaushalt());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getAusgezKinderGeld());
        WageTaxCertificateDataSource2016.append(stringBuilder, 30, PerfidiaTyp.an, lStB.getGrossbuchstaben());
        for (LStBWert lStBWert : lStB.getLStBWerte()) {
            WageTaxCertificateDataSource2016.append(stringBuilder, 60, PerfidiaTyp.an, lStBWert.getWertName());
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStBWert.getWert());
        }
        int anzahlFreierSaetze = 10;
        for (int i = lStB.getLStBWerte().length; i < 10; ++i) {
            WageTaxCertificateDataSource2016.append(stringBuilder, 60, PerfidiaTyp.an, "");
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, ZERO2);
        }
        int anzahlFreierTexte = 10;
        for (int i = 0; i < 10; ++i) {
            WageTaxCertificateDataSource2016.append(stringBuilder, 60, PerfidiaTyp.an, "");
            WageTaxCertificateDataSource2016.append(stringBuilder, 200, PerfidiaTyp.an, "");
        }
        WageTaxCertificateDataSource2016.append(stringBuilder, 60, PerfidiaTyp.an, lStB.getArbgName());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getArbgFANr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 100, PerfidiaTyp.an, lStB.getArbgFAName());
        WageTaxCertificateDataSource2016.append(stringBuilder, 13, PerfidiaTyp.n, lStB.getArbgStNr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 33, PerfidiaTyp.an, lStB.getArbgAdrStr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 9, PerfidiaTyp.n, lStB.getArbgAdrHausnummer());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.an, lStB.getArbgAdrHNrZusatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 40, PerfidiaTyp.an, lStB.getArbgAdrAnschriftenzusatz());
        WageTaxCertificateDataSource2016.append(stringBuilder, 34, PerfidiaTyp.an, lStB.getArbgAdrOrt());
        WageTaxCertificateDataSource2016.append(stringBuilder, 5, PerfidiaTyp.n, lStB.getArbgAdrPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 5, PerfidiaTyp.n, lStB.getArbgAdrGKPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 3, PerfidiaTyp.an, lStB.getArbgAdrAuslandLaenderkennzeichen());
        WageTaxCertificateDataSource2016.append(stringBuilder, 10, PerfidiaTyp.an, lStB.getArbgAdrAuslandPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 8, PerfidiaTyp.n, lStB.getArbgAdrPostfach());
        WageTaxCertificateDataSource2016.append(stringBuilder, 5, PerfidiaTyp.n, lStB.getArbgAdrPostfachPLZ());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.n, lStB.getPersNr());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbgAnteilRenVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilRenVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 34, PerfidiaTyp.an, lStB.getPersAdrPostfachort());
        WageTaxCertificateDataSource2016.append(stringBuilder, 34, PerfidiaTyp.an, lStB.getArbgAdrPostfachort());
        WageTaxCertificateDataSource2016.append(stringBuilder, 38, PerfidiaTyp.an, lStB.getPersAdrVermerk1(), true);
        WageTaxCertificateDataSource2016.append(stringBuilder, 38, PerfidiaTyp.an, lStB.getPersAdrVermerk2(), true);
        WageTaxCertificateDataSource2016.append(stringBuilder, 38, PerfidiaTyp.an, lStB.getPersAdrVermerk3(), true);
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getErmStVbezMKalenderjahr1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getErmStVbezMKalenderjahrJahr1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getErmStVbezMKalenderjahr2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getErmStVbezMKalenderjahrJahr2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getErmStVbezMKalenderjahr3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getErmStVbezMKalenderjahrJahr3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getErmStVbezMKalenderjahr4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getErmStVbezMKalenderjahrJahr4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBez1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getVBezJahr1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezBeginn1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezEnde1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezBMGFreibetrag1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezEinmVersbezug1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBez2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getVBezJahr2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezBeginn2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezEnde2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezBMGFreibetrag2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezEinmVersbezug2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBez3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getVBezJahr3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezBeginn3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezEnde3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezBMGFreibetrag3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezEinmVersbezug3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBez4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.n, lStB.getVBezJahr4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezBeginn4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 2, PerfidiaTyp.n, lStB.getVBezEnde4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezBMGFreibetrag4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getVBezEinmVersbezug4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKammerbeitragHB());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKammerbeitragSL());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilWBUmlage());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbgAnteilZusatzVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilZusatzVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 3, PerfidiaTyp.an, lStB.getAnzahlArbeitstage());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiFahrtkAusw());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilKrankVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilPflegVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilArblVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getBeitrPrKrankVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getNErmStVBezMKalenderjahr1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.an, lStB.getNErmStVBezMKalenderjahrJahr1());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getNErmStVBezMKalenderjahr2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.an, lStB.getNErmStVBezMKalenderjahrJahr2());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getNErmStVBezMKalenderjahr3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.an, lStB.getNErmStVBezMKalenderjahrJahr3());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getNErmStVBezMKalenderjahr4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 4, PerfidiaTyp.an, lStB.getNErmStVBezMKalenderjahrJahr4());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbgAnteilBerufsVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getArbnAnteilBerufsVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiArbgZuschBerufsVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 20, PerfidiaTyp.an, lStB.getSortiermerkmal());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiGeKrankVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiPrKrankVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getStFreiGePflegeVers());
        WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getFreibetragDBATuerkei());
        WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.an, TypeOfInstructionEnumMapper.toPerfidiaString((TypeOfInstructionEnum)lStB.getTypeOfInstruction()));
        WageTaxCertificateDataSource2016.append(stringBuilder, 100, PerfidiaTyp.an, lStB.getKmId());
        WageTaxCertificateDataSource2016.append(stringBuilder, 100, PerfidiaTyp.an, lStB.getRefKmId());
        if (Integer.parseInt(lStB.getDauerJahr()) >= 2026) {
            if (lStB.getTypeOfInstruction() == TypeOfInstructionEnum.TOI_Korrektur) {
                WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.n, 1);
            } else {
                WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.n, 0);
            }
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKurzArbGeld());
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[0]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[0]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[1]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[1]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[2]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[2]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[3]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[3]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[4]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[4]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[5]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[5]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[6]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[6]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[7]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[7]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[8]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[8]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[9]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[9]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[10]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[10]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrPKV[11]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, beitrbasisPKV[11]);
            WageTaxCertificateDataSource2016.append(stringBuilder, 889, PerfidiaTyp.an, "");
        } else if (Integer.parseInt(lStB.getDauerJahr()) >= 2025) {
            if (lStB.getTypeOfInstruction() == TypeOfInstructionEnum.TOI_Korrektur) {
                WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.n, 1);
            } else {
                WageTaxCertificateDataSource2016.append(stringBuilder, 1, PerfidiaTyp.n, 0);
            }
            WageTaxCertificateDataSource2016.append(stringBuilder, 15, PerfidiaTyp.d2, lStB.getKurzArbGeld());
            WageTaxCertificateDataSource2016.append(stringBuilder, 1249, PerfidiaTyp.an, "");
        } else {
            WageTaxCertificateDataSource2016.append(stringBuilder, 1265, PerfidiaTyp.an, "");
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    private static String toYYYYMMDDString(String datum) {
        if (datum.length() != 10 || datum.charAt(2) != '.' || datum.charAt(5) != '.') {
            throw new IllegalArgumentException("Datum " + datum + " hat nicht die korrekte Form.");
        }
        return datum.substring(6) + datum.substring(3, 5) + datum.substring(0, 2);
    }

    protected LStB createLStB(EmployeeWageTaxCertificateBean eWT, LStBAccount refLStBAccount) throws BusinessDomainException {
        LStBAccount lStBAccount = this.createLStBAccount(eWT);
        lStBAccount.setValidFrom(this.mEmploymentStartDate);
        lStBAccount.setValidUntil(this.mEmploymentEndDate);
        lStBAccount.setCancelflag(LStBAccount.CancelFlag.Normal);
        if (refLStBAccount == null) {
            lStBAccount.setTypeOfInstruction(TypeOfInstructionEnum.TOI_Neu);
            lStBAccount.setReferenzKmId("");
        } else {
            lStBAccount.setTypeOfInstruction(TypeOfInstructionEnum.TOI_Korrektur);
            lStBAccount.setReferenzKmId(refLStBAccount.getKmId());
        }
        lStBAccount.check();
        LStB lStB = new LStB(lStBAccount);
        lStB.setVersionsNr(LSTB_VERSION_PersonalSatz);
        lStB.setEmpfaenger(this.mEmployeeShortDescSocialInsuranceLaw);
        lStB.setLStBArt(LSTB_ART);
        lStB.setLStBVersion(this.LSTB_VERSION);
        lStB.setDauerJahr(this.mYear);
        lStB.setDauerVon(this.DATEFORMAT_TTMM.format(lStBAccount.getValidFrom()));
        lStB.setDauerBis(this.DATEFORMAT_TTMM.format(lStBAccount.getValidUntil()));
        lStB.setETIN(lStBAccount.getETIN());
        lStB.setIdNr(lStBAccount.getIdNr());
        lStB.setOrdnungsmerkmal(lStBAccount.getOrdnungsmerkmal());
        lStB.setPersGeschlecht(this.mEmployeeSex);
        lStB.setPersNachname(lStBAccount.getSurname());
        lStB.setPersVorname(lStBAccount.getFirstname());
        lStB.setPersNamensvorsatz(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeNamePrefix, 20));
        lStB.setPersNamenszusatz(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeNameAffix, 20));
        lStB.setPersTitel(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeTitle, 20));
        lStB.setPersGebName("");
        lStB.setPersGebNamensvorsatz("");
        lStB.setPersGebNamenszusatz("");
        lStB.setPersGeburtsdatum(this.mEmployeeDateOfBirth);
        lStB.setPersMelderechtlichesGeburtsdatum(this.mEmployeeDateOfBirthELSTAM);
        lStB.setPersAdrStr(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilStreet, 33));
        int positionFromStreetZusatz = WageTaxCertificateDataSource2016.getSplitPositionStreetNumberFromStreetZusatz(this.mEmployeeDomicilStreetNumber);
        lStB.setPersAdrHausnummer(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilStreetNumber.substring(0, positionFromStreetZusatz), 9));
        lStB.setPersAdrHNrZusatz(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilStreetNumber.substring(positionFromStreetZusatz, this.mEmployeeDomicilStreetNumber.length()).trim(), 15));
        lStB.setPersAdrAnschriftenzusatz(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeAdressAddendum, 40));
        lStB.setPersAdrOrt(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicile, 34));
        if (StringMapper.equal((String)"D", (String)this.mEmployeeDomicilStateTag) || StringMapper.isNullString((String)this.mEmployeeDomicilStateTag)) {
            this.mEmployeeDomicilStateTag = "D";
            lStB.setPersAdrPLZ(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilPostalCode, 5));
            lStB.setPersAdrAuslandLaenderkennzeichen("");
            lStB.setPersAdrAuslandPLZ("");
        } else {
            lStB.setPersAdrPLZ("");
            lStB.setPersAdrAuslandLaenderkennzeichen(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilStateTag, 3));
            lStB.setPersAdrAuslandPLZ(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeDomicilPostalCode, 10));
        }
        lStB.setPersAdrPostfach("");
        lStB.setPersAdrPostfachPLZ("");
        for (LStBMonat lStBMonat : this.mLStBMonate.getLStBMonate()) {
            lStBMonat.makeSaveable();
            lStBMonat.setLStB(lStB);
            lStB.addLStBMonat(lStBMonat);
        }
        lStB.setAnzahlU(WageTaxCertificateDataSource2016.maxLength(this.mEmployerHolidaysCount, 2));
        lStB.setBruttoArbLohn(this.FIELD_z_3_arbeitslohn_brutto);
        lStB.setLSteuer(this.FIELD_LSteuer);
        lStB.setSoli(this.FIELD_SolZ);
        lStB.setArbnKiSteuer(this.FIELD_KiStAN);
        lStB.setEhegKiSteuer(this.FIELD_KiStEG);
        lStB.setErmStBetrMKalJahr(this.FIELD_ErmStBetrMKalJahr);
        lStB.setLSteuerMKalJahr(this.FIELD_LSteuerMKalendJahr);
        lStB.setSoliMKalJahr(this.FIELD_SolZMKalJahr);
        lStB.setKiSteuerArbnMKalJahr(this.FIELD_KiStANMKalJahr);
        lStB.setKiSteuerEhegMKalJahr(this.FIELD_KiStEGMKalJahr);
        lStB.setKurzArbGeld(this.FIELD_KurzArbGeld);
        lStB.setKurzArbGeldAnteilig(this.FIELD_KurzArbGeldAnteilig);
        lStB.setStFreiArbLohnDBA(this.FIELD_StFreiArbLohnDBA);
        lStB.setStFreiArbLohnATE(this.FIELD_StFreiArbLohnATE);
        lStB.setStFreiArbgLeistg(this.FIELD_StFreiAGLeistg);
        lStB.setPauschArbgLeistg(this.FIELD_PauschAGLsitg);
        lStB.setStPflichtArbLohnMKalJahr(this.FIELD_StPflichtEntschArbLohnMKalJahr);
        lStB.setStFreiVerpfleg(this.FIELD_StFreiVerpfleg);
        lStB.setStFreiDopHaushalt(this.FIELD_StFreiDopHaushalt);
        lStB.setAusgezKinderGeld(this.FIELD_AusgezKiGeld);
        lStB.setGrossbuchstaben(WageTaxCertificateDataSource2016.maxLength(this.mCapitalLetters.toString(), 30));
        int n = this.mStatisticalValueTPs.size();
        assert (n == this.mStatisticalValues.size());
        for (int i = 0; i < n; ++i) {
            StatisticalValueTP statisticalValueTP = this.mStatisticalValueTPs.get(i);
            BigDecimal statisticalValue = this.mStatisticalValues.get(i);
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)statisticalValue)) continue;
            LStBWert lStBWert = new LStBWert(lStB);
            lStBWert.setLfdNr(i + 1);
            lStBWert.setWertName(statisticalValueTP.getLongDescription());
            lStBWert.setWert(statisticalValue);
            lStB.addLStBWert(lStBWert);
        }
        lStB.setArbgName(WageTaxCertificateDataSource2016.maxLength(this.mEmployerDescription, 60));
        lStB.setArbgFANr(WageTaxCertificateDataSource2016.maxLength(this.mWageTaxOfficeNumber, 4));
        lStB.setArbgFAName(WageTaxCertificateDataSource2016.maxLength(this.mEmployerWageTaxOfficeDescription, 100));
        lStB.setArbgStNr(lStBAccount.getTaxNumber());
        lStB.setArbgAdrStr(WageTaxCertificateDataSource2016.maxLength(this.mEmployerStreetStreetNumber, 33));
        lStB.setArbgAdrHausnummer("");
        lStB.setArbgAdrHNrZusatz("");
        lStB.setArbgAdrAnschriftenzusatz("");
        lStB.setArbgAdrOrt(WageTaxCertificateDataSource2016.maxLength(this.mEmployerCity, 34));
        if (StringMapper.equal((String)"D", (String)this.mEmployerStateTag)) {
            lStB.setArbgAdrPLZ(WageTaxCertificateDataSource2016.maxLength(this.mEmployerPostalCode, 5));
            lStB.setArbgAdrGKPLZ("");
            lStB.setArbgAdrAuslandLaenderkennzeichen("");
            lStB.setArbgAdrAuslandPLZ("");
        } else {
            lStB.setArbgAdrPLZ("");
            lStB.setArbgAdrGKPLZ("");
            lStB.setArbgAdrAuslandLaenderkennzeichen(WageTaxCertificateDataSource2016.maxLength(this.mEmployerStateTag, 3));
            lStB.setArbgAdrAuslandPLZ(WageTaxCertificateDataSource2016.maxLength(this.mEmployerPostalCode, 10));
        }
        lStB.setArbgAdrPostfach("");
        lStB.setArbgAdrPostfachPLZ("");
        lStB.setPersNr(WageTaxCertificateDataSource2016.maxLength(this.mEmployeePersonnelNumberForPrint, 15));
        lStB.setArbgAnteilRenVers(WageTaxCertificateDataSource2016.toScale2(this.FIELD_AGAGesRV));
        lStB.setArbnAnteilRenVers(WageTaxCertificateDataSource2016.toScale2(this.FIELD_ANAGesRV));
        lStB.setPersAdrPostfachort("");
        lStB.setArbgAdrPostfachort("");
        lStB.setPersAdrVermerk1(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeAdressAddition1, 38));
        lStB.setPersAdrVermerk2(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeAdressAddition2, 38));
        lStB.setPersAdrVermerk3(WageTaxCertificateDataSource2016.maxLength(this.mEmployeeAdressAddition3, 38));
        lStB.setErmStVbezMKalenderjahr1(WageTaxCertificateDataSource2016.toScale2(this.FIELD_StBegVBezMKalJahr));
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBezMKalJahr)) {
            lStB.setErmStVbezMKalenderjahrJahr1(WageTaxCertificateDataSource2016.maxLength(this.FIELD_VersBezMonatKalJahr, 4));
        } else {
            lStB.setErmStVbezMKalenderjahrJahr1("");
        }
        lStB.setErmStVbezMKalenderjahr2(ZERO2);
        lStB.setErmStVbezMKalenderjahrJahr2("");
        lStB.setErmStVbezMKalenderjahr3(ZERO2);
        lStB.setErmStVbezMKalenderjahrJahr3("");
        lStB.setErmStVbezMKalenderjahr4(ZERO2);
        lStB.setErmStVbezMKalenderjahrJahr4("");
        lStB.setVBez1(this.FIELD_StBegVBez);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_BemGrundVersFreiBetrag)) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBezMKalJahr) || !BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez)) {
                lStB.setVBezJahr1(WageTaxCertificateDataSource2016.maxLength(this.FIELD_VersBezMonatKalJahr, 4));
            } else {
                lStB.setVBezJahr1("");
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez)) {
                lStB.setVBezBeginn1(WageTaxCertificateDataSource2016.maxLength(this.FIELD_VBZBeginnPerfidia, 2));
                lStB.setVBezEnde1(WageTaxCertificateDataSource2016.maxLength(this.FIELD_VBZEndePerfidia, 2));
                lStB.setVBezBMGFreibetrag1(this.FIELD_BemGrundVersFreiBetrag);
                lStB.setVBezEinmVersbezug1(this.FIELD_SterbegeldVBZNachzahl);
            } else {
                lStB.setVBezBeginn1("");
                lStB.setVBezEnde1("");
                lStB.setVBezBMGFreibetrag1(ZERO2);
                lStB.setVBezEinmVersbezug1(ZERO2);
            }
        } else {
            lStB.setVBezJahr1("");
            lStB.setVBezBeginn1("");
            lStB.setVBezEnde1("");
            lStB.setVBezBMGFreibetrag1(ZERO2);
            lStB.setVBezEinmVersbezug1(ZERO2);
        }
        lStB.setVBez2(ZERO2);
        lStB.setVBezJahr2("");
        lStB.setVBezBeginn2("");
        lStB.setVBezEnde2("");
        lStB.setVBezBMGFreibetrag2(ZERO2);
        lStB.setVBezEinmVersbezug2(ZERO2);
        lStB.setVBez3(ZERO2);
        lStB.setVBezJahr3("");
        lStB.setVBezBeginn3("");
        lStB.setVBezEnde3("");
        lStB.setVBezBMGFreibetrag3(ZERO2);
        lStB.setVBezEinmVersbezug3(ZERO2);
        lStB.setVBez4(ZERO2);
        lStB.setVBezJahr4("");
        lStB.setVBezBeginn4("");
        lStB.setVBezEnde4("");
        lStB.setVBezBMGFreibetrag4(ZERO2);
        lStB.setVBezEinmVersbezug4(ZERO2);
        lStB.setKammerbeitragHB(this.FIELD_Kammerbeitrag_Bremen);
        lStB.setKammerbeitragSL(this.FIELD_Kammerbeitrag_Saarland);
        lStB.setArbnAnteilWBUmlage(ZERO2);
        lStB.setArbgAnteilZusatzVers(this.FIELD_AGA_Zusatzversorgung);
        lStB.setArbnAnteilZusatzVers(this.FIELD_ANA_Zusatzversorgung);
        lStB.setAnzahlArbeitstage("");
        lStB.setStFreiFahrtkAusw(this.FIELD_Fahrtkosten_Auswaertstaetigkeit);
        lStB.setArbnAnteilKrankVers(this.FIELD_KV_ANA);
        lStB.setArbnAnteilPflegVers(this.FIELD_PV_ANA);
        lStB.setArbnAnteilArblVers(this.FIELD_AV_ANA);
        lStB.setBeitrPrKrankVers(this.FIELD_Priv_KV_PV);
        lStB.setNErmStVBezMKalenderjahr1(ZERO2);
        lStB.setNErmStVBezMKalenderjahrJahr1("");
        lStB.setNErmStVBezMKalenderjahr2(ZERO2);
        lStB.setNErmStVBezMKalenderjahrJahr2("");
        lStB.setNErmStVBezMKalenderjahr3(ZERO2);
        lStB.setNErmStVBezMKalenderjahrJahr3("");
        lStB.setNErmStVBezMKalenderjahr4(ZERO2);
        lStB.setNErmStVBezMKalenderjahrJahr4("");
        lStB.setArbgAnteilBerufsVers(this.FIELD_AGABerufVersorg);
        lStB.setArbnAnteilBerufsVers(this.FIELD_ANABerufVersorg);
        lStB.setStFreiArbgZuschBerufsVers(ZERO2);
        lStB.setSortiermerkmal(WageTaxCertificateDataSource2016.maxLength(this.mSortiermerkmal, 20));
        lStB.setStFreiGeKrankVers(this.FIELD_StFreiArbgZuschGesKV);
        lStB.setStFreiPrKrankVers(this.FIELD_StFreiArbgZuschPrivKV);
        lStB.setStFreiGePflegeVers(this.FIELD_StFreiArbgZuschGesPV);
        lStB.setFreibetragDBATuerkei(this.FIELD_FreibetragDBATuerkei);
        lStB.setTypeOfInstruction(lStBAccount.getTypeOfInstruction());
        lStB.setKmId(lStBAccount.getKmId());
        lStB.setRefKmId(lStBAccount.getReferenzKmId());
        if (this.mYearInt >= 2025) {
            lStB.setKurzArbGeldAnteilig(this.FIELD_KurzArbGeldAnteilig);
        }
        return lStB;
    }

    protected LStB createLStBStornosatz(LStBAccount lStBAccount) throws BusinessDomainException {
        LStBAccount lStBAccountStornosatz = new LStBAccount();
        lStBAccountStornosatz.setEmployee(lStBAccount.getEmployee());
        lStBAccountStornosatz.setEffectiveFrom(this.mForEffectiveDate);
        lStBAccountStornosatz.setTaxNumber(lStBAccount.getTaxNumber());
        lStBAccountStornosatz.setValidFrom(lStBAccount.getValidFrom());
        lStBAccountStornosatz.setValidUntil(lStBAccount.getValidUntil());
        lStBAccountStornosatz.setCreatedOn(new Date());
        lStBAccountStornosatz.setTransmitted(true);
        lStBAccountStornosatz.setCancelflag(LStBAccount.CancelFlag.Stornosatz);
        lStBAccountStornosatz.setPCompany(lStBAccount.getPCompany());
        lStBAccountStornosatz.setOrdnungsmerkmal(lStBAccount.getOrdnungsmerkmal());
        lStBAccountStornosatz.setAcknowledged(false);
        lStBAccountStornosatz.setIdNr(lStBAccount.getIdNr());
        lStBAccountStornosatz.setETIN(lStBAccount.getETIN());
        lStBAccountStornosatz.setIncorrect(false);
        lStBAccountStornosatz.setManual(false);
        lStBAccountStornosatz.setTypeOfInstruction(TypeOfInstructionEnum.TOI_Storno);
        lStBAccountStornosatz.setErrorMessage("");
        lStBAccountStornosatz.setDeleted(false);
        lStBAccountStornosatz.setPersonnelnumber(lStBAccount.getPersonnelnumber());
        lStBAccountStornosatz.setSurname(lStBAccount.getSurname());
        lStBAccountStornosatz.setFirstname(lStBAccount.getFirstname());
        lStBAccountStornosatz.setReferenzKmId(lStBAccount.getKmId());
        lStBAccountStornosatz.check();
        LStB lStBStornosatz = lStBAccount.getLStB().createNew(lStBAccountStornosatz);
        lStBStornosatz.setTypeOfInstruction(lStBAccountStornosatz.getTypeOfInstruction());
        lStBStornosatz.setKmId(lStBAccountStornosatz.getKmId());
        lStBStornosatz.setRefKmId(lStBAccountStornosatz.getReferenzKmId());
        return lStBStornosatz;
    }

    private LStBAccount createLStBAccount(EmployeeWageTaxCertificateBean eWT) {
        String idNr = this.mEmployeeIDENT;
        String eTIN = this.mEmployeeETIN;
        Object ordnungsmerkmal = StringUtils.replaceChars((String)this.mPCompanyKey, (char)'-', (char)'_');
        ordnungsmerkmal = StringUtils.replaceChars((String)ordnungsmerkmal, (char)' ', (char)'_') + "/" + this.mEmployeePersonnelNumber;
        String arbeitgeberSteuernummer = this.mElsterEmployerNumber;
        String vorname = WageTaxCertificateDataSource2016.maxLength(this.mEmployeeFirstName, 30);
        String nachname = WageTaxCertificateDataSource2016.maxLength(this.mEmployeeName, 30);
        LStBAccount lStBAccount = new LStBAccount();
        lStBAccount.setEmployee(this.mReportValues.getEmployee(eWT.getOidEmployee()));
        lStBAccount.setEffectiveFrom(this.mForEffectiveDate);
        lStBAccount.setTaxNumber(arbeitgeberSteuernummer);
        lStBAccount.setCreatedOn(new Date());
        lStBAccount.setTransmitted(true);
        lStBAccount.setPCompany(PCompanyPersistencyManager.getPCompany((String)eWT.getOidPCompany()));
        lStBAccount.setOrdnungsmerkmal((String)ordnungsmerkmal);
        lStBAccount.setAcknowledged(false);
        lStBAccount.setIdNr(idNr);
        lStBAccount.setETIN(eTIN);
        lStBAccount.setIncorrect(false);
        lStBAccount.setManual(false);
        lStBAccount.setErrorMessage("");
        lStBAccount.setDeleted(false);
        lStBAccount.setPersonnelnumber(this.mEmployeePersonnelNumber);
        lStBAccount.setSurname(nachname);
        lStBAccount.setFirstname(vorname);
        return lStBAccount;
    }

    protected String writeLstbNachlaufSatz() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"NCSZ", (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)LSTB_VERSION_VORLAUFSATZ, (int)2));
        stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)Integer.toString(this.mEmployeeCountOfGroup), (int)4));
        stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)"", (int)8182));
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    protected void resetDataEmployee() {
        this.mEmployeeAdressAddition1 = "";
        this.mEmployeeAdressAddition2 = "";
        this.mEmployeeAdressAddition3 = "";
        this.mEmployeeTitle = "";
        this.mEmployeeNameAffix = "";
        this.mEmployeeNamePrefix = "";
        this.mEmployeeSex = "";
        this.mEmployeeName = "";
        this.mEmployeeFirstName = "";
        this.mSortiermerkmal = "";
        this.mEmployeeDomicilStreet = "";
        this.mEmployeeDomicilStreetNumber = "";
        this.mEmployeeDomicilPostalCode = "";
        this.mEmployeeDomicile = "";
        this.mEmployeeDomicilStateTag = "";
        this.mEmployeeAdressAddendum = "";
        this.mEmployeePersonnelNumber = 0;
        this.mEmployeePersonnelNumberForPrint = "";
        this.mEmployeeDateOfBirth = null;
        this.mEmployeeDateOfBirthELSTAM = null;
        this.mEmployeeETIN = "";
        this.mEmployeeIDENT = "";
        this.mEmployeeShortDescSocialInsuranceLaw = "";
        this.mEmploymentStartDate = null;
        this.mEmploymentEndDate = null;
        this.mCapitalLetters = new LStBCapitalLetters();
        this.mEmployerHolidaysCount = "";
        this.mEmployeeWageTaxOfficeDescription = "";
        this.mEmployeeWageTaxOfficeNumber = "";
        this.FIELD_u_anz_bigdecimal = ZERO2;
        this.FIELD_z_3_arbeitslohn_brutto = ZERO2;
        this.FIELD_LSteuer = ZERO2;
        this.FIELD_SolZ = ZERO2;
        this.FIELD_KiStAN = ZERO2;
        this.FIELD_KiStEG = ZERO2;
        this.FIELD_StBegVBez = ZERO2;
        this.FIELD_StBegVBezMKalJahr = ZERO2;
        this.FIELD_ErmStBetrMKalJahr = ZERO2;
        this.FIELD_LSteuerMKalendJahr = ZERO2;
        this.FIELD_SolZMKalJahr = ZERO2;
        this.FIELD_KiStANMKalJahr = ZERO2;
        this.FIELD_KiStEGMKalJahr = ZERO2;
        this.FIELD_KurzArbGeld = ZERO2;
        this.FIELD_KurzArbGeldAnteilig = ZERO2;
        this.FIELD_StFreiArbLohnDBA = ZERO2;
        this.FIELD_StFreiArbLohnATE = ZERO2;
        this.FIELD_StFreiAGLeistg = ZERO2;
        this.FIELD_PauschAGLsitg = ZERO2;
        this.FIELD_AGAGesRV = ZERO2;
        this.FIELD_ANAGesRV = ZERO2;
        this.FIELD_StPflichtEntschArbLohnMKalJahr = ZERO2;
        this.FIELD_StFreiVerpfleg = ZERO2;
        this.FIELD_StFreiDopHaushalt = ZERO2;
        this.FIELD_StFreiArbgZuschGesKV = ZERO2;
        this.FIELD_StFreiArbgZuschPrivKV = ZERO2;
        this.FIELD_StFreiArbgZuschGesPV = ZERO2;
        this.FIELD_KV_ANA = ZERO2;
        this.FIELD_AV_ANA = ZERO2;
        this.FIELD_PV_ANA = ZERO2;
        this.FIELD_Priv_KV_PV = ZERO2;
        this.FIELD_ANABerufVersorg = ZERO2;
        this.FIELD_AGABerufVersorg = ZERO2;
        this.FIELD_AusgezKiGeld = ZERO2;
        this.FIELD_BemGrundVersFreiBetrag = ZERO2;
        this.FIELD_VersBezMonatKalJahr = "";
        this.FIELD_VBZBeginnEnde = "";
        this.FIELD_VBZBeginnPerfidia = "";
        this.FIELD_VBZEndePerfidia = "";
        this.FIELD_SterbegeldVBZNachzahl = ZERO2;
        this.FIELD_FreibetragDBATuerkei = ZERO2;
        this.FIELD_Kammerbeitrag_Bremen = ZERO2;
        this.FIELD_Kammerbeitrag_Saarland = ZERO2;
        this.FIELD_Fahrtkosten_Auswaertstaetigkeit = ZERO2;
        this.FIELD_AGA_Zusatzversorgung = ZERO2;
        this.FIELD_ANA_Zusatzversorgung = ZERO2;
        this.mBeitragspflichtigZVKUmlageAGA = BigDecimal.ZERO;
        this.mSteuerfreiZVKUmlageAGA = BigDecimal.ZERO;
        this.mPauschalsteuerpflichtigZVKUmlageAGA = BigDecimal.ZERO;
        this.mSteuerpflichtigZVKUmlageAGA = BigDecimal.ZERO;
        this.mGesamtesKVEntgelt = BigDecimal.ZERO;
        this.mGesamtesRVEntgelt = BigDecimal.ZERO;
        this.mGesamtesAVEntgelt = BigDecimal.ZERO;
        this.mGesamtesPVEntgelt = BigDecimal.ZERO;
        this.mKVFreiwBeitrag = BigDecimal.ZERO;
        this.mPVFreiwBeitrag = BigDecimal.ZERO;
        this.FIELD_Zusatztext = new ArrayList<String>();
        this.FIELD_Zusatzbetrag = new ArrayList<String>();
        this.mStatisticalValues = new ArrayList<BigDecimal>();
        this.mSubReport = new WageTaxCertificateSubReport();
    }

    private static String queryPlantTaxOffice(String oidPlant, Date effectiveDate, Date validDate) {
        PlanttaofficeallContainer planttaofficeallContainer = new PlanttaofficeallContainer();
        PersistencyDataSet planttaofficeallDatas = daoPlanttaofficeall.getDataSet(new Order[]{Order.asc((String)"oidplant"), Order.desc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidplant", (String)oidPlant), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validDate))}));
        if (planttaofficeallDatas.hasNext()) {
            planttaofficeallContainer = (PlanttaofficeallContainer)planttaofficeallDatas.getNext();
        }
        return planttaofficeallContainer.oidtaxoffice;
    }

    private static String queryCompanyTaxOffice(String oidPCompany, Date effectiveDate, Date validDate) {
        ComptaxofficeallContainer comptaxofficeallContainer = new ComptaxofficeallContainer();
        PersistencyDataSet comptaxofficeallDatas = daoComptaxofficeall.getDataSet(new Order[]{Order.asc((String)"oidpcompany"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)oidPCompany), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validDate)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validDate))}));
        if (comptaxofficeallDatas.hasNext()) {
            comptaxofficeallContainer = (ComptaxofficeallContainer)comptaxofficeallDatas.getNext();
        }
        return comptaxofficeallContainer.oidtaxoffice;
    }

    private boolean isJournalized(Employee employee) throws BusinessDomainException {
        return WageTaxCertificateDataSource2016.getDiffInMonths(this.mListEndDate, employee.getJournalizedUntil()) <= 0;
    }

    private Master getMaster(Employee employee) {
        return this.mAddressFieldCreator.getMaster(employee);
    }

    private TaxOfficeTP getTaxOfficeTP(String taxOfficeOid, Date validDate) throws BusinessDomainException {
        TaxOffice eeTaxoffice = this.mTaxOfficeMap.get(taxOfficeOid);
        if (eeTaxoffice == null) {
            eeTaxoffice = TaxOfficePersistencyManager.getTaxOffice((String)taxOfficeOid);
            this.mTaxOfficeMap.put(taxOfficeOid, eeTaxoffice);
        }
        return eeTaxoffice.getTaxOfficeTP(this.mForEffectiveDate, validDate);
    }

    private String getStateTag(State state) throws BusinessDomainException {
        if (state == null) {
            return "D";
        }
        String oidState = state.getObjectid();
        StateTP stateTP = this.mStateTPMap.get(oidState);
        if (stateTP == null) {
            stateTP = state.getStateTP(this.mForEffectiveDate, this.mListEndDate);
            this.mStateTPMap.put(oidState, stateTP);
        }
        return stateTP.getStateTag();
    }

    private static String getEmployeeShortDescSocialInsuranceLawByTaxOfficeNumber(String taxOfficeNumber) throws BusinessDomainException {
        int bundesland = StringMapper.isNullString((String)taxOfficeNumber) ? 0 : Integer.parseInt(taxOfficeNumber.substring(0, 2));
        switch (bundesland) {
            case 28: {
                return "BW";
            }
            case 24: {
                return "HB";
            }
            case 22: {
                return "HH";
            }
            case 23: {
                return "ND";
            }
            case 27: {
                return "RP";
            }
            case 21: {
                return "SH";
            }
            case 91: 
            case 92: {
                return "BY";
            }
            case 26: {
                return "HE";
            }
            case 30: {
                return "BB";
            }
            case 51: 
            case 52: 
            case 53: {
                return "NW";
            }
            case 10: {
                return "SL";
            }
            case 40: {
                return "MV";
            }
            case 32: {
                return "SN";
            }
            case 31: {
                return "ST";
            }
            case 41: {
                return "TH";
            }
            case 11: {
                return "BE";
            }
            case 0: {
                LOGGER.debug(" Kein FederalState");
            }
        }
        return "";
    }

    private static int getSplitPositionStreetNumberFromStreetZusatz(String streetNumber) {
        int length = streetNumber.length();
        for (int i = 0; i < length; ++i) {
            char ch = streetNumber.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return i;
        }
        return 0;
    }

    private static String getReportName() {
        return "Lohnsteuerbescheinigung";
    }

    private static int getDiffInMonths(Date endDate, Date startDate) {
        return PDateHelper.getDiffInMonths((Date)endDate, (Date)startDate);
    }

    private boolean isDbaOrAteVP(ValuepositionContainer vpContainer) {
        if (this.mHasNurDBAorATE) {
            return true;
        }
        for (String oidGenesisParent : this.mDbaOrAteVPList) {
            if (!StringMapper.equal((String)vpContainer.oidgenesisparent, (String)oidGenesisParent)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOnlyNullValues(EmployeeWageTaxCertificateBean eWT) throws BusinessDomainException {
        boolean hasOnlyNullValues;
        boolean bl = hasOnlyNullValues = BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_u_anz_bigdecimal) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_z_3_arbeitslohn_brutto) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_LSteuer) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_SolZ) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KiStAN) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KiStEG) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBez) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StBegVBezMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_ErmStBetrMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_LSteuerMKalendJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_SolZMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KiStANMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KiStEGMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KurzArbGeld) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KurzArbGeldAnteilig) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiArbLohnDBA) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiArbLohnATE) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiAGLeistg) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_PauschAGLsitg) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StPflichtEntschArbLohnMKalJahr) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiVerpfleg) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiDopHaushalt) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_AGAGesRV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_ANAGesRV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiArbgZuschGesKV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiArbgZuschPrivKV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_StFreiArbgZuschGesPV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_KV_ANA) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_AV_ANA) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_PV_ANA) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Priv_KV_PV) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_ANABerufVersorg) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_AGABerufVersorg) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_AusgezKiGeld) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_SterbegeldVBZNachzahl) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Kammerbeitrag_Bremen) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Kammerbeitrag_Saarland) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_AGA_Zusatzversorgung) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_ANA_Zusatzversorgung) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_Fahrtkosten_Auswaertstaetigkeit) && BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_FreibetragDBATuerkei);
        if (hasOnlyNullValues && mWageTaxCertificateHelper.hatAnzahlUVorBescheinigungsbeginn(eWT.getEmployeeForReport(), this.mForEffectiveDate, eWT.getEmployeeStartDate())) {
            this.mEmployerHolidaysCount = "1";
            hasOnlyNullValues = false;
        }
        return hasOnlyNullValues;
    }

    public int getCountEmployeeWageTaxEFRit() {
        return this.mCountEmployeeWageTaxEFRit;
    }

    private static String toString(String s) {
        return StringMapper.isNullString((String)s) ? "" : s;
    }

    private static String maxLength(String s, int maxLength) {
        return s == null ? null : (s.length() > maxLength ? s.substring(0, maxLength) : s);
    }

    private static void append(StringBuilder stringBuilder, int fieldLength, PerfidiaTyp typ, String value) {
        switch (typ) {
            case an: {
                stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericLeftLength((String)StringMapper.toString((String)value), (int)fieldLength));
                break;
            }
            case n: {
                stringBuilder.append(ReportDataTransfer.makeToNeededNumberLength((String)StringMapper.toString((String)value), (int)fieldLength));
                break;
            }
            default: {
                throw new IllegalArgumentException("typ=" + typ);
            }
        }
    }

    private static void append(StringBuilder stringBuilder, int fieldLength, PerfidiaTyp typ, String value, boolean rightAligned) {
        if (rightAligned) {
            switch (typ) {
                case an: {
                    stringBuilder.append(ReportDataTransfer.makeToNeededAlphanumericRightLength((String)StringMapper.toString((String)value), (int)fieldLength));
                    return;
                }
            }
            throw new IllegalArgumentException("typ=" + typ);
        }
        WageTaxCertificateDataSource2016.append(stringBuilder, fieldLength, typ, value);
    }

    private static void append(StringBuilder stringBuilder, int fieldLength, PerfidiaTyp typ, int value) {
        WageTaxCertificateDataSource2016.append(stringBuilder, fieldLength, typ, Integer.toString(value));
    }

    private static void append(StringBuilder stringBuilder, int fieldLength, PerfidiaTyp typ, BigDecimal value) {
        int scale;
        switch (typ) {
            case d1: {
                scale = 1;
                break;
            }
            case d2: {
                scale = 2;
                break;
            }
            case d3: {
                scale = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("typ=" + typ);
            }
        }
        stringBuilder.append(WageTaxCertificateDataSource2016.toPerfidiaString(value, scale, fieldLength));
    }

    private static String toPerfidiaString(BigDecimal bigDecimal, int scale, int fieldLength) {
        boolean isNegative = (bigDecimal = WageTaxCertificateDataSource2016.toScale(scale, bigDecimal)).signum() < 0;
        bigDecimal = bigDecimal.abs();
        String perfidiaString = isNegative ? "-" + ReportDataTransfer.makeToNeededNumberLength((String)bigDecimal.toPlainString(), (int)(fieldLength - 1)) : ReportDataTransfer.makeToNeededNumberLength((String)bigDecimal.toPlainString(), (int)fieldLength);
        return perfidiaString;
    }

    public BigDecimal getRvAvBBGJaehrl(Employee employee) throws BusinessDomainException {
        SocialInsuranceTP socialInsuranceTP = this.getSocialInsuranceTP();
        SocialInsuranceLawArea socialInsuranceLawArea = this.marbRechtskreis(employee) == 'W' ? socialInsuranceTP.getLawAreaWest() : socialInsuranceTP.getLawAreaEast();
        return socialInsuranceLawArea.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance();
    }

    private SocialInsuranceTP getSocialInsuranceTP() throws BusinessDomainException {
        SocialInsuranceTP socialInsuranceTP = (SocialInsuranceTP)SocialInsurancePersistencyManager.getInstance().getHistory().getItemOrNull(this.mForEffectiveDate, this.mForValidDate);
        if (socialInsuranceTP == null) {
            throw EvaluationExceptionMapper.makeMissingSocialInsuranceDomainException((String)(DateMapper.toString((Date)this.mForEffectiveDate) + DateMapper.toString((Date)this.mForValidDate)));
        }
        return socialInsuranceTP;
    }

    public char marbRechtskreis(Employee employee) throws BusinessDomainException {
        FederalStateTP federalStateTP = this.getFederalStateTP(employee);
        return federalStateTP == null ? (char)'W' : federalStateTP.getLawArea().charAt(0);
    }

    private FederalStateTP getFederalStateTP(Employee employee) throws BusinessDomainException {
        FederalState federalState = this.getFederalState(employee);
        return federalState != null ? federalState.getFederalStateTP(this.mForEffectiveDate, this.mForValidDate) : null;
    }

    private FederalState getFederalState(Employee employee) throws BusinessDomainException {
        String oidPCompany;
        Foundations plantFoundations;
        String oidPlant;
        FederalState federalState = null;
        Employment employment = employee.getEmployment(this.mForEffectiveDate, this.mForValidDate);
        PlantPlaceTP plantPlaceTP = this.getPlantPlaceTP(employment);
        if (plantPlaceTP != null) {
            federalState = plantPlaceTP.getFederalState();
        }
        if (federalState == null && !StringMapper.isNullString((String)(oidPlant = employment.getPlant().getObjectid())) && (plantFoundations = this.mReportValues.getPlantFoundations(oidPlant, this.mForEffectiveDate, this.mForValidDate)) != null) {
            federalState = plantFoundations.getFederalState();
        }
        if (federalState == null && !StringMapper.isNullString((String)(oidPCompany = employee.getPCompany().getObjectid()))) {
            federalState = this.mReportValues.getCompanyFoundations(oidPCompany, this.mForEffectiveDate, this.mForValidDate).getFederalState();
        }
        return federalState;
    }

    private PlantPlaceTP getPlantPlaceTP(Employment employment) {
        PlantPlace plantPlace = employment.getPlantPlace();
        return plantPlace != null ? plantPlace.getPlantPlaceTPOrNull(this.mForEffectiveDate, this.mForValidDate) : null;
    }

    static enum PerfidiaTyp {
        n,
        an,
        d1,
        d2,
        d3;

    }
}

