/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.deuvstatementofcontribution;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.companyplant.StatusByInsolvencyEnum;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuvmessaging.DeuvRecipientMap;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipientTP;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.deuvstatementofcontribution.DEUVSOCDataTransferBean;
import com.varial.personnel.domain.reports.reportdatatransfer.DEUVDataTransferHelper;
import com.varial.personnel.domain.reports.statementofcontributionpaidkvdr.StatementOfContributionPaidKVDRReportDataSource;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.query.AllCallback;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DEUVStatementOfContributionPaidKVDRDataSource
extends StatementOfContributionPaidKVDRReportDataSource {
    private final List<DEUVSOCDataTransferBean> mSOCPDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
    private List<DEUVSOCDataTransferBean> mDEUVSOCDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
    private final String mDEUVSenderOid;
    private final String mDEUVSenderStdCompanyNumber;
    private final String mDEUVSenderDescription;
    private DEUVRecipientTP mDEUVRecipientTP;

    public DEUVStatementOfContributionPaidKVDRDataSource(AllCallback callback, ISpecialAccessPersistencyContext sapc, ReportFirstFilterStruct firstFilter, ReportSortStruct[] reportSortStruct, Date forEffectiveDate, Date forValidDate, String dEUVSenderOid, String dEUVSenderStdCompanyNumber, String dEUVSenderDescription, ProgressBarUpdater progressBar, List<String> errorList) throws BusinessDomainException {
        super(callback, sapc, firstFilter, null, null, reportSortStruct, forEffectiveDate, forValidDate, "", false, false, true, progressBar, errorList);
        this.mDEUVSenderStdCompanyNumber = dEUVSenderStdCompanyNumber;
        this.mDEUVSenderDescription = dEUVSenderDescription;
        this.mDEUVSenderOid = dEUVSenderOid;
    }

    protected void resetComponents() {
        super.resetComponents();
        this.mDEUVSOCDataTransferBeanLi.clear();
    }

    public List<DEUVSOCDataTransferBean> getSOCPDataTransferBeanLi() {
        return this.mSOCPDataTransferBeanLi;
    }

    protected void buildSummCollection() throws BusinessDomainException {
        super.buildSummCollection();
        this.mDEUVSOCDataTransferBeanLi = new LinkedList<DEUVSOCDataTransferBean>();
        DEUVSOCDataTransferBean dEUVSOCDataTransferBean = new DEUVSOCDataTransferBean();
        dEUVSOCDataTransferBean.setVKennung("VOSZ");
        dEUVSOCDataTransferBean.setVVverfIntMerkmal("BWBNV");
        dEUVSOCDataTransferBean.setVAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        HealthFundTP healthFundTP = this.getHealthFundTP(this.getSOCKVDRTypeBeanForReport().getOidHealthFund(), this.getForEffectiveDate(), this.getForValidDate());
        DEUVSender deuvSender = new DEUVSender(this.mDEUVSenderOid);
        DeuvRecipientMap deuvRecipientMap = new DeuvRecipientMap(deuvSender);
        DEUVRecipient dEUVRecipient = deuvRecipientMap.getDeuvRecipient(healthFundTP.getHealthFund());
        this.mDEUVRecipientTP = dEUVRecipient.getCurrentDEUVRecipientTP();
        int typeOfHealthFundInt = healthFundTP.getTypeOfHealthFundEnum().value();
        dEUVSOCDataTransferBean.setDEUVEmpfaengerForSort(DEUVDataTransferHelper.getNeededDEUVRecipientKey((String)Integer.toString(typeOfHealthFundInt)));
        String dEUVRecipientStandardCompanyNumber = this.getStandardCompanyNumber();
        dEUVSOCDataTransferBean.setVEmpfaengerNr(dEUVRecipientStandardCompanyNumber);
        dEUVSOCDataTransferBean.setDEUVRecipientName(this.mDEUVRecipientTP.getName());
        dEUVSOCDataTransferBean.setVErstDatumDati(DateMapper.toYYYYMMDDString((Date)new Date()));
        dEUVSOCDataTransferBean.setVDateiNr(Integer.toString(this.getFileNumberOfStatementOfContributionsKVDR() + 1));
        dEUVSOCDataTransferBean.setVAbsender(this.mDEUVSenderDescription);
        dEUVSOCDataTransferBean.setVReserve("");
        dEUVSOCDataTransferBean.setVVersionNr("01");
        dEUVSOCDataTransferBean.setVSatzEnde("E");
        dEUVSOCDataTransferBean.setBKennung("BW03");
        dEUVSOCDataTransferBean.setBVerfIntMerkmal("BWBNV");
        dEUVSOCDataTransferBean.setBAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        dEUVSOCDataTransferBean.setBKrKEmpfaengerBetriebsNr(healthFundTP.getStandardCompanyNumber());
        dEUVSOCDataTransferBean.setKrankenkasseBezeichnung(healthFundTP.getShortDescription());
        dEUVSOCDataTransferBean.setBKennzeichen1("0");
        if (this.mPCompanyFoundations.getStatusByInsolvency() == StatusByInsolvencyEnum.SBIE_FUER_SOFORT_FREIGESTELLTE_AN) {
            dEUVSOCDataTransferBean.setBKennzeichenInsolvenz("1");
        } else {
            dEUVSOCDataTransferBean.setBKennzeichenInsolvenz("0");
        }
        dEUVSOCDataTransferBean.setBKennzeichen2("0");
        dEUVSOCDataTransferBean.setBKennzeichen3("0");
        dEUVSOCDataTransferBean.setBArbeitgeberBetriebsnummerNr(this.getAGBeitragskontonummer());
        dEUVSOCDataTransferBean.setArbeitgeberVWENr(this.getAgVweNr());
        dEUVSOCDataTransferBean.setBZeitraumBeginn(DateMapper.toYYYYMMDDString((Date)DateHelper.getFirstDayOfMonth((Date)this.getForValidDate())));
        dEUVSOCDataTransferBean.setBZeitraumEnde(DateMapper.toYYYYMMDDString((Date)DateHelper.getLastDayOfMonth((Date)this.getForValidDate())));
        dEUVSOCDataTransferBean.setForValidDate(this.getForValidDate());
        dEUVSOCDataTransferBean.setMonat(DateMapper.toMMYYYYPointSeparationString((Date)this.getForValidDate()));
        this.getDEUVSOCDataTransferBeanAmounts(dEUVSOCDataTransferBean);
        dEUVSOCDataTransferBean.setBAGName1(this.getAGBezeichnung());
        dEUVSOCDataTransferBean.setBAGName2("");
        dEUVSOCDataTransferBean.setBAGStrassePostfach(this.getAGStrNr());
        dEUVSOCDataTransferBean.setBNationalitaetAnschrift("");
        dEUVSOCDataTransferBean.setBAGPLZ(this.getAGPlzOrt().substring(0, 5));
        dEUVSOCDataTransferBean.setBAGOrt(this.getAGPlzOrt().substring(5, this.getAGPlzOrt().length()));
        dEUVSOCDataTransferBean.setBAbrechnnungsstelle1(this.getAGBetriebsnummer());
        dEUVSOCDataTransferBean.setBAbrechnnungsstelle2("");
        dEUVSOCDataTransferBean.setBOrdnungsmerkmal("");
        dEUVSOCDataTransferBean.setBVerarbeitungsmerkmal("");
        dEUVSOCDataTransferBean.setBKVBeitragSatzAllg(healthFundTP.getPercentageGeneral().add(healthFundTP.getAdditionalDues()).toString());
        dEUVSOCDataTransferBean.setBKVBeitragSatzErh("");
        dEUVSOCDataTransferBean.setBKVBeitragSatzErm("");
        dEUVSOCDataTransferBean.setBRechtskreis("");
        dEUVSOCDataTransferBean.setBKennzeichenU12("0");
        dEUVSOCDataTransferBean.setBErstellungsdatum(DeuvBasics.getCurrentDeuvDateString());
        dEUVSOCDataTransferBean.setBLfdNummer("0");
        dEUVSOCDataTransferBean.setBVersion("12");
        dEUVSOCDataTransferBean.setBWaehrung("E");
        dEUVSOCDataTransferBean.setBPauschStBD(BigDecimal.valueOf(0L, 2));
        dEUVSOCDataTransferBean.setBSteuernummer("");
        dEUVSOCDataTransferBean.setBSatzende("E");
        dEUVSOCDataTransferBean.setNKennung("NCSZ");
        dEUVSOCDataTransferBean.setNVerfIntMerkmal("BWBNV");
        dEUVSOCDataTransferBean.setNAbsenderNr(this.mDEUVSenderStdCompanyNumber);
        dEUVSOCDataTransferBean.setNEmpfaengerNr(dEUVRecipientStandardCompanyNumber);
        dEUVSOCDataTransferBean.setNErstDatDatei(DateMapper.toYYYYMMDDString((Date)new Date()));
        dEUVSOCDataTransferBean.setNDateiNr(dEUVSOCDataTransferBean.getVDateiNr());
        dEUVSOCDataTransferBean.setNAnzahlSaetze("");
        dEUVSOCDataTransferBean.setNVorzeichenSummeZahlbetrag("");
        dEUVSOCDataTransferBean.setNSummeZahlbetrag("");
        dEUVSOCDataTransferBean.setNReserve("");
        dEUVSOCDataTransferBean.setNVersion("01");
        dEUVSOCDataTransferBean.setNSatzende("E");
        dEUVSOCDataTransferBean.setOidHealthFund(this.getSOCKVDRTypeBeanForReport().getOidHealthFund());
        dEUVSOCDataTransferBean.setOidPCompany(this.getOidPCompany());
        this.mDEUVSOCDataTransferBeanLi.add(dEUVSOCDataTransferBean);
    }

    private void getDEUVSOCDataTransferBeanAmounts(DEUVSOCDataTransferBean dEUVSOCDataTransferBean) {
        BigDecimal bgDecimal = BigDecimal.valueOf(0L, 2);
        dEUVSOCDataTransferBean.setBD_1000(this.getSummeKVBeitraege());
        dEUVSOCDataTransferBean.setBD_2000(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Zusatzbeitrag(this.getF_summe_kv_zusatzbeitrag());
        dEUVSOCDataTransferBean.setBD_3000(this.getSummeKV3000Beitrag());
        dEUVSOCDataTransferBean.setBD_0001(this.getSummePVBeitraege());
        dEUVSOCDataTransferBean.setBD_0100(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0200(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0010(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0300(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0020(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0050(bgDecimal);
        dEUVSOCDataTransferBean.setBD_U1(bgDecimal);
        dEUVSOCDataTransferBean.setBD_U2(bgDecimal);
        dEUVSOCDataTransferBean.setBD_6000(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0500(bgDecimal);
        dEUVSOCDataTransferBean.setBD_0600(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Gesamtsumme(this.getSummeBeitrag());
        dEUVSOCDataTransferBean.setBD_FreiwKV(bgDecimal);
        dEUVSOCDataTransferBean.setBD_FreiwPV(bgDecimal);
        dEUVSOCDataTransferBean.setBD_LFZG(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Betrag1(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Betrag2(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Betrag3(bgDecimal);
        dEUVSOCDataTransferBean.setBD_Zahlbetrag(this.getSummeBeitrag());
        dEUVSOCDataTransferBean.setBZahlbetragBD(this.getSummeBeitrag());
        dEUVSOCDataTransferBean.setBD_FwZusatzbeitrag(bgDecimal);
    }

    public void saveSOCPDataTransferBean() {
        this.mSOCPDataTransferBeanLi.addAll(this.mDEUVSOCDataTransferBeanLi);
    }

    private String getStandardCompanyNumber() {
        return this.mDEUVRecipientTP.getStdCompanyNumber();
    }

    private int getFileNumberOfStatementOfContributionsKVDR() {
        return this.mDEUVRecipientTP.getFileNumberKvdrStatementOfContributions();
    }
}

