/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CertificateCalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;

public class KVBeitragsermittlungPrivatFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private static final BigDecimal FUENFZIG = BigDecimal.valueOf(50L);
    private static final BigDecimal EINHUNDERT = BigDecimal.valueOf(100L);
    private static final BigDecimal DREIHUNDERTSECHZIG = BigDecimal.valueOf(360L);
    private final CalculationLibrary callib;
    private final EmployeeLibrary eelib;
    private final GlobalLibrary gllib;
    private final ValuePositionLibrary wplib;
    private BigDecimal mBeitragspflichtig = BigDecimal.ZERO;
    private BigDecimal mKVTageAufgelaufen = BigDecimal.ZERO;
    private BigDecimal mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
    private BigDecimal mAGZFaehigerGesamtbeitrag = BigDecimal.ZERO;
    private BigDecimal mAGZuschussAufgelaufen = BigDecimal.ZERO;
    private boolean mMfB = false;
    private BigDecimal mKvBBG = BigDecimal.ZERO;
    private BigDecimal mKVTage = BigDecimal.ZERO;

    public KVBeitragsermittlungPrivatFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.gllib = globalLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void kvBeitragsermittlung() throws BusinessDomainException {
        String BGSAndererAG = Integer.toString(this.eelib.marbBgrKvAndererAG()) + Integer.toString(this.eelib.marbBgrRvAndererAG()) + Integer.toString(this.eelib.marbBgrAvAndererAG()) + Integer.toString(this.eelib.marbBgrPvAndererAG());
        this.mMfB = this.eelib.isMehrfachbeschaeftigt() && this.eelib.marbBgrKvAndererAG() != 6 && !StringMapper.equal((String)BGSAndererAG, (String)"0500");
        this.mKVTage = this.wplib.svTage();
        if (this.callib.dbbgVorhanden() && BigDecimal.valueOf(this.callib.dbbgSVTG()).compareTo(this.mKVTage) > 0) {
            this.mKVTage = BigDecimal.valueOf(this.callib.dbbgSVTG());
        }
        this.mKvBBG = this.mKVTage.compareTo(DREISSIG) != 0 ? this.gllib.svBbgKvPv().multiply(this.mKVTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.gllib.svBbgKvPv();
        switch (this.wplib.wertartenNummer()) {
            case 770120: {
                this.zuschussErmittlungLfd();
                break;
            }
            case 770150: {
                this.wplib.wertPosition().makeReadOnly();
                break;
            }
            case 770130: {
                if (this.eelib.marbAGZPKv() == 1) {
                    this.zuschussErmittlungEGA();
                    break;
                }
                this.callib.kvAGZ(BigDecimal.ZERO);
                break;
            }
            case 770140: {
                this.zuschussErmittlungKug();
                break;
            }
        }
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2026, 0, 1).getDate()) && this.mKVTage.compareTo(DREISSIG) != 0 && this.callib.getTypeOfCalculationCase() != TypeOfCalculationCase.PkvPpVBerechnungOhneFZ) {
            CertificateCalculationCase calculationCase = new CertificateCalculationCase();
            calculationCase.init(this.eelib.marb(), this.callib.berchnungWirksamAb(), this.callib.berchnungGueltigAb(), BigDecimal.ZERO, TypeOfCalculationCase.PkvPpVBerechnungOhneFZ);
            calculationCase.start();
            BigDecimal kvAGZVollerMonat = calculationCase.getSumOfValuePosition(this.wplib.wertartenNummer());
            calculationCase.removeValuesOfCalculation();
            this.callib.setResultVM(kvAGZVollerMonat);
        } else {
            this.callib.setResultVM(this.callib.kvAGZ());
        }
    }

    private void zuschussErmittlungLfd() throws BusinessDomainException {
        BigDecimal gesamtEntgelt;
        ValuePosition[] lVpArray;
        BigDecimal gesamtesFiktivesEntgelt = BigDecimal.ZERO;
        BigDecimal gesamtesKugEntgelt = BigDecimal.ZERO;
        block10: for (ValuePosition lElement : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130560, 770110, 130540, 230110}))) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 130510: 
                case 130560: {
                    this.mBeitragspflichtig = this.mBeitragspflichtig.add(lElement.getResult());
                    continue block10;
                }
                case 130540: {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)lElement.getBufferField01())) {
                        gesamtesFiktivesEntgelt = gesamtesFiktivesEntgelt.add(lElement.getBufferField01());
                        continue block10;
                    }
                    gesamtesFiktivesEntgelt = gesamtesFiktivesEntgelt.add(lElement.getResult());
                    continue block10;
                }
                case 230110: {
                    if (!DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2021, 6, 1).getDate())) continue block10;
                    gesamtesKugEntgelt = gesamtesKugEntgelt.add(lElement.getResult());
                    continue block10;
                }
                case 770110: {
                    this.wplib.loescheWertPosition(this.wplib.wertPosition());
                    return;
                }
            }
        }
        if (!BigDecimalMapper.isZero((BigDecimal)gesamtesFiktivesEntgelt) && BigDecimalMapper.compareTo((BigDecimal)(gesamtEntgelt = this.mBeitragspflichtig.add(gesamtesFiktivesEntgelt)), (BigDecimal)this.mKvBBG) > 0) {
            this.mBeitragspflichtig = this.mBeitragspflichtig.multiply(this.mKvBBG).divide(gesamtEntgelt, 2, RoundingMode.HALF_UP);
        }
        if (this.mBeitragspflichtig.compareTo(BigDecimal.ZERO) == 0) {
            this.wplib.addNeueWertPosition(770190, BigDecimal.ZERO, BigDecimal.ZERO, this.mKVTage, BigDecimal.ZERO, this.mBeitragspflichtig, true);
            this.wplib.addNeueWertPosition(770110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true);
            this.callib.kvAGZ(BigDecimal.ZERO);
            return;
        }
        if (this.mBeitragspflichtig.compareTo(this.mKvBBG) > 0) {
            this.mBeitragspflichtig = this.mKvBBG;
        }
        this.wplib.addNeueWertPosition(770190, BigDecimal.ZERO, BigDecimal.ZERO, this.mKVTage, BigDecimal.ZERO, this.mBeitragspflichtig, true);
        switch (this.eelib.marbAGZPKv()) {
            case 1: {
                this.ermittleAGZNachEntgelt(gesamtesKugEntgelt);
                break;
            }
            case 2: {
                this.ermittleAGZNachBBG(gesamtesKugEntgelt);
            }
        }
    }

    private void ermittleAGZNachBBG(BigDecimal kugEntgelt) throws BusinessDomainException {
        this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPKv();
        if (this.mMfB) {
            BigDecimal lfdBeitragsPflFuerMfB = this.mKvBBG;
            BigDecimal entgeltAndererAG = BigDecimal.ZERO;
            if (this.callib.dbbgVorhanden()) {
                entgeltAndererAG = this.callib.dbbgGAEGKV().subtract(lfdBeitragsPflFuerMfB);
            } else {
                ValuePosition[] lVpArray;
                block3: for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205}))) {
                    switch (valuePosition.getValueType().getValueTypeKey()) {
                        case 129200: 
                        case 129205: {
                            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getResult(), (BigDecimal)this.mKvBBG) > 0) {
                                    entgeltAndererAG = entgeltAndererAG.add(this.mKvBBG);
                                    continue block3;
                                }
                                entgeltAndererAG = entgeltAndererAG.add(valuePosition.getResult());
                                continue block3;
                            }
                            entgeltAndererAG = entgeltAndererAG.add(valuePosition.getResult());
                            continue block3;
                        }
                    }
                }
            }
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                this.wplib.addNeueWertPosition(321595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, entgeltAndererAG, true);
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mKvBBG)) {
                this.mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
            } else if (BigDecimalMapper.compareTo((BigDecimal)lfdBeitragsPflFuerMfB.add(entgeltAndererAG), (BigDecimal)BigDecimal.ZERO) > 0) {
                this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(lfdBeitragsPflFuerMfB).divide(lfdBeitragsPflFuerMfB.add(entgeltAndererAG), 2, RoundingMode.HALF_UP);
                this.mKvBBG = this.mKvBBG.multiply(lfdBeitragsPflFuerMfB).divide(lfdBeitragsPflFuerMfB.add(entgeltAndererAG), 2, RoundingMode.HALF_UP);
            }
        }
        this.wplib.addNeueWertPosition(770110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mMitarbeiterGesamtbeitrag, true);
        this.mMitarbeiterGesamtbeitrag = this.anrechnungKUGEntgelt(kugEntgelt, this.mKvBBG, this.mMitarbeiterGesamtbeitrag);
        BigDecimal gesamtbeitrag = this.mKvBBG.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal agZuschuss = gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal halberGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 3, RoundingMode.HALF_UP);
        if (agZuschuss.compareTo(halberGesamtbeitrag) > 0) {
            agZuschuss = DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? halberGesamtbeitrag.setScale(2, RoundingMode.DOWN) : halberGesamtbeitrag.setScale(2, RoundingMode.HALF_UP);
        }
        this.callib.kvAGZ(agZuschuss);
    }

    private void ermittleAGZNachEntgelt(BigDecimal kugEntgelt) throws BusinessDomainException {
        BigDecimal halberGesamtbeitrag;
        block19: {
            BigDecimal entgeltLfdAndererAG;
            BigDecimal entgeltLfdEigenerAG;
            block21: {
                ValuePosition[] lVpArray;
                block20: {
                    ValuePosition[] vpArray;
                    BigDecimal dbbgSvTage;
                    this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPKv();
                    if (!this.mMfB) break block19;
                    entgeltLfdEigenerAG = BigDecimal.ZERO;
                    entgeltLfdAndererAG = BigDecimal.ZERO;
                    BigDecimal gesEntgeltBeideAG = BigDecimal.ZERO;
                    BigDecimal eigeneBBG = this.gllib.svBbgKvPv();
                    BigDecimal dbbgBBG = this.gllib.svBbgKvPv();
                    if (!this.callib.dbbgVorhanden()) break block20;
                    BigDecimal dbbgEntgelt = this.callib.dbbgGAEGKV();
                    if (dbbgEntgelt.compareTo(BigDecimal.ZERO) == 0) break block21;
                    BigDecimal bigDecimal = dbbgSvTage = BigDecimalMapper.isZero((BigDecimal)BigDecimal.valueOf(this.callib.dbbgSVTG())) ? DREISSIG : BigDecimal.valueOf(this.callib.dbbgSVTG());
                    if (BigDecimalMapper.compareTo((BigDecimal)dbbgSvTage, (BigDecimal)DREISSIG) != 0) {
                        dbbgBBG = dbbgBBG.multiply(dbbgSvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    }
                    for (ValuePosition valuePosition : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510}))) {
                        entgeltLfdEigenerAG = entgeltLfdEigenerAG.add(valuePosition.getResult());
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)this.mKVTage, (BigDecimal)DREISSIG) != 0) {
                        eigeneBBG = eigeneBBG.multiply(this.mKVTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)entgeltLfdEigenerAG, (BigDecimal)eigeneBBG) > 0) {
                        entgeltLfdEigenerAG = eigeneBBG;
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)(entgeltLfdAndererAG = (gesEntgeltBeideAG = dbbgEntgelt).subtract(entgeltLfdEigenerAG)), (BigDecimal)BigDecimal.ZERO) >= 0) break block21;
                    entgeltLfdAndererAG = BigDecimal.ZERO;
                    break block21;
                }
                for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510}))) {
                    entgeltLfdEigenerAG = entgeltLfdEigenerAG.add(valuePosition.getResult());
                }
                if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && BigDecimalMapper.compareTo((BigDecimal)entgeltLfdEigenerAG, (BigDecimal)this.mKvBBG) > 0) {
                    entgeltLfdEigenerAG = this.mKvBBG;
                }
                for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205}))) {
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                        if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getResult(), (BigDecimal)this.mKvBBG) > 0) {
                            entgeltLfdAndererAG = entgeltLfdAndererAG.add(this.mKvBBG);
                            continue;
                        }
                        entgeltLfdAndererAG = entgeltLfdAndererAG.add(valuePosition.getResult());
                        continue;
                    }
                    entgeltLfdAndererAG = entgeltLfdAndererAG.add(valuePosition.getResult());
                }
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mKvBBG)) {
                this.mMitarbeiterGesamtbeitrag = BigDecimal.ZERO;
            } else if (BigDecimalMapper.compareTo((BigDecimal)entgeltLfdEigenerAG.add(entgeltLfdAndererAG), (BigDecimal)BigDecimal.ZERO) > 0) {
                this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(entgeltLfdEigenerAG).divide(entgeltLfdEigenerAG.add(entgeltLfdAndererAG), 2, RoundingMode.HALF_UP);
                this.mKvBBG = this.mKvBBG.multiply(entgeltLfdEigenerAG).divide(entgeltLfdEigenerAG.add(entgeltLfdAndererAG), 2, RoundingMode.HALF_UP);
            }
        }
        BigDecimal gesamtbeitrag = BigDecimal.ZERO;
        if (DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            gesamtbeitrag = this.mBeitragspflichtig.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        } else {
            if (this.mBeitragspflichtig.compareTo(this.mKvBBG) > 0) {
                this.mBeitragspflichtig = this.mKvBBG;
            }
            gesamtbeitrag = DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? this.mBeitragspflichtig.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.UP) : this.mBeitragspflichtig.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        }
        if (gesamtbeitrag.compareTo(this.mMitarbeiterGesamtbeitrag) > 0) {
            gesamtbeitrag = this.mMitarbeiterGesamtbeitrag;
        }
        this.wplib.addNeueWertPosition(770110, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.mMitarbeiterGesamtbeitrag, true);
        this.mMitarbeiterGesamtbeitrag = this.anrechnungKUGEntgelt(kugEntgelt, this.mBeitragspflichtig, this.mMitarbeiterGesamtbeitrag);
        if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)DREISSIG) != 0) {
            this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(this.wplib.svTage()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
        BigDecimal agZuschuss = gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        BigDecimal fiktSvTage = this.getSVTageUnterBeruecksichtigungFehlzeiten();
        if (BigDecimalMapper.compareTo((BigDecimal)this.wplib.svTage(), (BigDecimal)fiktSvTage) != 0) {
            agZuschuss = agZuschuss.multiply(fiktSvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        }
        if (agZuschuss.compareTo(halberGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 3, RoundingMode.HALF_UP)) > 0) {
            agZuschuss = DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? halberGesamtbeitrag.setScale(2, RoundingMode.DOWN) : halberGesamtbeitrag.setScale(2, RoundingMode.HALF_UP);
        }
        this.callib.kvAGZ(agZuschuss);
    }

    private BigDecimal anrechnungKUGEntgelt(BigDecimal kugEntgelt, BigDecimal beitragspflichtig, BigDecimal mitarbeiterGesamtbeitrag) throws BusinessDomainException {
        BigDecimal agzKug;
        BigDecimal marbGesamtbeitrag;
        if (beitragspflichtig.add(kugEntgelt).compareTo(this.mKvBBG) > 0) {
            kugEntgelt = this.mKvBBG.subtract(beitragspflichtig);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)(marbGesamtbeitrag = mitarbeiterGesamtbeitrag.subtract(agzKug = this.getAGZKUG(kugEntgelt))), (BigDecimal)BigDecimal.ZERO) < 0) {
            marbGesamtbeitrag = BigDecimal.ZERO;
        }
        return marbGesamtbeitrag;
    }

    private void zuschussErmittlungKug() throws BusinessDomainException {
        ValuePosition[] lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{770120, 770190, 230110}));
        BigDecimal kugEntgeltImMonat = BigDecimal.ZERO;
        BigDecimal aufgelaufenesEntgeltPKV = BigDecimal.ZERO;
        block5: for (ValuePosition lElement : lVpArray) {
            switch (lElement.getValueType().getValueTypeKey()) {
                case 230110: {
                    kugEntgeltImMonat = kugEntgeltImMonat.add(lElement.getResult());
                    continue block5;
                }
                case 770120: {
                    this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(lElement.getResult());
                    continue block5;
                }
                case 770190: {
                    aufgelaufenesEntgeltPKV = aufgelaufenesEntgeltPKV.add(lElement.getResult());
                    continue block5;
                }
            }
        }
        if (aufgelaufenesEntgeltPKV.add(kugEntgeltImMonat).compareTo(this.mKvBBG) > 0) {
            kugEntgeltImMonat = this.mKvBBG.subtract(aufgelaufenesEntgeltPKV);
        }
        if (kugEntgeltImMonat.compareTo(BigDecimal.ZERO) < 0) {
            kugEntgeltImMonat = BigDecimal.ZERO;
        }
        this.modifizierePKVEntgelt(kugEntgeltImMonat);
        BigDecimal agZuschuss = this.getAGZKUG(kugEntgeltImMonat);
        BigDecimal gesamtbeitrag = this.eelib.marbBeitrPKv();
        if (this.mAGZuschussAufgelaufen.add(agZuschuss).compareTo(gesamtbeitrag) > 0) {
            agZuschuss = gesamtbeitrag.subtract(this.mAGZuschussAufgelaufen);
        }
        this.callib.kvAGZ(agZuschuss);
    }

    private BigDecimal getAGZKUG(BigDecimal kugEntgelt) throws BusinessDomainException {
        BigDecimal agzKUG = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)kugEntgelt)) {
            BigDecimal kvBeitragsVHSatz = this.getSVBSDurchschnitt().multiply(FUENFZIG).divide(EINHUNDERT, 3, RoundingMode.HALF_UP);
            agzKUG = kugEntgelt.multiply(kvBeitragsVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            agzKUG = agzKUG.add(kugEntgelt.multiply(kvBeitragsVHSatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP));
            if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2016, 0, 1).getDate()) && DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                BigDecimal zusatzbeitrag = BigDecimal.ZERO;
                BigDecimal kvBeitragsVHSatzZusatz = this.gllib.kvAnaZusatzDurchVHSatz();
                zusatzbeitrag = kugEntgelt.multiply(kvBeitragsVHSatzZusatz).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                agzKUG = agzKUG.add(zusatzbeitrag);
            }
        }
        return agzKUG;
    }

    private void zuschussErmittlungEGA() throws BusinessDomainException {
        ValuePosition[] lVpArray;
        this.fuelleJahresWerte();
        BigDecimal entgeltLfd = BigDecimal.ZERO;
        BigDecimal lBeitragspflichtig = BigDecimal.ZERO;
        block10: for (ValuePosition valuePosition : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{770190, 129200, 130590}))) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 770190: {
                    entgeltLfd = entgeltLfd.add(valuePosition.getResult());
                }
                case 129200: {
                    lBeitragspflichtig = lBeitragspflichtig.add(valuePosition.getResult());
                    this.mBeitragspflichtig = this.mBeitragspflichtig.add(valuePosition.getResult());
                    continue block10;
                }
                case 130590: {
                    this.mKVTageAufgelaufen = this.mKVTageAufgelaufen.add(valuePosition.getFactor1());
                }
            }
        }
        BigDecimal gesamtBeitragLfdAktuellerMonat = BigDecimal.ZERO;
        BigDecimal aktuellesEGA = BigDecimal.ZERO;
        BigDecimal lGesamtbeitragAG = lBeitragspflichtig.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
        this.mAGZFaehigerGesamtbeitrag = this.mAGZFaehigerGesamtbeitrag.add(lGesamtbeitragAG);
        block11: for (ValuePosition vp : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{770110, 770120, 130610, 130620, 130650}))) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 770110: {
                    gesamtBeitragLfdAktuellerMonat = gesamtBeitragLfdAktuellerMonat.add(vp.getResult());
                    this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.add(vp.getResult());
                    continue block11;
                }
                case 770120: {
                    this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(vp.getResult());
                    continue block11;
                }
                case 130610: 
                case 130620: 
                case 130650: {
                    aktuellesEGA = aktuellesEGA.add(vp.getResult());
                    continue block11;
                }
            }
        }
        BigDecimal bigDecimal = this.gllib.svBbgKvPvJaehrl().multiply(this.mKVTageAufgelaufen).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP);
        BigDecimal pKVLuft = bigDecimal.subtract(this.mBeitragspflichtig);
        if (!BigDecimalMapper.isZero((BigDecimal)this.eelib.vortragSozialVersicherungKVLuft(this.wplib.gueltigAb()))) {
            pKVLuft = pKVLuft.add(this.eelib.vortragSozialVersicherungKVLuft(this.wplib.gueltigAb()));
        }
        if (aktuellesEGA.compareTo(pKVLuft) >= 0) {
            aktuellesEGA = pKVLuft;
        }
        if (aktuellesEGA.compareTo(BigDecimal.ZERO) < 0) {
            aktuellesEGA = BigDecimal.ZERO;
        }
        BigDecimal agZuschuss = BigDecimal.ZERO;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)aktuellesEGA)) {
            this.modifizierePKVEntgelt(aktuellesEGA);
            BigDecimal gesamtbeitrag = BigDecimal.ZERO;
            if (!this.mMfB) {
                gesamtbeitrag = aktuellesEGA.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                agZuschuss = gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                this.mAGZFaehigerGesamtbeitrag = this.mAGZFaehigerGesamtbeitrag.add(gesamtbeitrag);
                if (this.mAGZFaehigerGesamtbeitrag.compareTo(this.mMitarbeiterGesamtbeitrag) > 0) {
                    this.mAGZFaehigerGesamtbeitrag = this.mMitarbeiterGesamtbeitrag;
                }
                BigDecimal halberGesamtbeitrag = this.mAGZFaehigerGesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                if (agZuschuss.compareTo(BigDecimal.ZERO) != 0 && this.mAGZuschussAufgelaufen.add(agZuschuss).compareTo(halberGesamtbeitrag) > 0) {
                    agZuschuss = halberGesamtbeitrag.subtract(this.mAGZuschussAufgelaufen);
                    if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && agZuschuss.compareTo(BigDecimal.ZERO) < 0) {
                        agZuschuss = BigDecimal.ZERO;
                    }
                }
            } else {
                this.mMitarbeiterGesamtbeitrag = this.eelib.marbBeitrPKv();
                BigDecimal beitrag = BigDecimal.ZERO;
                if (!BigDecimalMapper.isZero((BigDecimal)lBeitragspflichtig.add(aktuellesEGA))) {
                    beitrag = entgeltLfd.add(aktuellesEGA).multiply(this.mMitarbeiterGesamtbeitrag).divide(lBeitragspflichtig.add(aktuellesEGA), 2, RoundingMode.HALF_UP);
                }
                gesamtbeitrag = beitrag.subtract(gesamtBeitragLfdAktuellerMonat);
                agZuschuss = DateHelper.before((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 6, 1).getDate()) ? gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.DOWN) : gesamtbeitrag.multiply(FUENFZIG).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
                this.modifizierePKVBeitraege(gesamtbeitrag);
            }
        }
        this.callib.kvAGZ(agZuschuss);
    }

    private void modifizierePKVEntgelt(BigDecimal decimal) throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), new ValueType[]{ValueType.getValueType((int)770190)});
            if (lVpArray.length == 0) {
                this.wplib.addNeueWertPosition(770190, decimal);
            } else {
                lVpArray[0].setResult(lVpArray[0].getResult().add(decimal));
            }
        }
    }

    private void modifizierePKVBeitraege(BigDecimal decimal) throws BusinessDomainException {
        if (DateHelper.between((Date)this.wplib.gueltigAb(), (Date)this.callib.berchnungGueltigAb(), (Date)DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()))) {
            ValuePosition[] vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{770110}));
            if (vpArray.length == 0) {
                this.wplib.addNeueWertPosition(770110, decimal);
            } else {
                vpArray[0].setResult(vpArray[0].getResult().add(decimal));
            }
        }
    }

    private void fuelleJahresWerte() throws BusinessDomainException {
        Date start = DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb());
        Date aktuellerMonat = DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb());
        while (DateHelper.before((Date)start, (Date)aktuellerMonat)) {
            ValuePosition[] lVpArray;
            BigDecimal svTage = BigDecimal.ZERO;
            BigDecimal kvEntgeltGKV = BigDecimal.ZERO;
            BigDecimal lBeitragspflichtig = BigDecimal.ZERO;
            block10: for (ValuePosition vp : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)start), DateHelper.getLastDayOfMonth((Date)start), ValueTypeHelper.getValueTypes((int[])new int[]{770190, 321595, 130590, 770090, 770100, 321510}))) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 321595: 
                    case 770190: {
                        lBeitragspflichtig = lBeitragspflichtig.add(vp.getResult());
                        this.mBeitragspflichtig = this.mBeitragspflichtig.add(vp.getResult());
                        continue block10;
                    }
                    case 130590: {
                        svTage = svTage.add(vp.getFactor1());
                        continue block10;
                    }
                    case 321510: 
                    case 770090: 
                    case 770100: {
                        kvEntgeltGKV = kvEntgeltGKV.add(vp.getResult());
                    }
                }
            }
            if (BigDecimalMapper.isZero((BigDecimal)kvEntgeltGKV)) {
                this.mKVTageAufgelaufen = this.mKVTageAufgelaufen.add(svTage);
            }
            BigDecimal lGesamtbeitragAG = lBeitragspflichtig.multiply(this.getSVBSDurchschnitt()).divide(EINHUNDERT, 2, RoundingMode.HALF_UP);
            this.mAGZFaehigerGesamtbeitrag = this.mAGZFaehigerGesamtbeitrag.add(lGesamtbeitragAG);
            block11: for (ValuePosition vp : lVpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)start), DateHelper.getLastDayOfMonth((Date)start), ValueTypeHelper.getValueTypes((int[])new int[]{770110, 770120, 770130}))) {
                switch (vp.getValueType().getValueTypeKey()) {
                    case 770110: {
                        this.mMitarbeiterGesamtbeitrag = this.mMitarbeiterGesamtbeitrag.add(vp.getResult());
                        continue block11;
                    }
                    case 770120: 
                    case 770130: {
                        this.mAGZuschussAufgelaufen = this.mAGZuschussAufgelaufen.add(vp.getResult());
                        continue block11;
                    }
                }
            }
            start = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)start));
        }
    }

    private BigDecimal getSVBSDurchschnitt() throws BusinessDomainException {
        BigDecimal sVAGBSDurchschnitt = this.gllib.svBsDurchschnittlich();
        if (DateHelper.afterOrEqual((Date)this.callib.berchnungGueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
            sVAGBSDurchschnitt = sVAGBSDurchschnitt.add(this.gllib.getKVBSZusatzversicherung(true));
        }
        return sVAGBSDurchschnitt;
    }

    private BigDecimal getSVTageUnterBeruecksichtigungFehlzeiten() throws BusinessDomainException {
        BigDecimal svtage = this.wplib.svTageLfd();
        BigDecimal tempFehltage = this.getFehltage(this.wplib.gueltigAb());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)tempFehltage) && BigDecimalMapper.compareTo((BigDecimal)(svtage = svtage.subtract(tempFehltage)), (BigDecimal)BigDecimal.ZERO) < 0) {
            svtage = BigDecimal.ZERO;
        }
        return svtage;
    }

    private BigDecimal getFehltage(Date validDate) throws BusinessDomainException {
        BigDecimal fehltage = BigDecimal.ZERO;
        String fehlzeitSchluessel = "";
        String[] fehlzeiten = new String[]{"KAP"};
        EEAbsentTimeTP[] eeAbsentTimeTPs = this.eelib.aktuelleFehlzeitenfuerMonat(validDate);
        if (eeAbsentTimeTPs != null) {
            for (EEAbsentTimeTP eeAbsentTimeTP : eeAbsentTimeTPs) {
                fehlzeitSchluessel = eeAbsentTimeTP.getEEAbsentTime().getAbsentTime().getAbsentTimeKey();
                for (String fehlzeit : fehlzeiten) {
                    Date fehlzeitBis;
                    if (!StringMapper.equal((String)fehlzeitSchluessel, (String)fehlzeit)) continue;
                    Date fehlzeitAb = DateHelper.before((Date)eeAbsentTimeTP.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)validDate)) ? DateHelper.getFirstDayOfMonth((Date)validDate) : eeAbsentTimeTP.getValidFrom();
                    Date beginnDatumFuerSVTageKuerzung = this.getBeginnDatumFuerSVTageKuerzung(eeAbsentTimeTP.getValidFrom());
                    Date date = fehlzeitBis = DateHelper.before((Date)beginnDatumFuerSVTageKuerzung, (Date)eeAbsentTimeTP.getValidUntil()) ? beginnDatumFuerSVTageKuerzung : eeAbsentTimeTP.getValidUntil();
                    if (!DateHelper.afterOrEqual((Date)beginnDatumFuerSVTageKuerzung, (Date)DateHelper.getFirstDayOfMonth((Date)validDate))) continue;
                    if (DateHelper.after((Date)fehlzeitBis, (Date)DateHelper.getLastDayOfMonth((Date)validDate))) {
                        fehlzeitBis = DateHelper.getLastDayOfMonth((Date)validDate);
                    }
                    fehltage = fehltage.add(BigDecimal.valueOf(DateHelper.getDiffInDays((Date)fehlzeitBis, (Date)fehlzeitAb)).add(BigDecimal.ONE).setScale(0));
                }
            }
        }
        return fehltage;
    }

    private Date getBeginnDatumFuerSVTageKuerzung(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, cal.get(5) - 1);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }
}

