/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.deuv.DataRecipientUtil;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.DeuvAcknowledgement;
import com.varial.personnel.domain.deuv.DeuvBasics;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuv.PerfidiaResult;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dban;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbap;
import com.varial.personnel.domain.deuvmessaging.basiccomponents.Dbna;
import com.varial.personnel.domain.eel.EelAdvice;
import com.varial.personnel.domain.eel.eelaccount.EelAccount;
import com.varial.personnel.domain.eel.eelaccount.EelAdviceStateEnum;
import com.varial.personnel.domain.eel.eelaccount.IEelAccountPersistencyManager;
import com.varial.personnel.domain.eel.eeldbae.EelDbae;
import com.varial.personnel.domain.eel.eeldbal.EelDbal;
import com.varial.personnel.domain.eel.eeldban.EelDban;
import com.varial.personnel.domain.eel.eeldbap.EelDbap;
import com.varial.personnel.domain.eel.eeldbaw.EelDbaw;
import com.varial.personnel.domain.eel.eeldbbe.EelDbbe;
import com.varial.personnel.domain.eel.eeldbee.EelDbee;
import com.varial.personnel.domain.eel.eeldbfe.EelDbfe;
import com.varial.personnel.domain.eel.eeldbfr.EelDbfr;
import com.varial.personnel.domain.eel.eeldbhe.EelDbhe;
import com.varial.personnel.domain.eel.eeldbid.EelDbid;
import com.varial.personnel.domain.eel.eeldblt.EelDblt;
import com.varial.personnel.domain.eel.eeldbmu.EelDbmu;
import com.varial.personnel.domain.eel.eeldbna.EelDbna;
import com.varial.personnel.domain.eel.eeldbsd.EelDbsd;
import com.varial.personnel.domain.eel.eeldbun.EelDbun;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvo;
import com.varial.personnel.domain.eel.eeldbvo.EelDbvoPart;
import com.varial.personnel.domain.eel.eeldbza.EelDbza;
import com.varial.personnel.domain.eel.eeldslw.EelDslw;
import com.varial.personnel.domain.eel.eeldslw.IEelDslwPersistencyManager;
import com.varial.personnel.domain.eel.receive.EelReceiveHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.PFileHelper;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EelReceive {
    private static final int LENGTH_TO_FILENUMBER = 53;
    private static final Pattern VOSZ_TO_FILENUMBER = Pattern.compile("VOSZSVEEL(\\d{8}).{7}.{15}.{8}(\\d{6})");
    private static final Pattern DSLW_VERSION13_CHECK = Pattern.compile("DSLWLEIST(.{15})(.{15})13(.*)");
    private static final Pattern DSLW = Pattern.compile("DSLWLEIST(.{15})(.{15})(\\d{2})(\\d{20})(\\d{1})(\\d{1})(.{12})(.{8})(.{15})(.{36})(.{7})(.{8})(.{8})(.{12})(.{15})(.{15})([JN])(\\d{2})(\\d{2})(\\d{1})([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])(.*)");
    private static final Pattern DSLW_V12 = Pattern.compile("DSLWLEIST(.{15})(.{15})(\\d{2})(\\d{20})(\\d{1})(\\d{1})(.{12})(.{8})(.{15})(.{32})(.{7})(.{8})(.{8})(.{12})(.{2})(.{15})(.{15})([JN])(\\d{2})(\\d{2})(\\d{1})([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])([JN])(.*)");
    private static final Pattern DBEE = Pattern.compile("DBEE(.{8})(.{8})(.{8})(.{2})(.*)");
    private static final Pattern DBVO = Pattern.compile("DBVO(.{1})(.{8})(.{8})(.{1})(.{8})(.{2})(.*)");
    private static final Pattern DBVOPART = Pattern.compile("(.{8})(.{8})(.{1})(.{8})(.{8})(.{1})(.{8})(.{8})(.*)");
    private static final Pattern DBHE = Pattern.compile("DBHE(.{8})(.{8})(.{8})(.*)");
    private static final Pattern DBAP = Pattern.compile("DBAP(.{30})(.{20})(.{20})(.{70})(.{30})(.{30})(.{30})(.{10})(.{34})(.{33})(.{9})(.*)");
    private static final Pattern DBAP_V12 = Pattern.compile("DBAP(.{1})(.{30})(.{20})(.{20})(.{70})(.{30})(.{30})(.{30})(.{10})(.{34})(.{33})(.{9})(.*)");
    private static final Pattern DBFR = Pattern.compile("DBFR(.{66})(.*)");
    private static final Pattern DBAL = Pattern.compile("DBAL(.{87})(.*)");
    private static final Pattern DBAE = Pattern.compile("DBAE(.{161})(.*)");
    private static final Pattern DBAW = Pattern.compile("DBAW(.{6})(.*)");
    private static final Pattern DBMU = Pattern.compile("DBMU(.{210})(.*)");
    private static final Pattern DBBE = Pattern.compile("DBBE(.{24})(.*)");
    private static final Pattern DBUN = Pattern.compile("DBUN(.{83})(.*)");
    private static final Pattern DBLT = Pattern.compile("DBLT(.{73})(.*)");
    private static final Pattern DBZA = Pattern.compile("DBZA(.{56})(.*)");
    private static final Pattern DBID = Pattern.compile("DBID(.{20})(.{20})(.{36})(.*)");
    private static final Pattern DBID_V12 = Pattern.compile("DBID(.{20})(.{20})(.*)");
    private static final Pattern DBSD = Pattern.compile("DBSD(.{36})(.{30})(.{30})(.{20})(.*)");
    private static final Pattern DBFE = Pattern.compile("DBFE(.{72})(.*)");
    private static final Pattern DBNA = Pattern.compile("DBNA(.{30})(.{30})(.{20})(.{20})(.{20})(.{1})(.*)");
    private static final Pattern DBAN = Pattern.compile("DBAN(.{3})(.{10})(.{34})(.{33})(.{9})(.{40})(.*)");
    private static final Pattern NCSZ = Pattern.compile("NCSZAGEEL(.{15}).{15}.{8}(\\d{6}).{8}(\\d{2})(.*)");
    private static final int DBEE_LENGTH = 30;
    private static final int DBVO_LENGTH = 32;
    private static final int DBVOPART_LENGTH = 50;
    private static final int DBHE_LENGTH = 28;
    private static final int DBAP_LENGTH = 320;
    private static final int DBAP_V12_LENGTH = 321;
    private static final int DBFR_LENGTH = 70;
    private static final int DBAL_LENGTH = 91;
    private static final int DBAE_LENGTH = 165;
    private static final int DBAW_LENGTH = 10;
    private static final int DBMU_LENGTH = 214;
    private static final int DBID_V12_LENGTH = 44;
    private static final int DBID_LENGTH = 80;
    private static final int DBSD_LENGTH = 120;
    private static final int DBFE_LENGTH = 76;
    private static final int DBNA_LENGTH = 125;
    private static final int DBAN_LENGTH = 133;
    private static final int DBBE_LENGTH = 28;
    private static final int DBUN_LENGTH = 87;
    private static final int DBLT_LENGTH = 77;
    private static final int DBZA_LENGTH = 60;
    private static final int DSLW_REST_GROUP = 41;
    private static final int DSLW_REST_GROUP_V13 = 40;
    private static final int NCSZ_REST_GROUP = 4;
    private final DEUVSender mDEUVSender;
    private final List<EelAccount> mImporteds;
    private final PerfidiaResult mPerfidiaResult;
    private File mCurrent;
    private final DeuvAcknowledgement mAcknowledgement;
    private final AuthorizationToken mToken;
    private Date mDatumVer;

    public EelReceive(DEUVSender deuvSender, AuthorizationToken token) {
        this.mDEUVSender = deuvSender;
        this.mPerfidiaResult = new PerfidiaResult();
        this.mImporteds = new ArrayList<EelAccount>();
        this.mAcknowledgement = new DeuvAcknowledgement(deuvSender);
        this.mToken = token;
    }

    public void readEelReceives(DEUVRecipient responder) throws BusinessDomainException {
        File[] files;
        String baseFolder = this.mDEUVSender.getPerfidiaPath();
        String subFolder = Deuv.getPerfidiaSubFolder((DEUVRecipient)responder);
        File dir = new File(String.format("%1$s%2$spem%2$srecv%2$s%3$s%2$sdat", baseFolder, File.separator, subFolder));
        PFileHelper.checkFolder((File)dir, (String)"Das Unterverzeichnis im Perfidia Datenordner");
        for (File each : files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String input = name.toUpperCase();
                return input.startsWith("EEEK0") || input.startsWith("TEEK0") || input.startsWith("EEEL0") || input.startsWith("TEEL0");
            }
        })) {
            PFileHelper.checkFile((File)each, (String)"Meldung Entgeltersatzleistung");
            this.readEelReceives(each, responder);
            SessionContext.getInstance().getPersistencySession().flush();
        }
    }

    private void readEelReceives(File input, DEUVRecipient responder) throws BusinessDomainException {
        this.mCurrent = input;
        CharSequence content = PFileHelper.getFileContent((File)input, (String)"ISO-8859-1", (int)53);
        Matcher matcher = VOSZ_TO_FILENUMBER.matcher(content);
        if (matcher.matches()) {
            int currentFileNumber = Integer.parseInt(matcher.group(2));
            LinkedList records = PFileHelper.getFileLines((File)input, (String)"ISO-8859-1");
            records.pollFirst();
            records.pollLast();
            if (input.getName().startsWith("EEEK0") || input.getName().startsWith("TEEK0")) {
                while (!records.isEmpty()) {
                    this.readDslw((String)records.pollFirst(), currentFileNumber, responder);
                }
                this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.AGEEK, responder, currentFileNumber);
            } else {
                int fileNumberSend = 0;
                records.pollFirst();
                records.pollFirst();
                while (!records.isEmpty()) {
                    if (((String)records.getFirst()).startsWith("DSLWLEIST")) {
                        this.readDslw((String)records.pollFirst(), currentFileNumber, responder);
                        continue;
                    }
                    fileNumberSend = this.readNcsz((String)records.pollFirst(), responder);
                }
                this.addProcessedFile(input, PerfidiaDataType.AGEEL, responder, fileNumberSend, currentFileNumber);
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcher);
        }
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private void addProcessedFile(File file, PerfidiaDataType perfidiaDataType, DEUVRecipient deuvRecipient, int fileNumberSend, int fileNumberRecv) throws BusinessDomainException {
        int perfidiaSubFolder = DataRecipientUtil.getSubFolderNumberByCompNo((String)deuvRecipient.getCurrentDEUVRecipientTP().getStdCompanyNumber());
        this.mAcknowledgement.addProcessedFile(file, perfidiaDataType, perfidiaSubFolder, fileNumberSend, fileNumberRecv);
    }

    private int readNcsz(String input, DEUVRecipient responder) throws BusinessDomainException {
        Matcher matcher = NCSZ.matcher(input);
        if (matcher.matches()) {
            String bbnrAbsender = this.asString(matcher.group(1));
            String dateiNr = this.asString(matcher.group(2));
            String rest = matcher.group(4);
            if (!StringMapper.isNullString((String)rest) && rest.startsWith("DBFE")) {
                EelAccount[] accounts;
                EelDbfe dbfeTemp = new EelDbfe();
                rest = this.initDbfe(rest, dbfeTemp);
                dbfeTemp.makeReadOnly();
                for (EelAccount account : accounts = EelAccount.getEelAccountsByFileNr((String)dateiNr, (DEUVRecipient)responder)) {
                    if (!account.getEelDslw().getBbnrAbsender().equals(bbnrAbsender)) continue;
                    account.makeSaveable();
                    if (dbfeTemp.getFehler().startsWith("NCSZH10")) {
                        account.setAdviceState(EelAdviceStateEnum.VERARBEITET);
                        continue;
                    }
                    account.setAdviceState(EelAdviceStateEnum.ABGELEHNT);
                    EelDbfe dbfe = new EelDbfe(account.getEelDslw());
                    dbfe.makeSaveable();
                    dbfe.setFehler(dbfeTemp.getFehler());
                    EelDbfe[] fehler = new EelDbfe[]{dbfe};
                    account.getEelDslw().setDbfe(fehler);
                    account.getEelDslw().setMmDbfe(true);
                    account.addError(dbfeTemp.getFehler());
                }
            }
            return Integer.parseInt(dateiNr);
        }
        throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + NCSZ);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readDslw(String input, int currentFileNumber, DEUVRecipient responder) throws BusinessDomainException {
        EelAccount account;
        EelDslw dslwtemp;
        Matcher matcher = DSLW_VERSION13_CHECK.matcher(input);
        if (matcher.matches()) {
            matcher = DSLW.matcher(input);
            if (!matcher.matches()) throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DSLW);
            dslwtemp = this.createEelDslw(matcher);
        } else {
            matcher = DSLW_V12.matcher(input);
            if (!matcher.matches()) throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.replace(' ', '.') + " don't match into: " + DSLW_V12);
            dslwtemp = this.createEelDslw(matcher);
        }
        EelAccount accountOrigin = this.getOrigin(dslwtemp);
        if (accountOrigin != null && dslwtemp.getAbgabegrund() != 61 && dslwtemp.getAbgabegrund() != 62 && dslwtemp.getAbgabegrund() != 66 && dslwtemp.getAbgabegrund() != 67 && dslwtemp.getAbgabegrund() != 71 && dslwtemp.getAbgabegrund() != 72) {
            account = accountOrigin;
            account.makeSaveable();
            account.setAdviceState(EelAdviceStateEnum.VERARBEITET);
            if (dslwtemp.getFehlerKennz().equals("1")) {
                account.getEelDslw().setDbfe(dslwtemp.getDbfe());
                account.getEelDslw().setFehlerKennz("1");
                account.getEelDslw().setFehlerAnzahl(dslwtemp.getFehlerAnzahl());
                account.setAdviceState(EelAdviceStateEnum.ABGELEHNT);
            }
            account.setAktenzeichenSV(dslwtemp.getDbid().getAktenzeichenSv());
            account.setCurrentFileNumber(currentFileNumber);
            account.setDEUVRecipient(responder);
            if (dslwtemp.getFehlerAnzahl() >= 1) {
                for (EelDbfe dbfe : dslwtemp.getDbfe()) {
                    account.addError(dbfe.getFehler());
                }
            }
            this.doActionsByReason(dslwtemp.getAbgabegrund(), account);
        } else {
            account = this.getAccount(dslwtemp);
            if (account.getEmployee() != null && (dslwtemp.getAbgabegrund() == 61 || dslwtemp.getAbgabegrund() == 62 || dslwtemp.getAbgabegrund() == 66 || dslwtemp.getAbgabegrund() == 67 || dslwtemp.getAbgabegrund() == 71 || dslwtemp.getAbgabegrund() == 72)) {
                account = new EelAccount(account.getEmployee());
                account.setErrorMessage(null);
                account.setEffectiveFrom(new Date());
                account.setCreatedOn(DeuvBasics.getCurrentDeuvDateString());
                account.setTransmitted(true);
                account.setCanceled("N");
                account.setErrorMessage("");
                account.setAktenzeichenVU(dslwtemp.getDbid().getAktenzeichenVu());
                account.setReasonOfDelivery(dslwtemp.getAbgabegrund());
                dslwtemp.makeSaveable();
                account.setEelDslw(dslwtemp);
                dslwtemp.setEelAccount(account);
                this.setDates(account);
                account.setAdviceState(EelAdviceStateEnum.VERARBEITET);
                if (dslwtemp.getFehlerKennz().equals("1")) {
                    account.getEelDslw().setDbfe(dslwtemp.getDbfe());
                    account.getEelDslw().setFehlerKennz("1");
                    account.getEelDslw().setFehlerAnzahl(dslwtemp.getFehlerAnzahl());
                    account.setAdviceState(EelAdviceStateEnum.ABGELEHNT);
                }
                account.setAktenzeichenSV(dslwtemp.getDbid().getAktenzeichenSv());
                account.setCurrentFileNumber(currentFileNumber);
                account.setDEUVRecipient(responder);
                if (dslwtemp.getFehlerAnzahl() >= 1) {
                    for (EelDbfe dbfe : dslwtemp.getDbfe()) {
                        account.addError(dbfe.getFehler());
                    }
                }
                if (EelAccount.hasEelAccountToParse((String)account.getEmployee().getObjectid(), (Date)account.getValidFrom(), (int)account.getReasonOfDelivery(), (int)account.getCurrentFileNumber())) {
                    account.makeReadOnly();
                }
                this.doActionsByReason(dslwtemp.getAbgabegrund(), account);
            }
        }
        this.mImporteds.add(account);
    }

    private void setDates(EelAccount account) {
        switch (account.getReasonOfDelivery()) {
            case 61: {
                account.setValidFrom(account.getEelDslw().getDbvo().getAuAbag());
                break;
            }
            case 62: {
                account.setValidFrom(account.getEelDslw().getDbee().getEelAbAg());
                if (account.getValidFrom() == null) {
                    account.setValidFrom(account.getEelDslw().getDbee().getEelAbSv());
                }
                account.setValidUntil(account.getEelDslw().getDbee().getEelEnde());
                break;
            }
            case 66: {
                account.setValidFrom(this.mDatumVer);
                break;
            }
            case 67: {
                account.setValidFrom(this.mDatumVer);
                break;
            }
            case 71: {
                account.setValidFrom(account.getEelDslw().getDbhe().getZahlBeginn());
                break;
            }
            case 72: {
                account.setValidFrom(account.getEelDslw().getDbfr().getFreiStVom());
                break;
            }
        }
    }

    private EelAccount getAccount(EelDslw dslwtemp) {
        Employee emp;
        PCompany company;
        EelAccount account = null;
        if (dslwtemp.getDbid() == null) {
            account = new EelAccount(null, true);
            account.addError("Der Baustein DBID fehlt. Keine Zuordnung m\u00f6glich und Pr\u00fcfung notwendig.");
            return account;
        }
        String[] domain = EelReceive.getDomain(dslwtemp);
        if (domain != null && this.isValid(domain[0], false, 20) && (company = PCompanyPersistencyManager.getPCompanyByKey((String)domain[0])) != null && this.isValid(domain[1], true, 8) && (emp = EelReceive.getIEmployeePM().getEmployeeByKey(company, domain[1])) != null) {
            account = new EelAccount(emp, true);
            account.addError("R\u00fcckmeldung wurde nicht eingelesen, da das EEL-Meldekonto nicht gefunden wurde.");
            return account;
        }
        account = new EelAccount(null, true);
        account.addError("Zuordnung zum Mitarbeiter anhand AZVU nicht m\u00f6glich: " + dslwtemp.getDbid().getAktenzeichenVu());
        return account;
    }

    public static String[] getDomain(EelDslw dslwtemp) {
        String azvu = dslwtemp.getDbid().getAktenzeichenVu();
        if (azvu == null) {
            return null;
        }
        String[] domain = azvu.split(" / ");
        if (domain == null || domain.length != 2) {
            return null;
        }
        return domain;
    }

    private EelAccount getOrigin(EelDslw dslwtemp) {
        EelAccount result;
        if (dslwtemp.getDbid() != null && this.isValid(dslwtemp.getDbid().getReferenzId(), true, 18) && (result = this.getReceived(dslwtemp.getDbid().getReferenzId())) != null) {
            return result;
        }
        if (!this.isValid(dslwtemp.getDatensatzId(), true, 18)) {
            return null;
        }
        return this.getReceivedOid(dslwtemp.getDatensatzId());
    }

    private boolean isValid(String stringToCheck, boolean mustNumeric, int size) {
        if (StringMapper.isNullString((String)stringToCheck)) {
            return false;
        }
        if (mustNumeric && !StringUtils.isNumeric((CharSequence)stringToCheck)) {
            return false;
        }
        return stringToCheck.length() <= size;
    }

    private void doActionsByReason(int reason, EelAccount account) throws BusinessDomainException {
        if (account.getEelDslw().hasMmDbee() && account.getEelDslw().getDbee().getEelEndeGrund() == 1) {
            account.addError("kein Leistungsbezug - \u00fcberpr\u00fcfen und \u00e4ndern Sie die Mitarbeiter - Fehlzeit!");
        }
        EEAbsentTimeTP tp = null;
        switch (reason) {
            case 71: {
                tp = account.getEEAbsentTimeTP();
                if (tp == null) {
                    account.addError("Zuordnung zur Mitarbeiter-Fehlzeit nicht m\u00f6glich.");
                    break;
                }
                boolean eelBrutto = this.getEelTakeoverOfGrossSickPay(account);
                tp.setStickPay(this.getHelper().getEelAmount(account, eelBrutto));
                tp.makeSaveable();
                tp.updateFromEELOrEAU(this.mToken);
                break;
            }
            case 66: {
                EelAccount accountOrigin = this.getOrigin(account.getEelDslw());
                if (accountOrigin != null) {
                    EelAdvice advice = new EelAdvice(accountOrigin.getEmployee().getPCompany());
                    EelAdviceStateEnum origin = accountOrigin.getAdviceState();
                    EelAccount storno = advice.makeCancellation(accountOrigin);
                    accountOrigin.setAdviceState(origin);
                    advice.checkAttributes(storno);
                    if (!storno.hasErrors()) {
                        storno.setAdviceState(EelAdviceStateEnum.BEREIT);
                    } else {
                        storno.setAdviceState(EelAdviceStateEnum.AUFGEBAUT);
                    }
                    account.addError("Ursprungsmeldung wurde storniert. Bitte Neumeldung mit zur\u00fcckgemeldetem Abgabegrund aufbauen.");
                    break;
                }
                account.addError("Ursprungsmeldung konnte nicht ermittelt werden. Bitte manuell stornieren und mit Abgabegrund " + account.getEelDslw().getKorrabgabegrund() + " neumelden.");
                break;
            }
            case 62: {
                Date eelEnde = account.getEelDslw().getDbee().getEelEnde();
                if (eelEnde == null) break;
                tp = account.getEEAbsentTimeTP();
                if (tp == null) {
                    account.addError("Zuordnung zur Mitarbeiter-Fehlzeit nicht m\u00f6glich");
                    break;
                }
                if (tp.getValidUntil() != null) {
                    account.addError("Die Mitarbeiter-Fehlzeit wurde bereits begrenzt. Bitte pr\u00fcfen und ggf. manuell bearbeiten.");
                    break;
                }
                tp.setValidUntil(eelEnde);
                tp.makeSaveable();
                tp.updateFromEELOrEAU(this.mToken);
                break;
            }
        }
    }

    private EelReceiveHelper getHelper() {
        return (EelReceiveHelper)UtilitiesManager.getApplicationContext().getBean("eelReceiveHelper");
    }

    private EelDslw createEelDslw(Matcher matcher) throws BusinessDomainException {
        EelDslw dslw = this.initEelDslw(matcher);
        int restgrp = 41;
        if (Integer.valueOf(dslw.getEelVersion()) >= 13) {
            restgrp = 40;
        }
        String rest = matcher.group(restgrp);
        if (dslw.hasMmDbna()) {
            rest = this.initDbna(rest, dslw.getDbna());
        }
        if (dslw.hasMmDban()) {
            rest = this.initDban(rest, dslw.getDban());
        }
        if (dslw.hasMmDbal()) {
            rest = this.initDbal(rest, dslw.getDbal());
        }
        if (dslw.hasMmDbae()) {
            rest = this.initDbae(rest, dslw.getDbae());
        }
        if (dslw.hasMmDbza()) {
            rest = this.initDbza(rest, dslw.getDbza());
        }
        if (dslw.hasMmDbee()) {
            rest = this.initDbee(rest, dslw.getDbee());
        }
        if (dslw.hasMmDbaw()) {
            rest = this.initDbaw(rest, dslw.getDbaw());
        }
        if (dslw.hasMmDbfr()) {
            rest = this.initDbfr(rest, dslw.getDbfr());
        }
        if (dslw.hasMmDbun()) {
            rest = this.initDbun(rest, dslw.getDbun());
        }
        if (dslw.hasMmDbmu()) {
            rest = this.initDbmu(rest, dslw.getDbmu());
        }
        if (dslw.hasMmDbvo()) {
            rest = this.initDbvo(rest, dslw.getDbvo());
            if (dslw.getDbvo().getAnzahlAu() > 0) {
                rest = this.initDbvoParts(rest, dslw);
            }
        }
        if (dslw.hasMmDbhe()) {
            rest = this.initDbhe(rest, dslw.getDbhe());
        }
        if (dslw.hasMmDbbe()) {
            rest = this.initDbbe(rest, dslw.getDbbe());
        }
        if (dslw.hasMmDblt()) {
            rest = this.initDblt(rest, dslw.getDblt());
        }
        if (dslw.hasMmDbap()) {
            rest = this.initDbap(rest, dslw.getDbap());
        }
        if (dslw.hasMmDbid()) {
            rest = this.initDbid(rest, dslw.getDbid());
        }
        if (dslw.hasMmDbsd()) {
            rest = this.initDbsd(rest, dslw.getDbsd());
        }
        if (rest != null) {
            rest = this.initDbfes(rest, dslw);
        }
        dslw.makeReadOnly();
        return dslw;
    }

    private EelDslw initEelDslw(Matcher matcher) {
        String mmsd;
        EelDslw dslw = new EelDslw();
        int i = 1;
        String bbnrab = this.asString(matcher.group(i++));
        String bbnrep = this.asString(matcher.group(i++));
        String version = this.asString(matcher.group(i++));
        String datumer = this.asString(matcher.group(i++));
        String fehlerkennz = this.asString(matcher.group(i++));
        String fehleranzahl = this.asString(matcher.group(i++));
        String vsnr = this.asString(matcher.group(i++));
        String geburtsdat = this.asString(matcher.group(i++));
        String bbnrvu = this.asString(matcher.group(i++));
        String datensatzID = this.asString(matcher.group(i++));
        String prodid = this.asString(matcher.group(i++));
        String modid = this.asString(matcher.group(i++));
        String datumver = this.asString(matcher.group(i++));
        String uhrzeitver = this.asString(matcher.group(i++));
        if (Integer.valueOf(version) <= 12) {
            String string = this.asString(matcher.group(i++));
        }
        String bbnrkk = this.asString(matcher.group(i++));
        String bbnras = this.asString(matcher.group(i++));
        String rueckEEL = this.asString(matcher.group(i++));
        String gd = this.asString(matcher.group(i++));
        String korrgd = this.asString(matcher.group(i++));
        String abprog = this.asString(matcher.group(i++));
        if (Integer.valueOf(version) <= 12) {
            String kennzst = this.asString(matcher.group(i++));
            dslw.setKennzStorno(kennzst);
        } else {
            dslw.setKennzStorno("N");
        }
        String mmna = this.asString(matcher.group(i++));
        String mman = this.asString(matcher.group(i++));
        String mmal = this.asString(matcher.group(i++));
        String mmae = this.asString(matcher.group(i++));
        String mmza = this.asString(matcher.group(i++));
        String mmee = this.asString(matcher.group(i++));
        String mmaw = this.asString(matcher.group(i++));
        String mmfr = this.asString(matcher.group(i++));
        String mmun = this.asString(matcher.group(i++));
        String mmmu = this.asString(matcher.group(i++));
        String mmvo = this.asString(matcher.group(i++));
        String mmhe = this.asString(matcher.group(i++));
        String mmbe = this.asString(matcher.group(i++));
        String mmlt = this.asString(matcher.group(i++));
        String mmsf = this.asString(matcher.group(i++));
        String mmtk = this.asString(matcher.group(i++));
        String mmap = this.asString(matcher.group(i++));
        String mmid = this.asString(matcher.group(i++));
        if (Integer.valueOf(version) >= 13 && "J".equals(mmsd = this.asString(matcher.group(i++)))) {
            dslw.createDbsd();
            dslw.setKennzStorno("J");
        }
        dslw.setBbnrAbsender(bbnrab);
        dslw.setBbnrEmpfaenger(bbnrep);
        dslw.setEelVersion(Integer.valueOf(version).intValue());
        dslw.setDatumErstellung(datumer);
        dslw.setFehlerKennz(fehlerkennz);
        dslw.setFehlerAnzahl(Integer.valueOf(fehleranzahl).intValue());
        dslw.setVersicherungsnr(vsnr);
        dslw.setGeburtsDat(this.toDateYYYYMMDD(geburtsdat));
        dslw.setBbnrVU(bbnrvu);
        dslw.setDatensatzId(datensatzID);
        dslw.setProdId(prodid);
        dslw.setModId(modid);
        this.mDatumVer = this.toDateYYYYMMDD(datumver);
        if (this.mDatumVer == null) {
            this.mDatumVer = this.toDateYYYYMMDD(datumer.substring(0, 8));
        }
        dslw.setBbnrKK(bbnrkk);
        dslw.setRueckEntgeltErsatz(rueckEEL);
        dslw.setAbgabegrund(Integer.valueOf(gd).intValue());
        dslw.setKorrabgabegrund(Integer.valueOf(korrgd).intValue());
        dslw.setAbrechnungsprogramm(Integer.valueOf(abprog).intValue());
        if ("J".equals(mmna)) {
            dslw.createDbna();
        }
        if ("J".equals(mman)) {
            dslw.createDban();
        }
        if ("J".equals(mmal)) {
            dslw.createDbal();
        }
        if ("J".equals(mmae)) {
            dslw.createDbae();
        }
        if ("J".equals(mmza)) {
            dslw.createDbza();
        }
        if ("J".equals(mmee)) {
            dslw.createDbee();
        }
        if ("J".equals(mmaw)) {
            dslw.createDbaw();
        }
        if ("J".equals(mmfr)) {
            dslw.createDbfr();
        }
        if ("J".equals(mmun)) {
            dslw.createDbun();
        }
        if ("J".equals(mmmu)) {
            dslw.createDbmu();
        }
        if ("J".equals(mmvo)) {
            dslw.createDbvo();
        }
        if ("J".equals(mmhe)) {
            dslw.createDbhe();
        }
        if ("J".equals(mmbe)) {
            dslw.createDbbe();
        }
        if ("J".equals(mmlt)) {
            dslw.createDblt();
        }
        if ("J".equals(mmap)) {
            dslw.createDbap();
        }
        if ("J".equals(mmid)) {
            dslw.createDbid();
        }
        return dslw;
    }

    private String initDbna(String input, EelDbna dbna) {
        Matcher matcher = this.checkInputGetMatcher(input, 125, DBNA);
        int i = 1;
        String familienname = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String vorsatzwort = this.asString(matcher.group(i++));
        String namenszusatz = this.asString(matcher.group(i++));
        String titel = this.asString(matcher.group(i++));
        Dbna data = new Dbna();
        data.setFamilienname(familienname);
        data.setVorname(vorname);
        data.setVorsatzwort(vorsatzwort);
        data.setNamenszusatz(namenszusatz);
        data.setTitel(titel);
        dbna.setDbnaData(data);
        return matcher.group(++i);
    }

    private String initDban(String input, EelDban dban) {
        Matcher matcher = this.checkInputGetMatcher(input, 133, DBAN);
        int i = 1;
        String ldkz = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String wohnort = this.asString(matcher.group(i++));
        String strasse = this.asString(matcher.group(i++));
        String hausnr = this.asString(matcher.group(i++));
        String zusatz = this.asString(matcher.group(i++));
        Dban data = new Dban();
        data.setLaenderkennz(ldkz);
        data.setPostleitzahl(plz);
        data.setWohnort(wohnort);
        data.setStrasse(strasse);
        data.setHausnummer(hausnr);
        data.setAnschriftenzusatz(zusatz);
        dban.setDbanData(data);
        return matcher.group(i);
    }

    private String initDbee(String input, EelDbee dbee) {
        Matcher matcher = this.checkInputGetMatcher(input, 30, DBEE);
        int i = 1;
        String eelAbAg = this.asString(matcher.group(i++));
        String eelAbSv = this.asString(matcher.group(i++));
        String eelEnde = this.asString(matcher.group(i++));
        String eelEndeGrund = this.asString(matcher.group(i++));
        dbee.setEelAbAg(this.toDateYYYYMMDD(eelAbAg));
        dbee.setEelAbSv(this.toDateYYYYMMDD(eelAbSv));
        dbee.setEelEnde(this.toDateYYYYMMDD(eelEnde));
        dbee.setEelEndeGrund(Integer.valueOf(eelEndeGrund).intValue());
        return matcher.group(i);
    }

    private String initDbvo(String input, EelDbvo dbvo) {
        Matcher matcher = this.checkInputGetMatcher(input, 32, DBVO);
        int i = 1;
        String grundav = this.asString(matcher.group(i++));
        String auabag = this.asString(matcher.group(i++));
        String auabsv = this.asString(matcher.group(i++));
        String kzakau = this.asString(matcher.group(i++));
        String monatsfristab = this.asString(matcher.group(i++));
        String anzahlau = this.asString(matcher.group(i++));
        dbvo.setGrundAv(Integer.valueOf(grundav).intValue());
        dbvo.setAuAbag(this.toDateYYYYMMDD(auabag));
        dbvo.setAuAbsv(this.toDateYYYYMMDD(auabsv));
        dbvo.setKzAkau(Integer.valueOf(kzakau).intValue());
        if (dbvo.getEelDslw().getEelVersion() == 11) {
            dbvo.setMonatsfristab(this.toDateYYYYMMDD(monatsfristab));
        }
        dbvo.setAnzahlAu(Integer.valueOf(anzahlau).intValue());
        return matcher.group(i);
    }

    private String initDbvoParts(String input, EelDslw dbslw) throws BusinessDomainException {
        String rest = input;
        EelDbvoPart[] parts = new EelDbvoPart[dbslw.getDbvo().getAnzahlAu()];
        for (int i = 0; i < dbslw.getDbvo().getAnzahlAu(); ++i) {
            parts[i] = new EelDbvoPart(dbslw.getDbvo());
            parts[i].setEelDbvo(dbslw.getDbvo());
            rest = this.initDbvoPart(rest, parts[i]);
        }
        dbslw.getDbvo().setEelDbvoParts(parts);
        return rest;
    }

    private String initDbvoPart(String input, EelDbvoPart part) {
        Matcher matcher = this.checkInputGetMatcher(input, 50, DBVOPART);
        int i = 1;
        String beginnau = this.asString(matcher.group(i++));
        String endeau = this.asString(matcher.group(i++));
        String kznachw = this.asString(matcher.group(i++));
        String teilnachwbeginn = this.asString(matcher.group(i++));
        String teilnachwende = this.asString(matcher.group(i++));
        String kzau = this.asString(matcher.group(i++));
        String teilanrbeginn = this.asString(matcher.group(i++));
        String teilanrende = this.asString(matcher.group(i++));
        part.setBeginnAu(this.toDateYYYYMMDD(beginnau));
        part.setEndeAu(this.toDateYYYYMMDD(endeau));
        part.setKzNachweis(Integer.valueOf(kznachw).intValue());
        part.setTeilNachweisAuBeginn(this.toDateYYYYMMDD(teilnachwbeginn));
        part.setTeilNachweisAuEnde(this.toDateYYYYMMDD(teilnachwende));
        part.setKzAu(Integer.valueOf(kzau).intValue());
        part.setTeilAnrAuBeginn(this.toDateYYYYMMDD(teilanrbeginn));
        part.setTeilAnrAuEnde(this.toDateYYYYMMDD(teilanrende));
        return matcher.group(i);
    }

    private String initDbfr(String input, EelDbfr dbfr) {
        Matcher matcher = this.checkInputGetMatcher(input, 70, DBFR);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbal(String input, EelDbal dbal) {
        Matcher matcher = this.checkInputGetMatcher(input, 91, DBAL);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbae(String input, EelDbae dbae) {
        Matcher matcher = this.checkInputGetMatcher(input, 165, DBAE);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbaw(String input, EelDbaw dbaw) {
        Matcher matcher = this.checkInputGetMatcher(input, 10, DBAW);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbmu(String input, EelDbmu dbmu) {
        Matcher matcher = this.checkInputGetMatcher(input, 214, DBMU);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbbe(String input, EelDbbe dbbe) {
        Matcher matcher = this.checkInputGetMatcher(input, 28, DBBE);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbun(String input, EelDbun dbun) {
        Matcher matcher = this.checkInputGetMatcher(input, 87, DBUN);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDblt(String input, EelDblt dblt) {
        Matcher matcher = this.checkInputGetMatcher(input, 77, DBLT);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbza(String input, EelDbza dbza) {
        Matcher matcher = this.checkInputGetMatcher(input, 60, DBZA);
        int i = 1;
        String content = this.asString(matcher.group(i++));
        return matcher.group(i);
    }

    private String initDbap(String input, EelDbap dbap) {
        Matcher matcher = dbap.getEelDslw().getEelVersion() >= 13 ? this.checkInputGetMatcher(input, 320, DBAP) : this.checkInputGetMatcher(input, 321, DBAP_V12);
        int i = 1;
        Dbap data = new Dbap();
        if (dbap.getEelDslw().getEelVersion() < 13) {
            String anrap = this.asString(matcher.group(i++));
            data.setAnrap(anrap);
        }
        String nameap = this.asString(matcher.group(i++));
        String telap = this.asString(matcher.group(i++));
        String faxap = this.asString(matcher.group(i++));
        String emailap = this.asString(matcher.group(i++));
        String name1 = this.asString(matcher.group(i++));
        String name2 = this.asString(matcher.group(i++));
        String name3 = this.asString(matcher.group(i++));
        String plz = this.asString(matcher.group(i++));
        String ort = this.asString(matcher.group(i++));
        String strasse = this.asString(matcher.group(i++));
        String hausnr = this.asString(matcher.group(i++));
        data.setNameap(nameap);
        data.setTelap(telap);
        data.setFaxap(faxap);
        data.setEmailap(emailap);
        data.setName1(name1);
        data.setName2(name2);
        data.setName3(name3);
        data.setPlz(plz);
        data.setOrt(ort);
        data.setStrasse(strasse);
        data.setHausnr(hausnr);
        dbap.setDbapData(data);
        return matcher.group(i);
    }

    private String initDbhe(String input, EelDbhe dbhe) {
        Matcher matcher = this.checkInputGetMatcher(input, 28, DBHE);
        int i = 1;
        String zahlbeginn = this.asString(matcher.group(i++));
        String eelbrutto = this.asString(matcher.group(i++));
        String eelnetto = this.asString(matcher.group(i++));
        dbhe.setZahlBeginn(this.toDateYYYYMMDD(zahlbeginn));
        dbhe.setEelBrutto(this.asCents(eelbrutto));
        dbhe.setEelNetto(this.asCents(eelnetto));
        return matcher.group(i);
    }

    private Date toDateYYYYMMDD(String date) {
        if ("99999999".equals(date)) {
            return null;
        }
        return PDateHelper.toDateYYYYMMDD((String)date);
    }

    private String initDbid(String input, EelDbid dbid) {
        Matcher matcher = dbid.getEelDslw().getEelVersion() >= 13 ? this.checkInputGetMatcher(input, 80, DBID) : this.checkInputGetMatcher(input, 44, DBID_V12);
        int i = 1;
        String azsv = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        dbid.setAktenzeichenSv(azsv);
        dbid.setAktenzeichenVu(azvu);
        if (dbid.getEelDslw().getEelVersion() >= 13) {
            String referenzId = this.asString(matcher.group(i++));
            dbid.setReferenzId(referenzId);
        }
        return matcher.group(i);
    }

    private String initDbsd(String input, EelDbsd dbsd) {
        Matcher matcher = this.checkInputGetMatcher(input, 120, DBSD);
        int i = 1;
        String datensatzidursprung = this.asString(matcher.group(i++));
        String vorname = this.asString(matcher.group(i++));
        String familienname = this.asString(matcher.group(i++));
        String azvu = this.asString(matcher.group(i++));
        dbsd.setDatensatzidursprung(datensatzidursprung);
        dbsd.setVorname(vorname);
        dbsd.setFamilienname(familienname);
        dbsd.setAktenzeichenVu(azvu);
        return matcher.group(i);
    }

    private String initDbfe(String input, EelDbfe dbfe) {
        Matcher matcher = this.checkInputGetMatcher(input, 76, DBFE);
        int i = 1;
        String fehler = this.asString(matcher.group(i++));
        dbfe.setFehler(fehler);
        return matcher.group(i);
    }

    private String initDbfes(String input, EelDslw dbslw) throws BusinessDomainException {
        String rest = input;
        EelDbfe[] fes = new EelDbfe[dbslw.getFehlerAnzahl()];
        for (int i = 0; i < dbslw.getFehlerAnzahl(); ++i) {
            fes[i] = new EelDbfe(dbslw);
            rest = this.initDbfe(rest, fes[i]);
        }
        dbslw.setDbfe(fes);
        return rest;
    }

    private EelAccount getReceivedOid(String oid) {
        EelAccount[] receiveds = this.getPm().query(null, Restrictions.eq((String)"OBJECTID", (String)oid), true);
        if (receiveds == null || receiveds.length == 0) {
            return null;
        }
        return receiveds[0];
    }

    private EelAccount getReceived(String id) {
        EelDslw[] receiveds = this.getPmDslw().query(null, Restrictions.eq((String)"DATENSATZID", (String)id), true);
        if (receiveds == null || receiveds.length == 0) {
            return null;
        }
        return receiveds[0].getEelAccount();
    }

    public void writeAcknowledgements() throws BusinessDomainException {
        this.mAcknowledgement.writeAcknowledgements();
    }

    public void writePerfidiaFiles() {
        this.mAcknowledgement.writePerfidiaFiles();
        this.mPerfidiaResult.writePerfidiaFiles();
    }

    public boolean hasImporteds() {
        return !this.mImporteds.isEmpty();
    }

    public List<EelAccount> getImporteds() {
        return Collections.unmodifiableList(this.mImporteds);
    }

    public DEUVSender getDEUVSender() {
        return this.mDEUVSender;
    }

    private IEelAccountPersistencyManager getPm() {
        return (IEelAccountPersistencyManager)UtilitiesManager.getBean((String)"eelAccountPersistencyManager", IEelAccountPersistencyManager.class);
    }

    private IEelDslwPersistencyManager getPmDslw() {
        return (IEelDslwPersistencyManager)UtilitiesManager.getBean((String)"eelDslwPersistencyManager", IEelDslwPersistencyManager.class);
    }

    private String asString(String value) {
        return StringMapper.toStringWithTrim((String)value);
    }

    private BigDecimal asCents(String source) {
        int unscaledValue = Integer.parseInt(source);
        return BigDecimal.valueOf(unscaledValue, 2);
    }

    private Matcher checkInputGetMatcher(String input, int length, Pattern pattern) {
        if (input.length() < length) {
            throw new IllegalArgumentException(this.mCurrent.getPath() + ": Input is to short: " + input.replace(' ', '.'));
        }
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalStateException(this.mCurrent.getPath() + ": " + input.substring(0, length).replace(' ', '.') + " don't match into: " + pattern);
        }
        return matcher;
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private boolean getEelTakeoverOfGrossSickPay(EelAccount account) throws BusinessDomainException {
        Employee emp = account.getEmployee();
        if (emp == null) {
            return false;
        }
        Plant plant = emp.getAppurtenantPlant(VDate.getDateMax(), account.getValidFrom());
        PCompany comp = emp.getPCompany();
        if (plant != null && plant.getPlantFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getEelTakeoverOfGrossSickPay()) {
            return true;
        }
        return comp != null && comp.getCompanyFoundations(VDate.getDateMax(), account.getValidFrom()).getFoundations().getEelTakeoverOfGrossSickPay();
    }
}

