/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.typeofvalue.foundation;

import com.varial.base.CacheUtil;
import com.varial.base.UtilitiesManager;
import com.varial.base.cache.Cache;
import com.varial.base.cache.CacheProvider;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.designationtype.designation.TypeOfDesignationEnum;
import com.varial.personnel.domain.typeofvalue.ValueTypeTPPersistencyManager;
import com.varial.personnel.domain.typeofvalue.basictypes.BlankLineEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ClassificationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.CompressionEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.CompressionOnAccountOfMovementEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ERAEvaluationEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.ERASystemCostsEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.FontEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.NoPrintByZeroEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.PrintEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.TypeOfPaymentEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.TypeOfValueTypeEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.BlankLineEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.CategoryEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.ClassificationEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.CompressionEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.CompressionOnAccountOfMovementEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.ERAEvaluationEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.ERASystemCostsEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.FontEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.NoPrintByZeroEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.PrintEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.TypeOfPaymentEnumMapper;
import com.varial.personnel.domain.typeofvalue.basictypes.mapper.TypeOfValueTypeEnumMapper;
import com.varial.personnel.domain.typeofvalue.foundation.ValueTypeFoundation;
import com.varial.personnel.domain.typeofvalue.foundation.ValueTypeFoundationData;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.typeofvalue.foundation.printsettings.FoundationPrintSettings;
import com.varial.personnel.framework.basictypes.Interval;
import com.varial.personnel.persistency.typeofValue.valuetypesall.ValuetypesallContainer;
import com.varial.personnel.persistency.typeofValue.vtfoundations.IVtfoundationsDao;
import com.varial.personnel.persistency.typeofValue.vtfoundations.VtfoundationsContainer;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.util.Set;
import net.sf.ehcache.Element;

public final class ValueTypeFoundationPersistencyManager {
    private static IVtfoundationsDao dao = (IVtfoundationsDao)UtilitiesManager.getApplicationContext().getBean("vtfoundationsDao");
    private static CacheProvider cacheManager = (CacheProvider)UtilitiesManager.getGenericAccessor().getBean("localCacheManager", CacheProvider.class);

    public static ValueTypeFoundation getValueTypeFoundation(String objectid) {
        ValueTypeFoundation result;
        Cache cache = cacheManager.getCache("ValueTypeFoundation");
        IPersistentObject po = CacheUtil.value((Element)cache.get((Object)objectid));
        if (po == null) {
            result = new ValueTypeFoundation(objectid);
            cache.put(CacheUtil.element((IPersistentObject)result));
        } else {
            result = (ValueTypeFoundation)po;
        }
        return result;
    }

    public static void load(Set<String> oidSet, boolean readOnly) {
        try {
            if (oidSet.isEmpty()) {
                return;
            }
            VtfoundationsContainer[] containers = dao.getRows(null, Restrictions.in((String)"objectid", oidSet));
            int count = containers.length;
            ValueTypeFoundation vtFoundation = null;
            Cache cache = cacheManager.getCache("ValueTypeFoundation");
            for (int i = 0; i < count; ++i) {
                IPersistentObject po = CacheUtil.value((Element)cache.get((Object)containers[i].getObjectid()));
                if (po != null) continue;
                vtFoundation = new ValueTypeFoundation(readOnly);
                ValueTypeFoundationPersistencyManager.fillValueTypeFoundation(vtFoundation, containers[i]);
                cache.put(CacheUtil.element((IPersistentObject)vtFoundation));
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static ValueTypeFoundation[] query(Order[] sortierung, Criterion filters, boolean readOnly) {
        try {
            VtfoundationsContainer[] containers = dao.getRows(sortierung, filters);
            ValueTypeFoundation[] result = new ValueTypeFoundation[containers.length];
            for (int i = 0; i < containers.length; ++i) {
                result[i] = new ValueTypeFoundation(readOnly);
                ValueTypeFoundationPersistencyManager.fillValueTypeFoundation(result[i], containers[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void load(ValueTypeFoundation vtf) {
        VtfoundationsContainer container = null;
        try {
            container = dao.getRowByObjectID(vtf.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)vtf.getObjectid());
        }
        ValueTypeFoundationPersistencyManager.fillValueTypeFoundation(vtf, container);
    }

    public static void save(ValueTypeFoundation vtf) {
        VtfoundationsContainer container = dao.getInitializedInstance();
        ValueTypeFoundationPersistencyManager.fillContainer(container, vtf);
        try {
            container = vtf.isNew() ? dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        vtf.setLastuser(container.getLastUserid());
        vtf.setObjectid(container.getObjectid());
        vtf.setTimestamp(container.getObjectTS());
        vtf.setVersion(container.getVersion());
    }

    public static void delete(ValueTypeFoundation vtf) {
        try {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), vtf.getObjectid(), vtf.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static void fillValueTypeFoundation(ValueTypeFoundation vtf, VtfoundationsContainer container) {
        vtf.setObjectid(container.getObjectid());
        vtf.setTimestamp(container.getObjectTS());
        vtf.setLastuser(container.getLastUserid());
        vtf.setVersion(container.getVersion());
        Designation valueTypeGroup = null;
        if (!StringMapper.isNullString((String)container.oidvaluetypegroup)) {
            valueTypeGroup = Designation.getDesignation((String)container.oidvaluetypegroup, (TypeOfDesignationEnum)TypeOfDesignationEnum.TODE_VALUETYPEGROUP);
        }
        ValuetypesallContainer[] shortvts = ValueTypeTPPersistencyManager.queryAll((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidvtfoundation", (String)container.getObjectid())}));
        int vTNr = shortvts[0].valuetypenumber;
        int rankingnumber = container.rankingnumber;
        switch (vTNr) {
            case 770120: {
                rankingnumber = 200120;
                break;
            }
            case 770130: {
                rankingnumber = 200130;
                break;
            }
            case 770140: {
                rankingnumber = 200140;
                break;
            }
            case 770150: {
                rankingnumber = 200150;
                break;
            }
            case 771120: {
                rankingnumber = 201120;
                break;
            }
            case 771130: {
                rankingnumber = 201130;
                break;
            }
            case 771140: {
                rankingnumber = 201140;
                break;
            }
            case 771150: {
                rankingnumber = 201150;
                break;
            }
        }
        vtf.setData(new ValueTypeFoundationData(new FoundationGeneral(CategoryEnumMapper.toCategoryEnum((int)container.category), ClassificationEnumMapper.toClassificationEnum((int)container.classification), rankingnumber, container.shortdescription, container.longdescription, container.description, TypeOfValueTypeEnumMapper.toTypeOfValueTypeEnum((int)container.typeofvaluetype), container.specification, valueTypeGroup, new Interval(container.january, container.february, container.march, container.april, container.may, container.june, container.july, container.august, container.september, container.oktober, container.november, container.december, container.annualnterval), container.calculationassista, container.resultassistant, container.createsingle, container.isnetwage, TypeOfPaymentEnumMapper.toTypeOfPaymentEnum((int)container.typeofpayment), ERASystemCostsEnumMapper.toERASystemCostsEnum((int)container.erasystemcosts), ERAEvaluationEnumMapper.toERAEvaluationEnum((int)container.eraevaluation), container.paidovertimehour, TypeOfPaymentEnumMapper.toTypeOfPaymentEnum((int)container.shtypeofpayment), container.useintervalincalc, container.createautomatic), new FoundationPrintSettings(CompressionEnumMapper.toCompressionEnum((int)container.compressiononsoe), CompressionEnumMapper.toCompressionEnum((int)container.compressionongj), container.costjournalfactor1, container.costjournalresult, container.mmpayrollresult, container.yypayrollfactor1, container.yypayrollresult, PrintEnumMapper.toPrintEnum((int)container.printonsoefactor1), PrintEnumMapper.toPrintEnum((int)container.printonsoefactor2), PrintEnumMapper.toPrintEnum((int)container.printonsoeresult), container.positiononsoe, FontEnumMapper.toFontEnum((int)container.fontonsoe), BlankLineEnumMapper.toBlankLineEnum((int)container.blanklineonsoe), PrintEnumMapper.toPrintEnum((int)container.printoncwjfactor1), PrintEnumMapper.toPrintEnum((int)container.printoncwjfactor2), PrintEnumMapper.toPrintEnum((int)container.printoncwjresult), container.positiononcwj, FontEnumMapper.toFontEnum((int)container.fontoncwj), BlankLineEnumMapper.toBlankLineEnum((int)container.blanklineoncwj), CompressionOnAccountOfMovementEnumMapper.toCompressionOnAccountOfMovementEnum((int)container.compressiononma), container.targethourscontrol, container.grosscontrol, container.netcontrol, NoPrintByZeroEnumMapper.toNoPrintByZeroEnum((int)container.noprintbyzero), container.additionalboolean), container.memo, container.vtkeyofpresystem));
    }

    public static void fillContainer(VtfoundationsContainer container, ValueTypeFoundation vtf) {
        container.setObjectid(vtf.getObjectid());
        container.setObjectTS(vtf.getTimestamp());
        container.setLastUserid(vtf.getLastuser());
        container.setVersion(vtf.getVersion());
        container.category = CategoryEnumMapper.toInt((CategoryEnum)vtf.getGeneral().getCategory());
        container.classification = ClassificationEnumMapper.toInt((ClassificationEnum)vtf.getGeneral().getClassification());
        container.rankingnumber = vtf.getGeneral().getRankingNumber();
        container.shortdescription = vtf.getGeneral().getShortDescription();
        container.longdescription = vtf.getGeneral().getLongDescription();
        container.description = vtf.getGeneral().getDescription();
        container.typeofvaluetype = TypeOfValueTypeEnumMapper.toInt((TypeOfValueTypeEnum)vtf.getGeneral().getTypeOfValueType());
        container.specification = vtf.getGeneral().getSpecification();
        container.oidvaluetypegroup = vtf.getGeneral().getValueTypeGroup() == null ? "" : vtf.getGeneral().getValueTypeGroup().getObjectid();
        container.january = vtf.getGeneral().getInterval().getJanuary();
        container.february = vtf.getGeneral().getInterval().getFebruary();
        container.march = vtf.getGeneral().getInterval().getMarch();
        container.april = vtf.getGeneral().getInterval().getApril();
        container.may = vtf.getGeneral().getInterval().getMay();
        container.june = vtf.getGeneral().getInterval().getJune();
        container.july = vtf.getGeneral().getInterval().getJuly();
        container.august = vtf.getGeneral().getInterval().getAugust();
        container.september = vtf.getGeneral().getInterval().getSeptember();
        container.oktober = vtf.getGeneral().getInterval().getOctober();
        container.november = vtf.getGeneral().getInterval().getNovember();
        container.december = vtf.getGeneral().getInterval().getDecember();
        container.annualnterval = vtf.getGeneral().getInterval().getYearDistance();
        container.calculationassista = vtf.getGeneral().isCompressToSummary();
        container.resultassistant = vtf.getGeneral().getResultAssistant();
        container.createsingle = vtf.getGeneral().getCreateSingle();
        container.isnetwage = vtf.getGeneral().getIsNetWage();
        container.compressiononsoe = CompressionEnumMapper.toInt((CompressionEnum)vtf.getPrintSettings().getCompressionOnCertificateOfEarnings());
        container.compressionongj = CompressionEnumMapper.toInt((CompressionEnum)vtf.getPrintSettings().getCompressionOnCrossWageJournal());
        container.costjournalfactor1 = vtf.getPrintSettings().getCostJournalFactor1();
        container.costjournalresult = vtf.getPrintSettings().getCostJournalResult();
        container.mmpayrollresult = vtf.getPrintSettings().getMonthlyPayrollResult();
        container.yypayrollfactor1 = vtf.getPrintSettings().getYearlyTotalPayrollFactor1();
        container.yypayrollresult = vtf.getPrintSettings().getYearlyTotalPayrollResult();
        container.printonsoefactor1 = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnStatementOfEarningsFactor1());
        container.printonsoefactor2 = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnStatementOfEarningsFactor2());
        container.printonsoeresult = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnStatementOfEarningsResult());
        container.positiononsoe = vtf.getPrintSettings().getPositionOnStatementOfEarnings();
        container.fontonsoe = FontEnumMapper.toInt((FontEnum)vtf.getPrintSettings().getFontOnStatementOfEarnings());
        container.blanklineonsoe = BlankLineEnumMapper.toInt((BlankLineEnum)vtf.getPrintSettings().getBlankLineOnStatementOfEarnings());
        container.printoncwjfactor1 = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnGrossWageJournalFactor1());
        container.printoncwjfactor2 = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnGrossWageJournalFactor2());
        container.printoncwjresult = PrintEnumMapper.toInt((PrintEnum)vtf.getPrintSettings().getPrintOnGrossWageJournalResult());
        container.positiononcwj = vtf.getPrintSettings().getPositionOnGrossWageJournal();
        container.fontoncwj = FontEnumMapper.toInt((FontEnum)vtf.getPrintSettings().getFontOnGrossWageJournal());
        container.blanklineoncwj = BlankLineEnumMapper.toInt((BlankLineEnum)vtf.getPrintSettings().getBlankLineOnGrossWageJournal());
        container.compressiononma = CompressionOnAccountOfMovementEnumMapper.toInt((CompressionOnAccountOfMovementEnum)vtf.getPrintSettings().getCompressionOnAccountOfMovement());
        container.memo = vtf.getMemo();
        container.vtkeyofpresystem = vtf.getValueTypeKeyPreSystem();
        container.typeoflumpsumtax = 0;
        container.yytotalfactor1 = 0;
        container.yytotalfactor2 = 0;
        container.yytotalresult = 0;
        container.regjournalfactor1 = false;
        container.regjournalfactor2 = false;
        container.regjournalresult = false;
        container.totaljournlfactor1 = false;
        container.totaljournlfactor2 = false;
        container.totaljournalresult = false;
        container.costjournalfactor2 = false;
        container.mmpayrollfactor1 = false;
        container.mmpayrollfactor2 = false;
        container.yypayrollfactor2 = false;
        container.typeofpayment = TypeOfPaymentEnumMapper.toInt((TypeOfPaymentEnum)vtf.getGeneral().getTypeOfPayment());
        container.erasystemcosts = ERASystemCostsEnumMapper.toInt((ERASystemCostsEnum)vtf.getGeneral().getEraSystemCosts());
        container.eraevaluation = ERAEvaluationEnumMapper.toInt((ERAEvaluationEnum)vtf.getGeneral().getEraEvaluation());
        container.eracomparisonevalu = 0;
        container.targethourscontrol = vtf.getPrintSettings().getTargethoursControl();
        container.grosscontrol = vtf.getPrintSettings().getGrossControl();
        container.netcontrol = vtf.getPrintSettings().getNetControl();
        container.paidovertimehour = vtf.getGeneral().getPaidOvertimeHour();
        container.shtypeofpayment = TypeOfPaymentEnumMapper.toInt((TypeOfPaymentEnum)vtf.getGeneral().getTypeOfPaymentSalaryHistory());
        container.noprintbyzero = NoPrintByZeroEnumMapper.toInt((NoPrintByZeroEnum)vtf.getPrintSettings().getNoPrintByZeroOnSoE());
        container.useintervalincalc = vtf.getGeneral().getUseIntervalInCalculation();
        container.additionalboolean = vtf.getPrintSettings().getAnnualValueEveryMonth();
        container.createautomatic = vtf.getGeneral().getCreateOnlyAutomatically();
        container.additionaldate = null;
        container.additionalenum = 0;
        container.additionalamount = null;
        container.additionalint = Integer.MIN_VALUE;
        container.additionalstring = "";
        container.additionaloid = "";
    }
}

