/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.rvbea.receive;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.deuv.Deuv;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.AdviceStateEnum;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.rvbea.dxar.IRvbeaDxarPersistencyManager;
import com.varial.personnel.domain.rvbea.dxar.RvbeaDxar;
import com.varial.personnel.domain.rvbea.receive.BasicRvbeaReceive;
import com.varial.personnel.framework.PFileHelper;
import com.varial.serverbase.basictypes.VDate;
import java.io.File;
import java.io.FilenameFilter;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RvbeaRequestsReceive
extends BasicRvbeaReceive<RvbeaDxar> {
    private static final String[] FILENAMEFILTER = new String[]{"ERVA0", "TRVA0"};
    private static final Pattern VOSX_RV_AG = RvbeaRequestsReceive.getVosxPattern((String)"RVA");
    private static final Pattern DXAR = Pattern.compile("DXAR(?<VERSION>020000|030000)(?<DSID>.{32})(?<BBNRAS>.{15})(?<BBNRVU>.{15})(?<BEZUGSID>.{32})(?<VSNR>.{12})(?<AZVU>.{20})(?<ANFGR>.{15})(?<ANFGRVERS>\\d{6})(?<ANZEBWERTE>\\d{3})(?<EBWERTE>(?:.{15})*)(?<ANZMONATE>\\d{2})(?<MONATE>(?:\\d{4}\\d{2}.{100})+)(?<URL>.{200})(?<PIN>.{8}).{100}");
    private static final Pattern DXAR_MONTH = Pattern.compile("(?<JAHR>\\d{4})(?<MONAT>\\d{2}).{100}(?<REST>.*)");
    private static final int DXAR_MIN_LENGTH = 574;
    private static final int DXAR_MONTH_LENGTH = 106;
    private final Date mCreatedOn = VDate.getCurrentLocalizedDateAndTime();
    private boolean mDxwlImported = false;

    public RvbeaRequestsReceive(DEUVSender deuvSender) {
        super(deuvSender);
    }

    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, this.getFileDescription());
        LinkedList<String> records = PFileHelper.getFileLines(file, "ISO-8859-1");
        Matcher matcherRV = VOSX_RV_AG.matcher((CharSequence)records.poll());
        return matcherRV.matches();
    }

    public String getProcedureName() {
        return "rvBEA";
    }

    public String getFileDescription() {
        return "Anforderungen rvBEA";
    }

    public String getActionName() {
        return "importieren";
    }

    public void readRvbeaDxars() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        for (File file : this.getFileList()) {
            this.readRvbeaDxar(file);
        }
    }

    private void readRvbeaDxar(File input) throws BusinessDomainException {
        int currentFileNumber;
        this.mCurrent = input;
        LinkedList<String> records = PFileHelper.getFileLines(input, "ISO-8859-1");
        Matcher matcherRV = VOSX_RV_AG.matcher((CharSequence)records.pollFirst());
        if (matcherRV.matches()) {
            currentFileNumber = this.asInteger(matcherRV.group("DATEINUMMER"));
            records.pollLast();
            while (!records.isEmpty()) {
                String record = (String)records.pollFirst();
                if (record.startsWith("DXAR")) {
                    RvbeaDxar dxar = this.createDxar(record);
                    dxar.setCurrentFileNumber(currentFileNumber);
                    dxar.setDeuvSender(this.mDeuvSender);
                    this.mImporteds.add(dxar);
                    continue;
                }
                if (!record.startsWith("DXWL")) continue;
                this.mDxwlImported = true;
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcherRV);
        }
        int subFolderNr = PerfidiaHelper.getPerfidiaSubFolderNumber((DEUVSender)this.mDeuvSender, (TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.RVA, subFolderNr, currentFileNumber);
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private RvbeaDxar createDxar(String input) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 574, DXAR);
        RvbeaDxar dxar = new RvbeaDxar();
        dxar.setVersionsnummer(matcher.group("VERSION"));
        dxar.setDsid(this.asString(matcher.group("DSID")));
        dxar.setBbnras(this.asString(matcher.group("BBNRAS")));
        dxar.setBbnrvu(this.asString(matcher.group("BBNRVU")));
        dxar.setBezugsid(this.asString(matcher.group("BEZUGSID")));
        dxar.setVsnr(this.asString(matcher.group("VSNR")));
        dxar.setAzvu(this.asString(matcher.group("AZVU")));
        dxar.setAnfgr(this.asString(matcher.group("ANFGR")));
        dxar.setAnfgrvers(this.asString(matcher.group("ANFGRVERS")));
        dxar.setUrl(this.asString(matcher.group("URL")));
        dxar.setPin(this.asString(matcher.group("PIN")));
        int anzahlEbWerte = this.asInteger(matcher.group("ANZEBWERTE"));
        String ebWerte = matcher.group("EBWERTE");
        ArrayList<String> ebWerteListe = new ArrayList<String>();
        for (int i = 0; i < anzahlEbWerte; ++i) {
            ebWerteListe.add(this.asString(ebWerte.substring(0, 14)));
            ebWerte = ebWerte.substring(15);
        }
        dxar.setEbWerte(ebWerteListe);
        int anzahlmonate = this.asInteger(matcher.group("ANZMONATE"));
        String monate = matcher.group("MONATE");
        ArrayList<LocalDate> months = new ArrayList<LocalDate>();
        for (int i = 0; i < anzahlmonate; ++i) {
            Matcher matcherMonth = this.checkInputGetMatcher(monate, 106, DXAR_MONTH);
            int year = this.asInteger(matcherMonth.group("JAHR"));
            int month = this.asInteger(matcherMonth.group("MONAT"));
            monate = matcherMonth.group("REST");
            months.add(LocalDate.of(year, month, 1));
        }
        if (!this.checkAndAssignMonths(months, dxar)) {
            dxar.addErrorMessage("Fehler bei den Kalendermonaten");
        }
        dxar.setPerfidiaFile(this.mCurrent.getPath());
        dxar.setCreatedOn(this.mCreatedOn);
        dxar.setEmployee(Deuv.findEmployeeByAz((String)dxar.getAzvu()));
        RvbeaDxar existent = this.getReceived(dxar.getDsid());
        if (existent != null) {
            if ((existent.getRvbeaDxeb() == null || existent.getRvbeaDxeb().getAdviceState() == AdviceStateEnum.AUFGEBAUT) && existent.getReason57Account() == null) {
                existent.makeSaveable();
                existent.destroy();
            } else {
                dxar.makeReadOnly();
                dxar.setErrorMessage("Diese Anforderung wurde bereits eingelesen");
            }
        }
        return dxar;
    }

    private RvbeaDxar getReceived(String dsid) {
        RvbeaDxar[] existent = RvbeaRequestsReceive.getRvbeaDxarPM().query(null, Restrictions.eq((String)"DSID", (String)dsid));
        return existent.length > 0 ? existent[0] : null;
    }

    private boolean checkAndAssignMonths(List<LocalDate> months, RvbeaDxar dxar) {
        if (months.isEmpty()) {
            return false;
        }
        Collections.sort(months);
        LocalDate previous = null;
        for (LocalDate each : months) {
            if (previous != null && !previous.plusMonths(1L).isEqual(each)) {
                return false;
            }
            previous = each;
        }
        LocalDate first = months.get(0);
        dxar.setEbjahrvon(first.getYear());
        dxar.setEbmonatvon(first.getMonthValue());
        LocalDate last = months.get(months.size() - 1);
        dxar.setEbjahrbis(last.getYear());
        dxar.setEbmonatbis(last.getMonthValue());
        return true;
    }

    public boolean areDxwlImported() {
        return this.mDxwlImported;
    }

    private static final IRvbeaDxarPersistencyManager getRvbeaDxarPM() {
        return (IRvbeaDxarPersistencyManager)UtilitiesManager.getBean((String)"rvbeaDxarPersistencyManager", IRvbeaDxarPersistencyManager.class);
    }
}

