/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.reports.wagetax.WageTaxEmployeeBean;
import com.varial.personnel.domain.reports.wagetax.WageTaxSetFederalstateChurchTaxBean;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxEnum;
import com.varial.personnel.domain.reports.wagetaxperemployee.WageTaxPerEmployeeBean;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.employee.tax.ITaxDao;
import com.varial.personnel.persistency.employee.tax.TaxContainer;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class WageTaxSetFederalstateChurchTax2019 {
    private static ITaxDao daoTax = (ITaxDao)UtilitiesManager.getApplicationContext().getBean("taxDao");
    private final WageTaxEmployeeBean mEWT;
    private final Date mEmployeeStartDate;
    private final Date mEmployeeEndDate;
    private final int mFederalState;
    private List<ValuepositionContainer> mValuePositionli = new LinkedList<ValuepositionContainer>();
    private WageTaxSetFederalstateChurchTaxBean mWTSFChurchTaxBean;
    private final WageTaxEnum mWageTaxEnum;
    private BigDecimal FIELD_z_25 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_26 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_26_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_26_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_27 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_27_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_27_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_28 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_28_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_28_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_29 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_29_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_29_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_30 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_30_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_30_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_31 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_31_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_31_FJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_32 = BigDecimal.ZERO;
    private BigDecimal FIELD_z_32_VJ = BigDecimal.ZERO;
    private BigDecimal FIELD_z_32_FJ = BigDecimal.ZERO;
    private String FIELD_z_25_text = "";
    private String FIELD_z_26_text = "";
    private String FIELD_z_27_text = "";
    private String FIELD_z_28_text = "";
    private String FIELD_z_29_text = "";
    private String FIELD_z_30_text = "";
    private String FIELD_z_31_text = "";
    private String FIELD_z_32_text = "";
    private String FIELD_z_25_short_text = "";
    private String FIELD_z_26_short_text = "";
    private String FIELD_z_27_short_text = "";
    private String FIELD_z_28_short_text = "";
    private String FIELD_z_29_short_text = "";
    private String FIELD_z_30_short_text = "";
    private String FIELD_z_31_short_text = "";
    private String FIELD_z_32_short_text = "";
    private String FIELD_z_25_nr = "";
    private String FIELD_z_26_nr = "";
    private String FIELD_z_27_nr = "";
    private String FIELD_z_28_nr = "";
    private String FIELD_z_29_nr = "";
    private String FIELD_z_30_nr = "";
    private String FIELD_z_31_nr = "";
    private String FIELD_z_32_nr = "";
    private BigDecimal FIELD_LStJA_ChrchTax_gesamt = BigDecimal.ZERO;

    public WageTaxSetFederalstateChurchTax2019(WageTaxEmployeeBean eWT, List<ValuepositionContainer> valuePositionli, WageTaxEnum wageTaxEnum) {
        this.mEWT = eWT;
        this.mEmployeeStartDate = eWT.getEmployeeStartDate();
        this.mEmployeeEndDate = eWT.getEmployeeEndDate();
        this.mFederalState = eWT.getEmployerFstateregionKey();
        this.mValuePositionli = valuePositionli;
        this.mWageTaxEnum = wageTaxEnum;
    }

    public void runForChrchTaxKammerBeitrag() {
        this.getValuesKammerBeitrag();
    }

    private void getValuesKammerBeitrag() {
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            block0 : switch (valuepositionContainer.valuetypenumber) {
                case 250510: 
                case 250610: {
                    Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
                    Date endDate = new VDate(this.mEmployeeEndDate).getDate();
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (this.mFederalState) {
                        case 4: {
                            this.getFederalStateWageTaxValuesArbeitsKammerHB(valuepositionContainer, beginDate, endDate);
                            break block0;
                        }
                        case 10: {
                            this.getFederalStateWageTaxValuesArbeitsKammerSL(valuepositionContainer, beginDate, endDate);
                        }
                    }
                }
            }
        }
    }

    private void getFederalStateWageTaxValuesArbeitsKammerHB(ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_25_short_text = "";
        this.FIELD_z_25_nr = "47";
        this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
        this.FIELD_z_26_short_text = "ev";
        this.FIELD_z_26_nr = "61";
        this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
        this.FIELD_z_27_short_text = "rk";
        this.FIELD_z_27_nr = "62";
        this.FIELD_z_28_text = "Beitr\u00e4ge zur Arbeitnehmerkammer";
        this.FIELD_z_28_short_text = "AK";
        this.FIELD_z_28_nr = "68";
        BigDecimal z_28 = BigDecimal.ZERO;
        switch (valuepositionContainer.valuetypenumber) {
            case 250510: {
                z_28 = valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
            }
        }
        if (this.mWageTaxEnum == WageTaxEnum.AktuellesJahr) {
            this.FIELD_z_28 = this.FIELD_z_28.add(z_28);
        } else if (this.mWageTaxEnum == WageTaxEnum.Vorjahr) {
            this.FIELD_z_28_VJ = this.FIELD_z_28_VJ.add(z_28);
        } else {
            this.FIELD_z_28_FJ = this.FIELD_z_28_FJ.add(z_28);
        }
    }

    private void getFederalStateWageTaxValuesArbeitsKammerSL(ValuepositionContainer valuepositionContainer, Date beginDate, Date endDate) {
        this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
        this.FIELD_z_25_short_text = "";
        this.FIELD_z_25_nr = "47";
        this.FIELD_z_26_text = "Evangelische Kirchensteuer";
        this.FIELD_z_26_short_text = "ev";
        this.FIELD_z_26_nr = "61";
        this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer";
        this.FIELD_z_27_short_text = "rk";
        this.FIELD_z_27_nr = "62";
        this.FIELD_z_28_text = "Israelitische Kultussteuer";
        this.FIELD_z_28_short_text = "is";
        this.FIELD_z_28_nr = "64";
        this.FIELD_z_29_text = "Altkatholische Kirchensteuer";
        this.FIELD_z_29_short_text = "ak";
        this.FIELD_z_29_nr = "63";
        this.FIELD_z_30_text = "Beitr\u00e4ge zur Arbeitskammer";
        this.FIELD_z_30_short_text = "Arb.-kammer";
        this.FIELD_z_30_nr = "70";
        BigDecimal z_30 = BigDecimal.ZERO;
        switch (valuepositionContainer.valuetypenumber) {
            case 250610: {
                z_30 = valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
            }
        }
        if (this.mWageTaxEnum == WageTaxEnum.AktuellesJahr) {
            this.FIELD_z_30 = this.FIELD_z_30.add(z_30);
        } else if (this.mWageTaxEnum == WageTaxEnum.Vorjahr) {
            this.FIELD_z_30_VJ = this.FIELD_z_30_VJ.add(z_30);
        } else {
            this.FIELD_z_30_FJ = this.FIELD_z_30_FJ.add(z_30);
        }
    }

    public void runForChrchTax() {
        BigDecimal lSTJAValue;
        if (new VDate(this.mEmployeeStartDate).getMonth() == 11 && !BigDecimalMapper.isZero((BigDecimal)(lSTJAValue = this.getCurchTaxLSTJAValues()))) {
            this.getChruchTaxLSTJA(lSTJAValue);
            this.FIELD_LStJA_ChrchTax_gesamt = this.FIELD_LStJA_ChrchTax_gesamt.add(lSTJAValue);
        }
        this.getLSTChurch();
    }

    private BigDecimal getCurchTaxLSTJAValues() {
        BigDecimal lSTJAValue = BigDecimal.ZERO;
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
            Date endDate = new VDate(this.mEmployeeEndDate).getDate();
            if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) continue;
            beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
            endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
            endDate = DateHelper.getLastDayOfMonth((Date)endDate);
            if (new VDate(beginDate).getMonth() != 11) continue;
            switch (valuepositionContainer.valuetypenumber) {
                case 760470: 
                case 760480: {
                    lSTJAValue = lSTJAValue.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                    break;
                }
                case 760120: 
                case 760130: {
                    lSTJAValue = lSTJAValue.subtract(valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                }
            }
        }
        return lSTJAValue;
    }

    private void getChruchTaxLSTJA(BigDecimal lSTJAValue) {
        int churchtaxee = this.mEWT.getEmployeeChurchtaxee();
        int churchtaxspouse = this.mEWT.getEmployeeChurchtaxspouse();
        if (!BigDecimalMapper.isZero((BigDecimal)lSTJAValue)) {
            if (churchtaxee == 0) {
                churchtaxee = this.getReligionszugehoerigkeitAN();
            }
            if (churchtaxspouse == 0) {
                churchtaxspouse = this.getReligionszugehoerigkeitEG();
            }
        }
        WageTaxSetFederalstateChurchTaxBean wTSFChurchTaxBean = new WageTaxSetFederalstateChurchTaxBean();
        BigDecimal z_26 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_27 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_28 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_29 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_30 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_31 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_32 = BigDecimal.valueOf(0L, 2);
        if (churchtaxspouse == 0) {
            ChurchtaxBean ctb = this.getChurchtaxBean(this.mFederalState, churchtaxee, lSTJAValue);
            z_26 = ctb.getFIELD_z_26();
            z_27 = ctb.getFIELD_z_27();
            z_28 = ctb.getFIELD_z_28();
            z_29 = ctb.getFIELD_z_29();
            z_30 = ctb.getFIELD_z_30();
            z_31 = ctb.getFIELD_z_31();
            z_32 = ctb.getFIELD_z_32();
        } else {
            ChurchtaxBean ctb = this.getChurchtaxBean(this.mFederalState, churchtaxee, lSTJAValue);
            z_26 = ctb.getFIELD_z_26().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_27 = ctb.getFIELD_z_27().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_28 = ctb.getFIELD_z_28().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_29 = ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_30 = ctb.getFIELD_z_30().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_31 = ctb.getFIELD_z_31().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            z_32 = ctb.getFIELD_z_32().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
            ctb = this.getChurchtaxBean(this.mFederalState, churchtaxspouse, lSTJAValue);
            z_26 = z_26.add(ctb.getFIELD_z_26().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_27 = z_27.add(ctb.getFIELD_z_27().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_28 = z_28.add(ctb.getFIELD_z_28().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_29 = z_29.add(ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_30 = z_30.add(ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_31 = z_31.add(ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            z_32 = z_32.add(ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
        }
        if (this.mWageTaxEnum == WageTaxEnum.AktuellesJahr) {
            wTSFChurchTaxBean.setZ_26(z_26);
            wTSFChurchTaxBean.setZ_27(z_27);
            wTSFChurchTaxBean.setZ_28(z_28);
            wTSFChurchTaxBean.setZ_29(z_29);
            wTSFChurchTaxBean.setZ_30(z_30);
            wTSFChurchTaxBean.setZ_31(z_31);
            wTSFChurchTaxBean.setZ_32(z_32);
        } else if (this.mWageTaxEnum == WageTaxEnum.Vorjahr) {
            wTSFChurchTaxBean.setZ_26_vj(z_26);
            wTSFChurchTaxBean.setZ_27_vj(z_27);
            wTSFChurchTaxBean.setZ_28_vj(z_28);
            wTSFChurchTaxBean.setZ_29_vj(z_29);
            wTSFChurchTaxBean.setZ_30_vj(z_30);
            wTSFChurchTaxBean.setZ_31_vj(z_31);
            wTSFChurchTaxBean.setZ_32_vj(z_32);
        } else {
            wTSFChurchTaxBean.setZ_26_fj(z_26);
            wTSFChurchTaxBean.setZ_27_fj(z_27);
            wTSFChurchTaxBean.setZ_28_fj(z_28);
            wTSFChurchTaxBean.setZ_29_fj(z_29);
            wTSFChurchTaxBean.setZ_30_fj(z_30);
            wTSFChurchTaxBean.setZ_31_fj(z_31);
            wTSFChurchTaxBean.setZ_32_fj(z_32);
        }
        this.mWTSFChurchTaxBean = wTSFChurchTaxBean;
    }

    private int getReligionszugehoerigkeitAN() {
        PersistencyDataSet taxDatas = this.getTaxDataSet();
        if (taxDatas != null) {
            while (taxDatas.hasNext()) {
                TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                if (taxContainer.churchtaxee == 0) continue;
                return taxContainer.churchtaxee;
            }
        }
        return 0;
    }

    private int getReligionszugehoerigkeitEG() {
        PersistencyDataSet taxDatas = this.getTaxDataSet();
        if (taxDatas != null) {
            while (taxDatas.hasNext()) {
                TaxContainer taxContainer = (TaxContainer)taxDatas.getNext();
                if (taxContainer.churchtaxspouse == 0) continue;
                return taxContainer.churchtaxspouse;
            }
        }
        return 0;
    }

    private PersistencyDataSet getTaxDataSet() {
        PersistencyDataSet taxDatas;
        Conjunction filterStructs = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEWT.getOidEmployee()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate)))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)this.mEmployeeStartDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)this.mEmployeeStartDate)))});
        Order[] sortierungStruct = new Order[]{Order.asc((String)"validfrom")};
        try {
            taxDatas = daoTax.getDataSet(sortierungStruct, (Criterion)filterStructs);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return taxDatas;
    }

    private void getLSTChurch() {
        this.setChurchTaxExpressions();
        Date beginDate = new VDate(this.mEmployeeStartDate).getDate();
        Date endDate = new VDate(this.mEmployeeEndDate).getDate();
        for (ValuepositionContainer valuepositionContainer : this.mValuePositionli) {
            block0 : switch (valuepositionContainer.valuetypenumber) {
                case 226050: 
                case 227050: 
                case 710610: 
                case 710620: {
                    if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeEndDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeStartDate)) break;
                    beginDate = DateHelper.after((Date)valuepositionContainer.validfrom, (Date)this.mEmployeeStartDate) ? valuepositionContainer.validfrom : this.mEmployeeStartDate;
                    endDate = DateHelper.before((Date)valuepositionContainer.validuntil, (Date)this.mEmployeeEndDate) ? valuepositionContainer.validuntil : this.mEmployeeEndDate;
                    endDate = DateHelper.getLastDayOfMonth((Date)endDate);
                    switch (valuepositionContainer.valuetypenumber) {
                        case 226050: {
                            this.getDataChurchTax(valuepositionContainer, this.mEWT, this.mFederalState, beginDate, endDate, TypeOfAddition.TOA_NUR_MITARBEITER);
                            break block0;
                        }
                        case 227050: {
                            this.getDataChurchTax(valuepositionContainer, this.mEWT, this.mFederalState, beginDate, endDate, TypeOfAddition.TOA_NUR_EHEGATTE);
                            break block0;
                        }
                        case 710610: {
                            this.FIELD_z_25 = this.FIELD_z_25.add(valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate))));
                            break block0;
                        }
                        case 710620: {
                            if (this.mEWT.getEmployeeChurchtaxspouse() == 0) {
                                this.getDataChurchTax(valuepositionContainer, this.mEWT, this.mFederalState, beginDate, endDate, TypeOfAddition.TOA_NUR_MITARBEITER);
                                break block0;
                            }
                            this.getDataChurchTax(valuepositionContainer, this.mEWT, this.mFederalState, beginDate, endDate, TypeOfAddition.TOA_MITARBEITER_EHEGATTE);
                        }
                    }
                }
            }
        }
    }

    private void getDataChurchTax(ValuepositionContainer valuepositionContainer, WageTaxPerEmployeeBean eWT, int federalState, Date beginDate, Date endDate, TypeOfAddition typeOfAddition) {
        BigDecimal result = valuepositionContainer.results.multiply(new BigDecimal(WageTaxSetFederalstateChurchTax2019.getDiffInMonths(DateHelper.tomorrow((Date)endDate), beginDate)));
        BigDecimal z_26 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_27 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_28 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_29 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_30 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_31 = BigDecimal.valueOf(0L, 2);
        BigDecimal z_32 = BigDecimal.valueOf(0L, 2);
        switch (typeOfAddition) {
            case TOA_NUR_MITARBEITER: {
                ChurchtaxBean ctb = this.getChurchtaxBean(federalState, eWT.getEmployeeChurchtaxee(), result);
                z_26 = ctb.getFIELD_z_26();
                z_27 = ctb.getFIELD_z_27();
                z_28 = ctb.getFIELD_z_28();
                z_29 = ctb.getFIELD_z_29();
                z_30 = ctb.getFIELD_z_30();
                z_31 = ctb.getFIELD_z_31();
                z_32 = ctb.getFIELD_z_32();
                break;
            }
            case TOA_NUR_EHEGATTE: {
                ChurchtaxBean ctb = this.getChurchtaxBean(federalState, eWT.getEmployeeChurchtaxspouse(), result);
                z_26 = ctb.getFIELD_z_26();
                z_27 = ctb.getFIELD_z_27();
                z_28 = ctb.getFIELD_z_28();
                z_29 = ctb.getFIELD_z_29();
                z_30 = ctb.getFIELD_z_30();
                z_31 = ctb.getFIELD_z_31();
                z_32 = ctb.getFIELD_z_32();
                break;
            }
            case TOA_MITARBEITER_EHEGATTE: {
                ChurchtaxBean ctb = this.getChurchtaxBean(federalState, eWT.getEmployeeChurchtaxee(), result);
                z_26 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_26()) ? BigDecimal.ZERO : ctb.getFIELD_z_26().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_27 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_27()) ? BigDecimal.ZERO : ctb.getFIELD_z_27().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_28 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_28()) ? BigDecimal.ZERO : ctb.getFIELD_z_28().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_29 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_29()) ? BigDecimal.ZERO : ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_30 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_30()) ? BigDecimal.ZERO : ctb.getFIELD_z_30().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_31 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_31()) ? BigDecimal.ZERO : ctb.getFIELD_z_31().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                z_32 = BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_32()) ? BigDecimal.ZERO : ctb.getFIELD_z_32().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
                ctb = this.getChurchtaxBean(federalState, eWT.getEmployeeChurchtaxspouse(), result);
                z_26 = z_26.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_26()) ? BigDecimal.ZERO : ctb.getFIELD_z_26().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_27 = z_27.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_27()) ? BigDecimal.ZERO : ctb.getFIELD_z_27().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_28 = z_28.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_28()) ? BigDecimal.ZERO : ctb.getFIELD_z_28().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_29 = z_29.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_29()) ? BigDecimal.ZERO : ctb.getFIELD_z_29().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_30 = z_30.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_30()) ? BigDecimal.ZERO : ctb.getFIELD_z_30().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_31 = z_31.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_31()) ? BigDecimal.ZERO : ctb.getFIELD_z_31().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
                z_32 = z_32.add(BigDecimalMapper.isZeroOrNull((BigDecimal)ctb.getFIELD_z_32()) ? BigDecimal.ZERO : ctb.getFIELD_z_32().divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_DOWN));
            }
        }
        if (this.mWageTaxEnum == WageTaxEnum.AktuellesJahr) {
            this.FIELD_z_26 = this.FIELD_z_26.add(z_26);
            this.FIELD_z_27 = this.FIELD_z_27.add(z_27);
            this.FIELD_z_28 = this.FIELD_z_28.add(z_28);
            this.FIELD_z_29 = this.FIELD_z_29.add(z_29);
            this.FIELD_z_30 = this.FIELD_z_30.add(z_30);
            this.FIELD_z_31 = this.FIELD_z_31.add(z_31);
            this.FIELD_z_32 = this.FIELD_z_32.add(z_32);
        } else if (this.mWageTaxEnum == WageTaxEnum.Vorjahr) {
            this.FIELD_z_26_VJ = this.FIELD_z_26_VJ.add(z_26);
            this.FIELD_z_27_VJ = this.FIELD_z_27_VJ.add(z_27);
            this.FIELD_z_28_VJ = this.FIELD_z_28_VJ.add(z_28);
            this.FIELD_z_29_VJ = this.FIELD_z_29_VJ.add(z_29);
            this.FIELD_z_30_VJ = this.FIELD_z_30_VJ.add(z_30);
            this.FIELD_z_31_VJ = this.FIELD_z_31_VJ.add(z_31);
            this.FIELD_z_32_VJ = this.FIELD_z_32_VJ.add(z_32);
        } else {
            this.FIELD_z_26_FJ = this.FIELD_z_26_FJ.add(z_26);
            this.FIELD_z_27_FJ = this.FIELD_z_27_FJ.add(z_27);
            this.FIELD_z_28_FJ = this.FIELD_z_28_FJ.add(z_28);
            this.FIELD_z_29_FJ = this.FIELD_z_29_FJ.add(z_29);
            this.FIELD_z_30_FJ = this.FIELD_z_30_FJ.add(z_30);
            this.FIELD_z_31_FJ = this.FIELD_z_31_FJ.add(z_31);
            this.FIELD_z_32_FJ = this.FIELD_z_32_FJ.add(z_32);
        }
    }

    private ChurchtaxBean getChurchtaxBean(int federalState, int churchtax, BigDecimal value) {
        ChurchtaxBean ctb = new ChurchtaxBean();
        block0 : switch (federalState) {
            case 1: {
                switch (churchtax) {
                    case 1: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 19: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_29(value);
                    }
                }
                break;
            }
            case 2: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 19: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_29(value);
                    }
                }
                break;
            }
            case 3: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_28(value);
                    }
                }
                break;
            }
            case 4: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                    }
                }
                break;
            }
            case 5: {
                switch (churchtax) {
                    case 1: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 16: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_29(value);
                    }
                }
                break;
            }
            case 6: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 11: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 10: {
                        ctb.setFIELD_z_29(value);
                        break;
                    }
                    case 14: {
                        ctb.setFIELD_z_30(value);
                        break;
                    }
                    case 13: {
                        ctb.setFIELD_z_31(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_32(value);
                    }
                }
                break;
            }
            case 7: {
                switch (churchtax) {
                    case 1: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 14: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 9: {
                        ctb.setFIELD_z_29(value);
                        break;
                    }
                    case 10: {
                        ctb.setFIELD_z_30(value);
                        break;
                    }
                    case 7: {
                        ctb.setFIELD_z_31(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_32(value);
                    }
                }
                break;
            }
            case 8: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 12: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 8: {
                        ctb.setFIELD_z_29(value);
                        break;
                    }
                    case 15: {
                        ctb.setFIELD_z_30(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_31(value);
                    }
                }
                break;
            }
            case 9: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 17: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_29(value);
                    }
                }
                break;
            }
            case 10: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 13: {
                        ctb.setFIELD_z_28(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_29(value);
                    }
                }
                break;
            }
            case 11: 
            case 12: {
                switch (churchtax) {
                    case 1: {
                        ctb.setFIELD_z_26(value);
                        break;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                        break;
                    }
                    case 3: {
                        ctb.setFIELD_z_28(value);
                    }
                }
                break;
            }
            case 13: {
                if (DateHelper.afterOrEqual((Date)this.mEmployeeStartDate, (Date)new VDate(2023, 0, 1).getDate())) {
                    switch (churchtax) {
                        case 1: 
                        case 4: 
                        case 5: 
                        case 6: {
                            ctb.setFIELD_z_26(value);
                            break;
                        }
                        case 2: {
                            ctb.setFIELD_z_27(value);
                            break;
                        }
                        case 14: 
                        case 16: 
                        case 18: {
                            ctb.setFIELD_z_28(value);
                            break;
                        }
                        case 10: {
                            ctb.setFIELD_z_29(value);
                            break;
                        }
                        case 13: {
                            ctb.setFIELD_z_30(value);
                            break;
                        }
                        case 3: {
                            ctb.setFIELD_z_31(value);
                        }
                    }
                    break;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                switch (churchtax) {
                    case 1: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ctb.setFIELD_z_26(value);
                        break block0;
                    }
                    case 2: {
                        ctb.setFIELD_z_27(value);
                    }
                }
            }
        }
        return ctb;
    }

    private void setChurchTaxExpressions() {
        switch (this.mFederalState) {
            case 1: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "J\u00fcdische Kultussteuer - ih";
                this.FIELD_z_28_short_text = "ih";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_29_short_text = "ak";
                this.FIELD_z_29_nr = "63";
                break;
            }
            case 2: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "J\u00fcdische Kultussteuer - jh";
                this.FIELD_z_28_short_text = "jh";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_29_short_text = "ak";
                this.FIELD_z_29_nr = "63";
                break;
            }
            case 3: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26 = BigDecimal.ZERO;
                this.FIELD_z_26_text = "Kirchensteuer - lt/rf (ev)";
                this.FIELD_z_26_short_text = "lt/rf (ev)";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27 = BigDecimal.ZERO;
                this.FIELD_z_27_text = "Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Kirchensteuer - ak";
                this.FIELD_z_28_short_text = "ak";
                this.FIELD_z_28_nr = "63";
                break;
            }
            case 4: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Beitr\u00e4ge zur Arbeitnehmerkammer";
                this.FIELD_z_28_short_text = "AK";
                this.FIELD_z_28_nr = "68";
                break;
            }
            case 5: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev/lt/rf/fr";
                this.FIELD_z_26_short_text = "ev/lt/rf/fr";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "J\u00fcdische Kultussteuer - jd";
                this.FIELD_z_28_short_text = "jd";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_29_short_text = "ak";
                this.FIELD_z_29_nr = "63";
                break;
            }
            case 6: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev (lt/rf/fr)";
                this.FIELD_z_26_short_text = "ev (lt/rf/fr)";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Freireligi\u00f6se Gemeinde Offenbach/M. - fs";
                this.FIELD_z_28_short_text = "fs";
                this.FIELD_z_28_nr = "66";
                this.FIELD_z_29_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
                this.FIELD_z_29_short_text = "fm";
                this.FIELD_z_29_nr = "65";
                this.FIELD_z_30_text = "Israelitische Kultussteuer Frankfurt - is";
                this.FIELD_z_30_short_text = "is";
                this.FIELD_z_30_nr = "64";
                this.FIELD_z_31_text = "Israelitische Kultussteuer der kultusberechtigten Gemeinden - il";
                this.FIELD_z_31_short_text = "il";
                this.FIELD_z_31_nr = "74";
                this.FIELD_z_32_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_32_short_text = "ak";
                this.FIELD_z_32_nr = "63";
                break;
            }
            case 7: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "J\u00fcdische Kultussteuer - is";
                this.FIELD_z_28_short_text = "is";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Freireligi\u00f6se Landesgemeinde Pfalz - fg";
                this.FIELD_z_29_short_text = "fg";
                this.FIELD_z_29_nr = "68";
                this.FIELD_z_30_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
                this.FIELD_z_30_short_text = "fm";
                this.FIELD_z_30_nr = "65";
                this.FIELD_z_31_text = "Freie Religionsgemeinschaft Alzey - fa";
                this.FIELD_z_31_short_text = "fa";
                this.FIELD_z_31_nr = "72";
                this.FIELD_z_32_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_32_short_text = "ak";
                this.FIELD_z_32_nr = "63";
                break;
            }
            case 8: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft Baden - ib";
                this.FIELD_z_28_short_text = "ib";
                this.FIELD_z_28_nr = "78";
                this.FIELD_z_29_text = "Kirchensteuer der Freireligi\u00f6sen Landesgemeinde Baden - fb";
                this.FIELD_z_29_short_text = "fb";
                this.FIELD_z_29_nr = "67";
                this.FIELD_z_30_text = "Kirchensteuer der Israelitischen Relgionsgemeinschaft W\u00fcttembergs - iw";
                this.FIELD_z_30_short_text = "iw";
                this.FIELD_z_30_nr = "73";
                this.FIELD_z_31_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_31_short_text = "ak";
                this.FIELD_z_31_nr = "63";
                break;
            }
            case 9: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Israelitische Bekenntnissteuer - is";
                this.FIELD_z_28_short_text = "is";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_29_short_text = "ak";
                this.FIELD_z_29_nr = "63";
                break;
            }
            case 10: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Israelitische Kultussteuer";
                this.FIELD_z_28_short_text = "is";
                this.FIELD_z_28_nr = "64";
                this.FIELD_z_29_text = "Altkatholische Kirchensteuer";
                this.FIELD_z_29_short_text = "ak";
                this.FIELD_z_29_nr = "63";
                this.FIELD_z_30_text = "Beitr\u00e4ge zur Arbeitskammer";
                this.FIELD_z_30_short_text = "Arb.-kammer";
                this.FIELD_z_30_nr = "70";
                break;
            }
            case 11: 
            case 12: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
                this.FIELD_z_28_text = "Altkatholische Kirchensteuer - ak";
                this.FIELD_z_28_short_text = "ak";
                this.FIELD_z_28_nr = "63";
                break;
            }
            case 13: {
                if (DateHelper.afterOrEqual((Date)this.mEmployeeStartDate, (Date)new VDate(2023, 0, 1).getDate())) {
                    this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                    this.FIELD_z_25_short_text = "";
                    this.FIELD_z_25_nr = "47";
                    this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                    this.FIELD_z_26_short_text = "ev";
                    this.FIELD_z_26_nr = "61";
                    this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                    this.FIELD_z_27_short_text = "rk";
                    this.FIELD_z_27_nr = "62";
                    this.FIELD_z_28_text = "Israelitische / J\u00fcdische Kultussteuer - is/jh/jd";
                    this.FIELD_z_28_short_text = "is/jh/jd";
                    this.FIELD_z_28_nr = "64";
                    this.FIELD_z_29_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
                    this.FIELD_z_29_short_text = "fm";
                    this.FIELD_z_29_nr = "65";
                    this.FIELD_z_30_text = "Israelitische Kultussteuer der kultussteuerberechtigten Gemeinden Hessen - il";
                    this.FIELD_z_30_short_text = "il";
                    this.FIELD_z_30_nr = "74";
                    this.FIELD_z_31_text = "Altkatholische Kirchensteuer - ak";
                    this.FIELD_z_31_short_text = "ak";
                    this.FIELD_z_31_nr = "63";
                    this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                    this.FIELD_z_25_short_text = "";
                    this.FIELD_z_25_nr = "47";
                    this.FIELD_z_26_text = "Evangelische Kirchensteuer - ev";
                    this.FIELD_z_26_short_text = "ev";
                    this.FIELD_z_26_nr = "61";
                    this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer - rk";
                    this.FIELD_z_27_short_text = "rk";
                    this.FIELD_z_27_nr = "62";
                    this.FIELD_z_28_text = "Israelitische / J\u00fcdische Kultussteuer - is/jh/jd";
                    this.FIELD_z_28_short_text = "is/jh/jd";
                    this.FIELD_z_28_nr = "64";
                    this.FIELD_z_29_text = "Freireligi\u00f6se Gemeinde Mainz - fm";
                    this.FIELD_z_29_short_text = "fm";
                    this.FIELD_z_29_nr = "65";
                    this.FIELD_z_30_text = "Israelitische Kultussteuer der kultussteuerberechtigten Gemeinden Hessen - il";
                    this.FIELD_z_30_short_text = "il";
                    this.FIELD_z_30_nr = "74";
                    this.FIELD_z_31_text = "Altkatholische Kirchensteuer - ak";
                    this.FIELD_z_31_short_text = "ak";
                    this.FIELD_z_31_nr = "63";
                    break;
                }
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.FIELD_z_25_text = "pauschale Kirchensteuer im vereinfachten Verfahren";
                this.FIELD_z_25_short_text = "";
                this.FIELD_z_25_nr = "47";
                this.FIELD_z_26_text = "Evangelische Kirchensteuer";
                this.FIELD_z_26_short_text = "ev";
                this.FIELD_z_26_nr = "61";
                this.FIELD_z_27_text = "R\u00f6misch-Katholische Kirchensteuer";
                this.FIELD_z_27_short_text = "rk";
                this.FIELD_z_27_nr = "62";
            }
        }
    }

    public void resetValues() {
        this.FIELD_z_25 = BigDecimal.ZERO;
        this.FIELD_z_26 = BigDecimal.ZERO;
        this.FIELD_z_26_VJ = BigDecimal.ZERO;
        this.FIELD_z_26_FJ = BigDecimal.ZERO;
        this.FIELD_z_27 = BigDecimal.ZERO;
        this.FIELD_z_27_VJ = BigDecimal.ZERO;
        this.FIELD_z_27_FJ = BigDecimal.ZERO;
        this.FIELD_z_28 = BigDecimal.ZERO;
        this.FIELD_z_28_VJ = BigDecimal.ZERO;
        this.FIELD_z_28_FJ = BigDecimal.ZERO;
        this.FIELD_z_29 = BigDecimal.ZERO;
        this.FIELD_z_29_VJ = BigDecimal.ZERO;
        this.FIELD_z_29_FJ = BigDecimal.ZERO;
        this.FIELD_z_30 = BigDecimal.ZERO;
        this.FIELD_z_30_VJ = BigDecimal.ZERO;
        this.FIELD_z_30_FJ = BigDecimal.ZERO;
        this.FIELD_z_31 = BigDecimal.ZERO;
        this.FIELD_z_31_VJ = BigDecimal.ZERO;
        this.FIELD_z_31_FJ = BigDecimal.ZERO;
        this.FIELD_z_32 = BigDecimal.ZERO;
        this.FIELD_z_32_VJ = BigDecimal.ZERO;
        this.FIELD_z_32_FJ = BigDecimal.ZERO;
        this.FIELD_z_25_text = "";
        this.FIELD_z_26_text = "";
        this.FIELD_z_27_text = "";
        this.FIELD_z_28_text = "";
        this.FIELD_z_29_text = "";
        this.FIELD_z_30_text = "";
        this.FIELD_z_31_text = "";
        this.FIELD_z_32_text = "";
        this.FIELD_z_25_short_text = "";
        this.FIELD_z_26_short_text = "";
        this.FIELD_z_27_short_text = "";
        this.FIELD_z_28_short_text = "";
        this.FIELD_z_29_short_text = "";
        this.FIELD_z_30_short_text = "";
        this.FIELD_z_30_short_text = "";
        this.FIELD_z_32_short_text = "";
        this.FIELD_z_25_nr = "";
        this.FIELD_z_26_nr = "";
        this.FIELD_z_27_nr = "";
        this.FIELD_z_28_nr = "";
        this.FIELD_z_29_nr = "";
        this.FIELD_z_30_nr = "";
        this.FIELD_z_31_nr = "";
        this.FIELD_z_32_nr = "";
    }

    private static final int getDiffInMonths(Date endDate, Date startDate) {
        return PDateHelper.getDiffInMonths((Date)endDate, (Date)startDate);
    }

    public WageTaxSetFederalstateChurchTaxBean getMWTSFChurchTaxBean() {
        return this.mWTSFChurchTaxBean;
    }

    public BigDecimal getFIELD_z_25() {
        return this.FIELD_z_25;
    }

    public String getFIELD_z_25_nr() {
        return this.FIELD_z_25_nr;
    }

    public String getFIELD_z_25_short_text() {
        return this.FIELD_z_25_short_text;
    }

    public String getFIELD_z_25_text() {
        return this.FIELD_z_25_text;
    }

    public BigDecimal getFIELD_z_26() {
        return this.FIELD_z_26;
    }

    public BigDecimal getFIELD_z_26_VJ() {
        return this.FIELD_z_26_VJ;
    }

    public BigDecimal getFIELD_z_26_FJ() {
        return this.FIELD_z_26_FJ;
    }

    public String getFIELD_z_26_nr() {
        return this.FIELD_z_26_nr;
    }

    public String getFIELD_z_26_short_text() {
        return this.FIELD_z_26_short_text;
    }

    public String getFIELD_z_26_text() {
        return this.FIELD_z_26_text;
    }

    public BigDecimal getFIELD_z_27() {
        return this.FIELD_z_27;
    }

    public BigDecimal getFIELD_z_27_VJ() {
        return this.FIELD_z_27_VJ;
    }

    public BigDecimal getFIELD_z_27_FJ() {
        return this.FIELD_z_27_FJ;
    }

    public String getFIELD_z_27_nr() {
        return this.FIELD_z_27_nr;
    }

    public String getFIELD_z_27_short_text() {
        return this.FIELD_z_27_short_text;
    }

    public String getFIELD_z_27_text() {
        return this.FIELD_z_27_text;
    }

    public BigDecimal getFIELD_z_28() {
        return this.FIELD_z_28;
    }

    public BigDecimal getFIELD_z_28_VJ() {
        return this.FIELD_z_28_VJ;
    }

    public BigDecimal getFIELD_z_28_FJ() {
        return this.FIELD_z_28_FJ;
    }

    public String getFIELD_z_28_nr() {
        return this.FIELD_z_28_nr;
    }

    public String getFIELD_z_28_short_text() {
        return this.FIELD_z_28_short_text;
    }

    public String getFIELD_z_28_text() {
        return this.FIELD_z_28_text;
    }

    public BigDecimal getFIELD_z_29() {
        return this.FIELD_z_29;
    }

    public BigDecimal getFIELD_z_29_VJ() {
        return this.FIELD_z_29_VJ;
    }

    public BigDecimal getFIELD_z_29_FJ() {
        return this.FIELD_z_29_FJ;
    }

    public String getFIELD_z_29_nr() {
        return this.FIELD_z_29_nr;
    }

    public String getFIELD_z_29_short_text() {
        return this.FIELD_z_29_short_text;
    }

    public String getFIELD_z_29_text() {
        return this.FIELD_z_29_text;
    }

    public BigDecimal getFIELD_z_30() {
        return this.FIELD_z_30;
    }

    public BigDecimal getFIELD_z_30_VJ() {
        return this.FIELD_z_30_VJ;
    }

    public BigDecimal getFIELD_z_30_FJ() {
        return this.FIELD_z_30_FJ;
    }

    public String getFIELD_z_30_nr() {
        return this.FIELD_z_30_nr;
    }

    public String getFIELD_z_30_short_text() {
        return this.FIELD_z_30_short_text;
    }

    public String getFIELD_z_30_text() {
        return this.FIELD_z_30_text;
    }

    public BigDecimal getFIELD_z_31() {
        return this.FIELD_z_31;
    }

    public BigDecimal getFIELD_z_31_VJ() {
        return this.FIELD_z_31_VJ;
    }

    public BigDecimal getFIELD_z_31_FJ() {
        return this.FIELD_z_31_FJ;
    }

    public String getFIELD_z_31_nr() {
        return this.FIELD_z_31_nr;
    }

    public String getFIELD_z_31_short_text() {
        return this.FIELD_z_31_short_text;
    }

    public String getFIELD_z_31_text() {
        return this.FIELD_z_31_text;
    }

    public BigDecimal getFIELD_z_32() {
        return this.FIELD_z_32;
    }

    public BigDecimal getFIELD_z_32_VJ() {
        return this.FIELD_z_32_VJ;
    }

    public BigDecimal getFIELD_z_32_FJ() {
        return this.FIELD_z_32_FJ;
    }

    public String getFIELD_z_32_nr() {
        return this.FIELD_z_32_nr;
    }

    public String getFIELD_z_32_short_text() {
        return this.FIELD_z_32_short_text;
    }

    public String getFIELD_z_32_text() {
        return this.FIELD_z_32_text;
    }

    public Date getMEmployeeEndDate() {
        return this.mEmployeeEndDate;
    }

    public Date getMEmployeeStartDate() {
        return this.mEmployeeStartDate;
    }

    public WageTaxEmployeeBean getMEWT() {
        return this.mEWT;
    }

    public int getMFederalState() {
        return this.mFederalState;
    }

    public BigDecimal getLStJAChrchTaxGesamt() {
        return this.FIELD_LStJA_ChrchTax_gesamt;
    }

    public List<ValuepositionContainer> getMValuePositionli() {
        return this.mValuePositionli;
    }

    private class ChurchtaxBean {
        private BigDecimal FIELD_z_26 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_27 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_28 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_29 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_30 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_31 = BigDecimal.ZERO;
        private BigDecimal FIELD_z_32 = BigDecimal.ZERO;

        public BigDecimal getFIELD_z_26() {
            return this.FIELD_z_26;
        }

        public void setFIELD_z_26(BigDecimal fIELD_z_26) {
            this.FIELD_z_26 = fIELD_z_26;
        }

        public BigDecimal getFIELD_z_27() {
            return this.FIELD_z_27;
        }

        public void setFIELD_z_27(BigDecimal fIELD_z_27) {
            this.FIELD_z_27 = fIELD_z_27;
        }

        public BigDecimal getFIELD_z_28() {
            return this.FIELD_z_28;
        }

        public void setFIELD_z_28(BigDecimal fIELD_z_28) {
            this.FIELD_z_28 = fIELD_z_28;
        }

        public BigDecimal getFIELD_z_29() {
            return this.FIELD_z_29;
        }

        public void setFIELD_z_29(BigDecimal fIELD_z_29) {
            this.FIELD_z_29 = fIELD_z_29;
        }

        public BigDecimal getFIELD_z_30() {
            return this.FIELD_z_30;
        }

        public void setFIELD_z_30(BigDecimal fIELD_z_30) {
            this.FIELD_z_30 = fIELD_z_30;
        }

        public BigDecimal getFIELD_z_31() {
            return this.FIELD_z_31;
        }

        public void setFIELD_z_31(BigDecimal fIELD_z_31) {
            this.FIELD_z_31 = fIELD_z_31;
        }

        public BigDecimal getFIELD_z_32() {
            return this.FIELD_z_32;
        }

        public void setFIELD_z_32(BigDecimal fIELD_z_32) {
            this.FIELD_z_32 = fIELD_z_32;
        }
    }

    private static enum TypeOfAddition {
        TOA_NUR_MITARBEITER,
        TOA_NUR_EHEGATTE,
        TOA_MITARBEITER_EHEGATTE;

    }
}

