/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.wagetax;

import com.infor.igf.py.PayrollConstants;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.framework.basictypes.ReportExportFormatEnum;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.pcompany.attributive.AttributiveCompany;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.reportdatatransfer.mapper.ReportDataTransferExceptionMapper;
import com.varial.personnel.domain.reports.wagetax.RetroActiveTreatmentEnum;
import com.varial.personnel.domain.reports.wagetax.WageTaxReportDataSource;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.SpecialAccess;
import com.varial.personnel.servantimpl.employee.SpecialAccessPrintCommand;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;

public class WageTaxReport
extends SpecialAccessPrintCommand<ReportFileStructCallback> {
    private static final long serialVersionUID = 1910367601314331731L;
    private static String PROFILE_PREFIX = "WTR";
    private final ReportFirstFilterStruct mFirstFilter;
    private final ReportSecondFilterStruct[] mSecondFilter;
    private final ReportThirdFilterStruct mThirdFilter;
    private final ReportSortStruct[] mSorts;
    private boolean mPayment;
    private String mName;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private String mUserPassword = "";
    private final String mOwnerPassword;
    private final boolean mDataTransfer;
    private final boolean mInternalUse;
    private final boolean mCancelationCollectionOrder;
    private final boolean mComputationAmountRefunded;
    private final RetroActiveTreatmentEnum mRetroActiveType;
    private final ReportExportFormatEnum mReportExportFormat;
    private final List<String> mErrorList;
    private ProgressBarUpdater mProgressBar;

    public WageTaxReport(AuthorizationToken token, ReportFileStructCallback callback, TransactionMode transactionMode, ReportFirstFilterStruct filter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, String name, String password, boolean payment, boolean dataTransfer, boolean internalUse, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportExportFormatEnum format) {
        super(token, (AllCallbackOperations)callback, transactionMode, SpecialAccess.mode((boolean)internalUse));
        this.mFirstFilter = filter;
        this.mSecondFilter = null;
        this.mThirdFilter = null;
        this.mSorts = sorts;
        this.mPayment = payment;
        this.mName = name;
        this.mForEffectiveDate = forEffectiveDate;
        this.mForValidDate = forValidDate;
        this.mUserPassword = password;
        this.mOwnerPassword = PayrollConstants.getReportOwnerSecret();
        this.mDataTransfer = dataTransfer;
        this.mInternalUse = internalUse;
        this.mCancelationCollectionOrder = cancelationCollectionOrder;
        this.mComputationAmountRefunded = computationAmountRefunded;
        this.mRetroActiveType = retroActiveType;
        this.mReportExportFormat = format;
        this.mErrorList = new ArrayList<String>();
    }

    public WageTaxReport(AuthorizationToken token, ReportFileStructCallback callback, TransactionMode transactionMode, ReportSecondFilterStruct[] filters, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, String password, boolean dataTransfer, boolean internalUse, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportExportFormatEnum format) {
        super(token, (AllCallbackOperations)callback, transactionMode, SpecialAccess.mode((boolean)internalUse));
        this.mFirstFilter = null;
        this.mSecondFilter = filters;
        this.mThirdFilter = null;
        this.mSorts = sorts;
        this.mForEffectiveDate = forEffectiveDate;
        this.mForValidDate = forValidDate;
        this.mUserPassword = password;
        this.mOwnerPassword = PayrollConstants.getReportOwnerSecret();
        this.mDataTransfer = dataTransfer;
        this.mInternalUse = internalUse;
        this.mCancelationCollectionOrder = cancelationCollectionOrder;
        this.mComputationAmountRefunded = computationAmountRefunded;
        this.mRetroActiveType = retroActiveType;
        this.mReportExportFormat = format;
        this.mErrorList = new ArrayList<String>();
    }

    public WageTaxReport(AuthorizationToken token, ReportFileStructCallback callback, TransactionMode transactionMode, ReportThirdFilterStruct filter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, String password, boolean dataTransfer, boolean internalUse, boolean cancelationCollectionOrder, boolean computationAmountRefunded, RetroActiveTreatmentEnum retroActiveType, ReportExportFormatEnum format) {
        super(token, (AllCallbackOperations)callback, transactionMode, SpecialAccess.mode((boolean)internalUse));
        this.mFirstFilter = null;
        this.mSecondFilter = null;
        this.mThirdFilter = filter;
        this.mSorts = sorts;
        this.mForEffectiveDate = forEffectiveDate;
        this.mForValidDate = forValidDate;
        this.mUserPassword = password;
        this.mOwnerPassword = PayrollConstants.getReportOwnerSecret();
        this.mDataTransfer = dataTransfer;
        this.mInternalUse = internalUse;
        this.mCancelationCollectionOrder = cancelationCollectionOrder;
        this.mComputationAmountRefunded = computationAmountRefunded;
        this.mRetroActiveType = retroActiveType;
        this.mReportExportFormat = format;
        this.mErrorList = new ArrayList<String>();
    }

    public void execute() throws BusinessDomainException, PutDataException {
        AttributiveCompany[] attributiveCompanySeq;
        String oidPCompany;
        PCompany pCompany;
        String url = "";
        LinkedList<String> urlListe = new LinkedList<String>();
        boolean multiple = false;
        boolean error = false;
        if (this.mRetroActiveType.value() == 1) {
            throw ReportExceptionMapper.makeUseSettlementWagetax();
        }
        if (this.mDataTransfer && this.mInternalUse) {
            throw ReportDataTransferExceptionMapper.makeNoSameUseOfInternalUseAndDataTransfer();
        }
        ReportFirstFilterStruct[] firstFilterSeq = new ReportFirstFilterStruct[]{this.mFirstFilter};
        if (this.mFirstFilter != null && (pCompany = PCompanyPersistencyManager.getPCompany((String)(oidPCompany = this.mFirstFilter.oidPCompany))).getIsMultiple() && (attributiveCompanySeq = pCompany.getAttributiveCompany()).length > 0) {
            firstFilterSeq = new ReportFirstFilterStruct[attributiveCompanySeq.length];
            for (int i = 0; i < attributiveCompanySeq.length; ++i) {
                firstFilterSeq[i] = new ReportFirstFilterStruct(attributiveCompanySeq[i].getAttributiveCompany().getObjectid(), "", "", "", "", "", "", "", "", "", "", "", "");
            }
            if (attributiveCompanySeq.length > 1) {
                multiple = true;
            }
        }
        this.mProgressBar = new ProgressBarUpdater((ReportFileStructCallback)this.getCallback(), 1, firstFilterSeq.length, "Lohnsteuer-Anmeldung");
        this.mProgressBar.show();
        JasperReport wageTaxReportJasperReport = null;
        JasperReport wageTaxSubJasperReport2006 = null;
        JasperReport wageTaxSubJasperReport2007 = null;
        JasperReport wageTaxSubJasperReport2009 = null;
        JasperReport wageTaxSubJasperReport2018 = null;
        JasperReport wageTaxSubJasperReport2019 = null;
        JasperReport wageTaxSubJasperReport2022 = null;
        JasperReport wageTaxSubJasperReport2026 = null;
        JasperReport wageTaxSubRAJasperReport = null;
        JasperReport wageTaxSubRAJasperReport2009 = null;
        JasperReport wageTaxErrorReport = null;
        if (!this.mDataTransfer) {
            wageTaxReportJasperReport = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxReport.jrxml");
            wageTaxSubJasperReport2006 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2006.jrxml");
            wageTaxSubJasperReport2007 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2007.jrxml");
            wageTaxSubJasperReport2009 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2009.jrxml");
            wageTaxSubJasperReport2018 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2018.jrxml");
            wageTaxSubJasperReport2019 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2019.jrxml");
            wageTaxSubJasperReport2022 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2022.jrxml");
            wageTaxSubJasperReport2026 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubReport2026.jrxml");
            wageTaxSubRAJasperReport = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubRAReport.jrxml");
            wageTaxSubRAJasperReport2009 = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/wagetax/WageTaxSubRAReport2009.jrxml");
            wageTaxErrorReport = JasperReportCompiler.compileReport((String)"com/varial/personnel/jasperreport/reports/ErrorPortraitReport.jrxml");
        }
        for (int i = 0; i < firstFilterSeq.length; ++i) {
            try {
                ReportHelper.reportsCheckUserValidDate((Date)this.mForEffectiveDate, (Date)this.mForValidDate, (ReportFirstFilterStruct)firstFilterSeq[i], (ReportSecondFilterStruct[])this.mSecondFilter, (ReportThirdFilterStruct)this.mThirdFilter);
                WageTaxReportDataSource wageTaxReportDataSource = new WageTaxReportDataSource((AllCallback)this.getCallback(), (ISpecialAccessPersistencyContext)this.getSpecialAccess(), firstFilterSeq[i], this.mSecondFilter, this.mThirdFilter, this.mSorts, this.mForEffectiveDate, this.mForValidDate, this.mName, this.mPayment, this.mDataTransfer, this.mInternalUse, this.mCancelationCollectionOrder, this.mComputationAmountRefunded, this.mRetroActiveType, this.mErrorList, this.mProgressBar);
                if (!this.mDataTransfer) {
                    Map<String, Object> parameter = wageTaxReportDataSource.getParameters();
                    parameter.put("subreport_wage_tax_2006", wageTaxSubJasperReport2006);
                    parameter.put("subreport_wage_tax_2007", wageTaxSubJasperReport2007);
                    parameter.put("subreport_wage_tax_2009", wageTaxSubJasperReport2009);
                    parameter.put("subreport_wage_tax_2018", wageTaxSubJasperReport2018);
                    parameter.put("subreport_wage_tax_2019", wageTaxSubJasperReport2019);
                    parameter.put("subreport_wage_tax_2022", wageTaxSubJasperReport2022);
                    parameter.put("subreport_wage_tax_2026", wageTaxSubJasperReport2026);
                    parameter.put("subreport_wage_tax_ra", wageTaxSubRAJasperReport);
                    parameter.put("subreport_wage_tax_ra2009", wageTaxSubRAJasperReport2009);
                    parameter.put("subreport_errorReport", wageTaxErrorReport);
                    File file = this.createFile(wageTaxReportDataSource, parameter, wageTaxReportJasperReport);
                    url = JasperReportManager.getUrl((File)file);
                }
            }
            catch (BusinessDomainException de) {
                ExceptionMapper.printException((Throwable)de);
                if (multiple && ReportExceptionMapper.isNoEmployeeForThisAssortmentException((BusinessDomainException)de)) {
                    error = true;
                }
                throw de;
            }
            if (!error) {
                if (!StringMapper.isNullString((String)url)) {
                    urlListe.add(url);
                }
            } else {
                error = false;
            }
            this.mProgressBar.nextStep();
        }
        if (this.getTransactionMode() == TransactionMode.UPDATE) {
            this.getContext().flush();
        }
        String[] result = new String[urlListe.size()];
        result = urlListe.toArray(result);
        ((ReportFileStructCallback)this.getCallback()).putData(result);
    }

    private File createFile(WageTaxReportDataSource reportDataSource, Map<String, Object> parameters, JasperReport jasperReport) throws BusinessDomainException, PutDataException {
        this.mProgressBar.setTotal(reportDataSource.getCountEmployeeWageTaxEFRit());
        if (!StringMapper.isNullString((String)this.mUserPassword)) {
            return JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)jasperReport, parameters, (JRDataSource)reportDataSource, (String)PROFILE_PREFIX, (String)this.mUserPassword, (String)this.mOwnerPassword);
        }
        if (this.mReportExportFormat == ReportExportFormatEnum.REFE_ARCHIVE) {
            return JasperReportManager.runReportToArchive((JasperReport)jasperReport, parameters, (JRDataSource)reportDataSource, (String)PROFILE_PREFIX, (byte[])new byte[0], (boolean)false, (int)0, (int)0, (int)0, (int)0);
        }
        return JasperReportManager.runReportToPdf((String)this.getToken().getUserId(), (JasperReport)jasperReport, parameters, (JRDataSource)reportDataSource, (String)PROFILE_PREFIX);
    }
}

