/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.eubp;

import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;

public enum EubpVersion {
    V_3_3_0("3.3.0"),
    V_3_4_0("3.4.0"),
    V_3_5_0("3.5.0");

    private final String versionString;
    public static String PROPKEY_EUBPVERSION;
    public static EubpVersion DEFAULT_EUBPVERSION;
    private static EubpVersion eubpVersion;

    private EubpVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    private static EubpVersion getEubpVersion(String versionString) {
        for (EubpVersion eubpVersion : EubpVersion.values()) {
            if (!versionString.equals(eubpVersion.versionString)) continue;
            return eubpVersion;
        }
        return null;
    }

    public static EubpVersion getVersion() throws BusinessDomainException {
        String version;
        if (eubpVersion == null && (eubpVersion = EubpVersion.getEubpVersion(version = ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getString(PROPKEY_EUBPVERSION, DEFAULT_EUBPVERSION.toString()))) == null) {
            throw EubpExceptionMapper.makeUnknownEubpVersionException(version);
        }
        return eubpVersion;
    }

    public String getVersionDSST() {
        return this.compareTo(V_3_5_0) >= 0 ? "04" : (this.compareTo(V_3_4_0) >= 0 ? "03" : "02");
    }

    public String getVersionDSEK() {
        return "04";
    }

    public String getVersionDSBN() {
        return this.compareTo(V_3_5_0) >= 0 ? "07" : "06";
    }

    public String getVersionDSAN() {
        return this.compareTo(V_3_5_0) >= 0 ? "08" : (this.compareTo(V_3_4_0) >= 0 ? "07" : "06");
    }

    public String getVersionDSLA() {
        return this.compareTo(V_3_5_0) >= 0 ? "08" : (this.compareTo(V_3_4_0) >= 0 ? "07" : "06");
    }

    static {
        PROPKEY_EUBPVERSION = "eubp.version";
        DEFAULT_EUBPVERSION = V_3_5_0;
        eubpVersion = null;
    }
}

