/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.eubp;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTime;
import com.varial.personnel.domain.absenttime.AbsentTimeTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFund;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTP;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyaccidentinsurancefund.accidentinsurancefundvaluetype.AccidentInsuranceFundValuetype;
import com.varial.personnel.domain.employee.EECompanyPlant;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.accidentinsurancefund.EEAccidentInsuranceFund;
import com.varial.personnel.domain.employee.datacredit.EEDataCreditTP;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.insurance.ModeOfPensionEnum;
import com.varial.personnel.domain.employee.insurance.SpecialCategoryEnum;
import com.varial.personnel.domain.employee.insurance.TypeAgePartTimeEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.basics.BasicRecordWgh;
import com.varial.personnel.domain.eubp.dsla.EubpDsla;
import com.varial.personnel.domain.eubp.dsla.PartDsla;
import com.varial.personnel.domain.eubp.dsla.PartDslaLohnart;
import com.varial.personnel.domain.eubp.dsla.dbat.EubpDbat;
import com.varial.personnel.domain.eubp.dsla.dbfz.EubpDbfz;
import com.varial.personnel.domain.eubp.dsla.dbfz.PartDbfz;
import com.varial.personnel.domain.eubp.dsla.dbkg.EubpDbkg;
import com.varial.personnel.domain.eubp.dsla.dbvw.EubpDbvw;
import com.varial.personnel.domain.eubp.dsla.dbvz.EubpDbvz;
import com.varial.personnel.domain.eubp.dsla.dbwg.EubpDbwg;
import com.varial.personnel.domain.eubp.dsla.dbwo.EubpDbwo;
import com.varial.personnel.domain.eubp.dsla.dbww.EubpDbww;
import com.varial.personnel.domain.global.accidentinsurancefund.AccidentInsuranceFund;
import com.varial.personnel.domain.global.creditmodel.TypeOfCreditEnum;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.place.PlantPlace;
import com.varial.personnel.domain.reports.eubp.EmployeeWithPeriods;
import com.varial.personnel.domain.reports.eubp.EubpCreator;
import com.varial.personnel.domain.reports.eubp.EubpVersion;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.domain.typeofvalue.foundation.general.FoundationGeneral;
import com.varial.personnel.domain.workingtime.WorkingTime;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.Period;
import com.varial.personnel.framework.PeriodMap;
import com.varial.personnel.framework.Periods;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.InclusionEnum;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;

public class DslaCreator {
    private static final Logger LOGGER = EubpCreator.LOGGER;
    private final EubpCreator mEubpCreator;
    private final Map<String, List<ValuepositionContainer>> mValuePositionMap = new HashMap<String, List<ValuepositionContainer>>();
    private final Map<String, List<LohnartEigenschaft>> mLohnartEigenschaftMap = new HashMap<String, List<LohnartEigenschaft>>();
    private final Employee mEmployee;
    private final Periods mPeriods;
    private final EubpAccount mEubpAccount;
    private final Date mEffectiveDate;
    private final Date mValidDate;
    private PeriodMap<List<AssignmentPCompanyAccidentInsuranceFundTP>> mAssignmentPCompanyAccidentInsuranceFundTPMap = new PeriodMap();
    private String[] mAwaArray = new String[0];

    public DslaCreator(EubpCreator eubpCreator, EmployeeWithPeriods employeeWithPeriod, Date validDate) {
        this.mEubpCreator = eubpCreator;
        this.mEubpAccount = eubpCreator.mEubpAccount;
        this.mEffectiveDate = eubpCreator.mEffectiveDate;
        this.mEmployee = employeeWithPeriod.getEmployee();
        this.mPeriods = employeeWithPeriod.getPeriods();
        this.mValidDate = validDate;
    }

    public EubpDsla create() throws BusinessDomainException {
        AccidentInsuranceFund accidentInsuranceFund;
        Plant plant;
        Criterion oidRestriction;
        LOGGER.debug("DslaCreator.create(): Begin, personnelnumber=" + this.mEmployee.getPersonnelnumber() + "; mPeriods=" + this.mPeriods + "; mValidDate=" + this.mValidDate);
        if (this.mEubpAccount.getPCompany() != null) {
            oidRestriction = Restrictions.eq((String)"oidpcompany", (String)this.mEubpAccount.getPCompany().getObjectid());
        } else if (this.mEubpAccount.getPlant() != null) {
            plant = this.mEubpAccount.getPlant();
            oidRestriction = Restrictions.or((Criterion)Restrictions.eq((String)"oidplant", (String)plant.getObjectid()), (Criterion)Restrictions.eq((String)"oidpcompany", (String)plant.getHeadCompany().getObjectid()));
        } else {
            plant = this.mEubpAccount.getPlantPlace().getPlant();
            oidRestriction = Restrictions.or((Criterion)Restrictions.eq((String)"oidplant", (String)plant.getObjectid()), (Criterion)Restrictions.eq((String)"oidpcompany", (String)plant.getHeadCompany().getObjectid()));
        }
        String[] uvValueTypeKeysArray = new String[]{};
        EEAccidentInsuranceFund eeAccidentInsuranceFund = (EEAccidentInsuranceFund)this.mEmployee.getEEAccidentInsuranceFundHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate);
        if (eeAccidentInsuranceFund != null && (accidentInsuranceFund = eeAccidentInsuranceFund.getAccidentInsuranceFund()) != null) {
            Conjunction restrictions = Restrictions.conjunction((Criterion[])new Criterion[]{oidRestriction, this.mPeriods.toDisjunction("validfrom", "validuntil"), this.mPeriods.toDisjunction("effectivefrom", "effectiveuntil"), Restrictions.eq((String)"OIDACCIDENTINS", (String)accidentInsuranceFund.getObjectid())});
            LOGGER.debug("DslaCreator.create(): AssignmentPCompanyAccidentInsuranceFundTP.queryAll()");
            AssignmentPCompanyAccidentInsuranceFundTP[] assignmentPCAIFTPs = AssignmentPCompanyAccidentInsuranceFundTPPersistencyManager.queryAll(null, (Criterion)restrictions);
            this.mAssignmentPCompanyAccidentInsuranceFundTPMap = PeriodMap.createListMap((PersonnelTimedPersistenceObject[])assignmentPCAIFTPs, (Periods)this.mPeriods);
            uvValueTypeKeysArray = this.getUvValueTypeKeys(this.mAssignmentPCompanyAccidentInsuranceFundTPMap);
        }
        LOGGER.debug("DslaCreator.create(): getValuePosition()");
        this.getValuePosition(uvValueTypeKeysArray);
        LOGGER.debug("DslaCreator.create(): createLohnartEigenschaften()");
        this.createLohnartEigenschaften();
        EubpDsla dsla = new EubpDsla();
        dsla.setVersionsnr(this.mEubpCreator.getEubpVersion().getVersionDSLA());
        dsla.setBasicRecord(this.mEubpCreator.mBasicRecord);
        dsla.setEubpAccount(this.mEubpAccount);
        dsla.setMandant(this.mEubpCreator.mBetriebsnummer);
        dsla.setEmployee(this.mEmployee);
        dsla.setAzvu(this.mEmployee.getPCompany().getPCompanyKey() + "/" + Integer.toString(this.mEmployee.getPersonnelnumber()));
        Insurance insurance = this.getInsurance(this.mEffectiveDate, this.mValidDate);
        String insuranceNo = insurance != null ? insurance.getInsuranceNo() : "";
        dsla.setVsnr(insuranceNo);
        dsla.setMmvt(false);
        ArrayList<PartDsla> partDslaList = new ArrayList<PartDsla>();
        for (Period period : this.mPeriods) {
            for (Period month : period) {
                PartDsla partDslaAktuellerMonat;
                boolean monthWithoutEmployment;
                LOGGER.debug("DslaCreator.create(): month=" + month);
                Date rueckrechnungsdatum = this.getRueckrechnungsdatum(month.from);
                boolean bl = monthWithoutEmployment = !this.mEmployee.isMonthOfEmployment(month.from, this.mEffectiveDate);
                if (DateHelper.afterOrEqual((Date)rueckrechnungsdatum, (Date)month.from) && monthWithoutEmployment) continue;
                Insurance partInsurance = this.getInsurance(month.until, month.until);
                if (!(partInsurance == null || (partDslaAktuellerMonat = this.createPartDsla(dsla, partInsurance, month.from, month.until, month.from, month.until, false)).hatNurNullWerte() && monthWithoutEmployment)) {
                    this.addTopPartDslaList(partDslaList, partDslaAktuellerMonat, partInsurance, month.from, month.until, month.from, month.until);
                }
                if (!DateHelper.before((Date)rueckrechnungsdatum, (Date)month.from)) continue;
                Date vormonat = DateHelper.addMonths((Date)month.from, (int)-1);
                Date rueckrechnungsmonat = rueckrechnungsdatum;
                while (DateHelper.before((Date)rueckrechnungsmonat, (Date)month.from)) {
                    LOGGER.debug("DslaCreator.create(): month=" + month + "; rueckrechnungsmonat=" + DateMapper.toDDMMYYYYPointSeparationString((Date)rueckrechnungsmonat));
                    Insurance partInsuranceNeu = this.getInsurance(month.until, DateHelper.getLastDayOfMonth((Date)rueckrechnungsmonat));
                    Insurance partInsuranceAlt = this.getInsurance(vormonat, DateHelper.getLastDayOfMonth((Date)rueckrechnungsmonat));
                    if (partInsuranceNeu != null && partInsuranceAlt != null) {
                        PartDsla partDslaNeu = this.createPartDsla(dsla, partInsuranceNeu, month.from, month.until, rueckrechnungsmonat, DateHelper.getLastDayOfMonth((Date)rueckrechnungsmonat), true);
                        PartDsla partDslaAlt = this.createPartDsla(dsla, partInsuranceAlt, vormonat, DateHelper.getLastDayOfMonth((Date)vormonat), rueckrechnungsmonat, DateHelper.getLastDayOfMonth((Date)rueckrechnungsmonat), true);
                        if (StringMapper.compareTo((String)partDslaNeu.printCompareString(), (String)partDslaAlt.printCompareString()) != 0) {
                            this.addTopPartDslaList(partDslaList, partDslaNeu, partInsuranceNeu, month.from, month.until, rueckrechnungsmonat, DateHelper.getLastDayOfMonth((Date)rueckrechnungsmonat));
                        }
                    }
                    rueckrechnungsmonat = DateHelper.addMonths((Date)rueckrechnungsmonat, (int)1);
                }
            }
        }
        PartDsla[] partDslaArray = new PartDsla[partDslaList.size()];
        partDslaArray = partDslaList.toArray(partDslaArray);
        dsla.setPartDslas(partDslaArray);
        LOGGER.debug("DslaCreator.create(): End");
        return dsla;
    }

    private String[] getUvValueTypeKeys(PeriodMap<List<AssignmentPCompanyAccidentInsuranceFundTP>> apcaiftpMap) {
        HashSet<String> uvValueTypeKeys = new HashSet<String>();
        for (List apcaiftps : apcaiftpMap.values()) {
            for (AssignmentPCompanyAccidentInsuranceFundTP apcaiftp : apcaiftps) {
                for (AccidentInsuranceFundValuetype aifvt : apcaiftp.getValueTypes()) {
                    if (aifvt.getInclusionContibutoryPayment().value() <= 0) continue;
                    uvValueTypeKeys.add(String.valueOf(aifvt.getValueType().getValueTypeKey()));
                }
            }
        }
        return uvValueTypeKeys.toArray(new String[0]);
    }

    private void addTopPartDslaList(List<PartDsla> partDslaList, PartDsla partDsla, Insurance insurance, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        Employment wghKonten;
        Date vormonatUntil;
        Date vormonatFrom;
        EubpDbkg dbkg;
        EubpDbfz dbfz = this.createDbfz(effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (dbfz != null) {
            partDsla.setDbfz(dbfz);
            partDsla.setMmfz(true);
        }
        if ((dbkg = this.createDbkg(effectiveFrom, effectiveUntil, validFrom, validUntil)) != null) {
            partDsla.setDbkg(dbkg);
            partDsla.setMmkg(true);
        }
        if (this.mEubpCreator.getEubpVersion().compareTo(EubpVersion.V_3_4_0) >= 0 && PDateHelper.inSameMonth((Date)validFrom, (Date)this.mEubpCreator.getValidFrom()) && insurance != null && insurance.getPersonGroup() == 103 && insurance.getTypeAgePartTime() == TypeAgePartTimeEnum.TOAPTE_BLOCKZEIT) {
            vormonatFrom = DateHelper.getFirstDayOfMonth((Date)DateHelper.addMonths((Date)validFrom, (int)-1));
            vormonatUntil = DateHelper.getLastDayOfMonth((Date)DateHelper.addMonths((Date)validFrom, (int)-1));
            EEDataCreditTP[] eeDataCreditTPs = this.mEmployee.getEEDataCredits(effectiveFrom, vormonatUntil);
            Date beginn = null;
            for (EEDataCreditTP eeDataCreditTP2 : eeDataCreditTPs) {
                beginn = PDateHelper.minIgnoringNulls((Date[])new Date[]{beginn, eeDataCreditTP2.getBeginEast(), eeDataCreditTP2.getBeginWest()});
            }
            if (beginn != null && DateHelper.beforeOrEqual(beginn, (Date)vormonatUntil)) {
                EubpDbvz dbvz = new EubpDbvz();
                ValuePosition[] valuePositions = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)vormonatUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)vormonatFrom)), Restrictions.in((String)"valuetypenumber", (String[])new String[]{"801000", "801400", "324000", "330000", "336000", "342000"})}));
                BigDecimal kvsvluft = this.getResultFromValuepositions(valuePositions, 324000);
                BigDecimal rvsvluft = this.getResultFromValuepositions(valuePositions, 330000);
                BigDecimal avsvluft = this.getResultFromValuepositions(valuePositions, 336000);
                BigDecimal pvsvluft = this.getResultFromValuepositions(valuePositions, 342000);
                BigDecimal gesWghSvPfl = this.getResultFromValuepositions(valuePositions, 801000);
                BigDecimal gesAgaSvPflWgh = this.getResultFromValuepositions(valuePositions, 801400);
                BigDecimal differenz = gesWghSvPfl.subtract(gesAgaSvPflWgh);
                BigDecimal kvabgegrsvluftsum = kvsvluft.signum() <= 0 ? BigDecimal.ZERO : kvsvluft.min(differenz);
                BigDecimal rvabgegrsvluftsum = rvsvluft.signum() <= 0 ? BigDecimal.ZERO : rvsvluft.min(differenz);
                BigDecimal avabgegrsvluftsum = avsvluft.signum() <= 0 ? BigDecimal.ZERO : avsvluft.min(differenz);
                BigDecimal pvabgegrsvluftsum = pvsvluft.signum() <= 0 ? BigDecimal.ZERO : pvsvluft.min(differenz);
                dbvz.setKvsvluft(kvsvluft);
                dbvz.setRvsvluft(rvsvluft);
                dbvz.setAvsvluft(avsvluft);
                dbvz.setPvsvluft(pvsvluft);
                dbvz.setKvabgegrsvluftsum(kvabgegrsvluftsum);
                dbvz.setRvabgegrsvluftsum(rvabgegrsvluftsum);
                dbvz.setAvabgegrsvluftsum(avabgegrsvluftsum);
                dbvz.setPvabgegrsvluftsum(pvabgegrsvluftsum);
                partDsla.setDbvz(dbvz);
                partDsla.setMmvatz(true);
            }
        }
        if (this.mEubpCreator.getEubpVersion().compareTo(EubpVersion.V_3_4_0) >= 0 && PDateHelper.inSameMonth((Date)validFrom, (Date)this.mEubpCreator.getValidFrom()) && insurance != null && insurance.getPersonGroup() != 103) {
            vormonatFrom = DateHelper.getFirstDayOfMonth((Date)DateHelper.addMonths((Date)validFrom, (int)-1));
            vormonatUntil = DateHelper.getLastDayOfMonth((Date)DateHelper.addMonths((Date)validFrom, (int)-1));
            Employment employment = (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(effectiveFrom, vormonatUntil);
            if (employment != null && employment.getDateOfEntry() != null && DateHelper.beforeOrEqual((Date)employment.getDateOfEntry(), (Date)vormonatUntil) && (employment.getDateOfWithDrawal() == null || DateHelper.after((Date)employment.getDateOfWithDrawal(), (Date)vormonatFrom))) {
                EEDataCreditTP[] eeDataCreditTPs = this.mEmployee.getEEDataCredits(effectiveFrom, vormonatUntil);
                boolean hatSvPflWgh = false;
                for (EEDataCreditTP eeDataCreditTP3 : eeDataCreditTPs) {
                    TypeOfCreditEnum typeOfCreditEnum = eeDataCreditTP3.getEEDataCredit().getCreditModel().getTypeOfCredit();
                    if (typeOfCreditEnum != TypeOfCreditEnum.TOCBE_SV_PFLICHTIG && typeOfCreditEnum != TypeOfCreditEnum.TOCBE_WERTSTEIGERUNG_STEUER_UND_SV_PFLICHTIG) continue;
                    hatSvPflWgh = true;
                }
                if (hatSvPflWgh) {
                    EubpDbvw dbvw = new EubpDbvw();
                    ValuePosition[] valuePositions = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)vormonatUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)vormonatFrom)), Restrictions.in((String)"valuetypenumber", (String[])new String[]{"801000", "801400", "324000", "330000", "336000", "342000"})}));
                    BigDecimal kvsvluft = this.getResultFromValuepositions(valuePositions, 324000);
                    BigDecimal rvsvluft = this.getResultFromValuepositions(valuePositions, 330000);
                    BigDecimal knvsvluft = this.getResultFromValuepositions(valuePositions, new Integer[0]);
                    BigDecimal avsvluft = this.getResultFromValuepositions(valuePositions, 336000);
                    BigDecimal pvsvluft = this.getResultFromValuepositions(valuePositions, 342000);
                    BigDecimal gesWghSvPfl = this.getResultFromValuepositions(valuePositions, 801000);
                    BigDecimal gesAgaSvPflWgh = this.getResultFromValuepositions(valuePositions, 801400);
                    BigDecimal differenz = gesWghSvPfl.subtract(gesAgaSvPflWgh);
                    BigDecimal kvabgegrsvluftsum = kvsvluft.signum() <= 0 ? BigDecimal.ZERO : kvsvluft.min(differenz);
                    BigDecimal rvabgegrsvluftsum = rvsvluft.signum() <= 0 ? BigDecimal.ZERO : rvsvluft.min(differenz);
                    BigDecimal knvabgegrsvluftsum = knvsvluft.signum() <= 0 ? BigDecimal.ZERO : knvsvluft.min(differenz);
                    BigDecimal avabgegrsvluftsum = avsvluft.signum() <= 0 ? BigDecimal.ZERO : avsvluft.min(differenz);
                    BigDecimal pvabgegrsvluftsum = pvsvluft.signum() <= 0 ? BigDecimal.ZERO : pvsvluft.min(differenz);
                    dbvw.setKvsvluft(kvsvluft);
                    dbvw.setRvsvluft(rvsvluft);
                    dbvw.setKnvsvluft(knvsvluft);
                    dbvw.setAvsvluft(avsvluft);
                    dbvw.setPvsvluft(pvsvluft);
                    dbvw.setKvabgegrsvluftsum(kvabgegrsvluftsum);
                    dbvw.setRvabgegrsvluftsum(rvabgegrsvluftsum);
                    dbvw.setKnvabgegrsvluftsum(knvabgegrsvluftsum);
                    dbvw.setAvabgegrsvluftsum(avabgegrsvluftsum);
                    dbvw.setPvabgegrsvluftsum(pvabgegrsvluftsum);
                    partDsla.setDbvw(dbvw);
                    partDsla.setMmvwg(true);
                }
            }
        }
        if (this.mEubpCreator.getEubpVersion().compareTo(EubpVersion.V_3_4_0) >= 0 && insurance != null && insurance.getPersonGroup() != 103) {
            ArrayList<Employment> eeDataCreditTPs = new ArrayList<Employment>();
            for (Employment dataCreditTP : wghKonten = this.mEmployee.getEEDataCredits(effectiveFrom, validFrom)) {
                TypeOfCreditEnum typeOfCreditEnum = dataCreditTP.getEEDataCredit().getCreditModel().getTypeOfCredit();
                if (typeOfCreditEnum != TypeOfCreditEnum.TOCBE_SV_PFLICHTIG && typeOfCreditEnum != TypeOfCreditEnum.TOCBE_WERTSTEIGERUNG_STEUER_UND_SV_PFLICHTIG) continue;
                eeDataCreditTPs.add(dataCreditTP);
            }
            if (!eeDataCreditTPs.isEmpty()) {
                Employment dbwg = new EubpDbwg();
                dbwg.setWgmodell("0");
                dbwg.setSumges(DslaCreator.subtract(this.getResultFromValuepositions(new String[]{"801000"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"801400"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setSumgeso(DslaCreator.sum(this.getResultFromValuepositions(new String[]{"801025"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"801020"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"806020"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setSumgesw(DslaCreator.sum(this.getResultFromValuepositions(new String[]{"801015"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"801010"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"806010"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setKvpflaegsum(BigDecimal.ZERO);
                dbwg.setRvpflaegsum(BigDecimal.ZERO);
                dbwg.setKnvpflaegsum(BigDecimal.ZERO);
                dbwg.setAvpflaegsum(BigDecimal.ZERO);
                dbwg.setPvpflaegsum(BigDecimal.ZERO);
                dbwg.setUvpflaegsum(BigDecimal.ZERO);
                dbwg.setKvsvluft(DslaCreator.max(this.getResultFromValuepositions(new String[]{"324110"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"324150"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setRvsvluft(DslaCreator.max(this.getResultFromValuepositions(new String[]{"330110"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"330150"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setKnvsvluft(BigDecimal.ZERO);
                dbwg.setAvsvluft(DslaCreator.max(this.getResultFromValuepositions(new String[]{"336110"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"336150"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setPvsvluft(DslaCreator.max(this.getResultFromValuepositions(new String[]{"342110"}, effectiveFrom, effectiveUntil, validFrom, validUntil), this.getResultFromValuepositions(new String[]{"342150"}, effectiveFrom, effectiveUntil, validFrom, validUntil)));
                dbwg.setKvabgegrsvluftsum(BigDecimal.ZERO);
                dbwg.setRvabgegrsvluftsum(BigDecimal.ZERO);
                dbwg.setKnvabgegrsvluftsum(BigDecimal.ZERO);
                dbwg.setAvabgegrsvluftsum(BigDecimal.ZERO);
                dbwg.setPvabgegrsvluftsum(BigDecimal.ZERO);
                BigDecimal gsvagsum = this.getResultFromValuepositions(new String[]{"801400"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
                dbwg.setGsvagsum(gsvagsum);
                String lawArea = this.mEmployee.getAppurtenantLawArea(effectiveFrom, validFrom);
                dbwg.setGsvagsumo(StringMapper.equal((String)lawArea, (String)"O") ? gsvagsum : BigDecimal.ZERO);
                dbwg.setGsvagsumw(StringMapper.equal((String)lawArea, (String)"W") ? gsvagsum : BigDecimal.ZERO);
                partDsla.setDbwg((EubpDbwg)dbwg);
                partDsla.setMmwg(true);
            }
        }
        if (insurance != null && insurance.getPersonGroup() == 103) {
            EubpDbat dbat = this.createDbat(effectiveFrom, effectiveUntil, validFrom, validUntil);
            if (dbat != null) {
                partDsla.setDbat(dbat);
                partDsla.setMmat(true);
            }
        } else if (this.mEubpCreator.getEubpVersion().compareTo(EubpVersion.V_3_4_0) < 0) {
            EubpDbww dbww;
            List dataCreditTPWestList;
            EubpDbwo dbwo;
            EEDataCreditTP[] eeDataCreditTPArray;
            ArrayList<Employment> eeDataCreditList = new ArrayList<Employment>();
            for (Employment dataCreditTP : wghKonten = this.mEmployee.getEEDataCredits(effectiveFrom, validFrom)) {
                TypeOfCreditEnum typeOfCreditEnum = dataCreditTP.getEEDataCredit().getCreditModel().getTypeOfCredit();
                if (typeOfCreditEnum != TypeOfCreditEnum.TOCBE_SV_PFLICHTIG && typeOfCreditEnum != TypeOfCreditEnum.TOCBE_WERTSTEIGERUNG_STEUER_UND_SV_PFLICHTIG) continue;
                eeDataCreditList.add(dataCreditTP);
            }
            if (!eeDataCreditList.isEmpty()) {
                eeDataCreditTPArray = new EEDataCreditTP[eeDataCreditList.size()];
                eeDataCreditTPArray = eeDataCreditList.toArray(eeDataCreditTPArray);
            } else {
                eeDataCreditTPArray = new EEDataCreditTP[]{};
            }
            List dataCreditTPOstList = Arrays.stream(eeDataCreditTPArray).filter(eeDataCreditTP -> eeDataCreditTP.getBeginEast() != null && DateHelper.beforeOrEqual((Date)eeDataCreditTP.getBeginEast(), (Date)validUntil)).collect(Collectors.toList());
            if (!dataCreditTPOstList.isEmpty() && (dbwo = this.createDbwo(effectiveFrom, effectiveUntil, validFrom, validUntil, dataCreditTPOstList.size())) != null) {
                partDsla.setDbwo(dbwo);
                partDsla.setMmwo(true);
            }
            if (!(dataCreditTPWestList = Arrays.stream(eeDataCreditTPArray).filter(eeDataCreditTP -> eeDataCreditTP.getBeginWest() != null && DateHelper.beforeOrEqual((Date)eeDataCreditTP.getBeginWest(), (Date)validUntil)).collect(Collectors.toList())).isEmpty() && (dbww = this.createDbww(effectiveFrom, effectiveUntil, validFrom, validUntil, dataCreditTPWestList.size())) != null) {
                partDsla.setDbww(dbww);
                partDsla.setMmww(true);
            }
        }
        partDslaList.add(partDsla);
    }

    private static BigDecimal subtract(BigDecimal v, BigDecimal w) {
        return v.subtract(w);
    }

    private static BigDecimal sum(BigDecimal ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            result = result.add(value);
        }
        return result;
    }

    private static BigDecimal max(BigDecimal ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            if (value.compareTo(result) <= 0) continue;
            result = value;
        }
        return result;
    }

    private static String toFourCharPercentage(BigDecimal number) {
        number = number == null || number.signum() < 0 ? BigDecimal.ZERO : number.remainder(BigDecimal.valueOf(100L));
        number = number.setScale(2, RoundingMode.HALF_UP);
        return new DecimalFormat("00.00").format(number).replace(".", "").replace(",", "");
    }

    private PartDsla createPartDsla(EubpDsla dsla, Insurance insurance, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, boolean isRueckrechnung) throws BusinessDomainException {
        HealthFundTP healthFundTP;
        PartDsla partDsla = new PartDsla(dsla);
        Calendar validCalendar = Calendar.getInstance();
        validCalendar.setTime(validUntil);
        Calendar effectiveCalendar = Calendar.getInstance();
        effectiveCalendar.setTime(effectiveUntil);
        partDsla.setKj(validCalendar.get(1));
        partDsla.setKm(validCalendar.get(2) + 1);
        partDsla.setTagvon(1);
        partDsla.setTagbis(validCalendar.get(5));
        partDsla.setKjin(isRueckrechnung ? effectiveCalendar.get(1) : validCalendar.get(1));
        partDsla.setKmin(isRueckrechnung ? effectiveCalendar.get(2) + 1 : validCalendar.get(2) + 1);
        partDsla.setKennzart(isRueckrechnung ? "K" : "E");
        String abbrechdatString = effectiveUntil.toString();
        partDsla.setAbrechdat(DateMapper.toYYYYMMDDString((Date)effectiveUntil) + abbrechdatString.substring(11, 13) + abbrechdatString.substring(14, 16) + abbrechdatString.substring(17, 19) + "000");
        partDsla.setAbrnr(0);
        BigDecimal resultMK = this.getResultFromValuepositions(new String[]{"130630", "130640"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKennzmk(BigDecimalMapper.isZeroOrNull((BigDecimal)resultMK) ? "N" : "J");
        BigDecimal svtg = this.getFaktor1FromValuepositions(new String[]{"130590"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSvtg(null);
        partDsla.setKvtg(svtg.intValue());
        boolean hatBV = insurance.getRecipient() != null && insurance.getModeOfPension() != ModeOfPensionEnum.MOPE_KEINE;
        int rvBGS = insurance.getDuesGroupPI();
        int pgs = insurance.getPersonGroup();
        partDsla.setRvtg((rvBGS != 0 || pgs == 110 || pgs == 190) && !hatBV ? svtg.intValue() : 0);
        partDsla.setAvtg(svtg.intValue());
        partDsla.setPvtg(svtg.intValue());
        BigDecimal sttg = this.getFaktor1FromValuepositions(new String[]{"110590"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSttg(sttg.intValue());
        String kennzpvz = insurance.getNIChildEducation() ? "N" : "J";
        partDsla.setKennzpvz(kennzpvz);
        int kinderUnter25 = 0;
        if (insurance.getNIChildEducation() && DateHelper.afterOrEqual((Date)validFrom, (Date)new VDate(2023, 6, 1).getDate())) {
            kinderUnter25 = this.mEmployee.getEffectiveNumberOfChildrenForNI(effectiveUntil, validFrom, true, false).intValue();
            if (kinderUnter25 > 5) {
                kinderUnter25 = 5;
            }
            if (kinderUnter25 < 2) {
                kinderUnter25 = 0;
            }
        }
        partDsla.setKinderUnter25(kinderUnter25);
        EECompanyPlant eeCompanyPlant = (EECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        eeCompanyPlant.setEffectiveFrom(this.mEffectiveDate);
        eeCompanyPlant.setValidFrom(this.mValidDate);
        eeCompanyPlant.setEmployee(this.mEmployee);
        partDsla.setKennzpvs(eeCompanyPlant.getFederalStateTP().getLongDescription().equals("Sachsen") ? "J" : "N");
        partDsla.setPersgr(insurance.getPersonGroup());
        int bygrkv = insurance.getDuesGroupHI();
        partDsla.setBygrkv(bygrkv);
        partDsla.setBygrrv(insurance.getDuesGroupPI());
        partDsla.setBygrav(insurance.getDuesGroupUI());
        partDsla.setBygrpv(insurance.getDuesGroupNI());
        String bbnrEzu = "";
        String zbpSatz = "";
        String bbnrEzu2 = "";
        String byGrKV2 = "";
        String byGrRV2 = "";
        String byGrAV2 = "";
        String byGrPV2 = "";
        HealthFund healthFundAssessment = insurance.getAssessmentHealthFund();
        HealthFundTP healthFundTPAssessment = healthFundAssessment == null ? null : (HealthFundTP)healthFundAssessment.getHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate);
        HealthFund healthFund = insurance.getHealthFund();
        if (healthFund != null && (healthFundTP = (HealthFundTP)healthFund.getHistory().getItemOrNull(this.mEffectiveDate, this.mValidDate)) != null) {
            bbnrEzu = healthFundTP.getStandardCompanyNumber();
            if (bygrkv >= 1 && bygrkv <= 5) {
                zbpSatz = DslaCreator.toFourCharPercentage(healthFundTP.getAdditionalDues());
            }
            String bgs = insurance.getDuesGroups();
            if (pgs == 109 && healthFundTPAssessment != null && "98000006".equals(healthFundTPAssessment.getStandardCompanyNumber()) && insurance.getSpecialCategoryOfPersons() == SpecialCategoryEnum.SCE_GLEITZONENREGELUNG && insurance.getUseTransitionBy31122022()) {
                switch (bgs) {
                    case "1111": 
                    case "1101": 
                    case "3111": 
                    case "3101": {
                        bbnrEzu2 = StringMapper.isNullString((String)bbnrEzu) ? "" : "J";
                        byGrKV2 = "0";
                        byGrRV2 = "1";
                        byGrAV2 = "0";
                        byGrPV2 = "0";
                        break;
                    }
                    case "1511": 
                    case "1501": 
                    case "3511": 
                    case "3501": {
                        bbnrEzu2 = StringMapper.isNullString((String)bbnrEzu) ? "" : "J";
                        byGrKV2 = "0";
                        byGrRV2 = "5";
                        byGrAV2 = "0";
                        byGrPV2 = "0";
                        break;
                    }
                    case "6110": {
                        bbnrEzu2 = StringMapper.isNullString((String)bbnrEzu) ? "" : "J";
                        byGrKV2 = "6";
                        byGrRV2 = "1";
                        byGrAV2 = "0";
                        byGrPV2 = "0";
                        break;
                    }
                    case "6510": {
                        bbnrEzu2 = StringMapper.isNullString((String)bbnrEzu) ? "" : "J";
                        byGrKV2 = "6";
                        byGrRV2 = "5";
                        byGrAV2 = "0";
                        byGrPV2 = "0";
                    }
                }
            }
            if (pgs == 101 && "6100".equals(bgs)) {
                bbnrEzu2 = StringMapper.isNullString((String)bbnrEzu) ? "" : "J";
                byGrKV2 = "6";
                byGrRV2 = "0";
                byGrAV2 = "0";
                byGrPV2 = "0";
            }
        }
        partDsla.setZbpsatz(zbpSatz);
        partDsla.setBbnrEzu(bbnrEzu);
        partDsla.setBbnrEzu2(bbnrEzu2);
        partDsla.setByGrKV2(byGrKV2);
        partDsla.setByGrRV2(byGrRV2);
        partDsla.setByGrAV2(byGrAV2);
        partDsla.setByGrPV2(byGrPV2);
        String bbnrKkum = "";
        String umlSatz = "0000";
        if (healthFundTPAssessment != null) {
            bbnrKkum = healthFundTPAssessment.getStandardCompanyNumber();
            umlSatz = DslaCreator.toFourCharPercentage(healthFundTPAssessment.getAdditionalDues());
        }
        partDsla.setBbnrKkum(bbnrKkum);
        partDsla.setUmlsatz(umlSatz);
        partDsla.setWg("EUR");
        BigDecimal pauschsteuergb = this.getResultFromValuepositions(new String[]{"710280"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPauschsteuergb(pauschsteuergb);
        Tax tax = this.mEmployee.getTaxOrNull(effectiveUntil, validUntil);
        partDsla.setStkl(tax == null ? "" : String.valueOf(tax.getTaxBracket()));
        partDsla.setKistpf(tax != null && tax.getChurchTax() ? "J" : "N");
        partDsla.setKifrbtrg(tax == null ? BigDecimal.ZERO : tax.getChildRelief());
        partDsla.setEgStfrBtrg("");
        partDsla.setStfrBtrgMtl("");
        BigDecimal gesbrutto = this.getResultFromValuepositions(new String[]{"100100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setGesbrutto(gesbrutto);
        BigDecimal svbrutto = this.getResultFromValuepositions(new String[]{"130110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSvbrutto(svbrutto);
        BigDecimal steuerbrutto = this.getResultFromValuepositions(new String[]{"110100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSteuerbrutto(steuerbrutto);
        BigDecimal kvbrutto = this.getResultFromValuepositions(new String[]{"321110", "321740"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbrutto(kvbrutto);
        BigDecimal rvbrutto = this.getResultFromValuepositions(new String[]{"327110", "327740"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbrutto(rvbrutto);
        BigDecimal avbrutto = this.getResultFromValuepositions(new String[]{"333110", "333540"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbrutto(avbrutto);
        BigDecimal pvbrutto = this.getResultFromValuepositions(new String[]{"339110", "339740"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbrutto(pvbrutto);
        BigDecimal umbrutto = this.getResultFromValuepositions(new String[]{"360050"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setUmbrutto(umbrutto);
        BigDecimal insobrutto = this.getResultFromValuepositions(new String[]{"365100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setInsobrutto(insobrutto);
        BigDecimal uvbrutto = BigDecimal.ZERO;
        AssignmentPCompanyAccidentInsuranceFundTP apcaiftp = this.getAssignmentPCompanyAccidentInsuranceFundTP(effectiveUntil, validUntil);
        if (apcaiftp != null) {
            for (AccidentInsuranceFundValuetype aifvt : apcaiftp.getValueTypes()) {
                InclusionEnum inclusion = aifvt.getInclusionContibutoryPayment();
                if (inclusion == InclusionEnum.IE_KEINE_EINRECHNUNG) continue;
                BigDecimal result = this.getResultFromValuepositions(new String[]{String.valueOf(aifvt.getValueType().getValueTypeKey())}, effectiveFrom, effectiveUntil, validFrom, validUntil);
                if (inclusion == InclusionEnum.IE_ADDITION) {
                    uvbrutto = uvbrutto.add(result);
                    continue;
                }
                if (inclusion != InclusionEnum.IE_SUBTRAKTION) continue;
                uvbrutto = uvbrutto.subtract(result);
            }
        }
        partDsla.setUvbrutto(uvbrutto);
        BigDecimal lohnsteuer = this.getResultFromValuepositions(new String[]{"220100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setLohnsteuer(lohnsteuer);
        BigDecimal soli = this.getResultFromValuepositions(new String[]{"223100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSoli(soli);
        BigDecimal kirchenst = this.getResultFromValuepositions(new String[]{"226100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKirchenst(kirchenst);
        BigDecimal kvbyag = this.getResultFromValuepositions(new String[]{"323510", "323514", "323520", "323512", "323740"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyag(kvbyag);
        BigDecimal kvbyagzusatz = this.getResultFromValuepositions(new String[]{"323515", "323516", "323525", "323741"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyagzusatz(kvbyagzusatz);
        BigDecimal kvbyan = this.getResultFromValuepositions(new String[]{"322510", "322514"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyan(kvbyan);
        BigDecimal kvbyanzusatz = this.getResultFromValuepositions(new String[]{"322516", "322518"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyanzusatz(kvbyanzusatz);
        BigDecimal rvbyag = this.getResultFromValuepositions(new String[]{"329110", "329740"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbyag(rvbyag);
        BigDecimal rvbyan = this.getResultFromValuepositions(new String[]{"328110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbyan(rvbyan);
        BigDecimal avbyag = this.getResultFromValuepositions(new String[]{"335110", "335540"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbyag(avbyag);
        BigDecimal avbyan = this.getResultFromValuepositions(new String[]{"334110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbyan(avbyan);
        BigDecimal pvbyag = this.getResultFromValuepositions(new String[]{"341110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbyag(pvbyag);
        BigDecimal pvbyan = this.getResultFromValuepositions(new String[]{"340110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbyan(pvbyan);
        BigDecimal u1byag = this.getResultFromValuepositions(new String[]{"361100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setU1byag(u1byag);
        BigDecimal u2byag = this.getResultFromValuepositions(new String[]{"362100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setU2byag(u2byag);
        BigDecimal insobyag = this.getResultFromValuepositions(new String[]{"366100"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setInsobyag(insobyag);
        BigDecimal svbruttoega = this.getResultFromValuepositions(new String[]{"130200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSvbruttoega(svbruttoega);
        BigDecimal stbruttoega = this.getResultFromValuepositions(new String[]{"110200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setStbruttoega(stbruttoega);
        BigDecimal lohnsteuerega = this.getResultFromValuepositions(new String[]{"220200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setLohnsteuerega(lohnsteuerega);
        BigDecimal soliega = this.getResultFromValuepositions(new String[]{"223200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setSoliega(soliega);
        BigDecimal kirchenstega = this.getResultFromValuepositions(new String[]{"226200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKirchenstega(kirchenstega);
        BigDecimal kvbruttoega = this.getResultFromValuepositions(new String[]{"321200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbruttoega(kvbruttoega);
        BigDecimal rvbruttoega = this.getResultFromValuepositions(new String[]{"327200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbruttoega(rvbruttoega);
        BigDecimal avbruttoega = this.getResultFromValuepositions(new String[]{"333200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbruttoega(avbruttoega);
        BigDecimal pvbruttoega = this.getResultFromValuepositions(new String[]{"339200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbruttoega(pvbruttoega);
        BigDecimal insobruttoega = this.getResultFromValuepositions(new String[]{"365200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setInsobruttoega(insobruttoega);
        BigDecimal kvbyagega = this.getResultFromValuepositions(new String[]{"323610", "323620", "323630", "323640"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyagega(kvbyagega);
        BigDecimal kvbyagegazusatz = this.getResultFromValuepositions(new String[]{"323615", "323625", "323635", "323645"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyagegazusatz(kvbyagegazusatz);
        BigDecimal kvbyanega = this.getResultFromValuepositions(new String[]{"322610", "322620", "322630"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyanega(kvbyanega);
        BigDecimal kvbyanegazusatz = this.getResultFromValuepositions(new String[]{"322616", "322626", "322636"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setKvbyanegazusatz(kvbyanegazusatz);
        BigDecimal rvbyagega = this.getResultFromValuepositions(new String[]{"329200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbyagega(rvbyagega);
        BigDecimal rvbyanega = this.getResultFromValuepositions(new String[]{"328200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setRvbyanega(rvbyanega);
        BigDecimal avbyagega = this.getResultFromValuepositions(new String[]{"335200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbyagega(avbyagega);
        BigDecimal avbyanega = this.getResultFromValuepositions(new String[]{"334200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setAvbyanega(avbyanega);
        BigDecimal pvbyagega = this.getResultFromValuepositions(new String[]{"341200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbyagega(pvbyagega);
        BigDecimal pvbyanega = this.getResultFromValuepositions(new String[]{"340200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPvbyanega(pvbyanega);
        BigDecimal insobyagega = this.getResultFromValuepositions(new String[]{"366200"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setInsobyagega(insobyagega);
        BigDecimal bbgruanbueb = this.getResultFromValuepositions(new String[]{"327060"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)bbgruanbueb)) {
            bbgruanbueb = this.getResultFromValuepositions(new String[]{"333060"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)bbgruanbueb)) {
            bbgruanbueb = this.getResultFromValuepositions(new String[]{"321060"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        }
        partDsla.setBbgruanbub(bbgruanbueb);
        partDsla.setHinzubtrg(BigDecimal.ZERO);
        partDsla.setUrlrestvj(BigDecimal.ZERO);
        partDsla.setUrlgenom(BigDecimal.ZERO);
        partDsla.setUrlrest(BigDecimal.ZERO);
        partDsla.setUrlunbez(BigDecimal.ZERO);
        BigDecimal netto = this.getResultFromValuepositions(new String[]{"700000"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setNetto(netto);
        BigDecimal zahlbtrg = this.getResultFromValuepositions(new String[]{"890000"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setZahlbtrg(zahlbtrg);
        partDsla.setAnwesend(0);
        partDsla.setFehl(0);
        partDsla.setBezstd(BigDecimal.ZERO);
        partDsla.setAu(0);
        partDsla.setAustd(BigDecimal.ZERO);
        partDsla.setZeitlohnstd(BigDecimal.ZERO);
        partDsla.setUestd(BigDecimal.ZERO);
        partDsla.setDoppelst(BigDecimal.ZERO);
        partDsla.setMmfz(false);
        partDsla.setMmkg(false);
        partDsla.setMmvatz(false);
        partDsla.setMmat(false);
        partDsla.setMmvwg(false);
        partDsla.setMmwo(false);
        partDsla.setMmww(false);
        partDsla.setMmwg(false);
        PartDslaLohnart[] partDslaLohnarten = this.createPartDslaLohnarten(effectiveFrom, effectiveUntil, validFrom, validUntil);
        partDsla.setPartDslaLohnarts(partDslaLohnarten);
        partDsla.setAnla(partDslaLohnarten.length);
        return partDsla;
    }

    private AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAccidentInsuranceFundTP(Date effectiveDate, Date validDate) {
        List apcaiftps = (List)this.mAssignmentPCompanyAccidentInsuranceFundTPMap.getValue(validDate);
        if (apcaiftps == null) {
            return null;
        }
        Employment employment = (Employment)this.mEmployee.getEmploymentHistory().getItemOrNull(effectiveDate, validDate);
        if (employment != null) {
            Plant plant;
            AssignmentPCompanyAccidentInsuranceFundTP result;
            PlantPlace plantPlace = employment.getPlantPlace();
            if (plantPlace != null && (result = this.getAssignmentPCompanyAccidentInsuranceFundTP(plant = plantPlace.getPlant(), (List<AssignmentPCompanyAccidentInsuranceFundTP>)apcaiftps)) != null) {
                return result;
            }
            plant = employment.getPlant();
            if (plant != null && (result = this.getAssignmentPCompanyAccidentInsuranceFundTP(plant, (List<AssignmentPCompanyAccidentInsuranceFundTP>)apcaiftps)) != null) {
                return result;
            }
        }
        return this.getAssignmentPCompanyAccidentInsuranceFundTP(this.mEmployee.getPCompany(), (List<AssignmentPCompanyAccidentInsuranceFundTP>)apcaiftps);
    }

    private AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAccidentInsuranceFundTP(Plant plant, List<AssignmentPCompanyAccidentInsuranceFundTP> apcaiftps) {
        for (AssignmentPCompanyAccidentInsuranceFundTP apcaiftp : apcaiftps) {
            Plant p = apcaiftp.getAssignmentPCompanyAccidentInsuranceFund().getPlant();
            if (p == null || p.getObjectid() != plant.getObjectid()) continue;
            return apcaiftp;
        }
        return null;
    }

    private AssignmentPCompanyAccidentInsuranceFundTP getAssignmentPCompanyAccidentInsuranceFundTP(PCompany pCompany, List<AssignmentPCompanyAccidentInsuranceFundTP> apcaiftps) {
        for (AssignmentPCompanyAccidentInsuranceFundTP apcaiftp : apcaiftps) {
            PCompany pc;
            AssignmentPCompanyAccidentInsuranceFund apcaif = apcaiftp.getAssignmentPCompanyAccidentInsuranceFund();
            if (apcaif.getPlant() != null || (pc = apcaif.getPCompany()) == null || pc.getObjectid() != pCompany.getObjectid()) continue;
            return apcaiftp;
        }
        return null;
    }

    private EubpDbfz createDbfz(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        EubpDbfz dbfz = null;
        PartDbfz[] partDbfzArray = this.getPartDbfz(effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (partDbfzArray != null && partDbfzArray.length > 0) {
            dbfz = new EubpDbfz();
            dbfz.setPartDbfz(partDbfzArray);
            dbfz.setAnfz(partDbfzArray.length);
        }
        return dbfz;
    }

    private EubpDbat createDbat(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        EubpDbat dbat = null;
        dbat = new EubpDbat();
        dbat.setAtzmodell("0");
        BigDecimal asbtrg = this.getResultFromValuepositions(new String[]{"99971"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setAsbtrg(asbtrg);
        BigDecimal bypfleinrv = this.getResultFromValuepositions(new String[]{"130120"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setBypfleinrv(bypfleinrv);
        BigDecimal bypfleinrvbyag = this.getResultFromValuepositions(new String[]{"329310"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setBypfleinrvbyag(bypfleinrvbyag);
        BigDecimal summemeldepflendgelt = this.getResultFromValuepositions(new String[]{"130240"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setEg(summemeldepflendgelt);
        BigDecimal summeangespartwgh = this.getResultFromValuepositions(new String[]{"801000", "806000"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setSum(summeangespartwgh);
        BigDecimal summeost = this.getResultFromValuepositions(new String[]{"801025", "801020", "806020"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setSumost(summeost);
        BigDecimal summewest = this.getResultFromValuepositions(new String[]{"801015", "801010", "806010"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setSumwest(summewest);
        dbat.setKvpflaegsum(BigDecimal.ZERO);
        dbat.setRvpflaegsum(BigDecimal.ZERO);
        dbat.setAvpflaegsum(BigDecimal.ZERO);
        dbat.setPvpflaegsum(BigDecimal.ZERO);
        dbat.setUvpflaegsum(BigDecimal.ZERO);
        BigDecimal unterschiedsbtrg = this.getResultFromValuepositions(new String[]{"327310"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setUnterschiedsbtrg(unterschiedsbtrg);
        BigDecimal regelaeg = this.getResultFromValuepositions(new String[]{"125000"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setRegelaeg(regelaeg);
        BigDecimal kvsvluft = this.getResultFromValuepositions(new String[]{"324110", "324150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setKvsvluft(kvsvluft);
        BigDecimal rvsvluft = this.getResultFromValuepositions(new String[]{"330110", "330150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setRvsvluft(rvsvluft);
        BigDecimal avsvluft = this.getResultFromValuepositions(new String[]{"336110", "336150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setAvsvluft(avsvluft);
        BigDecimal pvsvluft = this.getResultFromValuepositions(new String[]{"342110", "342150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        dbat.setPvsvluft(pvsvluft);
        dbat.setKvabgegrsvluftsum(BigDecimal.ZERO);
        dbat.setRvabgegrsvluftsum(BigDecimal.ZERO);
        dbat.setAvabgegrsvluftsum(BigDecimal.ZERO);
        dbat.setPvabgegrsvluftsum(BigDecimal.ZERO);
        return dbat;
    }

    private EubpDbwo createDbwo(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, int anzahlWertguthaben) throws BusinessDomainException {
        BigDecimal sumgeso = this.getResultFromValuepositions(new String[]{"801025", "801020", "806020"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sumgeso)) {
            EubpDbwo dbwo = new EubpDbwo();
            dbwo.setWgmodell("0");
            BasicRecordWgh dbwoBasic = new BasicRecordWgh();
            dbwoBasic.setSumges(sumgeso);
            dbwoBasic.setKvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setRvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setKnvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setAvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setPvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setUvpflaegsum(BigDecimal.ZERO);
            dbwoBasic.setKvbyansum(BigDecimal.ZERO);
            dbwoBasic.setKvbyanzusatzsum(BigDecimal.ZERO);
            dbwoBasic.setRvbyansum(BigDecimal.ZERO);
            dbwoBasic.setKnvbyansum(BigDecimal.ZERO);
            dbwoBasic.setAvbyansum(BigDecimal.ZERO);
            dbwoBasic.setPvbyansum(BigDecimal.ZERO);
            dbwoBasic.setKvbyagsum(BigDecimal.ZERO);
            dbwoBasic.setKvbyagzusatzsum(BigDecimal.ZERO);
            dbwoBasic.setRvbyagsum(BigDecimal.ZERO);
            dbwoBasic.setKnvbyagsum(BigDecimal.ZERO);
            dbwoBasic.setAvbyagsum(BigDecimal.ZERO);
            dbwoBasic.setPvbyagsum(BigDecimal.ZERO);
            dbwoBasic.setStfrsum(BigDecimal.ZERO);
            BigDecimal kvsvlufto = this.getResultFromValuepositions(new String[]{"324150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setKvsvluft(kvsvlufto);
            BigDecimal rvsvlufto = this.getResultFromValuepositions(new String[]{"330150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setRvsvluft(rvsvlufto);
            dbwoBasic.setKnvsvluft(BigDecimal.ZERO);
            BigDecimal avsvlufto = this.getResultFromValuepositions(new String[]{"336150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setAvsvluft(avsvlufto);
            BigDecimal pvsvlufto = this.getResultFromValuepositions(new String[]{"342150"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setPvsvluft(pvsvlufto);
            dbwoBasic.setKvabgegrsvluftsum(BigDecimal.ZERO);
            dbwoBasic.setRvabgegrsvluftsum(BigDecimal.ZERO);
            dbwoBasic.setKnvabgegrsvluftsum(BigDecimal.ZERO);
            dbwoBasic.setAvabgegrsvluftsum(BigDecimal.ZERO);
            dbwoBasic.setPvabgegrsvluftsum(BigDecimal.ZERO);
            BigDecimal entgeltguthabenaufbauost = this.getResultFromValuepositions(new String[]{"801250"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setEgauf(entgeltguthabenaufbauost);
            BigDecimal entgeltguthabenabbauost = this.getResultFromValuepositions(new String[]{"801330", "801335"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setEgab(entgeltguthabenabbauost);
            dbwoBasic.setKvega(BigDecimal.ZERO);
            dbwoBasic.setRvega(BigDecimal.ZERO);
            dbwoBasic.setKnvega(BigDecimal.ZERO);
            dbwoBasic.setAvega(BigDecimal.ZERO);
            dbwoBasic.setPvega(BigDecimal.ZERO);
            BigDecimal entgeltbeistoerfallost = this.getResultFromValuepositions(new String[]{"130750"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setEg(entgeltbeistoerfallost);
            BigDecimal gsvagsum = this.getResultFromValuepositions(new String[]{"801400"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwoBasic.setGsvagsum(gsvagsum);
            BigDecimal anzvt = BigDecimal.ZERO;
            String rk = this.mEmployee.getAppurtenantLawArea(effectiveFrom, validFrom);
            if (StringMapper.equal((String)rk, (String)"O")) {
                anzvt = BigDecimal.valueOf(anzahlWertguthaben);
            }
            dbwoBasic.setAnzvt(anzvt);
            dbwo.setBasicRecordWgh(dbwoBasic);
            return dbwo;
        }
        return null;
    }

    private EubpDbww createDbww(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, int anzahlWertguthaben) throws BusinessDomainException {
        BigDecimal sumgesw = this.getResultFromValuepositions(new String[]{"801015", "801010", "806010"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sumgesw)) {
            EubpDbww dbww = new EubpDbww();
            BasicRecordWgh dbwwBasic = new BasicRecordWgh();
            dbww.setWgmodell("0");
            dbwwBasic.setSumges(sumgesw);
            dbwwBasic.setKvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setRvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setKnvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setAvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setPvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setUvpflaegsum(BigDecimal.ZERO);
            dbwwBasic.setKvbyansum(BigDecimal.ZERO);
            dbwwBasic.setKvbyanzusatzsum(BigDecimal.ZERO);
            dbwwBasic.setRvbyansum(BigDecimal.ZERO);
            dbwwBasic.setKnvbyansum(BigDecimal.ZERO);
            dbwwBasic.setAvbyansum(BigDecimal.ZERO);
            dbwwBasic.setPvbyansum(BigDecimal.ZERO);
            dbwwBasic.setKvbyagsum(BigDecimal.ZERO);
            dbwwBasic.setKvbyagzusatzsum(BigDecimal.ZERO);
            dbwwBasic.setRvbyagsum(BigDecimal.ZERO);
            dbwwBasic.setKnvbyagsum(BigDecimal.ZERO);
            dbwwBasic.setAvbyagsum(BigDecimal.ZERO);
            dbwwBasic.setPvbyagsum(BigDecimal.ZERO);
            dbwwBasic.setStfrsum(BigDecimal.ZERO);
            BigDecimal kvsvluftw = this.getResultFromValuepositions(new String[]{"324110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setKvsvluft(kvsvluftw);
            BigDecimal rvsvluftw = this.getResultFromValuepositions(new String[]{"330110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setRvsvluft(rvsvluftw);
            dbwwBasic.setKnvsvluft(BigDecimal.ZERO);
            BigDecimal avsvluftw = this.getResultFromValuepositions(new String[]{"336110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setAvsvluft(avsvluftw);
            BigDecimal pvsvluftw = this.getResultFromValuepositions(new String[]{"342110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setPvsvluft(pvsvluftw);
            dbwwBasic.setKvabgegrsvluftsum(BigDecimal.ZERO);
            dbwwBasic.setRvabgegrsvluftsum(BigDecimal.ZERO);
            dbwwBasic.setKnvabgegrsvluftsum(BigDecimal.ZERO);
            dbwwBasic.setAvabgegrsvluftsum(BigDecimal.ZERO);
            dbwwBasic.setPvabgegrsvluftsum(BigDecimal.ZERO);
            BigDecimal entgeltguthabenaufbauwest = this.getResultFromValuepositions(new String[]{"801210"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setEgauf(entgeltguthabenaufbauwest);
            BigDecimal entgeltguthabenabbauwest = this.getResultFromValuepositions(new String[]{"801220", "801225"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setEgab(entgeltguthabenabbauwest);
            dbwwBasic.setKvega(BigDecimal.ZERO);
            dbwwBasic.setRvega(BigDecimal.ZERO);
            dbwwBasic.setKnvega(BigDecimal.ZERO);
            dbwwBasic.setAvega(BigDecimal.ZERO);
            dbwwBasic.setPvega(BigDecimal.ZERO);
            BigDecimal entgeltbeistoerfallwest = this.getResultFromValuepositions(new String[]{"130750"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setEg(entgeltbeistoerfallwest);
            BigDecimal gsvagsumw = this.getResultFromValuepositions(new String[]{"801400"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbwwBasic.setGsvagsum(gsvagsumw);
            BigDecimal anzvt = BigDecimal.ZERO;
            String rk = this.mEmployee.getAppurtenantLawArea(effectiveFrom, validFrom);
            if (StringMapper.equal((String)rk, (String)"W")) {
                anzvt = BigDecimal.valueOf(anzahlWertguthaben);
            }
            dbwwBasic.setAnzvt(anzvt);
            dbww.setBasicRecordWgh(dbwwBasic);
            return dbww;
        }
        return null;
    }

    private PartDbfz[] getPartDbfz(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        EEAbsentTimeTP[] eeAbsentTimes;
        ArrayList<PartDbfz> partDbfzList = new ArrayList<PartDbfz>();
        for (EEAbsentTimeTP eeAbsentTime : eeAbsentTimes = this.fehlzeitenBerechnungsZeitraum(effectiveFrom, effectiveUntil, validFrom, validUntil)) {
            AbsentTime absentTime = eeAbsentTime.getEEAbsentTime().getAbsentTime();
            if (!absentTime.getDEUVRelevant()) continue;
            String fzKennz = absentTime.getDEUVAbsentTimeKey();
            AbsentTimeTP absentTimeTP = absentTime.getAbsentTimeTP(effectiveUntil, validUntil);
            String fzName = absentTimeTP.getShortDescription();
            Calendar validCalendar = Calendar.getInstance();
            validCalendar.setTime(DateHelper.afterOrEqual((Date)eeAbsentTime.getValidFrom(), (Date)validFrom) ? eeAbsentTime.getValidFrom() : validFrom);
            int tagVon = validCalendar.get(5);
            validCalendar.setTime(DateHelper.beforeOrEqual((Date)eeAbsentTime.getValidUntil(), (Date)validUntil) ? eeAbsentTime.getValidUntil() : validUntil);
            int tagBis = validCalendar.get(5);
            partDbfzList.add(new PartDbfz(fzKennz, fzName, tagVon, tagBis));
        }
        PartDbfz[] partDbfzArray = new PartDbfz[partDbfzList.size()];
        partDbfzArray = partDbfzList.toArray(partDbfzArray);
        return partDbfzArray;
    }

    private EubpDbkg createDbkg(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        EubpDbkg dbkg = null;
        BigDecimal ausfstd = this.getResultFromValuepositions(new String[]{"150110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)ausfstd)) {
            ausfstd = this.getFaktor1FromValuepositions(new String[]{"150110"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)ausfstd)) {
            dbkg = new EubpDbkg();
            dbkg.setKennzkug("0");
            dbkg.setSollstd(this.getSollStunden(effectiveFrom, validFrom, validUntil));
            dbkg.setAusfstd(ausfstd);
            BigDecimal fiktivaegkv = this.getResultFromValuepositions(new String[]{"321720"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivaegkv(fiktivaegkv);
            BigDecimal fiktivaegrv = this.getResultFromValuepositions(new String[]{"327720"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivaegrv(fiktivaegrv);
            BigDecimal fiktivaegpv = this.getResultFromValuepositions(new String[]{"339720"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivaegpv(fiktivaegpv);
            dbkg.setFiktivaegrvbeh(BigDecimal.ZERO);
            BigDecimal anrechistaeg = this.getResultFromValuepositions(new String[]{"150510"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setAnrechistaeg(anrechistaeg);
            BigDecimal fiktivkvby = this.getResultFromValuepositions(new String[]{"323720", "770040", "770140"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivkvby(fiktivkvby);
            BigDecimal fiktivrvby = this.getResultFromValuepositions(new String[]{"329720"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivrvby(fiktivrvby);
            BigDecimal fiktivpvby = this.getResultFromValuepositions(new String[]{"341720", "771040", "771140"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivpvby(fiktivpvby);
            BigDecimal fiktivkvbyzusatz = this.getResultFromValuepositions(new String[]{"323721", "770045"}, effectiveFrom, effectiveUntil, validFrom, validUntil);
            dbkg.setFiktivkvbyzusatz(fiktivkvbyzusatz);
        }
        return dbkg;
    }

    private BigDecimal getSollStunden(Date effectiveTimePoint, Date from, Date until) throws BusinessDomainException {
        WorkingTime workingTime = this.mEmployee.getAppurtenantWorkingTime(effectiveTimePoint, from);
        if (workingTime == null) {
            return BigDecimal.ZERO;
        }
        WorkingTimeTP wttp = workingTime.getWorkingTimeTP(effectiveTimePoint, from);
        BigDecimal hourOfAbsence = workingTime.getConcreteTargetHours(from, until, this.mEmployee, effectiveTimePoint, from, wttp.getPaidPublicHoliday());
        return hourOfAbsence;
    }

    private BigDecimal getResultFromValuepositions(String[] valueTypes, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        BigDecimal result = BigDecimal.ZERO;
        for (String valueType : valueTypes) {
            List<ValuepositionContainer> vpList = this.getValuepositionContainerList(valueType, effectiveFrom, effectiveUntil, validFrom, validUntil);
            for (ValuepositionContainer vpContainer : vpList) {
                result = result.add(vpContainer.results);
            }
        }
        return result;
    }

    private BigDecimal getResultFromValuepositions(ValuePosition[] valuePositions, Integer ... valueTypes) {
        BigDecimal result = BigDecimal.ZERO;
        for (Integer valueType : valueTypes) {
            for (ValuePosition valuePosition : valuePositions) {
                if (!valueType.equals(valuePosition.getValueType().getValueTypeKey())) continue;
                result = result.add(valuePosition.getResult());
            }
        }
        return result;
    }

    private BigDecimal getFaktor1FromValuepositions(String[] valueTypeKeys, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        BigDecimal factor1 = BigDecimal.ZERO;
        for (String valueTypeKey : valueTypeKeys) {
            List<ValuepositionContainer> vpList = this.getValuepositionContainerList(valueTypeKey, effectiveFrom, effectiveUntil, validFrom, validUntil);
            for (ValuepositionContainer vpContainer : vpList) {
                factor1 = vpContainer.factor1;
            }
        }
        return factor1;
    }

    private BigDecimal getFaktor2FromValuepositions(String[] valueTypeKeys, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        BigDecimal factor2 = BigDecimal.ZERO;
        for (String valueTypeKey : valueTypeKeys) {
            List<ValuepositionContainer> vpList = this.getValuepositionContainerList(valueTypeKey, effectiveFrom, effectiveUntil, validFrom, validUntil);
            for (ValuepositionContainer vpContainer : vpList) {
                factor2 = vpContainer.factor2;
            }
        }
        return factor2;
    }

    private List<ValuepositionContainer> getValuepositionContainerList(String valueTypeNumber, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        ArrayList<ValuepositionContainer> containerList = new ArrayList<ValuepositionContainer>();
        List<ValuepositionContainer> vpList = this.mValuePositionMap.get(valueTypeNumber);
        if (vpList != null) {
            for (ValuepositionContainer vpContainer : vpList) {
                if (!DateHelper.beforeOrEqual((Date)vpContainer.effectivefrom, (Date)effectiveUntil) || !DateHelper.afterOrEqual((Date)vpContainer.effectiveuntil, (Date)effectiveFrom) || !DateHelper.beforeOrEqual((Date)vpContainer.validfrom, (Date)validUntil) || !DateHelper.afterOrEqual((Date)vpContainer.validuntil, (Date)validFrom)) continue;
                containerList.add(vpContainer);
            }
        }
        return containerList;
    }

    private void createLohnartEigenschaften() throws BusinessDomainException {
        String[] dslaLohnarten;
        for (String dslaLohnart : dslaLohnarten = new String[]{"99971:12000000   +++", "100900:12000000   +++", "100930:12000000   +++", "100940:121        +++", "100950:12000000   +++", "100960:12000000   +++", "100970:12000000   +++", "101750:12000000   +++", "101780:12000025   +++", "101790:12000025   +++", "102590:12000210   +++", "103100:12000000   +++", "103110:12000000   +++", "103120:12000000   +++", "103130:12000000   +++", "103140:12000000   +++", "103150:12000000   +++", "103160:12000000   +++", "103170:12000000   +++", "103180:12000000   +++", "104000:12000000   +++", "104500:12000000   +++", "104700:12000000   +++", "104800:12000000   +++", "105000:12000000   +++", "106010:121        -++", "106020:12000000   +++", "106130:12010110   +--", "110510:12000110   +++", "110610:12000210   +++", "111110:12000000   +++", "111120:12000000   +++", "111210:12000025   +++", "111220:12000025   +++", "111310:12000110   +++", "111320:12000110   +++", "111410:12000000   +++", "111420:12000000   +++", "111510:12011000   +++", "111520:12011000   +++", "128000:12000000   +++", "129100:12000000   +++", "129110:12000000   +++", "129500:12000000   +++", "129600:12011000   ++-", "130510:12011000   +++", "130610:12021000   +++", "145110:12000000   +++", "145120:12000000   +++", "145130:12000000   +++", "145140:12000000   +++", "145160:12000000   +++", "145170:12000000   +++", "145180:12000000   +++", "145190:12000000   +++", "145210:12000000   +++", "145215:12000000   +++", "145220:12000000   +++", "145225:12000000   +++", "145230:12000000   +++", "145235:12000000   +++", "145240:12000000   +++", "145245:12000000   +++", "145260:12000000   +++", "145270:12000000   +++", "145280:12000000   +++", "145290:12000000   +++", "145310:12000000   +++", "145320:12000000   +++", "145330:12000000   +++", "145335:12000000   +++", "145340:12000000   +++", "145345:12000000   +++", "145360:12000000   +++", "145370:12000000   +++", "145380:12000000   +++", "145385:12000000   +++", "145390:12000000   +++", "145395:12000000   +++", "145500:12000000   +++", "150420:12000110   +++", "150510:12000000   +++", "151900:12000000   +++", "230500:12000000   +++", "250510:121        -++", "250610:121        -++", "321700:12010000   +++", "327700:12010000   +++", "333700:12010000   +++", "339700:12010000   +++", "702000:121        -++", "710020:121        -++", "750210:121        +++", "760000:121        +++", "760500:121        +++", "770000:121        -++", "770005:121        -++", "770020:121        +++", "770025:121        +++", "770030:121        +++", "770035:121        +++", "770050:121        +++", "770055:121        +++", "770120:121        +++", "770130:121        +++", "770150:121        +++", "771000:121        -++", "771020:121        +++", "771030:121        +++", "771050:121        +++", "771120:121        +++", "771130:121        +++", "771150:121        +++", "773110:12000000   +++", "773200:12000000   +++", "773514:12000000   +++", "773614:12000000   +++", "774050:121        -++", "775050:121        +++", "795000:121        -++", "795002:121        +++", "860000:121        +++", "861000:121        -++", "861004:121        +++", "861006:121        -++", "862000:121        -++", "862004:121        +++", "862006:121        -++", "863000:121        -++", "863004:121        +++", "863006:121        -++", "864000:121        -++", "870000:121        -++", "871000:121        -++", "880000:121        -++", "881000:121        +++", "882000:121        +++", "886200:121        -++", "889990:121        +++"}) {
            LohnartEigenschaft lohnartEigenschaft;
            LinkedList<LohnartEigenschaft> lohnartEigenschaftList = new LinkedList<LohnartEigenschaft>();
            String[] lohnart = dslaLohnart.split(":");
            ValueType vt = ValueType.getValueType((int)Integer.parseUnsignedInt(lohnart[0]));
            ValueTypeTP vttp = vt.getValueTypeTP(VDate.getDateMax(), VDate.getDateMax());
            FoundationGeneral foundationGeneral = vttp.getValueTypeFoundation().getGeneral();
            String[] signs = lohnart[1].split("");
            if (vt.getValueTypeKey() != 150420) {
                lohnartEigenschaft = new LohnartEigenschaft();
                lohnartEigenschaft.setLa(Integer.toString(vt.getValueTypeKey()));
                lohnartEigenschaft.setName(foundationGeneral.getLongDescription());
                lohnartEigenschaft.setEffectiveFrom(VDate.getDateMin());
                lohnartEigenschaft.setEffectiveUntil(VDate.getDateMax());
                lohnartEigenschaft.setValidFrom(VDate.getDateMin());
                lohnartEigenschaft.setValidUntil(VDate.getDateMax());
                lohnartEigenschaft.setKennzherkunft(signs[0]);
                lohnartEigenschaft.setKennzverw(signs[1]);
                lohnartEigenschaft.setKennzbruttonetto(signs[2]);
                lohnartEigenschaft.setKennzsv(signs[3]);
                lohnartEigenschaft.setKennzuv(signs[4]);
                lohnartEigenschaft.setKennzsteuer(signs[5]);
                lohnartEigenschaft.setKennzstpfl(signs[6]);
                lohnartEigenschaft.setKennzpauschsteuer(signs[7]);
                lohnartEigenschaft.setVzBtrgges(signs[11]);
                lohnartEigenschaft.setVzBtrgst(signs[12]);
                lohnartEigenschaft.setVzBtrgsv(signs[13]);
                lohnartEigenschaft.setIsBruttolohn(true);
                lohnartEigenschaftList.add(lohnartEigenschaft);
            } else {
                lohnartEigenschaft = new LohnartEigenschaft();
                lohnartEigenschaft.setLa(Integer.toString(vt.getValueTypeKey()));
                lohnartEigenschaft.setName(foundationGeneral.getLongDescription());
                lohnartEigenschaft.setEffectiveFrom(VDate.getDateMin());
                lohnartEigenschaft.setEffectiveUntil(VDate.getDateMax());
                lohnartEigenschaft.setValidFrom(VDate.getDateMin());
                lohnartEigenschaft.setValidUntil(new VDate(2020, 1, 29).getDate());
                lohnartEigenschaft.setKennzherkunft(signs[0]);
                lohnartEigenschaft.setKennzverw(signs[1]);
                lohnartEigenschaft.setKennzbruttonetto(signs[2]);
                lohnartEigenschaft.setKennzsv(signs[3]);
                lohnartEigenschaft.setKennzuv(signs[4]);
                lohnartEigenschaft.setKennzsteuer(signs[5]);
                lohnartEigenschaft.setKennzstpfl(signs[6]);
                lohnartEigenschaft.setKennzpauschsteuer(signs[7]);
                lohnartEigenschaft.setVzBtrgges(signs[11]);
                lohnartEigenschaft.setVzBtrgst(signs[12]);
                lohnartEigenschaft.setVzBtrgsv(signs[13]);
                lohnartEigenschaft.setIsBruttolohn(true);
                lohnartEigenschaftList.add(lohnartEigenschaft);
                lohnartEigenschaft = new LohnartEigenschaft();
                lohnartEigenschaft.setLa(Integer.toString(vt.getValueTypeKey()));
                lohnartEigenschaft.setName(foundationGeneral.getLongDescription());
                lohnartEigenschaft.setEffectiveFrom(VDate.getDateMin());
                lohnartEigenschaft.setEffectiveUntil(VDate.getDateMax());
                lohnartEigenschaft.setValidFrom(new VDate(2020, 2, 1).getDate());
                lohnartEigenschaft.setValidUntil(new VDate(2022, 5, 30).getDate());
                lohnartEigenschaft.setKennzherkunft(signs[0]);
                lohnartEigenschaft.setKennzverw(signs[1]);
                lohnartEigenschaft.setKennzbruttonetto(signs[2]);
                lohnartEigenschaft.setKennzsv(signs[3]);
                lohnartEigenschaft.setKennzuv(signs[4]);
                lohnartEigenschaft.setKennzsteuer("0");
                lohnartEigenschaft.setKennzstpfl("0");
                lohnartEigenschaft.setKennzpauschsteuer(signs[7]);
                lohnartEigenschaft.setVzBtrgges(signs[11]);
                lohnartEigenschaft.setVzBtrgst(signs[12]);
                lohnartEigenschaft.setVzBtrgsv(signs[13]);
                lohnartEigenschaft.setIsBruttolohn(true);
                lohnartEigenschaftList.add(lohnartEigenschaft);
                lohnartEigenschaft = new LohnartEigenschaft();
                lohnartEigenschaft.setLa(Integer.toString(vt.getValueTypeKey()));
                lohnartEigenschaft.setName(foundationGeneral.getLongDescription());
                lohnartEigenschaft.setEffectiveFrom(VDate.getDateMin());
                lohnartEigenschaft.setEffectiveUntil(VDate.getDateMax());
                lohnartEigenschaft.setValidFrom(new VDate(2022, 6, 1).getDate());
                lohnartEigenschaft.setValidUntil(VDate.getDateMax());
                lohnartEigenschaft.setKennzherkunft(signs[0]);
                lohnartEigenschaft.setKennzverw(signs[1]);
                lohnartEigenschaft.setKennzbruttonetto(signs[2]);
                lohnartEigenschaft.setKennzsv(signs[3]);
                lohnartEigenschaft.setKennzuv(signs[4]);
                lohnartEigenschaft.setKennzsteuer(signs[5]);
                lohnartEigenschaft.setKennzstpfl(signs[6]);
                lohnartEigenschaft.setKennzpauschsteuer(signs[7]);
                lohnartEigenschaft.setVzBtrgges(signs[11]);
                lohnartEigenschaft.setVzBtrgst(signs[12]);
                lohnartEigenschaft.setVzBtrgsv(signs[13]);
                lohnartEigenschaft.setIsBruttolohn(true);
                lohnartEigenschaftList.add(lohnartEigenschaft);
            }
            this.mLohnartEigenschaftMap.put(lohnart[0], lohnartEigenschaftList);
        }
    }

    private PartDslaLohnart[] createPartDslaLohnarten(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        Object[] swaArray = new String[]{"99971", "100900", "100930", "100940", "100950", "100960", "100970", "101750", "101780", "101790", "102590", "103100", "103110", "103120", "103130", "103140", "103150", "103160", "103170", "103180", "104000", "104500", "104700", "104800", "105000", "106010", "106020", "106130", "111110", "111120", "111210", "111220", "111310", "111320", "111410", "111420", "111510", "111520", "128000", "129100", "129110", "129500", "129600", "145110", "145120", "145130", "145140", "145160", "145170", "145180", "145190", "145210", "145215", "145220", "145225", "145230", "145235", "145240", "145245", "145260", "145270", "145280", "145290", "145310", "145320", "145330", "145335", "145340", "145345", "145360", "145370", "145380", "145385", "145390", "145395", "145500", "150420", "150510", "151900", "230500", "250510", "250610", "321700", "327700", "333700", "339700", "702000", "710020", "750210", "760000", "760500", "770000", "770005", "770020", "770025", "770030", "770035", "770050", "770055", "770120", "770130", "770150", "771000", "771020", "771030", "771050", "771120", "771130", "771150", "773110", "773200", "773514", "773614", "774050", "775050", "795000", "795002", "860000", "861000", "861004", "861006", "862000", "862004", "862006", "863000", "863004", "863006", "864000", "870000", "871000", "880000", "881000", "882000", "886200", "889990"};
        String[] lohnartenBAV = new String[]{"110510", "110610", "130510", "130610"};
        String[] dslaLohnarten = (String[])ArrayUtils.addAll((Object[])this.mAwaArray, (Object[])swaArray);
        ArrayList<PartDslaLohnart> partList = new ArrayList<PartDslaLohnart>();
        for (String dslaLohnart : dslaLohnarten) {
            PartDslaLohnart partDslaLohnart;
            List<ValuepositionContainer> containerList = this.getValuepositionContainerList(dslaLohnart, effectiveFrom, effectiveUntil, validFrom, validUntil);
            if (containerList == null || containerList.isEmpty()) continue;
            BigDecimal result = BigDecimal.ZERO;
            LinkedList<String> genesisparentList = new LinkedList<String>();
            for (ValuepositionContainer container : containerList) {
                result = result.add(container.results);
                if (!StringMapper.equal((String)dslaLohnart, (String)"145215") && !StringMapper.equal((String)dslaLohnart, (String)"145235") && !StringMapper.equal((String)dslaLohnart, (String)"145240")) continue;
                genesisparentList.add(container.oidgenesisparent);
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)result) || (partDslaLohnart = this.createPartDsla(dslaLohnart, result, effectiveFrom, effectiveUntil, validFrom, validUntil)) == null) continue;
            partList.add(partDslaLohnart);
            for (String oidGenesisparent : genesisparentList) {
                for (String lohnartBAV : lohnartenBAV) {
                    List<ValuepositionContainer> containerListBAV = this.getValuepositionContainerList(lohnartBAV, effectiveFrom, effectiveUntil, validFrom, validUntil);
                    if (containerListBAV == null || containerListBAV.isEmpty()) continue;
                    for (ValuepositionContainer containerBAV : containerListBAV) {
                        if (!StringMapper.equal((String)oidGenesisparent, (String)containerBAV.oidgenesisparent)) continue;
                        PartDslaLohnart partDslaLohnartBAV = this.createPartDsla(lohnartBAV, containerBAV.results, effectiveFrom, effectiveUntil, validFrom, validUntil);
                        partList.add(partDslaLohnartBAV);
                    }
                }
            }
        }
        PartDslaLohnart[] partDslaLohnarten = partList.toArray(new PartDslaLohnart[partList.size()]);
        return partDslaLohnarten;
    }

    private PartDslaLohnart createPartDsla(String lohnart, BigDecimal result, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)Integer.parseUnsignedInt(lohnart));
        ValueTypeTP vttp = vt.getValueTypeTP(effectiveUntil, validUntil);
        FoundationGeneral foundationGeneral = vttp.getValueTypeFoundation().getGeneral();
        LohnartEigenschaft lohnartEigenschaft = this.getLohnartEigenschaft(lohnart, effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (lohnartEigenschaft != null && lohnartEigenschaft.useForANLA()) {
            PartDslaLohnart partDslaLohnart = new PartDslaLohnart();
            partDslaLohnart.setLa(Integer.toString(vt.getValueTypeKey()));
            partDslaLohnart.setName(foundationGeneral.getLongDescription());
            partDslaLohnart.setKennzherkunft(lohnartEigenschaft.getKennzherkunft());
            partDslaLohnart.setKennzverw(lohnartEigenschaft.getKennzverw());
            partDslaLohnart.setKennzbruttonetto(lohnartEigenschaft.getKennzbruttonetto());
            partDslaLohnart.setKennzsv(lohnartEigenschaft.getKennzsv());
            partDslaLohnart.setKennzuv(lohnartEigenschaft.getKennzuv());
            partDslaLohnart.setKennzsteuer(lohnartEigenschaft.getKennzsteuer());
            partDslaLohnart.setKennzstpfl(lohnartEigenschaft.getKennzstpfl());
            partDslaLohnart.setKennzpauschsteuer(lohnartEigenschaft.getKennzpauschsteuer());
            partDslaLohnart.setBezmenge(this.getFaktor1FromValuepositions(new String[]{lohnart}, effectiveFrom, effectiveUntil, validFrom, validUntil));
            partDslaLohnart.setFaktor(this.getFaktor2FromValuepositions(new String[]{lohnart}, effectiveFrom, effectiveUntil, validFrom, validUntil));
            partDslaLohnart.setZuschlag(BigDecimal.ZERO);
            BigDecimal btrgges = result;
            if (lohnartEigenschaft.getVzBtrgges().equals("-")) {
                btrgges = btrgges.multiply(new BigDecimal(-1));
            }
            BigDecimal btrgst = result;
            if (lohnartEigenschaft.getVzBtrgst().equals("-")) {
                btrgst = btrgst.multiply(new BigDecimal(-1));
            }
            BigDecimal btrgsv = result;
            if (lohnartEigenschaft.getVzBtrgsv().equals("-")) {
                btrgsv = btrgsv.multiply(new BigDecimal(-1));
            }
            partDslaLohnart.setLabtrgges(btrgges);
            partDslaLohnart.setLabtrgst(!StringMapper.equal((String)lohnartEigenschaft.getKennzsteuer(), (String)" ") && Integer.parseInt(lohnartEigenschaft.getKennzsteuer()) > 0 ? btrgst : BigDecimal.ZERO);
            partDslaLohnart.setLabtrgsv(!StringMapper.equal((String)lohnartEigenschaft.getKennzsv(), (String)" ") && Integer.parseInt(lohnartEigenschaft.getKennzsv()) > 0 ? btrgsv : BigDecimal.ZERO);
            return partDslaLohnart;
        }
        return null;
    }

    private LohnartEigenschaft getLohnartEigenschaft(String lohnart, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        int lohnartINT;
        List<LohnartEigenschaft> lohnartEigenschaftList = this.mLohnartEigenschaftMap.get(lohnart);
        if (lohnartEigenschaftList != null && !lohnartEigenschaftList.isEmpty()) {
            for (LohnartEigenschaft lohnartEigenschaft : lohnartEigenschaftList) {
                if (!DateHelper.beforeOrEqual((Date)lohnartEigenschaft.getEffectiveFrom(), (Date)effectiveUntil) || !DateHelper.afterOrEqual((Date)lohnartEigenschaft.getEffectiveUntil(), (Date)effectiveFrom) || !DateHelper.beforeOrEqual((Date)lohnartEigenschaft.getValidFrom(), (Date)validUntil) || !DateHelper.afterOrEqual((Date)lohnartEigenschaft.getValidUntil(), (Date)validFrom)) continue;
                return lohnartEigenschaft;
            }
        }
        if ((lohnartINT = Integer.parseInt(lohnart)) <= 99999) {
            LohnartEigenschaft lohnartEigenschaft;
            lohnartEigenschaft = this.getLohnartEigenschaftAWA(lohnartINT, effectiveFrom, validFrom);
            lohnartEigenschaftList = this.mLohnartEigenschaftMap.get(lohnart);
            if (lohnartEigenschaftList == null) {
                lohnartEigenschaftList = new LinkedList<LohnartEigenschaft>();
                lohnartEigenschaftList.add(lohnartEigenschaft);
                this.mLohnartEigenschaftMap.put(lohnart, lohnartEigenschaftList);
            } else {
                lohnartEigenschaftList.add(lohnartEigenschaft);
                this.mLohnartEigenschaftMap.put(lohnart, lohnartEigenschaftList);
            }
            return lohnartEigenschaft;
        }
        return null;
    }

    private LohnartEigenschaft getLohnartEigenschaftAWA(int lohnart, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        boolean isVersion08OrHigher;
        ValueType vt = ValueType.getValueType((int)lohnart);
        ValueTypeTP vttp = vt.getValueTypeTP(effectiveFrom, validFrom);
        ConsequenceOfValueType[] consArray = vttp.getConsequenceForOrientation();
        boolean hatBruttolohn = false;
        String kennzSV = "0";
        String kennzUV = "0";
        String kennzSteuer = "0";
        String kennzStPfl = "0";
        String kennzPauschsteuer = "0";
        block12: for (ConsequenceOfValueType cons : consArray) {
            switch (cons.getConsequenceOfValueType().getValueTypeKey()) {
                case 100200: {
                    hatBruttolohn = true;
                    continue block12;
                }
                case 110510: 
                case 110630: {
                    kennzSteuer = "1";
                    kennzStPfl = "1";
                    continue block12;
                }
                case 110610: {
                    kennzSteuer = "2";
                    kennzStPfl = "1";
                    continue block12;
                }
                case 110620: {
                    kennzSteuer = "5";
                    kennzStPfl = "1";
                    continue block12;
                }
                case 101610: {
                    kennzPauschsteuer = "1";
                }
                case 101510: 
                case 101550: 
                case 101560: 
                case 101570: 
                case 101580: 
                case 101590: 
                case 101600: 
                case 101750: 
                case 101760: 
                case 101770: 
                case 101780: 
                case 101790: {
                    kennzStPfl = "2";
                    continue block12;
                }
                case 129510: 
                case 129511: 
                case 129512: 
                case 129513: 
                case 130510: 
                case 130515: 
                case 130520: 
                case 130560: {
                    kennzUV = "1";
                }
                case 130530: {
                    kennzSV = "1";
                    continue block12;
                }
                case 130610: 
                case 130620: 
                case 130650: {
                    kennzUV = "1";
                }
                case 130635: 
                case 130750: {
                    kennzSV = "2";
                }
            }
        }
        boolean bl = isVersion08OrHigher = this.mEubpCreator.getEubpVersion().getVersionDSLA().compareTo("08") >= 0;
        if (isVersion08OrHigher && kennzSteuer.equals("0")) {
            kennzStPfl = "";
        }
        LohnartEigenschaft lohnartEigenschaft = new LohnartEigenschaft();
        lohnartEigenschaft.setLa(Integer.toString(vt.getValueTypeKey()));
        lohnartEigenschaft.setName(vttp.getValueTypeFoundation().getGeneral().getLongDescription());
        lohnartEigenschaft.setEffectiveFrom(vttp.getEffectiveFrom());
        lohnartEigenschaft.setEffectiveUntil(vttp.getEffectiveUntil());
        lohnartEigenschaft.setValidFrom(vttp.getValidFrom());
        lohnartEigenschaft.setValidUntil(vttp.getValidUntil());
        lohnartEigenschaft.setKennzherkunft("2");
        lohnartEigenschaft.setKennzverw("1");
        lohnartEigenschaft.setKennzbruttonetto("0");
        lohnartEigenschaft.setKennzsv(kennzSV);
        lohnartEigenschaft.setKennzuv(kennzUV);
        lohnartEigenschaft.setKennzsteuer(kennzSteuer);
        lohnartEigenschaft.setKennzstpfl(kennzStPfl);
        lohnartEigenschaft.setKennzpauschsteuer(kennzPauschsteuer);
        lohnartEigenschaft.setVzBtrgges("+");
        lohnartEigenschaft.setVzBtrgst("+");
        lohnartEigenschaft.setVzBtrgsv("+");
        lohnartEigenschaft.setIsBruttolohn(hatBruttolohn);
        return lohnartEigenschaft;
    }

    private EEAbsentTimeTP[] fehlzeitenBerechnungsZeitraum(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) {
        EEAbsentTimeTP[] tpArray = this.mEmployee.getEEAbsentTimesTP(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}), true);
        if (tpArray.length > 0) {
            ArrayList<EEAbsentTimeTP> list = new ArrayList<EEAbsentTimeTP>();
            for (EEAbsentTimeTP absentTimeTP : tpArray) {
                if (absentTimeTP.getEEAbsentTime().getIsDeleted()) continue;
                list.add(absentTimeTP);
            }
            EEAbsentTimeTP[] array = new EEAbsentTimeTP[list.size()];
            return list.toArray(array);
        }
        return new EEAbsentTimeTP[0];
    }

    private Date getRueckrechnungsdatum(Date abrechnungsMonat) {
        Date rueckrechnungsdatum = abrechnungsMonat;
        ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)UtilitiesManager.getBean((String)"calculationbasicDao", ICalculationbasicDao.class);
        PersistencyDataSet calculationbasicDatas = daoCalculationbasic.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)abrechnungsMonat))), Restrictions.lt((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)abrechnungsMonat)))}));
        while (calculationbasicDatas.hasNext()) {
            CalculationbasicContainer container = (CalculationbasicContainer)calculationbasicDatas.getNext();
            if (!DateHelper.before((Date)container.validfrom, (Date)rueckrechnungsdatum)) continue;
            rueckrechnungsdatum = container.validfrom;
        }
        return rueckrechnungsdatum;
    }

    private Insurance getInsurance(Date effectiveDate, Date validDate) {
        return (Insurance)this.mEmployee.getInsuranceHistory().getItemOrNull(effectiveDate, validDate);
    }

    private void getValuePosition(String[] additionalValueTypeKeys) {
        IValuepositionDao daoValueposition = (IValuepositionDao)UtilitiesManager.getBean((String)"valuepositionDao", IValuepositionDao.class);
        String[] staticValueTypeKeys = new String[]{"99971", "100100", "110100", "110200", "110590", "130110", "130200", "130590", "130630", "130640", "220100", "223100", "220200", "223200", "226100", "226200", "321060", "321110", "321200", "321740", "327110", "322510", "322514", "322516", "322518", "322610", "322616", "322620", "322626", "322630", "322636", "323510", "323512", "323514", "323515", "323516", "323520", "323525", "323610", "323615", "323620", "323625", "323630", "323635", "323640", "323645", "323740", "323741", "327060", "327200", "327740", "328110", "328200", "329110", "329200", "329740", "333060", "333110", "333200", "333540", "334110", "334200", "335110", "335200", "335540", "339110", "339200", "339740", "340110", "340200", "341110", "341200", "360050", "365100", "361100", "362100", "366100", "365200", "366200", "700000", "710280", "890000", "100900", "100930", "100940", "100950", "100960", "100970", "101750", "101780", "101790", "102590", "103100", "103110", "103120", "103130", "103140", "103150", "103160", "103170", "103180", "104000", "104500", "104700", "104800", "105000", "106010", "106020", "106130", "111110", "111120", "111210", "111220", "111310", "111320", "111410", "111420", "111510", "111520", "128000", "129100", "129110", "129500", "129600", "145110", "145120", "145130", "145140", "145160", "145170", "145180", "145190", "145210", "145215", "145220", "145225", "145230", "145235", "145240", "145245", "145260", "145270", "145280", "145290", "145310", "145320", "145330", "145335", "145340", "145345", "145360", "145370", "145380", "145385", "145390", "145395", "145500", "150420", "150510", "151900", "230500", "250510", "250610", "321700", "327700", "333700", "339700", "702000", "710020", "750210", "760000", "760500", "770000", "770005", "770020", "770025", "770030", "770035", "770050", "770055", "770120", "770130", "770150", "771000", "771020", "771030", "771050", "771120", "771130", "771150", "773110", "773200", "773514", "773614", "774050", "775050", "795000", "795002", "860000", "861000", "861004", "861006", "862000", "862004", "862006", "863000", "863004", "863006", "864000", "870000", "871000", "880000", "881000", "882000", "886200", "889990", "150110", "321720", "323720", "323721", "327720", "329720", "339720", "341720", "770040", "770045", "770140", "771040", "771140", "125000", "130120", "130240", "324110", "324150", "327310", "329310", "330110", "330150", "336110", "336150", "342110", "342150", "801000", "801010", "801015", "801020", "801025", "806000", "806010", "806020", "130750", "801210", "801220", "801225", "801250", "801335", "801400", "110510", "110610", "130510", "130610"};
        String[] valueTypeKeys = new String[staticValueTypeKeys.length + additionalValueTypeKeys.length];
        System.arraycopy(staticValueTypeKeys, 0, valueTypeKeys, 0, staticValueTypeKeys.length);
        System.arraycopy(additionalValueTypeKeys, 0, valueTypeKeys, staticValueTypeKeys.length, additionalValueTypeKeys.length);
        PersistencyDataSet valuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), this.mPeriods.toDisjunction("effectivefrom", "effectiveuntil"), this.mPeriods.toDisjunction("validfrom", "validuntil"), Restrictions.in((String)"valuetypenumber", (String[])valueTypeKeys)}));
        while (valuePositionDatas.hasNext()) {
            ValuepositionContainer vp = (ValuepositionContainer)valuePositionDatas.getNext();
            List<ValuepositionContainer> vpList = this.mValuePositionMap.get(Integer.toString(vp.valuetypenumber));
            if (vpList == null) {
                vpList = new ArrayList<ValuepositionContainer>();
                vpList.add(vp);
                this.mValuePositionMap.put(Integer.toString(vp.valuetypenumber), vpList);
                continue;
            }
            boolean isContainerVorhanden = false;
            for (ValuepositionContainer tempContainer : vpList) {
                if (!tempContainer.getObjectid().equals(vp.getObjectid())) continue;
                isContainerVorhanden = true;
            }
            if (isContainerVorhanden) continue;
            vpList.add(vp);
        }
        valuePositionDatas = daoValueposition.getDataSet(new Order[]{Order.asc((String)"valuetypenumber")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployee.getObjectid()), this.mPeriods.toDisjunction("effectivefrom", "effectiveuntil"), this.mPeriods.toDisjunction("validfrom", "validuntil"), Restrictions.le((String)"valuetypenumber", (String)"99900")}));
        ArrayList<String> awaList = new ArrayList<String>();
        while (valuePositionDatas.hasNext()) {
            List<ValuepositionContainer> vpList;
            ValuepositionContainer vp = (ValuepositionContainer)valuePositionDatas.getNext();
            String valuetypeNumber = Integer.toString(vp.valuetypenumber);
            if (!awaList.contains(valuetypeNumber)) {
                awaList.add(valuetypeNumber);
            }
            if ((vpList = this.mValuePositionMap.get(valuetypeNumber)) == null) {
                vpList = new ArrayList<ValuepositionContainer>();
                vpList.add(vp);
                this.mValuePositionMap.put(Integer.toString(vp.valuetypenumber), vpList);
                continue;
            }
            boolean isContainerVorhanden = false;
            for (ValuepositionContainer tempContainer : vpList) {
                if (!tempContainer.getObjectid().equals(vp.getObjectid())) continue;
                isContainerVorhanden = true;
            }
            if (isContainerVorhanden) continue;
            vpList.add(vp);
        }
        this.mAwaArray = new String[awaList.size()];
        this.mAwaArray = awaList.toArray(this.mAwaArray);
    }

    private class LohnartEigenschaft {
        private String mLa;
        private String mName;
        private Date mEffectiveFrom;
        private Date mEffectiveUntil;
        private Date mValidFrom;
        private Date mValidUntil;
        private String mKennzherkunft;
        private String mKennzverw;
        private String mKennzbruttonetto;
        private String mKennzsv;
        private String mKennzuv;
        private String mKennzsteuer;
        private String mKennzstpfl;
        private String mKennzpauschsteuer;
        private String mVzBtrgges;
        private String mVzBtrgst;
        private String mVzBtrgsv;
        private boolean mIsBruttolohn;

        public String getLa() {
            return this.mLa;
        }

        public void setLa(String la) {
            this.mLa = la;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public Date getEffectiveFrom() {
            return this.mEffectiveFrom;
        }

        public void setEffectiveFrom(Date effectiveFrom) {
            this.mEffectiveFrom = effectiveFrom;
        }

        public Date getEffectiveUntil() {
            return this.mEffectiveUntil;
        }

        public void setEffectiveUntil(Date effectiveUntil) {
            this.mEffectiveUntil = effectiveUntil;
        }

        public Date getValidFrom() {
            return this.mValidFrom;
        }

        public void setValidFrom(Date validFrom) {
            this.mValidFrom = validFrom;
        }

        public Date getValidUntil() {
            return this.mValidUntil;
        }

        public void setValidUntil(Date validUntil) {
            this.mValidUntil = validUntil;
        }

        public String getKennzherkunft() {
            return this.mKennzherkunft;
        }

        public void setKennzherkunft(String kennzherkunft) {
            this.mKennzherkunft = kennzherkunft;
        }

        public String getKennzverw() {
            return this.mKennzverw;
        }

        public void setKennzverw(String kennzverw) {
            this.mKennzverw = kennzverw;
        }

        public String getKennzbruttonetto() {
            return this.mKennzbruttonetto;
        }

        public void setKennzbruttonetto(String kennzbruttonetto) {
            this.mKennzbruttonetto = kennzbruttonetto;
        }

        public String getKennzsv() {
            return this.mKennzsv;
        }

        public void setKennzsv(String kennzsv) {
            this.mKennzsv = kennzsv;
        }

        public String getKennzuv() {
            return this.mKennzuv;
        }

        public void setKennzuv(String kennzuv) {
            this.mKennzuv = kennzuv;
        }

        public String getKennzsteuer() {
            return this.mKennzsteuer;
        }

        public void setKennzsteuer(String kennzsteuer) {
            this.mKennzsteuer = kennzsteuer;
        }

        public String getKennzstpfl() {
            return this.mKennzstpfl;
        }

        public void setKennzstpfl(String kennzstpfl) {
            this.mKennzstpfl = kennzstpfl;
        }

        public String getKennzpauschsteuer() {
            return this.mKennzpauschsteuer;
        }

        public void setKennzpauschsteuer(String kennzpauschsteuer) {
            this.mKennzpauschsteuer = kennzpauschsteuer;
        }

        public String getVzBtrgges() {
            return this.mVzBtrgges;
        }

        public void setVzBtrgges(String vzBtrgges) {
            this.mVzBtrgges = vzBtrgges;
        }

        public String getVzBtrgst() {
            return this.mVzBtrgst;
        }

        public void setVzBtrgst(String vzBtrgst) {
            this.mVzBtrgst = vzBtrgst;
        }

        public String getVzBtrgsv() {
            return this.mVzBtrgsv;
        }

        public void setVzBtrgsv(String vzBtrgsv) {
            this.mVzBtrgsv = vzBtrgsv;
        }

        public boolean isBruttolohn() {
            return this.mIsBruttolohn;
        }

        public void setIsBruttolohn(boolean isBruttolohn) {
            this.mIsBruttolohn = isBruttolohn;
        }

        public boolean useForANLA() {
            return this.mIsBruttolohn || !this.mKennzsv.equals("0") || !this.mKennzsteuer.equals("0") || !this.mKennzpauschsteuer.equals("0");
        }
    }
}

