/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pueg.puegaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.pueg.mapper.PuegExceptionMapper;
import com.varial.personnel.domain.pueg.puegaccount.IPuegAccountPersistencyManager;
import com.varial.personnel.domain.pueg.puegaccount.PuegAdviceStateEnum;
import com.varial.personnel.domain.pueg.puegaccount.PuegReasonOfDeliveryEnum;
import com.varial.personnel.domain.pueg.pueganfrage.IPuegAnfragePersistencyManager;
import com.varial.personnel.domain.pueg.pueganfrage.PuegAnfrage;
import com.varial.personnel.domain.pueg.puegkuendigung.IPuegKuendigungPersistencyManager;
import com.varial.personnel.domain.pueg.puegkuendigung.PuegKuendigung;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class PuegAccount
extends PersistentObject
implements IEmployeeReferenced {
    private final IPuegAccountPersistencyManager pm = (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    public static final String N = "N";
    public static final String J = "J";
    public static final String X = "X";
    private static final int PRIORITY = 1;
    private Employee mEmployee;
    private DEUVSender mDEUVSender;
    private DEUVRecipient mDEUVRecipient;
    private Date mCreatedOn;
    private PuegReasonOfDeliveryEnum mReasonOfDelivery;
    private PuegAdviceStateEnum mAdviceState;
    private int mCurrentFileNumber;
    private String mErrorMessage;
    private PuegAnfrage mPuegAnfrage;
    private PuegKuendigung mPuegKuendigung;
    private Date mValidDate;
    private boolean mAbo;

    public PuegAccount(int priority) {
        super(priority);
    }

    public static PuegAccount getPuegAccount(String objectID) {
        return new PuegAccount(objectID);
    }

    public PuegAccount(Employee employee) {
        super(1);
        this.mEmployee = employee;
    }

    public PuegAccount(Employee employee, boolean readOnly) {
        super(1, readOnly);
        this.mEmployee = employee;
    }

    public PuegAccount(String objectID) {
        super(1, objectID);
    }

    public PuegAccount(String objectID, int version) {
        super(1, objectID, version);
    }

    public PuegAccount(boolean readOnly) {
        super(1, readOnly);
    }

    protected void load() {
        this.pm.load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        this.pm.save(this);
    }

    protected void deleteImpl() {
        this.pm.delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        if (this.isTransmitted()) {
            throw new IllegalStateException("never destroy transmitted accounts!");
        }
        this.partialDestroyImpl();
    }

    private void partialDestroyImpl() throws BusinessDomainException {
        if (this.mPuegAnfrage != null) {
            this.mPuegAnfrage.makeSaveable();
            this.mPuegAnfrage.destroy();
        }
        if (this.mPuegKuendigung != null) {
            this.mPuegKuendigung.makeSaveable();
            this.mPuegKuendigung.destroy();
        }
    }

    private boolean isTransmitted() {
        return PuegAdviceStateEnum.UEBERMITTELT.equals((Object)this.mAdviceState) || PuegAdviceStateEnum.VERARBEITET.equals((Object)this.mAdviceState) || PuegAdviceStateEnum.ABGELEHNT.equals((Object)this.mAdviceState) || PuegAdviceStateEnum.FEHLER_DATEI.equals((Object)this.mAdviceState);
    }

    public void makeReadOnly() {
        super.makeReadOnly();
        if (this.mPuegAnfrage != null) {
            this.mPuegAnfrage.makeReadOnly();
        }
        if (this.mPuegKuendigung != null) {
            this.mPuegKuendigung.makeReadOnly();
        }
    }

    public void makeSaveable() {
        super.makeSaveable();
        if (this.mPuegAnfrage != null) {
            this.mPuegAnfrage.makeSaveable();
        }
        if (this.mPuegKuendigung != null) {
            this.mPuegKuendigung.makeSaveable();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public DEUVSender getDEUVSender() {
        this.requireLoaded();
        return this.mDEUVSender;
    }

    public void setDEUVSender(DEUVSender dEUVSender) {
        this.mDEUVSender = dEUVSender;
    }

    public DEUVRecipient getDEUVRecipient() {
        this.requireLoaded();
        return this.mDEUVRecipient;
    }

    public void setDEUVRecipient(DEUVRecipient deuvRecipient) {
        this.mDEUVRecipient = deuvRecipient;
    }

    public Date getCreatedOn() {
        this.requireLoaded();
        return this.mCreatedOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.mCreatedOn = createdOn;
    }

    public PuegReasonOfDeliveryEnum getReasonOfDelivery() {
        this.requireLoaded();
        return this.mReasonOfDelivery;
    }

    public void setReasonOfDelivery(PuegReasonOfDeliveryEnum reasonOfDelivery) {
        this.mReasonOfDelivery = reasonOfDelivery;
    }

    public PuegAdviceStateEnum getAdviceState() {
        this.requireLoaded();
        return this.mAdviceState;
    }

    public void setAdviceState(PuegAdviceStateEnum adviceState) {
        this.mAdviceState = adviceState;
    }

    public int getCurrentFileNumber() {
        this.requireLoaded();
        return this.mCurrentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.mCurrentFileNumber = currentFileNumber;
    }

    public String getErrorMessage() {
        this.requireLoaded();
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public Date getValidDate() {
        return this.mValidDate;
    }

    public void setValidDate(Date mValidDate) {
        this.mValidDate = mValidDate;
    }

    public boolean getAbo() {
        return this.mAbo;
    }

    public void setAbo(boolean mAbo) {
        this.mAbo = mAbo;
    }

    public PuegAnfrage getPuegAnfrage() {
        if (this.mPuegAnfrage == null) {
            Criterion filter = Restrictions.eq((String)"oidPuegAccount", (String)this.getObjectid());
            PuegAnfrage[] rs = PuegAccount.getIPuegAnfragePM().query(null, filter, true);
            if (rs.length > 0) {
                this.mPuegAnfrage = rs[0];
            }
        }
        return this.mPuegAnfrage;
    }

    public PuegKuendigung getPuegKuendigung() {
        if (this.mPuegKuendigung == null) {
            Criterion filter = Restrictions.eq((String)"oidPuegAccount", (String)this.getObjectid());
            PuegKuendigung[] rs = PuegAccount.getIPuegKuendigungPM().query(null, filter, true);
            if (rs.length > 0) {
                this.mPuegKuendigung = rs[0];
            }
        }
        return this.mPuegKuendigung;
    }

    public static PuegAccount[] getPuegAccounts(String oidPCompany, String oidEmployee, Date validFrom, int reasonOfDelivery, boolean abo, String[] states) {
        Order[] sort = null;
        sort = new Order[]{Order.desc((String)"ADDITIONALSTRING"), Order.desc((String)"CREATEDON")};
        Conjunction filter = Restrictions.conjunction();
        Criterion fes = Restrictions.ge((String)"ADDITIONALSTRING", (String)DateMapper.toString((Date)validFrom));
        filter.add(fes);
        if (reasonOfDelivery != 0) {
            fes = Restrictions.eq((String)"ADDITIONALSTRING1", (String)BooleanMapper.toString((boolean)abo));
            filter.add(fes);
            fes = Restrictions.eq((String)"reasonofdelivery", (String)("" + reasonOfDelivery));
            filter.add(fes);
        }
        if (states != null) {
            fes = Restrictions.in((String)"advicestate", (String[])states);
            filter.add(fes);
        }
        ArrayList<PuegAccount> accounts = new ArrayList<PuegAccount>();
        for (Criterion empFilter : PuegAccount.getEmployeeFilter(oidPCompany, null, oidEmployee)) {
            PuegAccount[] rows = PuegAccount.getIPuegAccountPM().queryAll(sort, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            accounts.addAll(Arrays.asList(rows));
        }
        return accounts.toArray(new PuegAccount[accounts.size()]);
    }

    public static PuegAccount[] getPuegAccount(String oidPCompany, String oidPlant, String oidEmployee, Date fromDate, Date untilDate, int reasonOfDelivery, int adviceState) {
        Criterion fes;
        Order[] sort = new Order[]{Order.asc((String)"personnelnumber"), Order.asc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        if (fromDate != null && untilDate != null) {
            fes = Restrictions.le((String)"createdon", (String)DateMapper.toString((Date)DateHelper.tomorrow((Date)untilDate)));
            filter.add(fes);
            fes = Restrictions.ge((String)"createdon", (String)DateMapper.toString((Date)fromDate));
            filter.add(fes);
        } else if (fromDate != null && untilDate == null) {
            fes = Restrictions.ge((String)"createdon", (String)DateMapper.toString((Date)fromDate));
            filter.add(fes);
        } else if (fromDate == null && untilDate != null) {
            fes = Restrictions.le((String)"createdon", (String)DateMapper.toString((Date)DateHelper.tomorrow((Date)untilDate)));
            filter.add(fes);
        }
        if (reasonOfDelivery != 0) {
            fes = Restrictions.eq((String)"reasonofdelivery", (String)("" + reasonOfDelivery));
            filter.add(fes);
        }
        if (adviceState >= 0) {
            fes = Restrictions.eq((String)"advicestate", (String)("" + adviceState));
            filter.add(fes);
        }
        ArrayList<PuegAccount> accounts = new ArrayList<PuegAccount>();
        for (Criterion empFilter : PuegAccount.getEmployeeFilter(oidPCompany, null, oidEmployee)) {
            PuegAccount[] rows = PuegAccount.getIPuegAccountPM().queryAll(sort, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            accounts.addAll(Arrays.asList(rows));
        }
        return accounts.toArray(new PuegAccount[accounts.size()]);
    }

    public static List<Criterion> getEmployeeFilter(String oidPCompany, String oidPlant, String oidEmployee) {
        if (!StringMapper.isNullString((String)oidEmployee)) {
            ArrayList<Criterion> filter = new ArrayList<Criterion>();
            filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
            return filter;
        }
        String[] oidEmployees = null;
        if (!StringMapper.isNullString((String)oidPlant)) {
            ReportFirstFilterStruct filter = new ReportFirstFilterStruct();
            filter.oidPlant = oidPlant;
            filter.oidPCompany = oidPCompany;
            oidEmployees = PuegAccount.getIEmployeePM().getOidEmployees(oidPCompany, filter);
            return PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
        }
        oidEmployees = PuegAccount.getIEmployeePM().getOidEmployees(oidPCompany);
        return PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
    }

    public void deleteAccount() throws BusinessDomainException {
        if (!this.getAdviceState().equals((Object)PuegAdviceStateEnum.AUFGEBAUT) && !this.getAdviceState().equals((Object)PuegAdviceStateEnum.BEREIT)) {
            throw PuegExceptionMapper.makeNoDeleteOrCancellationAllowedDomainException((String)(this.getEmployee().getPersonnelnumber() + " " + this.getCreatedOn()));
        }
        this.makeSaveable();
        this.destroy();
    }

    public String toString() {
        return "PuegAccount [mEmployee = " + this.mEmployee.getIDString() + ", mCreatedOn = " + this.mCreatedOn + ", mAdviceState = " + this.mAdviceState + "]";
    }

    private static IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static IPuegAccountPersistencyManager getIPuegAccountPM() {
        return (IPuegAccountPersistencyManager)UtilitiesManager.getBean((String)"puegAccountPersistencyManager", IPuegAccountPersistencyManager.class);
    }

    private static IPuegAnfragePersistencyManager getIPuegAnfragePM() {
        return (IPuegAnfragePersistencyManager)UtilitiesManager.getBean((String)"puegAnfragePersistencyManager", IPuegAnfragePersistencyManager.class);
    }

    private static IPuegKuendigungPersistencyManager getIPuegKuendigungPM() {
        return (IPuegKuendigungPersistencyManager)UtilitiesManager.getBean((String)"puegKuendigungPersistencyManager", IPuegKuendigungPersistencyManager.class);
    }

    public void addError(String errorMessage) {
        this.mErrorMessage = StringMapper.isNullString((String)this.getErrorMessage()) ? errorMessage : this.mErrorMessage.trim() + " " + errorMessage;
    }

    public boolean hasErrors() {
        return this.mErrorMessage != null && !this.mErrorMessage.isEmpty();
    }

    public String getName() throws BusinessDomainException {
        if (this.getEmployee() == null) {
            return "";
        }
        Master master = this.getEmployee().getMaster(VDate.getDateMax(), VDate.getDateMax());
        return master.getSurname() + ", " + master.getFirstname();
    }

    public PuegAnfrage createAnfrage() {
        if (this.mPuegAnfrage != null) {
            throw new IllegalStateException("PeugAnfrage already exists");
        }
        this.mPuegAnfrage = new PuegAnfrage();
        this.mPuegAnfrage.setPuegAccount(this);
        return this.mPuegAnfrage;
    }

    public PuegKuendigung createKuendigung() {
        if (this.mPuegKuendigung != null) {
            throw new IllegalStateException("PuegKuendigung already exists");
        }
        this.mPuegKuendigung = new PuegKuendigung();
        this.mPuegKuendigung.setPuegAccount(this);
        return this.mPuegKuendigung;
    }

    public String getIdnr() {
        String idnr = "";
        if (this.mPuegAnfrage != null) {
            idnr = this.mPuegAnfrage.getIdnr();
        }
        if (this.mPuegKuendigung != null) {
            idnr = this.mPuegKuendigung.getIdnr();
        }
        return idnr;
    }

    public Date getGeburtsdatum() {
        Date birthDay = null;
        if (this.mPuegAnfrage != null) {
            birthDay = this.mPuegAnfrage.getGeburtsdatum();
        }
        if (this.mPuegKuendigung != null) {
            birthDay = this.mPuegKuendigung.getGeburtsdatum();
        }
        return birthDay;
    }

    public String getGrund() {
        if (this.getEmployee() == null) {
            return "";
        }
        if (PuegReasonOfDeliveryEnum.KUENDIGUNG.equals((Object)this.getReasonOfDelivery())) {
            return "K\u00fcndigung";
        }
        return "Anfrage";
    }

    public String getPersonnelNumber() {
        if (this.getEmployee() == null) {
            return "";
        }
        return "" + this.getEmployee().getPersonnelnumber();
    }

    public boolean isCancelationProvisionActual() {
        return this.hasErrors() && this.getErrorMessage().contains("R\u00fcckstellung: ") && this.isCreatedToday();
    }

    private boolean isCreatedToday() {
        if (this.getCreatedOn() == null && DateHelper.after((Date)this.getCreatedOn(), (Date)VDate.getCurrentLocalizedDateAndTime())) {
            return false;
        }
        return DateHelper.getDiffInDays((Date)VDate.getCurrentLocalizedDateAndTime(), (Date)this.getCreatedOn()) == 0;
    }
}

