/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.socialinsurance;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTPPersistencyManager;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.util.Date;
import java.util.List;

public class SocialInsurance
extends PersonnelPersistenceObject<SocialInsuranceTP> {
    static final String CLASSNAME = SocialInsurance.class.getName();

    public SocialInsurance() {
        super(1, true);
        this.setObjectid("0");
    }

    public String getDomainKey() {
        return "";
    }

    protected void deleteImpl() {
    }

    protected void saveImpl() {
    }

    protected void load() {
    }

    private SocialInsuranceTP[] listToSocialInsuranceTPArray(List<SocialInsuranceTP> list) {
        SocialInsuranceTP[] sitp = new SocialInsuranceTP[list.size()];
        return list.toArray(sitp);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public SocialInsuranceTP[] getPSocialInsuranceHistory() {
        return SocialInsuranceTPPersistencyManager.getSocialInsuranceTPHistory();
    }

    public SocialInsuranceTP[] getAllSocialInsuranceHistory() {
        return this.listToSocialInsuranceTPArray(this.getHistory().getAll());
    }

    public SocialInsuranceTP[] getSocialInsuranceHistory(Date effective) {
        return this.listToSocialInsuranceTPArray(this.getHistory().getItems(effective));
    }

    public void addSocialInsuranceHistory(SocialInsuranceTP socialInsuranceTP, boolean removeNew) throws BusinessDomainException {
        socialInsuranceTP.checkAttributes();
        SocialInsuranceTP[] changedArray = this.listToSocialInsuranceTPArray(this.getHistory().addItem((PersonnelTimedPersistenceObject)socialInsuranceTP, removeNew));
        for (int i = 0; i < changedArray.length; ++i) {
            changedArray[i].makeSaveable();
            changedArray[i].registerForLastExecute();
        }
    }

    public void setSocialInsuranceHistory(SocialInsuranceTP socialInsuranceTP, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        socialInsuranceTP.checkAttributes();
        SocialInsuranceTP[] changedArray = DateHelper.equal((Date)socialInsuranceTP.getEffectiveFrom(), (Date)oldEffectiveFrom) ? this.listToSocialInsuranceTPArray(this.getHistory().setItem((PersonnelTimedPersistenceObject)socialInsuranceTP, removeNew)) : this.listToSocialInsuranceTPArray(this.getHistory().addItem((PersonnelTimedPersistenceObject)socialInsuranceTP, true));
        for (int i = 0; i < changedArray.length; ++i) {
            changedArray[i].makeSaveable();
            changedArray[i].registerForLastExecute();
        }
    }

    public static SocialInsuranceTP[] getActiveSocialInsurancesTP() {
        return SocialInsuranceTPPersistencyManager.query(null, (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), (Criterion)Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())), (boolean)true);
    }

    public SocialInsuranceTP getActiveSocialInsuranceTP() {
        SocialInsuranceTP[] siTP = SocialInsuranceTPPersistencyManager.query(null, (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), (Criterion)Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())), (boolean)true);
        if (siTP.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getClassName());
        }
        return siTP[0];
    }

    public SocialInsuranceTP[] getActiveEffectiveSocialInsuranceHistory() {
        return this.listToSocialInsuranceTPArray(this.getHistory().getItems(VDate.getDateMax()));
    }

    public SocialInsuranceTP[] getEffectiveSocialInsuranceHistory(Date effective) {
        return this.listToSocialInsuranceTPArray(this.getHistory().getItems(effective));
    }

    public SocialInsuranceTP getSocialInsurance(Date effective, Date valid) throws BusinessDomainException {
        return (SocialInsuranceTP)this.getHistory().getItem(effective, valid);
    }

    public SocialInsuranceTP[] getSocialInsurancePeriods(SocialInsuranceTP ptpo) {
        return (SocialInsuranceTP[])this.getHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public static SocialInsuranceTP getSocialInsuranceHistory(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        SocialInsuranceTP socialInsuranceTP;
        block2: {
            socialInsuranceTP = null;
            try {
                socialInsuranceTP = SocialInsurancePersistencyManager.getInstance().getSocialInsurance(effectiveTimePoint, validTimePoint);
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block2;
                throw e;
            }
        }
        return socialInsuranceTP;
    }

    public PersonnelHistory<SocialInsuranceTP> getHistory() {
        if (this.mHistory == null) {
            this.mHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getPSocialInsuranceHistory());
        }
        return this.mHistory;
    }
}

