/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.mapper;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.lumpsumitax.ConsolidationIntoALumpSumEnum;
import com.varial.serverbase.basictypes.VDate;
import java.math.BigDecimal;
import java.util.Date;

public final class BAVHelper {
    private static final int MARB_IN_ATZ = 103;

    private BAVHelper() {
    }

    public static void erzeugeSteuerWerteLfd(EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib, BigDecimal wert) throws BusinessDomainException {
        switch (eelib.taxacation()) {
            case 0: 
            case 1: 
            case 13: {
                wplib.addNeueWertPosition(104600, wert);
                break;
            }
            case 3: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101650, 729800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101650, 729300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(729840, wert);
                    } else {
                        wplib.addNeueWertPosition(729340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(729890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(729880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(729390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(729380, wert);
                    break;
                }
            }
            case 4: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101660, 732800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101660, 732300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(732840, wert);
                    } else {
                        wplib.addNeueWertPosition(732340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(732890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(732880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(732390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(732380, wert);
                    break;
                }
            }
            case 6: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101670, 735800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101670, 735300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(735840, wert);
                    } else {
                        wplib.addNeueWertPosition(735340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(735890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(735880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(735390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(735380, wert);
                    break;
                }
            }
            case 5: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) break;
            }
            default: {
                wplib.addNeueWertPosition(110510, wert);
                if (!DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2010, 0, 1).getDate()) || !eelib.isMarbKammerBeitragsPflichtig() || gllib.bundeslandSchluesselBeschaeftigungsort() != 4) break;
                wplib.addNeueWertPosition(115200, wert);
            }
        }
    }

    public static void erzeugeSteuerWerteSBZ(EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib, BigDecimal wert) throws BusinessDomainException {
        switch (eelib.taxacation()) {
            case 0: 
            case 1: 
            case 13: {
                wplib.addNeueWertPosition(104600, wert);
                break;
            }
            case 3: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101650, 729800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101650, 729300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(729840, wert);
                    } else {
                        wplib.addNeueWertPosition(729340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(729890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(729880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Kurzfristig_Beschaeftigte)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(729390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(729380, wert);
                    break;
                }
            }
            case 4: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101660, 732800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101660, 732300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(732840, wert);
                    } else {
                        wplib.addNeueWertPosition(732340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(732890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(732880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Geringfuegig_Beschaeftigte)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(732390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(732380, wert);
                    break;
                }
            }
            case 6: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) {
                    if (eelib.ueberwaelzungLstAN() && !wplib.aus37b()) {
                        wplib.addNeueWertPosition(new int[]{101670, 735800}, wert);
                    } else {
                        wplib.addNeueWertPosition(new int[]{101670, 735300}, wert);
                    }
                    if (eelib.ueberwaelzungSolZAN()) {
                        wplib.addNeueWertPosition(735840, wert);
                    } else {
                        wplib.addNeueWertPosition(735340, wert);
                    }
                    if (eelib.ueberwaelzungKiStAN()) {
                        if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                            if (eelib.marbKiStAbz() == 0) break;
                            wplib.addNeueWertPosition(735890, wert);
                            break;
                        }
                        wplib.addNeueWertPosition(735880, wert);
                        break;
                    }
                    if (gllib.nachweisverfahren(ConsolidationIntoALumpSumEnum.CIALSE_Aushilfskraefte_Land_und_Forstwirtschaft)) {
                        if (eelib.marbKiStAbz() == 0) break;
                        wplib.addNeueWertPosition(735390, wert);
                        break;
                    }
                    wplib.addNeueWertPosition(735380, wert);
                    break;
                }
            }
            case 5: {
                if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2008, 0, 1).getDate())) break;
            }
            default: {
                wplib.addNeueWertPosition(110610, wert);
                if (!DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2010, 0, 1).getDate()) || !eelib.isMarbKammerBeitragsPflichtig() || gllib.bundeslandSchluesselBeschaeftigungsort() != 4) break;
                wplib.addNeueWertPosition(115200, wert);
            }
        }
    }

    public static void erzeugeBeitragsWerteLfd(CalculationLibrary callib, EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib, BigDecimal wert) throws BusinessDomainException {
        if (eelib.marbSvFrei()) {
            wplib.addNeueWertPosition(128600, wert);
        } else {
            wplib.addNeueWertPosition(130510, wert);
            wplib.addNeueWertPosition(135200, wert);
            if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                if (eelib.isMarbKammerBeitragsPflichtig() && gllib.bundeslandSchluesselBeschaeftigungsort() == 10) {
                    wplib.addNeueWertPosition(115200, wert);
                }
            } else if (eelib.isMarbKammerBeitragsPflichtig() && (gllib.bundeslandSchluesselBeschaeftigungsort() == 4 || gllib.bundeslandSchluesselBeschaeftigungsort() == 10)) {
                wplib.addNeueWertPosition(115200, wert);
            }
            if (eelib.marbPgs() == 103) {
                wplib.addNeueWertPosition(109110, wert);
                if (DateHelper.before((Date)callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                    wplib.addNeueWertPosition(109150, wert);
                    wplib.addNeueWertPosition(109510, wert);
                } else {
                    wplib.addNeueWertPosition(109150, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert.negate(), BigDecimal.ZERO);
                    wplib.addNeueWertPosition(109510, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert.negate(), BigDecimal.ZERO);
                }
                if (gllib.vertraglicheEinrechnungBAV()) {
                    wplib.addNeueWertPosition(109130, wert);
                    if (DateHelper.before((Date)callib.berchnungGueltigAb(), (Date)new VDate(2010, 0, 1).getDate())) {
                        wplib.addNeueWertPosition(109170, wert);
                        wplib.addNeueWertPosition(109530, wert);
                    } else {
                        wplib.addNeueWertPosition(109170, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert.negate(), BigDecimal.ZERO);
                        wplib.addNeueWertPosition(109530, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert, false, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, wert.negate(), BigDecimal.ZERO);
                    }
                }
            }
        }
    }

    public static void erzeugeBeitragsWerteEGA(EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib, BigDecimal wert) throws BusinessDomainException {
        if (eelib.marbSvFrei()) {
            wplib.addNeueWertPosition(128600, wert);
        } else {
            wplib.addNeueWertPosition(130610, wert);
            wplib.addNeueWertPosition(135300, wert);
            if (DateHelper.afterOrEqual((Date)wplib.gueltigAb(), (Date)new VDate(2010, 0, 1).getDate()) && eelib.isMarbKammerBeitragsPflichtig() && gllib.bundeslandSchluesselBeschaeftigungsort() == 10) {
                wplib.addNeueWertPosition(115200, wert);
            }
            if (eelib.marbPgs() == 103) {
                wplib.addNeueWertPosition(109330, wert);
                if (gllib.vertraglicheEinrechnungBAV()) {
                    wplib.addNeueWertPosition(109360, wert);
                }
            }
        }
    }

    public static BigDecimal beitragspflLfdBruttoFuerUmwandlung(CalculationLibrary callib, ValuePositionLibrary wplib) throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = wplib.wpAusWPListeOderDB(callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungWirksamAb()), callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 130560}))) {
            result = result.add(vPos.getResult());
        }
        return result;
    }

    public static BigDecimal beitragspflLfdBruttoFuerUmwandlung(BigDecimal betragBAV, CalculationLibrary callib, ValuePositionLibrary wplib) throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition vPos : vpArray = wplib.wpAusWPListeOderDB(callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungWirksamAb()), callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130510, 99984}))) {
            if (vPos.getValueType().getValueTypeKey() != 130510) {
                return betragBAV;
            }
            result = result.add(vPos.getResult());
        }
        return result;
    }

    public static BigDecimal beitragspflEgaBruttoFuerUmwandlung(BigDecimal betragBAV, CalculationLibrary callib, ValuePositionLibrary wplib) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.NettoBruttoHochrechnung && callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.Verdienstausfall && callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.VerdienstausfallOhneFZBetreuungKind && callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.VerdienstausfallOhneFZQuarantaene && callib.getCalculationCase().getTypeOfCalculationCase() != TypeOfCalculationCase.PkvPpVBerechnungOhneFZ) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = wplib.wpAusWPListeOderDB(callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungWirksamAb()), callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{130610, 99984, 99985}))) {
                if (vPos.getValueType().getValueTypeKey() != 130610) {
                    return betragBAV;
                }
                result = result.add(vPos.getResult());
            }
        } else {
            return betragBAV;
        }
        return result;
    }
}

