/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.libraryimpl;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.absenttime.AbsentTimeTP;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.MKPosition;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.carriedforward.system.socialinsurance.EECarriedForwardSystemSI;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionScheme;
import com.varial.personnel.domain.employee.pensionscheme.EEPensionSchemeTP;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.evaluation.ErmittlungSVTage;
import com.varial.personnel.domain.evaluation.ErmittlungSteuerTage;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTP;
import com.varial.personnel.domain.global.socialinsurance.lawarea.SocialInsuranceLawArea;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.domain.typeofvalue.basictypes.CategoryEnum;
import com.varial.personnel.domain.typeofvalue.basictypes.TypeOfPaymentEnum;
import com.varial.personnel.domain.typeofvalue.foundation.ValueTypeFoundation;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public class ValuePositionLibraryImpl
implements ValuePositionLibrary {
    private static final BigDecimal DREIHUNDERTSECHZIG = BigDecimal.valueOf(360L);
    protected final CalculationCase mCalculationCase;
    protected final ValuePosition mValuePosition;
    private final EmployeeLibrary mEeLib;
    private ValuePositionHistory mValuePositionHistory;
    private boolean mValuePositionHistoryLoaded = false;
    private BigDecimal aufgelaufeneBbgKv = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneKvTage = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneBbgRv = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneRvTage = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneBbgAv = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneAvTage = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneBbgPv = BigDecimal.ZERO;
    private BigDecimal aufgelaufenePvTage = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneBbgInsG = BigDecimal.ZERO;
    private BigDecimal aufgelaufeneInsGTage = BigDecimal.ZERO;
    private boolean jahreswerteErmittelt = false;
    private boolean tegeMitEFZErmittelt = false;
    private BigDecimal mTageMitEFZ;

    public ValuePositionLibraryImpl(ValuePosition valuePosition, CalculationCase calculationCase, EmployeeLibrary eelib) {
        this.mValuePosition = valuePosition;
        this.mCalculationCase = calculationCase;
        this.mEeLib = eelib;
    }

    public ValuePosition wertPosition() throws BusinessDomainException {
        return this.mValuePosition;
    }

    protected ValuePositionHistory getValuePositionHistory() {
        if (!this.mValuePositionHistoryLoaded) {
            this.mValuePositionHistoryLoaded = true;
            this.mValuePositionHistory = this.mCalculationCase.getValuePositionHistory();
        }
        return this.mValuePositionHistory;
    }

    private ValuePosition getParentValuePosition() {
        return (ValuePosition)this.mValuePosition.getParentObject();
    }

    public ValuePosition parent() throws BusinessDomainException {
        return this.getParentValuePosition();
    }

    public BigDecimal parentWPErgebnis() throws BusinessDomainException {
        return this.getParentValuePosition().getResult();
    }

    private ValuePosition getGenesisParentValuePosition() {
        return (ValuePosition)this.mValuePosition.getGenesisOfParentObjects();
    }

    public ValuePosition genesisParent() throws BusinessDomainException {
        return this.getGenesisParentValuePosition();
    }

    public BigDecimal genesisParentWPFaktor1() throws BusinessDomainException {
        return this.getGenesisParentValuePosition().getFactor1();
    }

    public BigDecimal genesisParentWPErgebnis() throws BusinessDomainException {
        return this.getGenesisParentValuePosition().getResult();
    }

    public Date wirksamAb() throws BusinessDomainException {
        return this.mValuePosition.getEffectiveFrom();
    }

    public Date wirksamBis() throws BusinessDomainException {
        return this.mValuePosition.getEffectiveUntil();
    }

    public Date gueltigAb() throws BusinessDomainException {
        return this.mValuePosition.getValidFrom();
    }

    public Date gueltigBis() throws BusinessDomainException {
        return this.mValuePosition.getValidUntil();
    }

    public BigDecimal prozentsatz() throws BusinessDomainException {
        return this.mValuePosition.getPercentage();
    }

    public void prozentsatz(BigDecimal prozentsatz) throws BusinessDomainException {
        this.mValuePosition.setPercentage(prozentsatz);
    }

    public BigDecimal leistungsfactor() throws BusinessDomainException {
        return this.mValuePosition.getPerformanceFactor();
    }

    public void leistungsfactor(BigDecimal leistungsfactor) throws BusinessDomainException {
        this.mValuePosition.setPerformanceFactor(leistungsfactor);
    }

    public BigDecimal result() throws BusinessDomainException {
        return this.mValuePosition.getResult();
    }

    public void result(BigDecimal result) throws BusinessDomainException {
        this.mValuePosition.setResult(result);
    }

    public BigDecimal getResultVM() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer3();
    }

    public void setResultVM(BigDecimal result) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer3(result);
    }

    public BigDecimal factor1() throws BusinessDomainException {
        return this.mValuePosition.getFactor1();
    }

    public void factor1(BigDecimal factor1) throws BusinessDomainException {
        this.mValuePosition.setFactor1(factor1);
    }

    public BigDecimal getFactor1VM() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer1();
    }

    public void setFactor1VM(BigDecimal factor1) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer1(factor1);
    }

    public BigDecimal factor2() throws BusinessDomainException {
        return this.mValuePosition.getFactor2();
    }

    public void factor2(BigDecimal factor2) throws BusinessDomainException {
        this.mValuePosition.setFactor2(factor2);
    }

    public BigDecimal getFactor2VM() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer2();
    }

    public void setFactor2VM(BigDecimal factor2) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer2(factor2);
    }

    public BigDecimal persistentBuffer1() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer1();
    }

    public void persistentBuffer1(BigDecimal pb1) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer1(pb1);
    }

    public BigDecimal persistentBuffer2() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer2();
    }

    public void persistentBuffer2(BigDecimal pb2) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer2(pb2);
    }

    public BigDecimal persistentBuffer3() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer3();
    }

    public void persistentBuffer3(BigDecimal pb3) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer3(pb3);
    }

    public BigDecimal persistentBuffer4() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer4();
    }

    public void persistentBuffer4(BigDecimal pb4) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer4(pb4);
    }

    public BigDecimal persistentBuffer5() throws BusinessDomainException {
        return this.mValuePosition.getPersistentBuffer5();
    }

    public void persistentBuffer5(BigDecimal pb5) throws BusinessDomainException {
        this.mValuePosition.setPersistentBuffer5(pb5);
    }

    public int wertartenNummer() throws BusinessDomainException {
        return this.mValuePosition.getValueType().getValueTypeKey();
    }

    public ValuePosition[] wpAusWPListeOderDB(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, ValueType[] valueTypes) throws BusinessDomainException {
        return this.wpAusWPListeOderDB(this.mCalculationCase.getEmployee().getObjectid(), effectiveFrom, effectiveUntil, validFrom, validUntil, valueTypes);
    }

    public ValuePosition[] wpAusWPListeOderDB(String oidEmployee, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, ValueType[] valueTypes) throws BusinessDomainException {
        ValuePosition[] vpArray = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (vpArray.length == 0) {
            ArrayList<String> values = new ArrayList<String>(valueTypes.length);
            for (ValuePosition valuePosition : valueTypes) {
                values.add(Integer.toString(valuePosition.getValueTypeKey()));
            }
            vpArray = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.in((String)"valuetypenumber", values), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveUntil)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validUntil)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFrom))}));
        }
        LinkedList<ValuePosition> resultList = new LinkedList<ValuePosition>();
        for (ValuePosition valuePosition : vpArray) {
            for (ValueType valueType : valueTypes) {
                if (valueType == null || valuePosition.getValueType().getValueTypeKey() != valueType.getValueTypeKey()) continue;
                resultList.add(valuePosition);
            }
        }
        ValuePosition[] result = new ValuePosition[resultList.size()];
        return resultList.toArray(result);
    }

    public ValuePosition[] wpAusWPListeOderDB(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, PersistentObject genesisObject) throws BusinessDomainException {
        ValuePosition[] vpArray = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (vpArray.length == 0) {
            vpArray = ValuePosition.getValuePositionen(this.mCalculationCase.getEmployee().getObjectid(), effectiveFrom, effectiveUntil, validFrom, validUntil);
        }
        LinkedList<ValuePosition> resultList = new LinkedList<ValuePosition>();
        for (ValuePosition element : vpArray) {
            if (element.getGenesisOfParentObjects() == null || !element.getGenesisOfParentObjects().equals((Object)genesisObject)) continue;
            resultList.add(element);
        }
        ValuePosition[] result = new ValuePosition[resultList.size()];
        return resultList.toArray(result);
    }

    public ValuePosition[] wpAusWPListeOderDB(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil) throws BusinessDomainException {
        ValuePosition[] result = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil);
        if (result.length == 0) {
            result = ValuePosition.getValuePositionen(this.mCalculationCase.getEmployee().getObjectid(), effectiveFrom, effectiveUntil, validFrom, validUntil);
        }
        return result;
    }

    public ValuePosition[] wpAusWPListeBisParentUebergebenerWP(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, ValuePosition valuePosition, ValueType[] vtArray) throws BusinessDomainException {
        ValuePosition[] vpArray;
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        int aktuelleVP = this.getValuePositionHistory().getIndex((ValuePosition)valuePosition.getParentObject());
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil, aktuelleVP)) {
            for (ValueType element2 : vtArray) {
                if (element.getValueType().getValueTypeKey() != element2.getValueTypeKey()) continue;
                result.add(element);
            }
        }
        ValuePosition[] returnArray = new ValuePosition[result.size()];
        return result.toArray(returnArray);
    }

    public ValuePosition[] wpAusWPListeBisGenesisParentUebergebenerWP(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, ValuePosition valuePosition, ValueType[] vtArray) throws BusinessDomainException {
        ValuePosition[] vpArray;
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        int aktuelleVP = this.getValuePositionHistory().getIndex((ValuePosition)valuePosition.getGenesisOfParentObjects());
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil, aktuelleVP)) {
            for (ValueType element2 : vtArray) {
                if (element.getValueType().getValueTypeKey() != element2.getValueTypeKey()) continue;
                result.add(element);
            }
        }
        ValuePosition[] returnArray = new ValuePosition[result.size()];
        return result.toArray(returnArray);
    }

    public ValuePosition[] wpAusWPListeBisUebergebeneWP(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, ValuePosition valuePosition, ValueType[] vtArray) throws BusinessDomainException {
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        int aktuelleVP = this.getValuePositionHistory().getIndex(valuePosition);
        ValuePosition[] vpArray = this.getValuePositionHistory().getItems(effectiveFrom, effectiveUntil, validFrom, validUntil, aktuelleVP);
        if (vtArray.length == 0) {
            for (ValuePosition vPos : vpArray) {
                result.add(vPos);
            }
        } else {
            for (ValuePosition vPos : vpArray) {
                for (ValueType vType : vtArray) {
                    if (vPos.getValueType().getValueTypeKey() != vType.getValueTypeKey()) continue;
                    result.add(vPos);
                }
            }
        }
        ValuePosition[] returnArray = new ValuePosition[result.size()];
        return result.toArray(returnArray);
    }

    public ValuePosition[] wpAusWPListeBisUebergebeneWP(Date wirksamAb, Date wirksamBis, Date gueltigAb, Date gueltigBis, ValuePosition position, CategoryEnum category) throws BusinessDomainException {
        ValuePosition[] vpArray;
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        int aktuelleVP = this.getValuePositionHistory().getIndex(position);
        for (ValuePosition valuePosition : vpArray = this.getValuePositionHistory().getItems(wirksamAb, wirksamBis, gueltigAb, gueltigBis, aktuelleVP)) {
            if (valuePosition.getValueType().getValueTypeTP(wirksamAb, gueltigAb).getValueTypeFoundation().getGeneral().getCategory().value() != category.value()) continue;
            result.add(valuePosition);
        }
        ValuePosition[] returnArray = new ValuePosition[result.size()];
        return result.toArray(returnArray);
    }

    public ValuePosition[] wpAusWPListeBisUebergebeneWP(Date wirksamAb, Date wirksamBis, Date gueltigAb, Date gueltigBis, ValuePosition position, TypeOfPaymentEnum entgeltArt) throws BusinessDomainException {
        ValuePosition[] vpArray;
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        int aktuelleVP = this.getValuePositionHistory().getIndex(position);
        for (ValuePosition valuePosition : vpArray = this.getValuePositionHistory().getItems(wirksamAb, wirksamBis, gueltigAb, gueltigBis, aktuelleVP)) {
            if (valuePosition.getValueType().getValueTypeTP(wirksamAb, gueltigAb).getValueTypeFoundation().getGeneral().getTypeOfPayment() != entgeltArt) continue;
            result.add(valuePosition);
        }
        ValuePosition[] returnArray = new ValuePosition[result.size()];
        return result.toArray(returnArray);
    }

    public BigDecimal summeWPErgebnisVonWertarten(ValueType[] wa) throws BusinessDomainException {
        ValuePosition[] wpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()), DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()));
        BigDecimal result = BigDecimal.valueOf(0L);
        for (ValuePosition element : wpArray) {
            for (ValueType element2 : wa) {
                if (element.getValueType().getValueTypeKey() != element2.getValueTypeKey()) continue;
                result = result.add(element.getResult());
            }
        }
        return result;
    }

    public BigDecimal aktuellerNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = this.getValuePositionHistory().getItemsInside(700100, this.mCalculationCase.getEffectiveFrom(), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        for (ValuePosition element : vpArray) {
            result = result.add(element.getResult().setScale(2, RoundingMode.HALF_UP));
        }
        return result;
    }

    public BigDecimal alterNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = ValuePosition.getValuePositionen(this.mCalculationCase.getEmployee().getObjectid(), ValueType.getValueType((int)700100).getObjectid(), DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.mCalculationCase.getEffectiveFrom())), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        for (ValuePosition element : vpArray) {
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal aktuellesBasisentgeltFuerNettoVomGenesis() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        ValuePosition vp = this.folgeWertartVomGenesis(100200);
        if (vp != null) {
            result = vp.getResult();
        }
        return result;
    }

    public BigDecimal aktuelleAbzuegeVorNettoVomGenesis() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(CategoryEnum.CE_SYS_Gestzlicher_Abzug_vor_Nettolohn, this.mValuePosition.getGenesisOfParentObjects())) {
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal aktuelleBVWerteVomGenesis() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        block4: for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(this.mValuePosition.getGenesisOfParentObjects())) {
            switch (element.getValueType().getValueTypeKey()) {
                case 774510: 
                case 774511: 
                case 774512: 
                case 774514: 
                case 774550: 
                case 774560: 
                case 774565: 
                case 774610: 
                case 774620: 
                case 774630: 
                case 774710: 
                case 774720: 
                case 774730: {
                    result = result.add(element.getResult());
                    continue block4;
                }
                case 775510: 
                case 775512: 
                case 775514: 
                case 775520: 
                case 775550: 
                case 775555: 
                case 775560: 
                case 775610: 
                case 775620: 
                case 775630: 
                case 775640: 
                case 775650: 
                case 775655: 
                case 775720: 
                case 775725: 
                case 775730: {
                    result = result.subtract(element.getResult());
                }
            }
        }
        return result;
    }

    public BigDecimal aktuelleAbzuegeVorNetto() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), this.mValuePosition.getValidFrom(), DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (element.getValueType().getValueTypeTP(element.getEffectiveFrom(), element.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() != 20) continue;
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal aktuelleBezuegeVorNetto() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), this.mValuePosition.getValidFrom(), DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (element.getValueType().getValueTypeTP(element.getEffectiveFrom(), element.getValidFrom()).getValueTypeFoundation().getGeneral().getCategory().value() != 19) continue;
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal aktuelleBezuegeVorNettoVomGenesis() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal result = BigDecimal.ZERO;
        for (ValuePosition element : vpArray = this.getValuePositionHistory().getItems(CategoryEnum.CE_SYS_Gestzlicher_Bezug_vor_Nettolohn, this.mValuePosition.getGenesisOfParentObjects())) {
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal aktuelleAbzuegeNachNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = this.getValuePositionHistory().getItemsInside(CategoryEnum.CE_SYS_Abzug_nach_Nettolohn, this.mCalculationCase.getEffectiveFrom(), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        for (ValuePosition element : vpArray) {
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal alteAbzuegeNachNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = ValuePosition.getValuePositionen(this.mCalculationCase.getEmployee().getObjectid(), CategoryEnum.CE_SYS_Abzug_nach_Nettolohn, DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.mCalculationCase.getEffectiveFrom())), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        block3: for (ValuePosition element : vpArray) {
            switch (element.getValueType().getValueTypeKey()) {
                case 795064: 
                case 795065: 
                case 795074: 
                case 795084: 
                case 795094: 
                case 795554: 
                case 861114: 
                case 862114: 
                case 863114: 
                case 863124: 
                case 863134: 
                case 863144: 
                case 863154: 
                case 863164: 
                case 880000: 
                case 889991: {
                    continue block3;
                }
                default: {
                    result = result.add(element.getResult());
                }
            }
        }
        return result;
    }

    public BigDecimal aktuelleBezuegeNachNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = this.getValuePositionHistory().getItemsInside(CategoryEnum.CE_SYS_Bezug_nach_Nettolohn, this.mCalculationCase.getEffectiveFrom(), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        for (ValuePosition element : vpArray) {
            result = result.add(element.getResult());
        }
        return result;
    }

    public BigDecimal alteBezuegeNachNettolohn() throws BusinessDomainException {
        ValuePosition[] vpArray = ValuePosition.getValuePositionen(this.mCalculationCase.getEmployee().getObjectid(), CategoryEnum.CE_SYS_Bezug_nach_Nettolohn, DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.mCalculationCase.getEffectiveFrom())), this.mValuePosition.getValidFrom());
        BigDecimal result = BigDecimal.valueOf(0L, 2);
        block3: for (ValuePosition element : vpArray) {
            switch (element.getValueType().getValueTypeKey()) {
                case 795062: 
                case 795063: 
                case 795072: 
                case 795082: 
                case 795092: 
                case 795552: 
                case 861112: 
                case 862112: 
                case 863112: 
                case 863122: 
                case 863132: 
                case 863142: 
                case 863152: 
                case 863162: 
                case 882110: {
                    continue block3;
                }
                default: {
                    result = result.add(element.getResult());
                }
            }
        }
        return result;
    }

    public BigDecimal kvEntgeltFKV257() throws BusinessDomainException {
        try {
            return this.getValuePositionHistory().getItem(770090, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects()).getResult();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return BigDecimal.valueOf(0L, 2);
            }
            throw e;
        }
    }

    public BigDecimal kvEntgeltPKV257() throws BusinessDomainException {
        try {
            return this.getValuePositionHistory().getItem(770190, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects()).getResult();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return BigDecimal.valueOf(0L, 2);
            }
            throw e;
        }
    }

    public BigDecimal pvEntgeltFPV61() throws BusinessDomainException {
        try {
            return this.mCalculationCase.getValuePositionHistory().getItem(771090, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects()).getResult();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return BigDecimal.valueOf(0L, 2);
            }
            throw e;
        }
    }

    public BigDecimal pvEntgeltPPV61() throws BusinessDomainException {
        try {
            return this.mCalculationCase.getValuePositionHistory().getItem(771190, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects()).getResult();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return BigDecimal.valueOf(0L, 2);
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate, PersistentObject genesis) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (onetimecreate) {
                if (mFoundation.getOneTimeCreateForCalculationCase()) {
                    if (mFoundation.getGeneral().getCategory().value() == 15) {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), genesis);
                        oldVP.setResult(oldVP.getResult().add(result));
                    } else {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                        if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                            oldVP.setResult(oldVP.getResult().add(result));
                        }
                    }
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setGenesisOfParentObjects(genesis);
                    if (this.mValuePosition.getValueType().getValueTypeKey() < 100000) {
                        newVP.setParentObject(genesis);
                    } else {
                        newVP.setParentObject(this.mValuePosition);
                    }
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setGenesisOfParentObjects(genesis);
                    newVP.setParentObject(genesis);
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal result, boolean summierung) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if ((oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) && summierung) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        if (vt == null) {
            throw EvaluationExceptionMapper.makeMissingValueTypeDomaineException(valueTypeNumber);
        }
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (onetimecreate) {
                if (mFoundation.getOneTimeCreateForCalculationCase()) {
                    if (mFoundation.getGeneral().getCategory().value() == 15) {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                        oldVP.setResult(oldVP.getResult().add(result));
                    } else {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                        if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                            oldVP.setResult(oldVP.getResult().add(result));
                        }
                    }
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                        oldVP.setEvaluateComplete(false);
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate, BigDecimal persistentBuffer1, BigDecimal persistentBuffer2, BigDecimal persistentBuffer3, BigDecimal persistentBuffer4, BigDecimal persistentBuffer5) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (onetimecreate) {
                if (mFoundation.getOneTimeCreateForCalculationCase()) {
                    if (mFoundation.getGeneral().getCategory().value() == 15) {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                        oldVP.setResult(oldVP.getResult().add(result));
                    } else {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                        if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                            oldVP.setResult(oldVP.getResult().add(result));
                        }
                    }
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setPersistentBuffer1(persistentBuffer1);
                    newVP.setPersistentBuffer2(persistentBuffer2);
                    newVP.setPersistentBuffer3(persistentBuffer3);
                    newVP.setPersistentBuffer4(persistentBuffer4);
                    newVP.setPersistentBuffer5(persistentBuffer5);
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setPersistentBuffer1(persistentBuffer1);
                    newVP.setPersistentBuffer2(persistentBuffer2);
                    newVP.setPersistentBuffer3(persistentBuffer3);
                    newVP.setPersistentBuffer4(persistentBuffer4);
                    newVP.setPersistentBuffer5(persistentBuffer5);
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPositionMitGleichemParent(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate) throws BusinessDomainException {
        this.addNeueWertPositionMitGleichemParent(valueTypeNumber, percentage, performanceFactor, factor1, factor2, result, onetimecreate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public void addNeueWertPositionMitGleichemParent(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate, BigDecimal bufferResult) throws BusinessDomainException {
        this.addNeueWertPositionMitGleichemParent(valueTypeNumber, percentage, performanceFactor, factor1, factor2, result, onetimecreate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, bufferResult);
    }

    public void addNeueWertPositionMitGleichemParent(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate, BigDecimal persistentBuffer1, BigDecimal persistentBuffer2, BigDecimal persistentBuffer3, BigDecimal persistentBuffer4, BigDecimal persistentBuffer5) throws BusinessDomainException {
        this.addNeueWertPositionMitGleichemParent(valueTypeNumber, percentage, performanceFactor, factor1, factor2, result, onetimecreate, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void addNeueWertPositionMitGleichemParent(int valueTypeNumber, BigDecimal percentage, BigDecimal performanceFactor, BigDecimal factor1, BigDecimal factor2, BigDecimal result, boolean onetimecreate, BigDecimal persistentBuffer1, BigDecimal persistentBuffer2, BigDecimal persistentBuffer3, BigDecimal persistentBuffer4, BigDecimal persistentBuffer5, BigDecimal bufferResult) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (onetimecreate) {
                if (mFoundation.getOneTimeCreateForCalculationCase()) {
                    if (mFoundation.getGeneral().getCategory().value() == 15) {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                        oldVP.setResult(oldVP.getResult().add(result));
                    } else {
                        ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                        if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation()) {
                            oldVP.setResult(oldVP.getResult().add(result));
                        }
                    }
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation()) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation()) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setParentObject(this.mValuePosition.getParentObject());
                    newVP.setPersistentBuffer1(persistentBuffer1);
                    newVP.setPersistentBuffer2(persistentBuffer2);
                    newVP.setPersistentBuffer3(persistentBuffer3);
                    newVP.setPersistentBuffer4(persistentBuffer4);
                    newVP.setPersistentBuffer5(persistentBuffer5);
                    newVP.setBufferResult(bufferResult);
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, percentage, performanceFactor, factor1, factor2, result);
                if (newVP != null) {
                    newVP.setParentObject(this.mValuePosition.getParentObject());
                    newVP.setPersistentBuffer1(persistentBuffer1);
                    newVP.setPersistentBuffer2(persistentBuffer2);
                    newVP.setPersistentBuffer3(persistentBuffer3);
                    newVP.setPersistentBuffer4(persistentBuffer4);
                    newVP.setPersistentBuffer5(persistentBuffer5);
                    newVP.setBufferResult(bufferResult);
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPositionNurMaerzklausel(int valueTypeNumber, Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, BigDecimal result) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        ValuePosition newVP = this.mValuePosition.create(vt, result);
        if (newVP != null) {
            newVP.setEffectiveFrom(effectiveFrom);
            newVP.setEffectiveUntil(effectiveUntil);
            newVP.setValidFrom(validFrom);
            newVP.setValidUntil(validUntil);
            this.getValuePositionHistory().addItem(newVP);
            this.mCalculationCase.getValuePositionHistory().sort();
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal result) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition newVP = this.mValuePosition.create(vt, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int valueTypeNumber, BigDecimal result, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        ValueType vt = ValueType.getValueType((int)valueTypeNumber);
        try {
            ValueTypeFoundation mFoundation = vt.getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getValueTypeFoundation();
            if (mFoundation.getOneTimeCreateForCalculationCase()) {
                if (mFoundation.getGeneral().getCategory().value() == 15) {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
                    oldVP.setResult(oldVP.getResult().add(result));
                } else {
                    ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom());
                    if (oldVP.getValueType().getValueTypeTP(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom()).getResult().getSpecification().getTotalsFormation() || valueTypeNumber < 100000) {
                        oldVP.setResult(oldVP.getResult().add(result));
                    }
                }
            } else {
                ValuePosition oldVP = this.getValuePositionHistory().getItem(valueTypeNumber, effectiveFrom, validFrom, this.mValuePosition.getGenesisOfParentObjects());
            }
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                ValuePosition newVP = this.mValuePosition.create(vt, result);
                if (newVP != null) {
                    this.getValuePositionHistory().addItem(newVP);
                    this.mCalculationCase.getValuePositionHistory().sort();
                }
            }
            throw e;
        }
    }

    public void addNeueWertPosition(int[] valuetypes, BigDecimal result) throws BusinessDomainException {
        for (int valuetype : valuetypes) {
            this.addNeueWertPosition(valuetype, result);
        }
    }

    public void loescheWertPositionenImMonat(int valueTypeNumber) throws BusinessDomainException {
        ValuePosition[] toRemove;
        for (ValuePosition element : toRemove = this.getValuePositionHistory().getItems(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getValidUntil())) {
            this.getValuePositionHistory().removeItem(element);
        }
    }

    public void loescheWertPosition(ValuePosition toRemove) throws BusinessDomainException {
        this.getValuePositionHistory().removeItem(toRemove);
    }

    public void loescheWertPosition(int valueTypeNumber) throws BusinessDomainException {
        try {
            ValuePosition toRemove = this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects());
            this.getValuePositionHistory().removeItem(toRemove);
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return;
            }
            throw e;
        }
    }

    public void loescheWertPosition(int ... valuetypes) throws BusinessDomainException {
        for (int valuetype : valuetypes) {
            this.loescheWertPosition(valuetype);
        }
    }

    public int kvTage() throws BusinessDomainException {
        try {
            return this.getValuePositionHistory().getItem(130590, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), this.mValuePosition.getGenesisOfParentObjects()).getResult().intValue();
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return 0;
            }
            throw e;
        }
    }

    public BigDecimal svTage() throws BusinessDomainException {
        ErmittlungSVTage ef = new ErmittlungSVTage();
        ef.evaluate(this.mValuePosition, this.mCalculationCase);
        return this.mCalculationCase.getBufferSIDays();
    }

    public BigDecimal svTageLfd() throws BusinessDomainException {
        if (DateHelper.between((Date)this.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalculationCase.getValidFrom()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getValidFrom()))) {
            if (!this.mCalculationCase.isSVTageEvaluate()) {
                ErmittlungSVTage ef = new ErmittlungSVTage();
                ef.evaluate(this.mValuePosition, this.mCalculationCase);
                return this.mCalculationCase.getBufferSIDays();
            }
            return this.mCalculationCase.getSVTage();
        }
        ErmittlungSVTage ef = new ErmittlungSVTage();
        ef.evaluate(this.mValuePosition, this.mCalculationCase);
        return this.mCalculationCase.getBufferSIDays();
    }

    public BigDecimal steuerTage() throws BusinessDomainException {
        if (!this.mCalculationCase.isSteuerTageEvaluate()) {
            ErmittlungSteuerTage ef = new ErmittlungSteuerTage();
            ef.evaluate(this.mValuePosition, this.mCalculationCase);
            return this.mCalculationCase.getBufferTaxDays();
        }
        return this.mCalculationCase.getSteuerTage();
    }

    public BigDecimal kvTageMarb() throws BusinessDomainException {
        if (this.mEeLib.marbBgrKv() != 0) {
            return this.svTage();
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal kvTageMarbLfd() throws BusinessDomainException {
        if (this.mEeLib.marbBgrKv() != 0) {
            return this.svTageLfd();
        }
        return this.svTage();
    }

    public BigDecimal rvTageMarb() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (this.mEeLib.marbBgrRv() != 0) {
            result = this.svTage();
        } else {
            switch (this.mEeLib.marbVersorgungsart().value()) {
                case 1: 
                case 2: 
                case 3: {
                    result = this.svTage();
                    break;
                }
            }
        }
        return result;
    }

    public BigDecimal rvTageMarbLfd() throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (this.mEeLib.marbBgrRv() != 0) {
            result = this.svTageLfd();
        } else {
            switch (this.mEeLib.marbVersorgungsart().value()) {
                case 1: 
                case 2: 
                case 3: {
                    result = this.svTageLfd();
                    break;
                }
            }
        }
        return result;
    }

    public BigDecimal avTageMarb() throws BusinessDomainException {
        if (this.mEeLib.marbBgrAv() != 0) {
            return this.svTage();
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal avTageMarbLfd() throws BusinessDomainException {
        if (this.mEeLib.marbBgrAv() != 0) {
            return this.svTageLfd();
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal pvTageMarb() throws BusinessDomainException {
        if (this.mEeLib.marbBgrPv() != 0) {
            return this.svTage();
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal pvTageMarbLfd() throws BusinessDomainException {
        if (this.mEeLib.marbBgrPv() != 0) {
            return this.svTageLfd();
        }
        return this.svTage();
    }

    public BigDecimal insGTageMarb() throws BusinessDomainException {
        if (this.mEeLib.isMarbInsGPflichtig()) {
            return this.svTage();
        }
        return BigDecimal.valueOf(0L);
    }

    public BigDecimal insGTageMarbLfd() throws BusinessDomainException {
        if (this.mEeLib.isMarbInsGPflichtig()) {
            return this.svTageLfd();
        }
        return this.svTage();
    }

    public BigDecimal sammleKVTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributoryHI(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 321590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    public BigDecimal sammleRVTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributoryPI(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 327590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    public BigDecimal sammleAVTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributoryUI(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 333590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    public BigDecimal sammlePVTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributoryNI(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 339590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    public BigDecimal sammleInsGTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributoryNI(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 365590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    public BigDecimal sammleSVTageFuerEGA() throws BusinessDomainException {
        BigDecimal svTage = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()))) {
            if (this.mValuePosition.getEmployee().isContributory(this.mValuePosition.getEffectiveFrom(), suchDatum)) {
                ValuePosition[] vpArray;
                for (ValuePosition element : vpArray = this.getValuePositions(suchDatum, 130590)) {
                    svTage = svTage.add(element.getFactor1());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        return svTage.add(this.svTage());
    }

    private ValuePosition[] getValuePositions(Date suchDatum, int vtNumber) throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{vtNumber}));
        return vpArray;
    }

    public BigDecimal summeKVTageFuerEGA(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneKvTage;
    }

    public BigDecimal aufgelBbgKv(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneBbgKv;
    }

    public BigDecimal summeRVTageFuerEGA(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneRvTage;
    }

    public BigDecimal aufgelBbgRv(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneBbgRv;
    }

    public BigDecimal summeInsGTageFuerEGA(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneInsGTage;
    }

    public BigDecimal aufgelBbgInsG(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneBbgInsG;
    }

    public BigDecimal summeAVTageFuerEGA(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneAvTage;
    }

    public BigDecimal aufgelBbgAv(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneBbgAv;
    }

    public BigDecimal summePVTageFuerEGA(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufenePvTage;
    }

    public BigDecimal aufgelBbgPv(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.ermittleJahreswerteSv(beitragspflichtig);
        }
        return this.aufgelaufeneBbgPv;
    }

    public BigDecimal summeSVTageFuerEGA() throws BusinessDomainException {
        return this.sammleSVTageFuerEGA().add(this.mEeLib.vortragSozialVersicherungSVTage(this.gueltigAb()));
    }

    public void faktor1Bewerten(boolean bool) throws BusinessDomainException {
        this.mValuePosition.setEvaluateFactor1(bool);
    }

    public boolean faktor1Bewerten() throws BusinessDomainException {
        return this.mValuePosition.getEvaluateFactor1();
    }

    public void faktor2Bewerten(boolean bool) throws BusinessDomainException {
        this.mValuePosition.setEvaluateFactor2(bool);
    }

    public boolean faktor2Bewerten() throws BusinessDomainException {
        return this.mValuePosition.getEvaluateFactor2();
    }

    public void resultatBewerten(boolean bool) throws BusinessDomainException {
        this.mValuePosition.setEvaluateResult(bool);
    }

    public boolean resultatBewerten() throws BusinessDomainException {
        return this.mValuePosition.getEvaluateResult();
    }

    public ValuePosition folgeWertartVomGenesis(int valueTypeNumber) throws BusinessDomainException {
        try {
            return this.folgeWertartVomGenesis(this.mValuePosition.getGenesisOfParentObjects(), valueTypeNumber);
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return null;
            }
            throw e;
        }
    }

    public ValuePosition folgeWertartVomGenesis(PersistentObject genesis, int valueTypeNumber) throws BusinessDomainException {
        try {
            return this.getValuePositionHistory().getItem(valueTypeNumber, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getValidFrom(), genesis);
        }
        catch (BusinessDomainException e) {
            if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) {
                return null;
            }
            throw e;
        }
    }

    public ValuePosition folgeWertartVomGenesisDB(PersistentObject genesis, int valueTypeNumber) throws BusinessDomainException {
        return ValuePosition.getValuePosition(genesis, valueTypeNumber);
    }

    public ValuePosition[] genesisUndFolgen() throws BusinessDomainException {
        return this.genesisUndFolgen(this.wertPosition());
    }

    public ValuePosition[] genesisUndFolgen(ValuePosition vposition) throws BusinessDomainException {
        try {
            ValuePosition vp = (ValuePosition)vposition.getGenesisOfParentObjects();
            return this.getConsequensesOfValuePosition(vp);
        }
        catch (ClassCastException e) {
            return this.parentUndFolgen(vposition);
        }
    }

    public ValuePosition[] parentUndFolgen(ValuePosition lvp) throws BusinessDomainException {
        try {
            ValuePosition vp = (ValuePosition)lvp.getParentObject();
            return this.getConsequensesOfValuePosition(vp);
        }
        catch (ClassCastException e) {
            return this.getConsequensesOfValuePosition(lvp);
        }
    }

    private ValuePosition[] getConsequensesOfValuePosition(ValuePosition vp) {
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        vpList.add(vp);
        ValuePosition[] vpArray = this.getValuePositionHistory().getItems(vp);
        vpList.addAll(Arrays.asList(vpArray));
        return vpList.toArray(new ValuePosition[vpList.size()]);
    }

    public ValuePosition[] getFolgen(ValuePosition vposition) throws BusinessDomainException {
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        ValuePosition[] vpArray = this.getValuePositionHistory().getItemsOfParent(vposition);
        vpList.addAll(Arrays.asList(vpArray));
        return vpList.toArray(new ValuePosition[vpList.size()]);
    }

    public boolean pensionszusageOderUnterstutzungskasseAusEGAVorhanden() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()), DateHelper.yesterday((Date)this.mValuePosition.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{145140, 145190}));
        return vpArray.length != 0;
    }

    public boolean vbluAltVertrAusEGAVorhanden() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mCalculationCase.getEffectiveFrom(), DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getEffectiveFrom()), DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{106310, 106320}));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    public boolean vbluNeuVertrAusEGAVorhanden() throws BusinessDomainException {
        boolean result = false;
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mCalculationCase.getEffectiveFrom(), DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getEffectiveFrom()), DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom()), DateHelper.yesterday((Date)this.mCalculationCase.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{106330, 106340}));
        if (vpArray.length != 0) {
            result = true;
        }
        return result;
    }

    public boolean dVPauschalAusEGAVorhanden() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()), DateHelper.yesterday((Date)this.mValuePosition.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{145240}));
        return vpArray.length != 0;
    }

    public boolean pensionskasseAusEGAVorhanden() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()), DateHelper.yesterday((Date)this.mValuePosition.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{145345, 145320}));
        return vpArray.length != 0;
    }

    public boolean pauschaleAusPensionskasseVorhanden() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()), DateHelper.yesterday((Date)this.mValuePosition.getValidFrom()), new ValueType[]{ValueType.getValueType((int)101760)});
        return vpArray.length != 0;
    }

    public boolean pensionsfondAusEGAVorhanden() throws BusinessDomainException {
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfYear((Date)this.mValuePosition.getValidFrom()), DateHelper.yesterday((Date)this.mValuePosition.getValidFrom()), ValueTypeHelper.getValueTypes((int[])new int[]{145395, 145370}));
        return vpArray.length != 0;
    }

    private void ermittleJahreswerteSv(boolean beitragspflichtig) throws BusinessDomainException {
        if (!this.jahreswerteErmittelt) {
            this.jahreswerteErmittelt = true;
            Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.gueltigAb());
            while (DateHelper.beforeOrEqual((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()))) {
                if (this.wertPosition().getEmployee().isContributory(this.wirksamAb(), suchDatum) == beitragspflichtig) {
                    ValuePosition[] vpArray;
                    ValueType[] vtrArray = DateHelper.afterOrEqual((Date)suchDatum, (Date)new VDate(2009, 0, 1).getDate()) ? (DateHelper.afterOrEqual((Date)suchDatum, (Date)new VDate(2012, 0, 1).getDate()) ? ValueTypeHelper.getValueTypes((int[])new int[]{321590, 327590, 333590, 339590, 365590, 773590}) : ValueTypeHelper.getValueTypes((int[])new int[]{321590, 327590, 333590, 339590, 365590})) : ValueTypeHelper.getValueTypes((int[])new int[]{321590, 327590, 333590, 339590});
                    block15: for (ValuePosition valuePosition : vpArray = this.wpAusWPListeOderDB(this.wirksamAb(), this.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), vtrArray)) {
                        switch (valuePosition.getValueType().getValueTypeKey()) {
                            case 321590: {
                                this.aufgelaufeneKvTage = this.aufgelaufeneKvTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgKv = this.aufgelaufeneBbgKv.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgKv = this.aufgelaufeneBbgKv.add(bbg);
                                continue block15;
                            }
                            case 327590: {
                                this.aufgelaufeneRvTage = this.aufgelaufeneRvTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(bbg);
                                continue block15;
                            }
                            case 773590: {
                                this.aufgelaufeneRvTage = this.aufgelaufeneRvTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(bbg);
                                continue block15;
                            }
                            case 333590: {
                                this.aufgelaufeneAvTage = this.aufgelaufeneAvTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgAv = this.aufgelaufeneBbgAv.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgAv = this.aufgelaufeneBbgAv.add(bbg);
                                continue block15;
                            }
                            case 339590: {
                                this.aufgelaufenePvTage = this.aufgelaufenePvTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgPv = this.aufgelaufeneBbgPv.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgPv = this.aufgelaufeneBbgPv.add(bbg);
                                continue block15;
                            }
                            case 365590: {
                                this.aufgelaufeneInsGTage = this.aufgelaufeneInsGTage.add(valuePosition.getFactor1());
                                if (BigDecimalMapper.compareTo((BigDecimal)valuePosition.getFactor1(), (BigDecimal)BigDecimal.valueOf(30L)) == 0) {
                                    this.aufgelaufeneBbgInsG = this.aufgelaufeneBbgInsG.add(BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1());
                                    continue block15;
                                }
                                BigDecimal bbg = BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer2()) ? (BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getPersistentBuffer1()) ? valuePosition.getResult() : valuePosition.getPersistentBuffer1()) : valuePosition.getPersistentBuffer2();
                                this.aufgelaufeneBbgInsG = this.aufgelaufeneBbgInsG.add(bbg);
                                continue block15;
                            }
                            default: {
                                throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), valuePosition.getValueType().getValueTypeKey());
                            }
                        }
                    }
                }
                suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
            }
            EECarriedForwardSystemSI[] vortraege = this.mValuePosition.getEmployee().getEECarriedForwardSystemSI();
            boolean keinVortraegeGefunden = true;
            block16: for (EECarriedForwardSystemSI eECarriedForwardSystemSI : vortraege) {
                SocialInsuranceTP si = SocialInsurancePersistencyManager.getInstance().getSocialInsurance(this.wirksamAb(), eECarriedForwardSystemSI.getValidFrom());
                SocialInsuranceLawArea lSvRechtskreis = null;
                String rk = eECarriedForwardSystemSI.getLawArea();
                lSvRechtskreis = StringMapper.equal((String)rk, (String)"W") ? si.getLawAreaWest() : si.getLawAreaEast();
                if (!DateHelper.between((Date)eECarriedForwardSystemSI.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.gueltigAb()), (Date)DateHelper.getLastDayOfYear((Date)this.gueltigAb()))) continue;
                keinVortraegeGefunden = false;
                if (eECarriedForwardSystemSI.getNumberOfHIDays() != 0) {
                    this.aufgelaufeneKvTage = this.aufgelaufeneKvTage.add(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfHIDays()));
                    this.aufgelaufeneBbgKv = this.aufgelaufeneBbgKv.add(lSvRechtskreis.getMaximumAssessableEarningsForHealthAndNursingInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfHIDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                }
                if (eECarriedForwardSystemSI.getNumberOfPIDays() != 0) {
                    this.aufgelaufeneRvTage = this.aufgelaufeneRvTage.add(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfPIDays()));
                    switch (eECarriedForwardSystemSI.getHealthFund().getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), eECarriedForwardSystemSI.getValidFrom()).getTypeOfHealthFundEnum().value()) {
                        case 6: {
                            if (eECarriedForwardSystemSI.isIncreasedDuesMinersPISheme()) {
                                this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(lSvRechtskreis.getMaximumAssessableEarningsForMinersPensionersInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfPIDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                                break;
                            }
                        }
                        default: {
                            this.aufgelaufeneBbgRv = this.aufgelaufeneBbgRv.add(lSvRechtskreis.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfPIDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                        }
                    }
                }
                if (eECarriedForwardSystemSI.getNumberOfUIDays() != 0) {
                    this.aufgelaufeneAvTage = this.aufgelaufeneAvTage.add(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfUIDays()));
                    this.aufgelaufeneBbgAv = this.aufgelaufeneBbgAv.add(lSvRechtskreis.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfUIDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                }
                if (eECarriedForwardSystemSI.getNumberOfNIDays() != 0) {
                    this.aufgelaufenePvTage = this.aufgelaufenePvTage.add(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfNIDays()));
                    this.aufgelaufeneBbgPv = this.aufgelaufeneBbgPv.add(lSvRechtskreis.getMaximumAssessableEarningsForHealthAndNursingInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfNIDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                }
                if (eECarriedForwardSystemSI.getNumberOfInsGDays() == 0) continue;
                this.aufgelaufeneInsGTage = this.aufgelaufeneInsGTage.add(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfInsGDays()));
                switch (eECarriedForwardSystemSI.getHealthFund().getHealthFundTP(this.mCalculationCase.getEffectiveFrom(), eECarriedForwardSystemSI.getValidFrom()).getTypeOfHealthFundEnum().value()) {
                    case 6: {
                        if (this.mEeLib.marbErhBeitrErmKnappschRV()) {
                            this.aufgelaufeneBbgInsG = this.aufgelaufeneBbgInsG.add(lSvRechtskreis.getMaximumAssessableEarningsForMinersPensionersInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfInsGDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                            continue block16;
                        }
                    }
                    default: {
                        this.aufgelaufeneBbgInsG = this.aufgelaufeneBbgInsG.add(lSvRechtskreis.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance().multiply(BigDecimal.valueOf(eECarriedForwardSystemSI.getNumberOfInsGDays())).divide(DREIHUNDERTSECHZIG, 2, RoundingMode.HALF_UP));
                    }
                }
            }
            if (keinVortraegeGefunden) {
                this.pruefePnrWechsel();
            }
        }
    }

    private void pruefePnrWechsel() throws BusinessDomainException {
        if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)DateHelper.tomorrow((Date)DateHelper.getFirstDayOfYear((Date)this.mCalculationCase.getValidFrom())), (Date)this.mCalculationCase.getValidFrom()) && this.mEeLib.vorherigePNR() != 0) {
            throw EvaluationExceptionMapper.makeNoCFSIAfterChangedPersonalIdAvailable();
        }
    }

    public boolean kennzFuerMaerzklausel() throws BusinessDomainException {
        return this.mValuePosition.getSignedAsClauseOfMarch();
    }

    public ValuePosition naechsteWP() throws BusinessDomainException {
        return this.mCalculationCase.getValuePositionHistory().getNextItemWithSameValuetype(this.mCalculationCase.getValuePositionHistory().getIndex(this.mValuePosition), this.mValuePosition.getValueType(), this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()), DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidUntil()));
    }

    public ValuePosition naechsteWP(ValueType valueType) {
        return this.mCalculationCase.getValuePositionHistory().getNextItemWithSameValuetype(this.mCalculationCase.getValuePositionHistory().getIndex(this.mValuePosition), valueType, this.mValuePosition.getEffectiveFrom(), this.mValuePosition.getEffectiveUntil(), DateHelper.getFirstDayOfMonth((Date)this.mValuePosition.getValidFrom()), DateHelper.getLastDayOfMonth((Date)this.mValuePosition.getValidUntil()));
    }

    public BigDecimal tageMitEFZ() throws BusinessDomainException {
        if (!this.tegeMitEFZErmittelt) {
            EEAbsentTimeTP[] fehlzeiten;
            int index;
            this.tegeMitEFZErmittelt = true;
            this.mTageMitEFZ = BigDecimal.ZERO;
            int[] tage = new int[new VDate(DateHelper.getLastDayOfMonth((Date)this.gueltigAb())).getDay()];
            for (int i = 0; i < tage.length; ++i) {
                tage[i] = 1;
            }
            if (DateHelper.between((Date)this.mEeLib.marbEintritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.gueltigAb()))) {
                index = new VDate(this.mEeLib.marbEintritt()).getDay() - 1;
                for (int i = 0; i < index; ++i) {
                    tage[i] = 0;
                }
            }
            if (this.mEeLib.marbAustritt() != null && DateHelper.between((Date)this.mEeLib.marbAustritt(), (Date)DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.gueltigAb()))) {
                for (index = new VDate(this.mEeLib.marbAustritt()).getDay(); index < tage.length; ++index) {
                    tage[index] = 0;
                }
            }
            for (EEAbsentTimeTP fehlzeit : fehlzeiten = this.mEeLib.aktuelleFehlzeiten()) {
                AbsentTimeTP beschreibung = fehlzeit.getEEAbsentTime().getAbsentTime().getAbsentTimeTP(this.wirksamAb(), this.gueltigAb());
                if (!beschreibung.getCutByPartTimePayPeriod()) continue;
                int beginIndex = 0;
                int endIndex = tage.length - 1;
                if (DateHelper.between((Date)fehlzeit.getValidFrom(), (Date)DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.gueltigAb()))) {
                    beginIndex = new VDate(fehlzeit.getValidFrom()).getDay() - 1;
                }
                if (DateHelper.between((Date)fehlzeit.getValidUntil(), (Date)DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.gueltigAb()))) {
                    endIndex = new VDate(fehlzeit.getValidUntil()).getDay() - 1;
                }
                while (beginIndex <= endIndex) {
                    tage[beginIndex] = 0;
                    ++beginIndex;
                }
            }
            int anzahlTage = 0;
            for (int i : tage) {
                anzahlTage += i;
            }
            this.mTageMitEFZ = BigDecimal.valueOf(anzahlTage);
        }
        return this.mTageMitEFZ;
    }

    public void pruefeEigenschaft(ValuePosition vp, MKPosition mk) throws BusinessDomainException {
        ValuePosition[] vpArray;
        block8: for (ValuePosition valuePosition : vpArray = this.getValuePositionHistory().getItems(vp.getGenesisOfParentObjects())) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 109290: {
                    mk.setAtzEga109290Gesetzlich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109310: {
                    mk.setAtzEga109310Vertraglich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109330: {
                    mk.setAtzEga109330Gesetzlich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109340: {
                    mk.setAtzEga109340Gesetzlich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109360: {
                    mk.setAtzEga109360Vertraglich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109370: {
                    mk.setAtzEga109370Vertraglich(true);
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
            }
        }
    }

    public void pruefeUmlageEntgelt(MKPosition mk) throws BusinessDomainException {
        ValuePosition umlagepflicht = this.folgeWertartVomGenesis(mk.getGenesisVP().getGenesisOfParentObjects(), 135400);
        if (umlagepflicht != null) {
            mk.setHatUmlage(true);
        }
    }

    public void pruefeEigenschaft(ValuePosition vp) throws BusinessDomainException {
        ValuePosition[] vpArray;
        block8: for (ValuePosition valuePosition : vpArray = this.getValuePositionHistory().getItems(vp.getGenesisOfParentObjects())) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 109290: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109310: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109330: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109360: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109340: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
                case 109370: {
                    this.loescheWertPosition(valuePosition);
                    continue block8;
                }
            }
        }
    }

    public boolean aus37b() throws BusinessDomainException {
        ValuePosition genesis = this.genesisParent();
        return this.aus37b(genesis);
    }

    public boolean aus37b(ValuePosition genesis) throws BusinessDomainException {
        ValueTypeTP vttp;
        CategoryEnum category;
        ValueType vt;
        boolean is37b = false;
        if (genesis != null && (vt = genesis.getValueType()) != null && (category = (vttp = vt.getValueTypeTP(this.wirksamAb(), this.gueltigAb())).getValueTypeFoundation().getGeneral().getCategory()) == CategoryEnum.CE_Bruttosachbezug_AG_37b_EStG) {
            is37b = true;
        }
        return is37b;
    }

    public BigDecimal akkordlohnRuestzeit() throws BusinessDomainException {
        return this.mValuePosition.getSetupTimeAndUnit();
    }

    public BigDecimal akkordlohnGutmenge() throws BusinessDomainException {
        return this.mValuePosition.getYield();
    }

    public BigDecimal akkordlohnVorgabe() throws BusinessDomainException {
        return this.mValuePosition.getTargetOfTimeAndUnit();
    }

    public void akkordlohnGesamtVorgabe(BigDecimal gesamtVorgabe) throws BusinessDomainException {
        this.mValuePosition.setTotalTarget(gesamtVorgabe);
    }

    public void akkordlohnZeitgrad(BigDecimal zeitgrad) throws BusinessDomainException {
        this.mValuePosition.setRateOfLaborUtilisation(zeitgrad);
    }

    public CostCenter kostenstelle() throws BusinessDomainException {
        return this.mValuePosition.getCostCenter();
    }

    public EEPensionSchemeTP getGenesisEEPensionSchemeTP(ValuePosition vPos) throws BusinessDomainException {
        ValuePosition genesisParent = (ValuePosition)vPos.getGenesisOfParentObjects();
        EEPensionSchemeTP eePSTp = (EEPensionSchemeTP)genesisParent.getGenesisOfParentObjects();
        try {
            eePSTp.requireLoaded();
        }
        catch (IncorrectResultSizeDataAccessException e) {
            eePSTp.unload();
            EEPensionScheme eePS = (EEPensionScheme)genesisParent.getRootGenesisOfParentObjects();
            eePSTp = eePS.getEEPensionSchemeTP(vPos.getEffectiveFrom(), vPos.getValidFrom());
        }
        return eePSTp;
    }

    public BigDecimal checkBAVAGLeistungen(BigDecimal foerderbetrag) throws BusinessDomainException {
        BigDecimal jahreswert;
        BigDecimal maxBetrag;
        BigDecimal grenzwert;
        BigDecimal betrag = BigDecimal.ZERO;
        if (DateHelper.afterOrEqual((Date)this.gueltigAb(), (Date)new VDate(2020, 0, 1).getDate())) {
            grenzwert = BigDecimal.valueOf(2575L);
            maxBetrag = BigDecimal.valueOf(960L);
        } else {
            grenzwert = BigDecimal.valueOf(2200L);
            maxBetrag = BigDecimal.valueOf(480L);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.getSteuerpflichtigesEntgeltDesMonats(), (BigDecimal)grenzwert) <= 0 && BigDecimalMapper.compareTo((BigDecimal)(betrag = foerderbetrag).add(jahreswert = this.holeAufgelaufeneJahreswerte()), (BigDecimal)maxBetrag) >= 0) {
            betrag = maxBetrag.subtract(jahreswert);
            if (BigDecimalMapper.compareTo((BigDecimal)betrag, (BigDecimal)BigDecimal.ZERO) <= 0) {
                betrag = BigDecimal.ZERO;
            }
            new CalculationBasic(this.mCalculationCase.getEmployee(), this.mCalculationCase.getEffectiveFrom(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)this.mCalculationCase.getValidFrom())), ((Object)((Object)this.mCalculationCase)).getClass().getName());
        }
        return betrag;
    }

    public BigDecimal getSteuerpflichtigesEntgeltDesMonats() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal entgelt = BigDecimal.ZERO;
        for (ValuePosition vp : vpArray = this.wpAusWPListeOderDB(this.wirksamAb(), this.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{101650, 101660, 101670, 101680, 110510}))) {
            entgelt = entgelt.add(vp.getResult());
        }
        return entgelt;
    }

    private BigDecimal holeAufgelaufeneJahreswerte() throws BusinessDomainException {
        BigDecimal jahreswert = BigDecimal.ZERO;
        Date suchdatum = DateHelper.getFirstDayOfYear((Date)this.gueltigAb());
        while (DateHelper.before((Date)suchdatum, (Date)DateHelper.getLastDayOfMonth((Date)this.gueltigAb()))) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = this.wpAusWPListeOderDB(this.wirksamAb(), this.wirksamAb(), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes((int[])new int[]{145516, 145515}))) {
                jahreswert = jahreswert.add(vPos.getPersistentBuffer2());
            }
            suchdatum = new VDate(suchdatum).addMonths(1).getDate();
        }
        return jahreswert;
    }

    public BigDecimal hochrechnungGleitzonenEntgeltBeiLZZ(BigDecimal entgelt, BigDecimal kvTage) throws BusinessDomainException {
        BigDecimal result;
        if (StringMapper.equal((String)this.mEeLib.marb().getObjectid(), (String)"637773410565632772") && StringMapper.equal((String)this.mEeLib.marbFirma().getObjectid(), (String)"13622910718811422")) {
            BigDecimal anzKalenderTage = BigDecimal.valueOf(new VDate(DateHelper.getLastDayOfMonth((Date)this.gueltigAb())).getDay());
            result = entgelt.multiply(anzKalenderTage).divide(kvTage, 2, RoundingMode.HALF_UP);
        } else {
            result = entgelt.multiply(BigDecimal.valueOf(30L)).divide(kvTage, 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public BigDecimal kuerzungGleitzonenEntgeltBeiLZZ(BigDecimal entgelt, BigDecimal kvTage) throws BusinessDomainException {
        BigDecimal result;
        if (StringMapper.equal((String)this.mEeLib.marb().getObjectid(), (String)"637773410565632772") && StringMapper.equal((String)this.mEeLib.marbFirma().getObjectid(), (String)"13622910718811422")) {
            BigDecimal anzKalenderTage = BigDecimal.valueOf(new VDate(DateHelper.getLastDayOfMonth((Date)this.gueltigAb())).getDay());
            result = entgelt.multiply(kvTage).divide(anzKalenderTage, 2, RoundingMode.HALF_UP);
        } else {
            result = entgelt.multiply(kvTage).divide(BigDecimal.valueOf(30L), 2, RoundingMode.HALF_UP);
        }
        return result;
    }

    public void setze99991Zurueck() throws BusinessDomainException {
        if (!this.mCalculationCase.hatZvkDiffVorjahrResetDurchgefuehrt()) {
            ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.wirksamAb(), this.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{99991}));
            if (vpArray.length > 0) {
                for (ValuePosition vpos : vpArray) {
                    if (vpos == null || vpos.getGenesisOfParentObjects() instanceof VarPaymentTP) continue;
                    for (ValuePosition vp : vpArray = this.genesisUndFolgen(vpos)) {
                        vp.setResult(BigDecimal.ZERO);
                        this.loescheWertPosition(vp);
                    }
                    this.addNeueWertPosition(99991, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, this.mCalculationCase.getCalculation());
                }
            }
            this.mCalculationCase.resetValuepositionHistoryIndex();
            this.mCalculationCase.setZvkDiffVorjahrReset(false);
            this.mCalculationCase.setZvkDiffVorjahrResetDurchgefuehrt(true);
        }
    }

    public void setze99997Zurueck() throws BusinessDomainException {
        ValuePosition steuerDiffVP;
        ValuePosition[] vpArray = this.wpAusWPListeOderDB(this.wirksamAb(), this.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{99997}));
        if (vpArray.length > 0 && (steuerDiffVP = vpArray[0]) != null) {
            for (ValuePosition vp : vpArray = this.genesisUndFolgen(steuerDiffVP)) {
                vp.setResult(BigDecimal.ZERO);
                this.loescheWertPosition(vp);
            }
            this.addNeueWertPosition(99997, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, true, this.mCalculationCase.getCalculation());
        }
    }
}

