/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasic;
import com.varial.personnel.domain.employee.insurance.ContributionScaleVNIEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.formula.ErmittlungSVEntgeltMfBFormula;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungPVEntgeltLfdFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mGesPVEntgeltBeideAG = BigDecimal.ZERO;
    private BigDecimal mPvBBGohneMfB = BigDecimal.ZERO;
    private boolean mBehindertenAbrechnung100AGA = false;
    private boolean mIs100ProzentAG = false;

    public ErmittlungPVEntgeltLfdFormula(CalculationLibrary callib, EmployeeLibrary eelib, GlobalLibrary gllib, ValuePositionLibrary wplib) {
        this.mCalLib = callib;
        this.mEeLib = eelib;
        this.mGlLib = gllib;
        this.mVpLib = wplib;
    }

    public void ermittel() throws BusinessDomainException {
        BigDecimal pvTage = this.mVpLib.pvTageMarbLfd();
        BigDecimal pvEntgeltLfd = BigDecimal.ZERO;
        BigDecimal pvBbg = BigDecimal.ZERO;
        BigDecimal tempPvBBG = BigDecimal.ZERO;
        if (this.mVpLib.wertartenNummer() == 339740 || this.mVpLib.wertartenNummer() == 771100 || this.mVpLib.wertartenNummer() == 771200) {
            this.mIs100ProzentAG = true;
        }
        if (this.mEeLib.isMehrfachbeschaeftigt() && (this.mEeLib.marbBgrPvAndererAG() == 1 || this.mEeLib.marbPPVv())) {
            BigDecimal dbbgKVEntgelt = BigDecimal.ZERO;
            if (this.mCalLib.dbbgVorhanden()) {
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    if (StringMapper.compareTo((String)this.mCalLib.dbbgKVLBBG(), (String)"J") == 0) {
                        dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                    }
                } else {
                    dbbgKVEntgelt = this.mCalLib.dbbgGAEGKV();
                }
            }
            pvBbg = this.pvBbgBeiBeitragsteilung(pvTage, dbbgKVEntgelt);
            this.mVpLib.addNeueWertPosition(339590, BigDecimal.ZERO, BigDecimal.ZERO, pvTage, BigDecimal.ZERO, pvBbg, true, this.mPvBBGohneMfB, this.mGesPVEntgeltBeideAG, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            if (DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())) && this.mCalLib.getCalculationCase().isSVTageUnterbrechungEvaluated()) {
                tempPvBBG = this.pvRestBbgBeiBeitragsteilung(this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), dbbgKVEntgelt);
                this.mVpLib.addNeueWertPosition(339591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, tempPvBBG, true);
            }
        } else {
            block0 : switch (this.mEeLib.marbBgrPv()) {
                case 0: {
                    pvBbg = this.mGlLib.svBbgKvPv().multiply(this.mVpLib.svTageLfd()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    break;
                }
                default: {
                    switch (this.mEeLib.marbBgrKv()) {
                        case 0: 
                        case 9: {
                            pvBbg = this.mGlLib.svBbgKvPv().multiply(this.mVpLib.svTageLfd()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                            break block0;
                        }
                    }
                    pvBbg = this.mGlLib.svBbgKvPv().multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    this.mVpLib.addNeueWertPosition(339590, BigDecimal.ZERO, BigDecimal.ZERO, pvTage, BigDecimal.ZERO, pvBbg, true, pvBbg, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
                    if (!DateHelper.between((Date)this.mVpLib.gueltigAb(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), (Date)DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb())) || !this.mCalLib.getCalculationCase().isSVTageUnterbrechungEvaluated()) break;
                    tempPvBBG = this.mGlLib.svBbgKvPv().multiply(this.mCalLib.getCalculationCase().getSVTageUnterbrechung()).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                    this.mVpLib.addNeueWertPosition(339591, BigDecimal.ZERO, BigDecimal.ZERO, this.mCalLib.getCalculationCase().getSVTageUnterbrechung(), BigDecimal.ZERO, tempPvBBG, true);
                }
            }
        }
        BigDecimal bisherErmitteltesPVEntgeltLfd = BigDecimal.ZERO;
        if (pvBbg.compareTo(BigDecimal.ZERO) == 0) {
            pvEntgeltLfd = BigDecimal.ZERO;
            this.mCalLib.result(pvEntgeltLfd);
            this.mCalLib.factor1(pvTage);
            this.mCalLib.summeErgebnisseAlsBasisFuerDifferenzbildung(bisherErmitteltesPVEntgeltLfd);
            return;
        }
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{339510, 339700, 339740, 130510, 130540}));
        boolean hatEntgeltFiktiv100AG = false;
        BigDecimal gesamtesEntgelt = BigDecimal.ZERO;
        for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130540: {
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)valuePosition.getResult())) {
                        hatEntgeltFiktiv100AG = true;
                    }
                }
                case 130510: {
                    gesamtesEntgelt = gesamtesEntgelt.add(valuePosition.getResult());
                }
            }
        }
        pvEntgeltLfd = this.mVpLib.wertartenNummer() != 771190 && this.mVpLib.wertartenNummer() != 771090 ? (hatEntgeltFiktiv100AG && gesamtesEntgelt.compareTo(pvBbg) > 0 ? this.getEntgeltAufBasisGesamtEntgelt(vpArray, pvBbg) : this.getEntgeltAufBasisPVEntgelt(vpArray, pvBbg)) : this.mVpLib.result();
        this.mCalLib.result(pvEntgeltLfd);
        this.mCalLib.factor1(pvTage);
        boolean isGrvImLimit = false;
        if (this.mEeLib.isMarbGeringverdiener()) {
            ValuePosition[] vPArray;
            isGrvImLimit = true;
            BigDecimal lfdPVEntgeltImMonat = BigDecimal.ZERO;
            for (ValuePosition lElement : vPArray = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
                if (this.mVpLib.wertartenNummer() != lElement.getValueType().getValueTypeKey() || (lfdPVEntgeltImMonat = lfdPVEntgeltImMonat.add(lElement.getResult())).compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0) continue;
                isGrvImLimit = false;
            }
        }
        if (this.mEeLib.isBehinderterMA()) {
            BigDecimal percentage = this.mVpLib.prozentsatz();
            switch (this.mEeLib.marbBgrPv()) {
                case 1: 
                case 2: {
                    if (BigDecimalMapper.compareTo((BigDecimal)percentage, (BigDecimal)BigDecimal.valueOf(100L)) == 0) {
                        this.mBehindertenAbrechnung100AGA = true;
                        if (this.mVpLib.wertartenNummer() == 339700 && DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2024, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(341740, pvEntgeltLfd);
                        } else {
                            this.mVpLib.addNeueWertPosition(341520, pvEntgeltLfd);
                        }
                        if (this.mEeLib.marbPgs() == 111) break;
                        this.erzeugeZusatzbeitrag(pvEntgeltLfd);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(340510, pvEntgeltLfd);
                    this.mVpLib.addNeueWertPosition(341510, pvEntgeltLfd);
                    if (this.mEeLib.marbPgs() == 111) break;
                    this.erzeugeZusatzbeitrag(pvEntgeltLfd);
                }
            }
        } else if (this.mIs100ProzentAG) {
            switch (this.mEeLib.marbBgrPv()) {
                case 1: 
                case 2: {
                    ValuePosition genesis;
                    if (this.mEeLib.marbBklFPv() != ContributionScaleVNIEnum.CSVNIE_KEINE) break;
                    this.mVpLib.addNeueWertPosition(341740, pvEntgeltLfd);
                    if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2020, 11, 1).getDate()) || (genesis = this.mVpLib.genesisParent()) == null || genesis.getValueType().getValueTypeKey() != 99973) break;
                    this.erzeugeZusatzbeitrag(pvEntgeltLfd);
                }
            }
        } else if ((this.mEeLib.marbBgrPv() == 1 || this.mEeLib.marbBgrPv() == 2) && this.mEeLib.marbBklFPv() == ContributionScaleVNIEnum.CSVNIE_KEINE) {
            if (!this.is100ProzentAGA(isGrvImLimit)) {
                this.mVpLib.addNeueWertPosition(340510, pvEntgeltLfd);
                this.erzeugeZusatzbeitrag(pvEntgeltLfd);
                this.mVpLib.addNeueWertPosition(341510, pvEntgeltLfd);
            } else {
                this.mVpLib.addNeueWertPosition(341520, pvEntgeltLfd);
            }
        }
    }

    private boolean is100ProzentAGA(boolean GrV_im_Limit) throws BusinessDomainException {
        boolean is100ProzentAGA = false;
        switch (this.mEeLib.marbPgs()) {
            case 121: {
                is100ProzentAGA = true;
                break;
            }
            case 122: {
                if (!this.mEeLib.isPGS122Geringverdiener()) break;
                is100ProzentAGA = true;
                break;
            }
            default: {
                if (!GrV_im_Limit && !this.mEeLib.isBufdi()) break;
                is100ProzentAGA = true;
            }
        }
        return is100ProzentAGA;
    }

    private BigDecimal getEntgeltAufBasisPVEntgelt(ValuePosition[] vpArray, BigDecimal pvBbg) throws BusinessDomainException {
        BigDecimal pvEntgeltLfd;
        BigDecimal bisherErmitteltesPVEntgeltLfd = BigDecimal.ZERO;
        for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 339510: 
                case 339700: 
                case 339740: {
                    bisherErmitteltesPVEntgeltLfd = bisherErmitteltesPVEntgeltLfd.add(valuePosition.getResult());
                }
            }
        }
        if (this.mVpLib.result().compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal ueberBBG = BigDecimal.ZERO;
            for (ValuePosition lElement : vpArray) {
                if (lElement.getBufferResult() == null) continue;
                ueberBBG = ueberBBG.add(lElement.getBufferResult());
            }
            if (ueberBBG.compareTo(this.mVpLib.result().negate()) > 0) {
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
                this.mVpLib.result(BigDecimal.ZERO);
            } else {
                this.mVpLib.wertPosition().setBufferResult(ueberBBG.negate());
                this.mVpLib.result(this.mVpLib.result().add(ueberBBG));
            }
        }
        if ((bisherErmitteltesPVEntgeltLfd = bisherErmitteltesPVEntgeltLfd.add(this.mVpLib.result())).compareTo(pvBbg) <= 0) {
            pvEntgeltLfd = this.mVpLib.result();
        } else {
            BigDecimal differenz = bisherErmitteltesPVEntgeltLfd.subtract(pvBbg);
            if (differenz.compareTo(this.mVpLib.result()) < 0) {
                pvEntgeltLfd = this.mVpLib.result().subtract(differenz);
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result().subtract(pvEntgeltLfd));
            } else {
                pvEntgeltLfd = BigDecimal.ZERO;
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
            }
        }
        this.mCalLib.summeErgebnisseAlsBasisFuerDifferenzbildung(bisherErmitteltesPVEntgeltLfd);
        return pvEntgeltLfd;
    }

    private BigDecimal getEntgeltAufBasisGesamtEntgelt(ValuePosition[] vpArray, BigDecimal pvBbg) throws BusinessDomainException {
        BigDecimal bisherErmitteltesEntgeltLfd = BigDecimal.ZERO;
        BigDecimal bisherErmitteltesEntgeltLfd100AG = BigDecimal.ZERO;
        block4: for (ValuePosition valuePosition : vpArray) {
            switch (valuePosition.getValueType().getValueTypeKey()) {
                case 130510: {
                    bisherErmitteltesEntgeltLfd = bisherErmitteltesEntgeltLfd.add(valuePosition.getResult());
                    continue block4;
                }
                case 130540: {
                    bisherErmitteltesEntgeltLfd100AG = bisherErmitteltesEntgeltLfd100AG.add(valuePosition.getResult());
                }
            }
        }
        BigDecimal gesamtEntgelt = bisherErmitteltesEntgeltLfd.add(bisherErmitteltesEntgeltLfd100AG);
        BigDecimal aufgelaufenesGesEntgelt = this.mVpLib.result().add(this.mVpLib.wertPosition().getBufferField01());
        BigDecimal pvEntgeltLfd = aufgelaufenesGesEntgelt.multiply(pvBbg).divide(gesamtEntgelt, 2, RoundingMode.HALF_UP);
        BigDecimal aufgelaufenesAnteilEntgelt = this.mVpLib.wertPosition().getBufferField02();
        this.uebergabeWerte(aufgelaufenesGesEntgelt, pvEntgeltLfd);
        pvEntgeltLfd = pvEntgeltLfd.subtract(aufgelaufenesAnteilEntgelt);
        return pvEntgeltLfd;
    }

    private void uebergabeWerte(BigDecimal aufgelaufenesGesEntgelt, BigDecimal aufgelaufenesAnteilEntgelt) throws BusinessDomainException {
        ValuePosition nextVp = this.mVpLib.naechsteWP();
        if (nextVp != null) {
            nextVp.setBufferField01(aufgelaufenesGesEntgelt);
            nextVp.setBufferField02(aufgelaufenesAnteilEntgelt);
        }
    }

    private void erzeugeZusatzbeitrag(BigDecimal pvEntgeltLfd) throws BusinessDomainException {
        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 0, 1).getDate())) {
            if (this.mEeLib.marbAelterDreiUndZwanzig() && DateHelper.afterOrEqual((Date)this.mEeLib.marbGeburtstag(), (Date)new VDate(1940, 0, 1).getDate())) {
                if (!this.mEeLib.isMarbKindErz()) {
                    if (this.mEeLib.isUebernahmePVZuschlag() && this.mBehindertenAbrechnung100AGA) {
                        if (this.mVpLib.wertartenNummer() == 339700 && DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2024, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(341741, pvEntgeltLfd);
                        } else {
                            this.mVpLib.addNeueWertPosition(341516, pvEntgeltLfd);
                        }
                    } else if (!this.hatKeinEntgelt()) {
                        this.mVpLib.addNeueWertPosition(340516, pvEntgeltLfd);
                    }
                }
            } else if (!this.mEeLib.marbAelterDreiUndZwanzig()) {
                new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)new VDate(this.mEeLib.marbGeburtstag()).addYears(23).getDate())), "erreichen des 23. Lebensjahres f\u00fcr PV Zusatzbeitrag");
            }
        } else if (!this.mEeLib.marbAelterDreiUndZwanzig()) {
            new CalculationBasic(this.mEeLib.marb(), this.mVpLib.wirksamAb(), new VDate(2005, 0, 1).getDate(), "Zusatzbeitrag PV");
        }
    }

    private boolean hatKeinEntgelt() throws BusinessDomainException {
        ValuePosition[] vps;
        return this.mEeLib.marbPgs() == 107 && (vps = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), this.mVpLib.gueltigAb(), this.mVpLib.gueltigBis(), ValueTypeHelper.getValueTypes((int[])new int[]{99993}))).length > 0;
    }

    private BigDecimal pvBbgBeiBeitragsteilung(BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        BigDecimal pvBbg = BigDecimal.ZERO;
        pvBbg = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) ? this.pvBBGBeiBeitragsteilung2013(pvTage, dbbgKVEntgelt) : this.pvBBGBeiBeitragsteilung(pvTage, dbbgKVEntgelt);
        return pvBbg;
    }

    private BigDecimal pvRestBbgBeiBeitragsteilung(BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        BigDecimal tempPvBBG = BigDecimal.ZERO;
        tempPvBBG = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) ? this.pvRestBBGBeiBeitragsteilung2013(pvTage, dbbgKVEntgelt) : this.pvBBGBeiBeitragsteilung(pvTage, dbbgKVEntgelt);
        return tempPvBBG;
    }

    private BigDecimal pvBBGBeiBeitragsteilung2013(BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        return this.pvBBGBeiBeitragsteilung(pvTage, dbbgKVEntgelt);
    }

    private BigDecimal pvBBGBeiBeitragsteilung(BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        BigDecimal svBBG = this.mGlLib.svBbgKvPv();
        this.mPvBBGohneMfB = svBBG.multiply(pvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getBBGBeiBeitragsteilungEigenerRK(svBBG, pvTage, dbbgKVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(339595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        this.mGesPVEntgeltBeideAG = sVEntgeltMfBDatas.getGesEntgeltBeideAG();
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }

    private BigDecimal pvRestBBGBeiBeitragsteilung2013(BigDecimal pvTage, BigDecimal dbbgKVEntgelt) throws BusinessDomainException {
        ErmittlungSVEntgeltMfBFormula formula = new ErmittlungSVEntgeltMfBFormula(this.mCalLib, this.mVpLib);
        BigDecimal pvBBG = this.mGlLib.svBbgKvPv();
        ErmittlungSVEntgeltMfBFormula.SVEntgeltMfBDatas sVEntgeltMfBDatas = formula.getRestBBGBeiBeitragsteilungEigenerRK2013(pvBBG, pvTage, dbbgKVEntgelt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)sVEntgeltMfBDatas.getEntgeltLfdAndererAG())) {
            this.mVpLib.addNeueWertPosition(339595, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, sVEntgeltMfBDatas.getEntgeltLfdAndererAG(), true);
        }
        return sVEntgeltMfBDatas.getAnteiligeBBGAktuellerAG();
    }
}

