/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.EvaluationFormula;
import com.varial.personnel.domain.evaluation.formula.KVBeitragsermittlungPrivatFormula;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.libraryimpl.CalculationLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.EmployeeLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.GlobalLibraryImpl;
import com.varial.personnel.domain.evaluation.libraryimpl.IGlobalLibraryImplFactory;
import com.varial.personnel.domain.evaluation.libraryimpl.ValuePositionLibraryImpl;
import java.math.BigDecimal;

public class KVBeitragsermittlungPrivat
implements EvaluationFormula {
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private BigDecimal berechnungsgrundlageAlt = ZERO;
    private BigDecimal berechnungsgrundlageNeu = ZERO;
    private BigDecimal kvZuschussAlt = ZERO;
    private BigDecimal kvZuschussVollAlt = ZERO;
    private BigDecimal kvZuschussNeu = ZERO;
    private BigDecimal kvZuschussVollNeu = ZERO;

    public void evaluate(ValuePosition vPos, CalculationCase cCase) throws BusinessDomainException {
        CalculationLibraryImpl calLibraryImpl = new CalculationLibraryImpl(vPos, cCase);
        EmployeeLibraryImpl eeLibraryImpl = new EmployeeLibraryImpl(vPos, cCase);
        GlobalLibraryImpl glLibraryImpl = ((IGlobalLibraryImplFactory)UtilitiesManager.getBean((String)"globalLibraryImplFactory", IGlobalLibraryImplFactory.class)).create(vPos, cCase, (EmployeeLibrary)eeLibraryImpl);
        ValuePositionLibraryImpl wpLibraryImpl = new ValuePositionLibraryImpl(vPos, cCase, eeLibraryImpl);
        this.berechnungsgrundlageAlt = vPos.getSumOfBasicResult();
        this.kvZuschussAlt = vPos.getSumOfResult();
        this.kvZuschussVollAlt = vPos.getPersistentBuffer1();
        this.berechnungsgrundlageNeu = this.berechnungsgrundlageAlt.add(vPos.getResult());
        calLibraryImpl.kvEntgelt(this.berechnungsgrundlageNeu);
        new KVBeitragsermittlungPrivatFormula(calLibraryImpl, eeLibraryImpl, (GlobalLibrary)glLibraryImpl, wpLibraryImpl).kvBeitragsermittlung();
        this.kvZuschussNeu = calLibraryImpl.kvAGZ();
        this.kvZuschussVollNeu = calLibraryImpl.getResultVM();
        vPos.setResult(this.kvZuschussNeu.subtract(this.kvZuschussAlt));
        vPos.setPersistentBuffer1(this.kvZuschussVollNeu.subtract(this.kvZuschussVollAlt));
        vPos.setPercentage(calLibraryImpl.percentage());
        ValuePosition nextVP = wpLibraryImpl.naechsteWP();
        if (nextVP != null) {
            nextVP.setSumOfBasicResult(this.berechnungsgrundlageNeu);
            nextVP.setSumOfResult(this.kvZuschussNeu);
            nextVP.setPersistentBuffer1(this.kvZuschussVollNeu);
        }
    }
}

