/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.eubp.EubpHelper;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.account.EubpAccountStateEnum;
import com.varial.personnel.domain.eubp.basics.BasicRecord;
import com.varial.personnel.domain.eubp.dsst.EubpDsst;
import com.varial.personnel.domain.eubp.dsst.EubpDsstPersistencyManager;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;
import com.varial.personnel.domain.eubp.receive.EubpAccountMap;
import com.varial.personnel.domain.eubp.receive.EubpDbfesCreator;
import com.varial.personnel.domain.eubp.receive.EubpResponse;
import com.varial.personnel.domain.eubp.receive.dsgm.EubpDsgm;
import com.varial.personnel.domain.eubp.receive.dsgm.EubpDsgmPart;
import com.varial.personnel.domain.eubp.receive.dssm.EubpDssm;
import com.varial.personnel.domain.eubp.receive.dsum.EubpDsum;
import com.varial.personnel.domain.eubp.receive.dsum.EubpDsumPart;
import com.varial.personnel.domain.eubp.receive.ncsz.EubpNcsz;
import com.varial.personnel.domain.eubp.receive.vosz.EubpVosz;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EubpResponseCreator {
    public static final Pattern VOSZ_PATTERN = Pattern.compile("VOSZRVBPL(.{15})(.{15})(\\d{8})(\\d{6})(.{50})(\\d{2})(.*)");
    public static final Pattern DSSM_PATTERN_04 = Pattern.compile("DSSMEUBP (.{15})(.{15})(04)(\\d{17})(\\d{1})(\\d{1})(\\d{6})(.{8})(.{50})(.{3})(.{150})(.{1})(.*)");
    public static final Pattern DSSM_PATTERN_05 = Pattern.compile("DSSMEUBP (.{15})(.{15})(05)(\\d{17})(\\d{1})(\\d{1})(\\d{6})(.{8})(.{15})(.{50})(.{3})(.{150})(.{1})(.*)");
    private static final Pattern DSGM_PATTERN = Pattern.compile("DSGMEUBP (.{15})(.{15})(\\d{2})(\\d{17})(\\d{1})(\\d{1})(.{15})(.{100})(.{20})(.{12})(.{30})(.{30})(.{30})(\\d{8})(\\d{3})(.*)");
    private static final Pattern DSGM_PART_PATTERN = Pattern.compile("(\\d{8})(\\d{8})(\\d{1})(\\d{1})(\\d{1})(\\d{1})(.{15})(.{1})(\\d{10})(.{1})(\\d{10})(.*)");
    private static final Pattern DSUM_PATTERN = Pattern.compile("DSUMEUBP (.{15})(.{15})(\\d{2})(\\d{17})(\\d{1})(\\d{1})(.{15})(.{12})(.{30})(.{30})(.{30})(\\d{8})(\\d{3})(.*)");
    private static final Pattern DSUM_PART_PATTERN = Pattern.compile("(.{32})(.{20})(\\d{8})(\\d{8})(.{1})(\\d{10})(.{1})(\\d{10})(\\d{1})(\\d{1})(\\d{1})(\\d{1})(.{15})(\\d{3})(\\d{2})(.{9})(.{1})(.{1})(.{1})(.{1})(.{3})(.*)");
    private static final Pattern NCSZ_PATTERN = Pattern.compile("NCSZRVBPL(.{15})(.{15})(\\d{8})(\\d{6})(\\d{8})(\\d{2})(.*)");
    private final SimpleDateFormat mDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
    private final EubpResponse mEubpResponse;
    private final int mDateinummer;

    public EubpResponseCreator(File file, EubpAccountMap eubpAccountMap, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        this.mDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.mEubpResponse = new EubpResponse(file.getPath());
        this.mDateinummer = EubpHelper.getFileNumber((File)file);
        int lineNo = 1;
        String line = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), BasicReceive.ISO_8859_1));){
            while ((line = reader.readLine()) != null) {
                this.executeLine(line);
                ++lineNo;
            }
        }
        catch (IOException e) {
            throw EubpExceptionMapper.makeFileReadError(file.getPath(), lineNo, e);
        }
        catch (BusinessDomainException e) {
            throw EubpExceptionMapper.makeFileReadError(file.getPath(), lineNo, line, e);
        }
        this.mEubpResponse.check();
        EubpDssm dssm = this.mEubpResponse.getDssm();
        if (dssm != null) {
            dssm.setAktenzeichenAbsender(line);
            int dateinummer = dssm.getDateinummer();
            EubpDsst eubpDsst = this.getEubpDsst(file, dateinummer, deuvRecipient);
            EubpAccount eubpAccount = eubpAccountMap.getEubpAccount(eubpDsst);
            eubpAccount.makeSaveable();
            eubpDsst = eubpAccount.getDsst(eubpDsst.getObjectid());
            eubpAccount.calculateStatus();
            eubpDsst.setAdviceState(EubpAccountStateEnum.VERARBEITET);
            eubpDsst.clearFehler();
        }
    }

    private EubpDsst getEubpDsst(File file, int filenumber, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        EubpDsst[] eubpDssts = EubpDsstPersistencyManager.getInstance().query(null, Restrictions.and((Criterion)Restrictions.eq((String)"FILENUMBER", (String)Integer.toString(filenumber)), (Criterion)Restrictions.sqlRestriction((String)"OIDEUBPACCOUNT IN (SELECT OBJECTID FROM EUBPACCOUNT_T WHERE OIDDEUVRECIPIENT = ?)", (String)deuvRecipient.getObjectid())), true);
        if (eubpDssts.length == 0) {
            throw EubpExceptionMapper.makeEubpDsstNotFound(file, filenumber);
        }
        if (eubpDssts.length > 1) {
            throw EubpExceptionMapper.makeMultipleEubpDsstsFound(file, filenumber);
        }
        return eubpDssts[0];
    }

    public EubpResponse getEubpResponse() {
        return this.mEubpResponse;
    }

    private void executeLine(String line) throws BusinessDomainException {
        String satzart;
        if (line.length() < 4) {
            throw EubpExceptionMapper.makeLineTooShort();
        }
        switch (satzart = line.substring(0, 4)) {
            case "VOSZ": {
                this.executeVOSZ(line);
                break;
            }
            case "DSSM": {
                this.executeDSSM(line);
                break;
            }
            case "DSGM": {
                this.executeDSGM(line);
                break;
            }
            case "DSUM": {
                this.executeDSUM(line);
                break;
            }
            case "NCSZ": {
                this.executeNCSZ(line);
                break;
            }
            default: {
                throw EubpExceptionMapper.makeUnknownPrefix(satzart);
            }
        }
    }

    private void executeVOSZ(String line) throws BusinessDomainException {
        Matcher matcher = EubpResponseCreator.getMatcher(line, VOSZ_PATTERN);
        String absendernummer = EubpResponseCreator.toString(matcher, 1);
        String empfaengernummer = EubpResponseCreator.toString(matcher, 2);
        Date datumErstellung = EubpResponseCreator.toDate(matcher, 3);
        String nameAbsender = EubpResponseCreator.toString(matcher, 5);
        int versionsnummer = EubpResponseCreator.toInt(matcher, 6);
        String rest = EubpResponseCreator.toStringNoTrim(matcher, 7);
        EubpVosz vosz = new EubpVosz();
        vosz.setAbsendernummer(absendernummer);
        vosz.setEmpfaengernummer(empfaengernummer);
        vosz.setDatumErstellung(datumErstellung);
        vosz.setDateinummer(this.mDateinummer);
        vosz.setNameAbsender(nameAbsender);
        vosz.setVersionsnummer(versionsnummer);
        vosz.setDbfes(new EubpDbfesCreator(rest).getDbfes());
        if (this.mEubpResponse.getVosz() != null) {
            throw EubpExceptionMapper.makeMultipleDatasetsFound("VOSZ");
        }
        this.mEubpResponse.setVosz(vosz);
    }

    private void executeDSSM(String line) throws BusinessDomainException {
        Matcher matcher = EubpResponseCreator.getMatcher(line, DSSM_PATTERN_04, DSSM_PATTERN_05);
        int index = 0;
        String absendernummer = EubpResponseCreator.toString(matcher, ++index);
        String empfaengernummer = EubpResponseCreator.toString(matcher, ++index);
        String versionsnummer = EubpResponseCreator.toString(matcher, ++index);
        String datumErstellung = this.mDateFormat.format(EubpResponseCreator.toDate(matcher, ++index, "yyyyMMddHHmmssSSS"));
        int fehlerKennzeichen = EubpResponseCreator.toInt(matcher, ++index);
        int fehlerAnzahl = EubpResponseCreator.toInt(matcher, ++index);
        int dateiNummer = EubpResponseCreator.toInt(matcher, ++index);
        String versionGesamt = EubpResponseCreator.toString(matcher, ++index);
        String bbnrVU = versionsnummer.compareTo("05") >= 0 ? EubpResponseCreator.toString(matcher, ++index) : null;
        String aktenzeichenAbsender = EubpResponseCreator.toString(matcher, ++index);
        String statusCode = EubpResponseCreator.toString(matcher, ++index);
        String statusText = EubpResponseCreator.toString(matcher, ++index);
        String datensatzEnde = EubpResponseCreator.toString(matcher, ++index);
        String rest = EubpResponseCreator.toStringNoTrim(matcher, ++index);
        if (!List.of("E", " ").contains(datensatzEnde)) {
            throw EubpExceptionMapper.makeEndMarkMissing(rest);
        }
        EubpDssm dssm = new EubpDssm();
        BasicRecord basicRecord = new BasicRecord(absendernummer, empfaengernummer, datumErstellung, fehlerKennzeichen, fehlerAnzahl);
        dssm.setVersionsnr(versionsnummer);
        dssm.setBasicRecord(basicRecord);
        dssm.setDateinummer(dateiNummer);
        dssm.setVersionGesamt(versionGesamt);
        dssm.setBbnrVU(bbnrVU);
        dssm.setAktenzeichenAbsender(aktenzeichenAbsender);
        dssm.setStatuscode(statusCode);
        dssm.setStatustext(statusText);
        dssm.setDbfes(new EubpDbfesCreator(rest, fehlerAnzahl).getDbfes());
        if (this.mEubpResponse.getDssm() != null) {
            throw EubpExceptionMapper.makeMultipleDatasetsFound("DSSM");
        }
        this.mEubpResponse.setDssm(dssm);
    }

    private void executeDSGM(String line) throws BusinessDomainException {
        String datensatzEnde;
        Matcher matcher = EubpResponseCreator.getMatcher(line, DSGM_PATTERN);
        String absendernummer = EubpResponseCreator.toString(matcher, 1);
        String empfaengernummer = EubpResponseCreator.toString(matcher, 2);
        String versionsnummer = EubpResponseCreator.toString(matcher, 3);
        String datumErstellung = this.mDateFormat.format(EubpResponseCreator.toDate(matcher, 4, "yyyyMMddHHmmssSSS"));
        int fehlerKennzeichen = EubpResponseCreator.toInt(matcher, 5);
        int fehlerAnzahl = EubpResponseCreator.toInt(matcher, 6);
        String bbnrAG = EubpResponseCreator.toString(matcher, 7);
        String mandant = EubpResponseCreator.toString(matcher, 8);
        String aktenzeichenVerursacher = EubpResponseCreator.toString(matcher, 9);
        String versicherungsnummer = EubpResponseCreator.toString(matcher, 10);
        String name = EubpResponseCreator.toString(matcher, 11);
        String geburtsname = EubpResponseCreator.toString(matcher, 12);
        String vorname = EubpResponseCreator.toString(matcher, 13);
        Date geburtsdatum = EubpResponseCreator.toDate(matcher, 14);
        int anzahlRueckmeldungen = EubpResponseCreator.toInt(matcher, 15);
        String rest = EubpResponseCreator.toStringNoTrim(matcher, 16);
        EubpDsgm dsgm = new EubpDsgm();
        BasicRecord basicRecord = new BasicRecord(absendernummer, empfaengernummer, datumErstellung, fehlerKennzeichen, fehlerAnzahl);
        dsgm.setVersionsnr(versionsnummer);
        dsgm.setBasicRecord(basicRecord);
        dsgm.setBbnrAG(bbnrAG);
        dsgm.setMandant(mandant);
        dsgm.setAktenzeichenVerursacher(aktenzeichenVerursacher);
        dsgm.setVersicherungsnummer(versicherungsnummer);
        dsgm.setName(name);
        dsgm.setGeburtsname(geburtsname);
        dsgm.setVorname(vorname);
        dsgm.setGeburtsdatum(geburtsdatum);
        dsgm.setAnzahlRueckmeldungen(anzahlRueckmeldungen);
        for (int i = 0; i < anzahlRueckmeldungen; ++i) {
            Matcher dsgmPartMatcher = EubpResponseCreator.getMatcher(rest, DSGM_PART_PATTERN);
            Date zeitraumBeginn = EubpResponseCreator.toDate(dsgmPartMatcher, 1);
            Date zeitraumEnde = EubpResponseCreator.toDate(dsgmPartMatcher, 2);
            int beitragsgruppeKV = EubpResponseCreator.toInt(dsgmPartMatcher, 3);
            int beitragsgruppeRV = EubpResponseCreator.toInt(dsgmPartMatcher, 4);
            int beitragsgruppeAV = EubpResponseCreator.toInt(dsgmPartMatcher, 5);
            int beitragsgruppePV = EubpResponseCreator.toInt(dsgmPartMatcher, 6);
            String bbnrKK = EubpResponseCreator.toString(dsgmPartMatcher, 7);
            String vorzeichenEdiffGSV = EubpResponseCreator.toString(dsgmPartMatcher, 8);
            BigDecimal ediffGSV = EubpResponseCreator.toBigDecimal(dsgmPartMatcher, 9);
            String vorzeichenEdiffGRB = EubpResponseCreator.toString(dsgmPartMatcher, 10);
            BigDecimal ediffGRB = EubpResponseCreator.toBigDecimal(dsgmPartMatcher, 11);
            rest = EubpResponseCreator.toStringNoTrim(dsgmPartMatcher, 12);
            EubpDsgmPart part = new EubpDsgmPart();
            part.setZeitraumBeginn(zeitraumBeginn);
            part.setZeitraumEnde(zeitraumEnde);
            part.setByGrKV(beitragsgruppeKV);
            part.setByGrRV(beitragsgruppeRV);
            part.setByGrAV(beitragsgruppeAV);
            part.setByGrPV(beitragsgruppePV);
            part.setBbnrKK(bbnrKK);
            part.setEntgeltdifferenzGSV(EubpResponseCreator.toBigDecimal(vorzeichenEdiffGSV, ediffGSV));
            part.setEntgeltdifferenzGRB(EubpResponseCreator.toBigDecimal(vorzeichenEdiffGRB, ediffGRB));
            dsgm.addPart(part);
        }
        String string = datensatzEnde = rest.length() > 0 ? rest.substring(0, 1) : "";
        if (!List.of("E", " ").contains(datensatzEnde)) {
            throw EubpExceptionMapper.makeEndMarkMissing(datensatzEnde);
        }
        rest = rest.length() > 0 ? rest.substring(1) : "";
        EubpDbfesCreator dbfesCreator = new EubpDbfesCreator(rest, fehlerAnzahl);
        dsgm.setDbfes(dbfesCreator.getDbfes());
        if (!dbfesCreator.getRest().isEmpty()) {
            throw new IllegalStateException("Rest nicht leer. Rest: " + rest);
        }
        this.mEubpResponse.addDsgm(dsgm);
    }

    private void executeDSUM(String line) throws BusinessDomainException {
        Matcher matcher = EubpResponseCreator.getMatcher(line, DSUM_PATTERN);
        String absendernummer = EubpResponseCreator.toString(matcher, 1);
        String empfaengernummer = EubpResponseCreator.toString(matcher, 2);
        String versionsnummer = EubpResponseCreator.toString(matcher, 3);
        String datumErstellung = this.mDateFormat.format(EubpResponseCreator.toDate(matcher, 4, "yyyyMMddHHmmssSSS"));
        int fehlerKennzeichen = EubpResponseCreator.toInt(matcher, 5);
        int fehlerAnzahl = EubpResponseCreator.toInt(matcher, 6);
        String bbnrAG = EubpResponseCreator.toString(matcher, 7);
        String versicherungsnummer = EubpResponseCreator.toString(matcher, 8);
        String name = EubpResponseCreator.toString(matcher, 9);
        String geburtsname = EubpResponseCreator.toString(matcher, 10);
        String vorname = EubpResponseCreator.toString(matcher, 11);
        Date geburtsdatum = EubpResponseCreator.toDate(matcher, 12);
        int anzahlUrsprungsmeldungen = EubpResponseCreator.toInt(matcher, 13);
        String rest = EubpResponseCreator.toStringNoTrim(matcher, 14);
        EubpDsum dsum = new EubpDsum();
        BasicRecord basicRecord = new BasicRecord(absendernummer, empfaengernummer, datumErstellung, fehlerKennzeichen, fehlerAnzahl);
        dsum.setVersionsnr(versionsnummer);
        dsum.setBasicRecord(basicRecord);
        dsum.setBbnrAG(bbnrAG);
        dsum.setVersicherungsnummer(versicherungsnummer);
        dsum.setName(name);
        dsum.setGeburtsname(geburtsname);
        dsum.setVorname(vorname);
        dsum.setGeburtsdatum(geburtsdatum);
        dsum.setAnzahlUrsprungsmeldungen(anzahlUrsprungsmeldungen);
        for (int i = 0; i < anzahlUrsprungsmeldungen; ++i) {
            Matcher dsumPartMatcher = EubpResponseCreator.getMatcher(rest, DSUM_PART_PATTERN);
            String datensatzID = EubpResponseCreator.toString(dsumPartMatcher, 1);
            String aktenzeichenVerursacher = EubpResponseCreator.toString(dsumPartMatcher, 2);
            Date zeitraumBeginn = EubpResponseCreator.toDate(dsumPartMatcher, 3);
            Date zeitraumEnde = EubpResponseCreator.toDate(dsumPartMatcher, 4);
            String vorzeichenEUM = EubpResponseCreator.toString(dsumPartMatcher, 5);
            BigDecimal eum = EubpResponseCreator.toBigDecimal(dsumPartMatcher, 6);
            String vorzeichenEGRBUM = EubpResponseCreator.toString(dsumPartMatcher, 7);
            BigDecimal egrbum = EubpResponseCreator.toBigDecimal(dsumPartMatcher, 8);
            int beitragsgruppeKV = EubpResponseCreator.toInt(dsumPartMatcher, 9);
            int beitragsgruppeRV = EubpResponseCreator.toInt(dsumPartMatcher, 10);
            int beitragsgruppeAV = EubpResponseCreator.toInt(dsumPartMatcher, 11);
            int beitragsgruppePV = EubpResponseCreator.toInt(dsumPartMatcher, 12);
            String bbnrKK = EubpResponseCreator.toString(dsumPartMatcher, 13);
            int personengruppenschluessel = EubpResponseCreator.toInt(dsumPartMatcher, 14);
            int grundDerAbgabe = EubpResponseCreator.toInt(dsumPartMatcher, 15);
            String taetigkeitsschluessel = EubpResponseCreator.toString(dsumPartMatcher, 16);
            String kennzeichenGleitzone = EubpResponseCreator.toString(dsumPartMatcher, 17);
            String statuskennzeichen = EubpResponseCreator.toString(dsumPartMatcher, 18);
            String rechtskreiskennzeichen = EubpResponseCreator.toString(dsumPartMatcher, 19);
            String kennzeichenMehrfachbeschaeftigung = EubpResponseCreator.toString(dsumPartMatcher, 20);
            String staatsangehoerigkeit = EubpResponseCreator.toString(dsumPartMatcher, 21);
            rest = EubpResponseCreator.toStringNoTrim(dsumPartMatcher, 22);
            EubpDsumPart part = new EubpDsumPart();
            part.setDatensatzID(datensatzID);
            part.setAktenzeichenVerursacher(aktenzeichenVerursacher);
            part.setZeitraumBeginn(zeitraumBeginn);
            part.setZeitraumEnde(zeitraumEnde);
            part.setEntgelt(EubpResponseCreator.toBigDecimal(vorzeichenEUM, eum));
            part.setEntgeltRentenberechnung(EubpResponseCreator.toBigDecimal(vorzeichenEGRBUM, egrbum));
            part.setByGrKV(beitragsgruppeKV);
            part.setByGrRV(beitragsgruppeRV);
            part.setByGrAV(beitragsgruppeAV);
            part.setByGrPV(beitragsgruppePV);
            part.setBbnrKK(bbnrKK);
            part.setPersonengruppe(personengruppenschluessel);
            part.setGrundDerAbgabe(grundDerAbgabe);
            part.setTaetigkeitsschluessel(taetigkeitsschluessel);
            part.setKennzeichenGleitzone(kennzeichenGleitzone);
            part.setStatuskennzeichen(statuskennzeichen);
            part.setRechtskreis(rechtskreiskennzeichen);
            part.setMehrfachbeschaeftigung(kennzeichenMehrfachbeschaeftigung);
            part.setStaatsangehoerigkeit(staatsangehoerigkeit);
            dsum.addPart(part);
        }
        rest = rest.length() > 0 ? rest.substring(1) : "";
        EubpDbfesCreator dbfesCreator = new EubpDbfesCreator(rest, fehlerAnzahl);
        dsum.setDbfes(dbfesCreator.getDbfes());
        if (!dbfesCreator.getRest().isEmpty()) {
            throw new IllegalStateException("Rest nicht leer. Rest: " + rest);
        }
        List dsgms = this.mEubpResponse.getDsgms();
        if (dsgms.isEmpty()) {
            throw EubpExceptionMapper.makeDsumWithoutDsgm();
        }
        EubpDsgm dsgm = (EubpDsgm)dsgms.get(dsgms.size() - 1);
        if (dsgm.getDsum() != null) {
            throw EubpExceptionMapper.makeMultipleDsumFound();
        }
        dsgm.setDsum(dsum);
    }

    private void executeNCSZ(String line) throws BusinessDomainException {
        Matcher matcher = EubpResponseCreator.getMatcher(line, NCSZ_PATTERN);
        String absendernummer = EubpResponseCreator.toString(matcher, 1);
        String empfaengernummer = EubpResponseCreator.toString(matcher, 2);
        Date datumErstellung = EubpResponseCreator.toDate(matcher, 3);
        int dateinummer = EubpResponseCreator.toInt(matcher, 4);
        int anzahlSaetze = EubpResponseCreator.toInt(matcher, 5);
        int versionsnummer = EubpResponseCreator.toInt(matcher, 6);
        String rest = EubpResponseCreator.toStringNoTrim(matcher, 7);
        EubpNcsz ncsz = new EubpNcsz();
        ncsz.setAbsendernummer(absendernummer);
        ncsz.setEmpfaengernummer(empfaengernummer);
        ncsz.setDatumErstellung(datumErstellung);
        ncsz.setDateinummer(dateinummer);
        ncsz.setAnzahlSaetze(anzahlSaetze);
        ncsz.setVersionsnummer(versionsnummer);
        ncsz.setDbfes(new EubpDbfesCreator(rest).getDbfes());
        if (this.mEubpResponse.getNcsz() != null) {
            throw EubpExceptionMapper.makeMultipleDatasetsFound("NCSZ");
        }
        this.mEubpResponse.setNcsz(ncsz);
    }

    static String toStringNoTrim(Matcher matcher, int groupNo) {
        return matcher.group(groupNo);
    }

    static String toString(Matcher matcher, int groupNo) {
        return matcher.group(groupNo).trim();
    }

    static int toInt(Matcher matcher, int groupNo) {
        return Integer.parseInt(EubpResponseCreator.toString(matcher, groupNo));
    }

    static Date toDate(Matcher matcher, int groupNo) throws BusinessDomainException {
        return EubpResponseCreator.toDate(matcher, groupNo, "yyyyMMdd");
    }

    static Date toDate(Matcher matcher, int groupNo, String format) throws BusinessDomainException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = EubpResponseCreator.toString(matcher, groupNo);
        try {
            return dateFormat.parse(string);
        }
        catch (ParseException e) {
            throw EubpExceptionMapper.makeWrongFormatException(format, string);
        }
    }

    static BigDecimal toBigDecimal(Matcher matcher, int groupNo) {
        return new BigDecimal(EubpResponseCreator.toString(matcher, groupNo)).movePointLeft(2);
    }

    static BigDecimal toBigDecimal(String vorzeichen, BigDecimal bigDecimal) {
        return "-".equals(vorzeichen) ? bigDecimal.negate() : bigDecimal;
    }

    static Matcher getMatcher(String input, Pattern ... patterns) throws BusinessDomainException {
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(input);
            if (!matcher.matches()) continue;
            return matcher;
        }
        throw EubpExceptionMapper.makePatternNotValid(input, patterns);
    }
}

