/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.eubp.account.EubpAccount;
import com.varial.personnel.domain.eubp.mapper.EubpExceptionMapper;
import com.varial.personnel.domain.eubp.receive.EubpAccountMap;
import com.varial.personnel.domain.eubp.receive.EubpResponse;
import com.varial.personnel.domain.eubp.receive.EubpResponseCreator;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.framework.PFileHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EubpReceive
extends BasicReceive<EubpAccount> {
    private static final String[] FILENAMEPREFIXES = new String[]{"TEBR0", "EEBR0", "TEBE0", "EEBE0"};
    private static final String[] FILENAMEPREFIXES_EBE = new String[]{"TEBE0", "EEBE0"};
    private final List<EubpResponse> mEubpResponses = new ArrayList<EubpResponse>();
    private final EubpAccountMap mEubpAccountMap;

    public EubpReceive(DEUVSender deuvSender, EubpAccountMap eubpAccountMap) {
        super(deuvSender);
        this.mEubpAccountMap = eubpAccountMap;
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEPREFIXES);
    }

    @Override
    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, "euBP: R\u00fcckmeldungen");
        try {
            List<String> lines = EubpReceive.getFileLines(file, ISO_8859_1, 2);
            return lines.size() >= 2 && EubpResponseCreator.VOSZ_PATTERN.matcher(lines.get(0)).matches() && (EubpResponseCreator.DSSM_PATTERN_04.matcher(lines.get(1)).matches() || EubpResponseCreator.DSSM_PATTERN_05.matcher(lines.get(1)).matches());
        }
        catch (IOException e) {
            throw EubpExceptionMapper.makeFileReadError(file.getPath(), e);
        }
    }

    @Override
    public String getProcedureName() {
        return "euBP";
    }

    @Override
    public String getFileDescription() {
        return "R\u00fcckmeldungen elektronisch unterst\u00fctzte Betriebspr\u00fcfung";
    }

    @Override
    public String getActionName() {
        return "importieren";
    }

    @Override
    public Set<DEUVRecipient> getDeuvRecipients() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        return this.mFiles.keySet();
    }

    public void readEubpResponses(DEUVRecipient deuvRecipient) throws BusinessDomainException {
        this.initFiles();
        this.mRecipient = deuvRecipient;
        Iterator iterator = ((List)this.mFiles.get(deuvRecipient)).iterator();
        while (iterator.hasNext()) {
            File file;
            this.mCurrent = file = (File)iterator.next();
            EubpResponse eubpResponse = new EubpResponseCreator(file, this.mEubpAccountMap, deuvRecipient).getEubpResponse();
            eubpResponse.setDEUVRecipient(deuvRecipient);
            this.mEubpResponses.add(eubpResponse);
            int subFolderNr = PerfidiaHelper.getPerfidiaSubFolderNumber((DEUVSender)this.mDeuvSender, (TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
            int fileNumberReceive = eubpResponse.getVosz().getDateinummer();
            this.mAcknowledgement.addProcessedFile(file, this.isEBE(file) ? PerfidiaDataType.EUBP : PerfidiaDataType.EUBP_R, subFolderNr, 0, fileNumberReceive);
            this.mPerfidiaResult.addReceivedFile(file);
        }
    }

    private boolean isEBE(File file) {
        String fileName = file.getName().toUpperCase();
        for (String filenamePrefix : FILENAMEPREFIXES_EBE) {
            if (!fileName.startsWith(filenamePrefix)) continue;
            return true;
        }
        return false;
    }

    public List<EubpResponse> getEubpResponses() {
        return this.mEubpResponses;
    }

    private static List<String> getFileLines(File file, String charset, int maxLines) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), charset));){
            String line;
            while (lines.size() < maxLines && (line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }
}

