/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.eubp.receive.EubpResponseCreator;
import com.varial.personnel.domain.eubp.receive.dbfe.EubpDbfe;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EubpDbfesCreator {
    private static final String KENNUNG = "DBFE";
    private static final Pattern DBFE_PATTERN = Pattern.compile("DBFE(.{7}) (.{64})(.*)");
    private final List<EubpDbfe> mDbfes = new ArrayList<EubpDbfe>();
    private final String mRest;

    public EubpDbfesCreator(String string, int fehlerAnzahl) throws BusinessDomainException {
        String rest = string;
        for (int i = 0; i < fehlerAnzahl; ++i) {
            Matcher dbfeMatcher = EubpResponseCreator.getMatcher(rest, DBFE_PATTERN);
            String fehlernummer = EubpResponseCreator.toString(dbfeMatcher, 1);
            String fehlertext = EubpResponseCreator.toString(dbfeMatcher, 2);
            EubpDbfe dbfe = new EubpDbfe();
            dbfe.setFehlernummer(fehlernummer);
            dbfe.setFehlertext(fehlertext);
            this.mDbfes.add(dbfe);
            rest = EubpResponseCreator.toStringNoTrim(dbfeMatcher, 3);
        }
        this.mRest = rest;
    }

    public EubpDbfesCreator(String string) throws BusinessDomainException {
        String rest = string;
        while (rest.length() >= KENNUNG.length() && rest.startsWith(KENNUNG)) {
            Matcher dbfeMatcher = EubpResponseCreator.getMatcher(rest, DBFE_PATTERN);
            String fehlernummer = EubpResponseCreator.toString(dbfeMatcher, 1);
            String fehlertext = EubpResponseCreator.toString(dbfeMatcher, 2);
            EubpDbfe dbfe = new EubpDbfe();
            dbfe.setFehlernummer(fehlernummer);
            dbfe.setFehlertext(fehlertext);
            this.mDbfes.add(dbfe);
            rest = EubpResponseCreator.toStringNoTrim(dbfeMatcher, 3);
        }
        this.mRest = rest;
    }

    public List<EubpDbfe> getDbfes() {
        return this.mDbfes;
    }

    public String getRest() {
        return this.mRest;
    }
}

