/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eubp.mapper;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;

public class EubpExceptionMapper {
    private static final String CLASS_GENERAL = "PYEubp";
    private static final int STATUS_NOT_UEBERMITTELT = 101;
    private static final int STATUS_NOT_VERARBEITET = 102;
    private static final int ALREADY_EXISTS = 103;
    private static final int ILLEGAL_COUNT_DEUVRECIPIENTS = 104;
    private static final int WRITE_EUBP_FILE = 105;
    private static final int NO_EMPLOYEES_FOUND = 106;
    private static final int FILE_NOT_DELETED = 107;
    private static final int DSAG_NOT_FOUND = 108;
    private static final int ERROR_IN_SOC = 109;
    private static final int ILLEGAL_LENGTH_COMPANYNUMBER = 110;
    private static final int FILE_EXISTS = 111;
    private static final int PATTERN_NOT_VALID = 112;
    private static final int FILE_READ_ERROR = 113;
    private static final int LINE_TOO_SHORT = 114;
    private static final int UNKNOWN_PREFIX = 115;
    private static final int WRONG_FORMAT = 116;
    private static final int END_MARK_MISSING = 117;
    private static final int DSUM_WITHOUT_DSGM = 118;
    private static final int MULTIPLE_DSUM_FOUND = 119;
    private static final int MULTIPLE_DATASETS_FOUND = 120;
    private static final int FILE_NOT_FOUND = 121;
    private static final int FILE_TOO_SHORT = 122;
    private static final int EUBPDSST_NOT_FOUND = 123;
    private static final int MULTIPLE_EUBPDSST_FOUND = 124;
    private static final int STORNO_NOT_STORNABLE = 125;
    private static final int STORNO_NOT_DELETABLE = 126;
    private static final int NO_DSST_WITH_STATUS_VERARBEITET = 127;
    private static final int UNKNOWN_EUBP_VERSION = 128;
    private static final int FILECOPY_ERROR = 129;
    private static final int EMAIL_EMPTY = 130;
    private static final int NAME_AP_EMPTY = 131;
    private static final int TEL_AP_EMPTY = 132;
    private static final int EMAIL_AP_EMPTY = 133;
    private static final int TEL_AP_NOT_DIN5008 = 134;
    private static final int DEUVSENDER_NOT_FOUND = 135;
    @Errors
    private static final ErrorList mErrorList = new ErrorList("PYEubp", new ErrorMessage[]{new ErrorMessage(101, "Die euBP-Sendung kann nicht gel\u00f6scht werden, da der Status nicht '\u00fcbermittelt' ist."), new ErrorMessage(102, "Die euBP-Sendung kann nicht storniert werden, da der Status nicht 'verarbeitet' ist."), new ErrorMessage(103, "Es existiert bereits eine euBP-Sendung mit der Betriebsnummer."), new ErrorMessage(104, "Ung\u00fcltige Anzahl DEUV-Empf\u00e4nger zu Betriebsnummer gefunden."), new ErrorMessage(105, "Fehler beim Schreiben der euBP-Datei."), new ErrorMessage(106, "Keine Mitarbeiter zur Betriebnsummer in dem Zeitraum gefunden."), new ErrorMessage(107, "Die Datei konnte nicht gel\u00f6scht werden."), new ErrorMessage(108, "Zum Datensatz DSST wurde nicht genau ein Datensatz DSAG gefunden."), new ErrorMessage(109, "Fehler beim Aufbau der Beitragsnachweise."), new ErrorMessage(110, "Die Betriebsnummer muss die L\u00e4nge 8 haben."), new ErrorMessage(111, "Die Datei existiert bereits."), new ErrorMessage(112, "Der Satz entspricht nicht der Struktur."), new ErrorMessage(113, "Fehler beim Lesen der Datei."), new ErrorMessage(114, "Die Zeile ist zu kurz."), new ErrorMessage(115, "Unbekannte Satzart."), new ErrorMessage(116, "Der Wert hat ein falsches Format."), new ErrorMessage(117, "Das Ende des Datensatzes wird erwartet."), new ErrorMessage(118, "Es existiert ein DSUM-Satz ohne zugeh\u00f6rigen DSGM-Satz."), new ErrorMessage(119, "Es existieren mehrere DSUM-S\u00e4tze zu einem DSGM-Satz."), new ErrorMessage(120, "Es wurden mehrere Datens\u00e4tze einer Satzart gefunden."), new ErrorMessage(121, "Die Datei wurde nicht gefunden."), new ErrorMessage(122, "Die Datei ist zu kurz."), new ErrorMessage(123, "Zu der Dateinummer wurde keine gespeicherte Meldung gefunden."), new ErrorMessage(124, "Zu der Dateinummer wurden mehrere Meldungen gefunden."), new ErrorMessage(125, "Stornos\u00e4tze sind nicht stornierbar."), new ErrorMessage(126, "Stornos\u00e4tze sind nicht l\u00f6schbar."), new ErrorMessage(127, "Es existiert keine Datei mit Status verarbeitet."), new ErrorMessage(128, "Die euBP-Version ist nicht bekannt."), new ErrorMessage(129, "Fehler beim Kopieren einer Datei."), new ErrorMessage(130, "Die E-Mail-Adresse ist leer."), new ErrorMessage(131, "Der Name des Ansprechpartners ist leer."), new ErrorMessage(132, "Die Telefonnummer des Ansprechpartners ist leer."), new ErrorMessage(133, "Die E-Mail-Adresse des Ansprechpartners ist leer."), new ErrorMessage(134, "Die Telefonnummer des Ansprechpartners entspricht nicht DIN5008."), new ErrorMessage(135, "Der DEUV-Absender wurde nicht gefunden.")});

    private static BusinessDomainException makeBusinessDomainException(int errornr) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)2), (String)"", (int)errornr, (String)mErrorList.getDefaultString(errornr));
    }

    private static BusinessDomainException makeBusinessDomainException(int errornr, String message) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)2), (String)"", (int)errornr, (String)(mErrorList.getDefaultString(errornr) + "\n" + message + "\n"));
    }

    public static String getStackTrace(Throwable t) {
        StringBuilder result = new StringBuilder("");
        result.append(t.getLocalizedMessage() + "\n");
        for (StackTraceElement element : t.getStackTrace()) {
            result.append(element.toString() + "\n");
        }
        return result.toString();
    }

    public static BusinessDomainException makeStatusNotUebermitteltException() {
        return EubpExceptionMapper.makeBusinessDomainException(101);
    }

    public static BusinessDomainException makeStatusNotVerarbeitetException() {
        return EubpExceptionMapper.makeBusinessDomainException(102);
    }

    public static BusinessDomainException makeEubpAlreadyExistsException(String bbrnvu) {
        return EubpExceptionMapper.makeBusinessDomainException(103, "Betriebsnummer=" + bbrnvu);
    }

    public static BusinessDomainException makeIllegalCountDeuvRecipientsException(int count, String bbnr) {
        return EubpExceptionMapper.makeBusinessDomainException(104, "BBNR: " + bbnr + ", Anzahl: " + count);
    }

    public static BusinessDomainException makeWriteEubpFileException(Throwable t) {
        return EubpExceptionMapper.makeBusinessDomainException(105, "Exception: " + t + "\n" + EubpExceptionMapper.getStackTrace(t));
    }

    public static BusinessDomainException makeNoEmployeesFoundException(String bbnr) {
        return EubpExceptionMapper.makeBusinessDomainException(106, "Betriebsnummer: " + bbnr);
    }

    public static BusinessDomainException makeFileNotDeletedException(String fileName) {
        return EubpExceptionMapper.makeBusinessDomainException(107, "Dateiname: " + fileName);
    }

    public static BusinessDomainException makeDsagNotFoundException(int fileNumber, int countDSAG) {
        return EubpExceptionMapper.makeBusinessDomainException(108, "Dateinummer: " + fileNumber + "; Anzahl DSAG-Datens\u00e4tze: " + countDSAG);
    }

    public static BusinessDomainException makeErrorInSocException(List<String> errorList) {
        return EubpExceptionMapper.makeBusinessDomainException(109, "Fehlerliste: " + errorList);
    }

    public static BusinessDomainException makeIllegalLengthCompanyNumber(String companyNumber) {
        return EubpExceptionMapper.makeBusinessDomainException(110, "Betriebsnummer: " + companyNumber);
    }

    public static BusinessDomainException makeFileExists(String fileName) {
        return EubpExceptionMapper.makeBusinessDomainException(111, "Dateiname: " + fileName);
    }

    public static BusinessDomainException makePatternNotValid(String input, Pattern ... patterns) {
        return EubpExceptionMapper.makeBusinessDomainException(112, "input: " + input + "; patterns: " + patterns);
    }

    public static BusinessDomainException makeFileReadError(String fileName, Throwable t) {
        return EubpExceptionMapper.makeBusinessDomainException(113, "Dateiname: " + fileName + "\nException: " + t + "\n" + EubpExceptionMapper.getStackTrace(t));
    }

    public static BusinessDomainException makeFileReadError(String fileName, int lineNo, Throwable t) {
        return EubpExceptionMapper.makeBusinessDomainException(113, "Dateiname: " + fileName + "\nZeile: " + lineNo + "\nException: " + t + "\n" + EubpExceptionMapper.getStackTrace(t));
    }

    public static BusinessDomainException makeFileReadError(String fileName, int lineNo, String line, Throwable t) {
        return EubpExceptionMapper.makeBusinessDomainException(113, "Dateiname: " + fileName + "\nZeilennummer: " + lineNo + "\nZeile: " + line + "\nException: " + t + "\n" + EubpExceptionMapper.getStackTrace(t));
    }

    public static BusinessDomainException makeLineTooShort() {
        return EubpExceptionMapper.makeBusinessDomainException(114);
    }

    public static BusinessDomainException makeUnknownPrefix(String prefix) {
        return EubpExceptionMapper.makeBusinessDomainException(115, "Satzart: " + prefix);
    }

    public static BusinessDomainException makeWrongFormatException(String format, String string) {
        return EubpExceptionMapper.makeBusinessDomainException(116, "Format: " + format + "; Wert: " + string);
    }

    public static BusinessDomainException makeEndMarkMissing(String rest) {
        return EubpExceptionMapper.makeBusinessDomainException(117, "Rest: " + rest);
    }

    public static BusinessDomainException makeDsumWithoutDsgm() {
        return EubpExceptionMapper.makeBusinessDomainException(118);
    }

    public static BusinessDomainException makeMultipleDsumFound() {
        return EubpExceptionMapper.makeBusinessDomainException(119);
    }

    public static BusinessDomainException makeMultipleDatasetsFound(String satzart) {
        return EubpExceptionMapper.makeBusinessDomainException(120, "Satzart: " + satzart);
    }

    public static BusinessDomainException makeFileNotFoundException(String fileName) {
        return EubpExceptionMapper.makeBusinessDomainException(121, "Dateiname: " + fileName);
    }

    public static BusinessDomainException makeFileTooShortException(String fileName) {
        return EubpExceptionMapper.makeBusinessDomainException(122, "Dateiname: " + fileName);
    }

    public static BusinessDomainException makeEubpDsstNotFound(File file, int fileNumber) {
        return EubpExceptionMapper.makeBusinessDomainException(123, "Dateiname: " + file.getPath() + "; Dateinummer: " + fileNumber);
    }

    public static BusinessDomainException makeMultipleEubpDsstsFound(File file, int fileNumber) {
        return EubpExceptionMapper.makeBusinessDomainException(124, "Dateiname: " + file.getPath() + "; Dateinummer: " + fileNumber);
    }

    public static BusinessDomainException makeStornoNotStornable() {
        return EubpExceptionMapper.makeBusinessDomainException(125);
    }

    public static BusinessDomainException makeStornoNotDeletable() {
        return EubpExceptionMapper.makeBusinessDomainException(126);
    }

    public static BusinessDomainException makeNoDsstWithStatusVerarbeitet() {
        return EubpExceptionMapper.makeBusinessDomainException(127);
    }

    public static BusinessDomainException makeUnknownEubpVersionException(String version) {
        return EubpExceptionMapper.makeBusinessDomainException(128, "version=" + version);
    }

    public static BusinessDomainException makeFileCopyError(File source, File destination, Throwable error) {
        return EubpExceptionMapper.makeBusinessDomainException(129, "Quelle: " + source.getPath() + "; Ziel: " + destination.getPath() + "; Fehler: " + error.getMessage());
    }

    public static BusinessDomainException makeEmailEmptyException() {
        return EubpExceptionMapper.makeBusinessDomainException(130);
    }

    public static BusinessDomainException makeNameApEmptyException() {
        return EubpExceptionMapper.makeBusinessDomainException(131);
    }

    public static BusinessDomainException makeTelApEmptyException() {
        return EubpExceptionMapper.makeBusinessDomainException(132);
    }

    public static BusinessDomainException makeEmailApEmptyException() {
        return EubpExceptionMapper.makeBusinessDomainException(133);
    }

    public static BusinessDomainException makeTelApNotDIN5008Exception() {
        return EubpExceptionMapper.makeBusinessDomainException(134);
    }

    public static BusinessDomainException makeDEUVSenderNotFoundException(Date validDate) {
        return EubpExceptionMapper.makeBusinessDomainException(135, "Datum: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validDate));
    }
}

