/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.deleteafterwithdrawal;

import com.infor.igf.py.selfservice.SelfServiceHelper;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.personnel.domain.designationtype.designation.DesignationTP;
import com.varial.personnel.domain.designationtype.designation.IDesignationTPPersistencyManager;
import com.varial.personnel.domain.designationtype.designation.TypeOfDesignationEnum;
import com.varial.personnel.domain.designationtype.designation.TypeOfDesignationUnion;
import com.varial.personnel.domain.designationtype.smcriterion.SMCriterion;
import com.varial.personnel.domain.designationtype.smcriterion.SMCriterionPersistencyManager;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.bankdetails.EEBankDetails;
import com.varial.personnel.domain.employee.bankdetails.EEBankDetailsTP;
import com.varial.personnel.domain.employee.deleteafterwithdrawal.DeleteAfterWithdrawalPre;
import com.varial.personnel.domain.employee.education.Education;
import com.varial.personnel.domain.employee.eeskill.EESkill;
import com.varial.personnel.domain.employee.eeskill.IEESkillPersistencyManager;
import com.varial.personnel.domain.employee.employment.Employment;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpenses;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesPersistencyManager;
import com.varial.personnel.domain.employee.relative.DegreeRelationShipEnum;
import com.varial.personnel.domain.employee.relative.EERelative;
import com.varial.personnel.domain.employee.relative.EERelativeTP;
import com.varial.personnel.domain.employee.relative.FlagCalculationEnum;
import com.varial.personnel.domain.employee.relative.IEERelativePersistencyManager;
import com.varial.personnel.domain.employee.salaryhistory.SalaryHistory;
import com.varial.personnel.domain.employee.salaryhistory.SalaryHistoryPersistencyManager;
import com.varial.personnel.domain.global.recipient.ModeOfPaymentEnum;
import com.varial.personnel.framework.basictypes.BankAccount;
import com.varial.personnel.framework.basictypes.Communication;
import com.varial.serverbase.basictypes.VDate;
import java.util.ArrayList;
import java.util.List;

public final class EmployeeDeleteAfterWithdrawal {
    private Employee mEmployeeForAnonymization = null;
    private String[] mEmployeesForDelete = new String[0];
    private DeleteAfterWithdrawalPre mDeleteAfterWithdrawalPre = null;
    private final List<String> mMessageList = new ArrayList<String>();

    public EmployeeDeleteAfterWithdrawal(Employee employee, DeleteAfterWithdrawalPre deleteAfterWithdrawalPre) {
        this.mEmployeeForAnonymization = employee;
        this.mDeleteAfterWithdrawalPre = deleteAfterWithdrawalPre;
    }

    public EmployeeDeleteAfterWithdrawal(String[] oidEmployees) {
        this.mEmployeesForDelete = oidEmployees;
    }

    public List<String> anonymization() throws BusinessDomainException {
        this.isAnonymizationAllowed();
        this.mMessageList.add("in folgenden Bereichen");
        this.anonymizationMaster();
        this.anonymizationEmployment();
        this.anonymizationRelatives();
        this.anonymizationInsurance();
        this.anonymizationBankDetail();
        this.anonymizationEducation();
        this.anonymizationSalaryHistory();
        this.anonymizationCategory();
        this.anonymizationMaterialExpenses();
        this.mMessageList.add(this.mDeleteAfterWithdrawalPre.getNote());
        return this.mMessageList;
    }

    private void anonymizationMaterialExpenses() throws BusinessDomainException {
        TypeOfDesignationUnion typeOfDesignationUnion = new TypeOfDesignationUnion();
        typeOfDesignationUnion.typeOfDesignation(false, TypeOfDesignationEnum.TODE_MATERIALEXPENSES);
        DesignationTP[] designationTPs = EmployeeDeleteAfterWithdrawal.getIDesignationTPPM().queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), true, typeOfDesignationUnion);
        ArrayList<String> oidMaterialExpenses = new ArrayList<String>();
        for (DesignationTP each : designationTPs) {
            if (!each.getSelectedForDataProtection()) continue;
            oidMaterialExpenses.add(each.getDesignation().getObjectid());
        }
        this.mMessageList.add(" ");
        this.mMessageList.add("Sachmittel:");
        if (oidMaterialExpenses.isEmpty()) {
            this.mMessageList.add("keine Daten vorhanden");
            return;
        }
        EEMaterialExpenses[] eeMaterialExpenses = EEMaterialExpensesPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployeeForAnonymization.getObjectid()), Restrictions.in((String)"oidmaterialexpen", oidMaterialExpenses)}));
        boolean isDeleted = false;
        for (EEMaterialExpenses each : eeMaterialExpenses) {
            if (each.getActiveEEMaterialExpenses().getMonetaryBenefit()) continue;
            each.makeSaveable();
            each.destroy();
            isDeleted = true;
        }
        if (isDeleted) {
            this.mMessageList.add("die in der Bezeichnungstabelle zum L\u00f6schen gekennzeichneten Sachmittel beim Mitarbeiter gel\u00f6scht, sofern diese nicht berechnungsrelevant waren");
        } else {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    private void anonymizationCategory() throws BusinessDomainException {
        EESkill[] eeSkills;
        TypeOfDesignationUnion typeOfDesignationUnion = new TypeOfDesignationUnion();
        typeOfDesignationUnion.typeOfDesignation(false, TypeOfDesignationEnum.TODE_CATEGORY);
        DesignationTP[] designationTPs = EmployeeDeleteAfterWithdrawal.getIDesignationTPPM().queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.eq((String)"validuntil", (String)VDate.getDateMaxAsString())}), true, typeOfDesignationUnion);
        ArrayList<String> oidCategories = new ArrayList<String>();
        for (DesignationTP each : designationTPs) {
            if (!each.getSelectedForDataProtection()) continue;
            oidCategories.add(each.getDesignation().getObjectid());
        }
        this.mMessageList.add(" ");
        this.mMessageList.add("Qualifikation:");
        if (oidCategories.isEmpty()) {
            this.mMessageList.add("keine Daten vorhanden");
            return;
        }
        SMCriterion[] criterions = SMCriterionPersistencyManager.query(null, (Criterion)Restrictions.in((String)"oidcategory", oidCategories));
        if (criterions.length == 0) {
            return;
        }
        ArrayList<String> oidCriterions = new ArrayList<String>();
        for (SMCriterion each : criterions) {
            oidCriterions.add(each.getObjectid());
        }
        for (EESkill each : eeSkills = this.getIEESkillPM().query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployeeForAnonymization.getObjectid()), Restrictions.in((String)"oidsmcriterion", oidCriterions)}))) {
            each.makeSaveable();
            each.destroy();
        }
        if (eeSkills.length > 0) {
            this.mMessageList.add("die in der Bezeichnungstabelle zum L\u00f6schen gekennzeichneten Kategorien beim Mitarbeiter als Qualifikationen gel\u00f6scht");
        } else {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    private void isAnonymizationAllowed() throws BusinessDomainException {
        if (!this.mEmployeeForAnonymization.isLastDateOfWithdrawalJournalized()) {
            throw EmployeeExceptionMapper.makeAnonymizationNotAllowedDomainException();
        }
    }

    private void anonymizationMaster() throws BusinessDomainException {
        Master[] masters;
        if (!this.mDeleteAfterWithdrawalPre.getEeSelfService() && !this.mDeleteAfterWithdrawalPre.getEeMaster()) {
            return;
        }
        if (this.mDeleteAfterWithdrawalPre.getEeSelfService()) {
            this.mEmployeeForAnonymization.deleteSelfServiceReference();
            SelfServiceHelper.deleteSelfServiceDocuments((Employee)this.mEmployeeForAnonymization);
        }
        SessionContext.getInstance().getPersistencySession().flush();
        for (Master each : masters = this.mEmployeeForAnonymization.getEEMasterHistory()) {
            if (this.mDeleteAfterWithdrawalPre.getEeMaster()) {
                each.setPrivateCommunication(new Communication("", "", "", "", "", ""));
                each.setSOEperEMail(false);
                each.setPhotoAndFileName("", null);
            }
            each.makeSaveable();
        }
        if (masters.length > 0) {
            if (this.mDeleteAfterWithdrawalPre.getEeSelfService()) {
                this.mMessageList.add(" ");
                this.mMessageList.add("MA-Self-Service:");
                this.mMessageList.add("personenbezogene Daten zum Selfservice entfernt");
            }
            if (this.mDeleteAfterWithdrawalPre.getEeMaster()) {
                this.mMessageList.add(" ");
                this.mMessageList.add("pers\u00f6nliche Angaben:");
                this.mMessageList.add("personenbezogene Daten in den privaten Kontaktdaten in allen Zeitr\u00e4umen entfernt,");
                this.mMessageList.add("das Kennzeichen Verdienstnachweis per E-Mail auf nein gesetzt");
                this.mMessageList.add("und das Foto in allen Zeitr\u00e4umen entfernt");
            }
        }
    }

    private void anonymizationEmployment() {
        Employment[] employments;
        if (!this.mDeleteAfterWithdrawalPre.getEeEmployment()) {
            return;
        }
        for (Employment each : employments = this.mEmployeeForAnonymization.getEEEmploymentHistory()) {
            each.setEmployeeIdCard("");
            each.setDebitorCode("");
            each.setInHouseAddress("");
            each.setCreditorCode("");
            each.makeSaveable();
        }
        if (employments.length > 0) {
            this.mMessageList.add(" ");
            this.mMessageList.add("Besch\u00e4ftigung:");
            this.mMessageList.add("personenbezogene Daten sonstiger Zuordnungen in allen Zeitr\u00e4umen entfernt");
        }
    }

    private void anonymizationRelatives() throws BusinessDomainException {
        if (!this.mDeleteAfterWithdrawalPre.getEeRelativeChild() && !this.mDeleteAfterWithdrawalPre.getEeRelativeSpouse()) {
            return;
        }
        EERelative[] eeRelatives = this.mEmployeeForAnonymization.getEERelatives();
        this.mMessageList.add(" ");
        this.mMessageList.add("Familienangeh\u00f6rige:");
        int countOfChild = this.mEmployeeForAnonymization.getEffectiveNumberOfChildrenForNI(VDate.getDateMax(), this.mEmployeeForAnonymization.getLastDateOfWithdrawal(), true, false).intValue();
        boolean dataExists = false;
        block0: for (EERelative each : eeRelatives) {
            for (EERelativeTP tp : each.getEERelativeTPs()) {
                if (this.mDeleteAfterWithdrawalPre.getEeRelativeChild() && tp.getDegreeRelationShip() == DegreeRelationShipEnum.DRSE_KIND) {
                    if (countOfChild > 1 || tp.getDoPayment() || tp.getCAFlagCalculation() == FlagCalculationEnum.FCE_COUNTONLY) {
                        this.mMessageList.add("Kind " + tp.getFirstName() + " " + tp.getSurName() + " wurde als Familienangeh\u00f6riger nicht gel\u00f6scht, weil ein Zeitraum berechnungsrelevant ist");
                        dataExists = true;
                        continue block0;
                    }
                    tp.getEERelative().makeSaveable();
                    tp.getEERelative().destroy();
                    this.mMessageList.add("Kind " + tp.getFirstName() + " " + tp.getSurName() + " wurde als Familienangeh\u00f6riger gel\u00f6scht");
                    dataExists = true;
                    continue block0;
                }
                if (!this.mDeleteAfterWithdrawalPre.getEeRelativeSpouse() || tp.getDegreeRelationShip() != DegreeRelationShipEnum.DRSE_EHEGATTE) continue;
                tp.getEERelative().makeSaveable();
                tp.getEERelative().destroy();
                this.mMessageList.add("Ehegatte " + tp.getFirstName() + " " + tp.getSurName() + " wurde als Familienangeh\u00f6riger gel\u00f6scht");
                dataExists = true;
                continue block0;
            }
        }
        if (!dataExists) {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    private void anonymizationInsurance() {
        Insurance[] insurances;
        if (!this.mDeleteAfterWithdrawalPre.getEeInsurance()) {
            return;
        }
        for (Insurance each : insurances = this.mEmployeeForAnonymization.getEEInsuranceHistory()) {
            each.setMembershipKVdR("");
            each.makeSaveable();
        }
        if (insurances.length > 0) {
            this.mMessageList.add(" ");
            this.mMessageList.add("Sozialversicherung:");
            this.mMessageList.add("personenbezogene Daten in allen Zeitr\u00e4umen entfernt");
        }
    }

    private void anonymizationBankDetail() {
        EEBankDetails[] eeBankDetails;
        if (!this.mDeleteAfterWithdrawalPre.getEeBankDetail()) {
            return;
        }
        int count = 0;
        for (EEBankDetails each : eeBankDetails = this.mEmployeeForAnonymization.getEEBankDetails()) {
            for (EEBankDetailsTP tp : each.getEEBankDetailsTPs()) {
                tp.setModeOfPayment(ModeOfPaymentEnum.MOPE_Barzahlung);
                tp.setBankAccount(new BankAccount(null, "", "", ""));
                tp.setOwnerOfAccount("");
                tp.setRepetitionOfName(false);
                tp.makeSaveable();
            }
            ++count;
        }
        this.mMessageList.add(" ");
        this.mMessageList.add("Zahlungen - Bankverbindungen:");
        if (count > 0) {
            this.mMessageList.add("personenbezogene Daten in allen Zeitr\u00e4umen f\u00fcr " + count + " Bankverbindungen entfernt und auf Barzahlung gesetzt");
        } else {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    private void anonymizationEducation() throws BusinessDomainException {
        Education[] educations;
        if (!this.mDeleteAfterWithdrawalPre.getEeEducation()) {
            return;
        }
        for (Education each : educations = this.mEmployeeForAnonymization.getEEEducationHistory()) {
            each.makeSaveable();
            each.destroy();
        }
        this.mMessageList.add(" ");
        this.mMessageList.add("Ausbildung:");
        if (educations.length > 0) {
            this.mMessageList.add("Daten des Mitarbeitersgel\u00f6scht");
        } else {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    private void anonymizationSalaryHistory() throws BusinessDomainException {
        SalaryHistory[] salarays;
        if (!this.mDeleteAfterWithdrawalPre.getEeSalaryHistory()) {
            return;
        }
        for (SalaryHistory each : salarays = SalaryHistoryPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)this.mEmployeeForAnonymization.getObjectid())}))) {
            each.makeSaveable();
            each.destroy();
        }
        this.mMessageList.add(" ");
        this.mMessageList.add("Entgeltentwicklung:");
        if (salarays.length > 0) {
            this.mMessageList.add("Daten der Entgeltentwicklung gel\u00f6scht");
        } else {
            this.mMessageList.add("keine Daten vorhanden");
        }
    }

    public List<String> delete() throws BusinessDomainException {
        for (String each : this.mEmployeesForDelete) {
            Employee employee = this.getIEmployeePM().getEmployee(each);
            this.mMessageList.add("Mitarbeiter " + String.valueOf(employee.getPersonnelnumber()) + " - " + employee.getActiveMaster().getFirstname() + " " + employee.getActiveMaster().getSurname());
            this.delete(employee);
        }
        return this.mMessageList;
    }

    private void delete(Employee employee) throws BusinessDomainException {
        employee.deleteFinaly();
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    private static IDesignationTPPersistencyManager getIDesignationTPPM() {
        return (IDesignationTPPersistencyManager)UtilitiesManager.getBean((String)"designationTPPersistencyManager", IDesignationTPPersistencyManager.class);
    }

    private IEESkillPersistencyManager getIEESkillPM() {
        return (IEESkillPersistencyManager)UtilitiesManager.getBean((String)"eeSkillPersistencyManager", IEESkillPersistencyManager.class);
    }

    private IEERelativePersistencyManager getIEERelativePM() {
        return (IEERelativePersistencyManager)UtilitiesManager.getBean((String)"eeRelativePersistencyManager", IEERelativePersistencyManager.class);
    }
}

