/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.calculation;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.Calculation;
import com.varial.personnel.domain.calculation.CalculationCase;
import com.varial.personnel.domain.calculation.TypeOfCalculationCase;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.reports.certificate.Certificate;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.consequenceofvaluetype.ConsequenceOfValueType;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CertificateCalculationCase
extends CalculationCase {
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private BigDecimal mFesterBetrag = BigDecimal.ZERO;
    private BigDecimal mZVKBrutto = BigDecimal.ZERO;
    private ValuePosition mZusaetzlicheAWA;
    private boolean mNetWageIsLoaded = false;
    private BigDecimal mNetWage = BigDecimal.ZERO;
    private final boolean mNetWageMUGIsLoaded = false;
    private BigDecimal mNetWageMUG = BigDecimal.ZERO;
    private boolean mSVBeitraegeIsLoaded = false;
    private BigDecimal mSVBeitraege = BigDecimal.ZERO;
    private boolean mStAbzuegeIsLoaded = false;
    private BigDecimal mStAbzuege = BigDecimal.ZERO;
    private boolean mGrossWageIsLoaded = false;
    private BigDecimal mGrossWage = BigDecimal.ZERO;
    private boolean mHasEntgeltumwandlung = false;

    public CertificateCalculationCase() {
        super(true);
    }

    public CertificateCalculationCase(int certificateNo) {
        super(true);
        this.SetCertificateNo(certificateNo);
    }

    public void init(Employee empl, Date effectiveFrom, Date validFrom, BigDecimal fixedAmount) throws BusinessDomainException {
        this.mTypeOfCalculationCase = TypeOfCalculationCase.Bescheinigung;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = empl;
        this.mFesterBetrag = fixedAmount;
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.mCalculation = new Calculation();
        super.initDBBG();
    }

    public void init(Certificate cert, Date effectiveFrom, Date validFrom, BigDecimal mFixedAmount) throws BusinessDomainException {
        this.mTypeOfCalculationCase = TypeOfCalculationCase.Bescheinigung;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = cert.getEmployee();
        this.mFesterBetrag = mFixedAmount;
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.mCalculation = new Calculation();
        super.initDBBG();
    }

    public void init(Certificate cert, Date effectiveFrom, Date validFrom, BigDecimal mFixedAmount, TypeOfCalculationCase typeOfCalculationCase) throws BusinessDomainException {
        this.mTypeOfCalculationCase = typeOfCalculationCase;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = cert.getEmployee();
        this.mFesterBetrag = mFixedAmount;
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.mCalculation = new Calculation();
        super.initDBBG();
    }

    public void init(Employee empl, Date effectiveFrom, Date validFrom, BigDecimal mFixedAmount, TypeOfCalculationCase typeOfCalculationCase) throws BusinessDomainException {
        this.mTypeOfCalculationCase = typeOfCalculationCase;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = empl;
        this.mFesterBetrag = mFixedAmount;
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.mCalculation = new Calculation();
        super.initDBBG();
    }

    public void init(Employee empl, Date effectiveFrom, Date validFrom, ValuePosition zusaetzlicheAWA, TypeOfCalculationCase typeOfCalculationCase) throws BusinessDomainException {
        this.mTypeOfCalculationCase = typeOfCalculationCase;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = empl;
        this.mFesterBetrag = BigDecimal.ZERO;
        this.mZusaetzlicheAWA = zusaetzlicheAWA;
        Date[] datesOfCalculation = this.mEmployee.checkAndCorrectStartOfCalculation(this.mEffectiveFrom, this.mValidFrom);
        this.mEffectiveFrom = datesOfCalculation[0];
        this.mValidFrom = datesOfCalculation[1];
        this.mCalculation = new Calculation();
        super.initDBBG();
    }

    @Override
    public void start() throws BusinessDomainException {
        if (this.mEffectiveFrom == null || this.mValidFrom == null) {
            return;
        }
        Date cs = this.mReportHelper.getCalculationStartDate(this.mEmployee.getPCompany().getActiveCompanyFoundation());
        if (DateHelper.beforeOrEqual((Date)cs, (Date)this.mValidFrom)) {
            this.createNewValuePositionHistory();
            this.mValuePositionHistory.sort();
            this.evaluateValuePositionHistory();
            this.mValuePositionHistory.sort();
            this.calculateSummary();
        }
    }

    public BigDecimal getGrossWage() {
        if (!this.mGrossWageIsLoaded) {
            this.mGrossWageIsLoaded = true;
            if (this.mValuePositionHistory != null) {
                ValuePosition[] valuePositions;
                for (ValuePosition vp : valuePositions = this.mValuePositionHistory.getItems(DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                    switch (vp.getValueType().getValueTypeKey()) {
                        case 111460: {
                            this.mHasEntgeltumwandlung = true;
                        }
                        case 130510: 
                        case 130560: {
                            this.mGrossWage = this.mGrossWage.add(vp.getResult());
                        }
                    }
                }
            }
        }
        return this.mGrossWage;
    }

    public BigDecimal getNetWage() throws BusinessDomainException {
        if (!this.mNetWageIsLoaded) {
            if (this.mHasEntgeltumwandlung) {
                CertificateCalculationCase calc = new CertificateCalculationCase();
                calc.init(this.mEmployee, this.mEffectiveFrom, this.mValidFrom, this.mGrossWage);
                calc.start();
                this.mNetWage = calc.getNetWage();
                calc.removeValuesOfCalculation();
            } else {
                this.mNetWageIsLoaded = true;
                if (this.mValuePositionHistory != null) {
                    ValuePosition[] vpArray;
                    ValuePosition[] anwenderWertartvps = this.mValuePositionHistory.getItemsOfUserValueTypes();
                    ArrayList<ValueType> steuerpflSFNvtList = new ArrayList<ValueType>();
                    if (anwenderWertartvps.length > 0) {
                        for (ValuePosition valuePosition : anwenderWertartvps) {
                            if (valuePosition.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getValueTypeEvaluation().getBonusValues().getTaxableVT() == null) continue;
                            steuerpflSFNvtList.add(valuePosition.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getValueTypeEvaluation().getBonusValues().getTaxableVT());
                        }
                    }
                    ArrayList<ValuePosition> steuerpflSFNvps = new ArrayList<ValuePosition>();
                    for (ValueType vt : steuerpflSFNvtList) {
                        ValuePosition[] vps = this.mValuePositionHistory.getItems(vt.getValueTypeKey(), this.mEffectiveFrom, DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom));
                        if (vps.length <= 0) continue;
                        ValuePosition[] valuePositionArray = vps;
                        int n = valuePositionArray.length;
                        for (int i = 0; i < n; ++i) {
                            ValuePosition vp = valuePositionArray[i];
                            steuerpflSFNvps.add(vp);
                        }
                    }
                    ValuePosition[] steuerpflSFNvpArray = steuerpflSFNvps.toArray(new ValuePosition[steuerpflSFNvps.size()]);
                    ArrayList<ValueType> svpflSFNvtList = new ArrayList<ValueType>();
                    if (anwenderWertartvps.length > 0) {
                        for (ValuePosition valuePosition : anwenderWertartvps) {
                            if (valuePosition.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getValueTypeEvaluation().getBonusValues().getVTContributory() == null) continue;
                            svpflSFNvtList.add(valuePosition.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getValueTypeEvaluation().getBonusValues().getVTContributory());
                        }
                    }
                    ArrayList<ValuePosition> svpflSFNvps = new ArrayList<ValuePosition>();
                    for (ValueType vt : svpflSFNvtList) {
                        ValuePosition[] vps = this.mValuePositionHistory.getItems(vt.getValueTypeKey(), this.mEffectiveFrom, DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom));
                        if (vps.length <= 0) continue;
                        ValuePosition[] valuePositionArray = vps;
                        int n = valuePositionArray.length;
                        for (int i = 0; i < n; ++i) {
                            ValuePosition vp = valuePositionArray[i];
                            svpflSFNvps.add(vp);
                        }
                    }
                    ValuePosition[] svpflSFNvpArray = svpflSFNvps.toArray(new ValuePosition[svpflSFNvps.size()]);
                    block13: for (ValuePosition valuePosition : vpArray = this.mValuePositionHistory.getItems(DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                        if (!this.isValueTypeToAdd(valuePosition.getValueType().getValueTypeKey())) continue;
                        switch (valuePosition.getValueType().getValueTypeKey()) {
                            case 770000: 
                            case 770005: 
                            case 770110: 
                            case 771000: 
                            case 771110: {
                                this.mNetWage = this.mNetWage.subtract(valuePosition.getResult());
                                continue block13;
                            }
                            case 250510: 
                            case 250610: 
                            case 774510: 
                            case 774511: 
                            case 774512: 
                            case 774514: 
                            case 774550: 
                            case 774560: 
                            case 774565: 
                            case 774760: 
                            case 774761: 
                            case 774762: 
                            case 774764: 
                            case 774800: 
                            case 774810: 
                            case 774815: {
                                if (!this.checkBeitragspflichtigLfd(valuePosition)) continue block13;
                                this.mNetWage = this.mNetWage.subtract(valuePosition.getResult());
                                continue block13;
                            }
                            case 770020: 
                            case 770025: 
                            case 770120: 
                            case 771020: 
                            case 771120: {
                                this.mNetWage = this.mNetWage.add(valuePosition.getResult());
                                continue block13;
                            }
                            case 775510: 
                            case 775512: 
                            case 775514: 
                            case 775520: 
                            case 775550: 
                            case 775555: 
                            case 775560: {
                                if (!this.checkBeitragspflichtigLfd(valuePosition)) continue block13;
                                this.mNetWage = this.mNetWage.add(valuePosition.getResult());
                                continue block13;
                            }
                            case 130515: {
                                if (!this.checkSfnOf130515(valuePosition, svpflSFNvpArray)) continue block13;
                                this.mNetWage = this.mNetWage.add(valuePosition.getResult());
                                continue block13;
                            }
                            default: {
                                if (this.checkBeitragspflichtigLfd(valuePosition)) {
                                    this.mNetWage = this.mNetWage.add(valuePosition.getResult());
                                    continue block13;
                                }
                                if (!this.checkSfnOf700100(valuePosition, steuerpflSFNvpArray)) continue block13;
                                this.mNetWage = this.mNetWage.add(valuePosition.getResult());
                            }
                        }
                    }
                }
            }
        }
        return this.mNetWage;
    }

    public BigDecimal getNetWageMUG() throws BusinessDomainException {
        if (this.mHasEntgeltumwandlung) {
            CertificateCalculationCase calc = new CertificateCalculationCase();
            calc.init(this.mEmployee, this.mEffectiveFrom, this.mValidFrom, this.mGrossWage);
            calc.start();
            this.mNetWageMUG = calc.getNetWage();
            calc.removeValuesOfCalculation();
        } else {
            this.mNetWageIsLoaded = true;
            if (this.mValuePositionHistory != null) {
                ValuePosition[] vpArray;
                BigDecimal svTage = BigDecimal.ZERO;
                block5: for (ValuePosition vPos : vpArray = this.mValuePositionHistory.getItems(DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 700400: {
                            this.mNetWageMUG = this.mNetWageMUG.add(vPos.getResult());
                            continue block5;
                        }
                        case 770020: 
                        case 770025: 
                        case 771020: 
                        case 775510: 
                        case 775512: 
                        case 775514: 
                        case 775520: 
                        case 775550: 
                        case 775555: 
                        case 775560: 
                        case 775650: 
                        case 775655: 
                        case 775720: 
                        case 775725: {
                            this.mNetWageMUG = this.mNetWageMUG.add(vPos.getResult());
                            continue block5;
                        }
                        case 770000: 
                        case 770005: 
                        case 770010: 
                        case 771000: 
                        case 771010: 
                        case 774510: 
                        case 774511: 
                        case 774512: 
                        case 774514: 
                        case 774550: 
                        case 774760: 
                        case 774761: 
                        case 774762: 
                        case 774764: 
                        case 774800: {
                            this.mNetWageMUG = this.mNetWageMUG.subtract(vPos.getResult());
                        }
                    }
                }
            }
        }
        return this.mNetWageMUG;
    }

    public BigDecimal getSumOfValuePosition(int valueTypeNumber) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        if (this.mValuePositionHistory != null) {
            ValuePosition[] vpArray;
            for (ValuePosition vPos : vpArray = this.mValuePositionHistory.getItems(valueTypeNumber)) {
                result = result.add(vPos.getResult());
            }
        }
        return result;
    }

    private boolean isValueTypeToAdd(int valueTypeKey) {
        switch (valueTypeKey) {
            case 130515: 
            case 250510: 
            case 250610: 
            case 700100: 
            case 770000: 
            case 770005: 
            case 770020: 
            case 770025: 
            case 770110: 
            case 770120: 
            case 771000: 
            case 771020: 
            case 771110: 
            case 771120: 
            case 774510: 
            case 774511: 
            case 774512: 
            case 774514: 
            case 774550: 
            case 774560: 
            case 774565: 
            case 774760: 
            case 774761: 
            case 774762: 
            case 774764: 
            case 774800: 
            case 774810: 
            case 774815: 
            case 775510: 
            case 775512: 
            case 775514: 
            case 775520: 
            case 775550: 
            case 775555: 
            case 775560: {
                return true;
            }
        }
        return false;
    }

    public BigDecimal getSVBeitraege() {
        if (!this.mSVBeitraegeIsLoaded) {
            this.mSVBeitraegeIsLoaded = true;
            if (this.mValuePositionHistory != null) {
                block4: for (ValuePosition valuePosition : this.mValuePositionHistory.getItems(DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                    switch (valuePosition.getValueType().getValueTypeKey()) {
                        case 250510: 
                        case 250610: 
                        case 320510: 
                        case 770000: 
                        case 770005: 
                        case 770010: 
                        case 770110: 
                        case 771000: 
                        case 771010: 
                        case 771110: 
                        case 774510: 
                        case 774511: 
                        case 774512: 
                        case 774514: 
                        case 774550: 
                        case 774560: 
                        case 774565: {
                            this.mSVBeitraege = this.mSVBeitraege.add(valuePosition.getResult());
                            continue block4;
                        }
                        case 770020: 
                        case 770025: 
                        case 770030: 
                        case 770035: 
                        case 770040: 
                        case 770045: 
                        case 770120: 
                        case 770130: 
                        case 770140: 
                        case 771020: 
                        case 771030: 
                        case 771040: 
                        case 771120: 
                        case 771130: 
                        case 771140: 
                        case 775510: 
                        case 775512: 
                        case 775514: 
                        case 775520: 
                        case 775550: 
                        case 775555: 
                        case 775560: {
                            this.mSVBeitraege = this.mSVBeitraege.subtract(valuePosition.getResult());
                        }
                    }
                }
            }
        }
        return this.mSVBeitraege;
    }

    public BigDecimal getStAbzuege() throws BusinessDomainException {
        if (!this.mStAbzuegeIsLoaded) {
            this.mStAbzuegeIsLoaded = true;
            if (this.mValuePositionHistory != null) {
                for (ValuePosition valuePosition : this.mValuePositionHistory.getItems(DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getLastDayOfMonth((Date)this.mEffectiveFrom), DateHelper.getFirstDayOfMonth((Date)this.mValidFrom), DateHelper.getLastDayOfMonth((Date)this.mValidFrom))) {
                    switch (valuePosition.getValueType().getValueTypeKey()) {
                        case 220010: {
                            this.mStAbzuege = this.mStAbzuege.add(valuePosition.getResult());
                        }
                    }
                }
            }
        }
        return this.mStAbzuege;
    }

    private boolean checkBeitragspflichtigLfd(ValuePosition valuePosition) {
        ValuePosition[] lVpArray;
        for (ValuePosition lValuePosition : lVpArray = this.parentUndFolgen(valuePosition)) {
            switch (lValuePosition.getValueType().getValueTypeKey()) {
                case 130510: 
                case 130560: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean checkSfnOf700100(ValuePosition valuePosition, ValuePosition[] steuerpflSFNvp) {
        ValuePosition parent = (ValuePosition)valuePosition.getParentObject();
        if (parent != null) {
            for (ValuePosition vp : steuerpflSFNvp) {
                if (parent.getValueType().getValueTypeKey() != vp.getValueType().getValueTypeKey()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSfnOf130515(ValuePosition valuePosition, ValuePosition[] svpflSFNvps) {
        ValuePosition parent = (ValuePosition)valuePosition.getParentObject();
        if (parent != null) {
            for (ValuePosition vp : svpflSFNvps) {
                if (parent.getValueType().getValueTypeKey() != vp.getValueType().getValueTypeKey()) continue;
                return true;
            }
        }
        return false;
    }

    public ValuePosition[] parentUndFolgen(ValuePosition lvp) {
        try {
            ValuePosition vp = (ValuePosition)lvp.getParentObject();
            return this.getConsequensesOfValuePosition(vp);
        }
        catch (ClassCastException e) {
            return this.getConsequensesOfValuePosition(lvp);
        }
    }

    private ValuePosition[] getConsequensesOfValuePosition(ValuePosition vp) {
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        vpList.add(vp);
        ValuePosition[] vpArray = this.getValuePositionHistory().getItems(vp);
        vpList.addAll(Arrays.asList(vpArray));
        return vpList.toArray(new ValuePosition[vpList.size()]);
    }

    @Override
    protected void createNewValuePositionHistory() throws BusinessDomainException {
        ValuePosition[] vpArray;
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mFesterBetrag)) {
            this.mValuePositionHistory = new ValuePositionHistory(this.create99990FromCalulationCase(this.mFesterBetrag));
        } else if (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)this.mReportHelper.getCalculationStartDate(this.mEmployee.getPCompany().getActiveCompanyFoundation()))) {
            vpArray = this.createValuePositionFromFixedPayment();
            Date lastDayOfMonth = DateHelper.getLastDayOfMonth((Date)this.getValidFrom());
            LinkedList<ValuePosition> myList = new LinkedList<ValuePosition>();
            for (ValuePosition vp : vpArray) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom())) continue;
                if (DateHelper.before((Date)this.getValidFrom(), (Date)this.getEffectiveFrom())) {
                    if (!DateHelper.beforeOrEqual((Date)vp.getValidFrom(), (Date)lastDayOfMonth)) continue;
                    myList.add(vp);
                    continue;
                }
                myList.add(vp);
            }
            vpArray = new ValuePosition[myList.size()];
            vpArray = myList.toArray(vpArray);
            this.mValuePositionHistory = new ValuePositionHistory(vpArray);
            if (this.mZusaetzlicheAWA != null) {
                vpArray = new ValuePosition[]{this.mZusaetzlicheAWA};
                this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            }
            vpArray = this.createValuePositionFromVarPayment();
            this.addValuePositionCompressedToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromERASettings();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromScalePayment();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEMaterielExpenses();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.createValuePositionFromEEAbsentTime();
            this.addValuePositionToHistory(vpArray, lastDayOfMonth);
            vpArray = this.mEmployee.getInsurance(this.mEffectiveFrom, this.mValidFrom).getPersonGroup() == 103 ? (DateHelper.afterOrEqual((Date)this.mValidFrom, (Date)new VDate(2009, 0, 1).getDate()) ? this.createValuePositionFromEEDataCredit() : this.createValuePositionForAgePartTime()) : this.createValuePositionFromEEDataCredit();
            for (ValuePosition vp : vpArray) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom()) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)this.getValidFrom())) continue;
                this.mValuePositionHistory.addItem(vp);
            }
            for (ValuePosition vp : vpArray = this.createValuePosition110595FromCalculationCase()) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.getEffectiveFrom()) || !DateHelper.equal((Date)vp.getValidFrom(), (Date)this.getValidFrom())) continue;
                this.mValuePositionHistory.addItem(vp);
            }
            this.checkOnlyPermanentContributoryValuetypes();
            if (this.mValuePositionHistory == null) {
                this.mValuePositionHistory = new ValuePositionHistory(new ValuePosition[0]);
            }
        }
        if (this.mTypeOfCalculationCase == TypeOfCalculationCase.VerdienstausfallOhneFZQuarantaene || this.mTypeOfCalculationCase == TypeOfCalculationCase.VerdienstausfallOhneFZBetreuungKind || this.mTypeOfCalculationCase == TypeOfCalculationCase.Verdienstausfall || this.mTypeOfCalculationCase == TypeOfCalculationCase.PkvPpVBerechnungOhneFZ) {
            vpArray = this.createValuePositionFromEEPensionScheme();
            this.addValuePositionToHistory(vpArray, DateHelper.getLastDayOfMonth((Date)this.getValidFrom()));
        }
    }

    private void checkOnlyPermanentContributoryValuetypes() throws BusinessDomainException {
        List<ValuePosition> vpList = this.mValuePositionHistory.getAll();
        Iterator<ValuePosition> vpIt = vpList.iterator();
        ArrayList<ValuePosition> result = new ArrayList<ValuePosition>();
        while (vpIt.hasNext()) {
            ValuePosition vp = vpIt.next();
            ConsequenceOfValueType[] covts = vp.getValueType().getValueTypeTP(this.mEffectiveFrom, this.mValidFrom).getConsequenceForOrientation();
            boolean isEgaOrNonContributory = ValuePositionHistory.isEgaOrNonContributory(covts);
            if (isEgaOrNonContributory) {
                vp.makeReadOnly();
                continue;
            }
            result.add(vp);
        }
        ValuePosition[] vpArray = new ValuePosition[result.size()];
        this.mValuePositionHistory = new ValuePositionHistory(result.toArray(vpArray));
    }

    private ValuePosition[] create99990FromCalulationCase(BigDecimal festerBetrag) throws BusinessDomainException {
        boolean hatKammerbeitrag;
        block5: {
            hatKammerbeitrag = false;
            try {
                Tax tax = this.mEmployee.getTax(this.mEffectiveFrom, this.mValidFrom);
                if (tax != null) {
                    hatKammerbeitrag = tax.getAssociationEE();
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block5;
                throw e;
            }
        }
        ArrayList<ValuePosition> vpList = new ArrayList<ValuePosition>();
        ValuePosition baseVP = ValuePosition.create((CalculationCase)this, 99990);
        baseVP.setBasicResult(festerBetrag);
        baseVP.setResult(festerBetrag);
        vpList.add(baseVP);
        if (hatKammerbeitrag) {
            ValuePosition kammerVp = ValuePosition.create((CalculationCase)this, 115200);
            kammerVp.setBasicResult(festerBetrag);
            kammerVp.setResult(festerBetrag);
            kammerVp.setGenesisOfParentObjects(baseVP);
            kammerVp.setParentObject(baseVP);
            vpList.add(kammerVp);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mZVKBrutto)) {
            ValuePosition zvkVp = ValuePosition.create((CalculationCase)this, 100901);
            zvkVp.setBasicResult(this.mZVKBrutto);
            zvkVp.setResult(this.mZVKBrutto);
            zvkVp.setGenesisOfParentObjects(baseVP);
            zvkVp.setParentObject(baseVP);
            vpList.add(zvkVp);
        }
        ValuePosition[] vps = new ValuePosition[vpList.size()];
        vps = vpList.toArray(vps);
        return vps;
    }

    public void removeValuesOfCalculation() {
        if (this.mValuePositionHistory == null) {
            return;
        }
        for (ValuePosition vp : this.mValuePositionHistory.getAll()) {
            vp.makeReadOnly();
        }
    }

    public void setZVKBrutto(BigDecimal zVKBrutto) {
        this.mZVKBrutto = zVKBrutto;
    }
}

