/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.calculation;

import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationData;
import com.varial.personnel.domain.calculation.CalculationPersistencyManager;
import com.varial.personnel.domain.calculation.MKPosition;
import com.varial.personnel.domain.employee.Employee;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Calculation
extends PersistentObject {
    private static final int PRIORITY = 100;
    private Date mStartTimePoint;
    private String mGenesisObjectType;
    private String mReleaseLevel;
    private boolean mMaerzklausel;
    private Date mEffectiveFrom;
    private Date mValidFrom;
    private boolean MaerzklauselExecuted = false;
    private Date MaerzklauselGueltigAb = null;
    private List<MKPosition> mListOfMKPositions = new LinkedList<MKPosition>();
    private BigDecimal mSteuerlicheRueckrechnungsdifferenzAusVorjahr;
    private boolean mSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden = false;
    private boolean mZVKRueckrechnungsdifferenzAusVorjahrVorhanden = false;
    private boolean mCancellation = false;
    private Employee mSuccessor;
    private Date mSuccessorEvaluationValidFrom;
    private boolean mUebertragSteuerDiffVorjahrNachSuccessor = false;
    private final Map<Employee, Date> mEmployeeValuationMap = new HashMap<Employee, Date>();
    private String mUserID = "";

    public Calculation() {
        super(100);
        this.setLastuser(SessionContext.getInstance().getSession().getUserCode());
        this.setStartTimePoint(new Date());
        this.setReleaseLevel(Version.getVersion());
    }

    public static Calculation getCalculation(String objectid) {
        return new Calculation(objectid);
    }

    private Calculation(String objectid) {
        super(100, objectid);
    }

    public Calculation(String objectid, int version) {
        super(100, objectid, version);
    }

    protected Calculation(boolean readOnly) {
        super(100, readOnly);
    }

    protected void load() {
        CalculationPersistencyManager.load((Calculation)this);
    }

    protected void saveImpl() {
        CalculationPersistencyManager.save((Calculation)this);
    }

    protected void deleteImpl() {
        CalculationPersistencyManager.delete((Calculation)this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return this.getLastuser() + " / " + DateMapper.toString((Date)this.mStartTimePoint);
    }

    public static Calculation[] getCalculation(Order[] sortierung, Criterion filter) {
        return CalculationPersistencyManager.query((Order[])sortierung, (Criterion)filter);
    }

    protected void setData(CalculationData data) {
        this.mStartTimePoint = data.getStartTimePoint();
        this.mGenesisObjectType = data.getGenesisObjectType();
        this.mReleaseLevel = data.getReleaseLevel();
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public Date getStartTimePoint() {
        this.requireLoaded();
        return this.mStartTimePoint;
    }

    public void setStartTimePoint(Date startTimePoint) {
        this.mStartTimePoint = startTimePoint;
    }

    public String getGenesisObjectType() {
        this.requireLoaded();
        return this.mGenesisObjectType;
    }

    public void setGenesisObjectType(String genesisObjectType) {
        this.mGenesisObjectType = genesisObjectType;
    }

    public String getReleaseLevel() {
        this.requireLoaded();
        return this.mReleaseLevel;
    }

    public void setReleaseLevel(String releaseLevel) {
        this.mReleaseLevel = releaseLevel;
    }

    public Date getMaerzklauselGueltigAb() {
        return this.MaerzklauselGueltigAb;
    }

    public void setMaerklauselGueltigAb(Date mkga) {
        this.MaerzklauselGueltigAb = mkga;
    }

    public void setMaerzklauselExecuted(boolean mk) {
        this.MaerzklauselExecuted = mk;
        if (!mk) {
            this.mListOfMKPositions = new LinkedList<MKPosition>();
        }
    }

    public boolean getMaerzklauselExecuted() {
        return this.MaerzklauselExecuted;
    }

    public void setMaerzklausel(boolean mk) {
        this.mMaerzklausel = mk;
    }

    public boolean getMaerzklausel() {
        return this.mMaerzklausel;
    }

    public void addListOfMKPositions(MKPosition result) {
        this.mListOfMKPositions.add(result);
    }

    public List<MKPosition> getListOfMKPositions() {
        return this.mListOfMKPositions;
    }

    public BigDecimal getSteuerlicheRueckrechnungsdifferenzAusVorjahr() {
        return this.mSteuerlicheRueckrechnungsdifferenzAusVorjahr;
    }

    public void setSteuerlicheRueckrechnungsdifferenzAusVorjahr(BigDecimal steuerlicheRueckrechnungsdifferenzAusVorjahr) {
        this.mSteuerlicheRueckrechnungsdifferenzAusVorjahr = this.mSteuerlicheRueckrechnungsdifferenzAusVorjahr.add(steuerlicheRueckrechnungsdifferenzAusVorjahr);
    }

    public boolean isSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden() {
        return this.mSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden;
    }

    public boolean isZVKRueckrechnungsdifferenzAusVorjahrVorhanden() {
        return this.mZVKRueckrechnungsdifferenzAusVorjahrVorhanden;
    }

    public void setSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden(boolean steuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden) {
        this.mSteuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden = steuerlicheRueckrechnungsdifferenzAusVorjahrVorhanden;
    }

    public void setZVKRueckrechnungsdifferenzAusVorjahrVorhanden(boolean zVKRueckrechnungsdifferenzAusVorjahrVorhanden) {
        this.mZVKRueckrechnungsdifferenzAusVorjahrVorhanden = zVKRueckrechnungsdifferenzAusVorjahrVorhanden;
    }

    public boolean isReasonDifferentFromEmployee() {
        String s = this.getGenesisObjectType();
        return s.endsWith("WorkingTime") || s.endsWith("ValueType") || s.endsWith("PlantSettings") || s.endsWith("PlantFoundations") || s.endsWith("CompanySettings") || s.endsWith("CompanyFoundations") || s.endsWith("PayScaleGroup") || s.endsWith("SocialInsurance") || s.endsWith("LumpSumIncomeTax") || s.endsWith("HealthFund") || s.endsWith("FStateRegion") || s.endsWith("FStateRegionCalendar") || s.endsWith("AgePartTimeModel") || s.endsWith("wagefactor.WageFactor") || s.endsWith("Average") || s.endsWith("AssignmentPCompanyHealthFund") || s.endsWith("absenttime.AbsentTime") || s.endsWith("ERAModel") || s.endsWith("IncreaseInPayRates") || s.endsWith("HealthFundItsg") || s.endsWith("CreditModel") || s.endsWith("AssignmentPCompanyZVK") || s.endsWith("Recipient") || s.endsWith("ChildAllowance") || s.endsWith("SocialInsuranceXmlImport");
    }

    public boolean getCancellation() {
        return this.mCancellation;
    }

    public void setCancellation(boolean cancellation) {
        this.mCancellation = cancellation;
    }

    public void setSuccessor(Employee successor) {
        this.mSuccessor = successor;
    }

    public Employee getSuccessor() {
        return this.mSuccessor;
    }

    public void setSuccessorEvaluationValidFrom(Date successorEvaluationValidFrom) {
        this.mSuccessorEvaluationValidFrom = successorEvaluationValidFrom;
    }

    public Date getSuccessorEvaluationValidFrom() {
        return this.mSuccessorEvaluationValidFrom;
    }

    public void setUebertragSteuerDiffVorjahrNachSuccessor(boolean hatUebertrag) {
        this.mUebertragSteuerDiffVorjahrNachSuccessor = hatUebertrag;
    }

    public boolean hatUebertragSteuerDiffVorjahrNachSuccessor() {
        return this.mUebertragSteuerDiffVorjahrNachSuccessor;
    }

    public void setUserID(String userID) {
        this.mUserID = userID;
    }

    public String getUserID() {
        return this.mUserID;
    }

    public Map<Employee, Date> getEmployeeValuationMap() {
        return this.mEmployeeValuationMap;
    }

    public void addEmployeeToValuationMap(Employee empl, Date emplValuationDate) {
        Date currentValuationDate = this.mEmployeeValuationMap.get((Object)empl);
        if (currentValuationDate == null) {
            this.mEmployeeValuationMap.put(empl, emplValuationDate);
        } else if (DateHelper.before((Date)emplValuationDate, (Date)currentValuationDate)) {
            this.mEmployeeValuationMap.put(empl, emplValuationDate);
        }
    }
}

