/*
 * Decompiled with CFR 0.152.
 */
package de.varial.accounting.domain.ecsaleslist.export.perfidia;

import ce.varial.accounting.domain.vatreturn.VATReturnCEExceptionMapper;
import com.varial.accounting.domain.ecsaleslist.ECSalesList;
import com.varial.accounting.domain.ecsaleslist.ECSalesListEntry;
import com.varial.accounting.domain.ecsaleslist.ECSalesListHelper;
import com.varial.accounting.domain.ecsaleslist.ECSalesListReportEntry;
import com.varial.accounting.domain.ecsaleslistcorrection.ECSalesListCorrection;
import com.varial.accounting.domain.ecsaleslistcorrection.ECSalesListCorrectionEntry;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.ecsaleslist.ECSalesListTaxTypeEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.company.CompanyExceptionMapper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.serverbase.domain.textoutput.BigDecimalField;
import com.varial.serverbase.domain.textoutput.IntegerField;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.shared.Version;
import de.varial.accounting.domain.perfidia.PerfidiaCharacterConverter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ECSalesListDEPerfidiaLineGeneratorImpl
implements LineGenerator {
    private AccountingCompany mCompany;
    private PostalAddress mCompanyAddress;
    private OutputLine mHeadLine;
    private OutputLine mHeadLine2;
    private OutputLine mEndLine;
    private OutputLine[] mDataLines;
    private int mCounter = 1;
    private BigDecimal mAmountSum;
    private String mCompanyEcTaxNumber;
    private String mPeriodCode;
    private int mCalendarYear;
    private String mPeriodAsString;
    private boolean mIsCorrection;
    private boolean mWithNewRule072010;
    boolean mIsMonthArrangement = false;
    boolean mIsAvoidance = false;
    private boolean mWithNewRule122025;
    private static final Pattern BENUTZERKONTO_ID_PATTERN = Pattern.compile("#BENUTZERKONTO-ID=([A-Za-z0-9]{10})#", 2);

    public ECSalesListDEPerfidiaLineGeneratorImpl(ECSalesList salesList) throws BusinessDomainException {
        this.init(salesList, null);
    }

    public ECSalesListDEPerfidiaLineGeneratorImpl(ECSalesListCorrection salesListCorrection) throws BusinessDomainException {
        this.init(salesListCorrection.getECSalesList(), salesListCorrection);
    }

    private void init(ECSalesList salesList, ECSalesListCorrection salesListCorrection) throws BusinessDomainException {
        this.mIsCorrection = salesListCorrection != null;
        this.mCompany = salesList.getAccountingCompany();
        this.mCompanyAddress = this.mCompany.getCurrentAddress().getPostalAddress();
        this.mCompanyEcTaxNumber = this.mCompanyAddress.getCountry().getECCountryCode() + this.mCompany.getECTax().getTaxNumber();
        this.mPeriodCode = this.getPeriodCode(salesList);
        this.mAmountSum = BigDecimal.ZERO;
        this.mCalendarYear = salesList.getCalendarYear();
        this.mPeriodAsString = salesList.getPeriodAsString();
        this.mWithNewRule072010 = false;
        this.mWithNewRule122025 = true;
        this.mIsMonthArrangement = ECSalesListHelper.isMonthArrangement((ECSalesList)salesList);
        this.mIsAvoidance = ECSalesListHelper.isAvoidance((ECSalesList)salesList);
        if (this.mWithNewRule122025) {
            this.mHeadLine = this.createHeadLineVOSZ();
            this.mHeadLine2 = this.createHeadLineZM1SZ();
            List<OutputLine> dataList = null;
            dataList = this.mIsCorrection ? this.getDataList(salesListCorrection, (Boolean)this.mWithNewRule122025) : this.getDataList(salesList, (Boolean)this.mWithNewRule122025);
            dataList.add(0, this.mHeadLine2);
            this.mDataLines = new OutputLine[dataList.size()];
            dataList.toArray(this.mDataLines);
            this.mEndLine = this.createEndLine2Nachlaufsatz();
        } else {
            this.mHeadLine = this.createHeadLine();
            List<OutputLine> dataList = null;
            dataList = this.mIsCorrection ? this.getDataList(salesListCorrection, (Boolean)this.mWithNewRule122025) : this.getDataList(salesList, (Boolean)this.mWithNewRule122025);
            dataList.add(this.createEndLine1());
            this.mDataLines = new OutputLine[dataList.size()];
            dataList.toArray(this.mDataLines);
            this.mEndLine = this.createEndLine2();
        }
    }

    private List<OutputLine> getDataList(ECSalesListCorrection salesListCorrection, Boolean mWithNewRule122025) throws BusinessDomainException {
        LinkedList<OutputLine> dataList = new LinkedList<OutputLine>();
        List<OutputLine> subList = null;
        boolean roundAmounts = salesListCorrection.getECSalesList().getRoundAmounts();
        ECSalesListCorrectionEntry[] entries = salesListCorrection.getReportedCorrectionEntries();
        for (int i = 0; i < entries.length; ++i) {
            ECSalesListCorrectionEntry corrEntry = entries[i];
            ECSalesListEntry entry = entries[i].getOldECSalesListEntry();
            if (entry != null && !ECSalesListHelper.isNewAmount((ECSalesListEntry)entry, (ECSalesListCorrectionEntry)corrEntry)) {
                subList = mWithNewRule122025 != false ? this.createDataLineZM2SZ(entry.getEcCountryCode(), entry.getVatNumber(), BigDecimal.ZERO, entry.getTaxType()) : this.createDataLine(entry.getEcCountryCode(), entry.getVatNumber(), BigDecimal.ZERO, entry.getTaxType());
                dataList.addAll(subList);
                ++this.mCounter;
            }
            subList = mWithNewRule122025 != false ? this.createDataLineZM2SZ(corrEntry.getNewECCountryCode(), corrEntry.getNewEUTaxNumber(), ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)corrEntry.getNewReportedAmount(), (boolean)roundAmounts), corrEntry.getNewTaxType()) : this.createDataLine(corrEntry.getNewECCountryCode(), corrEntry.getNewEUTaxNumber(), ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)corrEntry.getNewReportedAmount(), (boolean)roundAmounts), corrEntry.getNewTaxType());
            dataList.addAll(subList);
            this.mAmountSum = this.mAmountSum.add(ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)corrEntry.getNewReportedAmount(), (boolean)roundAmounts));
            ++this.mCounter;
        }
        return dataList;
    }

    private List<OutputLine> getDataList(ECSalesList salesList, Boolean mWithNewRule122025) {
        LinkedList<OutputLine> dataList = new LinkedList<OutputLine>();
        List entries = salesList.getReportEntries();
        for (ECSalesListReportEntry entry : entries) {
            BigDecimal amount = ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)entry.getReportAmount(), (boolean)salesList.getRoundAmounts());
            if (mWithNewRule122025.booleanValue()) {
                dataList.addAll(this.createDataLineZM2SZ(entry.getEcCountryCode(), entry.getVatNumber(), amount, entry.getTaxType()));
            } else {
                dataList.addAll(this.createDataLine(entry.getEcCountryCode(), entry.getVatNumber(), amount, entry.getTaxType()));
            }
            this.mAmountSum = this.mAmountSum.add(amount);
            ++this.mCounter;
        }
        return dataList;
    }

    private String getPeriodCode(ECSalesList salesList) {
        String result = "05";
        if (salesList.getReportFrequency().value() == 0) {
            result = new IntegerField(2, '0', false, salesList.getQuarter()).getAsString();
        } else if (salesList.getReportFrequency().value() == 2) {
            result = new IntegerField(2, '0', false, salesList.getMonth() + 21).getAsString();
        }
        return result;
    }

    private OutputLine createHeadLine() throws BusinessDomainException {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        if (StringMapper.isNullString((String)this.mCompanyAddress.getName()) || StringMapper.isNullString((String)this.mCompanyAddress.getStreet()) || StringMapper.isNullString((String)this.mCompanyAddress.getPostalCode()) || StringMapper.isNullString((String)this.mCompanyAddress.getTown())) {
            throw VATReturnCEExceptionMapper.makeAddressNotCompleteDomainException();
        }
        fieldList.add((OutputField)new TextField(4, ' ', false, 0, "VOSZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new IntegerField(1, '0', false, 0));
        String s = PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getName());
        if (s.length() > 22) {
            s = s.substring(0, 22);
        }
        fieldList.add((OutputField)new TextField(30, ' ', true, 0, s + " " + this.mPeriodAsString));
        fieldList.add((OutputField)new TextField(50, ' ', true, 0, "Varial Finanzbuchfuehrung"));
        fieldList.add((OutputField)new TextField(50, ' ', true, 0, Version.getVersion()));
        fieldList.add((OutputField)new TextField(6, ' ', true, 0, this.mCompany.getParticipantNumber()));
        fieldList.add((OutputField)new TextField(45, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getName())));
        fieldList.add((OutputField)new TextField(25, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getStreet())));
        fieldList.add((OutputField)new TextField(5, ' ', false, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getPostalCode())));
        fieldList.add((OutputField)new TextField(25, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getTown())));
        fieldList.add((OutputField)new TextField(267, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private List<OutputLine> createDataLine(String eCCountryCode, String eCTaxNumber, BigDecimal amount, ECSalesListTaxTypeEnum salesListTaxTypeEnum) {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        fieldList.add((OutputField)new TextField(5, ' ', true, 0, "ZM1SZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new TextField(11, ' ', true, 0, this.mCompanyEcTaxNumber));
        if (this.mIsCorrection) {
            fieldList.add((OutputField)new TextField(2, ' ', true, 0, "11"));
        } else {
            fieldList.add((OutputField)new TextField(2, ' ', true, 0, "10"));
        }
        fieldList.add((OutputField)new TextField(2, ' ', true, 0, this.mPeriodCode));
        fieldList.add((OutputField)new IntegerField(4, '0', true, this.mCalendarYear));
        fieldList.add((OutputField)new TextField(14, ' ', true, 0, eCCountryCode + eCTaxNumber));
        String sign = "0";
        if (amount.signum() < 0) {
            sign = "-";
        }
        fieldList.add((OutputField)new TextField(sign));
        BigDecimalField bdf = new BigDecimalField(11, '0', false, 0, ',', amount.abs());
        fieldList.add((OutputField)bdf);
        String s = "";
        if (salesListTaxTypeEnum.value() == 1) {
            s = "D";
        } else if (salesListTaxTypeEnum.value() == 3) {
            s = "S";
        }
        fieldList.add((OutputField)new TextField(1, ' ', true, 0, s));
        if (this.mWithNewRule072010) {
            s = "10";
            if (this.mIsMonthArrangement) {
                s = "11";
            }
            fieldList.add((OutputField)new TextField(2, ' ', true, 0, s));
            s = "10";
            if (this.mIsAvoidance) {
                s = "11";
            }
            fieldList.add((OutputField)new TextField(2, ' ', true, 0, s));
            fieldList.add((OutputField)new TextField(455, ' ', true, 0, ""));
        } else {
            fieldList.add((OutputField)new TextField(459, ' ', true, 0, ""));
        }
        OutputLine outputLine = PaymentHelper.getOutputLine(fieldList);
        LinkedList<OutputLine> subList = new LinkedList<OutputLine>();
        subList.add(outputLine);
        return subList;
    }

    private OutputLine createEndLine1() {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        fieldList.add((OutputField)new TextField(5, ' ', true, 0, "ZM2SZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new TextField(11, ' ', true, 0, this.mCompanyEcTaxNumber));
        fieldList.add((OutputField)new TextField(2, ' ', true, 0, this.mPeriodCode));
        fieldList.add((OutputField)new IntegerField(4, '0', true, this.mCalendarYear));
        String sign = "0";
        if (this.mAmountSum.signum() < 0) {
            sign = "-";
        }
        fieldList.add((OutputField)new TextField(sign));
        BigDecimalField bdf = new BigDecimalField(13, '0', false, 0, ',', this.mAmountSum.abs());
        fieldList.add((OutputField)bdf);
        fieldList.add((OutputField)new IntegerField(5, '0', false, this.mCounter - 1));
        fieldList.add((OutputField)new TextField(469, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private OutputLine createEndLine2() {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        fieldList.add((OutputField)new TextField(4, ' ', true, 0, "NCSZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new IntegerField(6, '0', false, this.mCounter));
        fieldList.add((OutputField)new TextField(500, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private OutputLine createHeadLineVOSZ() throws BusinessDomainException {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        if (StringMapper.isNullString((String)this.mCompanyAddress.getName()) || StringMapper.isNullString((String)this.mCompanyAddress.getStreet()) || StringMapper.isNullString((String)this.mCompanyAddress.getTown())) {
            throw VATReturnCEExceptionMapper.makeAddressNotCompleteDomainException();
        }
        fieldList.add((OutputField)new TextField(4, ' ', false, 0, "VOSZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 2));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new IntegerField(1, '0', false, 0));
        String s = PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getName());
        if (s.length() > 22) {
            s = s.substring(0, 22);
        }
        fieldList.add((OutputField)new TextField(30, ' ', true, 0, s + " " + this.mPeriodAsString));
        fieldList.add((OutputField)new TextField(50, ' ', true, 0, "Varial Finanzbuchfuehrung"));
        fieldList.add((OutputField)new TextField(50, ' ', true, 0, Version.getVersion()));
        String id = ECSalesListDEPerfidiaLineGeneratorImpl.extractBenutzerkontoId(this.mCompany.getNote());
        if (StringMapper.isNullString((String)id)) {
            throw CompanyExceptionMapper.makeECSalesListCompanyNumberForPefidiaIsMissingDomainException();
        }
        fieldList.add((OutputField)new TextField(10, ' ', true, 0, id));
        UUID uuid = UUID.randomUUID();
        fieldList.add((OutputField)new TextField(36, ' ', true, 0, uuid.toString()));
        fieldList.add((OutputField)new TextField(11, ' ', true, 0, this.mCompanyEcTaxNumber));
        Date today = new Date();
        fieldList.add((OutputField)new TextField(8, ' ', true, 0, DateMapper.toYYYYMMDDString((Date)today)));
        fieldList.add((OutputField)new TextField(6, ' ', true, 0, this.createUhrzeit(today)));
        fieldList.add((OutputField)new TextField(1, ' ', true, 0, "L"));
        fieldList.add((OutputField)new TextField(7, ' ', true, 0, "1111111"));
        fieldList.add((OutputField)new TextField(100, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getName())));
        fieldList.add((OutputField)new TextField(40, ' ', true, 0, ""));
        fieldList.add((OutputField)new TextField(30, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getStreet())));
        fieldList.add((OutputField)new TextField(10, ' ', true, 0, ""));
        fieldList.add((OutputField)new TextField(10, ' ', true, 0, ""));
        fieldList.add((OutputField)new TextField(10, ' ', false, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getPostalCode())));
        fieldList.add((OutputField)new TextField(30, ' ', true, 0, PerfidiaCharacterConverter.convertString((String)this.mCompanyAddress.getTown())));
        fieldList.add((OutputField)new TextField(2, ' ', true, 0, "DE"));
        fieldList.add((OutputField)new TextField(20, ' ', true, 0, ""));
        fieldList.add((OutputField)new TextField(42, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private OutputLine createHeadLineZM1SZ() {
        LinkedList<OutputField> outputLine = new LinkedList<OutputField>();
        outputLine.add((OutputField)new TextField(5, ' ', true, 0, "ZM1SZ"));
        outputLine.add((OutputField)new IntegerField(2, '0', false, 2));
        UUID uuid = UUID.randomUUID();
        outputLine.add((OutputField)new TextField(36, ' ', true, 0, uuid.toString()));
        if (this.mIsCorrection) {
            outputLine.add((OutputField)new TextField(2, ' ', true, 0, "11"));
        } else {
            outputLine.add((OutputField)new TextField(2, ' ', true, 0, "10"));
        }
        outputLine.add((OutputField)new TextField(2, ' ', true, 0, this.mPeriodCode));
        outputLine.add((OutputField)new IntegerField(4, '0', true, this.mCalendarYear));
        String s = "";
        s = "0";
        if (this.mIsMonthArrangement) {
            s = "1";
        } else if (this.mIsAvoidance) {
            s = "2";
        }
        outputLine.add((OutputField)new TextField(1, ' ', true, 0, s));
        outputLine.add((OutputField)new TextField(460, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(outputLine);
    }

    private List<OutputLine> createDataLineZM2SZ(String eCCountryCode, String eCTaxNumber, BigDecimal amount, ECSalesListTaxTypeEnum salesListTaxTypeEnum) {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        fieldList.add((OutputField)new TextField(5, ' ', true, 0, "ZM2SZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 2));
        UUID uuid = UUID.randomUUID();
        fieldList.add((OutputField)new TextField(36, ' ', true, 0, uuid.toString()));
        fieldList.add((OutputField)new TextField(2, ' ', true, 0, eCCountryCode));
        fieldList.add((OutputField)new TextField(12, ' ', true, 0, eCTaxNumber));
        String s = "";
        switch (salesListTaxTypeEnum.value()) {
            case 1: {
                s = "D";
                break;
            }
            case 0: {
                s = "L";
                break;
            }
            case 3: {
                s = "S";
                break;
            }
        }
        fieldList.add((OutputField)new TextField(1, ' ', true, 0, s));
        String sign = "0";
        if (amount.signum() < 0) {
            sign = "-";
        }
        fieldList.add((OutputField)new TextField(sign));
        BigDecimalField bdf = new BigDecimalField(11, '0', false, 0, ',', amount.abs());
        fieldList.add((OutputField)bdf);
        fieldList.add((OutputField)new TextField(442, ' ', true, 0, ""));
        OutputLine outputLine = PaymentHelper.getOutputLine(fieldList);
        LinkedList<OutputLine> subList = new LinkedList<OutputLine>();
        subList.add(outputLine);
        return subList;
    }

    private OutputLine createEndLine2Nachlaufsatz() {
        LinkedList<OutputField> fieldList = new LinkedList<OutputField>();
        fieldList.add((OutputField)new TextField(4, ' ', true, 0, "NCSZ"));
        fieldList.add((OutputField)new IntegerField(2, '0', false, 1));
        fieldList.add((OutputField)new IntegerField(6, '0', false, this.mCounter));
        fieldList.add((OutputField)new TextField(500, ' ', true, 0, ""));
        return PaymentHelper.getOutputLine(fieldList);
    }

    private String createUhrzeit(Date today) {
        return new SimpleDateFormat("HHmmss").format(today);
    }

    public static String extractBenutzerkontoId(String note) {
        if (note == null) {
            return null;
        }
        Matcher matcher = BENUTZERKONTO_ID_PATTERN.matcher(note);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public OutputLine getHeadline() {
        return this.mHeadLine;
    }

    public OutputLine[] getDataLines() {
        return this.mDataLines;
    }

    public OutputLine getEndline() {
        return this.mEndLine;
    }
}

