/*
 * Decompiled with CFR 0.152.
 */
package com.varial.transfer.domain.accounting.invoicetransaction;

import com.varial.accounting.domain.cashtransaction.CashTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransaction;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NominalLedger;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.accounting.domain.nominalledger.NominalLedgerTaxAccounts;
import com.varial.accounting.domain.nominaltransactionbase.INominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.INominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntryManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionTranslatableResourceUtils;
import com.varial.accounting.domain.nominaltransactionbase.tax.resolver.TaxEntryMatcher;
import com.varial.accounting.domain.openitem.IOpenItemDiscount;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.taxcode.ITaxRate;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxHandlingType;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.taxcalculation.ICalculatedTax;
import com.varial.accounting.domain.taxcode.taxcalculation.TaxCalculationRequestBuilder;
import com.varial.accounting.domain.taxcode.taxcalculation.TaxCalculationStrategy;
import com.varial.accounting.domain.taxcode.taxcalculation.TaxCalculationStrategyFactory;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.base.exception.BusinessDomainException;
import com.varial.costing.base.domain.actcostingdata.ActCosting;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.fileimport.FileImportExceptionMapper;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.transfer.domain.accounting.invoicetransaction.FixedAssetPreDiscountHelper;
import com.varial.transfer.domain.accounting.invoicetransaction.NonDeductibleInputTax;
import com.varial.transfer.domain.accounting.transaction.NLEntryMapper;
import com.varial.transfer.domain.accounting.transaction.NLTaxEntryMapper;
import com.varial.transfer.domain.accounting.transaction.NLTransactionHelper;
import com.varial.transfer.domain.accounting.transaction.TransferEntry;
import com.varial.transfer.domain.accounting.transaction.TransferNLEntry;
import com.varial.transfer.domain.accounting.transaction.TransferTax;
import com.varial.transfer.domain.accounting.transaction.TransferTransaction;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NLEntryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(NLEntryHelper.class);
    private final List<NominalLedgerEntry> nlEntries = new LinkedList<NominalLedgerEntry>();
    private final List<NominalTaxEntry> taxEntries = new LinkedList<NominalTaxEntry>();
    private final List<TransferTax> transferTaxes = new LinkedList<TransferTax>();
    private final Map<String, NonDeductibleInputTax> nonDeductibleMap = new HashMap<String, NonDeductibleInputTax>();
    private int entryNo = -1;

    public void setNLEntries(TransferTransaction imp, NominalTransactionBase result, String description) throws BusinessDomainException {
        TransferNLEntry[] impNLEntries;
        for (TransferNLEntry transferNLEntry : impNLEntries = imp.getNLEntries()) {
            boolean isManualTax = this.isManualTax(result, transferNLEntry.getTaxcodeID());
            if (isManualTax) {
                TransferTax manualTax = this.createManualTransferTax(imp, transferNLEntry);
                this.transferTaxes.add(manualTax);
                continue;
            }
            NominalLedgerEntry e = this.createNLEntry(result, transferNLEntry, description);
            this.createPreDiscountEntries(e);
            this.createNonDeductibleNLEntries(result, e);
        }
        for (TransferNLEntry transferNLEntry : imp.getTaxes()) {
            TransferTax t;
            if (StringMapper.isNullString((String)transferNLEntry.getTaxCodeID())) {
                throw FileImportExceptionMapper.makeTaxCodeNotFoundDomainException((String)transferNLEntry.getTaxCodeID());
            }
            TaxCode taxCode = TaxCode.getTaxCodeByImportCode((String)transferNLEntry.getTaxCodeID(), (JurisdictionType)result.getBatch().getCompany().getJurisdictionType());
            if (taxCode == null) {
                throw FileImportExceptionMapper.makeTaxCodeNotFoundDomainException((String)transferNLEntry.getTaxCodeID());
            }
            this.transferTaxes.add((TransferTax)transferNLEntry);
            if (this.hasZeroTaxAmounts((TransferTax)transferNLEntry)) {
                this.calculateTaxAmounts(result, impNLEntries, (TransferTax)transferNLEntry, taxCode);
            }
            LOGGER.debug("......... is EU-Erwerb {}", (Object)taxCode.isEuErwerb());
            if (taxCode.isEuErwerb()) {
                if (result.getTransactionManager().useTransitoryCustomer() && !result.getReverseChargeMethod()) {
                    NominalLedgerEntry te = this.createTransitoryEntry(result, (TransferTax)transferNLEntry, taxCode);
                    this.nlEntries.add(te);
                    continue;
                }
                t = this.createCorrespondingTransferTax(imp, (TransferTax)transferNLEntry);
                this.transferTaxes.add(t);
                continue;
            }
            if (!taxCode.isSplitPayment()) continue;
            t = this.createCorrespondingTransferTax(imp, (TransferTax)transferNLEntry);
            this.transferTaxes.add(t);
        }
        boolean getTaxableAmount = false;
        for (int i = 0; i < this.transferTaxes.size(); ++i) {
            this.logTaxInfo(i, this.transferTaxes.get(i));
            NominalTaxEntry taxEntry = new NominalTaxEntry(result);
            NLTaxEntryMapper.fillNominalTaxEntry((NominalTaxEntry)taxEntry, (TransferTax)this.transferTaxes.get(i));
            if ((ISoftware.isKronospan() || result.getCompany().getNote() != null && result.getCompany().getNote().contains("%UseInvRateBaseDateBasedOnTaxcode%")) && JurisdictionType.PL.equals((Object)result.getCompany().getJurisdictionType()) && taxEntry.getTaxRate() != null && taxEntry.getTaxRate().getTaxCode().isEditTaxBase() && result instanceof InvoiceTransaction) {
                taxEntry.setCorrespondingEntry(this.transferTaxes.get(i).isCorrespondingEntry());
                taxEntry.setEnteredBaseNetAmount(NLEntryHelper.getTaxableAmount(taxEntry, this.nlEntries.toArray(new NominalLedgerEntry[this.nlEntries.size()]), result.getIsInputTax()));
                getTaxableAmount = true;
            }
            this.taxEntries.add(taxEntry);
            this.addNonDeductibleTaxEntry(result, taxEntry);
        }
        if (getTaxableAmount && this.nlEntries != null && this.nlEntries.size() > 0) {
            for (NominalLedgerEntry nomLedgerEntry : this.nlEntries) {
                nomLedgerEntry.setUseTaxNetAmount(null);
            }
        }
        if (result instanceof InvoiceTransaction) {
            ((InvoiceTransaction)result).setNominalEntries(this.nlEntries.toArray(new NominalLedgerEntry[this.nlEntries.size()]));
            ((InvoiceTransaction)result).setTaxEntries(this.taxEntries.toArray(new NominalTaxEntry[this.taxEntries.size()]));
        } else {
            ((CashTransaction)result).setNominalEntries(this.nlEntries.toArray(new NominalLedgerEntry[this.nlEntries.size()]));
            ((CashTransaction)result).setTaxEntries(this.taxEntries.toArray(new NominalTaxEntry[this.taxEntries.size()]));
        }
    }

    private void addNonDeductibleTaxEntry(NominalTransactionBase result, NominalTaxEntry taxEntry) throws BusinessDomainException {
        NominalTaxEntry nonDeductibleTaxEntry = null;
        NonDeductibleInputTax inputTax = this.nonDeductibleMap.get(taxEntry.getTaxRate().getObjectid() + "/" + BooleanMapper.toInt((boolean)taxEntry.getIsDebit()));
        if (inputTax != null) {
            nonDeductibleTaxEntry = new NominalTaxEntry(result);
            NominalTaxEntryManager.fillNominalTaxEntry((NominalTaxEntry)nonDeductibleTaxEntry, (NLAccountCompanySetting)taxEntry.getAccount(), (!taxEntry.getIsDebit() ? 1 : 0) != 0, (BigDecimal)inputTax.getTaxTotal(), (TaxRate)taxEntry.getTaxRate(), (String)TransactionTranslatableResourceUtils.getNonDeductibleTaxDescription((ILanguage)result.getReportLanguage()), (boolean)true);
            if (new NLTransactionHelper().isForeignCurrency(result)) {
                nonDeductibleTaxEntry.setBaseAmount(inputTax.getBaseTaxTotal());
            }
            this.taxEntries.add(nonDeductibleTaxEntry);
        }
    }

    private NominalLedgerEntry createNLEntry(NominalTransactionBase transaction, TransferNLEntry nlEntry, String description) throws BusinessDomainException {
        NominalLedgerEntry e = new NominalLedgerEntry(transaction);
        e.setEntryNumber(this.entryNo++);
        NLEntryMapper.fillNominalLedgerEntry((NominalLedgerEntry)e, (TransferEntry)nlEntry, (String)description);
        this.nlEntries.add(e);
        return e;
    }

    private void createNonDeductibleNLEntries(NominalTransactionBase result, NominalLedgerEntry e) throws BusinessDomainException {
        if (e.getTaxRate() != null && TransactionHelper.postNonDeductibleInputTax((boolean)result.getIsInputTax(), (TaxRate)e.getTaxRate())) {
            ICalculatedTax tax = TaxCalculationStrategyFactory.getTaxCalculationStrategy((JurisdictionType)result.getCompany().getJurisdictionType()).calculateTax(new TaxCalculationRequestBuilder(e.getForeignNetAmount(), false, null, (ITaxRate[])new TaxRate[]{e.getTaxRate()}, e.getTransaction().getEnteredCurrency(), false));
            BigDecimal nonDeductibleTax = tax.getNonDeductibleInputTaxAmount();
            NominalLedgerEntry nonDeductibleEntry = NominalLedgerEntryManager.createNonDeductibleEntry((NominalTransactionBase)result, (BigDecimal)nonDeductibleTax, (NominalLedgerTaxAccounts)result.getFinanceSetup().getNominalLedger().getTaxAccounts(e.getTaxRate()), (NominalLedgerEntry)e, (boolean)false);
            nonDeductibleEntry.setEntryNumber(this.entryNo++);
            BigDecimal baseAmount = null;
            if (new NLTransactionHelper().isForeignCurrency(result)) {
                baseAmount = nonDeductibleTax.multiply(result.getConversionRate().getRate());
                baseAmount = result.getBaseCurrency().round(baseAmount);
                nonDeductibleEntry.setBaseAmount(baseAmount);
                ActCosting nonDeductibleCosting = nonDeductibleEntry.getCosting();
                if (nonDeductibleCosting != null) {
                    nonDeductibleCosting.setBaseAmount(result.getBaseCurrency(), result.getConversionRate().getRate(), false);
                }
            }
            this.nlEntries.add(nonDeductibleEntry);
            String nonDeductibleKey = e.getTaxRate().getObjectid() + "/" + BooleanMapper.toInt((boolean)e.getIsDebit());
            NonDeductibleInputTax nonDeductibleTmp = this.nonDeductibleMap.get(nonDeductibleKey);
            if (nonDeductibleTmp == null) {
                nonDeductibleTmp = new NonDeductibleInputTax();
                this.nonDeductibleMap.put(nonDeductibleKey, nonDeductibleTmp);
            }
            nonDeductibleTmp.add(nonDeductibleTax);
            nonDeductibleTmp.addBaseAmount(baseAmount);
        }
    }

    private void createPreDiscountEntries(NominalLedgerEntry entry) throws BusinessDomainException {
        NominalLedgerEntry[] preDiscountEntries;
        BigDecimal percentDiscount = this.getPercentDiscount(entry);
        if (percentDiscount != null && (preDiscountEntries = FixedAssetPreDiscountHelper.postFixedAssetPreDiscount((NominalLedgerEntry)entry, (BigDecimal)percentDiscount)) != null) {
            for (NominalLedgerEntry preDiscountEntry : preDiscountEntries) {
                this.nlEntries.add(preDiscountEntry);
            }
        }
    }

    private BigDecimal getPercentDiscount(NominalLedgerEntry entry) {
        BigDecimal result = null;
        if (!entry.getTransaction().isInvoiceTransaction()) {
            return result;
        }
        PersonalAccountEntry personalAccountEntry = ((InvoiceTransaction)entry.getTransaction()).getPersonalAccountEntry();
        if (personalAccountEntry.getPersonalAccount().isCustomer()) {
            return result;
        }
        if (personalAccountEntry.getOpenItems() == null) {
            return result;
        }
        if (personalAccountEntry.getOpenItems().length == 0) {
            return result;
        }
        OpenItem openItem = personalAccountEntry.getOpenItems()[0];
        IOpenItemDiscount oiDiscount = openItem.getDiscount1();
        if (oiDiscount == null) {
            ITermOfPayment term = openItem.getTermOfPayment();
            if (term != null && openItem.getValueDate() != null) {
                result = term.getPercentDiscount1(openItem.getValueDate());
            }
        } else {
            result = oiDiscount.getPercent();
        }
        return result;
    }

    private TransferTax createManualTransferTax(TransferTransaction transaction, TransferNLEntry entry) {
        TransferTax tax = new TransferTax(transaction);
        tax.setTaxCodeID(entry.getTaxcodeID());
        tax.setIsCreditnote(entry.isCreditnote());
        tax.setBaseAmount(entry.getBaseAmount());
        tax.setForeignAmount(entry.getForeignAmount());
        tax.setIsDebit(entry.isDebit());
        tax.makeReadOnly();
        return tax;
    }

    private boolean isManualTax(NominalTransactionBase result, String taxCodeID) {
        boolean isEust = false;
        if (!StringMapper.isNullString((String)taxCodeID)) {
            TaxCode taxCode = TaxCode.getTaxCodeByImportCode((String)taxCodeID, (JurisdictionType)result.getCompany().getJurisdictionType());
            isEust = taxCode != null && (taxCode.getTaxHandlingType() == TaxHandlingType.MANUAL_TAX || taxCode.getTaxHandlingType() == TaxHandlingType.RITENUTA);
        }
        return isEust;
    }

    private void logTaxInfo(int i, TransferTax transferTax) {
        if (LOGGER.isDebugEnabled()) {
            Object[] obj = new Object[]{i, transferTax.getTaxCodeID(), transferTax.isDebit(), transferTax.getBaseAmount(), transferTax.getForeignAmount()};
            LOGGER.debug("++++++++ tax {} {} {} {} {} ", obj);
        }
    }

    private boolean hasZeroTaxAmounts(TransferTax tax) {
        return BigDecimalMapper.isZeroOrNull((BigDecimal)tax.getBaseAmount()) && BigDecimalMapper.isZeroOrNull((BigDecimal)tax.getForeignAmount());
    }

    private void calculateTaxAmounts(NominalTransactionBase result, TransferNLEntry[] impNLEntries, TransferTax tax, TaxCode taxCode) throws BusinessDomainException {
        TaxRate taxRate = taxCode.getTaxRate(result.getTaxDate());
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)taxRate.getRate())) {
            BigDecimal taxAmountBase = BigDecimalMapper.ZERO;
            BigDecimal taxAmountForeign = BigDecimalMapper.ZERO;
            for (TransferNLEntry nlEntry : impNLEntries) {
                boolean gross = nlEntry.isGross();
                if (taxCode.isEuErwerb() || taxCode.isSplitPayment()) {
                    gross = false;
                }
                if (StringMapper.isNullString((String)nlEntry.getTaxcodeID()) || nlEntry.isDebit() != tax.isDebit() || !StringMapper.equal((String)nlEntry.getTaxcodeID(), (String)tax.getTaxCodeID())) continue;
                TaxCalculationStrategy tcmanager = TaxCalculationStrategyFactory.getTaxCalculationStrategy((JurisdictionType)result.getBatch().getCompany().getJurisdictionType());
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)nlEntry.getBaseAmount())) {
                    if (taxCode.isEuErwerb() && result.getCheckConversionRate() && result.getForeignCurrencyRate() != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)nlEntry.getForeignAmount()) && (ISoftware.isKronospan() || result.getCompany().getNote() != null && result.getCompany().getNote().contains("%UseInvRateBaseDateBasedOnTaxcode%")) && JurisdictionType.PL.equals((Object)result.getCompany().getJurisdictionType())) {
                        BigDecimal taxAmountCalc = this.calculateBaseTaxAmount(tcmanager.calculateTax(new TaxCalculationRequestBuilder(nlEntry.getForeignAmount(), gross, null, (ITaxRate[])new TaxRate[]{taxRate}, result.getEnteredCurrency(), !result.getIsInputTax())).getTaxAmount(), result);
                        taxAmountBase = taxAmountBase.add(taxAmountCalc);
                    } else {
                        taxAmountBase = taxAmountBase.add(tcmanager.calculateTax(new TaxCalculationRequestBuilder(nlEntry.getBaseAmount(), gross, null, (ITaxRate[])new TaxRate[]{taxRate}, result.getBaseCurrency(), !result.getIsInputTax())).getTaxAmount());
                    }
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)nlEntry.getForeignAmount())) continue;
                taxAmountForeign = taxAmountForeign.add(tcmanager.calculateTax(new TaxCalculationRequestBuilder(nlEntry.getForeignAmount(), gross, null, (ITaxRate[])new TaxRate[]{taxRate}, result.getEnteredCurrency(), !result.getIsInputTax())).getTaxAmount());
            }
            tax.setBaseAmount(taxAmountBase);
            tax.setForeignAmount(taxAmountForeign);
            LOGGER.debug("+++++++++ calc taxAmountBase {}", (Object)taxAmountBase);
            LOGGER.debug("+++++++++ calc taxAmountForeign {} ", (Object)taxAmountForeign);
        }
    }

    private TransferTax createCorrespondingTransferTax(TransferTransaction imp, TransferTax impTax) {
        TransferTax t = new TransferTax(imp);
        t.setTaxCodeID(impTax.getTaxCodeID());
        t.setIsCreditnote(impTax.isCreditnote());
        t.setBaseAmount(impTax.getBaseAmount());
        t.setForeignAmount(impTax.getForeignAmount());
        t.setIsDebit(!impTax.isDebit());
        t.setIsMirror(true);
        t.setIsCorrespondingEntry(true);
        t.makeReadOnly();
        return t;
    }

    private NominalLedgerEntry createTransitoryEntry(NominalTransactionBase result, TransferTax impTax, TaxCode taxCode) throws BusinessDomainException {
        NominalLedgerEntry te = new NominalLedgerEntry(result);
        NominalLedger ledger = result.getCompany().getFinanceSetup().getNominalLedger();
        TaxRate taxRate = taxCode.getTaxRate(result.getTaxDate());
        NominalLedgerTaxAccounts taxAccounts = ledger.getTaxAccounts(taxRate);
        NominalLedgerAccount transitoryPurchaseAccount = null;
        if (taxAccounts != null) {
            transitoryPurchaseAccount = taxAccounts.getTransitoryPurchaseAccount();
        }
        if (transitoryPurchaseAccount == null) {
            throw TransactionExceptionMapper.makeNoTransitoryPurchaseAccountDomainException();
        }
        te.setAccount(transitoryPurchaseAccount.getNLAccountCompanySetting(result.getCompany()));
        te.setIsDebit(!impTax.isDebit());
        te.setCosting(null);
        te.setDescription("");
        te.setIsDiscountable(false);
        te.setAnalysisCodes(new String[0]);
        te.setIsGross(false);
        te.setTaxRate(null);
        te.setEnteredAmount(impTax.getForeignAmount());
        te.setIsDownPayment(false);
        te.setQuantity(null);
        te.setEntryNumber(this.entryNo++);
        result.setFixedTaxCode(null);
        if (new NLTransactionHelper().isForeignCurrency(result)) {
            te.setBaseAmount(impTax.getBaseAmount());
        }
        return te;
    }

    public static BigDecimal getTaxableAmount(NominalTaxEntry taxEntry, NominalLedgerEntry[] nomLedgerEntries, boolean isInputTax) {
        BigDecimal taxableBaseAmount = BigDecimal.ZERO;
        List corrNlEntriesList = TaxEntryMatcher.getCorrespondingEntries((INominalTaxEntry)taxEntry, (INominalLedgerEntry[])nomLedgerEntries, (boolean)isInputTax);
        if (corrNlEntriesList != null && corrNlEntriesList.size() > 0) {
            for (INominalLedgerEntry nlEntry : corrNlEntriesList) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)nlEntry.getUseTaxNetAmount())) continue;
                taxableBaseAmount = taxableBaseAmount.add(nlEntry.getUseTaxNetAmount());
            }
        }
        return taxableBaseAmount;
    }

    protected BigDecimal calculateBaseTaxAmount(BigDecimal taxAmountForeign, NominalTransactionBase result) throws BusinessDomainException {
        BigDecimal conversionRate;
        if (result.getTaxOfficeRate() != null && !BigDecimalMapper.isZero((BigDecimal)(conversionRate = result.getTaxOfficeRate().getRate()))) {
            return result.getBaseCurrency().calculateConvertedAmount(taxAmountForeign, conversionRate);
        }
        return taxAmountForeign;
    }
}

