/*
 * Decompiled with CFR 0.152.
 */
package com.varial.serverbase.domain.resource;

import com.varial.base.i18n.I18NClient;
import com.varial.base.i18n.I18NData;
import com.varial.base.i18n.I18NTranslatableResource;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.global.resourcetranslat.IResourcetranslatDao;
import com.varial.base.persistency.global.resourcetranslat.ResourcetranslatContainer;
import com.varial.base.text.TextFactory;
import com.varial.serverbase.domain.resource.IResourceTranslationPersistencyManager;
import com.varial.serverbase.domain.resource.ResourceTranslation;
import com.varial.serverbase.domain.resource.ResourceTranslationDomainKey;
import com.varial.serverbase.mapper.ExceptionMapper;
import org.springframework.beans.factory.InitializingBean;

public class ResourceTranslationPersistencyManager
implements InitializingBean,
IResourceTranslationPersistencyManager {
    private IResourcetranslatDao dao;

    @Override
    public void save(ResourceTranslation p) {
        I18NClient client = new I18NClient();
        I18NData data = new I18NData(p.getLanguage(), p.getModule(), p.getParent(), p.getComponent(), p.getCaption(), p.getHint(), p.getShortcut(), p.getDescription(), p.getNoCaption(), p.getNoHint(), p.getNoShortcut());
        client.put((I18NTranslatableResource)data);
    }

    private ResourceTranslation[] query(Order[] order, Criterion criterion) {
        ResourcetranslatContainer[] containers = this.dao.getRows(order, criterion);
        int count = containers.length;
        ResourceTranslation[] result = new ResourceTranslation[count];
        for (int i = 0; i < count; ++i) {
            result[i] = new ResourceTranslation(containers[i].language, containers[i].resourcemodule, containers[i].parent, containers[i].component, true);
            this.fillResourceTranslation(result[i], containers[i]);
        }
        return result;
    }

    @Override
    public ResourceTranslation[] getResourceTranslations(String language, String module) {
        return this.query(null, Restrictions.and((Criterion)Restrictions.eq((String)"language", (String)language), (Criterion)Restrictions.eq((String)"resourcemodule", (String)module)));
    }

    @Override
    public ResourceTranslation[] getRightTranslations() {
        return this.query(new Order[]{Order.asc((String)"resourcemodule"), Order.asc((String)"parent"), Order.asc((String)"component"), Order.asc((String)"language")}, Restrictions.eq((String)"resourcemodule", (String)"right"));
    }

    @Override
    public ResourceTranslation[] getErrorMessageTranslations() {
        return this.query(new Order[]{Order.asc((String)"resourcemodule"), Order.asc((String)"parent"), Order.asc((String)"component"), Order.asc((String)"language")}, Restrictions.eq((String)"resourcemodule", (String)"errormessage"));
    }

    @Override
    public ResourceTranslation[] getProtocolTextTranslations() {
        return this.query(new Order[]{Order.asc((String)"resourcemodule"), Order.asc((String)"parent"), Order.asc((String)"component"), Order.asc((String)"language")}, Restrictions.eq((String)"resourcemodule", (String)"protocoltext"));
    }

    @Override
    public ResourceTranslation[] getMenuTranslations() {
        return this.query(new Order[]{Order.asc((String)"resourcemodule"), Order.asc((String)"parent"), Order.asc((String)"component"), Order.asc((String)"language")}, Restrictions.and((Criterion)Restrictions.eq((String)"resourcemodule", (String)"menu"), (Criterion)Restrictions.eq((String)"parent", (String)"menu")));
    }

    @Override
    public ResourceTranslation[] getSystemReportTranslations(String reportType, String reportName) {
        Criterion crit = Restrictions.and((Criterion)Restrictions.eq((String)"resourcemodule", (String)"server"), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"parent", (String)reportType), (Criterion)Restrictions.eq((String)"component", (String)reportName)));
        return this.query(new Order[]{Order.asc((String)"language")}, crit);
    }

    @Override
    public void load(ResourceTranslation b) {
        ResourcetranslatContainer container = null;
        if (b.hasObjectid()) {
            container = this.dao.getRowByObjectID(b.getObjectid());
        } else {
            ResourceTranslationDomainKey key = (ResourceTranslationDomainKey)b.getDomainID();
            if (key == null) {
                throw ExceptionMapper.makeApplicationException((String)"object has no domainkey");
            }
            ResourcetranslatContainer[] containers = this.dao.getRows(null, (Criterion)Restrictions.conjunction().add(Restrictions.eq((String)"language", (String)key.getLanguage())).add(Restrictions.eq((String)"resourcemodule", (String)key.getModule())).add(Restrictions.eq((String)"parent", (String)key.getParent())).add(Restrictions.eq((String)"component", (String)key.getComponent())));
            if (containers.length > 0) {
                container = containers[0];
            }
        }
        if (container == null) {
            b.setNoCaption(Integer.MIN_VALUE);
            b.setNoHint(Integer.MIN_VALUE);
            b.setNoShortcut(Integer.MIN_VALUE);
        } else {
            this.fillResourceTranslation(b, container);
        }
    }

    private void fillResourceTranslation(ResourceTranslation p, ResourcetranslatContainer container) {
        p.setTimestamp(container.getObjectTS());
        p.setLastuser(container.getLastUserid());
        p.setObjectid(container.getObjectid());
        p.setVersion(container.getVersion());
        p.setData(container.caption, container.resourcehint, container.shortcut, container.description, container.nocaption, container.nohint, container.noshortcut);
    }

    public void setDao(IResourcetranslatDao dao) {
        this.dao = dao;
    }

    public void afterPropertiesSet() {
        if (this.dao == null) {
            throw new IllegalArgumentException(TextFactory.makeArgumentNotSet((String)"dao"));
        }
    }

    @Override
    public ResourceTranslation[] getPrintManagerTranslations(String reportName) {
        Criterion crit = Restrictions.and((Criterion)Restrictions.eq((String)"resourcemodule", (String)"server"), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"parent", (String)"printmanager"), (Criterion)Restrictions.eq((String)"component", (String)reportName)));
        return this.query(new Order[]{Order.asc((String)"language")}, crit);
    }

    @Override
    public ResourceTranslation[] getErrorMessageTranslationsForParent(String parent, String language) {
        Criterion crit = Restrictions.and((Criterion)Restrictions.eq((String)"resourcemodule", (String)"errormessage"), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"parent", (String)parent), (Criterion)Restrictions.eq((String)"language", (String)language)));
        return this.query(new Order[]{Order.asc((String)"component")}, crit);
    }
}

