/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.printdocument;

import com.varial.base.error.ErrorDomain;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorListUtil;
import com.varial.base.error.Errors;
import com.varial.base.i18n.Translatable;
import com.varial.framework.domain.errormessage.ErrorDetails;
import com.varial.framework.domain.errormessage.TranslatableErrorMessage;

public enum PrintDocumentErrorMessage implements TranslatableErrorMessage
{
    ONLINESEARCH_NOT_INSTALLED(1, "The Software Module for getting archived Documents is not installed."),
    ONLINESEARCH_NOT_LICENSED(2, "The Software Module for getting archived Documents is not licensed."),
    ARCHIVE_NOT_FOUND(3, "The requested archive could not be found."),
    RUNTIME_ERROR(4, "Error while Calling OnlineSearch."),
    SERVERPATH_NOT_FOUND(5, "The server path could not be found."),
    OUTPUT_FILE_ERROR(6, "Error getting File from OnlineSearch."),
    C2XINVOICE_NOT_INSTALLED(7, "The Software Module for processing eInvoices is not installed."),
    C2XINVOICE_NOT_LICENSED(8, "The Software Module for processing eInvoices is not licensed."),
    NOT_ARCHIVED(9, "The E-Invoice isn't archived correctly."),
    ARCHIVE_CONTAINS_DIRECTORY(10, "The eInvoice ZIP Archive contains a directory! It may only contain PDF and JSON!"),
    ERROR_EXTRACTING_ARCHIVE(11, "An Error occurs while extracting The eInvoice ZIP Archive!"),
    JSON_FILE_DOESNT_EXIST(12, "The archived JSON File doesn't exist!"),
    ERROR_MAPPING_JSON_FILE(13, "An Error occurs while mapping the archived JSON File!"),
    ERROR_DELETING_JSON_FILE(14, "The archived JSON File could not be deleted!"),
    ERROR_DELETING_ZIP_FILE(15, "The eInvoice ZIP Archive could not be deleted!"),
    ARCHIVE_CONTAINS_TO_MANY_FILES(16, "The eInvoice ZIP Archive contains more than two files!"),
    ARCHIVE_CONTAINS_NO_PDF(17, "The eInvoice ZIP Archive contains no PDF file!"),
    ARCHIVE_CONTAINS_NO_JSON(18, "The eInvoice ZIP Archive contains no JSON file!"),
    ARCHIVE_EINVOICE_MISSING_FILENAME(19, "XML Filename missing to archive eInvoice!"),
    NO_EINVOICE_PATH_CONFIG(20, "There is no path for eInvoices configured!"),
    NO_EINVOICES_FOUND(21, "No eInvoices found for the company!"),
    ERROR_WRITING_JSON_FILE(22, "An Error occurs when creating the JSON File for eInvoive Archive!"),
    SEARCHNUMBER_NOT_FILLED(23, "Das Suchfeld hat keinen Wert! Deshalb kann die Suche nicht durchgef\u00fchrt werden.");

    private static final ErrorDomain ERROR_DOMAIN;
    @Translatable(type=Translatable.Type.ERRORLIST)
    @Errors
    public static final ErrorList ERROR_LIST;
    private final ErrorDetails errorDetails;

    private PrintDocumentErrorMessage(int errorNumber, String defaultMessage) {
        this.errorDetails = new ErrorDetails(errorNumber, defaultMessage);
    }

    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public ErrorDomain getErrorDomain() {
        return ERROR_DOMAIN;
    }

    static {
        ERROR_DOMAIN = ErrorDomain.PRINTDOCUMENT;
        ERROR_LIST = ErrorListUtil.createErrorList((ErrorDomain)ERROR_DOMAIN, (Enum[])PrintDocumentErrorMessage.values());
    }
}

