/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.country.vatcheck.bzst;

import com.varial.base.UtilitiesManager;
import com.varial.base.vat.VATException;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.bzstclient.BZStClient;
import com.varial.base.vat.bzstclient.BZStQualifiedRequestBuilder;
import com.varial.base.vat.bzstclient.BZStResponse;
import com.varial.framework.domain.country.vatcheck.IVATQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckService;
import com.varial.interfaces.IAccountingCompany;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Optional;

public class BzstVATQualifiedCheckService
extends VATQualifiedCheckService
implements IVATQualifiedCheckService {
    private BzstVATQualifiedCheckService() {
    }

    public static BzstVATQualifiedCheckService getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Override
    public VATQualifiedCheck checkVat(VATNumber requesterVAT, VATQualifiedCheckRequest request, IAccountingCompany company) {
        try {
            String traderName = this.toBzstString(request.getTraderName());
            String traderCity = this.toBzstString(request.getTraderCity());
            BZStQualifiedRequestBuilder builder = new BZStQualifiedRequestBuilder(request.getLookupVAT(), requesterVAT, traderName, traderCity).withTraderPostcode(this.toBzstString(request.getTraderPostcode())).withTraderStreet(this.toBzstString(request.getTraderStreet()));
            if (request.isWithCofirmationLetter()) {
                builder.withConfirmationLetter();
            }
            BZStClient client = (BZStClient)UtilitiesManager.getBean((String)"igf.vat.bzst.client", BZStClient.class);
            BZStResponse bzstResponse = client.checkVat(builder);
            VATQualifiedCheck vatQualifiedCheckResponse = this.toVATQualifiedCheckResponse(bzstResponse);
            return vatQualifiedCheckResponse;
        }
        catch (VATException e) {
            return this.toVATQualifiedCheckResponse(e, request);
        }
    }

    private VATQualifiedCheck toVATQualifiedCheckResponse(BZStResponse bzstResponse) {
        return new VATQualifiedCheck(this.toCheckResultType(bzstResponse.getTraderNameMatch()), this.toCheckResultType(bzstResponse.getTraderStreetMatch()), this.toCheckResultType(bzstResponse.getTraderPostcodeMatch()), this.toCheckResultType(bzstResponse.getTraderCityMatch()), this.toCheckResultType(bzstResponse.getResponseCode()), this.toDate(bzstResponse.getResponseDateTime()), bzstResponse.getResponseCode().getErrorId(), bzstResponse.getLookupVatId().toString(), DateMapper.toDate((Optional)bzstResponse.getValidFrom()), DateMapper.toDate((Optional)bzstResponse.getValidUntil()), "", bzstResponse.isLetterRequested());
    }

    private String toBzstString(String s) {
        return StringMapper.toStringWithTrim((String)s);
    }

    private static class SingletonHelper {
        private static final BzstVATQualifiedCheckService INSTANCE = new BzstVATQualifiedCheckService();

        private SingletonHelper() {
        }
    }
}

