/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.company;

import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.i18n.Translatable;
import com.varial.serverbase.mapper.ExceptionMapper;

public class CompanyExceptionMapper {
    private static final String CLASS_GENERAL = ExceptionMapper.CLASS_COMPANY;
    private static final int HEAD_OFFICE_NOT_IN_GROUP = 501;
    private static final int USES_GROUP_DATA_WITHOUT_GROUP_ASSIGNED = 502;
    private static final int DEFAULT_LANGUAGE_HAS_NO_LOCALE = 503;
    private static final int COMPANY_IS_CONSOLIDATION_COMPANY = 504;
    private static final int SAVE_AT_FIRST_THE_NEW_COMPANY_BEFORE_SETTING_CONSOLIDATION = 505;
    private static final int OBLIGATORY_COMPANYOID_OID_IS_NULL_FOR_SERVERFUNCTION_FROM_CLIENT_OR_OTHER_INPUT = 506;
    private static final int UNTIL_DATE_BEFORE_FROM_DATE = 507;
    private static final int LANGUAGE_HAS_NO_LOCALE = 508;
    private static final int COMPANY_NOT_FOUND = 509;
    private static final int JURISDICTION_NOT_LICENSED = 510;
    private static final int COMPANYTYPE_MUST_NOT_BE_CHANGED = 511;
    private static final int EXTERNAL_COMPANY_NOT_AVAILABLE_BECAUSE_OF_EXISTING_TRANSACTIONS = 512;
    private static final int ECSALESLIST_COMPANYNUMBER_FOR_PERFIDIA_IS_MISSING = 527;
    @Translatable(type=Translatable.Type.ERRORLIST)
    @Errors
    private static final ErrorList mErrorList = new ErrorList(CLASS_GENERAL, new ErrorMessage[]{new ErrorMessage(501, "-Head office not in group of companies"), new ErrorMessage(502, "The company cannot be removed from the group because the tax is declared by the group."), new ErrorMessage(503, "The default language has no locale."), new ErrorMessage(504, "The company is still consolidation company for at least one other company"), new ErrorMessage(505, "Please save at first the new company before setting the consolidation company for costing."), new ErrorMessage(506, "The obligatory company oid is null for the serverfunction from the client or other input."), new ErrorMessage(507, "The Until date is before the From date."), new ErrorMessage(508, "Language for reports has no Locale."), new ErrorMessage(509, "The company with the provided code could not be found."), new ErrorMessage(510, "The selected jurisdiction is not licensed."), new ErrorMessage(511, "Company type must not be changed if posting exists."), new ErrorMessage(512, "The identifier External Company is only available as long as there are no postings."), new ErrorMessage(527, "Die erforderliche Betriebsnummer-Id f\u00fcr die ZM-Ausgabe fehlt.")});

    public static BusinessDomainException makeExternalCompanyNotAvailableBecauseOfExistingTransactionsDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)512, (String)mErrorList.getDefaultString(512));
    }

    public static BusinessDomainException makeHeadOfficeNotInGroupDomainException(String value) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)value, (int)501, (String)mErrorList.getDefaultString(501));
    }

    public static BusinessDomainException makeCompanyMustBotBeChangedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)511, (String)mErrorList.getDefaultString(511));
    }

    public static BusinessDomainException makeLanguageForReportHasNoLocaleDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)508, (String)mErrorList.getDefaultString(508));
    }

    public static BusinessDomainException makeUsesGroupDataWithoutGroupAssignedDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)502, (String)mErrorList.getDefaultString(502));
    }

    public static BusinessDomainException makeDefaultLanguageHasNoLocaleDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)503, (String)mErrorList.getDefaultString(503));
    }

    public static BusinessDomainException makeCompanyIsConsolidatuionCompany() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)504, (String)mErrorList.getDefaultString(504));
    }

    public static BusinessDomainException makeSavAtFirstTheNewCompanyBeforeSettingTheConsolidationCompany() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)505, (String)mErrorList.getDefaultString(505));
    }

    public static BusinessDomainException makeObligatoryCompanyOidIsNullForServerfuncionFromClientOrOtherInput() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)506, (String)mErrorList.getDefaultString(506));
    }

    public static BusinessDomainException makeUntilDateBeforeFromDateException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)"", (int)507, (String)mErrorList.getDefaultString(507));
    }

    public static BusinessDomainException makeCompanyNotFoundException(String companyCode) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)companyCode, (int)509, (String)mErrorList.getDefaultString(509));
    }

    public static BusinessDomainException makeJurisdictionNotLicensed(String jurisdiction) {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)jurisdiction, (int)510, (String)mErrorList.getDefaultString(510));
    }

    public static BusinessDomainException makeECSalesListCompanyNumberForPefidiaIsMissingDomainException() {
        return ExceptionMapper.makeDomainException((String)CLASS_GENERAL, (String)"", (String)"", (int)527, (String)mErrorList.getDefaultString(527));
    }
}

