/*
 * Decompiled with CFR 0.152.
 */
package com.varial.costing.base.domain.exportactcosting;

import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.actcostingdata.CostingAreaType;
import com.varial.costing.base.domain.actcostingdata.CostingSplitPersistencyManager;
import com.varial.costing.base.domain.actcostingdata.kstkoabalance.CostCentreReportBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostTypeCentreUnitReportBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostingSplitKstKtrKoaBalancePersistencyManager;
import com.varial.costing.base.domain.actcostingdata.ktrkoabalance.CostUnitReportBalance;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.costing.base.domain.costcentrebase.CostCentreBasePersistencyManager;
import com.varial.costing.base.domain.costcentrebase.CostCentreGroup;
import com.varial.costing.base.domain.costingcompany.CostingCompany;
import com.varial.costing.base.domain.costingcompany.CostingCompanyPersistencyManager;
import com.varial.costing.base.domain.costinghierarchy.CostingGroup;
import com.varial.costing.base.domain.costinghierarchy.CostingGroupPersistencyManager;
import com.varial.costing.base.domain.costingquantity.CostCentreDistribution;
import com.varial.costing.base.domain.costingquantity.CostUnitDistribution;
import com.varial.costing.base.domain.costingquantity.CostingQuantity;
import com.varial.costing.base.domain.costingquantity.CostingQuantityPersistencyManager;
import com.varial.costing.base.domain.costingquantity.DistributionKey;
import com.varial.costing.base.domain.costingquantity.DistributionKeyPersistencyManager;
import com.varial.costing.base.domain.costingquantity.QuantityElement;
import com.varial.costing.base.domain.costingreport.ReportBalance;
import com.varial.costing.base.domain.costingsetup.CostPlanVariant;
import com.varial.costing.base.domain.costingsetup.CostingConfig;
import com.varial.costing.base.domain.costingsetup.CostingSetup;
import com.varial.costing.base.domain.costingyear.CostingYear;
import com.varial.costing.base.domain.costingyear.CostingYearExceptionMapper;
import com.varial.costing.base.domain.costtypebase.CostTypeBase;
import com.varial.costing.base.domain.costtypebase.CostTypeBasePersistencyManager;
import com.varial.costing.base.domain.costtypebase.CostTypeGroup;
import com.varial.costing.base.domain.costunit.CostUnit;
import com.varial.costing.base.domain.costunit.CostUnitGroup;
import com.varial.costing.base.domain.costunit.CostUnitPersistencyManager;
import com.varial.costing.base.domain.exportactcosting.ExportActCostingMapper;
import com.varial.costing.base.domain.exportactcosting.ExportActCostingPersistencyManager;
import com.varial.costing.base.exportactcosting.CostingBalanceStruct;
import com.varial.costing.base.exportactcosting.CostingEntryJStruct;
import com.varial.costing.base.persistency.costingsplit.CostingsplitContainer;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.company.CompanyPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.extendedquery.ExtendedFilterStruct;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.SelectGeneratorDataSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportActCostingManager {
    private static Logger LOGGER = LoggerFactory.getLogger((String)ExportActCostingManager.class.getName());
    private final CostingCompany mCompany;
    private Date mDateFrom;
    private Date mDateUntil;
    private int startperiod;
    private int endperiod;
    private Integer helpAverargeCount = 0;
    private BigDecimal amountHelp1 = BigDecimal.ZERO;
    private boolean isCostCentreRead;
    private CostCentreReportBalance[] mCostCentreReportBalances;
    private boolean isCostUnitRead;
    private CostUnitReportBalance[] mCostUnitReportBalances;
    private static int MAXSELECTIN = 999;
    private CostCentreReportBalance[] mBalancesHelp;
    private CostUnitReportBalance[] mBalancesHelpCU;

    public ExportActCostingManager(CostingCompany company) {
        this.mCompany = company;
    }

    public CostTypeCentreUnitReportBalance[] exportExportActCostingManager(String oidCostingCompany, short costingarea, String oidcostplanvariant, String[] oidCostingQuantities, String[] oidCostCentres, String[] oidCostUnits, String datefrom, String dateuntil, boolean isAllCostingQuantities, boolean isAllCostCentres, boolean isAllCostUnits) throws BusinessDomainException {
        CostTypeCentreUnitReportBalance[] quantityValues = this.fillCostingJQuantities(oidCostingCompany, costingarea, oidcostplanvariant, oidCostingQuantities, oidCostCentres, oidCostUnits, datefrom, dateuntil, isAllCostingQuantities, isAllCostCentres, isAllCostUnits);
        return quantityValues;
    }

    private final CostTypeCentreUnitReportBalance[] fillCostingJQuantities(String oidCostingCompany, short costingarea, String oidcostplanvariant, String[] oidCostingQuantities, String[] oidCostCentres, String[] oidCostUnits, String datefrom, String dateuntil, boolean isAllCostingQuantities, boolean isAllCostCentres, boolean isAllCostUnits) throws BusinessDomainException {
        CostTypeCentreUnitReportBalance[] resultQuantityContainerKstAndKtr = null;
        ArrayList<CostTypeCentreUnitReportBalance> costTypeCentreUnitReportBalanceArrayKstAndKtr = new ArrayList<CostTypeCentreUnitReportBalance>();
        CostingQuantity[] costingQuantities = null;
        if (isAllCostingQuantities) {
            costingQuantities = CostingQuantity.getCostingQuantityiesByCompany((CostingCompany)this.mCompany);
        } else {
            costingQuantities = new CostingQuantity[oidCostingQuantities.length];
            for (int i = 0; i < oidCostingQuantities.length; ++i) {
                costingQuantities[i] = CostingQuantityPersistencyManager.getCostingQuantity((String)oidCostingQuantities[i]);
            }
        }
        if (costingQuantities == null || costingQuantities.length == 0) {
            return null;
        }
        CostCentreBase[] kstsDerGruppe = null;
        if (isAllCostCentres) {
            kstsDerGruppe = CostCentreBase.getCostCentres((Company)this.mCompany);
        } else {
            kstsDerGruppe = new CostCentreBase[oidCostCentres.length];
            for (int i = 0; i < oidCostCentres.length; ++i) {
                kstsDerGruppe[i] = CostCentreBasePersistencyManager.getCostCentreBase((String)oidCostCentres[i]);
            }
        }
        ArrayList<DistributionKey> dkArray = new ArrayList<DistributionKey>();
        DistributionKey[] keys = null;
        DistributionKey[] keysPerQuantity = null;
        this.mDateFrom = DateMapper.toDate((String)datefrom);
        this.mDateUntil = DateMapper.toDate((String)dateuntil);
        this.startperiod = new VDate(this.mDateFrom).getMonth();
        this.endperiod = new VDate(this.mDateUntil).getMonth();
        Company company = CompanyPersistencyManager.getCompany((String)oidCostingCompany);
        CostingYear[] allYears = null;
        allYears = CostingYear.getCostingYears((Company)company);
        if (allYears.length == 0) {
            throw CostingYearExceptionMapper.makeNoCostingYearDomainException();
        }
        CostingYear youngestYear = null;
        for (int i = 0; i < allYears.length; ++i) {
            if (!DateHelper.between((Date)this.mDateFrom, (Date)allYears[i].getValidFrom(), (Date)allYears[i].getValidUntil())) continue;
            youngestYear = allYears[i];
            break;
        }
        if (youngestYear == null) {
            LOGGER.warn("Warning! no year is selected ! This should not be from the Reporting Client  datefrom: " + datefrom + " dateuntil: " + dateuntil);
            return null;
        }
        CostingYear oldestYear = null;
        for (int i = 0; i < allYears.length; ++i) {
            if (!DateHelper.between((Date)this.mDateUntil, (Date)allYears[i].getValidFrom(), (Date)allYears[i].getValidUntil())) continue;
            oldestYear = allYears[i];
            break;
        }
        if (oldestYear == null) {
            LOGGER.warn("Warning! no year is selected ! This should not be from the Reporting Client  datefrom: " + datefrom + " dateuntil: " + dateuntil);
            return null;
        }
        ArrayList<CostingYear> resultListTo = new ArrayList<CostingYear>();
        for (int i = 0; i < allYears.length; ++i) {
            if (!DateHelper.between((Date)this.mDateFrom, (Date)allYears[i].getValidFrom(), (Date)allYears[i].getValidUntil()) && !DateHelper.between((Date)this.mDateUntil, (Date)allYears[i].getValidFrom(), (Date)allYears[i].getValidUntil()) && !DateHelper.between((Date)allYears[i].getValidFrom(), (Date)this.mDateFrom, (Date)this.mDateUntil)) continue;
            resultListTo.add(allYears[i]);
        }
        CostingYear[] resultTo = new CostingYear[resultListTo.size()];
        resultListTo.toArray(resultTo);
        String[] oidcostingyears = new String[resultTo.length];
        for (int i = 0; i < oidcostingyears.length; ++i) {
            oidcostingyears[i] = resultTo[i].getObjectid();
        }
        boolean moreThanOneYears = false;
        if (oidcostingyears.length > 1) {
            moreThanOneYears = true;
        }
        for (int i = 0; i < costingQuantities.length; ++i) {
            keysPerQuantity = DistributionKeyPersistencyManager.getCurrentDistributionKeys((CostingQuantity)costingQuantities[i], (String[])oidcostingyears, (int)costingarea, (String)(costingarea == 1 ? oidcostplanvariant : ""));
            if (keysPerQuantity == null) continue;
            for (int j = 0; j < keysPerQuantity.length; ++j) {
                dkArray.add(keysPerQuantity[j]);
            }
        }
        keys = new DistributionKey[dkArray.size()];
        dkArray.toArray(keys);
        for (int k = 0; k < keys.length; ++k) {
            if (keys[k].getCostingYear().getObjectid().equals(youngestYear.getObjectid()) && moreThanOneYears) {
                this.startperiod = DateHelper.getMonth((Date)this.mDateFrom);
                this.endperiod = DateHelper.getMonth((Date)keys[k].getCostingYear().getValidUntil());
            } else if (keys[k].getCostingYear().getObjectid().equals(oldestYear.getObjectid()) && moreThanOneYears) {
                this.startperiod = DateHelper.getMonth((Date)keys[k].getCostingYear().getValidFrom());
                this.endperiod = DateHelper.getMonth((Date)this.mDateUntil);
            } else {
                this.startperiod = DateHelper.getMonth((Date)this.mDateFrom);
                this.endperiod = DateHelper.getMonth((Date)this.mDateUntil);
            }
            if (DateHelper.between((Date)keys[k].getCostingYear().getValidFrom(), (Date)this.mDateFrom, (Date)this.mDateUntil) && DateHelper.between((Date)keys[k].getCostingYear().getValidUntil(), (Date)this.mDateFrom, (Date)this.mDateUntil)) {
                this.startperiod = DateHelper.getMonth((Date)keys[k].getCostingYear().getValidFrom());
                this.endperiod = DateHelper.getMonth((Date)keys[k].getCostingYear().getValidUntil());
            }
            this.makeStartAndEndPeriodsForMonthlyQuantityValues(keys, k);
            if (DateHelper.getMonth((Date)keys[k].getCostingYear().getValidFrom()) != 0 && moreThanOneYears && keys[k].getCostingYear().getObjectid() != youngestYear.getObjectid()) {
                this.startperiod = 0;
            }
            CostCentreDistribution[] ds = keys[k].getCostCentreDistributions();
            for (int o = 0; o < ds.length; ++o) {
                int averagecount = 0;
                for (int p = 0; p < kstsDerGruppe.length; ++p) {
                    if (!ds[o].getCostCentre().getObjectid().equals(kstsDerGruppe[p].getObjectid())) continue;
                    this.amountHelp1 = BigDecimalMapper.ZERO;
                    QuantityElement[] es = ds[o].getQuantityElements();
                    if (es != null && es.length >= this.endperiod + 1 - this.startperiod) {
                        for (int m = this.startperiod; m < this.endperiod + 1; ++m) {
                            ++averagecount;
                            this.amountHelp1 = this.amountHelp1.add(es[m].getQuantity());
                        }
                        this.helpAverargeCount = averagecount;
                    }
                    if (keys[k].getIsAverageValue() && this.helpAverargeCount > 0) {
                        this.amountHelp1 = this.amountHelp1.divide(BigDecimal.valueOf(this.helpAverargeCount.intValue()), RoundingMode.HALF_DOWN);
                    }
                    CostTypeCentreUnitReportBalance costTypeCentreUnitReportBalance = new CostTypeCentreUnitReportBalance();
                    costTypeCentreUnitReportBalance.mOidCostCentre = ds[o].getCostCentre().getObjectid();
                    costTypeCentreUnitReportBalance.mOidCostUnit = "";
                    costTypeCentreUnitReportBalance.mOidCostType = keys[k].getCostingQuantity().getObjectid();
                    costTypeCentreUnitReportBalance.mQuantity = this.amountHelp1;
                    costTypeCentreUnitReportBalance.mBalance = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalance.mBalanceFix = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalance.mBalanceVar = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalanceArrayKstAndKtr.add(costTypeCentreUnitReportBalance);
                    this.amountHelp1 = BigDecimalMapper.ZERO;
                }
            }
        }
        CostUnit[] ktrsDerGruppe = null;
        if (isAllCostUnits) {
            ktrsDerGruppe = CostUnit.getCostUnits((Company)this.mCompany);
        } else {
            ktrsDerGruppe = new CostUnit[oidCostUnits.length];
            for (int i = 0; i < oidCostUnits.length; ++i) {
                ktrsDerGruppe[i] = CostUnitPersistencyManager.getCostUnit((String)oidCostUnits[i]);
            }
        }
        for (int k = 0; k < keys.length; ++k) {
            this.makeStartAndEndPeriodsForMonthlyQuantityValues(keys, k);
            CostUnitDistribution[] ds = keys[k].getCostUnitDistributions();
            for (int o = 0; o < ds.length; ++o) {
                int averagecount = 0;
                for (int p = 0; p < ktrsDerGruppe.length; ++p) {
                    if (!ds[o].getCostUnit().getObjectid().equals(ktrsDerGruppe[p].getObjectid())) continue;
                    this.amountHelp1 = BigDecimalMapper.ZERO;
                    QuantityElement[] es = ds[o].getQuantityElements();
                    if (es != null && es.length >= this.endperiod + 1 - this.startperiod) {
                        for (int m = this.startperiod; m < this.endperiod + 1; ++m) {
                            ++averagecount;
                            this.amountHelp1 = this.amountHelp1.add(es[m].getQuantity());
                        }
                        this.helpAverargeCount = averagecount;
                    }
                    if (keys[k].getIsAverageValue() && this.helpAverargeCount > 0) {
                        this.amountHelp1 = this.amountHelp1.divide(BigDecimal.valueOf(this.helpAverargeCount.intValue()), RoundingMode.HALF_DOWN);
                    }
                    CostTypeCentreUnitReportBalance costTypeCentreUnitReportBalance = new CostTypeCentreUnitReportBalance();
                    costTypeCentreUnitReportBalance.mOidCostUnit = ds[o].getCostUnit().getObjectid();
                    costTypeCentreUnitReportBalance.mOidCostCentre = "";
                    costTypeCentreUnitReportBalance.mOidCostType = keys[k].getCostingQuantity().getObjectid();
                    costTypeCentreUnitReportBalance.mQuantity = this.amountHelp1;
                    costTypeCentreUnitReportBalance.mBalance = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalance.mBalanceFix = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalance.mBalanceVar = BigDecimal.ZERO;
                    costTypeCentreUnitReportBalanceArrayKstAndKtr.add(costTypeCentreUnitReportBalance);
                    this.amountHelp1 = BigDecimalMapper.ZERO;
                }
            }
        }
        resultQuantityContainerKstAndKtr = new CostTypeCentreUnitReportBalance[costTypeCentreUnitReportBalanceArrayKstAndKtr.size()];
        costTypeCentreUnitReportBalanceArrayKstAndKtr.toArray(resultQuantityContainerKstAndKtr);
        return resultQuantityContainerKstAndKtr;
    }

    private void makeStartAndEndPeriodsForMonthlyQuantityValues(DistributionKey[] keys, int k) {
        CostingYear costingYear = keys[k].getCostingYear();
        if (DateHelper.getMonth((Date)costingYear.getValidFrom()) != 0) {
            int subtractValue = DateHelper.getMonth((Date)costingYear.getValidFrom());
            int monthOfTransactiondate = DateHelper.getMonth((Date)this.mDateFrom);
            int monthOfTransactiondateUntil = DateHelper.getMonth((Date)this.mDateUntil);
            if (this.endperiod < this.startperiod) {
                this.startperiod = monthOfTransactiondate - subtractValue;
                this.endperiod = 12 - subtractValue + this.endperiod;
            } else if (DateHelper.getYear((Date)this.mDateFrom) == DateHelper.getYear((Date)costingYear.getValidFrom())) {
                this.startperiod = monthOfTransactiondate - subtractValue;
                this.endperiod = monthOfTransactiondateUntil - subtractValue;
            } else {
                this.startperiod = 12 - subtractValue + monthOfTransactiondate;
                this.endperiod = 12 - subtractValue + monthOfTransactiondateUntil;
            }
        }
    }

    public CostingEntryJStruct[] exportExportActCostingJEntries(String oidCostingCompany, String oidCostingYear, short costingarea, String oidcostplanvariant, String[] oidCostingQuantities, String[] oidCostCentres, String[] oidCostUnits, String oidCurrency, String datefrom, String dateuntil, boolean isAllCostingQuantities, boolean isAllCostCentres, boolean isAllCostUnits, ExtendedFilterStruct[] extFilter) throws BusinessDomainException {
        CostingEntryJStruct[] costingEntryJSeq = ExportActCostingManager.getCostingJEntries(oidCostingCompany, oidCostingYear, costingarea, oidcostplanvariant, oidCostingQuantities, oidCostCentres, oidCostUnits, oidCurrency, datefrom, dateuntil, isAllCostingQuantities, isAllCostCentres, isAllCostUnits, extFilter);
        return costingEntryJSeq;
    }

    private static CostingEntryJStruct[] getCostingJEntries(String oidCostingCompany, String oidCostingYear, short costingarea, String oidcostplanvariant, String[] oidCostTypes, String[] oidCostCentres, String[] oidCostUnits, String oidCurrency, String datefromS, String dateuntilS, boolean isAllCostTypes, boolean isAllCostCentres, boolean isAllCostUnits, ExtendedFilterStruct[] extFilter) throws BusinessDomainException {
        CostingCompany costingCompany = CostingCompanyPersistencyManager.getCostingCompany((String)oidCostingCompany);
        CostingSetup costingSetup = costingCompany.getCostingSetup();
        ICurrency baseCurrency = costingSetup.getBaseCurrency();
        Date datefrom = DateMapper.toDate((String)datefromS);
        Date dateuntil = DateMapper.toDate((String)dateuntilS);
        CostingEntryJStruct[] result = null;
        CostTypeBase.preloadEverythingToCostTypeBase((CostingCompany)costingCompany);
        String[] strings = new String[]{""};
        SelectGeneratorDataSet dataSet = null;
        CostingsplitContainer[] mCostingsplitContainer = null;
        if (oidCostUnits.length < MAXSELECTIN && oidCostCentres.length < MAXSELECTIN) {
            dataSet = ExportActCostingPersistencyManager.getActCostingJEntries((CostingCompany)costingCompany, (Date)datefrom, (Date)dateuntil, (String[])oidCostCentres, (String[])oidCostTypes, (String[])oidCostUnits, (short)costingarea, (String)oidcostplanvariant, (boolean)isAllCostTypes, (boolean)isAllCostCentres, (boolean)isAllCostUnits, (ExtendedFilterStruct[])extFilter);
            LinkedList<CostingsplitContainer> listCS = new LinkedList<CostingsplitContainer>();
            while (dataSet.hasNext()) {
                Object[] o = dataSet.getNext();
                CostingsplitContainer costingsplitContainer = (CostingsplitContainer)o[0];
                listCS.add(costingsplitContainer);
            }
            dataSet.dispose();
            mCostingsplitContainer = new CostingsplitContainer[listCS.size()];
            listCS.toArray(mCostingsplitContainer);
        } else {
            mCostingsplitContainer = oidCostUnits.length >= MAXSELECTIN ? ExportActCostingPersistencyManager.getActCostingJEntriesCU1000((CostingCompany)costingCompany, (Date)datefrom, (Date)dateuntil, (String[])oidCostCentres, (String[])oidCostTypes, (String[])oidCostUnits, (short)costingarea, (String)oidcostplanvariant, (boolean)isAllCostTypes, (boolean)isAllCostCentres, (boolean)isAllCostUnits, (ExtendedFilterStruct[])extFilter) : ExportActCostingPersistencyManager.getActCostingJEntriesCC1000((CostingCompany)costingCompany, (Date)datefrom, (Date)dateuntil, (String[])oidCostCentres, (String[])oidCostTypes, (String[])oidCostUnits, (short)costingarea, (String)oidcostplanvariant, (boolean)isAllCostTypes, (boolean)isAllCostCentres, (boolean)isAllCostUnits, (ExtendedFilterStruct[])extFilter);
        }
        result = ExportActCostingMapper.toCostingEntryJStructIdl((CostingsplitContainer[])mCostingsplitContainer, (ICurrency)baseCurrency);
        LOGGER.debug("Ergebnis EXPORT ACT COSTING , Funktion:  ALLE ActCosting-S\u00e4tze : Es werden {} S\u00e4tze ausgegeben ", (Object)result.length);
        return result;
    }

    public CostingBalanceStruct[] exportBalanceCostingSeperate(String oidCostingCompany, short costingarea, String[] oidCostTypes, String[] oidCostCentres, String[] oidCostUnits, boolean isAllCostTypes, boolean isAllCostCentres, boolean isAllCostUnits, ExtendedFilterStruct[] extFilter, ICurrency currency, Date from, Date until, CostPlanVariant costPlanVariant, CostingCompany company, ExtendedFilterStruct[] analysisCodesCostTypes, ExtendedFilterStruct[] analysisCodesCostCentres, ExtendedFilterStruct[] analysisCodesCostUnits, String costCentreFrom, String costCentreTo, String costUnitFrom, String costUnitTo, String unitDateValidFrom, String unitDateValidTo, String[] managerCostCentreSeq, String[] managerCentreGroupSeq, String[] managerCostUnitSeq, String[] managerUnitGroupSeq, String[] oidCostUnitStateEnums, String[] oidCostUnitCustomers, String[] orderNoTypeCodes, String orderNoFrom, String orderNoTo, String[] oidCostTypeGroups, String[] oidCostCentreGroups, String[] oidCostUnitGroups) throws BusinessDomainException {
        if (extFilter != null && extFilter.length > 0) {
            return this.calculateValuesFromCostingSplit(oidCostingCompany, costingarea, oidCostTypes, oidCostCentres, oidCostUnits, isAllCostTypes, isAllCostCentres, isAllCostUnits, extFilter, currency, from, until, costPlanVariant, company, analysisCodesCostCentres, analysisCodesCostUnits, costCentreFrom, costCentreTo, costUnitFrom, costUnitTo, unitDateValidFrom, unitDateValidTo, managerCostCentreSeq, managerCentreGroupSeq, managerCostUnitSeq, managerUnitGroupSeq, oidCostUnitStateEnums, oidCostUnitCustomers, orderNoTypeCodes, orderNoFrom, orderNoTo, oidCostCentreGroups, oidCostUnitGroups);
        }
        return this.calculateValuesFromCostingBalances(oidCostingCompany, costingarea, oidCostTypes, oidCostCentres, oidCostUnits, isAllCostTypes, isAllCostCentres, isAllCostUnits, currency, from, until, costPlanVariant, company, analysisCodesCostTypes, analysisCodesCostCentres, analysisCodesCostUnits, costCentreFrom, costCentreTo, costUnitFrom, costUnitTo, unitDateValidFrom, unitDateValidTo, managerCostCentreSeq, managerCentreGroupSeq, managerCostUnitSeq, managerUnitGroupSeq, oidCostUnitStateEnums, oidCostUnitCustomers, orderNoTypeCodes, orderNoFrom, orderNoTo, oidCostTypeGroups, oidCostCentreGroups, oidCostUnitGroups);
    }

    private CostingBalanceStruct[] calculateValuesFromCostingBalances(String oidCostingCompany, short costingarea, String[] allOidCostTypes, String[] oidCostCentres, String[] oidCostUnits, boolean isAllCostTypes, boolean isAllCostCentres, boolean isAllCostUnits, ICurrency currency, Date from, Date until, CostPlanVariant costPlanVariant, CostingCompany costingCompany, ExtendedFilterStruct[] analysisCodesCostTypes, ExtendedFilterStruct[] analysisCodesCostCentres, ExtendedFilterStruct[] analysisCodesCostUnits, String costCentreFrom, String costCentreTo, String costUnitFrom, String costUnitTo, String unitDateValidFrom, String unitDateValidTo, String[] managerCostCentreSeq, String[] managerCentreGroupSeq, String[] managerCostUnitSeq, String[] managerUnitGroupSeq, String[] costUnitStateEnumCodes, String[] costUnitCustomerCodes, String[] orderNoTypeCodes, String orderNoFrom, String orderNoTo, String[] oidCostTypeGroups, String[] oidCostCentreGroups, String[] oidCostUnitGroups) throws BusinessDomainException {
        String[] ctbs;
        int i;
        boolean isPieceNumberAddidtion;
        if (oidCostCentres != null && oidCostCentres.length > 0 || isAllCostCentres || analysisCodesCostCentres != null && analysisCodesCostCentres.length > 0 || !StringMapper.isNullString((String)costCentreFrom) || !StringMapper.isNullString((String)costCentreTo) || oidCostCentreGroups != null && oidCostCentreGroups.length > 0 || managerCostCentreSeq != null && managerCostCentreSeq.length > 0 || managerCentreGroupSeq != null && managerCentreGroupSeq.length > 0) {
            this.isCostCentreRead = true;
            int counter = 0;
            ArrayList<String> ctbList = new ArrayList<String>();
            ArrayList<CostCentreReportBalance> returnList = new ArrayList<CostCentreReportBalance>();
            ArrayList<String> allCostCentresList = new ArrayList<String>();
            String[] allOIDsCostCentres = null;
            if (!isAllCostCentres) {
                allOIDsCostCentres = this.makeCostCentreObjectIDsForGivenFilter(oidCostingCompany, oidCostCentres, analysisCodesCostCentres, costCentreFrom, costCentreTo, managerCostCentreSeq, managerCentreGroupSeq, oidCostCentreGroups, allCostCentresList);
            }
            if (!(allOidCostTypes != null && allOidCostTypes.length != 0 || analysisCodesCostTypes == null && allOidCostTypes.length <= 0 && (oidCostTypeGroups == null || oidCostTypeGroups.length <= 0) || isAllCostTypes)) {
                allOidCostTypes = this.makeOIDCostTypesForSelection(oidCostingCompany, analysisCodesCostTypes, oidCostTypeGroups);
            }
            if (!(allOIDsCostCentres != null && allOIDsCostCentres.length != 0 || isAllCostCentres)) {
                this.mCostCentreReportBalances = new CostCentreReportBalance[0];
                this.isCostCentreRead = false;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("JM-KST-Filter :  Keine KST-Selektion  ! ");
                }
            } else {
                isPieceNumberAddidtion = CostingConfig.getIsSpecialQuantityAdditionForReporting();
                if (!isAllCostTypes) {
                    for (i = 0; i < allOidCostTypes.length; ++i) {
                        if (counter != 0 && counter % MAXSELECTIN == 0 || i == allOidCostTypes.length - 1) {
                            if (i == allOidCostTypes.length - 1) {
                                ctbList.add(allOidCostTypes[i]);
                            }
                            ctbs = new String[ctbList.size()];
                            ctbList.toArray(ctbs);
                            this.mBalancesHelp = null;
                            this.mBalancesHelp = allOIDsCostCentres == null || allOIDsCostCentres.length < MAXSELECTIN ? CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelected(isAllCostCentres ? null : allOIDsCostCentres, ctbs, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, isPieceNumberAddidtion) : CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCC1000(isAllCostCentres ? null : allOIDsCostCentres, ctbs, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, isPieceNumberAddidtion);
                            returnList.addAll(Arrays.asList(this.mBalancesHelp));
                            ctbList = new ArrayList();
                            counter = 0;
                        }
                        if (i != allOidCostTypes.length - 1) {
                            ctbList.add(allOidCostTypes[i]);
                        }
                        ++counter;
                    }
                    this.mCostCentreReportBalances = new CostCentreReportBalance[returnList.size()];
                    returnList.toArray(this.mCostCentreReportBalances);
                } else {
                    this.mBalancesHelp = null;
                    this.mCostCentreReportBalances = allOIDsCostCentres.length < MAXSELECTIN ? CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelected(isAllCostCentres ? null : allOIDsCostCentres, null, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, isPieceNumberAddidtion) : CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCC1000(isAllCostCentres ? null : allOIDsCostCentres, null, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, isPieceNumberAddidtion);
                }
            }
        }
        if (oidCostUnits != null && oidCostUnits.length > 0 || isAllCostUnits || analysisCodesCostUnits != null && analysisCodesCostUnits.length > 0 || !StringMapper.isNullString((String)costCentreFrom) || !StringMapper.isNullString((String)costUnitTo) || oidCostUnitGroups != null && oidCostUnitGroups.length > 0 || managerCostUnitSeq != null && managerCostUnitSeq.length > 0 || managerUnitGroupSeq != null && managerUnitGroupSeq.length > 0 || !StringMapper.isNullString((String)unitDateValidFrom) || !StringMapper.isNullString((String)unitDateValidTo) || costUnitStateEnumCodes != null && costUnitStateEnumCodes.length > 0 || costUnitCustomerCodes != null && costUnitCustomerCodes.length > 0 || orderNoTypeCodes != null && orderNoTypeCodes.length > 0 || !StringMapper.isNullString((String)orderNoFrom) || !StringMapper.isNullString((String)orderNoTo)) {
            this.isCostUnitRead = true;
            int counterCU = 0;
            ArrayList<String> ctbListCU = new ArrayList<String>();
            ArrayList<CostUnitReportBalance> returnListCU = new ArrayList<CostUnitReportBalance>();
            ArrayList<String> allCostUnitsList = new ArrayList<String>();
            String[] allOIDsCostUnits = null;
            if (!isAllCostUnits) {
                allOIDsCostUnits = this.makeCostUnitObjectIDsForGivenFilter(oidCostingCompany, oidCostUnits, analysisCodesCostUnits, costCentreFrom, costUnitFrom, costUnitTo, unitDateValidFrom, unitDateValidTo, managerCostUnitSeq, managerUnitGroupSeq, costUnitStateEnumCodes, costUnitCustomerCodes, orderNoTypeCodes, orderNoFrom, orderNoTo, oidCostUnitGroups, allCostUnitsList);
            }
            if (!(allOidCostTypes != null && allOidCostTypes.length != 0 || analysisCodesCostTypes == null && allOidCostTypes.length <= 0 && (oidCostTypeGroups == null || oidCostTypeGroups.length <= 0) || isAllCostTypes)) {
                allOidCostTypes = this.makeOIDCostTypesForSelection(oidCostingCompany, analysisCodesCostTypes, oidCostTypeGroups);
            }
            if (!(allOIDsCostUnits != null && allOIDsCostUnits.length != 0 || isAllCostUnits)) {
                this.mCostUnitReportBalances = new CostUnitReportBalance[0];
                this.isCostUnitRead = false;
            } else if (!isAllCostTypes) {
                isPieceNumberAddidtion = CostingConfig.getIsSpecialQuantityAdditionForReporting();
                for (i = 0; i < allOidCostTypes.length; ++i) {
                    if (counterCU != 0 && counterCU % MAXSELECTIN == 0 || i == allOidCostTypes.length - 1) {
                        if (i == allOidCostTypes.length - 1) {
                            ctbListCU.add(allOidCostTypes[i]);
                        }
                        ctbs = new String[ctbListCU.size()];
                        ctbListCU.toArray(ctbs);
                        this.mBalancesHelpCU = null;
                        this.mBalancesHelpCU = allOIDsCostUnits == null || allOIDsCostUnits.length < MAXSELECTIN ? CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU(allOIDsCostUnits, ctbs, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isPieceNumberAddidtion) : CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU1000(allOIDsCostUnits, ctbs, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isPieceNumberAddidtion);
                        returnListCU.addAll(Arrays.asList(this.mBalancesHelpCU));
                        ctbListCU = new ArrayList();
                        counterCU = 0;
                    }
                    if (i != allOidCostTypes.length - 1) {
                        ctbListCU.add(allOidCostTypes[i]);
                    }
                    ++counterCU;
                }
                this.mCostUnitReportBalances = new CostUnitReportBalance[returnListCU.size()];
                returnListCU.toArray(this.mCostUnitReportBalances);
            } else {
                this.mCostUnitReportBalances = null;
                isPieceNumberAddidtion = CostingConfig.getIsSpecialQuantityAdditionForReporting();
                this.mCostUnitReportBalances = allOIDsCostUnits.length < MAXSELECTIN ? CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU(allOIDsCostUnits, null, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isPieceNumberAddidtion) : CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU1000(allOIDsCostUnits, null, currency, null, from, until, (CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea), costPlanVariant, oidCostingCompany, isPieceNumberAddidtion);
            }
        }
        return this.costingBalanceStructs(costingCompany, currency);
    }

    private String[] makeCostUnitObjectIDsForGivenFilter(String oidCostingCompany, String[] oidCostUnits, ExtendedFilterStruct[] analysisCodesCostUnits, String costCentreFrom, String costUnitFrom, String costUnitTo, String unitDateValidFrom, String unitDateValidTo, String[] managerCostUnitSeq, String[] managerUnitGroupSeq, String[] costUnitStateEnumCodes, String[] costUnitCustomerCodes, String[] orderNoTypeCodes, String orderNoFrom, String orderNoTo, String[] oidCostUnitGroups, List<String> allCostUnitsList) throws BusinessDomainException {
        int i;
        if (oidCostUnits != null && oidCostUnits.length > 0) {
            for (int i2 = 0; i2 < oidCostUnits.length; ++i2) {
                allCostUnitsList.add(oidCostUnits[i2]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JM-KTR-Filter 1 (KTRS) L\u00e4nge =  {} ", oidCostUnits != null && oidCostUnits.length > 0 ? Integer.valueOf(oidCostUnits.length) : "keine einzelnen KTRS ");
        }
        if (analysisCodesCostUnits != null && analysisCodesCostUnits.length > 0 || !StringMapper.isNullString((String)costCentreFrom) || !StringMapper.isNullString((String)costUnitTo) || managerCostUnitSeq != null && managerCostUnitSeq.length > 0 || !StringMapper.isNullString((String)unitDateValidFrom) || !StringMapper.isNullString((String)unitDateValidTo) || costUnitStateEnumCodes != null && costUnitStateEnumCodes.length > 0 || costUnitCustomerCodes != null && costUnitCustomerCodes.length > 0 || orderNoTypeCodes != null && orderNoTypeCodes.length > 0 || !StringMapper.isNullString((String)orderNoFrom) || !StringMapper.isNullString((String)orderNoTo)) {
            Criterion costUnitssFromEnhancedFilters = CostUnitPersistencyManager.makeBaseFilterCriterionForCostUnitSelection((String)oidCostingCompany, (ExtendedFilterStruct[])analysisCodesCostUnits, (String)costUnitFrom, (String)costUnitTo, (String)unitDateValidFrom, (String)unitDateValidTo, (String[])managerCostUnitSeq, (String[])costUnitStateEnumCodes, (String[])costUnitCustomerCodes, (String[])orderNoTypeCodes, (String)orderNoFrom, (String)orderNoTo, (String[])oidCostUnitGroups);
            CostUnit[] costUnitsFromEnhancedFilter = CostUnitPersistencyManager.query(null, (Criterion)costUnitssFromEnhancedFilters);
            String[] costUnitOIDsFromEnhancedFilter = new String[costUnitsFromEnhancedFilter.length];
            for (i = 0; i < costUnitsFromEnhancedFilter.length; ++i) {
                costUnitOIDsFromEnhancedFilter[i] = costUnitsFromEnhancedFilter[i].getObjectid();
            }
            if (costUnitOIDsFromEnhancedFilter != null && costUnitOIDsFromEnhancedFilter.length > 0) {
                for (i = 0; i < costUnitOIDsFromEnhancedFilter.length; ++i) {
                    allCostUnitsList.add(costUnitOIDsFromEnhancedFilter[i]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KTR-Filter 2 (erw. Filter) L\u00e4nge =  {} ", costUnitOIDsFromEnhancedFilter != null && costUnitOIDsFromEnhancedFilter.length > 0 ? Integer.valueOf(costUnitOIDsFromEnhancedFilter.length) : "keine einzelnen KSTS aus erw. Filter");
            }
        }
        if (managerUnitGroupSeq != null && managerUnitGroupSeq.length > 0) {
            Criterion criterionForCostUnitGroupManagersFilter = CostUnitPersistencyManager.makeBaseFilterCriterionForCostUnitGroupManagerSelection((String[])managerUnitGroupSeq, (String)oidCostingCompany);
            CostingGroup[] costingGroups = CostingGroupPersistencyManager.query((Order[])new Order[]{Order.asc((String)"code")}, (Criterion)criterionForCostUnitGroupManagersFilter);
            String[] costunitOIDsForKTRGroupManager = new String[costingGroups.length];
            for (i = 0; i < costingGroups.length; ++i) {
                costunitOIDsForKTRGroupManager[i] = costingGroups[i].getObjectid();
            }
            if (costunitOIDsForKTRGroupManager != null && costunitOIDsForKTRGroupManager.length > 0) {
                for (i = 0; i < costunitOIDsForKTRGroupManager.length; ++i) {
                    allCostUnitsList.add(costunitOIDsForKTRGroupManager[i]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KTR-Filter 3 (erw. Filter) L\u00e4nge =  {} ", costunitOIDsForKTRGroupManager != null && costunitOIDsForKTRGroupManager.length > 0 ? Integer.valueOf(costunitOIDsForKTRGroupManager.length) : "keine einzelnen KSTS aus KST-Gruppen-Leiter");
            }
        }
        CostUnitGroup[] costUnitGruoups = null;
        if (oidCostUnitGroups != null && oidCostUnitGroups.length > 0) {
            costUnitGruoups = new CostUnitGroup[oidCostUnitGroups.length];
            for (int j = 0; j < costUnitGruoups.length; ++j) {
                costUnitGruoups[j] = (CostUnitGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostUnitGroups[j]);
            }
            String[] oidCostUnitBasesFromAllGroups = CostUnitPersistencyManager.readCostUnitOIDsForAllGroups((CostUnitGroup[])costUnitGruoups);
            if (oidCostUnitBasesFromAllGroups != null && oidCostUnitBasesFromAllGroups.length > 0) {
                for (int i3 = 0; i3 < oidCostUnitBasesFromAllGroups.length; ++i3) {
                    allCostUnitsList.add(oidCostUnitBasesFromAllGroups[i3]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KTR-Filter 4 (erw. Filter) L\u00e4nge =  {} ", oidCostUnitBasesFromAllGroups != null && oidCostUnitBasesFromAllGroups.length > 0 ? Integer.valueOf(oidCostUnitBasesFromAllGroups.length) : "keine einzelnen KSTS aus einzelnen mitg. KST-Gruppen");
            }
        }
        String[] allOIDsCostUnits = new String[allCostUnitsList.size()];
        allCostUnitsList.toArray(allOIDsCostUnits);
        return allOIDsCostUnits;
    }

    private String[] makeCostCentreObjectIDsForGivenFilter(String oidCostingCompany, String[] oidCostCentres, ExtendedFilterStruct[] analysisCodesCostCentres, String costCentreFrom, String costCentreTo, String[] managerCostCentreSeq, String[] managerCentreGroupSeq, String[] oidCostCentreGroups, List<String> allCostCentresList) throws BusinessDomainException {
        int i;
        if (oidCostCentres != null && oidCostCentres.length > 0) {
            for (int i2 = 0; i2 < oidCostCentres.length; ++i2) {
                allCostCentresList.add(oidCostCentres[i2]);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JM-KST-Filter 1 (KSTS) L\u00e4nge =  {} ", oidCostCentres != null && oidCostCentres.length > 0 ? Integer.valueOf(oidCostCentres.length) : "keine einzelnen KSTS ");
        }
        if (analysisCodesCostCentres != null && analysisCodesCostCentres.length > 0 || !StringMapper.isNullString((String)costCentreFrom) || !StringMapper.isNullString((String)costCentreTo) || managerCostCentreSeq != null && managerCostCentreSeq.length > 0) {
            Criterion costCentresFromEnhancedFilters = CostCentreBasePersistencyManager.makeBaseFilterForCostCentreSelectionStatement((String)oidCostingCompany, (ExtendedFilterStruct[])analysisCodesCostCentres, (String[])managerCostCentreSeq, (String)costCentreFrom, (String)costCentreTo);
            CostCentreBase[] costCentreBasesFromEnhancedFilter = CostCentreBasePersistencyManager.query(null, (Criterion)costCentresFromEnhancedFilters);
            String[] costcentreOIDsFromEnhancedFilter = new String[costCentreBasesFromEnhancedFilter.length];
            for (i = 0; i < costCentreBasesFromEnhancedFilter.length; ++i) {
                costcentreOIDsFromEnhancedFilter[i] = costCentreBasesFromEnhancedFilter[i].getObjectid();
            }
            if (costcentreOIDsFromEnhancedFilter != null && costcentreOIDsFromEnhancedFilter.length > 0) {
                for (i = 0; i < costcentreOIDsFromEnhancedFilter.length; ++i) {
                    allCostCentresList.add(costcentreOIDsFromEnhancedFilter[i]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KST-Filter 2 (erw. Filter) L\u00e4nge =  {} ", costcentreOIDsFromEnhancedFilter != null && costcentreOIDsFromEnhancedFilter.length > 0 ? Integer.valueOf(costcentreOIDsFromEnhancedFilter.length) : "keine einzelnen KSTS aus erw. Filter");
            }
        }
        if (managerCentreGroupSeq != null && managerCentreGroupSeq.length > 0) {
            Criterion criterionForCostCentreGroupManagersFilter = CostCentreBasePersistencyManager.makeBaseFilterCriterionForCostCentreGroupManagerSelection((String[])managerCentreGroupSeq, (String)oidCostingCompany);
            CostingGroup[] costingGroups = CostingGroupPersistencyManager.query((Order[])new Order[]{Order.asc((String)"code")}, (Criterion)criterionForCostCentreGroupManagersFilter);
            String[] costcentreOIDsForKSTGroupManager = new String[costingGroups.length];
            for (i = 0; i < costingGroups.length; ++i) {
                costcentreOIDsForKSTGroupManager[i] = costingGroups[i].getObjectid();
            }
            if (costcentreOIDsForKSTGroupManager != null && costcentreOIDsForKSTGroupManager.length > 0) {
                for (i = 0; i < costcentreOIDsForKSTGroupManager.length; ++i) {
                    allCostCentresList.add(costcentreOIDsForKSTGroupManager[i]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KST-Filter 3 (erw. Filter) L\u00e4nge =  {} ", costcentreOIDsForKSTGroupManager != null && costcentreOIDsForKSTGroupManager.length > 0 ? Integer.valueOf(costcentreOIDsForKSTGroupManager.length) : "keine einzelnen KSTS aus KST-Gruppen-Leiter");
            }
        }
        CostCentreGroup[] costCentreGruoups = null;
        if (oidCostCentreGroups != null && oidCostCentreGroups.length > 0) {
            costCentreGruoups = new CostCentreGroup[oidCostCentreGroups.length];
            for (int j = 0; j < costCentreGruoups.length; ++j) {
                costCentreGruoups[j] = (CostCentreGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostCentreGroups[j]);
            }
            String[] oidCostCentreBasesFromAllGroups = CostCentreBasePersistencyManager.readCostCentreOIDsForAllGroups((CostCentreGroup[])costCentreGruoups);
            if (oidCostCentreBasesFromAllGroups != null && oidCostCentreBasesFromAllGroups.length > 0) {
                for (int i3 = 0; i3 < oidCostCentreBasesFromAllGroups.length; ++i3) {
                    allCostCentresList.add(oidCostCentreBasesFromAllGroups[i3]);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KST-Filter 4 (erw. Filter) L\u00e4nge =  {} ", oidCostCentreBasesFromAllGroups != null && oidCostCentreBasesFromAllGroups.length > 0 ? Integer.valueOf(oidCostCentreBasesFromAllGroups.length) : "keine einzelnen KSTS aus einzelnen mitg. KST-Gruppen");
            }
        }
        String[] allOIDsCostCentres = new String[allCostCentresList.size()];
        allCostCentresList.toArray(allOIDsCostCentres);
        return allOIDsCostCentres;
    }

    private String[] makeOIDCostTypesForSelection(String oidCostingCompany, ExtendedFilterStruct[] analysisCodesCostTypes, String[] oidCostTypeGroups) throws BusinessDomainException {
        Criterion criterionForCostTypesAnalysecodes;
        CostTypeBase[] costTypeBases;
        ArrayList<String> allCostTypesList = new ArrayList<String>();
        if (analysisCodesCostTypes != null && analysisCodesCostTypes.length > 0 && (costTypeBases = CostTypeBasePersistencyManager.query(null, (Criterion)(criterionForCostTypesAnalysecodes = CostTypeBasePersistencyManager.makeBaseFilterForCostTypeSelectionStatement((String)oidCostingCompany, (ExtendedFilterStruct[])analysisCodesCostTypes)))) != null && costTypeBases.length > 0) {
            for (int i = 0; i < costTypeBases.length; ++i) {
                allCostTypesList.add(costTypeBases[i].getObjectid());
            }
        }
        CostTypeGroup[] costTypeGruoups = null;
        if (oidCostTypeGroups != null && oidCostTypeGroups.length > 0) {
            costTypeGruoups = new CostTypeGroup[oidCostTypeGroups.length];
            for (int j = 0; j < costTypeGruoups.length; ++j) {
                costTypeGruoups[j] = (CostTypeGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostTypeGroups[j]);
            }
            String[] oidCostTypeBasesFromAllGroups = CostTypeBasePersistencyManager.readCostTypeOIDsForAllGroups((CostTypeGroup[])costTypeGruoups);
            if (oidCostTypeBasesFromAllGroups != null && oidCostTypeBasesFromAllGroups.length > 0) {
                allCostTypesList.addAll(Arrays.asList(oidCostTypeBasesFromAllGroups));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("JM-KOA-Filter 4 (erw. Filter) L\u00e4nge =  {} ", oidCostTypeBasesFromAllGroups != null && oidCostTypeBasesFromAllGroups.length > 0 ? Integer.valueOf(oidCostTypeBasesFromAllGroups.length) : "keine einzelnen KOAs aus einzelnen mitg. KOA-Gruppen");
            }
        }
        String[] allOidCostTypes = new String[allCostTypesList.size()];
        allCostTypesList.toArray(allOidCostTypes);
        return allOidCostTypes;
    }

    private CostingBalanceStruct[] calculateValuesFromCostingSplit(String oidCostingCompany, short costingarea, String[] oidCostTypes, String[] oidCostCentres, String[] oidCostUnits, boolean isAllCostTypes, boolean isAllCostCentres, boolean isAllCostUnits, ExtendedFilterStruct[] extFilter, ICurrency currency, Date from, Date until, CostPlanVariant costPlanVariant, CostingCompany costingCompany, ExtendedFilterStruct[] analysisCodesCostCentres, ExtendedFilterStruct[] analysisCodesCostUnits, String costCentreFrom, String costCentreTo, String costUnitFrom, String costUnitTo, String unitDateValidFrom, String unitDateValidTo, String[] managerCostCentreSeq, String[] managerCentreGroupSeq, String[] managerCostUnitSeq, String[] managerUnitGroupSeq, String[] costUnitStateEnumCodes, String[] costUnitCustomerCodes, String[] orderNoTypeCodes, String orderNoFrom, String orderNoTo, String[] oidCostCentreGroups, String[] oidCostUnitGroups) throws BusinessDomainException {
        ArrayList<String> allCostCentresList = new ArrayList<String>();
        String[] allOIDsCostCentres = null;
        if (!isAllCostCentres) {
            allOIDsCostCentres = this.makeCostCentreObjectIDsForGivenFilter(oidCostingCompany, oidCostCentres, analysisCodesCostCentres, costCentreFrom, costCentreTo, managerCostCentreSeq, managerCentreGroupSeq, oidCostCentreGroups, allCostCentresList);
        }
        if (allOIDsCostCentres != null && allOIDsCostCentres.length > 0 || isAllCostCentres) {
            this.isCostCentreRead = true;
            this.mCostCentreReportBalances = CostingSplitPersistencyManager.getCostCentreReportBalancesAreasStringArray((String[])oidCostTypes, (String[])allOIDsCostCentres, null, (ICurrency)currency, null, (Date)from, (Date)until, (CostingAreaType)((CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea)), (CostPlanVariant)costPlanVariant, (ExtendedFilterStruct[])extFilter, (boolean)isAllCostTypes, (boolean)isAllCostCentres, (boolean)isAllCostUnits, (String)oidCostingCompany);
        }
        ArrayList<String> allCostUnitsList = new ArrayList<String>();
        String[] allOIDsCostUnits = null;
        if (!isAllCostUnits) {
            allOIDsCostUnits = this.makeCostUnitObjectIDsForGivenFilter(oidCostingCompany, oidCostUnits, analysisCodesCostUnits, costCentreFrom, costUnitFrom, costUnitTo, unitDateValidFrom, unitDateValidTo, managerCostUnitSeq, managerUnitGroupSeq, costUnitStateEnumCodes, costUnitCustomerCodes, orderNoTypeCodes, orderNoFrom, orderNoTo, oidCostUnitGroups, allCostUnitsList);
        }
        if (allOIDsCostUnits != null && allOIDsCostUnits.length > 0 || isAllCostUnits) {
            this.isCostUnitRead = true;
            this.mCostUnitReportBalances = CostingSplitPersistencyManager.getCostUnitReportBalancesAreasStringArray((String[])oidCostTypes, null, (String[])allOIDsCostUnits, (ICurrency)currency, null, (Date)from, (Date)until, (CostingAreaType)((CostingAreaType)PersistableEnumUtils.toEnum(CostingAreaType.class, (int)costingarea)), (CostPlanVariant)costPlanVariant, (ExtendedFilterStruct[])extFilter, (boolean)isAllCostTypes, (boolean)isAllCostCentres, (boolean)isAllCostUnits, (String)oidCostingCompany);
        }
        return this.costingBalanceStructs(costingCompany, currency);
    }

    private CostingBalanceStruct[] costingBalanceStructs(CostingCompany costingCompany, ICurrency currency) {
        if (this.isCostCentreRead && this.isCostUnitRead) {
            ArrayList<CostingBalanceStruct> costingBalanceStructArray = new ArrayList<CostingBalanceStruct>();
            CostingBalanceStruct[] returnCentres = null;
            if (this.mCostCentreReportBalances != null) {
                returnCentres = ExportActCostingMapper.toCostingCostingBalanceStructIdl((CostCentreReportBalance[])this.mCostCentreReportBalances, (CostingCompany)costingCompany, (ICurrency)currency);
            }
            CostingBalanceStruct[] returnUnits = null;
            if (this.mCostUnitReportBalances != null) {
                returnUnits = ExportActCostingMapper.toCostingCostingBalanceCostUnitStructIdl((ReportBalance[])this.mCostUnitReportBalances, (CostingCompany)costingCompany, (ICurrency)currency);
            }
            if (returnCentres != null) {
                costingBalanceStructArray.addAll(Arrays.asList(returnCentres));
            }
            if (returnUnits != null) {
                costingBalanceStructArray.addAll(Arrays.asList(returnUnits));
            }
            CostingBalanceStruct[] returnCostCentresAndCostUnits = null;
            if (costingBalanceStructArray != null) {
                returnCostCentresAndCostUnits = new CostingBalanceStruct[costingBalanceStructArray.size()];
                costingBalanceStructArray.toArray(returnCostCentresAndCostUnits);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("KoRe-Reporting return {} CostCentres and {} CostCentres", returnCentres == null ? "CC = null" : Integer.valueOf(returnCentres.length), returnUnits == null ? "CU = null" : Integer.valueOf(returnUnits.length));
                }
            }
            return returnCostCentresAndCostUnits;
        }
        if (this.isCostCentreRead) {
            CostingBalanceStruct[] returnCentres = null;
            if (this.mCostCentreReportBalances != null) {
                returnCentres = new CostingBalanceStruct[this.mCostCentreReportBalances.length];
                returnCentres = ExportActCostingMapper.toCostingCostingBalanceStructIdl((CostCentreReportBalance[])this.mCostCentreReportBalances, (CostingCompany)costingCompany, (ICurrency)currency);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("KoRe-Reporting return {} CostCentres ", (Object)returnCentres.length);
            }
            return returnCentres;
        }
        if (this.isCostUnitRead) {
            CostingBalanceStruct[] returnUnits = null;
            if (this.mCostUnitReportBalances != null) {
                returnUnits = new CostingBalanceStruct[this.mCostUnitReportBalances.length];
                returnUnits = ExportActCostingMapper.toCostingCostingBalanceCostUnitStructIdl((ReportBalance[])this.mCostUnitReportBalances, (CostingCompany)costingCompany, (ICurrency)currency);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("KoRe-Reporting return {} CostUnits ", (Object)returnUnits.length);
                }
            }
            return returnUnits;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("KoRe-Reporting no values, wrong calling from client (KoRe-Reporting)");
        }
        return null;
    }
}

