/*
 * Decompiled with CFR 0.152.
 */
package com.varial.costing.base.domain.actcostingdata.kstktrkoabalance;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.persistency.criterion.SubSelect;
import com.varial.base.persistency.criterion.Subqueries;
import com.varial.base.session.SessionContext;
import com.varial.costing.base.costingquantity.CostingAreaTypeEnum;
import com.varial.costing.base.domain.actcostingdata.CostingAreaType;
import com.varial.costing.base.domain.actcostingdata.koabalance.CostTypeReportBalanceNew;
import com.varial.costing.base.domain.actcostingdata.kstgroupkoabalance.CostingGroupCostTypeSumBalance;
import com.varial.costing.base.domain.actcostingdata.kstkoabalance.CostCentreReportBalance;
import com.varial.costing.base.domain.actcostingdata.kstkoabalance.CostCentreSumBalance;
import com.varial.costing.base.domain.actcostingdata.kstkoabalance.CountBalanceKst;
import com.varial.costing.base.domain.actcostingdata.kstkoabalance.SumBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostCentreCostTypeSumBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostClosingUnitCentreTypeSumBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostTypeCentreUnitReportBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostUnitCostCentreCostTypeSumBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostingSplitKstKtrKoaBalance;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.CostskstktrkbalPersistencyAppl;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.SumBalanceCostType;
import com.varial.costing.base.domain.actcostingdata.kstktrkoabalance.SumBalanceKstKtrWithFixAndVar;
import com.varial.costing.base.domain.actcostingdata.ktrkoabalance.CostUnitReportBalance;
import com.varial.costing.base.domain.actcostingdata.ktrkoabalance.CostUnitSumBalance;
import com.varial.costing.base.domain.actcostingdata.ktrkoabalance.CountBalanceKtr;
import com.varial.costing.base.domain.analyse.settings.AnalyseSettingExceptionMapper;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.costing.base.domain.costingcompany.CostingCompany;
import com.varial.costing.base.domain.costingcompany.CostingCompanyPersistencyManager;
import com.varial.costing.base.domain.costinghierarchy.CostingGroup;
import com.varial.costing.base.domain.costinghierarchy.CostingGroupPersistencyManager;
import com.varial.costing.base.domain.costingreport.ReportBalance;
import com.varial.costing.base.domain.costingsetup.CostPlanVariant;
import com.varial.costing.base.domain.costingsetup.CostingConfig;
import com.varial.costing.base.domain.costingsetup.CostingSetup;
import com.varial.costing.base.domain.costingyear.CostingYear;
import com.varial.costing.base.domain.costtypebase.CostTypeBase;
import com.varial.costing.base.domain.costtypebase.CostTypeBasePersistencyManager;
import com.varial.costing.base.domain.costtypebase.ICostTypeBase;
import com.varial.costing.base.domain.costunit.CostUnit;
import com.varial.costing.base.mapper.CostingAreaTypeMapper;
import com.varial.costing.base.persistency.costsctcccu.CostsctcccuContainer;
import com.varial.costing.base.persistency.costsctcccu.ICostsctcccuDao;
import com.varial.costing.base.servantimpl.AnalyseServantImpl;
import com.varial.framework.domain.balance.Balance;
import com.varial.framework.domain.balance.BalancePersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import com.varial.serverbase.persistency.SelectGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CostingSplitKstKtrKoaBalancePersistencyManager
extends BalancePersistencyManager {
    private static Logger LOGGER = LoggerFactory.getLogger((String)CostingSplitKstKtrKoaBalancePersistencyManager.class.getName());
    private static ICostsctcccuDao dao = (ICostsctcccuDao)UtilitiesManager.getApplicationContext().getBean("costsctcccuDao");
    private static final int MAX_SELECT_IN = 999;
    private final List<String> oidCostCentreList = new LinkedList<String>();
    private final List<String> oidCostUnitList = new LinkedList<String>();
    private static CostingSplitKstKtrKoaBalancePersistencyManager impl;

    private CostingSplitKstKtrKoaBalancePersistencyManager() {
    }

    public static synchronized CostingSplitKstKtrKoaBalancePersistencyManager getInstance() {
        if (impl == null) {
            impl = new CostingSplitKstKtrKoaBalancePersistencyManager();
        }
        return impl;
    }

    protected Criterion getDomainFilter(Balance balance) {
        String[] keys = balance.getDomainID().getKeys();
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidcurrency", (String)keys[0]), Restrictions.eq((String)"oidcostcentre", (String)keys[1]), Restrictions.eq((String)"oidcostunit", (String)keys[2]), Restrictions.eq((String)"oidcosttypebase", (String)keys[3]), Restrictions.eq((String)"oidcostingyear", (String)keys[4]), Restrictions.eq((String)"costingarea", (String)keys[5]), Restrictions.eq((String)"oidplanvariant", (String)keys[6])});
    }

    public void load(CostingSplitKstKtrKoaBalance b) {
        CostsctcccuContainer container = null;
        try {
            if (b.hasObjectid()) {
                container = dao.getRowByObjectID(b.getObjectid());
            } else {
                if (b.getDomainID() == null) {
                    throw ExceptionMapper.makeApplicationException((String)"object has no domainkey");
                }
                CostsctcccuContainer[] containers = dao.getRows(null, this.getDomainFilter((Balance)b));
                if (containers.length > 0) {
                    container = containers[0];
                }
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            b.initTotals();
        } else {
            CostingSplitKstKtrKoaBalancePersistencyManager.fillKstKtrKoaBalance(b, container);
        }
    }

    protected void insert(Balance balance) {
        try {
            CostingSplitKstKtrKoaBalance b = (CostingSplitKstKtrKoaBalance)balance;
            CostsctcccuContainer container = dao.getInitializedInstance();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Costing area:{},Company: {},OIDPlanVariant:{},{}Costing year:{},Currency:{},Cost type:{},{}Cost centre:{},Cost unit:{}", new Object[]{container.costingarea, container.oidcompany == null ? "null" : container.oidcompany, container.oidplanvariant == null ? "null" : container.oidplanvariant, System.lineSeparator(), container.oidcostingyear == null ? "null" : container.oidcostingyear, container.oidcurrency == null ? "null" : container.oidcurrency, container.oidcosttypebase == null ? "null" : container.oidcosttypebase, System.lineSeparator(), container.oidcostcentre == null ? "null" : container.oidcostcentre, container.oidcostunit == null ? "null" : container.oidcostunit});
            }
            CostingSplitKstKtrKoaBalancePersistencyManager.fillContainer(container, b);
            container = dao.insert(SessionContext.getInstance().getSession().getUserCode(), container);
            b.setLastuser(container.getLastUserid());
            b.setObjectid(container.getObjectid());
            b.setTimestamp(container.getObjectTS());
            b.setVersion(container.getVersion());
            b.setAbsolutValuesUnchanged();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    protected void saveImpl(Balance b) {
        CostingSplitKstKtrKoaBalance nab = (CostingSplitKstKtrKoaBalance)b;
        if (nab.absolutValuesChanged()) {
            try {
                CostskstktrkbalPersistencyAppl.updateStartBalances((String)nab.getObjectid(), (BigDecimal)nab.getStartAmountDebit(), (BigDecimal)nab.getStartAmountCredit(), (BigDecimal)nab.getStartQuantityDebit(), (BigDecimal)nab.getStartQuantityCredit());
            }
            catch (Exception e) {
                throw ExceptionMapper.makeApplicationException((Throwable)e);
            }
            nab.setAbsolutValuesUnchanged();
        }
    }

    private static void fillKstKtrKoaBalance(CostingSplitKstKtrKoaBalance p, CostsctcccuContainer container) {
        p.setVersion(container.getVersion());
        p.setTimestamp(container.getObjectTS());
        p.setLastuser(container.getLastUserid());
        p.setObjectid(container.getObjectid());
        p.setData(container.amountdebit, container.amountcredit, container.quantitydebit, container.quantitycredit, container.startamountdebit, container.startamountcredit, container.startquantdebit, container.startquantcredit, container.amountdebitfix, container.amountcreditfix);
    }

    private static void fillContainer(CostsctcccuContainer container, CostingSplitKstKtrKoaBalance p) {
        String oidCostCentreBase = null;
        if (p.getCostCentreBase() != null) {
            oidCostCentreBase = p.getCostCentreBase().getObjectid();
        }
        String oidCostUnit = null;
        if (p.getCostUnit() != null) {
            oidCostUnit = p.getCostUnit().getObjectid();
        }
        String oidPlanVariant = null;
        if (p.getCostPlanVariant() != null) {
            LOGGER.debug(" vlog oidPlanVariant != null");
            oidPlanVariant = p.getCostPlanVariant().getObjectid();
        }
        String oidCompany = null;
        if (p.getCostingYear().getCompany() != null) {
            oidCompany = p.getCostingYear().getCompany().getObjectid();
        }
        container.oidcompany = oidCompany;
        container.oidcostcentre = oidCostCentreBase;
        container.oidcostunit = oidCostUnit;
        container.oidcosttypebase = p.getCostTypeBase().getObjectid();
        container.oidcostingyear = p.getCostingYear().getObjectid();
        container.oidcurrency = p.getCurrency().getObjectid();
        container.costingarea = p.getCostingAreaType() == null ? PersistableEnumUtils.toPersistentValue((PersistableEnum)CostingAreaType.ACTUAL) : PersistableEnumUtils.toPersistentValue((PersistableEnum)p.getCostingAreaType());
        container.amountdebit = p.getDifferenceAmountDebit();
        container.amountcredit = p.getDifferenceAmountCredit();
        container.quantitydebit = p.getDifferenceQuantityDebit();
        container.quantitycredit = p.getDifferenceQuantityCredit();
        container.startamountdebit = p.getStartAmountDebit();
        container.startamountcredit = p.getStartAmountCredit();
        container.startquantdebit = p.getStartQuantityDebit();
        container.startquantcredit = p.getStartQuantityCredit();
        container.amountdebitfix = p.getDifferenceAmountDebitFix();
        container.amountcreditfix = p.getDifferenceAmountCreditVar();
        container.startamoundebitfix = p.getStartAmountDebitFix();
        container.startamoucreditfix = p.getStartAmountCreditFix();
        container.amountdebitvar = p.getDifferenceAmountDebitVar();
        container.amountcreditvar = p.getDifferenceAmountCreditVar();
        container.startamoundebitvar = p.getStartAmountDebitVar();
        container.startamoucreditvar = p.getStartAmountCreditVar();
        container.currencytype = 0;
        container.setObjectid(p.getObjectid());
        container.costcentreprevid = oidCostCentreBase != null ? BigDecimalMapper.toBigDecimal((String)oidCostCentreBase) : BigDecimalMapper.toBigDecimal((String)"-1");
        container.costunitprevid = oidCostUnit != null ? BigDecimalMapper.toBigDecimal((String)oidCostUnit) : BigDecimalMapper.toBigDecimal((String)"-1");
        container.oidplanvariant = oidPlanVariant;
        container.planvariantprevid = oidPlanVariant != null ? p.getCostPlanVariant().getObjectid() : "-1";
    }

    public ICurrency[] getUsedCurrencies(CostCentreBase kst, CostUnit ktr, CostTypeBase koa, CostingYear costingYear, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant) {
        try {
            String oidCostPlanVariant = null;
            if (costPlanVariant != null) {
                oidCostPlanVariant = costPlanVariant.getObjectid();
            }
            String oidCostCentreBase = null;
            if (kst != null) {
                oidCostCentreBase = kst.getObjectid();
            }
            String oidCostUnit = null;
            if (ktr != null) {
                oidCostUnit = ktr.getObjectid();
            }
            return CostskstktrkbalPersistencyAppl.getUsedCurrencies((String)oidCostCentreBase, (String)oidCostUnit, (String)koa.getObjectid(), (String)costingYear.getObjectid(), (CostingAreaTypeEnum)costingAreaType, (String)oidCostPlanVariant);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public CostsctcccuContainer[] getBalancesContainer(ICostTypeBase[] costType, CostCentreBase costCentre, CostUnit costUnit, CostingYear costingYear, ICurrency currency, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, String oidCostingGroup, boolean isCostCentre) {
        boolean isGroupVariantCostCentre = false;
        boolean isGroupVariantCostUnit = false;
        Conjunction elements = Restrictions.conjunction();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL 1.57 Function 8.0 getBalancesContainer() -> returns CostsctcccuContainer ");
        }
        if (costType.length == 0) {
            return new CostsctcccuContainer[0];
        }
        Object oidcostcentres = "";
        Object oidcostunits = "";
        if (oidCostingGroup != null) {
            int j;
            CostUnit[] costCentresParentDirectItems;
            ArrayList<CostUnit> allcostcentres;
            if (isCostCentre) {
                isGroupVariantCostCentre = true;
                CostCentreBase[] costCentresBase = null;
                allcostcentres = new ArrayList<CostUnit>();
                CostCentreBase.getAllCostCentresUnderGroup((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), allcostcentres);
                costCentresParentDirectItems = CostCentreBase.getCostCentres((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), (boolean)true);
                allcostcentres.addAll(Arrays.asList(costCentresParentDirectItems));
                costCentresBase = new CostCentreBase[allcostcentres.size()];
                allcostcentres.toArray(costCentresBase);
                if (costCentresBase.length > 0) {
                    for (j = 0; j < costCentresBase.length; ++j) {
                        if (j > 0) {
                            oidcostcentres = (String)oidcostcentres + ",";
                        }
                        oidcostcentres = (String)oidcostcentres + costCentresBase[j].getObjectid();
                        this.oidCostCentreList.add(costCentresBase[j].getObjectid());
                    }
                }
                if (costCentresBase.length == 0) {
                    CostsctcccuContainer[] containers = null;
                    return containers;
                }
            } else {
                isGroupVariantCostUnit = true;
                CostUnit[] costUnitBase = null;
                allcostcentres = new ArrayList();
                CostUnit.getAllCostUnitsUnderGroup((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), allcostcentres);
                costCentresParentDirectItems = CostUnit.getCostUnits((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup));
                allcostcentres.addAll(Arrays.asList(costCentresParentDirectItems));
                costUnitBase = new CostUnit[allcostcentres.size()];
                allcostcentres.toArray(costUnitBase);
                if (costUnitBase.length > 0) {
                    for (j = 0; j < costUnitBase.length; ++j) {
                        if (j > 0) {
                            oidcostunits = (String)oidcostunits + ",";
                        }
                        oidcostunits = (String)oidcostunits + costUnitBase[j].getObjectid();
                        this.oidCostUnitList.add(costUnitBase[j].getObjectid());
                    }
                }
                if (costUnitBase.length == 0) {
                    CostsctcccuContainer[] containers = null;
                    return containers;
                }
            }
        }
        String oidCostCentreBase = null;
        if (costCentre != null) {
            oidCostCentreBase = costCentre.getObjectid();
        }
        String oidCostUnit = null;
        if (costUnit != null) {
            oidCostUnit = costUnit.getObjectid();
        }
        if (!StringMapper.isNullString((String)oidcostcentres) && !isGroupVariantCostCentre) {
            elements.add(Restrictions.in((String)"oidcostcentre", (String[])((String)oidcostcentres).split(",")));
        }
        if (!StringMapper.isNullString((String)oidcostunits) && !isGroupVariantCostUnit) {
            elements.add(Restrictions.in((String)"oidcostunit", (String[])((String)oidcostunits).split(",")));
        }
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        if (costCentre != null) {
            elements.add(Restrictions.eq((String)"oidcostcentre", (String)oidCostCentreBase));
        }
        if (costUnit != null) {
            elements.add(Restrictions.eq((String)"oidcostunit", (String)oidCostUnit));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"oidplanvariant", (String)costPlanVariant.getObjectid()));
        }
        try {
            CostsctcccuContainer[] containers = null;
            if (isGroupVariantCostCentre || isGroupVariantCostUnit) {
                int counter = 0;
                ArrayList<CostsctcccuContainer> returnList = new ArrayList<CostsctcccuContainer>();
                Iterator<String> costCentreOrCostUnitIterator = null;
                costCentreOrCostUnitIterator = isGroupVariantCostCentre ? this.oidCostCentreList.iterator() : this.oidCostUnitList.iterator();
                StringBuffer oidBuffer = new StringBuffer();
                while (costCentreOrCostUnitIterator.hasNext()) {
                    String oid = costCentreOrCostUnitIterator.next();
                    oidBuffer.append(oid);
                    if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                        Conjunction elementsWithItems = Restrictions.conjunction();
                        Conjunction elementsOids = Restrictions.conjunction();
                        if (isGroupVariantCostCentre) {
                            elementsOids.add(Restrictions.in((String)"oidcostcentre", (String[])oidBuffer.toString().split(",")));
                        } else {
                            elementsOids.add(Restrictions.in((String)"oidcostunit", (String[])oidBuffer.toString().split(",")));
                        }
                        elementsWithItems.add((Criterion)elements);
                        elementsWithItems.add((Criterion)elementsOids);
                        CostsctcccuContainer[] containerBuffer = dao.getRows(null, (Criterion)elementsWithItems);
                        returnList.addAll(Arrays.asList(containerBuffer));
                        counter = 0;
                        oidBuffer.setLength(0);
                        continue;
                    }
                    if (!costCentreOrCostUnitIterator.hasNext()) continue;
                    oidBuffer.append(',');
                }
                containers = new CostsctcccuContainer[returnList.size()];
                returnList.toArray(containers);
                returnList.clear();
                this.oidCostCentreList.clear();
                this.oidCostUnitList.clear();
                return containers;
            }
            containers = dao.getRows(null, (Criterion)elements);
            return containers;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static CostCentreSumBalance[] getSecondaryCostCentreCostUnitBalancesWithMaxSelectInAreasCCSumBalance(String oidCostCentres, String oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL 1.57 Function 16.0 CostCentreCostUnitSumBalance() -> returns getSecondaryCostCentreCostUnitBalancesWithMaxSelectInAreasCCSumBalance[] ");
            LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, ctboids.length= {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, ctboids.length, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant == null ? null : costPlanVariant.getObjectid()});
        }
        Conjunction elements = Restrictions.conjunction();
        if (oidCostCentres != null && !oidCostCentres.equals("")) {
            elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
        }
        if (costPlanVariant != null) {
            elements.add(Restrictions.in((String)"oidPlanVariant", (String[])costPlanVariant.getObjectid().split(",")));
        }
        if (ctboids != null && ctboids.length > 0) {
            elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        if (costPlanVariant != null || costingAreaType == CostingAreaType.TARGET) {
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
        }
        CostCentreSumBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "oidCostCentre"}, null, (Criterion)elements, new String[]{"oidCostCentre"}, false, CostCentreSumBalance.class, new String[]{"mBalance", "mBalanceFix", "mBalanceVar", "mOidCostCentre"});
            result = (CostCentreSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CostCentreSumBalance[]{};
        }
        return result;
    }

    public static CostUnitSumBalance[] getSecondaryCostCentreCostUnitBalancesWithMaxSelectInAreasCUSumBalance(String oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        Conjunction elements = Restrictions.conjunction();
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
        }
        if (oidCostUnits != null && !oidCostUnits.equals("")) {
            elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
        }
        if (ctboids != null && ctboids.length > 0) {
            elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
        }
        CostUnitSumBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "oidCostUnit"}, null, (Criterion)elements, new String[]{"oidCostUnit"}, false, CostUnitSumBalance.class, new String[]{"mBalance", "mBalanceFix", "mBalanceVar", "mOidCostUnit"});
            result = (CostUnitSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CostUnitSumBalance[]{};
        }
        return result;
    }

    public static CostUnitSumBalance[] getSecondaryCostCentreCostUnitBalancesWithMaxSelectInAreasCUSumBalanceCTString(String oidCostCentres, String oidCostUnits, String oidCostTypeBases, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        Conjunction elements = Restrictions.conjunction();
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
        }
        if (oidCostCentres != null && !oidCostCentres.equals("")) {
            elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostUnits.split(",")));
        }
        if (oidCostUnits != null && !oidCostUnits.equals("")) {
            elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
        }
        if (oidCostTypeBases != null && !oidCostTypeBases.equals("")) {
            elements.add(Restrictions.in((String)"oidCostTypeBase", (String[])oidCostTypeBases.split(",")));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
        }
        CostUnitSumBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "oidCostUnit"}, null, (Criterion)elements, new String[]{"oidCostUnit"}, false, CostUnitSumBalance.class, new String[]{"mBalance", "mBalanceFix", "mBalanceVar", "mOidCostUnit"});
            result = (CostUnitSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CostUnitSumBalance[]{};
        }
        return result;
    }

    public static CostUnitCostCentreCostTypeSumBalance[] getDoubled(String oidCostCentres, String oidCostUnits, String oidCostTypeBases, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        Conjunction elements = Restrictions.conjunction();
        if (oidCostCentres != null && !oidCostCentres.equals("")) {
            elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
        }
        if (oidCostUnits != null && !oidCostUnits.equals("")) {
            elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
        }
        if (oidCostTypeBases != null && !oidCostTypeBases.equals("")) {
            elements.add(Restrictions.in((String)"oidCostTypeBase", (String[])oidCostTypeBases.split(",")));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
        }
        CostUnitCostCentreCostTypeSumBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidCostTypeBase", "oidCostUnit", "oidCostCentre", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostTypeBase", "oidCostCentre", "oidCostUnit"}, false, CostUnitCostCentreCostTypeSumBalance.class, new String[]{"mBalance", "mOidCostType", "mOidCostUnit", "mOidCostCentre", "mBalanceFix", "mBalanceVar"});
            result = (CostUnitCostCentreCostTypeSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CostUnitCostCentreCostTypeSumBalance[]{};
        }
        return result;
    }

    public static SumBalance[] getBalance(String oidCostCentres, String oidCostUnits, List<String> oidCostTypeList, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateUntil, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL 1.57 Function 20.0 getBalance() -> returns SumBalance[] ");
            LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateUntil), costingAreaType, costPlanVariant.getObjectid()});
        }
        int counter = 0;
        SumBalance[] balance = null;
        ArrayList<SumBalance> returnList = new ArrayList<SumBalance>();
        Iterator<String> costTypeIterator = oidCostTypeList.iterator();
        StringBuffer oidBuffer = new StringBuffer();
        while (costTypeIterator.hasNext()) {
            String oid = costTypeIterator.next();
            oidBuffer.append(oid);
            if (++counter % 999 == 0 || !costTypeIterator.hasNext()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("SQL 1.57 Function 20.1 requesting next  {} cost types", (Object)counter);
                    LOGGER.debug(oidBuffer.toString());
                }
                SumBalance[] balanceBuffer = CostingSplitKstKtrKoaBalancePersistencyManager.getBalanceAreas(oidCostCentres, oidCostUnits, oidBuffer.toString(), currency, costingYear, dateFrom, dateUntil, costingAreaType, costPlanVariant, false);
                returnList.addAll(Arrays.asList(balanceBuffer));
                counter = 0;
                oidBuffer.setLength(0);
                continue;
            }
            if (!costTypeIterator.hasNext()) continue;
            oidBuffer.append(',');
        }
        balance = new SumBalance[returnList.size()];
        returnList.toArray(balance);
        return balance;
    }

    public static SumBalance[] getBalanceAreas(String oidCostCentres, String oidCostUnits, String oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver) {
        SumBalance[] result = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL 1.57 Function 21.0 getBalanceAreas() -> returns SumBalance[] ");
            LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, oidCostTypes : {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, oidCostTypes, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant.getObjectid()});
        }
        try {
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.equals("")) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!StringMapper.isNullString((String)oidCostUnits)) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            }
            if (!StringMapper.isNullString((String)oidCostTypes)) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])oidCostTypes.split(",")));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.in((String)"oidPlanVariant", (String[])costPlanVariant.getObjectid().split(",")));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, null, false, SumBalance.class, new String[]{"mBalance", "mBalanceFix", "mBalanceVar"});
            result = (SumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: {}", (Object)ExceptionMapper.toString((Throwable)e));
        }
        if (result == null) {
            result = new SumBalance[]{};
        }
        return result;
    }

    public static SumBalanceKstKtrWithFixAndVar[] getBalanceWithTotalFixAndVarAreas(String oidCostCentres, String oidCostUnits, String oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isCostTypeVerbatim, String verbatimStatement, int countofCostTypes) {
        SumBalanceKstKtrWithFixAndVar[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 22.0 SumBalanceKstKtrWithFixAndVar() -> returns getBalanceWithTotalFixAndVarAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, oidCostTypes : {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, oidCostTypes, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant.getObjectid()});
            }
            CostingCompany costingcompany = CostingCompanyPersistencyManager.getCostingCompany((String)costingYear.getCompany().getObjectid());
            String oidPlanVariant = null;
            if (PersistableEnumUtils.toPersistentValue((PersistableEnum)costingAreaType) == 1) {
                if (costPlanVariant == null) {
                    oidPlanVariant = CostPlanVariant.getCostPlanVariantStandard((CostingSetup)costingcompany.getCostingSetup(), (boolean)true).getObjectid();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("tmp log : oidplanvariant = {} costingcompany = {}", (Object)oidPlanVariant, (Object)costingcompany.getCode());
                    }
                } else {
                    oidPlanVariant = costPlanVariant.getObjectid();
                }
            }
            Conjunction elements = Restrictions.conjunction();
            if (!StringMapper.isNullString((String)oidCostCentres)) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!StringMapper.isNullString((String)oidCostUnits)) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            }
            if (isCostTypeVerbatim) {
                if (countofCostTypes > 0) {
                    elements.add(Restrictions.sqlRestriction((String)verbatimStatement));
                }
            } else if (!StringMapper.isNullString((String)oidCostTypes)) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])oidCostTypes.split(",")));
            }
            if (!StringMapper.isNullString((String)oidPlanVariant)) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidPlanVariant));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, null, false, SumBalanceKstKtrWithFixAndVar.class, new String[]{"mBalance", "mBalanceFix", "mBalanceVar"});
            result = (SumBalanceKstKtrWithFixAndVar[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: {}", (Object)ExceptionMapper.toString((Throwable)e));
        }
        if (result == null) {
            result = new SumBalanceKstKtrWithFixAndVar[]{};
        }
        return result;
    }

    public static CostCentreCostTypeSumBalance[] getBalancesForCostCentreCostTypeFixAndVarAreas(String oidCostCentres, String oidCostUnits, String oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        CostCentreCostTypeSumBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 24.0 CostCentreCostTypeSumBalance() -> returns getBalancesForCostCentreCostTypeFixAndVarAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, oidCostTypes: {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, oidCostTypes, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant.getObjectid()});
            }
            Conjunction elements = Restrictions.conjunction();
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            elements.add(Restrictions.isNotNull((String)"oidCostCentre"));
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidcostcentre", "oidcosttypebase", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, new Order[]{Order.asc((String)"oidCostCentre"), Order.asc((String)"oidcosttypebase")}, (Criterion)elements, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreCostTypeSumBalance.class, new String[]{"mOidCostCentre", "mOidCostType", "mBalance", "mBalanceFix", "mBalanceVar", "mQuantity"});
            result = (CostCentreCostTypeSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: {}", (Object)ExceptionMapper.toString((Throwable)e));
        }
        if (result == null) {
            result = new CostCentreCostTypeSumBalance[]{};
        }
        return result;
    }

    public static CostClosingUnitCentreTypeSumBalance[] getBalancesForClosingUnitPeriod(String oidCostUnitFrom, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        CostClosingUnitCentreTypeSumBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                String currencyCode = currency == null ? null : currency.getCode();
                String costingYearOID = costingYear == null ? null : costingYear.getObjectid();
                LOGGER.debug("SQL 1.62 Function 24.0 getBalancesForClosingUnitPeriod() -> returns CostClosingUnitCentreTypeSumBalance[] ");
                LOGGER.debug("parameters: oidCostUnitFrom = " + oidCostUnitFrom + " currency.getCode() = " + currencyCode + "costingYear.getObjectid()=" + costingYearOID);
                LOGGER.debug("dateFrom: " + DateMapper.toString((Date)dateFrom) + " dateTo: " + DateMapper.toString((Date)dateTo));
                LOGGER.debug("costingAreaType =" + costingAreaType);
                LOGGER.debug("costPlanVariant=" + costPlanVariant);
                LOGGER.debug("Parameters: oidCostUnitFrom :{},  currency:{} , costingYear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostUnitFrom, currencyCode, costingYearOID, DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant == null ? null : costPlanVariant.getObjectid()});
            }
            Conjunction elements = Restrictions.conjunction();
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            elements.add(Restrictions.isNotNull((String)"oidcostunit"));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidCostUnit", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, new Order[]{Order.asc((String)"oidCostUnit")}, (Criterion)elements, new String[]{"oidCostUnit"}, false, CostClosingUnitCentreTypeSumBalance.class, new String[]{"mOidCostUnitFrom", "mBalance", "mBalanceFix", "mBalanceVar", "mQuantity"});
            result = (CostClosingUnitCentreTypeSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: {}", (Object)ExceptionMapper.toString((Throwable)e));
        }
        if (result == null) {
            result = new CostClosingUnitCentreTypeSumBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getCostUnitReportBalancesAreasOld(List<String> oidCostUnits, String oidCostCentres, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, List<String> oidCostTypesList) {
        CostUnitReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 CostCentreReportBalance() -> returns getCostCentreReportBalancesAreas[] ");
                LOGGER.debug("Parameters: oidCostUnits :{} ", oidCostUnits == null ? "oidCostCentres == null" : oidCostUnits);
                LOGGER.debug("Parameters: oidCostCentres :{} ", (Object)(oidCostCentres == null ? "oidCostUnits == null" : oidCostCentres));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : PersistableEnumUtils.toString((PersistableEnum)costingAreaType)));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostUnits.isEmpty()) {
                elements.add(Restrictions.in((String)"oidCostUnit", oidCostUnits));
            } else if (oidCostCentres.equals("")) {
                elements.add(Restrictions.isNotNull((String)"oidCostUnit"));
            }
            if (!oidCostCentres.equals("")) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!oidCostTypesList.isEmpty()) {
                elements.add(Restrictions.in((String)"oidcosttypebase", oidCostTypesList));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostUnit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostUnitReportBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getCostUnitReportBalancesAreas(List<String> oidCostUnits, String oidCostCentres, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, List<String> oidCostTypesList) {
        ArrayList<CostUnitReportBalance> finalResult = new ArrayList<CostUnitReportBalance>();
        try {
            List<List<String>> partitionedOidCostUnits = CostingSplitKstKtrKoaBalancePersistencyManager.partitionList(oidCostUnits, 1000);
            List<List<String>> partitionedOidCostTypes = CostingSplitKstKtrKoaBalancePersistencyManager.partitionList(oidCostTypesList, 1000);
            for (List<String> oidCostUnitPart : partitionedOidCostUnits) {
                for (List<String> oidCostTypePart : partitionedOidCostTypes) {
                    SelectGenerator select;
                    CostUnitReportBalance[] partialResult;
                    Conjunction elements = Restrictions.conjunction();
                    if (!oidCostUnitPart.isEmpty()) {
                        elements.add(Restrictions.in((String)"oidCostUnit", oidCostUnitPart));
                    } else if (oidCostCentres.equals("")) {
                        elements.add(Restrictions.isNotNull((String)"oidCostUnit"));
                    }
                    if (!oidCostCentres.equals("")) {
                        elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
                    }
                    if (!oidCostTypePart.isEmpty()) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", oidCostTypePart));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if ((partialResult = (CostUnitReportBalance[])(select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostUnit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"})).select()) == null) continue;
                    finalResult.addAll(Arrays.asList(partialResult));
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return finalResult.toArray(new CostUnitReportBalance[0]);
    }

    private static <T> List<List<T>> partitionList(List<T> list, int size) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += size) {
            partitions.add(list.subList(i, Math.min(i + size, list.size())));
        }
        return partitions;
    }

    public static CostCentreReportBalance[] getCostCentreReportBalancesAreas(List<String> oidCostCentres, String oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        CostCentreReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 CostCentreReportBalance() -> returns getCostCentreReportBalancesAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{} ", oidCostCentres == null ? "oidCostCentres == null" : oidCostCentres);
                LOGGER.debug("Parameters: oidCostUnits :{} ", (Object)(oidCostUnits == null ? "oidCostUnits == null" : oidCostUnits));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : PersistableEnumUtils.toString((PersistableEnum)costingAreaType)));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.isEmpty()) {
                elements.add(Restrictions.in((String)"oidCostCentre", oidCostCentres));
            } else if (oidCostUnits != null && oidCostUnits.equals("")) {
                elements.add(Restrictions.isNotNull((String)"oidCostCentre"));
            }
            if (oidCostUnits != null && !oidCostUnits.equals("")) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostCentre", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostCentreReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostCentreReportBalance[]{};
        }
        return result;
    }

    public static CostCentreReportBalance[] getCostCentreReportBalancesAreasWithCostTypeListSelection(List<String> oidCostCentres, String oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, List<String> oidCostTypesList) {
        CostCentreReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 CostCentreReportBalance() -> returns getCostCentreReportBalancesAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{} ", oidCostCentres == null ? "oidCostCentres == null" : oidCostCentres);
                LOGGER.debug("Parameters: oidCostUnits :{} ", (Object)(oidCostUnits == null ? "oidCostUnits == null" : oidCostUnits));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : PersistableEnumUtils.toString((PersistableEnum)costingAreaType)));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.isEmpty()) {
                elements.add(Restrictions.in((String)"oidCostCentre", oidCostCentres));
            } else if (oidCostUnits != null && oidCostUnits.equals("")) {
                elements.add(Restrictions.isNotNull((String)"oidCostCentre"));
            }
            if (oidCostUnits != null && !oidCostUnits.equals("")) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            }
            if (!oidCostTypesList.isEmpty()) {
                elements.add(Restrictions.in((String)"oidcosttypebase", oidCostTypesList));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostCentre", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostCentreReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostCentreReportBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getCostUnitReportBalancesAreas(String oidCostCentres, String oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver) {
        CostUnitReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 CostCentreReportBalance() -> returns getCostCentreReportBalancesAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{} ", (Object)(oidCostCentres == null ? "oidCostCentres == null" : oidCostCentres));
                LOGGER.debug("Parameters: oidCostUnits :{} ", (Object)(oidCostUnits == null ? "oidCostUnits == null" : oidCostUnits));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : PersistableEnumUtils.toString((PersistableEnum)costingAreaType)));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.equals("")) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!oidCostUnits.equals("")) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            } else if (oidCostCentres.equals("")) {
                elements.add(Restrictions.isNotNull((String)"oidCostUnit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (!isWithCarryOver) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostUnit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            ExceptionMapper.printException((Throwable)e);
        }
        if (result == null) {
            result = new CostUnitReportBalance[]{};
        }
        return result;
    }

    public static CostCentreReportBalance[] getBalancesArraySelected(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits) {
        return CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelected(oidCostCentres, ctboids, currency, costingYear, dateFrom, dateTo, costingAreaType, costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, false);
    }

    public static CostCentreReportBalance[] getBalancesArraySelected(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits, boolean isSummationAggregation) {
        CostCentreReportBalance[] result = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            if (ctboids != null && ctboids.length > 0) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
            }
            if (oidCostCentres != null && oidCostCentres.length > 0) {
                elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
            } else {
                elements.add(Restrictions.isNotNull((String)"oidcostcentre"));
            }
            if (isAllCostCentres && isAllCostUnits) {
                elements.add(Restrictions.isNull((String)"oidcostunit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (costingYear != null) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            }
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            String quantityExpr = isSummationAggregation ? "Sum(quantitydebit+quantitycredit)" : "Sum(quantitydebit-quantitycredit)";
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", quantityExpr, "oidCostCentre", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostCentreReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostCentreReportBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCU(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany) {
        return CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU(oidCostUnits, ctboids, currency, costingYear, dateFrom, dateTo, costingAreaType, costPlanVariant, oidCostingCompany, false);
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCU(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isSummationAggregation) {
        CostUnitReportBalance[] result = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            if (ctboids != null && ctboids.length > 0) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
            }
            if (oidCostUnits != null && oidCostUnits.length > 0) {
                elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
            } else {
                elements.add(Restrictions.isNotNull((String)"oidcostunit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (costingYear != null) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            }
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            String quantityExpr = isSummationAggregation ? "Sum(quantitydebit+quantitycredit)" : "Sum(quantitydebit-quantitycredit)";
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", quantityExpr, "oidcostunit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidcostunit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostUnitReportBalance[]{};
        }
        return result;
    }

    public static CostCentreReportBalance[] getBalancesArraySelectedCC1000(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits) {
        return CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCC1000(oidCostCentres, ctboids, currency, costingYear, dateFrom, dateTo, costingAreaType, costPlanVariant, oidCostingCompany, isAllCostCentres, isAllCostUnits, false);
    }

    public static CostCentreReportBalance[] getBalancesArraySelectedCC1000(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits, boolean isSummationAggregation) {
        CostCentreReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostCentreList = new LinkedList<String>();
            if (oidCostCentres.length > 0) {
                for (String oidCostCentre : oidCostCentres) {
                    oidCostCentreList.add(oidCostCentre);
                }
            }
            int counter = 0;
            ArrayList<CostCentreReportBalance> returnList = new ArrayList<CostCentreReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostCentreList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    if (isAllCostCentres && isAllCostUnits) {
                        elements.add(Restrictions.isNull((String)"oidcostunit"));
                    }
                    elementsOids.add(Restrictions.in((String)"oidcostcentre", (String[])oidBuffer.toString().split(",")));
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    String quantityExpr = isSummationAggregation ? "Sum(quantitydebit+quantitycredit)" : "Sum(quantitydebit-quantitycredit)";
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", quantityExpr, "oidCostCentre", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
                    CostCentreReportBalance[] containerBuffer = (CostCentreReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostCentreReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostCentreList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostCentreReportBalance[]{};
        }
        return containers;
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCU1000(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany) {
        return CostingSplitKstKtrKoaBalancePersistencyManager.getBalancesArraySelectedCU1000(oidCostUnits, ctboids, currency, costingYear, dateFrom, dateTo, costingAreaType, costPlanVariant, oidCostingCompany, false);
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCU1000(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isSummationAggregation) {
        CostUnitReportBalance[] containers = null;
        try {
            ArrayList<CostUnitReportBalance> returnList = new ArrayList<CostUnitReportBalance>();
            List<String> oidCostUnitList = Arrays.asList(oidCostUnits != null ? oidCostUnits : new String[]{});
            List<String> ctboidList = Arrays.asList(ctboids != null ? ctboids : new String[]{});
            List<List<String>> ctboidBatches = CostingSplitKstKtrKoaBalancePersistencyManager.splitList(ctboidList, 999);
            for (List<String> ctboidBatch : ctboidBatches) {
                List<List<String>> costUnitBatches = CostingSplitKstKtrKoaBalancePersistencyManager.splitList(oidCostUnitList, 999);
                for (List<String> costUnitBatch : costUnitBatches) {
                    Conjunction elements = Restrictions.conjunction();
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (!ctboidBatch.isEmpty()) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboidBatch.toArray(new String[0])));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    elementsOids.add(Restrictions.in((String)"oidcostunit", (String[])costUnitBatch.toArray(new String[0])));
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    String quantityExpr = isSummationAggregation ? "Sum(quantitydebit+quantitycredit)" : "Sum(quantitydebit-quantitycredit)";
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", quantityExpr, "oidcostunit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidcostunit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
                    CostUnitReportBalance[] containerBuffer = (CostUnitReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                }
            }
            containers = new CostUnitReportBalance[returnList.size()];
            returnList.toArray(containers);
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostUnitReportBalance[]{};
        }
        return containers;
    }

    private static <T> List<List<T>> splitList(List<T> list, int chunkSize) {
        ArrayList<List<T>> parts = new ArrayList<List<T>>();
        int size = list.size();
        for (int i = 0; i < size; i += chunkSize) {
            parts.add(new ArrayList<T>(list.subList(i, Math.min(size, i + chunkSize))));
        }
        return parts;
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCU1000ForOpeningBalance(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany) {
        CostUnitReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostUnitList = new LinkedList<String>();
            if (oidCostUnits.length > 0) {
                for (String oidCostUnit : oidCostUnits) {
                    oidCostUnitList.add(oidCostUnit);
                }
            }
            int counter = 0;
            ArrayList<CostUnitReportBalance> returnList = new ArrayList<CostUnitReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostUnitList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
                    elementsOids.add(Restrictions.in((String)"oidcostunit", (String[])oidBuffer.toString().split(",")));
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, null, (Criterion)elementsWithItems, new String[]{"oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "oidCostType", "balanceFix", "balanceVar", "quantity"});
                    CostUnitReportBalance[] containerBuffer = (CostUnitReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostUnitReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostUnitList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostUnitReportBalance[]{};
        }
        return containers;
    }

    public static CostCentreReportBalance[] getBalancesArraySelectedCT1000(String[] oidCostCentresOrCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits, boolean isForCostCentre) {
        CostCentreReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostCentreList = new LinkedList<String>();
            if (oidCostCentresOrCostUnits != null && oidCostCentresOrCostUnits.length > 0) {
                for (String oidCostCentre : oidCostCentresOrCostUnits) {
                    oidCostCentreList.add(oidCostCentre);
                }
            }
            int counter = 0;
            ArrayList<CostCentreReportBalance> returnList = new ArrayList<CostCentreReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostCentreList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    if (isForCostCentre) {
                        elementsOids.add(Restrictions.in((String)"oidcostcentre", (String[])oidBuffer.toString().split(",")));
                        if (isAllCostCentres && isAllCostUnits) {
                            elements.add(Restrictions.isNull((String)"oidcostunit"));
                        }
                    } else {
                        elementsOids.add(Restrictions.in((String)"oidcostunit", (String[])oidBuffer.toString().split(",")));
                        if (isAllCostCentres && isAllCostUnits) {
                            elements.add(Restrictions.isNull((String)"oidcostcentre"));
                        }
                    }
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    String[] groupBy = new String[]{"oidcosttypebase"};
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, groupBy, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostType", "balanceFix", "balanceVar"});
                    CostCentreReportBalance[] containerBuffer = (CostCentreReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostCentreReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostCentreList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostCentreReportBalance[]{};
        }
        return containers;
    }

    public static CostCentreReportBalance[] getBalancesArraySelectedCCCTs1000GroupByCC(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits) {
        CostCentreReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostCentreList = new LinkedList<String>();
            if (oidCostCentres.length > 0) {
                for (String oidCostCentre : oidCostCentres) {
                    oidCostCentreList.add(oidCostCentre);
                }
            }
            int counter = 0;
            ArrayList<CostCentreReportBalance> returnList = new ArrayList<CostCentreReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostCentreList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    elementsOids.add(Restrictions.in((String)"oidcostcentre", (String[])oidBuffer.toString().split(",")));
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    if (isAllCostCentres && isAllCostUnits) {
                        elements.add(Restrictions.isNull((String)"oidcostunit"));
                    }
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostCentre", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidCostCentre"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "balanceFix", "balanceVar"});
                    CostCentreReportBalance[] containerBuffer = (CostCentreReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostCentreReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostCentreList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostCentreReportBalance[]{};
        }
        return containers;
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCUCTs1000GroupByCU(String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany) {
        CostUnitReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostUnitList = new LinkedList<String>();
            if (oidCostUnits.length > 0) {
                for (String oidCostUnit : oidCostUnits) {
                    oidCostUnitList.add(oidCostUnit);
                }
            }
            int counter = 0;
            ArrayList<CostUnitReportBalance> returnList = new ArrayList<CostUnitReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostUnitList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    elementsOids.add(Restrictions.in((String)"oidcostunit", (String[])oidBuffer.toString().split(",")));
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidcostunit", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidcostunit"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "balanceFix", "balanceVar"});
                    CostUnitReportBalance[] containerBuffer = (CostUnitReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostUnitReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostUnitList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostUnitReportBalance[]{};
        }
        return containers;
    }

    public static CostTypeCentreUnitReportBalance[] getBalances(String[] oidCostCentres, String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isOnlyCostCentres, boolean isOnlyCostUnits) {
        CostTypeCentreUnitReportBalance[] result = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            if (ctboids != null && ctboids.length > 0 && !StringMapper.isNullString((String)ctboids[0])) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
            }
            if (oidCostCentres != null && oidCostCentres.length > 0 && !StringMapper.isNullString((String)oidCostCentres[0])) {
                elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
            }
            if (isOnlyCostCentres) {
                elements.add(Restrictions.isNotNull((String)"oidcostcentre"));
            }
            if (isOnlyCostUnits) {
                elements.add(Restrictions.isNotNull((String)"oidcostunit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (costingYear != null) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            }
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            if (costPlanVariant == null) {
                elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            } else {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, null, (Criterion)elements, new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit"}, false, CostTypeCentreUnitReportBalance.class, new String[]{"mOidCostType", "mOidCostCentre", "mOidCostUnit", "mBalance", "mBalanceFix", "mBalanceVar", "mQuantity"});
            result = (CostTypeCentreUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostTypeCentreUnitReportBalance[]{};
        }
        return result;
    }

    public static CostTypeCentreUnitReportBalance[] getBalancesForFormula(String[] oidCostCentres, String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        CostTypeCentreUnitReportBalance[] result = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            if (ctboids != null && ctboids.length > 0 && !StringMapper.isNullString((String)ctboids[0])) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
            }
            if (oidCostCentres != null && oidCostCentres.length > 0 && oidCostUnits != null && oidCostUnits.length > 0) {
                if (StringMapper.isNullString((String)oidCostCentres[0]) && !StringMapper.isNullString((String)oidCostUnits[0])) {
                    elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
                } else if (StringMapper.isNullString((String)oidCostUnits[0]) && !StringMapper.isNullString((String)oidCostCentres[0])) {
                    elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
                } else if (!StringMapper.isNullString((String)oidCostCentres[0]) && !StringMapper.isNullString((String)oidCostUnits[0])) {
                    elements.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres), Restrictions.in((String)"oidcostunit", (String[])oidCostUnits)}));
                }
            } else {
                if (oidCostCentres != null && oidCostCentres.length > 0 && !StringMapper.isNullString((String)oidCostCentres[0])) {
                    elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
                }
                if (oidCostUnits != null && oidCostUnits.length > 0 && !StringMapper.isNullString((String)oidCostUnits[0])) {
                    elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
                }
            }
            if (oidCostUnits == null) {
                elements.add(Restrictions.isNotNull((String)"oidcostcentre"));
            }
            if (oidCostCentres == null) {
                elements.add(Restrictions.isNotNull((String)"oidcostunit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (costingYear != null) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            }
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            if (costPlanVariant == null) {
                elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            } else {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, null, (Criterion)elements, new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit"}, false, CostTypeCentreUnitReportBalance.class, new String[]{"mOidCostType", "mOidCostCentre", "mOidCostUnit", "mBalance", "mBalanceFix", "mBalanceVar", "mQuantity"});
            result = (CostTypeCentreUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (result == null) {
            result = new CostTypeCentreUnitReportBalance[]{};
        }
        return result;
    }

    public static CostTypeCentreUnitReportBalance[] getBalancesForFormulaCT1000(String[] oidCostCentres, String[] oidCostUnits, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant) {
        CostTypeCentreUnitReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostTypeList = new LinkedList<String>();
            if (ctboids.length > 0) {
                for (String ctboid : ctboids) {
                    oidCostTypeList.add(ctboid);
                }
            }
            int counter = 0;
            ArrayList<CostTypeCentreUnitReportBalance> returnList = new ArrayList<CostTypeCentreUnitReportBalance>();
            Iterator costTypeIterator = null;
            costTypeIterator = oidCostTypeList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costTypeIterator.hasNext()) {
                String oid = (String)costTypeIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costTypeIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    if (oidCostCentres != null && oidCostCentres.length > 0 && oidCostUnits != null && oidCostUnits.length > 0) {
                        if (StringMapper.isNullString((String)oidCostCentres[0]) && !StringMapper.isNullString((String)oidCostUnits[0])) {
                            elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
                        } else if (StringMapper.isNullString((String)oidCostUnits[0]) && !StringMapper.isNullString((String)oidCostCentres[0])) {
                            elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
                        } else if (!StringMapper.isNullString((String)oidCostCentres[0]) && !StringMapper.isNullString((String)oidCostUnits[0])) {
                            elements.add((Criterion)Restrictions.disjunction((Criterion[])new Criterion[]{Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres), Restrictions.in((String)"oidcostunit", (String[])oidCostUnits)}));
                        }
                    } else {
                        if (oidCostCentres != null && oidCostCentres.length > 0 && !StringMapper.isNullString((String)oidCostCentres[0])) {
                            elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
                        }
                        if (oidCostUnits != null && oidCostUnits.length > 0 && !StringMapper.isNullString((String)oidCostUnits[0])) {
                            elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
                        }
                    }
                    if (oidCostUnits == null) {
                        elements.add(Restrictions.isNotNull((String)"oidcostcentre"));
                    }
                    if (oidCostCentres == null) {
                        elements.add(Restrictions.isNotNull((String)"oidcostunit"));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    if (costingYear != null) {
                        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                    }
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    if (costPlanVariant == null) {
                        elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    } else {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids.length > 0 && !StringMapper.isNullString((String)ctboids[0])) {
                        elementsOids.add(Restrictions.in((String)"oidcosttypebase", (String[])oidBuffer.toString().split(",")));
                    }
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, null, (Criterion)elementsWithItems, new String[]{"oidcosttypebase", "oidCostCentre", "oidcostunit"}, false, CostTypeCentreUnitReportBalance.class, new String[]{"mOidCostType", "mOidCostCentre", "mOidCostUnit", "mBalance", "mBalanceFix", "mBalanceVar", "mQuantity"});
                    CostTypeCentreUnitReportBalance[] containerBuffer = (CostTypeCentreUnitReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costTypeIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostTypeCentreUnitReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostTypeList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers.length == 0) {
            containers = new CostTypeCentreUnitReportBalance[]{};
        }
        return containers;
    }

    public static CountBalanceKst[] getCountBalanceKst(String oidCostCentres, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant) {
        Conjunction elements = Restrictions.conjunction();
        if (!oidCostCentres.equals("")) {
            elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        if (oidCostPlanVariant.equals("")) {
            elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        }
        if (oidCostPlanVariant.equals("")) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
        }
        CountBalanceKst[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("ANALYSECTCCCUBAL_V", new String[]{"COUNT(OIDCOSTCENTRE)", "OIDCOSTCENTRE"}, null, (Criterion)elements, new String[]{"OIDCOSTCENTRE"}, false, CountBalanceKst.class, new String[]{"mCounter", "mOidCountedObject"});
            result = (CountBalanceKst[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CountBalanceKst[]{};
        }
        return result;
    }

    public static CountBalanceKst[] getCountBalanceKstPlanForHierarchy(String oidCostCentreBase, String oidCostingHierarchy, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant) {
        Criterion filter1;
        CostTypeBase[] costTypeBases;
        Conjunction elements = Restrictions.conjunction();
        Criterion fesCurrency = Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid());
        elements.add(fesCurrency);
        Criterion oidKoreYear = Restrictions.eq((String)"oidCostingYear", (String)costingYear.getObjectid());
        elements.add(oidKoreYear);
        Criterion critDateFrom = Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom));
        elements.add(critDateFrom);
        Criterion critDateUntil = Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo));
        elements.add(critDateUntil);
        Criterion costingarea = Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType));
        elements.add(costingarea);
        if (!StringMapper.isNullString((String)oidCostCentreBase)) {
            Criterion critOidCostCentres = Restrictions.in((String)"oidCostCentre", (String[])oidCostCentreBase.split(","));
            elements.add(critOidCostCentres);
        }
        if (!StringMapper.isNullString((String)oidCostingHierarchy) && (costTypeBases = CostTypeBasePersistencyManager.query(null, (Criterion)(filter1 = Subqueries.in((String)"OBJECTID", (SubSelect)new SubSelect("SELECT DISTINCT OIDCOSTTYPE FROM COSTGROUPTYPE_T, COSTINGGROUP_T", Restrictions.and((Criterion)Restrictions.eqProperty((String)"COSTGROUPTYPE_T.OIDGROUP", (String)"COSTINGGROUP_T.OBJECTID"), (Criterion)Restrictions.eq((String)"COSTINGGROUP_T.OIDROOT", (String)oidCostingHierarchy))))))) != null && costTypeBases.length > 0 && costTypeBases.length < 1000) {
            elements.add(Restrictions.in((String)"oidCostTypeBase", (String[])PersistentObjectUtils.getObjectIdsArray((IPersistentObject[])costTypeBases)));
        }
        if (!StringMapper.isNullString((String)oidCostPlanVariant)) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
        }
        CountBalanceKst[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("ANALYSECTCCCUBAL_V", new String[]{"COUNT(OIDCOSTCENTRE)", "OIDCOSTCENTRE"}, null, (Criterion)elements, new String[]{"OIDCOSTCENTRE"}, false, CountBalanceKst.class, new String[]{"mCounter", "mOidCountedObject"});
            result = (CountBalanceKst[])select.select();
        }
        catch (Exception e) {
            LOGGER.error("Error SelectGenerator getCountBalanceKst (7): ", (Throwable)e);
        }
        if (result == null) {
            result = new CountBalanceKst[]{};
        }
        return result;
    }

    public static CountBalanceKtr[] getCountBalanceKtrPlanForHierarchy(String oidCostCentreBase, String oidCostingHierarchy, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant, boolean isWithCarryOver) {
        Criterion filter1;
        CostTypeBase[] costTypeBases;
        Conjunction elements = Restrictions.conjunction();
        Criterion fesCurrency = Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid());
        elements.add(fesCurrency);
        if (!isWithCarryOver) {
            Criterion oidKoreYear = Restrictions.eq((String)"oidCostingYear", (String)costingYear.getObjectid());
            elements.add(oidKoreYear);
            Criterion critDateFrom = Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom));
            elements.add(critDateFrom);
        }
        Criterion critDateUntil = Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo));
        elements.add(critDateUntil);
        Criterion costingarea = Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType));
        elements.add(costingarea);
        if (!StringMapper.isNullString((String)oidCostCentreBase)) {
            Criterion critOidCostCentres = Restrictions.in((String)"oidCostCentre", (String[])oidCostCentreBase.split(","));
            elements.add(critOidCostCentres);
        }
        if (!StringMapper.isNullString((String)oidCostingHierarchy) && (costTypeBases = CostTypeBasePersistencyManager.query(null, (Criterion)(filter1 = Subqueries.in((String)"OBJECTID", (SubSelect)new SubSelect("SELECT DISTINCT OIDCOSTTYPE FROM COSTGROUPTYPE_T, COSTINGGROUP_T", Restrictions.and((Criterion)Restrictions.eqProperty((String)"COSTGROUPTYPE_T.OIDGROUP", (String)"COSTINGGROUP_T.OBJECTID"), (Criterion)Restrictions.eq((String)"COSTINGGROUP_T.OIDROOT", (String)oidCostingHierarchy))))))) != null && costTypeBases.length > 0 && costTypeBases.length < 1000) {
            elements.add(Restrictions.in((String)"oidCostTypeBase", (String[])PersistentObjectUtils.getObjectIdsArray((IPersistentObject[])costTypeBases)));
        }
        if (!StringMapper.isNullString((String)oidCostPlanVariant)) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
        }
        CountBalanceKtr[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("ANALYSECTCCCUBAL_V", new String[]{"COUNT(OIDCOSTUNIT)", "OIDCOSTUNIT"}, null, (Criterion)elements, new String[]{"OIDCOSTUNIT"}, false, CountBalanceKtr.class, new String[]{"mCounter", "mOidCountedObject"});
            result = (CountBalanceKtr[])select.select();
        }
        catch (Exception e) {
            LOGGER.error("Error SelectGenerator getCountBalanceKtr (7): ", (Throwable)e);
        }
        if (result == null) {
            result = new CountBalanceKtr[]{};
        }
        return result;
    }

    public static CountBalanceKtr[] getCountBalanceKtr(String oidCostUnits, ICurrency currency, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant, boolean isWithCarryOver) {
        Conjunction elements = Restrictions.conjunction();
        if (!oidCostUnits.equals("")) {
            elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        if (!isWithCarryOver) {
            elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        }
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        if (oidCostPlanVariant.equals("")) {
            elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        }
        if (oidCostPlanVariant.equals("")) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
        }
        CountBalanceKtr[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("ANALYSECTCCCUBAL_V", new String[]{"COUNT(OIDCOSTCENTRE)", "OIDCOSTUNIT"}, null, (Criterion)elements, new String[]{"OIDCOSTUNIT"}, false, CountBalanceKtr.class, new String[]{"mCounter", "mOidCountedObject"});
            result = (CountBalanceKtr[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new CountBalanceKtr[]{};
        }
        return result;
    }

    public static ReportBalance[] getCostUnitReportBalances165(String oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, boolean isCostTypeVerbatim, String verbatimStatement, int countofCostUnits, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant, boolean isWithCarryOver) {
        ReportBalance[] result = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            if (isCostTypeVerbatim) {
                if (countofCostUnits > 0) {
                    elements.add(Restrictions.sqlRestriction((String)verbatimStatement));
                }
            } else if (oidCostUnits != null && !oidCostUnits.equals("")) {
                elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits.split(",")));
            }
            elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
            if (!StringMapper.isNullString((String)oidCostPlanVariant)) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (!isWithCarryOver) {
                if (!StringMapper.isNullString((String)oidCostPlanVariant)) {
                    elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                } else {
                    elements.add(Restrictions.eq((String)"oidKoreYear", (String)costingYear.getObjectid()));
                }
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            SelectGenerator select = StringMapper.isNullString((String)oidCostPlanVariant) ? new SelectGenerator("analysecuctbal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidCostUnit", "oidCostType"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidCostType"}, false, CostUnitReportBalance.class, new String[]{"balance", "oidCostUnit", "oidCostType"}) : new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidCostUnit", "oidcosttypebase"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidCostTypeBase"}, false, CostUnitReportBalance.class, new String[]{"balance", "oidCostUnit", "oidCostType"});
            result = (CostUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new ReportBalance[]{};
        }
        return result;
    }

    public static CostUnitSumBalance[] getBalanceAreasCostUnit(String oidCostCentres, String oidCostUnits, String oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver) {
        CostUnitSumBalance[] result = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SQL 1.57 Function 21.0 getBalanceAreas() -> returns SumBalance[] ");
            LOGGER.debug("Parameters: oidCostCentres :{},  oidCostUnits : {}, oidCostTypes : {}, currency:{} , koreyear: {}, dateFrom: {}, dateTo: {}, costingAreaType: {}, costPlanVariant: {} ", new Object[]{oidCostCentres, oidCostUnits, oidCostTypes, currency.getObjectid(), costingYear.getObjectid(), DateMapper.toString((Date)dateFrom), DateMapper.toString((Date)dateTo), costingAreaType, costPlanVariant.getObjectid()});
        }
        try {
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.equals("")) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!StringMapper.isNullString((String)oidCostUnits)) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            }
            if (!StringMapper.isNullString((String)oidCostTypes)) {
                elements.add(Restrictions.in((String)"oidcosttypebase", (String[])oidCostTypes.split(",")));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (!isWithCarryOver) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)"}, null, (Criterion)elements, null, false, SumBalance.class, new String[]{"mBalance"});
            result = (CostUnitSumBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: {}", (Object)ExceptionMapper.toString((Throwable)e));
        }
        if (result == null) {
            result = new CostUnitSumBalance[]{};
        }
        return result;
    }

    public static CostingGroupCostTypeSumBalance[] getCostingGroupCostTypeBalancesCostCentresAreas(String oidCostingGroup, String oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, boolean isCostCentre, CostingAreaTypeEnum costingAreaType, String oidCostPlanVariant) {
        String[] costCentreInFilter = null;
        String[] costUnitInFilter = null;
        CostingGroupCostTypeSumBalance[] result = null;
        CostCentreBase[] costCentresBase = null;
        CostUnit[] costUnitBase = null;
        if (oidCostingGroup != null) {
            CostUnit[] costCentresParentDirectItems;
            ArrayList<CostUnit> allcostcentres;
            if (isCostCentre) {
                allcostcentres = new ArrayList<CostUnit>();
                CostCentreBase.getAllCostCentresUnderGroup((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), allcostcentres);
                costCentresParentDirectItems = CostCentreBase.getCostCentres((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), (boolean)true);
                allcostcentres.addAll(Arrays.asList(costCentresParentDirectItems));
                costCentresBase = new CostCentreBase[allcostcentres.size()];
                allcostcentres.toArray(costCentresBase);
                costCentreInFilter = new String[costCentresBase.length];
                for (int i = 0; i < costCentresBase.length; ++i) {
                    costCentreInFilter[i] = costCentresBase[i].getObjectid();
                }
            } else {
                allcostcentres = new ArrayList();
                CostUnit.getAllCostUnitsUnderGroup((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup), allcostcentres);
                costCentresParentDirectItems = CostUnit.getCostUnits((CostingGroup)CostingGroupPersistencyManager.getCostingGroup((String)oidCostingGroup));
                allcostcentres.addAll(Arrays.asList(costCentresParentDirectItems));
                costUnitBase = new CostUnit[allcostcentres.size()];
                allcostcentres.toArray(costUnitBase);
                costUnitInFilter = new String[costUnitBase.length];
                for (int i = 0; i < costUnitBase.length; ++i) {
                    costUnitInFilter[i] = costUnitBase[i].getObjectid();
                }
            }
        }
        Conjunction elements = Restrictions.conjunction();
        if (isCostCentre && (costCentresBase == null || costCentresBase.length == 0)) {
            result = new CostingGroupCostTypeSumBalance[]{};
            return result;
        }
        if (!(isCostCentre || costUnitBase != null && costUnitBase.length != 0)) {
            result = new CostingGroupCostTypeSumBalance[]{};
            return result;
        }
        if (costCentreInFilter != null && costCentreInFilter.length > 0) {
            elements.add(Restrictions.in((String)"oidCostCentre", costCentreInFilter));
        }
        if (costUnitInFilter != null && costUnitInFilter.length > 0) {
            elements.add(Restrictions.in((String)"oidCostUnit", costUnitInFilter));
        }
        if (!StringMapper.isNullString((String)oidCostTypes)) {
            elements.add(Restrictions.in((String)"oidcosttypebase", (String[])oidCostTypes.split(",")));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        if (!oidCostPlanVariant.equals("")) {
            elements.add(Restrictions.eq((String)"oidPlanVariant", (String)oidCostPlanVariant));
        }
        try {
            SelectGenerator select;
            if (isCostCentre) {
                if (costCentreInFilter.length > 0) {
                    select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidCostTypeBase"}, null, (Criterion)elements, new String[]{"oidCostTypeBase"}, false, CostingGroupCostTypeSumBalance.class, new String[]{"mBalance", "mOidCostType", "mOidCostingGroup"});
                    result = (CostingGroupCostTypeSumBalance[])select.select();
                }
            } else {
                select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "oidCostTypeBase"}, null, (Criterion)elements, new String[]{"oidCostTypeBase"}, false, CostingGroupCostTypeSumBalance.class, new String[]{"mBalance", "mOidCostType", "mOidCostingGroup"});
                result = (CostingGroupCostTypeSumBalance[])select.select();
            }
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
        }
        if (result == null) {
            result = new CostingGroupCostTypeSumBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getCostUnitReportBalancesAreasGT1000(String[] oidCostCentres, String[] oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver, Criterion acCriterionGT1000) {
        ArrayList<CostUnitReportBalance> koaktrHashMapBalancesHelp = new ArrayList<CostUnitReportBalance>();
        CostUnitReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 getCostUnitReportBalancesAreasGT1000() -> returns CostUnitReportBalance[] ");
                LOGGER.debug("Parameters: oidCostCentres L\u00e4nge :{} ", oidCostCentres == null ? "oidCostCentres == null" : Integer.valueOf(oidCostCentres.length));
                LOGGER.debug("Parameters: oidCostUnits L\u00e4nge :{} ", oidCostUnits == null ? "oidCostUnits == null" : Integer.valueOf(oidCostUnits.length));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : costingAreaType.toString()));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            int MAX_SELECT_IN_FROM_CONFIG = 999;
            MAX_SELECT_IN_FROM_CONFIG = CostingConfig.getMaxInForSQLStatement();
            boolean oidCostUnits1000 = false;
            if (oidCostUnits != null && oidCostUnits.length > MAX_SELECT_IN_FROM_CONFIG) {
                if (oidCostUnits.length > MAX_SELECT_IN_FROM_CONFIG) {
                    oidCostUnits1000 = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Statement Info : Number of CostUnits : {} greater {} ", (Object)oidCostUnits.length, (Object)MAX_SELECT_IN_FROM_CONFIG);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Statement Info : Number of CostUnits : {} less {} ", (Object)oidCostUnits.length, (Object)MAX_SELECT_IN_FROM_CONFIG);
                }
            }
            Conjunction elements = Restrictions.conjunction();
            if (oidCostUnits != null && oidCostUnits.length > 0 && oidCostUnits.length <= MAX_SELECT_IN_FROM_CONFIG) {
                elements.add(Restrictions.in((String)"oidcostunit", (String[])oidCostUnits));
            }
            if (acCriterionGT1000 != null && oidCostUnits1000) {
                Criterion subFilter1 = Subqueries.in((String)"OIDCOSTUNIT", (SubSelect)new SubSelect("SELECT OBJECTID FROM COSTUNITBASE_T", acCriterionGT1000));
                elements.add(subFilter1);
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (!isWithCarryOver) {
                if (costingYear != null) {
                    elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                }
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostUnit", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostUnit", "oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostUnitReportBalance[])select.select();
            if (oidCostUnits1000) {
                block2: for (CostUnitReportBalance element : result) {
                    for (String oidCostUnit : oidCostUnits) {
                        if (!element.getOid().equals(oidCostUnit)) continue;
                        koaktrHashMapBalancesHelp.add(element);
                        continue block2;
                    }
                }
                CostUnitReportBalance[] resultFilterIt = new CostUnitReportBalance[koaktrHashMapBalancesHelp.size()];
                koaktrHashMapBalancesHelp.toArray(resultFilterIt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Statement Info : Variant 4 : ctboids1000 < border oidCostUnits1000 > {} ", (Object)MAX_SELECT_IN_FROM_CONFIG);
                    LOGGER.debug("Statement Info : Variant 4 : koaKtrCombinations = {} ", (Object)resultFilterIt.length);
                }
                return resultFilterIt;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Statement Info : Variant 5 : NORMAL STATEMENT < {} : KTRs = ", (Object)MAX_SELECT_IN_FROM_CONFIG, (Object)result.length);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static CostCentreReportBalance[] getCostCentreReportBalancesAreasGT1000(String[] oidCostCentres, String[] oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver) {
        ArrayList<CostCentreReportBalance> koaktrHashMapBalancesHelp = new ArrayList<CostCentreReportBalance>();
        CostCentreReportBalance[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 1.57 Function 11.0 getCostCentreReportBalancesAreasGT1000() -> returns CostCentreReportBalance[] ");
                LOGGER.debug("Parameters: oidCostCentres L\u00e4nge :{} ", oidCostCentres == null ? "oidCostCentres == null" : Integer.valueOf(oidCostCentres.length));
                LOGGER.debug("Parameters: oidCostUnits L\u00e4nge :{} ", oidCostUnits == null ? "oidCostUnits == null" : Integer.valueOf(oidCostUnits.length));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostCentres == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostCentres == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostCentres == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : costingAreaType.toString()));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            int MAX_SELECT_IN_FROM_CONFIG = 999;
            MAX_SELECT_IN_FROM_CONFIG = CostingConfig.getMaxInForSQLStatement();
            boolean oidCostCentres1000 = false;
            if (oidCostCentres != null && oidCostCentres.length > MAX_SELECT_IN_FROM_CONFIG) {
                if (oidCostCentres.length > MAX_SELECT_IN_FROM_CONFIG) {
                    oidCostCentres1000 = true;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Statement Info : Number of CostCentres : {} greater {} ", (Object)oidCostCentres.length, (Object)MAX_SELECT_IN_FROM_CONFIG);
                    }
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Statement Info : Number of CostCentres : {} less {} ", (Object)oidCostCentres.length, (Object)MAX_SELECT_IN_FROM_CONFIG);
                }
            }
            Conjunction elements = Restrictions.conjunction();
            if (oidCostCentres != null && oidCostCentres.length > 0 && oidCostCentres.length <= MAX_SELECT_IN_FROM_CONFIG) {
                elements.add(Restrictions.in((String)"oidcostcentre", (String[])oidCostCentres));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (costingYear != null && !isWithCarryOver) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
            }
            if (!isWithCarryOver) {
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidCostCentre", "oidcosttypebase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elements, new String[]{"oidCostCentre", "oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
            result = (CostCentreReportBalance[])select.select();
            if (oidCostCentres1000) {
                block2: for (CostCentreReportBalance element : result) {
                    for (String oidCostCentre : oidCostCentres) {
                        if (!element.getOid().equals(oidCostCentre)) continue;
                        koaktrHashMapBalancesHelp.add(element);
                        continue block2;
                    }
                }
                CostCentreReportBalance[] resultFilterIt = new CostCentreReportBalance[koaktrHashMapBalancesHelp.size()];
                koaktrHashMapBalancesHelp.toArray(resultFilterIt);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Statement Info : Variant 4 : ctboids1000 < border oidCostCentres1000 > {} ", (Object)MAX_SELECT_IN_FROM_CONFIG);
                    LOGGER.debug("Statement Info : Variant 4 : koaKstCombinations = {} ", (Object)resultFilterIt.length);
                }
                return resultFilterIt;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Statement Info : Variant 5 : NORMAL STATEMENT < {} : KSTs = {} ", (Object)MAX_SELECT_IN_FROM_CONFIG, (Object)result.length);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public CostsctcccuContainer[] getBalancesContainerCCandCU(ICostTypeBase[] costType, CostCentreBase costCentre, CostUnit costUnit, CostingYear costingYear, ICurrency currency, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, CostCentreBase[] costCentresBasesArray, CostUnit[] costUnitsBaseArray) {
        int i;
        if (costType.length == 0) {
            return new CostsctcccuContainer[0];
        }
        String oidCostCentreBase = null;
        if (costCentre != null) {
            oidCostCentreBase = costCentre.getObjectid();
        }
        String oidCostUnit = null;
        if (costUnit != null) {
            oidCostUnit = costUnit.getObjectid();
        }
        String[] costunitOIDs = null;
        String[] costcentreOIDs = null;
        costcentreOIDs = new String[costCentresBasesArray.length];
        for (i = 0; i < costCentresBasesArray.length; ++i) {
            costcentreOIDs[i] = costCentresBasesArray[i].getObjectid();
        }
        costunitOIDs = new String[costUnitsBaseArray.length];
        for (i = 0; i < costUnitsBaseArray.length; ++i) {
            costunitOIDs[i] = costUnitsBaseArray[i].getObjectid();
        }
        Conjunction elements = Restrictions.conjunction();
        if (costcentreOIDs != null && costcentreOIDs.length > 0) {
            elements.add(Restrictions.in((String)"oidcostcentre", (String[])costcentreOIDs));
        }
        if (costunitOIDs != null && costunitOIDs.length > 0) {
            elements.add(Restrictions.in((String)"oidcostunit", (String[])costunitOIDs));
        }
        elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
        if (costCentre != null) {
            elements.add(Restrictions.eq((String)"oidcostcentre", (String)oidCostCentreBase));
        }
        if (costUnit != null) {
            elements.add(Restrictions.eq((String)"oidcostunit", (String)oidCostUnit));
        }
        elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"oidplanvariant", (String)costPlanVariant.getObjectid()));
        }
        try {
            CostsctcccuContainer[] containers = dao.getRows(null, (Criterion)elements);
            return containers;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public static SumBalanceCostType[] getCostTypeSumBalance(String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, boolean isOnlyCostCentres, boolean isOnlyCostUnits) {
        Conjunction elements = Restrictions.conjunction();
        if (isOnlyCostCentres) {
            elements.add(Restrictions.isNotNull((String)"OIDCOSTCENTRE"));
        }
        if (isOnlyCostUnits) {
            elements.add(Restrictions.isNotNull((String)"OIDCOSTUNIT"));
        }
        elements.add(Restrictions.eq((String)"OIDCURRENCY", (String)currency.getObjectid()));
        elements.add(Restrictions.eq((String)"OIDCOSTINGYEAR", (String)costingYear.getObjectid()));
        elements.add(Restrictions.ge((String)"BALANCEDATE", (String)DateMapper.toString((Date)dateFrom)));
        elements.add(Restrictions.le((String)"BALANCEDATE", (String)DateMapper.toString((Date)dateTo)));
        elements.add(Restrictions.eq((String)"COSTINGAREA", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
        if (ctboids == null || ctboids.length <= 0) {
            return new SumBalanceCostType[0];
        }
        elements.add(Restrictions.in((String)"OIDCOSTTYPEBASE", (String[])ctboids));
        if (costPlanVariant != null) {
            elements.add(Restrictions.eq((String)"OIDPLANVARIANT", (String)costPlanVariant.getObjectid()));
        }
        SumBalanceCostType[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("ANALYSECTCCCUBAL_V", new String[]{"SUM(AMOUNTDEBIT-AMOUNTCREDIT)"}, null, (Criterion)elements, null, false, SumBalanceCostType.class, new String[]{"mBalance"});
            result = (SumBalanceCostType[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
        }
        if (result == null) {
            result = new SumBalanceCostType[]{};
        }
        return result;
    }

    public static CostTypeReportBalanceNew[] getReportBalancesAreasForCostTypes(String oidCostCentres, String oidCostUnits, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaTypeEnum costingAreaType, CostPlanVariant costPlanVariant, boolean isWithCarryOver) {
        CostTypeReportBalanceNew[] result = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("SQL 2.05 Function - CostTypeReportBalanceNew() -> returns getReportBalancesAreas[] ");
                LOGGER.debug("Parameters: oidCostCentres :{} ", (Object)(oidCostCentres == null ? "oidCostCentres == null" : oidCostCentres));
                LOGGER.debug("Parameters: oidCostUnits :{} ", (Object)(oidCostUnits == null ? "oidCostUnits == null" : oidCostUnits));
                LOGGER.debug("Parameters: currency :{} ", (Object)(currency == null ? "currency == null" : currency.getObjectid()));
                LOGGER.debug("Parameters: koreyear :{} ", (Object)(costingYear == null ? "oidCostUnits == null" : costingYear.getObjectid()));
                LOGGER.debug("Parameters: Date from :{} ", (Object)(dateFrom == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateFrom)));
                LOGGER.debug("Parameters: Date until :{} ", (Object)(dateTo == null ? "oidCostUnits == null" : DateMapper.toString((Date)dateTo)));
                LOGGER.debug("Parameters: CostingAreaType :{} ", (Object)(costingAreaType == null ? "costingAreaType == null" : costingAreaType.toString()));
                LOGGER.debug("Parameters: OIDPlanVariant :{} ", (Object)(costPlanVariant == null ? "costPlanVariant.getObjectid() == null" : costPlanVariant.getObjectid()));
            }
            Conjunction elements = Restrictions.conjunction();
            if (!oidCostCentres.equals("")) {
                elements.add(Restrictions.in((String)"oidCostCentre", (String[])oidCostCentres.split(",")));
            }
            if (!oidCostUnits.equals("")) {
                elements.add(Restrictions.in((String)"oidCostUnit", (String[])oidCostUnits.split(",")));
            } else if (oidCostCentres.equals("")) {
                elements.add(Restrictions.isNotNull((String)"oidCostUnit"));
            }
            elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
            if (!isWithCarryOver) {
                elements.add(Restrictions.eq((String)"oidcostingyear", (String)costingYear.getObjectid()));
                elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
            }
            elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
            elements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)costingAreaType)));
            if (costPlanVariant != null) {
                elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
            }
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"oidcosttypebase", "Sum(amountdebit-amountcredit)", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)", "Sum(quantitydebit-quantitycredit)"}, null, (Criterion)elements, new String[]{"oidcosttypebase"}, false, CostUnitReportBalance.class, new String[]{"oidCostType", "balance", "balanceFix", "balanceVar", "quantity"});
            result = (CostTypeReportBalanceNew[])select.select();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            ExceptionMapper.printException((Throwable)e);
        }
        if (result == null) {
            result = new CostTypeReportBalanceNew[]{};
        }
        return result;
    }

    public static CostCentreReportBalance[] getCostCentreReportBalancesForAnalysisGroup(List<String> oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingGroup costingGroup) throws BusinessDomainException {
        Conjunction filterElements = Restrictions.conjunction();
        filterElements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        filterElements.add(Restrictions.eq((String)"oidKoreYear", (String)costingYear.getObjectid()));
        filterElements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        filterElements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        filterElements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)CostingAreaTypeEnum.CA_ACTUAL)));
        CostingGroup[] costcentregroups = CostingGroup.getAllCostingGroupsUnderMasterGroup((String)costingGroup.getObjectid());
        if (costcentregroups.length > 1000) {
            throw AnalyseSettingExceptionMapper.makeGroupDrillDownWithMoreThan1000CostCentreGroupsDomainException();
        }
        CostingCompany costingCompany = CostingCompanyPersistencyManager.getCostingCompany((String)costingYear.getCompany().getObjectid());
        Criterion filter1 = AnalyseServantImpl.createFilterAllCostCentresOfGivenCostingGroups((CostingCompany)costingCompany, (CostingGroup[])costcentregroups);
        filterElements.add(filter1);
        filterElements.add(Restrictions.in((String)"oidCostType", oidCostTypes));
        CostCentreReportBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidcosttypebase"}, null, (Criterion)filterElements, new String[]{"oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostType"});
            result = (CostCentreReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.error("Error SelectGenerator getCostCentreReportBalances (1): ", (Throwable)e);
        }
        if (result == null) {
            result = new CostCentreReportBalance[]{};
        }
        return result;
    }

    public static CostUnitReportBalance[] getCostUnitReportBalancesForAnalysisGroup(List<String> oidCostTypes, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingGroup costingGroup) throws BusinessDomainException {
        Conjunction filterElements = Restrictions.conjunction();
        filterElements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
        filterElements.add(Restrictions.eq((String)"oidKoreYear", (String)costingYear.getObjectid()));
        filterElements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
        filterElements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
        filterElements.add(Restrictions.eq((String)"costingarea", (String)CostingAreaTypeMapper.toString((CostingAreaTypeEnum)CostingAreaTypeEnum.CA_ACTUAL)));
        CostingGroup[] costunitgroups = CostingGroup.getAllCostingGroupsUnderMasterGroup((String)costingGroup.getObjectid());
        if (costunitgroups.length > 1000) {
            throw AnalyseSettingExceptionMapper.makeGroupDrillDownWithMoreThan1000CostUnitGroupsDomainException();
        }
        CostingCompany costingCompany = CostingCompanyPersistencyManager.getCostingCompany((String)costingYear.getCompany().getObjectid());
        Criterion filter1 = AnalyseServantImpl.createFilterAllCostUnitsOfGivenCostingGroups((CostingCompany)costingCompany, (CostingGroup[])costunitgroups, (boolean)true, null);
        filterElements.add(filter1);
        filterElements.add(Restrictions.in((String)"oidCostType", oidCostTypes));
        CostUnitReportBalance[] result = null;
        try {
            SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit-quantitycredit)", "oidcosttypebase"}, null, (Criterion)filterElements, new String[]{"oidcosttypebase"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostType"});
            result = (CostUnitReportBalance[])select.select();
        }
        catch (Exception e) {
            LOGGER.error("Error SelectGenerator getCostCentreReportBalances (1): ", (Throwable)e);
        }
        if (result == null) {
            result = new CostUnitReportBalance[]{};
        }
        return result;
    }

    public static CostCentreReportBalance[] getBalancesArraySelectedCTCCs1000GroupByCTCC(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits, boolean isReadCCAndCUValues) {
        CostCentreReportBalance[] containers = null;
        try {
            LinkedList<String> oidCostTypeList = new LinkedList<String>();
            if (ctboids.length > 0) {
                for (String ctboid : ctboids) {
                    oidCostTypeList.add(ctboid);
                }
            }
            int counter = 0;
            ArrayList<CostCentreReportBalance> returnList = new ArrayList<CostCentreReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostTypeList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elements = Restrictions.conjunction();
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])oidBuffer.toString().split(",")));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    if (!isReadCCAndCUValues) {
                        elementsOids.add(Restrictions.isNotNull((String)"oidcostcentre"));
                    }
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    if (!isReadCCAndCUValues && isAllCostCentres && isAllCostUnits) {
                        elements.add(Restrictions.isNull((String)"oidcostunit"));
                    }
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit+quantitycredit)", "oidCostCentre", "oidCostTypeBase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidCostTypeBase", "oidCostCentre"}, false, CostCentreReportBalance.class, new String[]{"balance", "quantity", "oidCostCentre", "oidCostType", "balanceFix", "balanceVar"});
                    CostCentreReportBalance[] containerBuffer = (CostCentreReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostCentreReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostTypeList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers.length == 0) {
            containers = new CostCentreReportBalance[]{};
        }
        return containers;
    }

    public static CostUnitReportBalance[] getBalancesArraySelectedCTCUs1000GroupByCTCU(String[] oidCostCentres, String[] ctboids, ICurrency currency, CostingYear costingYear, Date dateFrom, Date dateTo, CostingAreaType costingAreaType, CostPlanVariant costPlanVariant, String oidCostingCompany, boolean isAllCostCentres, boolean isAllCostUnits, boolean isReadCCAndCUValues) {
        CostUnitReportBalance[] containers = null;
        try {
            Conjunction elements = Restrictions.conjunction();
            LinkedList<String> oidCostTypeList = new LinkedList<String>();
            if (ctboids.length > 0) {
                for (String ctboid : ctboids) {
                    oidCostTypeList.add(ctboid);
                }
            }
            int counter = 0;
            ArrayList<CostUnitReportBalance> returnList = new ArrayList<CostUnitReportBalance>();
            Iterator costCentreOrCostUnitIterator = null;
            costCentreOrCostUnitIterator = oidCostTypeList.iterator();
            StringBuffer oidBuffer = new StringBuffer();
            while (costCentreOrCostUnitIterator.hasNext()) {
                String oid = (String)costCentreOrCostUnitIterator.next();
                oidBuffer.append(oid);
                if (++counter % 999 == 0 || !costCentreOrCostUnitIterator.hasNext()) {
                    Conjunction elementsWithItems = Restrictions.conjunction();
                    Conjunction elementsOids = Restrictions.conjunction();
                    elements.add(Restrictions.eq((String)"oidCompany", (String)oidCostingCompany));
                    if (costPlanVariant != null) {
                        elements.add(Restrictions.eq((String)"oidPlanVariant", (String)costPlanVariant.getObjectid()));
                    }
                    if (ctboids != null && ctboids.length > 0) {
                        elements.add(Restrictions.in((String)"oidcosttypebase", (String[])ctboids));
                    }
                    elements.add(Restrictions.eq((String)"oidCurrency", (String)currency.getObjectid()));
                    elements.add(Restrictions.ge((String)"balanceDate", (String)DateMapper.toString((Date)dateFrom)));
                    elements.add(Restrictions.le((String)"balanceDate", (String)DateMapper.toString((Date)dateTo)));
                    elements.add(Restrictions.eq((String)"costingarea", (String)PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)costingAreaType)));
                    if (!isReadCCAndCUValues) {
                        elementsOids.add(Restrictions.isNotNull((String)"oidcostunit"));
                    }
                    elementsWithItems.add((Criterion)elements);
                    elementsWithItems.add((Criterion)elementsOids);
                    SelectGenerator select = new SelectGenerator("analysectcccubal_V", new String[]{"Sum(amountdebit-amountcredit)", "Sum(quantitydebit+quantitycredit)", "oidCostUnit", "oidCostTypeBase", "Sum(amountdebitfix-amountcreditfix)", "Sum(amountdebitvar-amountcreditvar)"}, null, (Criterion)elementsWithItems, new String[]{"oidCostTypeBase", "oidCostUnit"}, false, CostUnitReportBalance.class, new String[]{"balance", "quantity", "oidCostUnit", "oidCostType", "balanceFix", "balanceVar"});
                    CostUnitReportBalance[] containerBuffer = (CostUnitReportBalance[])select.select();
                    returnList.addAll(Arrays.asList(containerBuffer));
                    counter = 0;
                    oidBuffer.setLength(0);
                    continue;
                }
                if (!costCentreOrCostUnitIterator.hasNext()) continue;
                oidBuffer.append(',');
            }
            containers = new CostUnitReportBalance[returnList.size()];
            returnList.toArray(containers);
            returnList.clear();
            oidCostTypeList.clear();
        }
        catch (Exception e) {
            LOGGER.debug("Error: ", (Throwable)e);
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (containers == null || containers.length == 0) {
            containers = new CostUnitReportBalance[]{};
        }
        return containers;
    }
}

