/*
 * Decompiled with CFR 0.152.
 */
package com.varial.base.vat.bzstrestclient;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.bzstclient.BZStQualifiedRequestBuilder;
import com.varial.base.vat.bzstrestclient.VatQualifiedRestRequest;
import com.varial.base.vat.bzstrestclient.VatRestResponse;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class BZStRestClient {
    public static final String BZST_QUALIFIED_URL = "https://api.evatr.vies.bzst.de/app/v1/abfrage/";
    private final RestTemplate restTemplate;
    private final ObjectMapper objectMapper;

    public BZStRestClient() {
        this(new RestTemplate(), BZStRestClient.defaultObjectMapper());
    }

    public BZStRestClient(RestTemplate restTemplate, ObjectMapper objectMapper) {
        this.restTemplate = restTemplate;
        this.objectMapper = objectMapper;
    }

    private static ObjectMapper defaultObjectMapper() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new JavaTimeModule());
        om.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return om;
    }

    public VatRestResponse checkQualifiedOld(VatQualifiedRestRequest request) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String requestJson = this.objectMapper.writeValueAsString((Object)request);
        HttpEntity httpEntity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(BZST_QUALIFIED_URL, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            return (VatRestResponse)this.objectMapper.readValue((String)response.getBody(), VatRestResponse.class);
        }
        catch (HttpClientErrorException.BadRequest e) {
            String responseBody = e.getResponseBodyAsString();
            try {
                VatRestResponse errorResponse = (VatRestResponse)this.objectMapper.readValue(responseBody, VatRestResponse.class);
                if (errorResponse != null && errorResponse.status != null) {
                    return errorResponse;
                }
            }
            catch (Exception parsingException) {
                throw new RuntimeException("Could not parse HTTP 400 response: " + responseBody, parsingException);
            }
            throw new RuntimeException("Unknown HTTP 400 error: " + responseBody);
        }
        catch (HttpStatusCodeException e) {
            String body = e.getResponseBodyAsString();
            String evatr = this.extractEvatrStatus(body != null ? body : e.getMessage());
            throw new RuntimeException("HTTP error " + e.getStatusCode() + (String)(evatr != null ? " (" + evatr + ")" : "") + " \u2013 " + (body != null ? body : e.getMessage()), e);
        }
    }

    public VatRestResponse checkQualified(VatQualifiedRestRequest request) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String requestJson = this.objectMapper.writeValueAsString((Object)request);
        HttpEntity httpEntity = new HttpEntity((Object)requestJson, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(BZST_QUALIFIED_URL, HttpMethod.POST, httpEntity, String.class, new Object[0]);
            return (VatRestResponse)this.objectMapper.readValue((String)response.getBody(), VatRestResponse.class);
        }
        catch (HttpClientErrorException.BadRequest e) {
            String responseBody = e.getResponseBodyAsString();
            try {
                VatRestResponse errorResponse = (VatRestResponse)this.objectMapper.readValue(responseBody, VatRestResponse.class);
                if (errorResponse != null && errorResponse.status != null) {
                    return errorResponse;
                }
            }
            catch (Exception parsingException) {
                throw new RuntimeException("Could not parse HTTP 400 response: " + responseBody, parsingException);
            }
            throw new RuntimeException("Unknown HTTP 400 error: " + responseBody);
        }
        catch (HttpStatusCodeException e) {
            String body = e.getResponseBodyAsString();
            if (body != null && !body.isEmpty()) {
                try {
                    VatRestResponse err = (VatRestResponse)this.objectMapper.readValue(body, VatRestResponse.class);
                    if (err != null && err.status != null) {
                        return err;
                    }
                }
                catch (Exception err) {
                    // empty catch block
                }
            }
            String evatr = this.extractEvatrStatus(body != null ? body : e.getMessage());
            throw new RuntimeException("HTTP error " + e.getStatusCode() + (String)(evatr != null ? " (" + evatr + ")" : "") + " - " + (body != null ? body : e.getMessage()), e);
        }
    }

    private String extractEvatrStatus(String body) {
        if (body == null || body.isBlank()) {
            return null;
        }
        try {
            VatRestResponse tmp = (VatRestResponse)this.objectMapper.readValue(body, VatRestResponse.class);
            if (tmp != null && tmp.status != null && !tmp.status.isBlank()) {
                return tmp.status;
            }
        }
        catch (Exception tmp) {
            // empty catch block
        }
        try {
            String s;
            JsonNode node = this.objectMapper.readTree(body);
            if (node != null && node.has("status") && node.get("status").isTextual() && (s = node.get("status").asText()) != null && !s.isBlank()) {
                return s;
            }
        }
        catch (Exception node) {
            // empty catch block
        }
        try {
            Matcher m = Pattern.compile("\"status\"\\s*:\\s*\"([^\"]+)\"").matcher(body);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public VatRestResponse checkQualified(VATNumber requesterVAT, VATQualifiedCheckRequest request) throws IOException {
        VatQualifiedRestRequest restReq = new VatQualifiedRestRequest(requesterVAT.getVatNumber(), request.getLookupVAT().getVatNumber(), BZStRestClient.toBzstString(request.getTraderName()), BZStRestClient.toBzstString(request.getTraderStreet()), BZStRestClient.toBzstString(request.getTraderPostcode()), BZStRestClient.toBzstString(request.getTraderCity()));
        return this.checkQualified(restReq);
    }

    public VatRestResponse checkVat(VatQualifiedRestRequest request) throws IOException {
        return this.checkQualified(request);
    }

    public VatRestResponse checkVat(VATNumber requesterVAT, VATQualifiedCheckRequest request) throws IOException {
        return this.checkQualified(requesterVAT, request);
    }

    public VatRestResponse checkVat(BZStQualifiedRequestBuilder builder) throws IOException {
        VATNumber requesterVAT = BZStRestClient.getField(builder, "requesterVAT", VATNumber.class);
        VATNumber lookupVAT = BZStRestClient.getField(builder, "lookupVAT", VATNumber.class);
        String traderName = BZStRestClient.toBzstString(BZStRestClient.getField(builder, "traderName", String.class));
        String traderCity = BZStRestClient.toBzstString(BZStRestClient.getField(builder, "traderCity", String.class));
        String traderPostcode = BZStRestClient.toBzstString(BZStRestClient.getOptionalStringField(builder, "traderPostcode"));
        String traderStreet = BZStRestClient.toBzstString(BZStRestClient.getOptionalStringField(builder, "traderStreet"));
        Boolean confirmationLetter = BZStRestClient.getField(builder, "confirmationLetter", Boolean.class);
        VatQualifiedRestRequest restReq = new VatQualifiedRestRequest(requesterVAT != null ? requesterVAT.getVatNumber() : "", lookupVAT != null ? lookupVAT.getVatNumber() : "", traderName, traderStreet, traderPostcode, traderCity);
        return this.checkQualified(restReq);
    }

    private static <T> T getField(Object target, String fieldName, Class<T> type) {
        try {
            Field f = target.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            Object val = f.get(target);
            if (val == null) {
                return null;
            }
            if (type.isInstance(val)) {
                return (T)val;
            }
            if (type == String.class) {
                return (T)String.valueOf(val);
            }
            throw new IllegalArgumentException("Field '" + fieldName + "' is not of type " + type.getName());
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Field '" + fieldName + "' not found on " + target.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access field '" + fieldName + "' on " + target.getClass().getName(), e);
        }
    }

    private static String getOptionalStringField(Object target, String fieldName) {
        try {
            Field f = target.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            Object val = f.get(target);
            if (val == null) {
                return "";
            }
            if (val instanceof Optional) {
                return ((Optional)val).map(Object::toString).orElse("");
            }
            return String.valueOf(val);
        }
        catch (NoSuchFieldException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Cannot access optional field '" + fieldName + "'", e);
        }
    }

    private static String toBzstString(String s) {
        return s == null ? "" : s.trim();
    }
}

