/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.depreciation;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialPeriod;
import com.varial.accounting.domain.financialyear.FinancialPeriodPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.financialyear.FinancialYearPersistencyManager;
import com.varial.assetaccounting.depreciation.DepreciationFunctionEnum;
import com.varial.assetaccounting.depreciation.DepreciationStruct;
import com.varial.assetaccounting.domain.accounting.Accounting;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculation;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculationHelper;
import com.varial.assetaccounting.domain.depreciation.DepreciationExceptionMapper;
import com.varial.assetaccounting.domain.depreciation.DepreciationPostingAndProtocol;
import com.varial.assetaccounting.domain.depreciation.DepreciationPostingAndProtocolHelper;
import com.varial.assetaccounting.domain.depreciation.DepreciationProtocolMessages;
import com.varial.assetaccounting.domain.depreciation.report.CollectivePostingReportDataSource;
import com.varial.assetaccounting.domain.depreciation.report.DepreciationProtocolReportDataSource;
import com.varial.assetaccounting.domain.depreciation.report.DepreciationReportDataSource;
import com.varial.assetaccounting.domain.depreciation.report.ItemizedListingPostingsReportDataSource;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationAreaPersistencyManager;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriod;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriodPersistencyManager;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYearPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetPersistencyManager;
import com.varial.assetaccounting.domain.fixedassetreport.DepreciationReportPrint;
import com.varial.assetaccounting.domain.specialreserve.SpecialReserve;
import com.varial.assetaccounting.domain.specialreserve.SpecialReservePostingAndProtocol;
import com.varial.assetaccounting.persistency.fixedasset.FixedassetContainer;
import com.varial.assetaccounting.persistency.fixedasset.IFixedassetDao;
import com.varial.assetaccounting.servantimpl.depreciation.DepreciationMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.PersistencySession;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.service.ApplicationServiceAdapter;
import com.varial.base.service.TransactionalServiceAdapter;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costingyear.CostingPeriod;
import com.varial.costing.base.domain.costingyear.CostingPeriodPersistencyManager;
import com.varial.costing.base.domain.costingyear.CostingYear;
import com.varial.costing.base.domain.costingyear.CostingYearPersistencyManager;
import com.varial.framework.basictypes.ReportMediaType;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.printdocument.ReportType;
import com.varial.framework.domain.reports.JasperReportCompiler;
import com.varial.framework.domain.reports.JasperReportManager;
import com.varial.framework.domain.reports.PrintJob;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.domain.resource.IResourceTranslationPersistencyManager;
import com.varial.serverbase.domain.resource.ResourceTranslation;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;

public class DepreciationPrint {
    protected final AuthorizationToken mToken;
    protected final String mRight;
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)DepreciationReportPrint.class.getName());
    private static final Configuration CONFIGURATION = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static final IFixedassetDao dao = (IFixedassetDao)UtilitiesManager.getBean((String)"fixedassetDao", IFixedassetDao.class);
    private static final IResourceTranslationPersistencyManager resourceTranslationPersistencyManager = (IResourceTranslationPersistencyManager)UtilitiesManager.getBean((String)"resourceTranslationPersistencyManager", IResourceTranslationPersistencyManager.class);
    private AccountingCompany mCompany;
    private FAFinancialYear mFinYear;
    private FAFinancialPeriod mFinPeriod;
    private FinancialYear mFinYearPosting;
    private FinancialPeriod mFinPeriodPosting;
    private CostingYear mCostingYearPosting;
    private CostingPeriod mCostingPeriodPosting;
    private AssetaccountingSetup mAASetup;
    private DepreciationArea mDeprArea;
    private final Language mGlobalLanguage;
    private Criterion mWhere = null;
    private Order[] mOrder = null;
    private DepreciationFunctionEnum mFunction;
    private Date mDepreciationUntilDate;
    private Date mCancellationUntilDate;
    private Date mDocumentDate;
    private Date mTransactionDatePosting;
    private Date mTransactionDatePostingCA;
    private boolean mPrintDepreciationProtocol;
    private boolean mPostAccounting;
    private boolean mPostCosting;
    private boolean mPrintPostingProtocol;
    private final DepreciationStruct mPresetStruct;
    private final List<DepreciationProtocolMessages> mProtocolMessages = new ArrayList<DepreciationProtocolMessages>();
    private final String mPrintTime;
    private int mPostWithAnalysisCode;
    private int mPostWithAnalysisCodeCA;
    private String mIndivPostingNumber;
    private PersistencySession mContext;
    protected ReportMediaType mReportMediaType;
    protected boolean mIsAdditionalOutputArchive;
    protected ReportType mReportTypeForOutputManager;
    protected PrintJob.PrintJobType mPrintJobType;
    protected List<URL> mURLs;
    private final boolean mMergePrintoutToOneFile = false;
    protected boolean mExceptionIsThrown = false;
    private static final int END_PROTOCOL = 0;
    private static final int NO_DEPRECIATIONPROTOCOL = 1;
    private static final int NO_POSTINGPROTOCOL = 2;
    private static final int COUNT_FIXEDASSETS = 3;
    private static final int COUNT_PROCESSED_FIXEDASSETS = 4;
    private static final int COUNT_TRANSACTIONS_POSTED = 5;
    private static final int DEPRECIATIONISCOMPUTED = 6;
    private static final int POSTINGSAREDETERMIND = 7;
    private static final int CANCELATIONISCOMPUTED = 8;
    private static final int FIXEDASSET = 9;
    private static final int FIXEDASSETNOCALCULATION = 10;
    private static TranslateableResourceList mAADepreciationList = TranslateableResourceList.createTranslateableResourceList((String)"AADepreciationPrintList", (String[])new String[]{"END PROTOCOL", "Es wurde kein Abschreibungsprotokoll ausgegeben", "Es wurde kein Buchungsprotokoll ausgegeben", "Anzahl gelesene Anlageg\u00fcter", "Anzahl abgeschriebene/stornierte Anlageg\u00fcter", "Anzahl gebuchte Bewegungen", "Abschreibung wird berechnet f\u00fcr: ", "Buchungen werden ermittelt f\u00fcr: ", "Stornierung wird berechnet f\u00fcr: ", "Fixed Asset: ", "Das Anlagegut wird in diesem Lauf nicht bearbeitet !"});

    public DepreciationPrint(AuthorizationToken token, String right, DepreciationStruct preset, String oidGlobalLanguage, ReportMediaType format, boolean isAdditionalOutputArchive, ReportType reportTypeForOutputManager, String printTime, PrintJob.PrintJobType printJobType) throws BusinessDomainException {
        this.mToken = token;
        this.mRight = right;
        this.mPresetStruct = preset;
        this.mPrintTime = printTime;
        this.mReportMediaType = format;
        this.mIsAdditionalOutputArchive = isAdditionalOutputArchive;
        this.mGlobalLanguage = LanguageManager.getInstance().getLanguage(oidGlobalLanguage);
        this.mReportTypeForOutputManager = reportTypeForOutputManager;
        this.mPrintJobType = printJobType;
        this.mURLs = new ArrayList<URL>();
        this.mWhere = DepreciationMapper.fillQueryFilter((DepreciationStruct)this.mPresetStruct);
        this.mOrder = DepreciationMapper.fillQuerySort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        TransactionalServiceAdapter txAdapter = new TransactionalServiceAdapter();
        ApplicationServiceAdapter applAdapter = new ApplicationServiceAdapter();
        TransactionStatus txStatus = txAdapter.getUpdateTransaction();
        applAdapter.beginUpdateService();
        this.mContext = applAdapter.getContext();
        ArrayList<String> reportsList = new ArrayList<String>();
        try {
            FixedAssetArea faArea;
            FixedassetContainer faContainer;
            this.mFunction = this.mPresetStruct.function;
            this.mCompany = AccountingCompanyPersistencyManager.getAccountingCompany((String)this.mPresetStruct.oidCompany);
            if (this.mPresetStruct.faFinancialYear.discriminator()) {
                this.mFinYear = FAFinancialYearPersistencyManager.getFAFinancialYear((String)this.mPresetStruct.faFinancialYear.yearShort().oidTs.objectid);
            }
            if (this.mPresetStruct.faPeriod.discriminator()) {
                this.mFinPeriod = FAFinancialPeriodPersistencyManager.getFAFinancialPeriod((String)this.mPresetStruct.faPeriod.period().oidTs.objectid);
            }
            if (this.mPresetStruct.acFinancialYear.discriminator()) {
                this.mFinYearPosting = FinancialYearPersistencyManager.getFinancialYearById((String)this.mPresetStruct.acFinancialYear.fYear().oidTs.objectid, (AccountingCompany)this.mCompany);
                if (this.mFinYearPosting.getCloseMark()) {
                    throw DepreciationExceptionMapper.makeAccountingFinYearClosedException((String)"DepreciationPrint");
                }
            }
            if (this.mPresetStruct.acPeriod.discriminator()) {
                this.mFinPeriodPosting = FinancialPeriodPersistencyManager.getFinancialPeriod((String)this.mPresetStruct.acPeriod.fPeriod().oidTs.objectid);
                if (this.mFinPeriodPosting.getIsPeriodClosed()) {
                    throw DepreciationExceptionMapper.makeAccountingFinPeriodClosedException((String)"DepreciationPrint");
                }
                if (this.mFinPeriodPosting.getIsNominalLedgerClosed()) {
                    throw DepreciationExceptionMapper.makeAccountingNomLedgerClosedException((String)"DepreciationPrint");
                }
            }
            if (!StringMapper.isNullString((String)this.mPresetStruct.acTransactionDate)) {
                this.mTransactionDatePosting = DateMapper.toDate((String)this.mPresetStruct.acTransactionDate);
            }
            this.mAASetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mCompany);
            this.mDeprArea = DepreciationAreaPersistencyManager.getDepreciationArea((String)this.mPresetStruct.area.oidTs.objectid);
            if (this.mFunction.value() == 2 || this.mFunction.value() == 3) {
                if (this.mDeprArea.getTransferDataFin() && this.mDeprArea.getWithCostCentres()) {
                    if (this.mFinYearPosting != null) {
                        this.mCostingYearPosting = CostingYearPersistencyManager.getCostingYearByCode((Company)this.mCompany, (String)this.mFinYearPosting.getCode());
                    }
                    if (this.mTransactionDatePosting != null) {
                        this.mTransactionDatePostingCA = this.mTransactionDatePosting;
                    }
                    if (this.mTransactionDatePostingCA != null && this.mCostingYearPosting != null && DateHelper.after((Date)this.mTransactionDatePostingCA, (Date)this.mCostingYearPosting.getValidUntil())) {
                        this.mTransactionDatePostingCA = this.mCostingYearPosting.getValidUntil();
                    }
                } else {
                    if (this.mPresetStruct.caFinancialYear.discriminator()) {
                        this.mCostingYearPosting = CostingYearPersistencyManager.getCostingYearByOid((String)this.mPresetStruct.caFinancialYear.cYear().oidTs.objectid, (Company)this.mCompany);
                    }
                    if (this.mPresetStruct.caPeriod.discriminator()) {
                        this.mCostingPeriodPosting = CostingPeriodPersistencyManager.getCostingPeriod((String)this.mPresetStruct.caPeriod.fPeriod().oidTs.objectid);
                    }
                    if (!StringMapper.isNullString((String)this.mPresetStruct.caTransactionDate)) {
                        this.mTransactionDatePostingCA = DateMapper.toDate((String)this.mPresetStruct.caTransactionDate);
                    }
                }
            }
            if (this.mPresetStruct.faPeriod.discriminator()) {
                this.mDepreciationUntilDate = DateMapper.toDate((String)this.mPresetStruct.faPeriod.period().period.validUntil);
                this.mCancellationUntilDate = DateMapper.toDate((String)this.mPresetStruct.faPeriod.period().period.validFrom);
            }
            if (this.mDeprArea.getDepreciationFrequencies().value() == 1 && this.mFunction.value() != 2 && this.mFunction.value() != 3) {
                this.mCancellationUntilDate = this.mFinYear.getValidFrom();
            }
            this.mDocumentDate = DateMapper.toDate((String)this.mPresetStruct.documentDate);
            this.mPrintDepreciationProtocol = this.mPresetStruct.calcProtocoll;
            this.mPostAccounting = this.mPresetStruct.postAC;
            this.mPostCosting = this.mPresetStruct.postCA;
            this.mPrintPostingProtocol = this.mPresetStruct.postProtocoll;
            this.mProtocolMessages.add(new DepreciationProtocolMessages(8, ""));
            FAFinancialYear[] finYears = FAFinancialYear.getFAFinancialYears((AccountingCompany)this.mCompany);
            FAFinancialYear finYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mDepreciationUntilDate);
            LOGGER.debug("execute(...)");
            this.mPostWithAnalysisCode = 0;
            this.mPostWithAnalysisCodeCA = 0;
            if (this.mDeprArea.getAnalysisCodeTransaction()) {
                this.mPostWithAnalysisCode = this.mDeprArea.getPostWithAnalysisCode(false);
                if (this.mDeprArea.getWithCostCentres() || this.mDeprArea.getWithCostUnits()) {
                    this.mPostWithAnalysisCodeCA = this.mPostWithAnalysisCode;
                    LOGGER.debug("***Buchen FIBU und KORE mit Analysecode = " + this.mPostWithAnalysisCode + " ***");
                } else {
                    LOGGER.debug("***Buchen FIBU mit Analysecode = " + this.mPostWithAnalysisCode + " ***");
                }
            }
            if (this.mDeprArea.getAnalysisCodeTransactionCA()) {
                this.mPostWithAnalysisCodeCA = this.mDeprArea.getPostWithAnalysisCode(true);
                LOGGER.debug("***Buchen KORE mit Analysecode = " + this.mPostWithAnalysisCodeCA + " ***");
            }
            this.mIndivPostingNumber = this.mPresetStruct.postNumber;
            int counter = 0;
            int countTotal = (int)dao.getRowCount(this.mWhere);
            PersistencyDataSet dataset = dao.getDataSet(this.mOrder, this.mWhere);
            FixedAssetData fixedAsset = null;
            this.mProtocolMessages.add(new DepreciationProtocolMessages(8, mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 3) + ": " + countTotal));
            ResourceTranslation[] resourcetranslations = resourceTranslationPersistencyManager.getErrorMessageTranslationsForParent("fixedasset", this.mGlobalLanguage.getLocale().getCode());
            DepreciationCalculation.processedCounter = 0;
            if (this.mFunction.value() == 0 || this.mFunction.value() == 1) {
                ArrayList<DepreciationPostingAndProtocolHelper> allDepreciations = new ArrayList<DepreciationPostingAndProtocolHelper>();
                counter = 0;
                int afaCounter = 0;
                while (dataset.hasNext()) {
                    block75: {
                        ++counter;
                        ++afaCounter;
                        faContainer = (FixedassetContainer)dataset.getNext();
                        fixedAsset = new FixedAssetData(true);
                        FixedAssetPersistencyManager.fillFixedAssetData((FixedAssetData)fixedAsset, (FixedassetContainer)faContainer);
                        faArea = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, this.mDeprArea);
                        String[] result = new String[1];
                        try {
                            faArea.check(this.mGlobalLanguage, this.mDepreciationUntilDate);
                            if (this.mFunction.value() != 0) break block75;
                            faArea.checkDeprMethodIsNotNull(this.mGlobalLanguage);
                            faArea.checkForCorrectDeprMethod(this.mGlobalLanguage);
                        }
                        catch (BusinessDomainException de) {
                            String errorMessage = de.getMessage();
                            if (!this.mGlobalLanguage.getIsoLocale().equals("de-DE") && resourcetranslations != null && resourcetranslations.length > 0) {
                                for (ResourceTranslation resourceTranslation : resourcetranslations) {
                                    if (!Integer.toString(de.getErrorNumber()).equals(resourceTranslation.getComponent())) continue;
                                    errorMessage = resourceTranslation.getCaption();
                                    break;
                                }
                            }
                            StringBuffer message = new StringBuffer(mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 9));
                            message.append(' ');
                            message.append(fixedAsset.getCode());
                            message.append(" --> ");
                            message.append(errorMessage);
                            message.append(' ');
                            message.append(mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 10));
                            this.mProtocolMessages.add(new DepreciationProtocolMessages(0, message.toString()));
                            continue;
                        }
                    }
                    List<DepreciationCalculationHelper> allDepreciationsAfterDepr = null;
                    switch (this.mFunction.value()) {
                        case 0: {
                            int usefullLifeInDays;
                            DepreciationCalculation deprCalc = new DepreciationCalculation(this.mCompany, fixedAsset, this.mDeprArea, faArea, this.mGlobalLanguage, this.mFunction, this.mDepreciationUntilDate, this.mCancellationUntilDate, this.mDocumentDate, false, false, false, null, this.mProtocolMessages, this.mPrintDepreciationProtocol, false, false, finYears, finYearForFixedAsset);
                            deprCalc.depreciation(allDepreciations, null, false);
                            allDepreciationsAfterDepr = deprCalc.mTransactCache;
                            if ((faArea.getDeprStartDate() == null || !DateHelper.afterOrEqual((Date)this.mFinPeriod.getValidUntil(), (Date)faArea.getDeprStartDate())) && (faArea.getDeprStartDate() != null || !DateHelper.afterOrEqual((Date)this.mFinPeriod.getValidUntil(), (Date)fixedAsset.getAcquisitionDate())) || faArea.getProcessingDate() != null && (faArea.getProcessingDate() == null || !DateHelper.after((Date)this.mFinPeriod.getValidUntil(), (Date)faArea.getProcessingDate()))) break;
                            faArea.makeSaveable();
                            faArea.setProcessingDate(this.mFinPeriod.getValidUntil());
                            if (faArea.getStatus().value() != 7 || faArea.getUsefullLifeInMonth() <= 0 || faArea.getProcessingDate() == null) break;
                            Date fromDate = fixedAsset.getAcquisitionDate();
                            if (fixedAsset.getCommissioningDate() != null) {
                                fromDate = fixedAsset.getCommissioningDate();
                            }
                            int resMonth = FixedAssetArea.calculateResidualLifeInMonth(faArea.getUsefullLifeInMonth(), fromDate, faArea.getProcessingDate());
                            faArea.setResPeriodInYears((short)(resMonth / 12));
                            faArea.setResPeriodInMonth((short)(resMonth % 12));
                            if (faArea.getUsefullLifeInDays() == Integer.MIN_VALUE || faArea.getUsefullLifeInDays() == 0) {
                                usefullLifeInDays = 0;
                                if (faArea.getUsefullLifeInMonth() > 0) {
                                    usefullLifeInDays = FixedAssetArea.calculateLifeInDays(fromDate, null, faArea.getUsefullLifeInMonth());
                                }
                                faArea.setUsefullLifeInDays(usefullLifeInDays);
                            }
                            if (faArea.getUsefullLifeInDays() > 0) {
                                faArea.setResLifeInDays(FixedAssetArea.calculateResLifeInDays(faArea.getUsefullLifeInDays(), fromDate, faArea.getProcessingDate(), true));
                                break;
                            }
                            faArea.setResLifeInDays(0);
                            break;
                        }
                        case 1: {
                            int usefullLifeInDays;
                            int resMonth;
                            Date fromDate;
                            DepreciationCalculation deprCalc = new DepreciationCalculation(this.mCompany, fixedAsset, this.mDeprArea, faArea, this.mGlobalLanguage, this.mFunction, this.mDepreciationUntilDate, this.mCancellationUntilDate, this.mDocumentDate, false, false, false, null, this.mProtocolMessages, this.mPrintDepreciationProtocol, false, false, finYears, finYearForFixedAsset);
                            deprCalc.cancelDepreciation(allDepreciations);
                            allDepreciationsAfterDepr = deprCalc.mTransactCache;
                            if (faArea.getProcessingDate() == null || !DateHelper.beforeOrEqual((Date)this.mFinPeriod.getValidFrom(), (Date)faArea.getProcessingDate())) break;
                            if (faArea.getDeprStartDate() != null) {
                                if (DateHelper.after((Date)this.mFinPeriod.getValidFrom(), (Date)faArea.getDeprStartDate())) {
                                    faArea.makeSaveable();
                                    faArea.setProcessingDate(DateHelper.yesterday((Date)this.mFinPeriod.getValidFrom()));
                                    break;
                                }
                                faArea.makeSaveable();
                                faArea.setProcessingDate(null);
                                break;
                            }
                            if (DateHelper.after((Date)this.mFinPeriod.getValidFrom(), (Date)fixedAsset.getAcquisitionDate())) {
                                faArea.makeSaveable();
                                faArea.setProcessingDate(DateHelper.yesterday((Date)this.mFinPeriod.getValidFrom()));
                                if (faArea.getStatus().value() != 7 || faArea.getUsefullLifeInMonth() <= 0 || faArea.getProcessingDate() == null) break;
                                fromDate = fixedAsset.getAcquisitionDate();
                                if (fixedAsset.getCommissioningDate() != null) {
                                    fromDate = fixedAsset.getCommissioningDate();
                                }
                                resMonth = FixedAssetArea.calculateResidualLifeInMonth(faArea.getUsefullLifeInMonth(), fromDate, faArea.getProcessingDate());
                                faArea.setResPeriodInYears((short)(resMonth / 12));
                                faArea.setResPeriodInMonth((short)(resMonth % 12));
                                if (faArea.getUsefullLifeInDays() == Integer.MIN_VALUE || faArea.getUsefullLifeInDays() == 0) {
                                    usefullLifeInDays = 0;
                                    if (faArea.getUsefullLifeInMonth() > 0) {
                                        usefullLifeInDays = FixedAssetArea.calculateLifeInDays(fromDate, null, faArea.getUsefullLifeInMonth());
                                    }
                                    faArea.setUsefullLifeInDays(usefullLifeInDays);
                                }
                                if (faArea.getUsefullLifeInDays() > 0) {
                                    faArea.setResLifeInDays(FixedAssetArea.calculateResLifeInDays(faArea.getUsefullLifeInDays(), fromDate, faArea.getProcessingDate(), true));
                                    break;
                                }
                                faArea.setResLifeInDays(0);
                                break;
                            }
                            faArea.makeSaveable();
                            faArea.setProcessingDate(null);
                            if (faArea.getStatus().value() != 7 || faArea.getUsefullLifeInMonth() <= 0) break;
                            faArea.setResPeriodInYears(faArea.getPeriodInYears());
                            faArea.setResPeriodInMonth(faArea.getPeriodInMonth());
                            fromDate = fixedAsset.getAcquisitionDate();
                            if (fixedAsset.getCommissioningDate() != null) {
                                fromDate = fixedAsset.getCommissioningDate();
                            }
                            if (faArea.getUsefullLifeInDays() == Integer.MIN_VALUE || faArea.getUsefullLifeInDays() == 0) {
                                faArea.setUsefullLifeInDays(FixedAssetArea.calculateLifeInDays(fromDate, null, faArea.getUsefullLifeInMonth()));
                            }
                            faArea.setResLifeInDays(faArea.getUsefullLifeInDays());
                        }
                    }
                    Date untilDate = DateMapper.toDate((String)"2050-12-31");
                    DepreciationCalculationHelper dchelper = null;
                    if (allDepreciationsAfterDepr != null) {
                        dchelper = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(allDepreciationsAfterDepr, untilDate, true, false);
                    } else {
                        DepreciationCalculation deprCalcValues = new DepreciationCalculation(faArea, DepreciationFunctionEnum.DEFE_CALCULATION);
                        List<DepreciationCalculationHelper> transactCache = deprCalcValues.buildTransactionsCache(null);
                        if (transactCache != null) {
                            dchelper = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, untilDate, true, false);
                        }
                    }
                    if (dchelper != null) {
                        faArea.setAcquisitionValue(dchelper.getAccumAcquisitionValue());
                        faArea.setNetBookValue(dchelper.getNetBookValue());
                        faArea.setAccumDeprValue(dchelper.getAccumAcquisitionValue().subtract(dchelper.getNetBookValue()));
                        faArea.setIsCalledFromDepreciation(true);
                        faArea.makeSaveable();
                    }
                    if (afaCounter < 200) continue;
                    this.mContext.flush();
                    afaCounter = 0;
                }
                this.mContext.flush();
                txAdapter.commit(txStatus);
                txStatus = txAdapter.getUpdateTransaction();
                this.mProtocolMessages.add(new DepreciationProtocolMessages(8, mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 4) + ": " + DepreciationCalculation.processedCounter));
                if (this.mPrintDepreciationProtocol) {
                    this.printDepreciationReport(allDepreciations, reportsList);
                }
            }
            if (this.mPostAccounting && this.mDeprArea.getTransferDataFin() || this.mPostCosting && this.mDeprArea.getTransferDataCost()) {
                int countTransactionsPosted = 0;
                countTotal = (int)dao.getRowCount(this.mWhere);
                dataset = dao.getDataSet(this.mOrder, this.mWhere);
                ArrayList<DepreciationPostingAndProtocolHelper> allPostings = new ArrayList<DepreciationPostingAndProtocolHelper>();
                counter = 0;
                while (dataset.hasNext()) {
                    faContainer = (FixedassetContainer)dataset.getNext();
                    fixedAsset = new FixedAssetData(true);
                    FixedAssetPersistencyManager.fillFixedAssetData((FixedAssetData)fixedAsset, (FixedassetContainer)faContainer);
                    faArea = FixedAssetArea.getFixedAssetArea((FixedAsset)fixedAsset, this.mDeprArea);
                    ++counter;
                    if (faArea.getStatus().value() == 9 || faArea.getStatus().value() == 5 && !this.mDeprArea.getCalculative()) continue;
                    countTransactionsPosted += DepreciationPostingAndProtocol.processTransactions((DepreciationArea)this.mDeprArea, (FixedAssetArea)faArea, (Date)this.mDocumentDate, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (FinancialYear)this.mFinYearPosting, (FinancialPeriod)this.mFinPeriodPosting, (CostingYear)this.mCostingYearPosting, (CostingPeriod)this.mCostingPeriodPosting, (Boolean)this.mPostAccounting, (Boolean)this.mPostCosting, (AssetaccountingSetup)this.mAASetup, allPostings, (Language)this.mGlobalLanguage, (DepreciationFunctionEnum)this.mFunction, this.mProtocolMessages, (int)this.mPostWithAnalysisCode, (int)this.mPostWithAnalysisCodeCA);
                    SpecialReserve[] specialReserves = SpecialReserve.getSpecialReserves((FixedAssetArea)faArea);
                    for (int i = 0; i < specialReserves.length; ++i) {
                        countTransactionsPosted += SpecialReservePostingAndProtocol.processTransactions((SpecialReserve)specialReserves[i], (FixedAssetArea)faArea, (Date)this.mDocumentDate, (Date)this.mTransactionDatePosting, (FinancialYear)this.mFinYearPosting, (FinancialPeriod)this.mFinPeriodPosting, (CostingYear)this.mCostingYearPosting, (CostingPeriod)this.mCostingPeriodPosting, (Boolean)this.mPostAccounting, (Boolean)this.mPostCosting, allPostings, (Language)this.mGlobalLanguage, (DepreciationFunctionEnum)this.mFunction, this.mProtocolMessages, (int)this.mPostWithAnalysisCode, (int)this.mPostWithAnalysisCodeCA);
                    }
                }
                this.mProtocolMessages.add(new DepreciationProtocolMessages(8, mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 5) + ": " + countTransactionsPosted));
                Hashtable collectivePostingFinAccounting = new Hashtable();
                Hashtable collectivePostingCostAccounting = new Hashtable();
                if (!allPostings.isEmpty()) {
                    if (this.mDeprArea.getTransferDataFin() && this.mPostAccounting) {
                        collectivePostingFinAccounting = this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getWithCostCentres() || this.mDeprArea.getWithCostUnits() ? DepreciationPostingAndProtocol.buildAccumForCollectivePostingFinAccounting_CC_CU_AC(allPostings, (DepreciationArea)this.mDeprArea) : DepreciationPostingAndProtocol.buildAccumForCollectivePostingFinAccounting(allPostings);
                    }
                    if (this.mDeprArea.getTransferDataCost() && this.mPostCosting) {
                        collectivePostingCostAccounting = this.mDeprArea.getCaWithCostUnit() || this.mPostWithAnalysisCodeCA > 0 ? DepreciationPostingAndProtocol.buildAccumForCollectivePostingCostAccounting_CU(allPostings, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea) : DepreciationPostingAndProtocol.buildAccumForCollectivePostingCostAccounting(allPostings, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea);
                    }
                    if (this.mFunction.value() != 3) {
                        if (this.mPostAccounting) {
                            if (this.mDeprArea.getTransferTransactionAs().value() == 1) {
                                Accounting.bookSinglePostings(allPostings, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (FinancialYear)this.mFinYearPosting, (CostingYear)this.mCostingYearPosting, (int)this.mPostWithAnalysisCode, (int)this.mPostWithAnalysisCodeCA, (String)this.mIndivPostingNumber);
                            } else {
                                Accounting.bookCollectivePostings((Map)collectivePostingFinAccounting, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (FinancialYear)this.mFinYearPosting, (CostingYear)this.mCostingYearPosting, (Boolean)this.mPostAccounting, (Boolean)this.mPostCosting, (int)this.mPostWithAnalysisCode, (int)this.mPostWithAnalysisCodeCA, (String)this.mIndivPostingNumber);
                            }
                            if (this.mDeprArea.getSaveSingleEntries()) {
                                Accounting.storeSinglePostings(allPostings, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (String)this.mPrintTime, (FinancialYear)this.mFinYearPosting, (CostingYear)this.mCostingYearPosting, (FAFinancialPeriod)this.mFinPeriod);
                            }
                            if (this.mPostCosting) {
                                Accounting.bookCollectivePostingsCostAccounting((Map)collectivePostingCostAccounting, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (CostingYear)this.mCostingYearPosting, (Date)this.mCostingYearPosting.getValidUntil(), (int)this.mPostWithAnalysisCodeCA);
                            }
                        } else {
                            Accounting.bookCollectivePostingsCostAccounting((Map)collectivePostingCostAccounting, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (CostingYear)this.mCostingYearPosting, (Date)this.mCostingYearPosting.getValidUntil(), (int)this.mPostWithAnalysisCodeCA);
                            if (this.mDeprArea.getCaSaveSingleEntries()) {
                                Accounting.storeSinglePostings(allPostings, (AccountingCompany)this.mCompany, (DepreciationArea)this.mDeprArea, (Date)this.mTransactionDatePosting, (Date)this.mTransactionDatePostingCA, (Date)this.mDocumentDate, (String)this.mPrintTime, (FinancialYear)this.mFinYearPosting, (CostingYear)this.mCostingYearPosting, (FAFinancialPeriod)this.mFinPeriod);
                            }
                        }
                    }
                    if (this.mPrintPostingProtocol) {
                        this.printItemizedPostingProtocol(allPostings, reportsList);
                    }
                } else {
                    this.mProtocolMessages.add(new DepreciationProtocolMessages(8, mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 2)));
                }
                this.mContext.flush();
                txAdapter.commit(txStatus);
                txStatus = txAdapter.getUpdateTransaction();
                if (!collectivePostingFinAccounting.isEmpty() || !collectivePostingCostAccounting.isEmpty()) {
                    this.printCollectivePostingProtocol(reportsList, collectivePostingFinAccounting, collectivePostingCostAccounting);
                }
            }
            this.mContext.flush();
            txAdapter.commit(txStatus);
        }
        catch (BusinessDomainException e) {
            this.mContext.clearAll();
            txAdapter.rollbackOnException(txStatus, (Throwable)e);
            ExceptionMapper.printException((Throwable)e);
            this.mProtocolMessages.add(new DepreciationProtocolMessages(7, ExceptionMapper.toString((Throwable)e)));
        }
        catch (Exception e) {
            this.mContext.clearAll();
            txAdapter.rollbackOnException(txStatus, (Throwable)e);
            ExceptionMapper.printException((Throwable)e);
            this.mProtocolMessages.add(new DepreciationProtocolMessages(7, ExceptionMapper.toString((Throwable)e)));
        }
        finally {
            this.printDepreciationProtocol(reportsList);
            String[] result = new String[reportsList.size()];
            reportsList.toArray(result);
        }
    }

    private void printDepreciationReport(List<DepreciationPostingAndProtocolHelper> allDepreciations, List<String> reportsList) throws BusinessDomainException {
        if (allDepreciations.size() < 1) {
            this.mProtocolMessages.add(new DepreciationProtocolMessages(8, mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 1)));
            return;
        }
        DepreciationReportDataSource depreciationReportDataSource = new DepreciationReportDataSource(allDepreciations, this.mCompany, this.mFinYear, this.mFinPeriod, this.mDeprArea, this.mGlobalLanguage, this.mDocumentDate, this.mFunction, this.mPrintTime, this.mIsAdditionalOutputArchive);
        Map parameters = depreciationReportDataSource.getParameters();
        JasperReport jasperReport = null;
        jasperReport = ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getIsWideCostCentreColumnDeprProtocols() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/DepreciationReportCCWideColumn.jrxml") : JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/DepreciationReport.jrxml");
        File file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchive((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)depreciationReportDataSource, (ReportType)this.mReportTypeForOutputManager, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsAdditionalOutputArchive);
        if (depreciationReportDataSource.getHasDataToPrint()) {
            this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
            reportsList.add(file.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File name: {}", (Object)file.getName());
            }
        }
    }

    private void printDepreciationProtocol(List<String> reportsList) {
        try {
            String PDFFILE_PREFIX = "DPR";
            this.mProtocolMessages.add(new DepreciationProtocolMessages(9, "*** " + mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 0) + " ***"));
            DepreciationProtocolMessages[] protocolMessages = new DepreciationProtocolMessages[this.mProtocolMessages.size()];
            this.mProtocolMessages.toArray(protocolMessages);
            for (int i = protocolMessages.length - 1; i > 0; --i) {
                for (int j = 0; j < i; ++j) {
                    DepreciationProtocolMessages temp;
                    if (protocolMessages[j].getMessageType() > protocolMessages[j + 1].getMessageType()) {
                        temp = protocolMessages[j];
                        protocolMessages[j] = protocolMessages[j + 1];
                        protocolMessages[j + 1] = temp;
                        continue;
                    }
                    if (protocolMessages[j].getMessageType() != protocolMessages[j + 1].getMessageType() || protocolMessages[j].getSortKey() <= protocolMessages[j + 1].getSortKey()) continue;
                    temp = protocolMessages[j];
                    protocolMessages[j] = protocolMessages[j + 1];
                    protocolMessages[j + 1] = temp;
                }
            }
            String[] protocolMessagesText = new String[this.mProtocolMessages.size()];
            for (int i = 0; i < protocolMessages.length; ++i) {
                protocolMessagesText[i] = protocolMessages[i].getMessage();
            }
            DepreciationProtocolReportDataSource depreciationProtocolReportDataSource = new DepreciationProtocolReportDataSource(this.mCompany, this.mGlobalLanguage, this.mPresetStruct, protocolMessagesText, this.mPrintTime);
            Map parameters = depreciationProtocolReportDataSource.getParameters();
            JasperReport jasperReport = null;
            jasperReport = JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/DepreciationProtocolReport.jrxml");
            File file = JasperReportManager.runReportToPdfWithStdProtection((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)depreciationProtocolReportDataSource, (String)"DPR", (String)"", (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false);
            this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
            String result = file.getName();
            reportsList.add(result);
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
        }
    }

    private void printCollectivePostingProtocol(List<String> reportsList, Hashtable<String, BigDecimal> collectivePostingFinAccounting, Hashtable<String, BigDecimal[]> collectivePostingCostAccounting) throws BusinessDomainException {
        CollectivePostingReportDataSource collectivePostingDataSource = new CollectivePostingReportDataSource(collectivePostingFinAccounting, collectivePostingCostAccounting, this.mCompany, this.mFinYearPosting, this.mFinPeriodPosting, this.mCostingYearPosting, this.mCostingPeriodPosting, Boolean.valueOf(this.mPostAccounting), this.mDeprArea, this.mGlobalLanguage, this.mTransactionDatePosting, this.mTransactionDatePostingCA, this.mDocumentDate, this.mPrintTime, this.mPostWithAnalysisCode, this.mPostWithAnalysisCodeCA, this.mFunction, false, this.mIsAdditionalOutputArchive);
        Map parameters = collectivePostingDataSource.getParameters();
        JasperReport jasperReport = null;
        JasperReport subReportPostCosting = null;
        subReportPostCosting = JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingCostingSubReport.jrxml");
        parameters.put("SubreportPostCosting", subReportPostCosting);
        jasperReport = this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getWithCostUnits() && !this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getWithCostUnits() && !this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingCostCentreReport.jrxml") : (this.mDeprArea.getWithCostCentres() && this.mDeprArea.getWithCostUnits() && !this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() || !this.mDeprArea.getWithCostCentres() && this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingCcAcReport.jrxml") : (!this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingAnalCodesReport.jrxml") : (this.mDeprArea.getWithCostCentres() && this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingCcCuAcReport.jrxml") : JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/CollectivePostingReport.jrxml"))));
        File file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchive((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)collectivePostingDataSource, (ReportType)ReportType.DEPRECIATIONPOSTINGACCUM, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsAdditionalOutputArchive);
        if (collectivePostingDataSource.getHasDataToPrint()) {
            this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
            reportsList.add(file.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File name: {}", (Object)file.getName());
            }
        }
    }

    private void printItemizedPostingProtocol(List<DepreciationPostingAndProtocolHelper> allPostings, List<String> reportsList) throws BusinessDomainException {
        JasperReport jasperReport = null;
        Boolean postWithAnalysisCodesCA = false;
        if (this.mPostWithAnalysisCodeCA > 0 && this.mDeprArea.getTransferDataCost() && this.mDeprArea.getCaWithCostCentre()) {
            postWithAnalysisCodesCA = true;
        }
        ItemizedListingPostingsReportDataSource itemizedListingPostingsDataSource = new ItemizedListingPostingsReportDataSource(allPostings, this.mCompany, this.mFinYearPosting, this.mFinPeriodPosting, this.mCostingYearPosting, this.mCostingPeriodPosting, Boolean.valueOf(this.mPostAccounting), this.mDeprArea, this.mGlobalLanguage, this.mTransactionDatePosting, this.mTransactionDatePostingCA, this.mPrintTime, this.mFunction, postWithAnalysisCodesCA.booleanValue(), false, this.mIsAdditionalOutputArchive);
        Map parameters = itemizedListingPostingsDataSource.getParameters();
        jasperReport = this.mDeprArea.getTransferDataCost() && this.mDeprArea.getCaWithCostUnit() && this.mPostWithAnalysisCodeCA == 0 && !this.mDeprArea.getTransferDataFin() || this.mDeprArea.getTransferDataCost() && !this.mDeprArea.getCaWithCostUnit() && this.mPostWithAnalysisCodeCA > 0 && !this.mDeprArea.getTransferDataFin() || this.mDeprArea.getTransferDataFin() && this.mDeprArea.getWithCostUnits() && this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/ItemizedListingPostingsReportWithCostUnits.jrxml") : (this.mDeprArea.getTransferDataFin() && this.mDeprArea.getWithCostCentres() && this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getTransferDataFin() && this.mDeprArea.getWithCostCentres() && !this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getTransferDataFin() && !this.mDeprArea.getWithCostCentres() && this.mDeprArea.getWithCostUnits() && this.mDeprArea.getAnalysisCodeTransaction() || this.mDeprArea.getTransferDataCost() && this.mDeprArea.getCaWithCostUnit() && this.mPostWithAnalysisCodeCA > 0 || this.mDeprArea.getTransferDataFin() && this.mDeprArea.getTransferDataCost() && this.mDeprArea.getAnalysisCodeTransaction() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/ItemizedListingPostingsReportWithCcCuAc.jrxml") : (((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getIsWideCostCentreColumnDeprProtocols() ? JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/ItemizedListingPostingsReportCCWideColumn.jrxml") : JasperReportCompiler.compileReport((String)"com/varial/assetaccounting/jasperreport/depreciation/ItemizedListingPostingsReport.jrxml")));
        File file = JasperReportManager.runReportToPdfWithReportTypeAndOptionalArchive((String)this.mToken.getUserId(), (JasperReport)jasperReport, (Map)parameters, (JRDataSource)itemizedListingPostingsDataSource, (ReportType)ReportType.DEPRECIATIONPOSTINGSINGLE, (PrintJob.PrintJobType)this.mPrintJobType, (boolean)false, (boolean)this.mIsAdditionalOutputArchive);
        if (itemizedListingPostingsDataSource.getHasDataToPrint()) {
            this.mURLs.add(JasperReportManager.toHttpServerURL((File)file));
            reportsList.add(file.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("File name: {}", (Object)file.getName());
            }
        }
    }

    public List<URL> getURLs() {
        return this.mURLs;
    }
}

