/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.depreciation;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.assetaccounting.calculationmethod.BaseCalcEnum;
import com.varial.assetaccounting.calculationmethod.ChangeoverEnum;
import com.varial.assetaccounting.calculationmethod.DepreciationTypeEnum;
import com.varial.assetaccounting.calculationmethod.DistributionFirstYearEnum;
import com.varial.assetaccounting.calculationmethod.MethodTypeEnum;
import com.varial.assetaccounting.depreciation.DepreciationFunctionEnum;
import com.varial.assetaccounting.depreciation.DepreciationStruct;
import com.varial.assetaccounting.depreciationarea.DepreciationFromUntilEnum;
import com.varial.assetaccounting.depreciationarea.FullDisposDeprecUntilEnum;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationPlanMethodData;
import com.varial.assetaccounting.domain.calculationmethod.ImputedInterestMethodData;
import com.varial.assetaccounting.domain.calculationmethod.SpecDepreciationMethodData;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculationHelper;
import com.varial.assetaccounting.domain.depreciation.DepreciationPostingAndProtocol;
import com.varial.assetaccounting.domain.depreciation.DepreciationPostingAndProtocolHelper;
import com.varial.assetaccounting.domain.depreciation.DepreciationPresetExceptionMapper;
import com.varial.assetaccounting.domain.depreciation.DepreciationProtocolMessages;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriod;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialPeriodDetail;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fixedasset.DepreciationPlanIT;
import com.varial.assetaccounting.domain.fixedasset.FATransactionSequenceNoPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetArea;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetAreaPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransaction;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.TransactionMapper;
import com.varial.assetaccounting.domain.indexseries.IndexSeries;
import com.varial.assetaccounting.domain.specialreserve.SpecialReserve;
import com.varial.assetaccounting.domain.specialreserve.SpecialReserveCalculation;
import com.varial.assetaccounting.domain.unitdepreciation.PerformanceUnits;
import com.varial.assetaccounting.domain.unitdepreciation.PeriodUnits;
import com.varial.assetaccounting.domain.unitdepreciation.PeriodUnitsPersistencyManager;
import com.varial.assetaccounting.fafinancialyear.FAFinancialPeriodDetailStruct;
import com.varial.assetaccounting.fixedasset.AutomaticDepreciationTypeEnum;
import com.varial.assetaccounting.fixedasset.DepreciationStartEnum;
import com.varial.assetaccounting.fixedasset.StatusEnum;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategory;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryPersistencyManager;
import com.varial.framework.domain.analysiscode.AnalysisCodeCategoryType;
import com.varial.framework.domain.analysiscode.AnalysisCodeTable;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.quantityunit.QuantityUnitPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.SimplePeriod;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepreciationCalculation {
    private static Logger LOGGER = LoggerFactory.getLogger((String)DepreciationCalculation.class.getName());
    private static final BigDecimal HUNDRED = new BigDecimal("100.00");
    private static final BigDecimal DAYSOFAYEAR = new BigDecimal("365.00");
    private final AccountingCompany mCompany;
    private final FixedAssetData mFixedAsset;
    private final DepreciationArea mDeprArea;
    private final FixedAssetArea mFaArea;
    private boolean mKeepNetBookValueWithDecimalPlaces;
    private final Language mGlobalLanguage;
    private final DepreciationFunctionEnum mFunction;
    private final Date mDepreciationUntilDate;
    private final Date mCancellationUntilDate;
    private final Date mDocumentDate;
    private final boolean mTriggerIsNewTransaction;
    private boolean mIsTransactTypeIsDisposalOrRepost;
    private boolean mIsTransactTypeIsFullDisposal;
    private boolean mIsTransactionCancellation;
    private CalcMethod mCalcMethod;
    private CalcMethod mCalcMethodSpecDepr;
    private ImputedInterestMethodData mCalcMethodInterests;
    private int indexOfDeprStartPeriod;
    private int indexOfSpecDeprStartPeriod;
    private AssetaccountingSetup mAASetup;
    public List<DepreciationCalculationHelper> mTransactCache;
    private boolean mIsDeprPreview;
    private boolean mNoCalculation;
    private Date mPreviewUntilDate;
    private BigDecimal depreciationPercent;
    private BigDecimal mNewDepreciationPercent;
    private boolean mPrintDepreciationProtocol;
    private FAFinancialYear mFinYearForFixedAsset;
    private boolean mFromTransaction;
    private boolean mYearDeprAmountLess;
    private boolean mBaseForIndexIsReplValue;
    private boolean mIsFullDisposalWithHalfYearAT;
    private PerformanceUnits perfUnit;
    private PeriodUnits[] periodUnits;
    private FAFinancialYear[] mFinYears;
    private List<DepreciationProtocolMessages> mProtocolMessages = new ArrayList<DepreciationProtocolMessages>();
    private DepreciationPlanIT mDeprPlanIT;
    private int mNumberOfYearCZ;
    private boolean mLastDepr;
    private boolean mStartDepr;
    private boolean mLastInterest;
    private boolean mDeprMethodHasChanged;
    private int mPosACforFAT;
    private int mPosACforFA;
    private boolean mJurisdiction_CZ;
    private boolean mJurisdiction_AT;
    private boolean mJurisdiction_FR;
    private boolean mJurisdiction_PL;
    private boolean mJurisdiction_IT;
    private boolean mJurisdiction_DE;
    public static int processedCounter;
    private static final int AUTOMATICPOSTINGTEXT = 0;
    private static final int FIXEDASSET = 1;
    private static final int YEAR = 2;
    private static final int INDEXAQUISITIONYEAR = 3;
    private static final int INDEXCURRENTYEAR = 4;
    private static final int FIXEDASSETNOCALCULATION = 5;
    private static TranslateableResourceList mAADepreciationList;

    public DepreciationCalculation(FixedAssetArea faArea, DepreciationFunctionEnum function) {
        this.mCompany = null;
        this.mFixedAsset = null;
        this.mDeprArea = null;
        this.mGlobalLanguage = null;
        this.mFunction = function;
        this.mDepreciationUntilDate = null;
        this.mCancellationUntilDate = null;
        this.mDocumentDate = null;
        this.mFaArea = faArea;
        this.mKeepNetBookValueWithDecimalPlaces = faArea.getDeprArea().getDecPlacesNetValue();
        this.mTriggerIsNewTransaction = false;
    }

    public DepreciationCalculation(AccountingCompany company, FixedAssetData fixedAsset, DepreciationArea deprArea, FixedAssetArea faArea, Language globalLanguage, DepreciationFunctionEnum function, Date depreciationUntilDate, Date cancellationUntilDate, Date documentDate, boolean triggerIsNewTransaction, boolean isTransactTypeIsDisposalOrRepost, boolean isDeprPreview, Date previewUntilDate, List<DepreciationProtocolMessages> protocolMessages, boolean printDepreciationProtocol, boolean isTransactTypeIsFullDisposal, boolean isTransactionCancellation, FAFinancialYear[] finYears, FAFinancialYear finYearForFixedAsset) {
        this.mCompany = company;
        this.mFixedAsset = fixedAsset;
        this.mDeprArea = deprArea;
        this.mFaArea = faArea;
        this.mKeepNetBookValueWithDecimalPlaces = faArea.getDeprArea().getDecPlacesNetValue();
        this.mGlobalLanguage = globalLanguage;
        this.mFunction = function;
        this.mDepreciationUntilDate = depreciationUntilDate;
        this.mCancellationUntilDate = cancellationUntilDate;
        this.mDocumentDate = documentDate;
        this.mTriggerIsNewTransaction = triggerIsNewTransaction;
        this.mIsTransactTypeIsDisposalOrRepost = isTransactTypeIsDisposalOrRepost;
        this.mAASetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mCompany);
        this.mIsDeprPreview = isDeprPreview;
        this.mPreviewUntilDate = previewUntilDate;
        this.mProtocolMessages = protocolMessages;
        this.mNumberOfYearCZ = -1;
        this.mPrintDepreciationProtocol = printDepreciationProtocol;
        this.mIsTransactTypeIsFullDisposal = isTransactTypeIsFullDisposal;
        this.mIsTransactionCancellation = isTransactionCancellation;
        this.mFinYears = finYears;
        this.mFinYearForFixedAsset = finYearForFixedAsset;
    }

    public void depreciation(List<DepreciationPostingAndProtocolHelper> allDepreciations, List<DepreciationCalculationHelper> transactCache, boolean fromTransaction) throws BusinessDomainException {
        LOGGER.debug("depreciation(...)");
        this.mTransactCache = transactCache == null ? this.buildTransactionsCache(null, null, null, false) : transactCache;
        this.mNewDepreciationPercent = BigDecimal.ZERO;
        this.mLastDepr = false;
        this.mStartDepr = false;
        this.mLastInterest = false;
        this.mDeprMethodHasChanged = false;
        this.mNoCalculation = false;
        this.mFromTransaction = fromTransaction;
        this.mBaseForIndexIsReplValue = false;
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.CZ) {
            this.mJurisdiction_CZ = true;
        }
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.AT) {
            this.mJurisdiction_AT = true;
        }
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.PL) {
            this.mJurisdiction_PL = true;
        }
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.IT) {
            this.mJurisdiction_IT = true;
        }
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.FR) {
            this.mJurisdiction_FR = true;
        }
        if (this.mDeprArea.getJurisdictionType() == JurisdictionType.DE) {
            this.mJurisdiction_DE = true;
        }
        if (((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getUseAnalysisCodesForAssetAccPostings() && this.mDeprArea.getAnalysisCodeTransaction() && this.mDeprArea.getCodeTableTransaction() != null) {
            String oidAnalysisCodeTableArea = this.mDeprArea.getCodeTableTransaction().getObjectid();
            AnalysisCodeCategory analCodeCatFAT = AnalysisCodeCategoryPersistencyManager.getCategory((ICompany)this.mCompany, (AnalysisCodeCategoryType)AnalysisCodeCategoryType.FIXED_ASSETS_TRANSACTION);
            AnalysisCodeCategory analCodeCatFA = AnalysisCodeCategoryPersistencyManager.getCategory((ICompany)this.mCompany, (AnalysisCodeCategoryType)AnalysisCodeCategoryType.FIXED_ASSETS);
            AnalysisCodeTable[] analCodeTablesFAT = analCodeCatFAT.getAnalysisCodeTables();
            AnalysisCodeTable[] analCodeTablesFA = analCodeCatFA.getAnalysisCodeTables();
            this.mPosACforFAT = 0;
            this.mPosACforFA = 0;
            if (analCodeTablesFAT != null && analCodeTablesFAT.length >= 0) {
                for (int i = 0; i < analCodeTablesFAT.length; ++i) {
                    if (!analCodeTablesFAT[i].getObjectid().equals(oidAnalysisCodeTableArea)) continue;
                    this.mPosACforFAT = i + 1;
                    break;
                }
            }
            if (analCodeTablesFA != null && analCodeTablesFA.length >= 0) {
                for (int j = 0; j < analCodeTablesFA.length; ++j) {
                    if (!analCodeTablesFA[j].getObjectid().equals(oidAnalysisCodeTableArea)) continue;
                    this.mPosACforFA = j + 1;
                    break;
                }
            }
        }
        DepreciationCalculationHelper dch = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(this.mTransactCache, this.mDepreciationUntilDate, false, false);
        this.mIsFullDisposalWithHalfYearAT = false;
        if (dch != null) {
            if (dch.getLastDeprDate() != null && dch.getProcessingDate() != null) {
                this.mLastDepr = DateHelper.before((Date)dch.getLastDeprDate(), (Date)dch.getProcessingDate());
            } else if (dch.getLastDeprDate() == null && dch.getProcessingDate() != null) {
                this.mLastDepr = true;
            }
            if (this.mFromTransaction && this.mFaArea.getLastDeprDate() != null && this.mFaArea.getIsFullDisposed() && DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mDepreciationUntilDate) && dch.getTransactionType().value() == 20 && dch.getFullDisposalDeprUntilType().value() == 6 && this.mJurisdiction_AT) {
                this.mIsFullDisposalWithHalfYearAT = true;
            }
        }
        while (dch != null && (dch.getTransactionType().value() == 20 || dch.getTransactionType().value() == 6 && BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAccumAcquisitionValue()) || dch.getTransactionType().value() == 19 && BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAccumAcquisitionValue()) || dch.getTransactionType().value() == 5 && BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAccumAcquisitionValue()) || dch.getTransactionType().value() == 25 && BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAccumAcquisitionValue())) && this.mLastDepr && dch.getIndex() > 0) {
            if (dch.getProcessingDate() != null && this.mFaArea.getDeprStartDate() != null && DateHelper.getLastDayOfMonth((Date)dch.getProcessingDate()).equals(DateHelper.getLastDayOfMonth((Date)this.mFaArea.getDeprStartDate())) && (dch.getTransactionType().value() == 6 || dch.getTransactionType().value() == 5 || dch.getTransactionType().value() == 25)) {
                this.mLastDepr = false;
                continue;
            }
            if ((dch = this.mTransactCache.get(dch.getIndex() - 1)).getLastDeprDate() != null && dch.getProcessingDate() != null) {
                this.mLastDepr = DateHelper.before((Date)dch.getLastDeprDate(), (Date)dch.getProcessingDate());
                continue;
            }
            if (dch.getLastDeprDate() == null && dch.getProcessingDate() != null) {
                this.mLastDepr = true;
                continue;
            }
            this.mLastDepr = false;
        }
        this.mCalcMethod = null;
        boolean baseForDeprIsReplValue = false;
        BigDecimal baseForDepr = BigDecimal.ZERO;
        BigDecimal baseForSpecDepr = BigDecimal.ZERO;
        BigDecimal baseForInterests = BigDecimal.ZERO;
        if (!StringMapper.isNullString((String)this.mFaArea.getOidDepreciationMethod())) {
            this.mCalcMethod = CalcMethodPersistencyManager.getCalcMethod((String)this.mFaArea.getOidDepreciationMethod());
        }
        if (this.mCalcMethod != null && dch != null) {
            baseForDepr = DepreciationCalculation.getBaseForDepreciation(dch, this.mCalcMethod, this.mFaArea, null, this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage);
            if (this.mDeprArea.getCalculative() && (this.mCalcMethod.getBaseForCalc().value() == 5 || this.mCalcMethod.getBaseForCalc().value() == 6) && BigDecimalMapper.compareTo((BigDecimal)baseForDepr, (BigDecimal)BigDecimal.ZERO) > 0) {
                baseForDeprIsReplValue = true;
            }
        }
        if (!StringMapper.isNullString((String)this.mFaArea.getOidSpecDepreciationMethod())) {
            this.mCalcMethodSpecDepr = CalcMethodPersistencyManager.getCalcMethod((String)this.mFaArea.getOidSpecDepreciationMethod());
        }
        if (this.mCalcMethodSpecDepr != null && dch != null) {
            baseForSpecDepr = DepreciationCalculation.getBaseForDepreciation(dch, this.mCalcMethodSpecDepr, this.mFaArea, null, null, this.mIsDeprPreview, this.mGlobalLanguage);
        }
        if (!StringMapper.isNullString((String)this.mFaArea.getOidImputedInterestMethod())) {
            this.mCalcMethodInterests = (ImputedInterestMethodData)CalcMethodPersistencyManager.getCalcMethod((String)this.mFaArea.getOidImputedInterestMethod());
        }
        if (this.mCalcMethodInterests != null && dch != null && this.mCalcMethodInterests.getBaseForCalc().value() != 11) {
            baseForInterests = DepreciationCalculation.getBaseForDepreciation(dch, (CalcMethod)this.mCalcMethodInterests, this.mFaArea, null, this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage);
        }
        if (this.mFaArea.getReplacementIndex() != null && this.mFaArea.getReplacementIndex().getBaseForCalc().value() == 4) {
            this.mBaseForIndexIsReplValue = true;
        }
        boolean counterUpdated = false;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Debug conditions for depreciation, for:{}mFaArea.getLastDeprDate():{},mDepreciationUntilDate:{} {}mFaArea.getDeprStartDate():{},mFaArea.getStatus().value():{} ,mCalcMethod:{}", new Object[]{this.mFixedAsset.getCode(), this.mFaArea.getLastDeprDate(), this.mDepreciationUntilDate, System.getProperty("line.separator"), this.mFaArea.getDeprStartDate(), this.mFaArea.getStatus().value(), this.mCalcMethod});
            if (this.mCalcMethod != null) {
                LOGGER.debug("mCalcMethod.getCode():{}", (Object)this.mCalcMethod.getCode());
            }
            if (this.mCalcMethodSpecDepr != null) {
                LOGGER.debug("mCalcMethodSpecDepr.getCode():{}", (Object)this.mCalcMethodSpecDepr.getCode());
            }
            LOGGER.debug("dch {}  mTriggerIsNewTransaction {}", (Object)dch, (Object)this.mTriggerIsNewTransaction);
            if (dch != null) {
                LOGGER.debug("dch.getAccumAcquisitionValue():{} ,dch.getNetBookValue():{}", (Object)dch.getAccumAcquisitionValue(), (Object)dch.getNetBookValue());
            }
            LOGGER.debug("mFaArea.getDepResValue():{},mFaArea.getDeprArea().getDepBelowZero():{}mFaArea.getResidualLifeInMonth():{}, {}mFaArea.getDepBelowZero() {},baseForDepr:{},baseForSpec:{} ", new Object[]{DepreciationCalculation.getDepResValue(this.mFaArea), this.mFaArea.getDeprArea().getDepBelowZero(), this.mFaArea.getResidualLifeInMonth(), System.getProperty("line.separator"), this.mFaArea.getDepBelowZero(), baseForDepr, baseForSpecDepr});
        }
        this.mLastDepr = false;
        if (this.mDepreciationUntilDate != null) {
            if (this.mFromTransaction && this.mFaArea.getLastDeprDate() != null) {
                this.mLastDepr = this.mFaArea.getIsFullDisposed() && this.mDeprArea.getDeprToResValueFullDisposal() && DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mDepreciationUntilDate) && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0 ? false : (this.mIsFullDisposalWithHalfYearAT ? false : DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mDepreciationUntilDate));
                if (!this.mIsDeprPreview) {
                    this.mFinYearForFixedAsset = this.mDeprArea.getCalcRemLifeForPostCapitalization() && !this.mLastDepr && this.mJurisdiction_PL ? FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mDepreciationUntilDate) : (this.mIsTransactTypeIsDisposalOrRepost && DateHelper.after((Date)this.mDepreciationUntilDate, (Date)DateHelper.getLastDayOfYear((Date)this.mFaArea.getLastDeprDate())) ? FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mDepreciationUntilDate) : FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getLastDeprDate()));
                }
            } else {
                if (!this.mIsDeprPreview && this.mFinYearForFixedAsset == null) {
                    this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mDepreciationUntilDate);
                }
                if (this.mFaArea.getLastDeprDate() != null && this.mFaArea.getProcessingDate() != null) {
                    if (DateHelper.afterOrEqual((Date)this.mFaArea.getProcessingDate(), (Date)this.mFaArea.getLastDeprDate())) {
                        this.mLastDepr = DateHelper.afterOrEqual((Date)this.mFaArea.getProcessingDate(), (Date)this.mDepreciationUntilDate);
                        if (!this.mIsDeprPreview && !DateHelper.afterOrEqual((Date)DateHelper.tomorrow((Date)this.mFaArea.getProcessingDate()), (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                            this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getProcessingDate());
                        }
                    } else {
                        this.mLastDepr = DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mDepreciationUntilDate);
                        if (!this.mIsDeprPreview && !DateHelper.afterOrEqual((Date)DateHelper.tomorrow((Date)this.mFaArea.getLastDeprDate()), (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                            this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getLastDeprDate());
                        }
                    }
                } else if (this.mFaArea.getProcessingDate() != null) {
                    this.mLastDepr = DateHelper.afterOrEqual((Date)this.mFaArea.getProcessingDate(), (Date)this.mDepreciationUntilDate);
                    if (!this.mIsDeprPreview && !DateHelper.afterOrEqual((Date)DateHelper.tomorrow((Date)this.mFaArea.getProcessingDate()), (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                        this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getProcessingDate());
                    }
                } else if (this.mFaArea.getLastDeprDate() != null) {
                    this.mLastDepr = DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mDepreciationUntilDate);
                    if (!this.mIsDeprPreview && !DateHelper.afterOrEqual((Date)DateHelper.tomorrow((Date)this.mFaArea.getLastDeprDate()), (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                        this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getLastDeprDate());
                    }
                }
            }
        }
        this.mStartDepr = false;
        if (this.mFaArea.getDeprStartDate() != null && this.mDepreciationUntilDate != null) {
            this.mStartDepr = DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)this.mDepreciationUntilDate);
        }
        Date lastDeprDate = null;
        if (this.mFaArea.getLastDeprDate() != null) {
            lastDeprDate = this.mFaArea.getLastDeprDate();
        }
        int usefullLifeInDays = 0;
        int usefullResLifeInDays = 0;
        if (this.mFaArea.getUsefullLifeInMonth() > 0) {
            usefullLifeInDays = this.mFixedAsset == null ? FixedAssetArea.calculateLifeInDays(((FixedAssetData)this.mFaArea.getFixedAsset()).getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth()) : FixedAssetArea.calculateLifeInDays(this.mFixedAsset.getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth());
            usefullResLifeInDays = usefullLifeInDays;
            if (lastDeprDate != null) {
                usefullResLifeInDays = FixedAssetArea.calculateResLifeInDays(usefullLifeInDays, this.mFaArea.getDeprStartDate(), lastDeprDate, true);
            }
        }
        this.mFaArea.setUsefullLifeInDays(usefullLifeInDays);
        this.mFaArea.setResLifeInDays(usefullResLifeInDays);
        if (!((this.mLastDepr || this.mStartDepr || this.mFaArea.getStatus().value() == 1 || this.mFaArea.getStatus().value() == 7 || this.mFaArea.getStatus().value() == 3 || this.mFaArea.getStatus().value() == 5 || this.mCalcMethod == null && this.mCalcMethodSpecDepr == null || dch == null || !this.mTriggerIsNewTransaction && (BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValue(), (BigDecimal)BigDecimal.ZERO) != 1 || this.mFaArea.getResidualLifeInMonth() < 1 && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero()) && BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getNetBookValue()) || BigDecimalMapper.compareTo((BigDecimal)baseForDepr, (BigDecimal)BigDecimal.ZERO) != 1 && this.mFaArea.getReplacementIndex() == null && BigDecimalMapper.compareTo((BigDecimal)baseForSpecDepr, (BigDecimal)BigDecimal.ZERO) != 1)) && !baseForDeprIsReplValue && !this.mIsDeprPreview)) {
            if (this.mIsDeprPreview && this.mCalcMethod == null && this.mFaArea.getStatus().value() != 7) {
                this.mCalcMethod = new DepreciationMethodData();
                this.mCalcMethod.setBaseForCalc(BaseCalcEnum.BCE_REST_VAL);
                ((DepreciationMethodData)this.mCalcMethod).setChangeover(ChangeoverEnum.COE_NO);
                ((DepreciationMethodData)this.mCalcMethod).setMethodTypeEnum(MethodTypeEnum.MTE_DEPRECIATION);
                ((DepreciationMethodData)this.mCalcMethod).setDepreciationType(DepreciationTypeEnum.DTE_STRAIGHT_LINE);
                ((DepreciationMethodData)this.mCalcMethod).setPercentage(BigDecimal.ZERO);
                this.mCalcMethod.makeReadOnly();
                this.mKeepNetBookValueWithDecimalPlaces = true;
                this.mNoCalculation = true;
            } else {
                this.mKeepNetBookValueWithDecimalPlaces = this.mFaArea.getDeprArea().getDecPlacesNetValue();
            }
            if (this.mCalcMethod != null) {
                this.calculateDepreciationsManager(this.mTransactCache);
            }
            ++processedCounter;
            counterUpdated = true;
            this.createOrUpdateFATransactions(this.mTransactCache, this.mFixedAsset, allDepreciations, this.mPrintDepreciationProtocol, this.mFinYearForFixedAsset);
            SpecialReserve[] specialReserves = SpecialReserve.getSpecialReserves((FixedAssetArea)this.mFaArea);
            boolean specRes = false;
            if (specialReserves.length > 0) {
                this.checkSpecialReserves(allDepreciations, specialReserves);
                specRes = true;
            }
            if (!this.mIsDeprPreview) {
                this.setLastDeprDate(this.mTransactCache, this.mFaArea, this.mDepreciationUntilDate, specRes);
                if (this.mFaArea.getReplacementIndex() != null) {
                    if (this.mBaseForIndexIsReplValue) {
                        if (DateHelper.equal((Date)this.mDepreciationUntilDate, (Date)this.mFinYearForFixedAsset.getValidUntil())) {
                            this.setReplacementValue(this.mTransactCache, this.mFaArea, false);
                        }
                    } else {
                        this.setReplacementValue(this.mTransactCache, this.mFaArea, false);
                    }
                }
            }
        } else {
            SpecialReserve[] specialReserves;
            LOGGER.debug("   - Pr\u00fcfung negativ = keine Afa-Berechnung !");
            if (!this.mIsDeprPreview && this.mFaArea.getReplacementIndex() != null && !this.mFaArea.getIsFullDisposed()) {
                if (this.mBaseForIndexIsReplValue && this.mFinYearForFixedAsset != null) {
                    if (DateHelper.equal((Date)this.mDepreciationUntilDate, (Date)this.mFinYearForFixedAsset.getValidUntil())) {
                        this.setReplacementValue(this.mTransactCache, this.mFaArea, true);
                    }
                } else {
                    this.setReplacementValue(this.mTransactCache, this.mFaArea, true);
                }
            }
            if ((specialReserves = SpecialReserve.getSpecialReserves((FixedAssetArea)this.mFaArea)).length > 0) {
                this.checkSpecialReserves(allDepreciations, specialReserves);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("debug conditions for interests, for:{}mDeprArea.getImputedInterest():{},mFaArea.getLastInterestCalcDate():{},mDepreciationUntilDate:{}, {} mFaArea.getDeprStartDate():{},mFaArea.getStatus().value():{},mCalcMethodInterests:{}", new Object[]{this.mFixedAsset.getCode(), this.mDeprArea.getImputedInterest(), this.mFaArea.getLastInterestCalcDate(), this.mDepreciationUntilDate, System.getProperty("line.separator"), this.mFaArea.getDeprStartDate(), this.mFaArea.getStatus().value(), this.mCalcMethodInterests});
            if (this.mCalcMethodInterests != null) {
                LOGGER.debug(this.mCalcMethodInterests.getCode());
            }
            LOGGER.debug("dch:{},mTriggerIsNewTransaction:{}", (Object)dch, (Object)this.mTriggerIsNewTransaction);
            if (dch != null) {
                LOGGER.debug("dch.getAccumAcquisitionValue():{},dch.getNetBookValue(){} ", (Object)dch.getAccumAcquisitionValue(), (Object)dch.getNetBookValue());
            }
            LOGGER.debug("mFaArea.getDepResValue():{},mFaArea.getDeprArea().getDepBelowZero():{},mFaArea.getResidualLifeInMonth():{},{} mFaArea.getDepBelowZero():{},baseForInterests{}", new Object[]{DepreciationCalculation.getDepResValue(this.mFaArea), this.mFaArea.getDeprArea().getDepBelowZero(), this.mFaArea.getResidualLifeInMonth(), System.getProperty("line.separator"), this.mFaArea.getDepBelowZero(), baseForInterests});
        }
        this.mLastInterest = false;
        if (this.mFaArea.getLastInterestCalcDate() != null && this.mDepreciationUntilDate != null) {
            this.mLastInterest = DateHelper.afterOrEqual((Date)this.mFaArea.getLastInterestCalcDate(), (Date)this.mDepreciationUntilDate);
        }
        if (this.mDeprArea.getImputedInterest() && !this.mStartDepr && !this.mLastInterest && this.mFaArea.getStatus().value() != 1 && this.mFaArea.getStatus().value() != 3 && this.mFaArea.getStatus().value() != 5 && (this.mFaArea.getStatus().value() != 7 || this.mDeprArea.getCalculative() || this.mDeprArea.getImputedInterest()) && this.mCalcMethodInterests != null && dch != null && (this.mTriggerIsNewTransaction || BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValue(), (BigDecimal)BigDecimal.ZERO) == 1 && (this.mCalcMethodInterests.getBaseForCalc().value() == 11 || BigDecimalMapper.compareTo((BigDecimal)baseForInterests, (BigDecimal)BigDecimal.ZERO) == 1 || this.mFaArea.getReplacementIndex() != null))) {
            this.calculateInterestsManager(this.mTransactCache, lastDeprDate);
            if (!counterUpdated) {
                ++processedCounter;
            }
            this.createOrUpdateFATransactions(this.mTransactCache, this.mFixedAsset, allDepreciations, this.mPrintDepreciationProtocol, this.mFinYearForFixedAsset);
            this.setLastInterestCalcDate(this.mTransactCache, this.mFaArea, this.mDepreciationUntilDate);
        } else {
            LOGGER.debug("   - Pr\u00fcfung negativ = keine Zins-Berechnung !");
            if (this.mTriggerIsNewTransaction && this.mIsTransactTypeIsDisposalOrRepost) {
                this.createOrUpdateFATransactions(this.mTransactCache, this.mFixedAsset, allDepreciations, this.mPrintDepreciationProtocol, this.mFinYearForFixedAsset);
            }
        }
    }

    public void cancelDepreciation(List<DepreciationPostingAndProtocolHelper> allDepreciations) throws BusinessDomainException {
        LOGGER.debug("cancelDepreciation(...)");
        this.mFromTransaction = false;
        this.mLastDepr = false;
        if (this.mFaArea.getLastDeprDate() != null) {
            this.mLastDepr = DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mCancellationUntilDate);
        }
        this.mLastInterest = false;
        if (this.mFaArea.getLastInterestCalcDate() != null) {
            this.mLastInterest = DateHelper.afterOrEqual((Date)this.mFaArea.getLastInterestCalcDate(), (Date)this.mCancellationUntilDate);
        }
        if (this.mCancellationUntilDate != null) {
            this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mCancellationUntilDate);
            if (this.mFaArea.getLastDeprDate() != null && this.mFaArea.getProcessingDate() != null) {
                this.mFinYearForFixedAsset = DateHelper.afterOrEqual((Date)this.mFaArea.getProcessingDate(), (Date)this.mFaArea.getLastDeprDate()) ? FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getProcessingDate()) : FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getLastDeprDate());
            } else if (this.mFaArea.getProcessingDate() != null) {
                this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getProcessingDate());
            } else if (this.mFaArea.getLastDeprDate() != null) {
                this.mFinYearForFixedAsset = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mFaArea.getLastDeprDate());
            }
        }
        SpecialReserve[] specialReserves = SpecialReserve.getSpecialReserves((FixedAssetArea)this.mFaArea);
        if ((this.mLastDepr || this.mDeprArea.getImputedInterest() && this.mLastInterest) && this.mFaArea.getStatus().value() != 1 && this.mFaArea.getStatus().value() != 3 && this.mFaArea.getStatus().value() != 5 || specialReserves.length > 0 || this.mFaArea.getStatus().value() == 7 && this.mDeprArea.getImputedInterest() && this.mDeprArea.getCalculative()) {
            List<DepreciationCalculationHelper> transactCache = this.buildTransactionsCache(null, null, null, false);
            ++processedCounter;
            this.createOrUpdateFATransactions(transactCache, this.mFixedAsset, allDepreciations, this.mPrintDepreciationProtocol, this.mFinYearForFixedAsset);
            boolean specRes = false;
            if (specialReserves.length > 0) {
                this.checkSpecialReserves(allDepreciations, specialReserves);
                specRes = true;
            }
            this.setLastDeprDate(transactCache, this.mFaArea, this.mCancellationUntilDate, specRes);
            if (this.mFaArea.getReplacementIndex() != null) {
                if (this.mFaArea.getReplacementIndex().getBaseForCalc().value() == 4) {
                    if (DateHelper.equal((Date)this.mCancellationUntilDate, (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                        this.setReplacementValue(transactCache, this.mFaArea, false);
                    }
                } else {
                    this.setReplacementValue(transactCache, this.mFaArea, false);
                }
            }
            this.setLastInterestCalcDate(transactCache, this.mFaArea, this.mCancellationUntilDate);
        } else {
            List<DepreciationCalculationHelper> transactCache = this.buildTransactionsCache(null, null, null, false);
            if (this.mFaArea.getReplacementIndex() != null && !this.mFaArea.getIsFullDisposed()) {
                if (this.mFaArea.getReplacementIndex().getBaseForCalc().value() == 4) {
                    if (DateHelper.equal((Date)this.mCancellationUntilDate, (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                        this.setReplacementValue(transactCache, this.mFaArea, true);
                    }
                } else {
                    this.setReplacementValue(transactCache, this.mFaArea, true);
                }
            }
        }
    }

    public List<DepreciationCalculationHelper> buildTransactionsCache(FixedAssetTransaction[] faTransactions) {
        return this.buildTransactionsCache(faTransactions, null, null, false);
    }

    public List<DepreciationCalculationHelper> buildTransactionsCache(FixedAssetTransaction[] faTransactions, BigDecimal exchangeRate, ICurrency targetCurrency, boolean sortWithDocumentDate) {
        LOGGER.debug("buildTransactionsCache(...)");
        if (this.mAASetup == null) {
            if (this.mFaArea != null) {
                this.mAASetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mFaArea.getFixedAsset().getAccountCompany());
            } else if (faTransactions != null && faTransactions.length > 0) {
                this.mAASetup = AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)faTransactions[0].getFixedAsset().getAccountCompany());
            }
        }
        if (faTransactions == null || faTransactions.length < 1) {
            faTransactions = FixedAssetTransactionPersistencyManager.getTransactions((FixedAssetArea)this.mFaArea, null, (boolean)sortWithDocumentDate, (AssetaccountingSetup)this.mAASetup);
        }
        if (sortWithDocumentDate) {
            Arrays.sort(faTransactions, FixedAssetTransaction.getFATDefaultComparatorDocumentDate());
        } else if (this.mAASetup != null && this.mAASetup.getNote().equals("SORT_NEW") || sortWithDocumentDate) {
            Arrays.sort(faTransactions, FixedAssetTransaction.getFATDefaultComparator());
        } else {
            Arrays.sort(faTransactions, FixedAssetTransaction.getFATDefaultComparatorOld());
        }
        ArrayList<DepreciationCalculationHelper> transactCache = new ArrayList<DepreciationCalculationHelper>(faTransactions.length);
        for (int i = 0; i < faTransactions.length; ++i) {
            DepreciationCalculationHelper dch = new DepreciationCalculationHelper();
            dch.setOidFATransaction(faTransactions[i].getObjectid());
            dch.setDocumentDate(faTransactions[i].getDocumentDate());
            dch.setProcessingDate(faTransactions[i].getProcessingDate());
            dch.setTransactionType(faTransactions[i].getTransactionEnum());
            dch.setFinancialYear(faTransactions[i].getFinancialYear());
            dch.setDeterminationDisposalValueType(faTransactions[i].getDeterminationDisposalValueType());
            if (exchangeRate != null) {
                dch.setAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getAmount(), exchangeRate));
                dch.setAmountNotRounded(targetCurrency.calculateConvertedAmount(faTransactions[i].getAmount(), exchangeRate));
                dch.setAcquisitionAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getAcquisitionAmount(), exchangeRate));
                dch.setDepreciationAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getDepreciationAmount(), exchangeRate));
                dch.setGrant(targetCurrency.calculateConvertedAmount(faTransactions[i].getGrant(), exchangeRate));
                dch.setReserveAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getReserveAmount(), exchangeRate));
                dch.setSalesAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getSalesAmount(), exchangeRate));
                dch.setPartDisposalNetBookValue(targetCurrency.calculateConvertedAmount(faTransactions[i].getPartDisposalNetBookValue(), exchangeRate));
                if (faTransactions[i].getTransactionEnum().value() == 1) {
                    if (faTransactions[i].getDeprArea().getCalculative() && faTransactions[i].getDeprArea().getImputedInterest()) {
                        dch.setInterestAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getSpecDepreciationAmount(), exchangeRate));
                        dch.setSpecDepreciationAmount(BigDecimal.ZERO);
                    } else {
                        dch.setSpecDepreciationAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getSpecDepreciationAmount(), exchangeRate));
                        dch.setInterestAmount(BigDecimal.ZERO);
                    }
                } else {
                    dch.setSpecDepreciationAmount(targetCurrency.calculateConvertedAmount(faTransactions[i].getSpecDepreciationAmount(), exchangeRate));
                    dch.setInterestAmount(BigDecimal.ZERO);
                }
            } else {
                dch.setAmount(faTransactions[i].getAmount());
                dch.setAmountNotRounded(faTransactions[i].getAmount());
                dch.setAcquisitionAmount(faTransactions[i].getAcquisitionAmount());
                dch.setDepreciationAmount(faTransactions[i].getDepreciationAmount());
                dch.setGrant(faTransactions[i].getGrant());
                dch.setReserveAmount(faTransactions[i].getReserveAmount());
                dch.setSalesAmount(faTransactions[i].getSalesAmount());
                dch.setPartDisposalNetBookValue(faTransactions[i].getPartDisposalNetBookValue());
                if (faTransactions[i].getTransactionEnum().value() == 1) {
                    if (faTransactions[i].getDeprArea().getCalculative() && faTransactions[i].getDeprArea().getImputedInterest()) {
                        dch.setInterestAmount(faTransactions[i].getSpecDepreciationAmount());
                        dch.setSpecDepreciationAmount(BigDecimal.ZERO);
                    } else {
                        dch.setSpecDepreciationAmount(faTransactions[i].getSpecDepreciationAmount());
                        dch.setInterestAmount(BigDecimal.ZERO);
                    }
                } else {
                    dch.setSpecDepreciationAmount(faTransactions[i].getSpecDepreciationAmount());
                    dch.setInterestAmount(BigDecimal.ZERO);
                }
            }
            dch.setPartDisposalPercent(faTransactions[i].getPartDisposalPercent());
            dch.setIsBooked(faTransactions[i].getIsBooked());
            dch.setIsCanceled(faTransactions[i].getIsCanceled());
            dch.setIsCancelation(faTransactions[i].getIsCancelation());
            dch.setIsPersistent(true);
            dch.setBaseForReducingBalanceDepreciation(faTransactions[i].getNetBookValueBeginFY());
            dch.setLastDeprDate(faTransactions[i].getLastDeprDate());
            dch.setLastInterestCalcDate(faTransactions[i].getLastDeprDate());
            dch.setIndex(i);
            dch.setUsefullLifeInMonth((int)this.mFaArea.getUsefullLifeInMonth());
            dch.setUsefullLifeInDays(this.getUsefullLifeInDays());
            dch.setDeprStartDate(this.mFaArea.getDeprStartDate());
            dch.setOidFixedAsset(faTransactions[i].getFixedAsset().getObjectid());
            dch.setDerivation(faTransactions[i].getDerivation());
            dch.setBasedOnExternalAudit(faTransactions[i].getBasedOnExternalAudit());
            dch.setAnalysisCodes(faTransactions[i].getAnalysisCodes());
            dch.setWithDisposalDepr(faTransactions[i].getWithDisposalDepr());
            dch.setNoDeprCorrection(false);
            dch.setNote(faTransactions[i].getNote());
            if (faTransactions[i].getTransactionEnum().value() == 4) {
                if (exchangeRate != null) {
                    dch.setAccumAutomDeprValueDisposalForPosting(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumDepr(), exchangeRate));
                    dch.setAccumAutomSpecDeprValueDisposalForPosting(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumSpecDepr(), exchangeRate));
                    dch.setAccumGrantDisposalForPosting(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumGrant(), exchangeRate));
                    dch.setAccumWriteUpDisposalForPosting(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteUp(), exchangeRate));
                    dch.setAccumWriteDownDisposalForPosting(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteDown(), exchangeRate));
                } else {
                    dch.setAccumAutomDeprValueDisposalForPosting(faTransactions[i].getAccumDepr());
                    dch.setAccumAutomSpecDeprValueDisposalForPosting(faTransactions[i].getAccumSpecDepr());
                    dch.setAccumGrantDisposalForPosting(faTransactions[i].getAccumGrant());
                    dch.setAccumWriteUpDisposalForPosting(faTransactions[i].getAccumWriteUp());
                    dch.setAccumWriteDownDisposalForPosting(faTransactions[i].getAccumWriteDown());
                }
            }
            if (faTransactions[i].getTransactionEnum().value() == 19 && faTransactions[i].getDerivation().equals("Import Guide")) {
                if (exchangeRate != null) {
                    dch.setAutomDeprValueDisposal(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumDepr(), exchangeRate));
                } else {
                    dch.setAutomDeprValueDisposal(faTransactions[i].getAccumDepr());
                }
            }
            if (faTransactions[i].getTransactionEnum().value() == 25) {
                if (exchangeRate != null) {
                    dch.setAutomDeprValueRepostAddition(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumDepr(), exchangeRate));
                    dch.setAutomSpecDeprValueRepostAddition(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumSpecDepr(), exchangeRate));
                    dch.setGrantRepostAddition(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumGrant(), exchangeRate));
                    dch.setWriteUpRepostAddition(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteUp(), exchangeRate));
                    dch.setWriteDownRepostAddition(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteDown(), exchangeRate));
                } else {
                    dch.setAutomDeprValueRepostAddition(faTransactions[i].getAccumDepr());
                    dch.setAutomSpecDeprValueRepostAddition(faTransactions[i].getAccumSpecDepr());
                    dch.setGrantRepostAddition(faTransactions[i].getAccumGrant());
                    dch.setWriteUpRepostAddition(faTransactions[i].getAccumWriteUp());
                    dch.setWriteDownRepostAddition(faTransactions[i].getAccumWriteDown());
                }
            }
            if (faTransactions[i].getTransactionEnum().value() == 6 || faTransactions[i].getTransactionEnum().value() == 5) {
                if (exchangeRate != null) {
                    dch.setAutomDeprValueRepost(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumDepr(), exchangeRate));
                    dch.setAutomSpecDeprValueRepost(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumSpecDepr(), exchangeRate));
                    dch.setGrantRepost(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumGrant(), exchangeRate));
                    dch.setWriteUpRepost(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteUp(), exchangeRate));
                    dch.setWriteDownRepost(targetCurrency.calculateConvertedAmount(faTransactions[i].getAccumWriteDown(), exchangeRate));
                } else {
                    dch.setAutomDeprValueRepost(faTransactions[i].getAccumDepr());
                    dch.setAutomSpecDeprValueRepost(faTransactions[i].getAccumSpecDepr());
                    dch.setGrantRepost(faTransactions[i].getAccumGrant());
                    dch.setWriteUpRepost(faTransactions[i].getAccumWriteUp());
                    dch.setWriteDownRepost(faTransactions[i].getAccumWriteDown());
                }
            }
            if (faTransactions[i].getFixedAssetTransferFrom() != null) {
                dch.setOidFixedAssetTransferFrom(faTransactions[i].getFixedAssetTransferFrom().getObjectid());
            } else {
                dch.setOidFixedAssetTransferFrom("");
            }
            if (faTransactions[i].getFixedAssetTransferTo() != null) {
                dch.setOidFixedAssetTransferTo(faTransactions[i].getFixedAssetTransferTo().getObjectid());
            } else {
                dch.setOidFixedAssetTransferTo("");
            }
            dch.setFullDisposalDeprUntilType(faTransactions[i].getFullDisposDeprecUntil());
            if (this.mFunction.value() == 1) {
                FAFinancialPeriod finPeriod;
                boolean periodIsClosed = faTransactions[i].getFinancialYear().getYearClosed();
                if (!periodIsClosed && (finPeriod = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])faTransactions[i].getFinancialYear().getFinancialPeriods(), (Date)faTransactions[i].getProcessingDate())) != null) {
                    FAFinancialPeriodDetail detail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod.getFinancialPeriodDetails(), (DepreciationArea)faTransactions[i].getDeprArea());
                    periodIsClosed = detail.getDeprAreaClosed();
                }
                if (DateHelper.afterOrEqual((Date)faTransactions[i].getProcessingDate(), (Date)this.mCancellationUntilDate) && !periodIsClosed) {
                    if (!(faTransactions[i].getTransactionEnum().value() != 10 && faTransactions[i].getTransactionEnum().value() != 12 && faTransactions[i].getTransactionEnum().value() != 18 || faTransactions[i].getIsCancelation() || faTransactions[i].getIsCanceled())) {
                        dch.setMakeCancelation(true);
                        dch.setMakePersistent(true);
                    }
                    if (faTransactions[i].getTransactionEnum().value() == 20 || faTransactions[i].getTransactionEnum().value() == 19) {
                        dch.setMakeCancelation(true);
                        dch.setMakePersistent(true);
                    }
                }
            } else {
                dch.setMakeCancelation(false);
                dch.setMakePersistent(false);
            }
            transactCache.add(dch);
        }
        DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
        DepreciationCalculation.transactionsFillAccumValues(faTransactions, transactCache);
        return transactCache;
    }

    private List<DepreciationCalculationHelper> calculateDepreciationsManager(List<DepreciationCalculationHelper> transactCache) throws BusinessDomainException {
        int i;
        LOGGER.debug("calculateDepreciationsManager(...)");
        if (transactCache == null || transactCache.size() < 1) {
            return new ArrayList<DepreciationCalculationHelper>();
        }
        DepreciationCalculationHelper dch = null;
        int resLifeInMonth = this.mFaArea.getResidualLifeInMonth();
        int indexLastClosedFinYear = -1;
        this.mDeprMethodHasChanged = false;
        if (this.mFinYears == null) {
            this.mFinYears = DepreciationCalculation.getFAFinancialYears(this.mCompany, this.mIsDeprPreview, this.mPreviewUntilDate);
        }
        Date fullDisposalDate = null;
        for (i = 0; i < this.mFinYears.length; ++i) {
            if (!this.mFinYears[i].getYearClosed()) continue;
            indexLastClosedFinYear = i;
        }
        for (i = indexLastClosedFinYear + 1; i < this.mFinYears.length && !this.mFinYears[i].getValidFrom().after(this.mDepreciationUntilDate); ++i) {
            DepreciationMethodData deprMethod;
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)this.mFinYears[i].getValidUntil()) || this.mFaArea.getLastDeprDate() != null && (this.mFaArea.getProcessingDate() == null || this.mFromTransaction || !DateHelper.after((Date)this.mFaArea.getProcessingDate(), (Date)this.mFaArea.getLastDeprDate()) ? this.mFromTransaction && this.mIsTransactTypeIsDisposalOrRepost && this.mFaArea.getProcessingDate() != null && DateHelper.after((Date)this.mFaArea.getProcessingDate(), (Date)this.mFaArea.getLastDeprDate()) && DateHelper.after((Date)DateHelper.getLastDayOfMonth((Date)this.mDocumentDate), (Date)this.mFinYears[i].getValidUntil()) || DateHelper.afterOrEqual((Date)this.mFaArea.getLastDeprDate(), (Date)this.mFinYears[i].getValidUntil()) : DateHelper.afterOrEqual((Date)this.mFaArea.getProcessingDate(), (Date)this.mFinYears[i].getValidUntil()))) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("process the years, current year: {}", (Object)this.mFinYears[i].getCode());
            }
            dch = this.mFaArea.getDeprStartDate() != null && DateHelper.afterOrEqual((Date)this.mFaArea.getDeprStartDate(), (Date)this.mFinYears[i].getValidFrom()) ? (this.mJurisdiction_AT && this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR && DateHelper.before((Date)this.mFaArea.getDeprStartDate(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mFixedAsset.getAcquisitionDate())) ? DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDateAT(transactCache, DateHelper.getFirstDayOfMonth((Date)this.mFaArea.getDeprStartDate()), false) : DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, DateHelper.yesterday((Date)this.mFaArea.getDeprStartDate()), false, false)) : DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, DateHelper.yesterday((Date)this.mFinYears[i].getValidFrom()), false, false);
            if (dch == null) {
                int a = 0;
                while (((dch = transactCache.get(a)).getIsCancelation() || dch.getIsCanceled()) && ++a < transactCache.size()) {
                }
                if (dch.getTransactionType().value() != 0 && dch.getTransactionType().value() != 1 && dch.getTransactionType().value() != 2 && dch.getTransactionType().value() != 3) {
                    dch.setAccumAcquisitionValue(BigDecimal.ZERO);
                    dch.setNetBookValue(BigDecimal.ZERO);
                }
            }
            FAFinancialPeriod[] finPeriods = this.mFinYears[i].getFinancialPeriods();
            this.indexOfDeprStartPeriod = 0;
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)this.mFinYears[i].getValidFrom())) {
                this.indexOfDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)this.mFaArea.getDeprStartDate());
            }
            if (dch.getLastDeprDate() != null && DateHelper.after((Date)dch.getLastDeprDate(), (Date)this.mFinYears[i].getValidFrom())) {
                this.indexOfDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)dch.getLastDeprDate())));
            }
            if (this.indexOfDeprStartPeriod == -1) continue;
            BigDecimal[][] periodValues = new BigDecimal[finPeriods.length + 1][4];
            for (int j = 0; j < periodValues.length; ++j) {
                periodValues[j][0] = BigDecimal.ZERO;
                periodValues[j][1] = new BigDecimal("0.000000000000000000");
                periodValues[j][2] = BigDecimal.ZERO;
                periodValues[j][3] = new BigDecimal("0.000000000000000000");
            }
            int lastMonthForDepr = finPeriods.length - 1;
            Date disposalDate = null;
            if (this.mFaArea.getIsFullDisposed() && this.mFaArea.getRetirementDate() != null && DateHelper.between((Date)this.mFaArea.getRetirementDate(), (Date)this.mFinYears[i].getValidFrom(), (Date)this.mFinYears[i].getValidUntil())) {
                disposalDate = DepreciationCalculation.getDisposalDate(transactCache, this.mFinYears[i].getValidFrom(), this.mFinYears[i].getValidUntil());
                if (disposalDate == null) {
                    disposalDate = this.mFaArea.getRetirementDate();
                    switch (this.mDeprArea.getCompleteRetirement().value()) {
                        case 0: {
                            disposalDate = DateHelper.yesterday((Date)this.mFinYears[i].getValidFrom());
                            break;
                        }
                        case 1: {
                            disposalDate = DateHelper.yesterday((Date)this.mFaArea.getRetirementDate());
                            break;
                        }
                        case 2: {
                            disposalDate = DateHelper.getLastDayOfMonth((Date)this.mFaArea.getRetirementDate());
                            break;
                        }
                        case 3: {
                            disposalDate = this.mFinYears[i].getValidUntil();
                            break;
                        }
                        case 4: {
                            disposalDate = DateHelper.getLastDayOfHalfYear((Date)this.mFaArea.getRetirementDate());
                            break;
                        }
                        case 5: {
                            disposalDate = this.mFaArea.getRetirementDate();
                            break;
                        }
                        case 6: {
                            disposalDate = DateHelper.getLastDayOfMonth((Date)this.mFaArea.getRetirementDate());
                            break;
                        }
                        case 7: {
                            disposalDate = this.mFaArea.getRetirementDate();
                        }
                    }
                }
                lastMonthForDepr = this.mFinYears[i].getFAFinancialPeriodIndexForDate(disposalDate);
            }
            this.perfUnit = null;
            this.periodUnits = null;
            if (this.mCalcMethod.getMethodTypeEnum().value() == 0 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getDepreciationType().value() == 3) {
                this.perfUnit = PerformanceUnits.getPerformanceUnitForYear((FixedAssetArea)this.mFaArea, (FAFinancialYear)this.mFinYears[i]);
                if (this.perfUnit != null) {
                    this.periodUnits = PeriodUnits.getPeriodUnitsForDeprCalc((PerformanceUnits)this.perfUnit);
                }
            }
            if (this.mCalcMethod instanceof DepreciationMethodData && (dch.getResLifeInMonth() > 0 || this.mDeprArea.getCalculative())) {
                BigDecimal maxDeprAmount;
                BigDecimal baseForDeprAmount;
                DepreciationMethodData nextDeprMethod;
                if (((DepreciationMethodData)this.mCalcMethod).getChangeover().value() == 2 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getNextDepreciationMethod() != null) {
                    BigDecimal newDeprPercent = BigDecimal.ZERO;
                    BigDecimal oldDeprPercent = this.mFaArea.getDepreciationPercent();
                    DepreciationMethodData followingDeprMethod = (DepreciationMethodData)deprMethod.getNextDepreciationMethod();
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)oldDeprPercent)) {
                        oldDeprPercent = deprMethod.getPercentage();
                    }
                    if (followingDeprMethod.getDepreciationType().value() == 2) {
                        if (dch.getResLifeInMonth() > 0) {
                            double calcBase = 1200.0;
                            double resLifeinMonth = dch.getResLifeInMonth();
                            double percentage = 1200.0 / resLifeinMonth;
                            newDeprPercent = new BigDecimal(percentage);
                            newDeprPercent = newDeprPercent.setScale(2, RoundingMode.HALF_EVEN);
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)newDeprPercent, (BigDecimal)oldDeprPercent) > 0) {
                            this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                            this.mNewDepreciationPercent = newDeprPercent;
                        }
                    } else {
                        boolean newDeprMethod = false;
                        DepreciationMethodData deprMethodCheck = deprMethod;
                        BigDecimal yearDeprAmountOldMethod = this.calculateDepreciationForCheck(this.mFinYears[i], finPeriods, this.indexOfDeprStartPeriod, newDeprMethod, deprMethodCheck, dch);
                        newDeprMethod = true;
                        deprMethodCheck = (DepreciationMethodData)deprMethod.getNextDepreciationMethod();
                        BigDecimal yearDeprAmountNewMethod = this.calculateDepreciationForCheck(this.mFinYears[i], finPeriods, this.indexOfDeprStartPeriod, newDeprMethod, deprMethodCheck, dch);
                        if (BigDecimalMapper.compareTo((BigDecimal)yearDeprAmountNewMethod, (BigDecimal)yearDeprAmountOldMethod) > 0) {
                            this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                            this.mDeprMethodHasChanged = true;
                        }
                    }
                }
                if (((DepreciationMethodData)this.mCalcMethod).getChangeover().value() == 4 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getNextDepreciationMethod() != null && BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)deprMethod.getRestValueChangeover()) < 0) {
                    this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                    nextDeprMethod = (DepreciationMethodData)this.mCalcMethod;
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)nextDeprMethod.getPercentage())) {
                        this.mNewDepreciationPercent = nextDeprMethod.getPercentage();
                        this.mDeprMethodHasChanged = true;
                    }
                }
                if (((DepreciationMethodData)this.mCalcMethod).getChangeover().value() == 3 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getNextDepreciationMethod() != null && this.mFaArea.getDeprArea().getDepBelowZero() && this.mFaArea.getDepBelowZero() && BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)BigDecimalMapper.ZERO) < 0) {
                    this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                    nextDeprMethod = (DepreciationMethodData)this.mCalcMethod;
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)nextDeprMethod.getPercentage())) {
                        this.mNewDepreciationPercent = nextDeprMethod.getPercentage();
                        this.mDeprMethodHasChanged = true;
                    }
                }
                if (((DepreciationMethodData)this.mCalcMethod).getChangeover().value() == 5 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getNextDepreciationMethod() != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethod.getPercentChangeover()) && BigDecimalMapper.compareTo((BigDecimal)(baseForDeprAmount = DepreciationCalculation.getBaseForDepreciation(dch, (CalcMethod)deprMethod, this.mFaArea, finPeriods[this.indexOfDeprStartPeriod].getValidUntil(), this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage)), (BigDecimal)(maxDeprAmount = baseForDeprAmount.multiply(deprMethod.getPercentChangeover()).divide(HUNDRED, 2, RoundingMode.HALF_EVEN))) > 0) {
                    BigDecimal minNetBookValue = baseForDeprAmount.subtract(maxDeprAmount);
                    if (BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)minNetBookValue) <= 0) {
                        this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                        DepreciationMethodData nextDeprMethod2 = (DepreciationMethodData)this.mCalcMethod;
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)nextDeprMethod2.getPercentage())) {
                            this.mNewDepreciationPercent = nextDeprMethod2.getPercentage();
                            this.mDeprMethodHasChanged = true;
                        }
                    }
                }
                if (((DepreciationMethodData)this.mCalcMethod).getChangeover().value() == 1 && (deprMethod = (DepreciationMethodData)this.mCalcMethod).getNextDepreciationMethod() != null && (deprMethod.getPeriodInMonth() > 0 || deprMethod.getPeriodInYears() > 0)) {
                    int methodPeriodInMonth = deprMethod.getPeriodInYears() * 12 + deprMethod.getPeriodInMonth();
                    int deprPeriodInMonth = dch.getUsefullLifeInMonth() - dch.getResLifeInMonth();
                    if (deprPeriodInMonth >= methodPeriodInMonth) {
                        this.mCalcMethod = deprMethod.getNextDepreciationMethod();
                        DepreciationMethodData nextDeprMethod3 = (DepreciationMethodData)this.mCalcMethod;
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)nextDeprMethod3.getPercentage())) {
                            this.mNewDepreciationPercent = nextDeprMethod3.getPercentage();
                            this.mDeprMethodHasChanged = true;
                        }
                    }
                }
            }
            if (!this.mNoCalculation) {
                this.calculateDepreciation(this.mFinYears[i], finPeriods, this.indexOfDeprStartPeriod, periodValues, dch, transactCache);
            }
            boolean fullDisposal = false;
            DepreciationCalculationHelper lastDchs = null;
            DepreciationCalculationHelper disposalDch = null;
            for (int j = this.indexOfDeprStartPeriod; j < finPeriods.length && !finPeriods[j].getValidUntil().after(this.mDepreciationUntilDate) && !fullDisposal; ++j) {
                int k;
                FAFinancialPeriodDetail detail;
                FAFinancialPeriod finPeriod;
                if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)finPeriods[j].getValidUntil())) continue;
                boolean periodIsClosed = dch.getFinancialYear().getYearClosed();
                if (!periodIsClosed && (finPeriod = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])dch.getFinancialYear().getFinancialPeriods(), (Date)dch.getProcessingDate())) != null && (detail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null) {
                    periodIsClosed = detail.getDeprAreaClosed();
                }
                DepreciationCalculationHelper[] dchs = DepreciationCalculation.getDeprCalcHelperForPeriod(transactCache, finPeriods[j]);
                disposalDch = null;
                boolean newDeprTransact = true;
                boolean newSpecDeprTransact = true;
                boolean newDeprTransactForDisposalMonth = false;
                for (k = 0; k < dchs.length; ++k) {
                    FAFinancialPeriodDetail periodDetail;
                    FAFinancialPeriod finPeriod2;
                    if (dchs[k].getIsCancelation() || dchs[k].getIsCanceled()) continue;
                    if (dchs[k].getProcessingDate() != null && (finPeriod2 = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])dchs[k].getFinancialYear().getFinancialPeriods(), (Date)dchs[k].getProcessingDate())) != null && (periodDetail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod2.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null) {
                        periodIsClosed = periodDetail.getDeprAreaClosed();
                    }
                    if (dchs[k].getProcessingDate() != null && DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate()) != null && DateHelper.before((Date)dchs[k].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate()))) {
                        if (dchs[k].getTransactionType().value() == 2 || dchs[k].getTransactionType().value() == 3 || dchs[k].getTransactionType().value() == 4 || dchs[k].getTransactionType().value() == 19 || dchs[k].getTransactionType().value() == 5 || dchs[k].getTransactionType().value() == 25 || dchs[k].getTransactionType().value() == 11 || dchs[k].getTransactionType().value() == 13 || dchs[k].getTransactionType().value() == 7 || dchs[k].getTransactionType().value() == 14 || dchs[k].getTransactionType().value() == 15 || dchs[k].getTransactionType().value() == 26 || dchs[k].getTransactionType().value() == 6 && dchs[k].getOidFixedAsset().equals(dchs[k].getOidFixedAssetTransferTo())) {
                            if (this.mDeprArea.getDepreciationFrequencies().value() == 1 && (dchs[k].getTransactionType().value() == 2 || dchs[k].getTransactionType().value() == 3 || dchs[k].getTransactionType().value() == 4)) {
                                for (int l = 0; l < periodValues.length; ++l) {
                                    periodValues[l][0] = DepreciationCalculation.roundingAmount(periodValues[l][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                                }
                            }
                            if (dchs[k].getTransactionType().value() == 19 || dchs[k].getTransactionType().value() == 25 || dchs[k].getTransactionType().value() == 5) {
                                dchs[k].setMakePersistent(true);
                                if (BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAccumAcquisitionValue())) {
                                    for (int l = j; l < periodValues.length; ++l) {
                                        periodValues[l][0] = BigDecimal.ZERO;
                                        periodValues[l][1] = new BigDecimal("0.000000000000000000");
                                        periodValues[l][2] = BigDecimal.ZERO;
                                        periodValues[l][3] = new BigDecimal("0.000000000000000000");
                                    }
                                } else {
                                    this.calculateDepreciation(this.mFinYears[i], finPeriods, j, periodValues, dchs[k], transactCache);
                                }
                            } else {
                                this.calculateDepreciation(this.mFinYears[i], finPeriods, j, periodValues, dchs[k], transactCache);
                            }
                        } else if (dchs[k].getTransactionType().value() == 20) {
                            fullDisposalDate = dchs[k].getProcessingDate();
                            disposalDch = dchs[k];
                            if (fullDisposalDate != null && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)fullDisposalDate) && lastDchs != null) {
                                this.calculateDepreciation(this.mFinYears[i], finPeriods, j, periodValues, lastDchs, transactCache);
                            }
                            if (this.mTriggerIsNewTransaction) {
                                if (fullDisposalDate != null) {
                                    if ((dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE || dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_POSTING_DATE) && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)fullDisposalDate)) {
                                        newDeprTransactForDisposalMonth = true;
                                    }
                                    if (dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_BEGIN_MONTH && this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0 && DateHelper.equal((Date)finPeriods[j].getValidFrom(), (Date)fullDisposalDate)) {
                                        newDeprTransactForDisposalMonth = true;
                                    }
                                    this.cancelAllFollowingTransactions(transactCache, fullDisposalDate, false);
                                } else {
                                    Date technDispDate = DepreciationCalculation.calculateTechnicalDisposalDate(this.mFinYears[i], finPeriods[j], this.mDeprArea, fullDisposalDate);
                                    if ((dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE || dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_POSTING_DATE) && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)technDispDate)) {
                                        newDeprTransactForDisposalMonth = true;
                                    }
                                    if (dchs[k].getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_BEGIN_MONTH && this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0 && DateHelper.equal((Date)finPeriods[j].getValidFrom(), (Date)technDispDate)) {
                                        newDeprTransactForDisposalMonth = true;
                                    }
                                    this.cancelAllFollowingTransactions(transactCache, technDispDate, false);
                                }
                            }
                            fullDisposal = true;
                            dchs[k].setMakePersistent(true);
                        } else if (dchs[k].getTransactionType().value() == 6 && dchs[k].getOidFixedAsset().equals(dchs[k].getOidFixedAssetTransferFrom())) {
                            if (dchs[k].getProcessingDate() != null && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)dchs[k].getProcessingDate()) && lastDchs != null) {
                                this.calculateDepreciation(this.mFinYears[i], finPeriods, j, periodValues, lastDchs, transactCache);
                            }
                            if (this.mTriggerIsNewTransaction) {
                                this.cancelAllFollowingTransactions(transactCache, dchs[k].getProcessingDate(), false);
                            }
                            dchs[k].setMakePersistent(true);
                            for (int l = j; l < periodValues.length; ++l) {
                                periodValues[l][0] = BigDecimal.ZERO;
                                periodValues[l][1] = new BigDecimal("0.000000000000000000");
                                periodValues[l][2] = BigDecimal.ZERO;
                                periodValues[l][3] = new BigDecimal("0.000000000000000000");
                            }
                        } else if (dchs[k].getTransactionType().value() == 10) {
                            boolean isFullDisposal = false;
                            for (int l = 0; l < dchs.length; ++l) {
                                if (dchs[l].getIsCancelation() || dchs[l].getIsCanceled() || dchs[l].getTransactionType().value() != 20) continue;
                                isFullDisposal = true;
                                if (!DateHelper.between((Date)dchs[l].getProcessingDate(), (Date)finPeriods[j].getValidFrom(), (Date)finPeriods[j].getValidUntil()) || !DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)dchs[l].getProcessingDate()) || BigDecimalMapper.compareTo((BigDecimal)periodValues[j][0], (BigDecimal)BigDecimal.ZERO) <= 0) break;
                                VDate lastDay = new VDate(finPeriods[j].getValidUntil());
                                VDate processingDay = new VDate(dchs[l].getProcessingDate());
                                periodValues[j][1] = periodValues[j][0].divide(new BigDecimal(lastDay.getDay()), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(processingDay.getDay()));
                                periodValues[j][0] = DepreciationCalculation.roundingAmount(periodValues[j][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                                break;
                            }
                            if (!isFullDisposal) {
                                dchs[k].setProcessingDate(finPeriods[j].getValidUntil());
                            }
                        }
                    } else if (!(!ISoftware.getDepreciationForAdditionsWithValueLastDayOfMonth() && dchs[k].getResLifeInMonth() + j > finPeriods.length || dchs[k].getProcessingDate() == null || DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate()) == null || !DateHelper.equal((Date)dchs[k].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate())) || this.mJurisdiction_PL && this.mDeprArea.getCalcRemLifeForPostCapitalization() || dchs[k].getTransactionType().value() != 2 && dchs[k].getTransactionType().value() != 3 && dchs[k].getTransactionType().value() != 4 && dchs[k].getTransactionType().value() != 26 && dchs[k].getTransactionType().value() != 5 && dchs[k].getTransactionType().value() != 25 && (dchs[k].getTransactionType().value() != 6 || !dchs[k].getOidFixedAsset().equals(dchs[k].getOidFixedAssetTransferTo())))) {
                        if (dchs[k].getResLifeInMonth() + j <= finPeriods.length) {
                            dchs[k].setResLifeInMonth(dchs[k].getResLifeInMonth() + 1);
                        }
                        this.calculateDepreciation(this.mFinYears[i], finPeriods, j, periodValues, dchs[k], transactCache);
                        if (dchs[k].getTransactionType().value() == 25) {
                            dchs[k].setProcessingDate(DateHelper.yesterday((Date)dchs[k].getProcessingDate()));
                            dchs[k].setMakePersistent(true);
                        }
                    } else if (dchs[k].getProcessingDate() != null && DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate()) != null && DateHelper.equal((Date)dchs[k].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate())) && dchs[k].getTransactionType().value() == 20 && this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0) {
                        fullDisposal = true;
                        fullDisposalDate = dchs[k].getProcessingDate();
                        dchs[k].setMakePersistent(true);
                        if (this.mTriggerIsNewTransaction) {
                            for (int l = 0; l < dchs.length; ++l) {
                                if (dchs[l].getIsCancelation() || dchs[l].getIsCanceled() || dchs[l].getTransactionType().value() != 10) continue;
                                periodValues[j][1] = periodValues[j][0].add(DepreciationCalculation.getDepResValue(this.mFaArea));
                                periodValues[j][0] = periodValues[j][1];
                                dchs[l].setAmount(periodValues[j][0]);
                                dchs[l].setMakePersistent(true);
                            }
                        }
                    }
                    if (dchs[k].getTransactionType().value() == 10) {
                        newDeprTransact = false;
                        if (dchs[k].getAmount().compareTo(periodValues[j][0]) != 0 && !periodIsClosed) {
                            dchs[k].setAmount(periodValues[j][0]);
                            dchs[k].setMakePersistent(true);
                            if (BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAmount())) {
                                dchs[k].setMakeCancelation(true);
                            }
                            DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                        }
                    } else if (dchs[k].getTransactionType().value() == 11) {
                        newDeprTransact = false;
                    } else if (dchs[k].getTransactionType().value() == 12) {
                        newSpecDeprTransact = false;
                        if (dchs[k].getAmount().compareTo(periodValues[j][2]) != 0) {
                            dchs[k].setAmount(periodValues[j][2]);
                            dchs[k].setMakePersistent(true);
                            if (BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAmount())) {
                                dchs[k].setMakeCancelation(true);
                            }
                            DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                        }
                    } else if (dchs[k].getTransactionType().value() == 13) {
                        newSpecDeprTransact = false;
                    }
                    lastDchs = dchs[k];
                }
                if (this.mCalcMethod instanceof DepreciationMethodData && ((DepreciationMethodData)this.mCalcMethod).getDepreciationType().value() == 3 && this.perfUnit != null && !StringMapper.isNullString((String)this.periodUnits[j].getObjectid())) {
                    this.periodUnits[j].makeSaveable();
                    this.periodUnits[j].setIsDepreciated(true);
                    this.periodUnits[j].setDepreciation(periodValues[j][0]);
                }
                if (this.mFaArea.getIsFullDisposed() && this.mFromTransaction && newDeprTransactForDisposalMonth && disposalDch != null && fullDisposalDate != null && DateHelper.between(fullDisposalDate, (Date)finPeriods[j].getValidFrom(), (Date)finPeriods[j].getValidUntil()) && (disposalDch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE || disposalDch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_POSTING_DATE || disposalDch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_BEGIN_MONTH)) {
                    newDeprTransact = true;
                }
                if (newDeprTransact) {
                    if (this.mFaArea.getIsFullDisposed() && fullDisposalDate != null && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)DateHelper.getLastDayOfMonth(fullDisposalDate)) && (lastDchs == null || lastDchs.getTransactionType().value() != 20)) {
                        LOGGER.debug("No depreciation for Periods after the full disposal Period");
                    } else if (this.mFaArea.getIsFullDisposed() && fullDisposalDate != null && DateHelper.after((Date)finPeriods[j].getValidUntil(), fullDisposalDate) && lastDchs != null && lastDchs.getTransactionType().value() == 20 && (lastDchs.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE && lastDchs.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_POSTING_DATE && !this.mDeprArea.getDeprToResValueFullDisposal() || lastDchs.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE && lastDchs.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_POSTING_DATE && this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) == 0)) {
                        LOGGER.debug("No depreciation for Period with full disposal");
                    } else if (BigDecimalMapper.compareTo((BigDecimal)periodValues[j][0], (BigDecimal)BigDecimal.ZERO) < 0) {
                        LOGGER.debug("No transaction for negative depreciation amount");
                    } else {
                        FAFinancialPeriodDetail detail2;
                        FAFinancialPeriod finPeriodDisposal;
                        DepreciationCalculationHelper newDepr = new DepreciationCalculationHelper();
                        newDepr.setProcessingDate(finPeriods[j].getValidUntil());
                        newDepr.setDocumentDate(this.mDocumentDate);
                        if (fullDisposalDate != null) {
                            if (DateHelper.after((Date)newDepr.getProcessingDate(), fullDisposalDate)) {
                                newDepr.setProcessingDate(fullDisposalDate);
                                if (this.mFaArea.getResidualLifeInMonth() != 0 || !this.mFromTransaction || !this.mIsTransactTypeIsDisposalOrRepost) {
                                    if (disposalDch != null && (disposalDch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE || disposalDch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_POSTING_DATE)) {
                                        if (BigDecimalMapper.compareTo((BigDecimal)periodValues[j][0], (BigDecimal)BigDecimal.ZERO) > 0) {
                                            VDate lastDay = new VDate(finPeriods[j].getValidUntil());
                                            VDate processingDay = new VDate(fullDisposalDate);
                                            if (this.mDeprArea.getDepreciationFrequencies().value() == 1) {
                                                periodValues[j][0] = periodValues[j][0].subtract(periodValues[j][1]);
                                                if (BigDecimalMapper.compareTo((BigDecimal)periodValues[j][0], (BigDecimal)BigDecimal.ZERO) < 0) {
                                                    periodValues[j][0] = BigDecimal.ZERO;
                                                }
                                                periodValues[j][1] = periodValues[j][1].divide(new BigDecimal(lastDay.getDay()), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(processingDay.getDay()));
                                                periodValues[j][0] = DepreciationCalculation.roundingAmount(periodValues[j][0].add(periodValues[j][1]), this.mFaArea.getDeprArea().getRoundingDep().value());
                                            } else {
                                                periodValues[j][1] = periodValues[j][0].divide(new BigDecimal(lastDay.getDay()), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(processingDay.getDay()));
                                                periodValues[j][0] = DepreciationCalculation.roundingAmount(periodValues[j][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                                            }
                                        }
                                        if (this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0) {
                                            periodValues[j][1] = periodValues[j][0].add(DepreciationCalculation.getDepResValue(this.mFaArea));
                                            periodValues[j][0] = periodValues[j][1];
                                        }
                                    } else if (this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0) {
                                        periodValues[j][1] = DepreciationCalculation.getDepResValue(this.mFaArea);
                                        periodValues[j][0] = periodValues[j][1];
                                    }
                                } else if (this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0) {
                                    periodValues[j][1] = periodValues[j][0].add(DepreciationCalculation.getDepResValue(this.mFaArea));
                                    periodValues[j][0] = periodValues[j][1];
                                }
                            } else if (this.mDeprArea.getDeprToResValueFullDisposal() && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)BigDecimal.ZERO) > 0) {
                                periodValues[j][1] = periodValues[j][0].add(DepreciationCalculation.getDepResValue(this.mFaArea));
                                periodValues[j][0] = periodValues[j][1];
                            }
                        }
                        newDepr.setTransactionType(TransactionEnum.TRE_AUTOMATIC_DEPR);
                        newDepr.setFinancialYear(this.mFinYears[i]);
                        newDepr.setQuantity("");
                        newDepr.setAmount(periodValues[j][0]);
                        newDepr.setAmountNotRounded(periodValues[j][1]);
                        newDepr.setAcquisitionAmount(BigDecimal.ZERO);
                        newDepr.setDepreciationAmount(BigDecimal.ZERO);
                        newDepr.setSpecDepreciationAmount(BigDecimal.ZERO);
                        newDepr.setInterestAmount(BigDecimal.ZERO);
                        newDepr.setGrant(BigDecimal.ZERO);
                        newDepr.setPartDisposalPercent(BigDecimal.ZERO);
                        newDepr.setPartDisposalNetBookValue(BigDecimal.ZERO);
                        newDepr.setReserveAmount(BigDecimal.ZERO);
                        newDepr.setSalesAmount(BigDecimal.ZERO);
                        newDepr.setBaseForReducingBalanceDepreciation(BigDecimal.ZERO);
                        newDepr.setIsBooked(false);
                        newDepr.setIsCanceled(false);
                        newDepr.setIsCancelation(false);
                        newDepr.setIsPersistent(false);
                        newDepr.setMakePersistent(true);
                        newDepr.setUsefullLifeInMonth((int)this.mFaArea.getUsefullLifeInMonth());
                        newDepr.setUsefullLifeInDays(this.getUsefullLifeInDays());
                        newDepr.setDeprStartDate(this.mFaArea.getDeprStartDate());
                        newDepr.setOidFixedAsset(this.mFixedAsset.getObjectid());
                        newDepr.setOidFixedAssetTransferFrom("");
                        newDepr.setOidFixedAssetTransferTo("");
                        newDepr.setCalcMethodCode(this.mCalcMethod.getCode());
                        newDepr.setDeprPercent(this.depreciationPercent);
                        newDepr.setAnalysisCodes(null);
                        newDepr.setAutomDeprType(FixedAssetTransaction.determineAutomaticDepreciationType((CalcMethod)this.mCalcMethod));
                        if (this.mJurisdiction_IT) {
                            newDepr.setDeprPlanIT(this.mDeprPlanIT);
                        } else {
                            newDepr.setDeprPlanIT(null);
                        }
                        if (this.mYearDeprAmountLess) {
                            newDepr.setNoDeprCorrection(true);
                        } else {
                            newDepr.setNoDeprCorrection(false);
                        }
                        transactCache.add(newDepr);
                        Collections.sort(transactCache);
                        DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                        resLifeInMonth = FixedAssetArea.calculateResidualLifeInMonthBelowZero(this.mFaArea.getUsefullLifeInMonth(), this.mFaArea.getDeprStartDate(), newDepr.getProcessingDate()) + 1;
                        Date beginDate = this.mFixedAsset.getAcquisitionDate();
                        if (this.mJurisdiction_AT || this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR) {
                            Date activationDate = null;
                            for (DepreciationCalculationHelper dchCache : transactCache) {
                                if (dchCache.getTransactionType().value() != 21) continue;
                                activationDate = dchCache.getProcessingDate();
                                break;
                            }
                            if (this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
                                beginDate = this.mFixedAsset.getCommissioningDate();
                            }
                            if (activationDate != null && DateHelper.after(activationDate, (Date)DateHelper.getLastDayOfMonth((Date)beginDate))) {
                                beginDate = activationDate;
                            }
                        }
                        if (!this.mIsDeprPreview && resLifeInMonth < 1 && BigDecimalMapper.isZeroOrNull((BigDecimal)newDepr.getAmount()) && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero()) || DateHelper.before((Date)newDepr.getProcessingDate(), (Date)beginDate) || this.mDeprArea.getDepreciationFrequencies().value() == 1 && j != lastMonthForDepr) {
                            newDepr.setMakePersistent(false);
                        }
                        if (this.mFaArea.getIsFullDisposed() && this.mFaArea.getRetirementDate() != null) {
                            if (disposalDate != null) {
                                if (DateHelper.after((Date)newDepr.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)disposalDate))) {
                                    newDepr.setMakePersistent(false);
                                }
                            } else if (DateHelper.after((Date)newDepr.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)this.mFaArea.getRetirementDate()))) {
                                newDepr.setMakePersistent(false);
                            }
                        }
                        boolean disposalPeriodIsClosed = false;
                        if (!this.mIsDeprPreview && !(disposalPeriodIsClosed = finPeriods[j].getFinancialYear().getYearClosed()) && (finPeriodDisposal = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods[j].getFinancialYear().getFinancialPeriods(), (Date)finPeriods[j].getValidUntil())) != null && (detail2 = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriodDisposal.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null) {
                            disposalPeriodIsClosed = detail2.getDeprAreaClosed();
                        }
                        if (this.mFaArea.getStatus() == StatusEnum.STE_LOW_VALUE && this.mDeprArea.getDispInYearOfAcqu() && !this.mFaArea.getIsFullDisposed() && newDepr.getMakePersistent() && BigDecimalMapper.isZero((BigDecimal)newDepr.getNetBookValue()) && !disposalPeriodIsClosed) {
                            Date disposalDateGWG = finPeriods[j].getValidUntil();
                            boolean disposalNotAllowed = FixedAssetTransaction.checkTransactionsAfterDisposal((FixedAsset)this.mFixedAsset, (DepreciationArea)this.mDeprArea, (Date)disposalDateGWG);
                            if (disposalNotAllowed) {
                                if (!this.mIsDeprPreview) {
                                    StringBuffer message = new StringBuffer(mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 1));
                                    message.append(' ');
                                    message.append(this.mFixedAsset.getCode());
                                    message.append(" --> ");
                                    message.append(mAADepreciationList.getString((ILanguage)this.mGlobalLanguage, 5));
                                    this.mProtocolMessages.add(new DepreciationProtocolMessages(0, message.toString()));
                                }
                            } else {
                                newDepr = new DepreciationCalculationHelper();
                                newDepr.setProcessingDate(finPeriods[j].getValidUntil());
                                newDepr.setDocumentDate(this.mDocumentDate);
                                newDepr.setTransactionType(TransactionEnum.TRE_FULL_DISPOSAL);
                                newDepr.setFinancialYear(this.mFinYears[i]);
                                newDepr.setQuantity("");
                                newDepr.setAmount(BigDecimal.ZERO);
                                newDepr.setAmountNotRounded(BigDecimal.ZERO);
                                newDepr.setAcquisitionAmount(BigDecimal.ZERO);
                                newDepr.setDepreciationAmount(BigDecimal.ZERO);
                                newDepr.setSpecDepreciationAmount(BigDecimal.ZERO);
                                newDepr.setInterestAmount(BigDecimal.ZERO);
                                newDepr.setGrant(BigDecimal.ZERO);
                                newDepr.setPartDisposalPercent(BigDecimal.ZERO);
                                newDepr.setPartDisposalNetBookValue(BigDecimal.ZERO);
                                newDepr.setReserveAmount(BigDecimal.ZERO);
                                newDepr.setSalesAmount(BigDecimal.ZERO);
                                newDepr.setBaseForReducingBalanceDepreciation(BigDecimal.ZERO);
                                newDepr.setIsBooked(false);
                                newDepr.setIsCanceled(false);
                                newDepr.setIsCancelation(false);
                                newDepr.setIsPersistent(false);
                                newDepr.setMakePersistent(true);
                                newDepr.setUsefullLifeInMonth(0);
                                newDepr.setUsefullLifeInDays(0);
                                newDepr.setDeprStartDate(this.mFaArea.getDeprStartDate());
                                newDepr.setOidFixedAsset(this.mFixedAsset.getObjectid());
                                newDepr.setOidFixedAssetTransferFrom("");
                                newDepr.setOidFixedAssetTransferTo("");
                                newDepr.setCalcMethodCode(this.mCalcMethod.getCode());
                                newDepr.setDeprPercent(BigDecimal.ZERO);
                                newDepr.setSalesAmount(BigDecimal.ZERO);
                                newDepr.setNoDeprCorrection(false);
                                transactCache.add(newDepr);
                                Collections.sort(transactCache);
                                DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                                resLifeInMonth = FixedAssetArea.calculateResidualLifeInMonthBelowZero(this.mFaArea.getUsefullLifeInMonth(), this.mFaArea.getDeprStartDate(), newDepr.getProcessingDate()) + 1;
                                this.mFaArea.setIsFullDisposed(true);
                                this.mFaArea.setRetirementDate(newDepr.getProcessingDate());
                                if (this.mDeprArea.getBelongsToBalanceSheet()) {
                                    this.mFixedAsset.setDisposalDate(newDepr.getProcessingDate());
                                    this.mFixedAsset.makeSaveable();
                                }
                            }
                        }
                    }
                }
                if (newSpecDeprTransact && !BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[j][2])) {
                    DepreciationCalculationHelper newDepr = new DepreciationCalculationHelper();
                    newDepr.setProcessingDate(finPeriods[j].getValidUntil());
                    newDepr.setDocumentDate(this.mDocumentDate);
                    if (fullDisposalDate != null && DateHelper.after((Date)newDepr.getProcessingDate(), fullDisposalDate)) {
                        newDepr.setProcessingDate(fullDisposalDate);
                        newDepr.setDocumentDate(this.mDocumentDate);
                        if (BigDecimalMapper.compareTo((BigDecimal)periodValues[j][2], (BigDecimal)BigDecimal.ZERO) > 0) {
                            VDate lastDay = new VDate(finPeriods[j].getValidUntil());
                            VDate processingDay = new VDate(fullDisposalDate);
                            periodValues[j][3] = periodValues[j][2].divide(new BigDecimal(lastDay.getDay()), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(processingDay.getDay()));
                            periodValues[j][2] = DepreciationCalculation.roundingAmount(periodValues[j][3], this.mFaArea.getDeprArea().getRoundingDep().value());
                        }
                    }
                    newDepr.setTransactionType(TransactionEnum.TRE_AUTOMATIC_SPEC_DEPR);
                    newDepr.setFinancialYear(this.mFinYears[i]);
                    newDepr.setQuantity("");
                    newDepr.setAmount(periodValues[j][2]);
                    newDepr.setAmountNotRounded(periodValues[j][3]);
                    newDepr.setAcquisitionAmount(BigDecimal.ZERO);
                    newDepr.setDepreciationAmount(BigDecimal.ZERO);
                    newDepr.setSpecDepreciationAmount(BigDecimal.ZERO);
                    newDepr.setInterestAmount(BigDecimal.ZERO);
                    newDepr.setGrant(BigDecimal.ZERO);
                    newDepr.setPartDisposalPercent(BigDecimal.ZERO);
                    newDepr.setPartDisposalNetBookValue(BigDecimal.ZERO);
                    newDepr.setReserveAmount(BigDecimal.ZERO);
                    newDepr.setSalesAmount(BigDecimal.ZERO);
                    newDepr.setBaseForReducingBalanceDepreciation(BigDecimal.ZERO);
                    newDepr.setIsBooked(false);
                    newDepr.setIsCanceled(false);
                    newDepr.setIsCancelation(false);
                    newDepr.setIsPersistent(false);
                    newDepr.setMakePersistent(true);
                    newDepr.setUsefullLifeInMonth((int)this.mFaArea.getUsefullLifeInMonth());
                    newDepr.setUsefullLifeInDays(this.getUsefullLifeInDays());
                    newDepr.setDeprStartDate(this.mFaArea.getDeprStartDate());
                    newDepr.setOidFixedAsset(this.mFixedAsset.getObjectid());
                    newDepr.setOidFixedAssetTransferFrom("");
                    newDepr.setOidFixedAssetTransferTo("");
                    newDepr.setCalcMethodCode(this.mCalcMethod.getCode());
                    newDepr.setDeprPercent(this.depreciationPercent);
                    newDepr.setNoDeprCorrection(false);
                    transactCache.add(newDepr);
                    Collections.sort(transactCache);
                    DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                    resLifeInMonth = FixedAssetArea.calculateResidualLifeInMonth(this.mFaArea.getUsefullLifeInMonth(), this.mFaArea.getDeprStartDate(), newDepr.getProcessingDate());
                }
                for (k = 0; k < dchs.length; ++k) {
                    if (dchs[k].getIsCancelation() || dchs[k].getIsCanceled() || !DateHelper.equal((Date)dchs[k].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dchs[k].getProcessingDate()))) continue;
                    if (dchs[k].getTransactionType().value() == 11 || dchs[k].getTransactionType().value() == 13 || dchs[k].getTransactionType().value() == 7 || dchs[k].getTransactionType().value() == 14 || dchs[k].getTransactionType().value() == 26 || dchs[k].getTransactionType().value() == 15) {
                        int periodIndex = j + 1;
                        if (periodIndex > finPeriods.length - 1) {
                            periodIndex = finPeriods.length - 1;
                        }
                        this.calculateDepreciation(this.mFinYears[i], finPeriods, periodIndex, periodValues, dchs[k], transactCache);
                        continue;
                    }
                    if (!ISoftware.getDepreciationForAdditionsWithValueLastDayOfMonth() && dchs[k].getResLifeInMonth() + j > finPeriods.length && (dchs[k].getTransactionType().value() == 2 || dchs[k].getTransactionType().value() == 3 || dchs[k].getTransactionType().value() == 4 || dchs[k].getTransactionType().value() == 26 || dchs[k].getTransactionType().value() == 5 || dchs[k].getTransactionType().value() == 25 || dchs[k].getTransactionType().value() == 6 && dchs[k].getOidFixedAsset().equals(dchs[k].getOidFixedAssetTransferTo()))) {
                        int periodIndex = j + 1;
                        if (periodIndex > finPeriods.length - 1) {
                            periodIndex = finPeriods.length - 1;
                        }
                        this.calculateDepreciation(this.mFinYears[i], finPeriods, periodIndex, periodValues, dchs[k], transactCache);
                        continue;
                    }
                    if (dchs[k].getTransactionType().value() == 19) {
                        if (BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAccumAcquisitionValue())) {
                            if (this.mTriggerIsNewTransaction) {
                                Date technDispDate = DepreciationCalculation.calculateTechnicalDisposalDate(this.mFinYears[i], finPeriods[j], this.mDeprArea, dchs[k].getProcessingDate());
                                this.cancelAllFollowingTransactions(transactCache, technDispDate, false);
                            }
                            for (int l = j; l < periodValues.length; ++l) {
                                periodValues[l][0] = BigDecimal.ZERO;
                                periodValues[l][1] = new BigDecimal("0.000000000000000000");
                                periodValues[l][2] = BigDecimal.ZERO;
                                periodValues[l][3] = new BigDecimal("0.000000000000000000");
                            }
                            dchs[k].setMakePersistent(true);
                            continue;
                        }
                        int periodIndex = j + 1;
                        if (periodIndex > finPeriods.length - 1) {
                            periodIndex = finPeriods.length - 1;
                        }
                        this.calculateDepreciation(this.mFinYears[i], finPeriods, periodIndex, periodValues, dchs[k], transactCache);
                        dchs[k].setMakePersistent(true);
                        continue;
                    }
                    if (dchs[k].getTransactionType().value() == 20) {
                        if (this.mTriggerIsNewTransaction) {
                            if (disposalDate != null) {
                                this.cancelAllFollowingTransactions(transactCache, disposalDate, false);
                            } else {
                                Date technDispDate = DepreciationCalculation.calculateTechnicalDisposalDate(this.mFinYears[i], finPeriods[j], this.mDeprArea, dchs[k].getProcessingDate());
                                this.cancelAllFollowingTransactions(transactCache, technDispDate, false);
                            }
                        }
                        fullDisposal = true;
                        dchs[k].setMakePersistent(true);
                        continue;
                    }
                    if (dchs[k].getTransactionType().value() == 6 && dchs[k].getOidFixedAsset().equals(dchs[k].getOidFixedAssetTransferFrom())) {
                        if (this.mTriggerIsNewTransaction) {
                            this.cancelAllFollowingTransactions(transactCache, dchs[k].getProcessingDate(), true);
                        }
                        dchs[k].setMakePersistent(true);
                        continue;
                    }
                    if (dchs[k].getTransactionType().value() != 10 || !this.mFaArea.getDeprArea().getCalcRemLifeForPostCapitalization() || !this.mJurisdiction_PL) continue;
                    int periodIndex = j + 1;
                    if (periodIndex > finPeriods.length - 1) {
                        periodIndex = finPeriods.length - 1;
                    }
                    this.calculateDepreciation(this.mFinYears[i], finPeriods, periodIndex, periodValues, dchs[k], transactCache);
                    dchs[k].setMakePersistent(true);
                }
            }
        }
        return transactCache;
    }

    private List<DepreciationCalculationHelper> calculateInterestsManager(List<DepreciationCalculationHelper> transactCache, Date lastDeprDate) throws BusinessDomainException {
        LOGGER.debug("calculateInterestsManager(...)");
        DepreciationCalculationHelper dch = null;
        int indexLastClosedFinYear = 0;
        if (this.mFinYears == null) {
            this.mFinYears = DepreciationCalculation.getFAFinancialYears(this.mCompany, this.mIsDeprPreview, this.mPreviewUntilDate);
        }
        for (int i = 0; i < this.mFinYears.length; ++i) {
            if (!this.mFinYears[i].getYearClosed()) continue;
            indexLastClosedFinYear = i;
        }
        FAFinancialYear finYearForInterest = FAFinancialYear.getFAFinancialYearForLastDeprDate((AccountingCompany)this.mCompany, (Date)this.mDepreciationUntilDate);
        if (finYearForInterest != null && this.mFaArea.getLastInterestCalcDate() == null) {
            if (this.mFaArea.getDeprStartDate() == null && lastDeprDate == null) {
                this.mFaArea.setLastInterestCalcDate(DateHelper.yesterday((Date)finYearForInterest.getValidFrom()));
            }
            if (this.mFaArea.getDeprStartDate() != null && lastDeprDate == null && DateHelper.before((Date)this.mFaArea.getDeprStartDate(), (Date)finYearForInterest.getValidFrom())) {
                this.mFaArea.setLastInterestCalcDate(DateHelper.yesterday((Date)finYearForInterest.getValidFrom()));
            }
            if (this.mFaArea.getDeprStartDate() != null && lastDeprDate != null && DateHelper.before((Date)this.mFaArea.getDeprStartDate(), (Date)finYearForInterest.getValidFrom())) {
                this.mFaArea.setLastInterestCalcDate(DateHelper.yesterday((Date)finYearForInterest.getValidFrom()));
            }
        }
        boolean interestCalcInLastPeriod = false;
        block1: for (int i = indexLastClosedFinYear; i < this.mFinYears.length && !this.mFinYears[i].getValidFrom().after(this.mDepreciationUntilDate); ++i) {
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)this.mFinYears[i].getValidUntil()) || this.mFaArea.getLastInterestCalcDate() != null && DateHelper.afterOrEqual((Date)this.mFaArea.getLastInterestCalcDate(), (Date)this.mFinYears[i].getValidUntil())) continue;
            dch = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, DateHelper.yesterday((Date)this.mFinYears[i].getValidFrom()), false, false);
            if (dch == null) {
                dch = transactCache.get(0);
            }
            FAFinancialPeriod[] finPeriods = this.mFinYears[i].getFinancialPeriods();
            this.indexOfDeprStartPeriod = 0;
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)this.mFinYears[i].getValidFrom())) {
                this.indexOfDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)this.mFaArea.getDeprStartDate());
            }
            if (dch.getLastInterestCalcDate() != null && DateHelper.after((Date)dch.getLastInterestCalcDate(), (Date)this.mFinYears[i].getValidFrom())) {
                this.indexOfDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)dch.getLastInterestCalcDate())));
            }
            if (this.indexOfDeprStartPeriod == -1) continue;
            BigDecimal[][] periodValues = new BigDecimal[finPeriods.length + 1][2];
            for (int j = 0; j < periodValues.length; ++j) {
                periodValues[j][0] = BigDecimal.ZERO;
                periodValues[j][1] = new BigDecimal("0.000000000000000000");
            }
            boolean fullDisposal = false;
            if (this.mCalcMethodInterests.getBaseForCalc().value() == 11) {
                this.calculateInterestsForMiddleRestValue(this.mFinYears[i], finPeriods, this.indexOfDeprStartPeriod, periodValues, transactCache);
            } else {
                this.calculateInterests(this.mFinYears[i], finPeriods, this.indexOfDeprStartPeriod, periodValues, dch, transactCache);
            }
            for (int j = this.indexOfDeprStartPeriod; j < finPeriods.length && !finPeriods[j].getValidUntil().after(this.mDepreciationUntilDate) && !fullDisposal; ++j) {
                int interestCalcMonth;
                DepreciationCalculationHelper dchCheck;
                if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)finPeriods[j].getValidUntil())) continue;
                Date fullDisposalDate = null;
                DepreciationCalculationHelper[] dchs = DepreciationCalculation.getDeprCalcHelperForPeriod(transactCache, finPeriods[j]);
                if (dchs.length > 0) {
                    dchCheck = dchs[dchs.length - 1];
                } else {
                    dchCheck = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, finPeriods[j].getValidUntil(), false, false);
                    if (dchCheck == null) {
                        dchCheck = transactCache.get(0);
                    }
                }
                if (this.mCalcMethodInterests.getEndOfCalc().value() == 2) {
                    interestCalcMonth = 0;
                    interestCalcMonth = this.mFaArea.getDeprStartDate() != null ? DateHelper.getDiffInMonths((Date)finPeriods[j].getValidUntil(), (Date)DateHelper.yesterday((Date)this.mFaArea.getDeprStartDate())) : DateHelper.getDiffInMonths((Date)finPeriods[j].getValidUntil(), (Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mFixedAsset.getAcquisitionDate())));
                    if (interestCalcMonth > this.mFaArea.getUsefullLifeInMonth()) continue block1;
                }
                if (this.mCalcMethodInterests.getEndOfCalc().value() == 1 && BigDecimalMapper.compareTo((BigDecimal)dchCheck.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) < 1) {
                    if (interestCalcInLastPeriod) continue block1;
                    interestCalcInLastPeriod = true;
                }
                if (this.mCalcMethodInterests.getEndOfCalc().value() == 3) {
                    interestCalcMonth = 0;
                    interestCalcMonth = this.mFaArea.getDeprStartDate() != null ? DateHelper.getDiffInMonths((Date)finPeriods[j].getValidUntil(), (Date)DateHelper.yesterday((Date)this.mFaArea.getDeprStartDate())) : DateHelper.getDiffInMonths((Date)finPeriods[j].getValidUntil(), (Date)DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mFixedAsset.getAcquisitionDate())));
                    if (interestCalcMonth > this.mCalcMethodInterests.getPeriodInYears() * 12 + this.mCalcMethodInterests.getPeriodInMonth()) continue block1;
                }
                boolean newInterestTransact = true;
                for (int k = 0; k < dchs.length; ++k) {
                    if (dchs[k].getIsCancelation() || dchs[k].getIsCanceled()) continue;
                    if (dchs[k].getTransactionType().value() == 19 && BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAccumAcquisitionValue())) {
                        fullDisposalDate = dchs[k].getProcessingDate();
                        if (this.mTriggerIsNewTransaction) {
                            this.cancelAllFollowingTransactions(transactCache, dchs[k].getProcessingDate(), false);
                        }
                        fullDisposal = true;
                        dchs[k].setMakePersistent(true);
                    }
                    if (dchs[k].getTransactionType().value() == 20) {
                        fullDisposalDate = dchs[k].getProcessingDate();
                        if (this.mTriggerIsNewTransaction) {
                            this.cancelAllFollowingTransactions(transactCache, dchs[k].getProcessingDate(), false);
                        }
                        fullDisposal = true;
                        dchs[k].setMakePersistent(true);
                    }
                    if (this.mCalcMethodInterests.getBaseForCalc().value() != 11) {
                        this.calculateInterests(this.mFinYears[i], finPeriods, j, periodValues, dchs[k], transactCache);
                    }
                    if (dchs[k].getTransactionType().value() != 18) continue;
                    newInterestTransact = false;
                    if (dchs[k].getAmount().compareTo(periodValues[j][0]) == 0) continue;
                    dchs[k].setAmount(periodValues[j][0]);
                    dchs[k].setMakePersistent(true);
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dchs[k].getAmount())) continue;
                    dchs[k].setMakeCancelation(true);
                }
                if (!newInterestTransact) continue;
                if (this.mFaArea.getIsFullDisposed() && fullDisposalDate == null) {
                    fullDisposalDate = this.mFaArea.getRetirementDate();
                }
                if (this.mFaArea.getIsFullDisposed() && fullDisposalDate != null && DateHelper.after((Date)finPeriods[j].getValidUntil(), (Date)fullDisposalDate)) {
                    LOGGER.debug("No interests for Period with full disposal");
                    continue;
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[j][0])) {
                    LOGGER.debug("Build transaction only, when period-amount is not 0.00");
                    continue;
                }
                DepreciationCalculationHelper newDepr = new DepreciationCalculationHelper();
                newDepr.setProcessingDate(finPeriods[j].getValidUntil());
                newDepr.setDocumentDate(this.mDocumentDate);
                if (fullDisposalDate != null && DateHelper.after((Date)newDepr.getProcessingDate(), (Date)fullDisposalDate)) {
                    newDepr.setProcessingDate(fullDisposalDate);
                    newDepr.setDocumentDate(this.mDocumentDate);
                }
                newDepr.setTransactionType(TransactionEnum.TRE_INTERESTS);
                newDepr.setFinancialYear(this.mFinYears[i]);
                newDepr.setQuantity("");
                newDepr.setAmount(periodValues[j][0]);
                newDepr.setAmountNotRounded(periodValues[j][1]);
                newDepr.setAcquisitionAmount(BigDecimal.ZERO);
                newDepr.setDepreciationAmount(BigDecimal.ZERO);
                newDepr.setSpecDepreciationAmount(BigDecimal.ZERO);
                newDepr.setInterestAmount(BigDecimal.ZERO);
                newDepr.setGrant(BigDecimal.ZERO);
                newDepr.setPartDisposalPercent(BigDecimal.ZERO);
                newDepr.setPartDisposalNetBookValue(BigDecimal.ZERO);
                newDepr.setReserveAmount(BigDecimal.ZERO);
                newDepr.setSalesAmount(BigDecimal.ZERO);
                newDepr.setBaseForReducingBalanceDepreciation(BigDecimal.ZERO);
                newDepr.setIsBooked(false);
                newDepr.setIsCanceled(false);
                newDepr.setIsCancelation(false);
                newDepr.setIsPersistent(false);
                newDepr.setMakePersistent(true);
                newDepr.setUsefullLifeInMonth((int)this.mFaArea.getUsefullLifeInMonth());
                newDepr.setUsefullLifeInDays(this.getUsefullLifeInDays());
                newDepr.setDeprStartDate(this.mFaArea.getDeprStartDate());
                newDepr.setOidFixedAsset(this.mFixedAsset.getObjectid());
                newDepr.setOidFixedAssetTransferFrom("");
                newDepr.setOidFixedAssetTransferTo("");
                if (this.mCalcMethod != null) {
                    newDepr.setCalcMethodCode(this.mCalcMethod.getCode());
                } else {
                    newDepr.setCalcMethodCode("");
                }
                newDepr.setDeprPercent(this.depreciationPercent);
                newDepr.setAnalysisCodes(null);
                newDepr.setNoDeprCorrection(false);
                transactCache.add(newDepr);
                Collections.sort(transactCache);
                DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
            }
        }
        return transactCache;
    }

    private void calculateDepreciation(FAFinancialYear finYear, FAFinancialPeriod[] finPeriods, int periodIndex, BigDecimal[][] periodValues, DepreciationCalculationHelper dch, List<DepreciationCalculationHelper> transactCache) {
        VDate startDate;
        int startYear;
        VDate processingDate;
        int processingYear;
        int deprYears;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculateDepreciation, year: {} -", (Object)finYear.getCode());
        }
        DepreciationMethodData deprMethod = null;
        DepreciationPlanMethodData deprPlanMethod = null;
        this.mDeprPlanIT = null;
        this.mYearDeprAmountLess = false;
        boolean thisYearComplete = false;
        boolean lessThanPeriodsLength = false;
        boolean netBookValForResLife = false;
        boolean performanceDepreciation = false;
        boolean plannedDepreciation = false;
        boolean isFirstYearOfDepr = this.mFaArea.getDeprStartDate() == null ? false : finYear.getDateIsInFinancialYear(this.mFaArea.getDeprStartDate());
        BigDecimal deprPercentOfMethod = BigDecimal.ZERO;
        switch (this.mCalcMethod.getMethodTypeEnum().value()) {
            case 0: {
                deprMethod = (DepreciationMethodData)this.mCalcMethod;
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethod.getPercentage())) {
                    deprPercentOfMethod = deprMethod.getPercentage();
                }
                if (deprMethod.getDepreciationType().value() == 2) {
                    netBookValForResLife = true;
                    break;
                }
                if (deprMethod.getDepreciationType().value() != 3) break;
                performanceDepreciation = true;
                break;
            }
            case 2: {
                deprPlanMethod = (DepreciationPlanMethodData)this.mCalcMethod;
                plannedDepreciation = true;
            }
        }
        DepreciationPlanIT[] deprPlanITs = null;
        if (this.mJurisdiction_IT && this.mCalcMethod.getMethodTypeEnum().value() == 2) {
            deprPlanITs = DepreciationPlanIT.getDepreciationPlanITs((FixedAssetArea)this.mFaArea);
        }
        int numberOfMonthForDepr = finPeriods.length;
        int numberOfDaysForDepr = DateHelper.getDiffInDays((Date)finYear.getValidUntil(), (Date)finYear.getValidFrom()) + 1;
        if (dch.getResLifeInMonth() + periodIndex <= finPeriods.length && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero())) {
            thisYearComplete = true;
            if (dch.getUsefullLifeInMonth() > finPeriods.length) {
                numberOfMonthForDepr = dch.getResLifeInMonth();
                numberOfDaysForDepr = dch.getResLifeInDays();
                if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mFaArea.getDeprStartDate()))) {
                    ++numberOfMonthForDepr;
                    ++numberOfDaysForDepr;
                    dch.setResLifeInMonth(dch.getResLifeInMonth() + 1);
                    dch.setResLifeInDays(dch.getResLifeInDays() + 1);
                }
            }
        }
        if (this.mFaArea.getStatus() == StatusEnum.STE_LOW_VALUE_5_YEARS && dch.getResLifeInMonth() < 24 && this.mFaArea.getDeprStartDate() != null && dch.getProcessingDate() != null && (deprYears = (processingYear = (processingDate = new VDate(DateHelper.tomorrow((Date)dch.getProcessingDate()))).getYear()) - (startYear = (startDate = new VDate(this.mFaArea.getDeprStartDate())).getYear())) > 3) {
            thisYearComplete = true;
        }
        if (dch.getResLifeInMonth() <= finPeriods.length && dch.getUsefullLifeInMonth() <= finPeriods.length && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero())) {
            lessThanPeriodsLength = true;
            numberOfMonthForDepr = dch.getResLifeInMonth();
            numberOfDaysForDepr = dch.getResLifeInDays();
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mFaArea.getDeprStartDate())) && (dch.getUsefullLifeInMonth() != 1 || !this.mJurisdiction_DE)) {
                ++numberOfMonthForDepr;
                ++numberOfDaysForDepr;
            }
        }
        BigDecimal baseForDeprAmount = DepreciationCalculation.getBaseForDepreciation(dch, this.mCalcMethod, this.mFaArea, finPeriods[periodIndex].getValidUntil(), this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage);
        if (thisYearComplete || lessThanPeriodsLength) {
            if (this.mAASetup.getNote().equals("AFA_CZ") && this.mJurisdiction_CZ || this.mAASetup.getNote().equals("AFA_PL") && this.mJurisdiction_PL) {
                numberOfMonthForDepr = finPeriods.length;
                numberOfDaysForDepr = DateHelper.getDiffInDays((Date)finYear.getValidUntil(), (Date)finYear.getValidFrom()) + 1;
            } else if (!this.mDeprArea.getRestDepreciation() && dch.getResLifeInMonth() == 0 && dch.getNetBookValue().compareTo(BigDecimal.ZERO) >= 0 && BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0) {
                baseForDeprAmount = BigDecimal.ZERO;
                netBookValForResLife = true;
            } else if (this.mCalcMethod.getBaseForCalc().value() != 1 && this.mCalcMethod.getBaseForCalc().value() != 4 && !this.mJurisdiction_PL) {
                baseForDeprAmount = dch.getNetBookValue();
                netBookValForResLife = true;
            }
        }
        boolean isFullDisposal = false;
        Date fullDisposalDate = null;
        int fullDisposalMonth = 0;
        FixedAssetTransaction fatDisposal = null;
        if ((this.mJurisdiction_CZ || this.mJurisdiction_AT) && (fatDisposal = FixedAssetTransactionPersistencyManager.checkExistenceOfDisposal((FixedAssetArea)this.mFaArea, (FAFinancialYear)finYear)) != null) {
            isFullDisposal = true;
            fullDisposalDate = fatDisposal.getProcessingDate();
            if (this.mJurisdiction_CZ && this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR) {
                numberOfMonthForDepr = finYear.getFAFinancialPeriodIndexForDate(fatDisposal.getProcessingDate()) + 1;
                numberOfDaysForDepr = DateHelper.getDiffInDays((Date)fatDisposal.getProcessingDate(), (Date)finYear.getValidFrom()) + 1;
            }
            if (this.mJurisdiction_AT && (fatDisposal.getFullDisposDeprecUntil() == FullDisposDeprecUntilEnum.DUE_HALF_YEAR_AT || this.mDeprArea.getNote().equals("VOLLABGANG"))) {
                if (DateHelper.after((Date)fullDisposalDate, (Date)DateHelper.getLastDayOfHalfYear((Date)finYear.getValidFrom()))) {
                    numberOfMonthForDepr = finYear.getFAFinancialPeriodIndexForDate(finYear.getValidUntil()) + 1;
                    numberOfDaysForDepr = DateHelper.getDiffInDays((Date)finYear.getValidUntil(), (Date)finYear.getValidFrom()) + 1;
                } else {
                    numberOfMonthForDepr = finYear.getFAFinancialPeriodIndexForDate(DateHelper.getLastDayOfHalfYear((Date)finYear.getValidFrom())) + 1;
                    numberOfDaysForDepr = DateHelper.getDiffInDays((Date)DateHelper.getLastDayOfHalfYear((Date)finYear.getValidFrom()), (Date)finYear.getValidFrom()) + 1;
                }
                if (DateHelper.after((Date)fatDisposal.getProcessingDate(), (Date)DateHelper.getFirstDayOfMonth((Date)fatDisposal.getProcessingDate()))) {
                    fullDisposalMonth = finYear.getFAFinancialPeriodIndexForDate(fatDisposal.getProcessingDate());
                } else if (finYear.getFAFinancialPeriodIndexForDate(fatDisposal.getProcessingDate()) > 0) {
                    fullDisposalMonth = finYear.getFAFinancialPeriodIndexForDate(fatDisposal.getProcessingDate()) - 1;
                }
            }
        }
        int lastPeriodForDepr = numberOfMonthForDepr;
        if (baseForDeprAmount.compareTo(BigDecimal.ZERO) > 0 || dch.getTransactionType().value() == 6 || dch.getTransactionType().value() == 5 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 25 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 4 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 20 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 && (dch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE || dch.getFullDisposalDeprUntilType() == FullDisposDeprecUntilEnum.DUE_POSTING_DATE) && DateHelper.before((Date)dch.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dch.getProcessingDate())) && DateHelper.between((Date)dch.getProcessingDate(), (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil())) {
            BigDecimal decimalPlacesOnly;
            int m;
            int m2;
            BigDecimal shiftDeprAmount;
            BigDecimal shiftPercent;
            BigDecimal yearDeprAmount;
            int numberOfYear;
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mNewDepreciationPercent)) {
                this.depreciationPercent = this.mFaArea.getDepreciationPercent();
                if (this.mDeprMethodHasChanged) {
                    this.depreciationPercent = !BigDecimalMapper.isZeroOrNull((BigDecimal)deprPercentOfMethod) ? deprPercentOfMethod : new BigDecimal(100 / (dch.getUsefullLifeInMonth() / 12));
                }
            } else if (this.mDeprMethodHasChanged) {
                this.depreciationPercent = this.mNewDepreciationPercent;
            }
            if (plannedDepreciation && deprPlanMethod != null) {
                numberOfYear = this.mFaArea.getNumberOfYear(finYear);
                this.depreciationPercent = deprPlanMethod.getPercentForYear(numberOfYear);
                if (this.mJurisdiction_IT) {
                    if (deprPlanITs != null && deprPlanITs.length > 0) {
                        this.depreciationPercent = BigDecimal.ZERO;
                        if (numberOfYear <= deprPlanITs.length) {
                            this.mDeprPlanIT = deprPlanITs[numberOfYear - 1];
                        }
                    }
                    if (this.mDeprPlanIT != null) {
                        this.depreciationPercent = this.mDeprPlanIT.getPlannedPercent();
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mDeprPlanIT.getReducedPercent())) {
                            this.depreciationPercent = this.mDeprPlanIT.getReducedPercent().add(this.mDeprPlanIT.getNonUsedPercentage());
                        }
                    }
                }
            } else if (performanceDepreciation && this.perfUnit != null) {
                this.depreciationPercent = new BigDecimal(100).multiply(this.perfUnit.getAccumulatedUnits().divide(this.mFaArea.getPerfInUnits(), 10, RoundingMode.HALF_EVEN));
                this.depreciationPercent = this.depreciationPercent.setScale(2, RoundingMode.HALF_EVEN);
            } else if (deprMethod != null && deprMethod.getDepreciationType().value() == 4) {
                numberOfYear = this.mFaArea.getNumberOfYear(finYear);
                boolean hasPostCapitalization = FixedAssetTransaction.checkTransactionExistence((FixedAssetArea)this.mFaArea, (FAFinancialYear)finYear);
                if (hasPostCapitalization) {
                    this.mNumberOfYearCZ = 0;
                } else if (this.mNumberOfYearCZ > -1) {
                    ++this.mNumberOfYearCZ;
                }
                this.depreciationPercent = this.mNumberOfYearCZ == -1 ? (numberOfYear == 1 ? new BigDecimal("100.00").divide(new BigDecimal(deprMethod.getFirstCoefficient()), 20, RoundingMode.HALF_EVEN) : new BigDecimal(2).divide(new BigDecimal(deprMethod.getNextCoefficient() - numberOfYear + 1), 20, RoundingMode.HALF_DOWN).multiply(HUNDRED)) : new BigDecimal(2).divide(new BigDecimal(deprMethod.getPostCapCoefficient() - this.mNumberOfYearCZ), 20, RoundingMode.HALF_DOWN).multiply(HUNDRED);
            } else if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.depreciationPercent) && deprMethod != null) {
                this.depreciationPercent = deprMethod.getPercentage();
            }
            if (this.depreciationPercent == null) {
                this.depreciationPercent = BigDecimal.ZERO;
            }
            if ((lastPeriodForDepr += periodIndex) > numberOfMonthForDepr + periodIndex) {
                lastPeriodForDepr = numberOfMonthForDepr + periodIndex;
            }
            if (lastPeriodForDepr > finPeriods.length) {
                lastPeriodForDepr = finPeriods.length;
            }
            if (netBookValForResLife) {
                if (dch.getResLifeInMonth() > 0) {
                    if (lessThanPeriodsLength || this.mFaArea.getStatus() == StatusEnum.STE_LOW_VALUE_5_YEARS && thisYearComplete) {
                        yearDeprAmount = BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0 ? dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)) : dch.getNetBookValue();
                    } else if (this.mCalcMethod.getBaseForCalc().value() != 4) {
                        if (this.mDeprArea.getDayExact()) {
                            yearDeprAmount = dch.getNetBookValue().multiply(new BigDecimal(numberOfDaysForDepr)).divide(new BigDecimal(dch.getResLifeInDays()), 2, RoundingMode.HALF_EVEN);
                        } else if (isFirstYearOfDepr && this.mFaArea.getDeprStartDate() != null && this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR) {
                            Date procDateNewAddition = null;
                            for (DepreciationCalculationHelper dchCache : transactCache) {
                                if (dchCache.getTransactionType().value() != 0) continue;
                                procDateNewAddition = dchCache.getProcessingDate();
                                break;
                            }
                            yearDeprAmount = dch.getUsefullLifeInMonth() > dch.getResLifeInMonth() && procDateNewAddition != null && DateHelper.equal((Date)procDateNewAddition, (Date)dch.getProcessingDate()) ? dch.getNetBookValue().multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getUsefullLifeInMonth()), 2, RoundingMode.HALF_EVEN) : dch.getNetBookValue().multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN);
                        } else {
                            int realNumberOfMonthForDepr = numberOfMonthForDepr;
                            if (this.mJurisdiction_AT && fatDisposal != null && fatDisposal.getFullDisposDeprecUntil() == FullDisposDeprecUntilEnum.DUE_HALF_YEAR_AT) {
                                realNumberOfMonthForDepr = dch.getResLifeInMonth() < finPeriods.length ? dch.getResLifeInMonth() : finPeriods.length;
                            }
                            yearDeprAmount = dch.getNetBookValue().multiply(new BigDecimal(realNumberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN);
                        }
                    } else {
                        yearDeprAmount = BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0 ? (this.mDeprArea.getDayExact() ? dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)).multiply(new BigDecimal(numberOfDaysForDepr)).divide(new BigDecimal(dch.getResLifeInDays()), 2, RoundingMode.HALF_EVEN) : dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)).multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN)) : (this.mDeprArea.getDayExact() ? dch.getNetBookValue().multiply(new BigDecimal(numberOfDaysForDepr)).divide(new BigDecimal(dch.getResLifeInDays()), 2, RoundingMode.HALF_EVEN) : dch.getNetBookValue().multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN));
                    }
                } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getNetBookValue()) && BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0 && dch.getUsefullLifeInMonth() > 0 && deprMethod != null) {
                    yearDeprAmount = dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
                    if (numberOfMonthForDepr == 0) {
                        numberOfMonthForDepr = 1;
                        lastPeriodForDepr = periodIndex + 1;
                        if (lastPeriodForDepr > finPeriods.length) {
                            lastPeriodForDepr = 0;
                        }
                    }
                    if (this.mDeprArea.getDeprToResValueFullDisposal() && this.mFromTransaction && this.mIsTransactTypeIsDisposalOrRepost) {
                        lastPeriodForDepr = periodIndex + 1;
                    }
                } else {
                    yearDeprAmount = BigDecimal.ZERO;
                }
            } else {
                if (deprMethod != null && deprMethod.getDepreciationType() != null && deprMethod.getDepreciationType().value() == 6) {
                    yearDeprAmount = this.mFaArea.getFixDeprAmount();
                    if (yearDeprAmount == null) {
                        yearDeprAmount = BigDecimal.ZERO;
                    }
                } else {
                    yearDeprAmount = this.mJurisdiction_IT ? baseForDeprAmount.multiply(this.depreciationPercent).divide(HUNDRED, 2, RoundingMode.HALF_UP) : baseForDeprAmount.multiply(this.depreciationPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                }
                if (finPeriods.length < 12) {
                    yearDeprAmount = this.mJurisdiction_IT ? yearDeprAmount.multiply(new BigDecimal(finPeriods.length)).divide(new BigDecimal("12.00"), 2, RoundingMode.HALF_UP) : yearDeprAmount.multiply(new BigDecimal(finPeriods.length)).divide(new BigDecimal("12.00"), 2, RoundingMode.HALF_EVEN);
                }
            }
            if (thisYearComplete || lessThanPeriodsLength) {
                if (!this.mAASetup.getNote().equals("AFA_CZ") || !this.mJurisdiction_CZ) {
                    if (BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)), (BigDecimal)BigDecimal.ZERO) <= 0) {
                        yearDeprAmount = BigDecimal.ZERO;
                    } else if (BigDecimalMapper.compareTo((BigDecimal)yearDeprAmount, (BigDecimal)dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea))) > 0) {
                        yearDeprAmount = lessThanPeriodsLength ? yearDeprAmount.subtract(DepreciationCalculation.getDepResValue(this.mFaArea)) : (!this.mJurisdiction_PL ? dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)) : yearDeprAmount.subtract(DepreciationCalculation.getDepResValue(this.mFaArea)));
                    }
                } else {
                    yearDeprAmount = yearDeprAmount.subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
                }
            }
            if (this.mJurisdiction_CZ) {
                if (deprMethod != null && deprMethod.getDepreciationType().value() == 4) {
                    this.depreciationPercent = this.depreciationPercent.setScale(2, RoundingMode.HALF_EVEN);
                }
                if (isFullDisposal && this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR && BigDecimalMapper.compareTo((BigDecimal)yearDeprAmount, (BigDecimal)BigDecimal.ZERO) > 0) {
                    yearDeprAmount = yearDeprAmount.divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
                }
            }
            if (this.mJurisdiction_AT && isFullDisposal && fullDisposalDate != null && fatDisposal != null && (fatDisposal.getFullDisposDeprecUntil() == FullDisposDeprecUntilEnum.DUE_HALF_YEAR_AT || this.mDeprArea.getNote().equals("VOLLABGANG")) && BigDecimalMapper.compareTo((BigDecimal)yearDeprAmount, (BigDecimal)BigDecimal.ZERO) > 0 && DateHelper.beforeOrEqual((Date)fullDisposalDate, (Date)DateHelper.getLastDayOfHalfYear((Date)finYear.getValidFrom())) && !thisYearComplete) {
                yearDeprAmount = yearDeprAmount.divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(shiftPercent = this.mFaArea.getShiftFactor()))) {
                shiftDeprAmount = yearDeprAmount.multiply(shiftPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                yearDeprAmount = yearDeprAmount.add(shiftDeprAmount);
            }
            if (BigDecimalMapper.compareTo((BigDecimal)yearDeprAmount, (BigDecimal)new BigDecimal("12.00")) < 0) {
                this.mYearDeprAmountLess = true;
                if (!this.mKeepNetBookValueWithDecimalPlaces) {
                    yearDeprAmount = DepreciationCalculation.roundingAmount(yearDeprAmount, this.mFaArea.getDeprArea().getRoundingDep().value());
                    BigDecimal decimalPlacesOnly2 = new BigDecimal(dch.getNetBookValue().doubleValue() % 1.0).setScale(2, RoundingMode.HALF_EVEN);
                    yearDeprAmount = yearDeprAmount.add(decimalPlacesOnly2);
                }
            }
            Date activationDate = null;
            if (isFirstYearOfDepr && this.mFaArea.getDeprStartDate() != null && this.mFaArea.getDepreciationStart() == DepreciationStartEnum.DSE_HALF_YEAR) {
                for (DepreciationCalculationHelper dchCache : transactCache) {
                    if (dchCache.getTransactionType().value() != 21) continue;
                    activationDate = dchCache.getProcessingDate();
                    break;
                }
                if (this.mJurisdiction_AT) {
                    periodIndex = this.indexOfDeprStartPeriod;
                }
            } else if (this.indexOfDeprStartPeriod > periodIndex) {
                periodIndex = this.indexOfDeprStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1 && this.mKeepNetBookValueWithDecimalPlaces && thisYearComplete) {
                int lastPeriodOfYear = periodValues.length - 1;
                if (this.mFaArea.getIsFullDisposed() && this.mFaArea.getRetirementDate() != null && DateHelper.between((Date)this.mFaArea.getRetirementDate(), (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil())) {
                    lastPeriodOfYear = finYear.getFAFinancialPeriodIndexForDate(this.mFaArea.getRetirementDate()) + 1;
                }
                periodValues[lastPeriodOfYear - 1][0] = BigDecimal.ZERO;
            }
            if (performanceDepreciation && this.perfUnit != null) {
                for (int m3 = periodIndex; m3 < lastPeriodForDepr; ++m3) {
                    periodValues[m3][1] = baseForDeprAmount.divide(this.mFaArea.getPerfInUnits(), 10, RoundingMode.HALF_EVEN).multiply(this.periodUnits[m3].getMonthUnits());
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)shiftPercent)) continue;
                    shiftDeprAmount = periodValues[m3][1].multiply(shiftPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                    periodValues[m3][1] = periodValues[m3][1].add(shiftDeprAmount);
                }
            } else if (this.mFaArea.getDeprArea().getAverage()) {
                int m4;
                Date interruptDeprToDate = this.mFaArea.getInterruptDeprToDate();
                if (interruptDeprToDate == null) {
                    interruptDeprToDate = DateHelper.tomorrow((Date)this.mDepreciationUntilDate);
                }
                if (deprMethod != null && deprMethod.getDepreciationType().value() == 4 || this.mFaArea.getStatus() == StatusEnum.STE_LOW_VALUE_5_YEARS && isFirstYearOfDepr && this.indexOfDeprStartPeriod == periodIndex || deprPlanMethod != null && deprPlanMethod.getDepreciationFirstYear().value() == 1) {
                    for (m4 = periodIndex; m4 < lastPeriodForDepr; ++m4) {
                        if (this.mFaArea.getInterruptDeprFromDate() != null) {
                            if (DateHelper.between((Date)finPeriods[m4].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                                periodValues[m4][1] = BigDecimal.ZERO;
                                continue;
                            }
                            if (numberOfMonthForDepr > periodIndex) {
                                periodValues[m4][1] = yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr - periodIndex), 20, RoundingMode.HALF_EVEN);
                                continue;
                            }
                            periodValues[m4][1] = yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr), 20, RoundingMode.HALF_EVEN);
                            continue;
                        }
                        periodValues[m4][1] = numberOfMonthForDepr > periodIndex ? yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr - periodIndex), 20, RoundingMode.HALF_EVEN) : yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr), 20, RoundingMode.HALF_EVEN);
                    }
                } else {
                    for (m4 = periodIndex; m4 < lastPeriodForDepr; ++m4) {
                        if (this.mFaArea.getInterruptDeprFromDate() != null) {
                            if (DateHelper.between((Date)finPeriods[m4].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                                periodValues[m4][1] = BigDecimal.ZERO;
                                continue;
                            }
                            periodValues[m4][1] = yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr), 20, RoundingMode.HALF_EVEN);
                            continue;
                        }
                        if (this.mJurisdiction_AT && isFullDisposal && fullDisposalDate != null && fatDisposal != null && (fatDisposal.getFullDisposDeprecUntil() == FullDisposDeprecUntilEnum.DUE_HALF_YEAR_AT || this.mDeprArea.getNote().equals("VOLLABGANG")) && m4 >= fullDisposalMonth) {
                            periodValues[fullDisposalMonth][1] = periodValues[fullDisposalMonth][1].add(yearDeprAmount.divide(new BigDecimal(numberOfMonthForDepr), 20, RoundingMode.HALF_EVEN));
                            continue;
                        }
                        int realNumberOfMonthForDepr = numberOfMonthForDepr;
                        if (this.mJurisdiction_PL && thisYearComplete && !netBookValForResLife) {
                            realNumberOfMonthForDepr = finPeriods.length;
                        }
                        periodValues[m4][1] = yearDeprAmount.divide(new BigDecimal(realNumberOfMonthForDepr), 20, RoundingMode.HALF_EVEN);
                    }
                }
            } else {
                Date interruptDeprToDate;
                Date lastDay;
                int daysInYear = 365;
                if (finYear != null) {
                    daysInYear = DateHelper.getDiffInDays((Date)finYear.getValidUntil(), (Date)finYear.getValidFrom()) + 1;
                }
                int startPeriod = lastPeriodForDepr - numberOfMonthForDepr;
                if (this.mFaArea.getStatus() == StatusEnum.STE_LOW_VALUE_5_YEARS) {
                    startPeriod = periodIndex;
                }
                if (startPeriod < 0) {
                    startPeriod = 0;
                }
                if (deprMethod != null && deprMethod.getDepreciationType().value() == 4) {
                    startPeriod += periodIndex;
                }
                Date firstDay = DateHelper.before((Date)this.mFaArea.getDeprStartDate(), (Date)finYear.getValidFrom()) ? finYear.getValidFrom() : this.mFaArea.getDeprStartDate();
                Calendar cal = DateHelper.toCalendar((String)DateMapper.toString((Date)this.mFaArea.getDeprStartDate()));
                Calendar cal1 = DateHelper.toCalendar((String)DateMapper.toString((Date)this.mFaArea.getDeprStartDate()));
                cal.add(5, this.mFaArea.getUsefullLifeInDays());
                cal1.add(2, this.mFaArea.getUsefullLifeInMonth());
                cal.add(5, -1);
                cal1.add(5, -1);
                Date date = lastDay = !lessThanPeriodsLength && DateHelper.after((Date)cal.getTime(), (Date)finYear.getValidUntil()) ? finYear.getValidUntil() : cal.getTime();
                if (thisYearComplete || lessThanPeriodsLength) {
                    if (DateHelper.before((Date)lastDay, (Date)finYear.getValidFrom())) {
                        if (this.mFromTransaction && dch.getTransactionType().value() == 3 && this.mDeprArea.getCalcRemLifeForPostCapitalization() && this.mJurisdiction_PL) {
                            lastDay = finYear.getValidFrom();
                            daysInYear = DateHelper.getDiffInDays((Date)lastDay, (Date)DateHelper.yesterday((Date)firstDay));
                        } else {
                            daysInYear = 0;
                        }
                    } else {
                        daysInYear = DateHelper.getDiffInDays((Date)lastDay, (Date)DateHelper.yesterday((Date)firstDay));
                    }
                }
                if ((interruptDeprToDate = this.mFaArea.getInterruptDeprToDate()) == null) {
                    interruptDeprToDate = DateHelper.tomorrow((Date)this.mDepreciationUntilDate);
                }
                if (daysInYear > 0) {
                    for (m2 = periodIndex; m2 < lastPeriodForDepr; ++m2) {
                        VDate vdate = new VDate(finPeriods[m2].getValidUntil());
                        if (m2 == lastPeriodForDepr - 1 && thisYearComplete) {
                            if (DateHelper.before((Date)cal.getTime(), (Date)finYear.getValidFrom()) && this.mFromTransaction && dch.getTransactionType().value() == 3 && this.mDeprArea.getCalcRemLifeForPostCapitalization() && this.mJurisdiction_PL) {
                                vdate = new VDate(finYear.getValidFrom());
                            } else {
                                cal = DateHelper.toCalendar((String)DateMapper.toString((Date)this.mFaArea.getDeprStartDate()));
                                cal.add(2, this.mFaArea.getUsefullLifeInMonth());
                                vdate = new VDate(DateHelper.yesterday((Date)cal.getTime()));
                            }
                        }
                        periodValues[m2][1] = this.mFaArea.getInterruptDeprFromDate() != null ? (DateHelper.between((Date)finPeriods[m2].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate) ? BigDecimal.ZERO : yearDeprAmount.divide(new BigDecimal(daysInYear), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(vdate.getDay()))) : yearDeprAmount.divide(new BigDecimal(daysInYear), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(vdate.getDay()));
                        if (!isFirstYearOfDepr || m2 != periodIndex || !DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)DateHelper.getFirstDayOfMonth((Date)this.mFaArea.getDeprStartDate()))) continue;
                        int numberOfDays = DateHelper.getDate((Date)DateHelper.getLastDayOfMonth((Date)this.mFaArea.getDeprStartDate())) - DateHelper.getDate((Date)DateHelper.yesterday((Date)this.mFaArea.getDeprStartDate()));
                        periodValues[m2][1] = periodValues[m2][1].divide(new BigDecimal(DateHelper.getDate((Date)DateHelper.getLastDayOfMonth((Date)this.mFaArea.getDeprStartDate()))), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(numberOfDays));
                    }
                }
            }
            if (!(this.mFaArea.getDeprArea().getAverage() || (dch.getTransactionType() != TransactionEnum.TRE_POST_CAPITALIZATION && dch.getTransactionType() != TransactionEnum.TRE_PARTIAL_ADDITION && dch.getTransactionType() != TransactionEnum.TRE_PARTIAL_ADDITION_SPLIT && dch.getTransactionType() != TransactionEnum.TRE_WRITE_DOWN_CURR_VALUE && dch.getTransactionType() != TransactionEnum.TRE_WRITE_UP && dch.getTransactionType() != TransactionEnum.TRE_REVALUATION && dch.getTransactionType() != TransactionEnum.TRE_CREDIT_NOTE && dch.getTransactionType() != TransactionEnum.TRE_CREDIT_NOTE_SPLIT || this.mDeprArea.getAddAcquisitions() != DepreciationFromUntilEnum.DFUE_DOCUMENT_DATE && this.mDeprArea.getAddAcquisitions() != DepreciationFromUntilEnum.DFUE_POSTING_DATE) && (dch.getTransactionType() != TransactionEnum.TRE_PARTIAL_DISPOSAL && dch.getTransactionType() != TransactionEnum.TRE_PARTIAL_REPOST || this.mDeprArea.getPartitialRetirement() != DepreciationFromUntilEnum.DFUE_DOCUMENT_DATE && this.mDeprArea.getPartitialRetirement() != DepreciationFromUntilEnum.DFUE_POSTING_DATE) && (dch.getTransactionType() != TransactionEnum.TRE_FULL_DISPOSAL && dch.getTransactionType() != TransactionEnum.TRE_FULL_REPOST && dch.getTransactionType() != TransactionEnum.TRE_REPOST_ADDITION || dch.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_DOCUMENT_DATE && dch.getFullDisposalDeprUntilType() != FullDisposDeprecUntilEnum.DUE_POSTING_DATE))) {
                this.calculateDepreciationValue(this.mFaArea, dch, transactCache, periodValues, periodIndex, finPeriods);
            }
            BigDecimal sumPeriodDeprAmounts = BigDecimal.ZERO;
            BigDecimal sumRealPeriodDeprAmounts = BigDecimalMapper.ZERO.setScale(20);
            for (int m5 = 0; m5 < lastPeriodForDepr; ++m5) {
                sumRealPeriodDeprAmounts = sumRealPeriodDeprAmounts.add(periodValues[m5][1]);
            }
            int realNumberOfMonthForDepr = finYear.getFinancialPeriods().length;
            if (this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)finYear.getValidFrom()) && BigDecimalMapper.compareTo((BigDecimal)sumRealPeriodDeprAmounts, (BigDecimal)new BigDecimal("12.00")) < 0) {
                realNumberOfMonthForDepr = DateHelper.getDiffInMonths((Date)finYear.getValidUntil(), (Date)this.mFaArea.getDeprStartDate()) + 1;
            }
            if (!this.mKeepNetBookValueWithDecimalPlaces && BigDecimalMapper.compareTo((BigDecimal)sumRealPeriodDeprAmounts, (BigDecimal)new BigDecimal(realNumberOfMonthForDepr).setScale(2)) >= 0) {
                if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1 && thisYearComplete && lastPeriodForDepr <= finPeriods.length - 1) {
                    for (m = periodIndex; m < finPeriods.length; ++m) {
                        periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                    }
                } else {
                    for (m = periodIndex; m < lastPeriodForDepr - 1; ++m) {
                        periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                    }
                }
            } else {
                for (m = periodIndex; m < lastPeriodForDepr - 1; ++m) {
                    periodValues[m][0] = periodValues[m][1].setScale(2, RoundingMode.HALF_EVEN);
                }
            }
            boolean isDeprForLastMonthInFirstYear = false;
            if (!(this.mKeepNetBookValueWithDecimalPlaces || BigDecimalMapper.compareTo((BigDecimal)dch.getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) <= 0 || this.mYearDeprAmountLess || BigDecimalMapper.isZeroOrNull((BigDecimal)(decimalPlacesOnly = new BigDecimal(dch.getNetBookValue().doubleValue() % 1.0).setScale(2, RoundingMode.HALF_EVEN))))) {
                if (this.mFaArea.getInterruptDeprFromDate() == null) {
                    if (periodIndex == lastPeriodForDepr - 1 && BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[periodIndex][0]) && !BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[periodIndex][1]) && this.mFaArea.getDeprStartDate() != null && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)finYear.getValidFrom())) {
                        periodValues[periodIndex][0] = DepreciationCalculation.roundingAmount(periodValues[periodIndex][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                        isDeprForLastMonthInFirstYear = true;
                    }
                    periodValues[periodIndex][0] = periodValues[periodIndex][0].add(decimalPlacesOnly);
                } else {
                    Date interruptDeprToDate = this.mFaArea.getInterruptDeprToDate();
                    if (interruptDeprToDate == null) {
                        interruptDeprToDate = DateHelper.tomorrow((Date)this.mDepreciationUntilDate);
                    }
                    if (periodIndex == lastPeriodForDepr - 1 && BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[periodIndex][0]) && !BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[periodIndex][1]) && this.mFaArea.getDeprStartDate() != null && !DateHelper.between((Date)finPeriods[periodIndex].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate) && DateHelper.after((Date)this.mFaArea.getDeprStartDate(), (Date)finYear.getValidFrom())) {
                        periodValues[periodIndex][0] = DepreciationCalculation.roundingAmount(periodValues[periodIndex][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                        isDeprForLastMonthInFirstYear = true;
                    }
                    if (!DateHelper.between((Date)finPeriods[periodIndex].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                        periodValues[periodIndex][0] = periodValues[periodIndex][0].add(decimalPlacesOnly);
                    }
                }
            }
            boolean periodAmountsNotValid = false;
            for (int m6 = 0; m6 < lastPeriodForDepr; ++m6) {
                if (m6 < lastPeriodForDepr - 1) {
                    sumPeriodDeprAmounts = sumPeriodDeprAmounts.add(periodValues[m6][0]);
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[m6][0]) || BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[m6][1])) continue;
                    periodValues[m6][1] = BigDecimal.ZERO;
                    periodAmountsNotValid = true;
                    continue;
                }
                if (periodAmountsNotValid) {
                    sumRealPeriodDeprAmounts = BigDecimalMapper.ZERO.setScale(20);
                    for (int n = 0; n < lastPeriodForDepr; ++n) {
                        sumRealPeriodDeprAmounts = sumRealPeriodDeprAmounts.add(periodValues[n][1]);
                    }
                }
                if (!isDeprForLastMonthInFirstYear && !BigDecimalMapper.isZeroOrNull((BigDecimal)periodValues[m6][1])) {
                    periodValues[m6][0] = this.mDeprArea.getCalcRemLifeForPostCapitalization() && this.mJurisdiction_PL && !thisYearComplete ? (FixedAssetTransaction.checkExistenceOfPostCapitalizationForPeriod((FixedAssetData)this.mFixedAsset, (DepreciationArea)this.mDeprArea, (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil()) ? periodValues[m6][1] : sumRealPeriodDeprAmounts.subtract(sumPeriodDeprAmounts)) : sumRealPeriodDeprAmounts.subtract(sumPeriodDeprAmounts);
                    if (!this.mKeepNetBookValueWithDecimalPlaces && BigDecimalMapper.compareTo((BigDecimal)sumRealPeriodDeprAmounts, (BigDecimal)new BigDecimal("12.00")) >= 0) {
                        periodValues[m6][0] = BigDecimalMapper.compareTo((BigDecimal)sumPeriodDeprAmounts, (BigDecimal)sumRealPeriodDeprAmounts) > 0 ? BigDecimal.ZERO : DepreciationCalculation.roundingAmount(periodValues[m6][0], this.mFaArea.getDeprArea().getRoundingDep().value());
                    }
                }
                if (thisYearComplete) {
                    periodValues[m6][0] = dch.getNetBookValue();
                    for (int n = periodIndex; n < lastPeriodForDepr - 1; ++n) {
                        periodValues[m6][0] = periodValues[m6][0].subtract(periodValues[n][0]);
                    }
                    periodValues[m6][0] = periodValues[m6][0].subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
                }
                periodValues[m6][0] = periodValues[m6][0].setScale(2, RoundingMode.HALF_EVEN);
            }
            if (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero()) {
                BigDecimal resNetBookValue = dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
                BigDecimal manualDepr = DepreciationCalculation.getManualDepreciationForPeriod(transactCache, finPeriods[periodIndex].getValidFrom(), finYear.getValidUntil());
                if (BigDecimalMapper.compareTo((BigDecimal)manualDepr, (BigDecimal)BigDecimal.ZERO) > 0) {
                    BigDecimal increasingNetBookValuePeriod = DepreciationCalculation.getAdditionsAndDisposalForPeriod(transactCache, finPeriods[periodIndex].getValidFrom(), finYear.getValidUntil());
                    resNetBookValue = resNetBookValue.add(increasingNetBookValuePeriod).subtract(DepreciationCalculation.getManualDepreciationForPeriod(transactCache, finPeriods[periodIndex].getValidFrom(), finYear.getValidUntil()));
                }
                for (m2 = periodIndex; m2 < lastPeriodForDepr; ++m2) {
                    if (BigDecimalMapper.isZero((BigDecimal)resNetBookValue)) {
                        if ((dch.getTransactionType() == TransactionEnum.TRE_FULL_DISPOSAL || dch.getTransactionType() == TransactionEnum.TRE_FULL_REPOST) && DateHelper.before((Date)dch.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)dch.getProcessingDate())) && DateHelper.after((Date)dch.getProcessingDate(), (Date)DateHelper.getFirstDayOfMonth((Date)dch.getProcessingDate()))) continue;
                        periodValues[m2][0] = BigDecimal.ZERO;
                        continue;
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)periodValues[m2][0], (BigDecimal)resNetBookValue) > 0) {
                        periodValues[m2][0] = resNetBookValue;
                        resNetBookValue = BigDecimal.ZERO;
                        continue;
                    }
                    resNetBookValue = resNetBookValue.subtract(periodValues[m2][0]);
                }
            }
            int indexOfAcquisitionPeriod = -1;
            Date beginDate = this.mFixedAsset.getAcquisitionDate();
            if (this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
                beginDate = this.mFixedAsset.getCommissioningDate();
            }
            if (activationDate != null && DateHelper.after((Date)activationDate, (Date)DateHelper.getLastDayOfMonth((Date)beginDate))) {
                beginDate = activationDate;
            }
            if (DateHelper.after((Date)beginDate, (Date)finYear.getValidFrom())) {
                indexOfAcquisitionPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)beginDate);
            }
            if (indexOfAcquisitionPeriod != -1) {
                BigDecimal deprAmountForStartPeriod = BigDecimal.ZERO;
                for (int m7 = 0; m7 <= indexOfAcquisitionPeriod; ++m7) {
                    deprAmountForStartPeriod = deprAmountForStartPeriod.add(periodValues[m7][0]);
                    periodValues[m7][0] = BigDecimal.ZERO;
                }
                periodValues[indexOfAcquisitionPeriod][0] = deprAmountForStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1 || this.mCalcMethod.getMethodTypeEnum().value() == 0 && ((DepreciationMethodData)this.mCalcMethod).getDistributionFirstYear() == DistributionFirstYearEnum.DFYE_COMPLETE_LAST_MONTH && isFirstYearOfDepr) {
                sumPeriodDeprAmounts = BigDecimal.ZERO;
                lastPeriodForDepr = periodValues.length - 1;
                if (this.mFaArea.getIsFullDisposed() && this.mFaArea.getRetirementDate() != null && DateHelper.between((Date)this.mFaArea.getRetirementDate(), (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil())) {
                    lastPeriodForDepr = finYear.getFAFinancialPeriodIndexForDate(this.mFaArea.getRetirementDate()) + 1;
                }
                if (this.mFaArea.getUsefullLifeInMonth() < 12 && this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 0) {
                    int indexDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)this.mFaArea.getDeprStartDate());
                    if ((indexDeprStartPeriod += this.mFaArea.getUsefullLifeInMonth()) < 12) {
                        lastPeriodForDepr = indexDeprStartPeriod;
                    }
                }
                for (int m8 = this.indexOfDeprStartPeriod; m8 < lastPeriodForDepr; ++m8) {
                    sumPeriodDeprAmounts = sumPeriodDeprAmounts.add(periodValues[m8][0]);
                    periodValues[m8][0] = BigDecimal.ZERO;
                }
                int lastPer = lastPeriodForDepr - 1;
                if (lastPer < 0) {
                    lastPer = 11;
                }
                periodValues[lastPer][0] = this.mYearDeprAmountLess && !this.mKeepNetBookValueWithDecimalPlaces && isFirstYearOfDepr ? DepreciationCalculation.roundingAmount(sumPeriodDeprAmounts, this.mFaArea.getDeprArea().getRoundingDep().value()) : sumPeriodDeprAmounts.setScale(2, RoundingMode.HALF_EVEN);
            } else if (this.mCalcMethod.getMethodTypeEnum().value() == 0 && ((DepreciationMethodData)this.mCalcMethod).getDistributionFirstYear() == DistributionFirstYearEnum.DFYE_COMPLETE_FIRST_MONTH && isFirstYearOfDepr) {
                sumPeriodDeprAmounts = BigDecimal.ZERO;
                int indexFordeprStart = this.indexOfDeprStartPeriod;
                if (indexOfAcquisitionPeriod > this.indexOfDeprStartPeriod) {
                    indexFordeprStart = indexOfAcquisitionPeriod;
                }
                for (int m9 = indexFordeprStart; m9 <= lastPeriodForDepr; ++m9) {
                    sumPeriodDeprAmounts = sumPeriodDeprAmounts.add(periodValues[m9][0]);
                    periodValues[m9][0] = BigDecimal.ZERO;
                }
                periodValues[indexFordeprStart][0] = sumPeriodDeprAmounts.setScale(2, RoundingMode.HALF_EVEN);
            }
        } else {
            LOGGER.debug("- in Method 'calculateDepreciation': baseForDeprAmount = ZERO, es wurde keine weitere Berechnung duchgef\u00fchrt !");
        }
        if (this.mDeprArea.getSpecialDep() && this.mCalcMethodSpecDepr != null && this.mFaArea.getSpecDeprStartDate() != null && !DateHelper.after((Date)this.mFaArea.getSpecDeprStartDate(), (Date)finYear.getValidUntil())) {
            int m;
            this.calculateSepcialDepreciation(finYear, finPeriods, periodIndex, periodValues, dch);
            BigDecimal resNetBookValue = dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
            resNetBookValue = resNetBookValue.subtract(DepreciationCalculation.getManualDepreciationForPeriod(transactCache, finPeriods[periodIndex].getValidFrom(), finYear.getValidUntil()));
            for (m = periodIndex; m < lastPeriodForDepr; ++m) {
                BigDecimal totalDepr = periodValues[m][0].add(periodValues[m][2]);
                if (BigDecimalMapper.compareTo((BigDecimal)totalDepr, (BigDecimal)resNetBookValue) > 0) {
                    if (resNetBookValue.compareTo(BigDecimal.ZERO) >= 0) {
                        periodValues[m][0] = resNetBookValue.multiply(periodValues[m][0]).divide(totalDepr, 0, RoundingMode.HALF_EVEN);
                        periodValues[m][2] = resNetBookValue.subtract(periodValues[m][0]);
                        resNetBookValue = BigDecimal.ZERO;
                        continue;
                    }
                    periodValues[m][0] = BigDecimal.ZERO;
                    periodValues[m][2] = BigDecimal.ZERO;
                    continue;
                }
                resNetBookValue = resNetBookValue.subtract(periodValues[m][0]);
                resNetBookValue = resNetBookValue.subtract(periodValues[m][2]);
            }
            if (performanceDepreciation && this.perfUnit != null) {
                for (m = periodIndex; m < lastPeriodForDepr; ++m) {
                    if (StringMapper.isNullString((String)this.periodUnits[m].getObjectid()) || this.periodUnits[m].getIsDepreciated()) continue;
                    this.periodUnits[m].makeSaveable();
                    this.periodUnits[m].setIsDepreciated(true);
                    this.periodUnits[m].setDepreciation(periodValues[m][0]);
                }
            }
        }
    }

    private BigDecimal calculateDepreciationForCheck(FAFinancialYear finYear, FAFinancialPeriod[] finPeriods, int periodIndex, boolean newDeprMethod, DepreciationMethodData deprMethod, DepreciationCalculationHelper dch) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculateDepreciationForCheck, year: {} -", (Object)finYear.getCode());
        }
        boolean thisYearComplete = false;
        boolean netBookValForResLife = false;
        BigDecimal yearDeprAmount = BigDecimal.ZERO;
        if (deprMethod.getDepreciationType().value() == 2) {
            netBookValForResLife = true;
        }
        int numberOfMonthForDepr = finPeriods.length;
        int numberOfDaysForDepr = finPeriods.length;
        if (dch.getResLifeInMonth() + periodIndex <= finPeriods.length && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero())) {
            thisYearComplete = true;
            numberOfMonthForDepr = dch.getResLifeInMonth();
            numberOfDaysForDepr = dch.getResLifeInDays();
        }
        if (thisYearComplete) {
            netBookValForResLife = true;
        }
        BigDecimal baseForDeprAmount = DepreciationCalculation.getBaseForDepreciation(dch, (CalcMethod)deprMethod, this.mFaArea, finPeriods[periodIndex].getValidUntil(), this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage);
        if (thisYearComplete) {
            baseForDeprAmount = dch.getNetBookValue();
        }
        if (baseForDeprAmount.compareTo(BigDecimal.ZERO) > 0 || dch.getTransactionType().value() == 6 || dch.getTransactionType().value() == 5 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 25 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 4 && baseForDeprAmount.compareTo(BigDecimal.ZERO) == 0) {
            this.depreciationPercent = this.mFaArea.getDepreciationPercent();
            if (newDeprMethod) {
                if (this.mJurisdiction_PL || this.mJurisdiction_FR) {
                    if (deprMethod.getDepreciationType().value() == 0 && dch.getResLifeInMonth() > 0) {
                        this.depreciationPercent = new BigDecimal(100 / (dch.getUsefullLifeInMonth() / 12));
                    }
                } else if (!BigDecimalMapper.isZeroOrNull((BigDecimal)deprMethod.getPercentage())) {
                    this.depreciationPercent = deprMethod.getPercentage();
                } else {
                    double lifeInMonth = 0.0;
                    BigDecimal deprPercent = BigDecimal.ZERO;
                    if (deprMethod.getPeriodInYears() > 0) {
                        lifeInMonth = deprMethod.getPeriodInYears() * 12;
                    }
                    if (deprMethod.getPeriodInMonth() > 0) {
                        lifeInMonth += (double)deprMethod.getPeriodInMonth();
                    }
                    if (lifeInMonth == 0.0) {
                        lifeInMonth = this.mFaArea.getUsefullLifeInMonth();
                    }
                    double calcBase = 1200.0;
                    deprPercent = new BigDecimal(1200.0 / lifeInMonth);
                    this.depreciationPercent = deprPercent = deprPercent.setScale(2, RoundingMode.HALF_EVEN);
                }
            }
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.depreciationPercent)) {
                this.depreciationPercent = deprMethod.getPercentage();
            }
            if (this.depreciationPercent == null) {
                this.depreciationPercent = BigDecimal.ZERO;
            }
            if (netBookValForResLife) {
                yearDeprAmount = dch.getResLifeInMonth() > 0 ? (this.mDeprArea.getDayExact() ? dch.getNetBookValue().multiply(new BigDecimal(numberOfDaysForDepr)).divide(new BigDecimal(dch.getResLifeInDays()), 2, RoundingMode.HALF_EVEN) : dch.getNetBookValue().multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN)) : BigDecimal.ZERO;
            } else {
                yearDeprAmount = baseForDeprAmount.multiply(this.depreciationPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                if (finPeriods.length < 12) {
                    yearDeprAmount = yearDeprAmount.multiply(new BigDecimal(finPeriods.length)).divide(new BigDecimal("12.00"), 2, RoundingMode.HALF_EVEN);
                }
            }
            if (thisYearComplete) {
                yearDeprAmount = yearDeprAmount.subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
            }
        } else {
            LOGGER.debug("- in Method 'calculateDepreciation': baseForDeprAmount = ZERO, es wurde keine weitere Berechnung duchgef\u00fchrt !");
        }
        return yearDeprAmount;
    }

    private void calculateSepcialDepreciation(FAFinancialYear finYear, FAFinancialPeriod[] finPeriods, int periodIndex, BigDecimal[][] periodValues, DepreciationCalculationHelper dch) {
        LOGGER.debug("calculateSepcialDepreciation(...)");
        boolean thisYearComplete = false;
        boolean netBookValForResLife = false;
        int numberOfMonthForDepr = finPeriods.length;
        int numberOfDaysForDepr = DateHelper.getDiffInDays((Date)finYear.getValidUntil(), (Date)finYear.getValidFrom()) + 1;
        int numberOfMonthForDeprFirstYear = 0;
        this.indexOfSpecDeprStartPeriod = this.indexOfDeprStartPeriod;
        if (this.mFaArea.getSpecDeprStartDate() != null) {
            if (DateHelper.between((Date)this.mFaArea.getSpecDeprStartDate(), (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil())) {
                numberOfMonthForDeprFirstYear = DateHelper.getDiffInMonths((Date)finYear.getValidUntil(), (Date)this.mFaArea.getSpecDeprStartDate()) + 1;
            }
            if (DateHelper.after((Date)this.mFaArea.getSpecDeprStartDate(), (Date)finYear.getValidFrom())) {
                this.indexOfSpecDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)this.mFaArea.getSpecDeprStartDate());
            }
        }
        if (dch.getLastDeprDate() != null && DateHelper.after((Date)dch.getLastDeprDate(), (Date)finYear.getValidFrom())) {
            this.indexOfSpecDeprStartPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)dch.getLastDeprDate())));
        }
        if (dch.getResLifeInMonth() + periodIndex <= finPeriods.length && (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero())) {
            thisYearComplete = true;
            numberOfMonthForDepr = dch.getResLifeInMonth();
            numberOfDaysForDepr = dch.getResLifeInDays();
        }
        if (thisYearComplete) {
            netBookValForResLife = true;
        }
        int actSpecDeprYearNo = 0;
        Date specDeprStartDate = this.mFaArea.getSpecDeprStartDate();
        VDate vdate = new VDate(specDeprStartDate);
        while (specDeprStartDate != null && !DateHelper.between((Date)specDeprStartDate, (Date)finYear.getValidFrom(), (Date)finYear.getValidUntil())) {
            vdate.addYears(1);
            specDeprStartDate = vdate.getDate();
            ++actSpecDeprYearNo;
        }
        BigDecimal baseForSpecDeprAmount = DepreciationCalculation.getBaseForDepreciation(dch, this.mCalcMethodSpecDepr, this.mFaArea, null, null, this.mIsDeprPreview, this.mGlobalLanguage);
        if (actSpecDeprYearNo < ((SpecDepreciationMethodData)this.mCalcMethodSpecDepr).getPercents().length && (baseForSpecDeprAmount.compareTo(BigDecimal.ZERO) > 0 || dch.getTransactionType().value() == 6 || dch.getTransactionType().value() == 5 && baseForSpecDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 25 && baseForSpecDeprAmount.compareTo(BigDecimal.ZERO) == 0 || dch.getTransactionType().value() == 4 && baseForSpecDeprAmount.compareTo(BigDecimal.ZERO) == 0)) {
            int m;
            BigDecimal possibleSpecDeprValue;
            BigDecimal yearSpecDeprAmount;
            BigDecimal specDeprPercent = BigDecimal.ZERO;
            if (actSpecDeprYearNo < ((SpecDepreciationMethodData)this.mCalcMethodSpecDepr).getPercents().length) {
                specDeprPercent = ((SpecDepreciationMethodData)this.mCalcMethodSpecDepr).getPercents()[actSpecDeprYearNo].getPercentage();
            }
            if (specDeprPercent == null) {
                specDeprPercent = BigDecimal.ZERO;
            }
            int lastPeriodForDepr = numberOfMonthForDepr;
            if ((lastPeriodForDepr += periodIndex) > numberOfMonthForDepr) {
                lastPeriodForDepr = numberOfMonthForDepr;
            }
            if (netBookValForResLife) {
                yearSpecDeprAmount = dch.getResLifeInMonth() > 0 && BigDecimalMapper.compareTo((BigDecimal)specDeprPercent, (BigDecimal)BigDecimal.ZERO) > 0 ? (this.mDeprArea.getDayExact() ? dch.getNetBookValue().multiply(new BigDecimal(numberOfDaysForDepr)).divide(new BigDecimal(dch.getResLifeInDays()), 2, RoundingMode.HALF_EVEN) : dch.getNetBookValue().multiply(new BigDecimal(numberOfMonthForDepr)).divide(new BigDecimal(dch.getResLifeInMonth()), 2, RoundingMode.HALF_EVEN)) : BigDecimal.ZERO;
            } else {
                yearSpecDeprAmount = baseForSpecDeprAmount.multiply(specDeprPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                if (finPeriods.length < 12) {
                    yearSpecDeprAmount = yearSpecDeprAmount.multiply(new BigDecimal(finPeriods.length)).divide(new BigDecimal("12.00"), 2, RoundingMode.HALF_EVEN);
                }
            }
            if (thisYearComplete) {
                yearSpecDeprAmount = yearSpecDeprAmount.subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
            }
            if (!(this.mCalcMethodSpecDepr.getBaseForCalc().value() != 0 && this.mCalcMethodSpecDepr.getBaseForCalc().value() != 1 && this.mCalcMethodSpecDepr.getBaseForCalc().value() != 8 || BigDecimalMapper.isZeroOrNull((BigDecimal)baseForSpecDeprAmount) || BigDecimalMapper.compareTo((BigDecimal)(possibleSpecDeprValue = baseForSpecDeprAmount.multiply(((SpecDepreciationMethodData)this.mCalcMethodSpecDepr).getPercentage()).divide(HUNDRED, RoundingMode.HALF_DOWN).subtract(dch.getAccumSpecDepreciationAmountTotal())), (BigDecimal)yearSpecDeprAmount) >= 0)) {
                yearSpecDeprAmount = possibleSpecDeprValue;
            }
            if (this.indexOfSpecDeprStartPeriod > periodIndex) {
                periodIndex = this.indexOfSpecDeprStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getAverage()) {
                for (int m2 = periodIndex; m2 < lastPeriodForDepr; ++m2) {
                    periodValues[m2][3] = numberOfMonthForDeprFirstYear > 0 ? yearSpecDeprAmount.divide(new BigDecimal(numberOfMonthForDeprFirstYear), 20, RoundingMode.HALF_EVEN) : yearSpecDeprAmount.divide(new BigDecimal(numberOfMonthForDepr), 20, RoundingMode.HALF_EVEN);
                }
            } else {
                VDate date;
                int daysInYear = 0;
                int startPeriod = lastPeriodForDepr - numberOfMonthForDepr;
                if (numberOfMonthForDeprFirstYear > 0) {
                    startPeriod = lastPeriodForDepr - numberOfMonthForDeprFirstYear;
                }
                if (startPeriod < 0) {
                    startPeriod = 0;
                }
                for (m = startPeriod; m < lastPeriodForDepr; ++m) {
                    date = new VDate(finPeriods[m].getValidUntil());
                    daysInYear += date.getDay();
                }
                for (m = periodIndex; m < lastPeriodForDepr; ++m) {
                    date = new VDate(finPeriods[m].getValidUntil());
                    periodValues[m][3] = yearSpecDeprAmount.divide(new BigDecimal(daysInYear), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(date.getDay()));
                }
            }
            BigDecimal sumPeriodDeprAmounts = BigDecimal.ZERO;
            BigDecimal sumRealPeriodDeprAmounts = BigDecimal.ZERO.setScale(20);
            for (m = 0; m < lastPeriodForDepr; ++m) {
                sumRealPeriodDeprAmounts = sumRealPeriodDeprAmounts.add(periodValues[m][3]);
            }
            if (BigDecimalMapper.compareTo((BigDecimal)sumRealPeriodDeprAmounts, (BigDecimal)yearSpecDeprAmount) > 0) {
                sumRealPeriodDeprAmounts = yearSpecDeprAmount;
            }
            if (!this.mKeepNetBookValueWithDecimalPlaces) {
                for (m = periodIndex; m < lastPeriodForDepr - 1; ++m) {
                    periodValues[m][2] = DepreciationCalculation.roundingAmount(periodValues[m][3], this.mFaArea.getDeprArea().getRoundingDep().value());
                }
            } else {
                for (m = periodIndex; m < lastPeriodForDepr - 1; ++m) {
                    periodValues[m][2] = periodValues[m][3].setScale(2, RoundingMode.HALF_EVEN);
                }
            }
            for (m = 0; m < lastPeriodForDepr; ++m) {
                if (m < lastPeriodForDepr - 1) {
                    sumPeriodDeprAmounts = sumPeriodDeprAmounts.add(periodValues[m][2]);
                    continue;
                }
                periodValues[m][2] = sumRealPeriodDeprAmounts.subtract(sumPeriodDeprAmounts);
                if (!this.mKeepNetBookValueWithDecimalPlaces) {
                    periodValues[m][2] = DepreciationCalculation.roundingAmount(periodValues[m][2], this.mFaArea.getDeprArea().getRoundingDep().value());
                }
                periodValues[m][2] = periodValues[m][2].setScale(2, RoundingMode.HALF_EVEN);
            }
            if (!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero()) {
                BigDecimal resNetBookValue = dch.getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea));
                for (int m3 = periodIndex; m3 < lastPeriodForDepr; ++m3) {
                    if (BigDecimalMapper.compareTo((BigDecimal)periodValues[m3][2], (BigDecimal)resNetBookValue) > 0) {
                        periodValues[m3][2] = resNetBookValue;
                        resNetBookValue = BigDecimal.ZERO;
                        continue;
                    }
                    resNetBookValue = resNetBookValue.subtract(periodValues[m3][2]);
                }
            }
            int indexOfAcquisitionPeriod = -1;
            Date beginDate = this.mFixedAsset.getAcquisitionDate();
            if (this.mJurisdiction_AT && this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
                beginDate = this.mFixedAsset.getCommissioningDate();
            }
            if (DateHelper.after((Date)beginDate, (Date)finYear.getValidFrom())) {
                indexOfAcquisitionPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)beginDate);
            }
            if (indexOfAcquisitionPeriod != -1) {
                BigDecimal deprAmountForStartPeriod = BigDecimal.ZERO;
                for (int m4 = 0; m4 <= indexOfAcquisitionPeriod; ++m4) {
                    deprAmountForStartPeriod = deprAmountForStartPeriod.add(periodValues[m4][2]);
                    periodValues[m4][2] = BigDecimal.ZERO;
                }
                periodValues[indexOfAcquisitionPeriod][2] = deprAmountForStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1) {
                sumPeriodDeprAmounts = BigDecimal.ZERO;
                for (int m5 = this.indexOfSpecDeprStartPeriod; m5 < lastPeriodForDepr; ++m5) {
                    sumPeriodDeprAmounts = sumPeriodDeprAmounts.add(periodValues[m5][2]);
                    periodValues[m5][2] = BigDecimal.ZERO;
                }
                int lastPer = lastPeriodForDepr - 1;
                if (lastPer < 0) {
                    lastPer = 11;
                }
                periodValues[lastPer][2] = sumPeriodDeprAmounts.setScale(2, RoundingMode.HALF_EVEN);
            }
        }
    }

    private void calculateInterests(FAFinancialYear finYear, FAFinancialPeriod[] finPeriods, int periodIndex, BigDecimal[][] periodValues, DepreciationCalculationHelper dch, List<DepreciationCalculationHelper> transactCache) {
        BigDecimal baseForInterestAmount;
        DepreciationCalculation deprCalcForBalArea;
        List<DepreciationCalculationHelper> balTransactCache;
        FixedAssetArea balanceArea;
        ImputedInterestMethodData interestMethod;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculateInterests(...), year:{} - ", (Object)finYear.getCode());
        }
        if (!((interestMethod = CalcMethodPersistencyManager.getImputedInterestMethodData((String)this.mFaArea.getOidImputedInterestMethod())) == null || interestMethod.getBaseForCalc().value() != 12 && interestMethod.getBaseForCalc().value() != 14 && interestMethod.getBaseForCalc().value() != 13 || (balanceArea = FixedAssetAreaPersistencyManager.getFixedAssetArea((FixedAsset)this.mFaArea.getFixedAsset(), (DepreciationArea)DepreciationArea.getDepreciationAreaBelongsToBlanceSheet((AccountingCompany)this.mFaArea.getFixedAsset().getAccountCompany()))) == null || balanceArea.equals((Object)this.mFaArea) || (dch = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(balTransactCache = (deprCalcForBalArea = new DepreciationCalculation(balanceArea, DepreciationFunctionEnum.DEFE_CALCULATION)).buildTransactionsCache(null, null, null, false), DateHelper.yesterday((Date)finYear.getValidFrom()), false, false)) != null)) {
            dch = balTransactCache.get(0);
        }
        DepreciationCalculationHelper dchForBaseValue = dch;
        if (interestMethod != null && interestMethod.getBaseForCalc() == BaseCalcEnum.BCE_REST_VAL && dch.getProcessingDate() != null && DateHelper.equal((Date)dch.getProcessingDate(), (Date)finYear.getValidUntil()) && (dchForBaseValue = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)dch.getProcessingDate())), false, false)) == null) {
            dchForBaseValue = dch;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)(baseForInterestAmount = DepreciationCalculation.getBaseForDepreciation(dchForBaseValue, (CalcMethod)interestMethod, this.mFaArea, finPeriods[periodIndex].getValidUntil(), this.mProtocolMessages, this.mIsDeprPreview, this.mGlobalLanguage)))) {
            int m;
            int m2;
            BigDecimal interestPercent = this.mFaArea.getImputedInterestPercent();
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)interestPercent)) {
                interestPercent = interestMethod.getPercentage();
            }
            if (interestPercent == null) {
                interestPercent = BigDecimal.ZERO;
            }
            BigDecimal yearInterestAmount = baseForInterestAmount.multiply(interestPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
            if (this.indexOfDeprStartPeriod > periodIndex) {
                periodIndex = this.indexOfDeprStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getAverage()) {
                for (m2 = periodIndex; m2 < periodValues.length - 1; ++m2) {
                    periodValues[m2][1] = yearInterestAmount.divide(new BigDecimal("12.0"), 20, RoundingMode.HALF_EVEN);
                }
            } else {
                for (m2 = periodIndex; m2 < periodValues.length - 1; ++m2) {
                    VDate vdate = new VDate(finPeriods[m2].getValidUntil());
                    periodValues[m2][1] = yearInterestAmount.divide(new BigDecimal("365.0"), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(vdate.getDay()));
                }
            }
            BigDecimal sumPeriodInterestAmounts = BigDecimal.ZERO;
            BigDecimal sumRealPeriodInterestAmounts = BigDecimal.ZERO.setScale(20);
            for (m = 0; m < periodValues.length; ++m) {
                sumRealPeriodInterestAmounts = sumRealPeriodInterestAmounts.add(periodValues[m][1]);
            }
            if (!this.mKeepNetBookValueWithDecimalPlaces) {
                for (m = periodIndex; m < periodValues.length; ++m) {
                    periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][1], this.mFaArea.getDeprArea().getRoundingDep().value());
                }
            } else {
                for (m = periodIndex; m < periodValues.length - 1; ++m) {
                    periodValues[m][0] = periodValues[m][1].setScale(2, RoundingMode.HALF_EVEN);
                }
            }
            for (m = 0; m < periodValues.length - 1; ++m) {
                if (m < periodValues.length - 2) {
                    sumPeriodInterestAmounts = sumPeriodInterestAmounts.add(periodValues[m][0]);
                    continue;
                }
                periodValues[m][0] = sumRealPeriodInterestAmounts.subtract(sumPeriodInterestAmounts);
                if (!this.mKeepNetBookValueWithDecimalPlaces) {
                    periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][0], this.mFaArea.getDeprArea().getRoundingDep().value());
                }
                periodValues[m][0] = periodValues[m][0].setScale(2, RoundingMode.HALF_EVEN);
            }
            int indexOfAcquisitionPeriod = -1;
            Date beginDate = this.mFixedAsset.getAcquisitionDate();
            if (this.mJurisdiction_AT && this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
                beginDate = this.mFixedAsset.getCommissioningDate();
            }
            if (DateHelper.after((Date)beginDate, (Date)finYear.getValidFrom())) {
                indexOfAcquisitionPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)beginDate);
            }
            if (indexOfAcquisitionPeriod != -1) {
                BigDecimal interestAmountForStartPeriod = BigDecimal.ZERO;
                for (int m3 = 0; m3 <= indexOfAcquisitionPeriod; ++m3) {
                    interestAmountForStartPeriod = interestAmountForStartPeriod.add(periodValues[m3][0]);
                    periodValues[m3][0] = BigDecimal.ZERO;
                }
                periodValues[indexOfAcquisitionPeriod][0] = interestAmountForStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1) {
                sumPeriodInterestAmounts = BigDecimal.ZERO;
                for (int m4 = 0; m4 < periodValues.length - 1; ++m4) {
                    sumPeriodInterestAmounts = sumPeriodInterestAmounts.add(periodValues[m4][0]);
                    periodValues[m4][0] = BigDecimal.ZERO;
                }
                periodValues[periodValues.length - 2][0] = sumPeriodInterestAmounts.setScale(2, RoundingMode.HALF_EVEN);
            }
        }
    }

    private void calculateInterestsForMiddleRestValue(FAFinancialYear finYear, FAFinancialPeriod[] finPeriods, int periodIndex, BigDecimal[][] periodValues, List<DepreciationCalculationHelper> transactCache) {
        int m;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("calculateInterestsForMiddleRestValue(...), year: {} -", (Object)finYear.getCode());
        }
        ImputedInterestMethodData interestMethod = CalcMethodPersistencyManager.getImputedInterestMethodData((String)this.mFaArea.getOidImputedInterestMethod());
        BigDecimal baseForInterestAmount = BigDecimal.ZERO;
        BigDecimal interestPercent = this.mFaArea.getImputedInterestPercent();
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)interestPercent)) {
            interestPercent = interestMethod.getPercentage();
        }
        if (interestPercent == null) {
            interestPercent = BigDecimal.ZERO;
        }
        BigDecimal sumPeriodInterestAmounts = BigDecimal.ZERO;
        BigDecimal sumRealPeriodInterestAmounts = BigDecimal.ZERO.setScale(20);
        for (int i = periodIndex; i < periodValues.length - 1; ++i) {
            int m2;
            DepreciationCalculationHelper dchBegin = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, DateHelper.yesterday((Date)finPeriods[i].getValidFrom()), false, false);
            if (dchBegin == null) {
                dchBegin = transactCache.get(0);
            }
            DepreciationCalculationHelper dchEnd = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate(transactCache, finPeriods[i].getValidUntil(), false, false);
            baseForInterestAmount = dchBegin.getNetBookValue().add(dchEnd.getNetBookValue()).divide(new BigDecimal("2.00"), RoundingMode.HALF_EVEN);
            if (BigDecimalMapper.isZeroOrNull((BigDecimal)baseForInterestAmount)) continue;
            BigDecimal yearInterestAmount = baseForInterestAmount.multiply(interestPercent).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
            if (this.indexOfDeprStartPeriod > periodIndex) {
                periodIndex = this.indexOfDeprStartPeriod;
            }
            if (this.mFaArea.getDeprArea().getAverage()) {
                for (m2 = i; m2 < periodValues.length - 1; ++m2) {
                    periodValues[m2][1] = yearInterestAmount.divide(new BigDecimal("12.0"), 20, RoundingMode.HALF_EVEN);
                }
                continue;
            }
            for (m2 = i; m2 < periodValues.length - 1; ++m2) {
                VDate vdate = new VDate(finPeriods[m2].getValidUntil());
                periodValues[m2][1] = yearInterestAmount.divide(new BigDecimal("365.0"), 20, RoundingMode.HALF_EVEN).multiply(new BigDecimal(vdate.getDay()));
            }
        }
        for (m = 0; m < periodValues.length; ++m) {
            sumRealPeriodInterestAmounts = sumRealPeriodInterestAmounts.add(periodValues[m][1]);
        }
        if (!this.mKeepNetBookValueWithDecimalPlaces) {
            for (m = 0; m < periodValues.length; ++m) {
                periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][1], this.mFaArea.getDeprArea().getRoundingDep().value());
            }
        } else {
            for (m = 0; m < periodValues.length - 1; ++m) {
                periodValues[m][0] = periodValues[m][1].setScale(2, RoundingMode.HALF_EVEN);
            }
        }
        for (m = 0; m < periodValues.length - 1; ++m) {
            if (m < periodValues.length - 2) {
                sumPeriodInterestAmounts = sumPeriodInterestAmounts.add(periodValues[m][0]);
                continue;
            }
            periodValues[m][0] = sumRealPeriodInterestAmounts.subtract(sumPeriodInterestAmounts);
            if (!this.mKeepNetBookValueWithDecimalPlaces) {
                periodValues[m][0] = DepreciationCalculation.roundingAmount(periodValues[m][0], this.mFaArea.getDeprArea().getRoundingDep().value());
            }
            periodValues[m][0] = periodValues[m][0].setScale(2, RoundingMode.HALF_EVEN);
        }
        int indexOfAcquisitionPeriod = -1;
        Date beginDate = this.mFixedAsset.getAcquisitionDate();
        if (this.mJurisdiction_AT && this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
            beginDate = this.mFixedAsset.getCommissioningDate();
        }
        if (DateHelper.after((Date)beginDate, (Date)finYear.getValidFrom())) {
            indexOfAcquisitionPeriod = FAFinancialPeriod.getIndexOfFAFinancialPeriodForDate((FAFinancialPeriod[])finPeriods, (Date)beginDate);
        }
        if (indexOfAcquisitionPeriod != -1) {
            BigDecimal interestAmountForStartPeriod = BigDecimal.ZERO;
            for (int m3 = 0; m3 <= indexOfAcquisitionPeriod; ++m3) {
                interestAmountForStartPeriod = interestAmountForStartPeriod.add(periodValues[m3][0]);
                periodValues[m3][0] = BigDecimal.ZERO;
            }
            periodValues[indexOfAcquisitionPeriod][0] = interestAmountForStartPeriod;
        }
        if (this.mFaArea.getDeprArea().getDepreciationFrequencies().value() == 1) {
            sumPeriodInterestAmounts = BigDecimal.ZERO;
            for (int m4 = 0; m4 < periodValues.length - 1; ++m4) {
                sumPeriodInterestAmounts = sumPeriodInterestAmounts.add(periodValues[m4][0]);
                periodValues[m4][0] = BigDecimal.ZERO;
            }
            periodValues[periodValues.length - 1][0] = sumPeriodInterestAmounts.setScale(2, RoundingMode.HALF_EVEN);
        }
    }

    private void cancelAllFollowingTransactions(List<DepreciationCalculationHelper> transactCache, Date lastDate, boolean isFullRepost) {
        LOGGER.debug("cancelAllFollowingTransactions(...)");
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (lastDate != null && isFullRepost && DateHelper.equal((Date)dch.getProcessingDate(), (Date)lastDate) && !dch.getIsCanceled() && !dch.getIsCancelation() && (dch.getTransactionType().value() == 10 || dch.getTransactionType().value() == 12)) {
                dch.setNetBookValue(dch.getNetBookValue().add(dch.getAmount()));
                dch.setAmount(BigDecimal.ZERO);
                dch.setMakePersistent(true);
                continue;
            }
            if (lastDate == null || !DateHelper.after((Date)dch.getProcessingDate(), (Date)lastDate) || dch.getIsCanceled() || dch.getIsCancelation() || dch.getTransactionType().value() != 10 && dch.getTransactionType().value() != 12 && dch.getTransactionType().value() != 18) continue;
            dch.setMakePersistent(true);
            dch.setMakeCancelation(true);
            transactCache.set(i, dch);
        }
    }

    public static BigDecimal roundingAmount(BigDecimal amount, int roundingType) {
        switch (roundingType) {
            case 0: {
                amount = amount.setScale(0, RoundingMode.HALF_EVEN);
                break;
            }
            case 1: {
                amount = amount.setScale(0, RoundingMode.UP);
                break;
            }
            case 2: {
                amount = amount.setScale(0, RoundingMode.DOWN);
            }
        }
        amount = amount.setScale(2, RoundingMode.UNNECESSARY);
        return amount;
    }

    private static void transactionsFillAccumValues(FixedAssetTransaction[] transactions, List<DepreciationCalculationHelper> transactCache) {
        for (int i = 0; i < transactions.length; ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            transactions[i].setAccumulatedAcquisitionAmount(dch.getAccumAcquisitionValue());
            transactions[i].setAccumulatedDepreciationAmount(dch.getAccumDepreciationAmount().add(dch.getAccumWriteDown().add(dch.getAccumWriteUp())));
            transactions[i].setAccumulatedSpecDepreciationAmount(dch.getAccumSpecDeprAmount());
            transactions[i].setAccumulatedGrant(dch.getAccumGrant());
            transactions[i].setAccumulatedInterest(dch.getAccumInterest());
            transactions[i].setAccumulatedQuantity(dch.getAccumQuantity());
            transactions[i].setNetBookValue(dch.getNetBookValue());
            transactions[i].setPartDisposNetBookValue(dch.getNetBookValueDisposal());
            if (transactions[i].getTransactionEnum().value() == 19 && transactions[i].getDerivation().equals("Import Guide") && !BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAutomDeprValueDisposal()) && dch.getIsBooked() && !dch.getIsCancelation() && !dch.getIsCanceled()) {
                if (BigDecimalMapper.compareTo((BigDecimal)dch.getAutomDeprValueDisposal(), (BigDecimal)BigDecimal.ZERO) < 0) {
                    transactions[i].setAccumDepr(dch.getAutomDeprValueDisposal().multiply(new BigDecimal(-1)));
                    continue;
                }
                transactions[i].setAccumDepr(dch.getAutomDeprValueDisposal());
                continue;
            }
            if (transactions[i].getTransactionEnum().value() == 25) {
                transactions[i].setAccumDepr(dch.getAutomDeprValueRepostAddition());
                transactions[i].setAccumSpecDepr(dch.getAutomSpecDeprValueRepostAddition());
                transactions[i].setAccumGrant(dch.getGrantRepostAddition());
                transactions[i].setAccumWriteDown(dch.getWriteDownRepostAddition());
                transactions[i].setAccumWriteUp(dch.getWriteUpRepostAddition());
                continue;
            }
            transactions[i].setAccumDepr(dch.getAutomDeprValueRepost());
            transactions[i].setAccumSpecDepr(dch.getAutomSpecDeprValueRepost());
            transactions[i].setAccumGrant(dch.getGrantRepost());
            transactions[i].setAccumWriteDown(dch.getWriteDownRepost());
            transactions[i].setAccumWriteUp(dch.getWriteUpRepost());
        }
    }

    public static BigDecimal getBaseForDepreciation(DepreciationCalculationHelper dch, CalcMethod calcMethod, FixedAssetArea faArea, Date processDate, List<DepreciationProtocolMessages> protocolMessages, boolean isDeprPreview, Language language) {
        LOGGER.debug("getBaseForDepreciation(...)");
        switch (calcMethod.getBaseForCalc().value()) {
            case 0: {
                if (calcMethod.getNote().equals("HALBER_AW") && !BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAccumAcquisitionValue()) && faArea.getDeprArea().getCalculative()) {
                    return dch.getAccumAcquisitionValue().divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
                }
                return dch.getAccumAcquisitionValue();
            }
            case 1: {
                return dch.getAccumAcquisitionValue().subtract(DepreciationCalculation.getDepResValue(faArea));
            }
            case 2: {
                return dch.getAccumAcquisitionValue().divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
            }
            case 3: {
                return dch.getBaseForReducingBalanceDepreciation();
            }
            case 4: {
                return dch.getBaseForReducingBalanceDepreciation().subtract(DepreciationCalculation.getDepResValue(faArea));
            }
            case 5: {
                if (faArea.getReplacementIndex() != null) {
                    return DepreciationCalculation.calculateReplacementValue(dch, faArea, processDate, protocolMessages, isDeprPreview, language, null, false);
                }
                return faArea.getReplacementValue();
            }
            case 6: {
                if (faArea.getReplacementIndex() != null) {
                    return DepreciationCalculation.calculateReplacementValue(dch, faArea, processDate, protocolMessages, isDeprPreview, language, null, false).subtract(DepreciationCalculation.getDepResValue(faArea));
                }
                return faArea.getReplacementValue().subtract(DepreciationCalculation.getDepResValue(faArea));
            }
            case 7: {
                if (faArea.getReplacementIndex() != null) {
                    return DepreciationCalculation.calculateReplacementValue(dch, faArea, processDate, protocolMessages, isDeprPreview, language, null, false).divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
                }
                return faArea.getReplacementValue().divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
            }
            case 8: {
                return faArea.getHistoricalAcquisitionValue();
            }
            case 9: {
                return faArea.getHistoricalAcquisitionValue().divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
            }
            case 12: {
                return dch.getAccumAcquisitionValue();
            }
            case 13: {
                return dch.getAccumAcquisitionValue().divide(new BigDecimal("2.0"), 2, RoundingMode.HALF_EVEN);
            }
            case 14: {
                return dch.getAccumAcquisitionValue().subtract(DepreciationCalculation.getDepResValue(faArea));
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)calcMethod.getBaseForCalc()));
    }

    private void createOrUpdateFATransactions(List<DepreciationCalculationHelper> transactionCache, FixedAssetData fixedAsset, List<DepreciationPostingAndProtocolHelper> allDepreciations, boolean printDepreciationProtocol, FAFinancialYear finYearForFixedAsset) throws BusinessDomainException {
        LOGGER.debug("createOrUpdateFATransactions(...)");
        ArrayList<DepreciationCalculationHelper> transactCacheCopy = new ArrayList<DepreciationCalculationHelper>(transactionCache);
        ArrayList<DepreciationCalculationHelper> transactCache = new ArrayList<DepreciationCalculationHelper>(transactionCache);
        if (this.mIsDeprPreview && finYearForFixedAsset == null && this.mFaArea.getProcessingDate() != null) {
            finYearForFixedAsset = FAFinancialYear.getFAFinancialYearForDateFromPreview((AccountingCompany)fixedAsset.getAccountCompany(), (Date)this.mFaArea.getProcessingDate());
        }
        for (int i = 0; i < transactCache.size(); ++i) {
            FixedAssetTransaction cancelationTransaction;
            int j;
            DepreciationPostingAndProtocolHelper[] dph;
            FAFinancialPeriodDetail detail;
            FAFinancialPeriod finPeriod;
            FixedAssetTransaction faTransaction = null;
            DepreciationCalculationHelper dch = (DepreciationCalculationHelper)transactCache.get(i);
            if (dch == null || finYearForFixedAsset != null && !dch.getMakeCancelation() && DateHelper.before((Date)dch.getProcessingDate(), (Date)finYearForFixedAsset.getValidFrom()) && !StringMapper.isNullString((String)dch.getOidFATransaction())) continue;
            boolean periodIsClosed = dch.getFinancialYear().getYearClosed();
            if (!periodIsClosed && (finPeriod = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])dch.getFinancialYear().getFinancialPeriods(), (Date)dch.getProcessingDate())) != null && (detail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null) {
                periodIsClosed = detail.getDeprAreaClosed();
            }
            Date beginDate = this.mFixedAsset.getAcquisitionDate();
            if (this.mJurisdiction_AT && this.mFixedAsset.getCommissioningDate() != null && DateHelper.after((Date)this.mFixedAsset.getCommissioningDate(), (Date)this.mFixedAsset.getAcquisitionDate())) {
                beginDate = this.mFixedAsset.getCommissioningDate();
            }
            if (!(this.mKeepNetBookValueWithDecimalPlaces || dch.getMakeCancelation() || dch.getNoDeprCorrection() || dch.getTransactionType().value() != 10 && dch.getTransactionType().value() != 12 || !DateHelper.afterOrEqual((Date)dch.getProcessingDate(), (Date)beginDate) || dch.getIsCancelation() || dch.getIsCanceled() || periodIsClosed)) {
                BigDecimal decimalPlacesOnly = new BigDecimal(dch.getNetBookValue().doubleValue() % 1.0).setScale(2, RoundingMode.HALF_EVEN);
                if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)decimalPlacesOnly) || BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getAmount()) || this.mYearDeprAmountLess || this.mIsDeprPreview && BigDecimalMapper.compareTo((BigDecimal)dch.getAmount(), (BigDecimal)new BigDecimal("1.00")) < 0)) {
                    dch.setAmount(dch.getAmount().add(decimalPlacesOnly));
                    dch.setMakePersistent(true);
                    DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                }
                if ((!this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || this.mFaArea.getDepBelowZero() && !this.mFaArea.getDeprArea().getDepBelowZero() || !this.mFaArea.getDepBelowZero() && this.mFaArea.getDeprArea().getDepBelowZero()) && !BigDecimalMapper.isZeroOrNull((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) && (!this.mDeprArea.getDeprToResValueFullDisposal() || !this.mFaArea.getIsFullDisposed()) && BigDecimalMapper.compareTo((BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea), (BigDecimal)dch.getNetBookValue()) > 0) {
                    dch.setAmount(dch.getAmount().subtract(DepreciationCalculation.getDepResValue(this.mFaArea).subtract(dch.getNetBookValue())));
                    if (BigDecimalMapper.compareTo((BigDecimal)dch.getAmount(), (BigDecimal)BigDecimalMapper.ZERO) < 0) {
                        dch.setAmount(BigDecimalMapper.ZERO);
                    }
                    DepreciationCalculationHelper.createAccumulations(transactCache, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
                }
            }
            if (this.mIsDeprPreview) {
                dch.setMakePersistent(false);
            }
            if (!dch.getMakePersistent()) continue;
            if (dch.getMakeCancelation()) {
                if (dch.getTransactionType().value() != 20 && dch.getTransactionType().value() != 19) {
                    dch.setIsCancelation(true);
                }
                transactCache.set(i, dch);
                if (StringMapper.isNullString((String)dch.getOidFATransaction())) {
                    dch.setMakePersistent(false);
                    continue;
                }
                faTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)dch.getOidFATransaction());
                faTransaction.makeSaveable();
                if (printDepreciationProtocol && (faTransaction.getTransactionEnum().value() == 10 || faTransaction.getTransactionEnum().value() == 12 || faTransaction.getTransactionEnum().value() == 18)) {
                    DepreciationPostingAndProtocol.setAccounts((FixedAssetArea)this.mFaArea);
                    dph = DepreciationPostingAndProtocol.postingsForOthers((Date)faTransaction.getDocumentDate(), (AssetaccountingSetup)this.mAASetup, (FixedAssetTransaction)faTransaction, (Language)this.mGlobalLanguage, (Boolean)this.mDeprArea.getTransferDataFin(), (Boolean)this.mDeprArea.getTransferDataCost());
                    for (j = 0; j < dph.length; ++j) {
                        dph[j].setAmount(dph[j].getAmount().negate());
                        allDepreciations.add(dph[j]);
                    }
                }
                if (faTransaction.getAutomaticDepreciationTyp() != null && faTransaction.getAutomaticDepreciationTyp().value() == 3) {
                    DepreciationCalculation.removeIsDepreciatedWhenPerformanceDepr(faTransaction, this.mFaArea);
                }
                if (faTransaction.getTransactionEnum().value() != 19 && faTransaction.getTransactionEnum().value() != 20) {
                    if (dch.getIsBooked()) {
                        faTransaction.setIsCanceled(true);
                        cancelationTransaction = new FixedAssetTransaction(faTransaction);
                        cancelationTransaction.setIsBooked(false);
                        cancelationTransaction.setIsCanceled(false);
                        cancelationTransaction.setIsCancelation(true);
                        cancelationTransaction.setAmount(cancelationTransaction.getAmount().negate());
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)cancelationTransaction.getAmountNotUsedDeprIT())) {
                            cancelationTransaction.setAmountNotUsedDeprIT(cancelationTransaction.getAmountNotUsedDeprIT().negate());
                        }
                    } else {
                        faTransaction.destroy();
                        transactCache.set(i, null);
                    }
                }
            } else if (!StringMapper.isNullString((String)dch.getOidFATransaction())) {
                faTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)dch.getOidFATransaction());
                if (dch.getAmount().compareTo(faTransaction.getAmount()) != 0 && !periodIsClosed) {
                    if (printDepreciationProtocol && (faTransaction.getTransactionEnum().value() == 10 || faTransaction.getTransactionEnum().value() == 12 || faTransaction.getTransactionEnum().value() == 18)) {
                        DepreciationPostingAndProtocol.setAccounts((FixedAssetArea)this.mFaArea);
                        dph = DepreciationPostingAndProtocol.postingsForOthers((Date)faTransaction.getDocumentDate(), (AssetaccountingSetup)this.mAASetup, (FixedAssetTransaction)faTransaction, (Language)this.mGlobalLanguage, (Boolean)this.mDeprArea.getTransferDataFin(), (Boolean)this.mDeprArea.getTransferDataCost());
                        for (j = 0; j < dph.length; ++j) {
                            if (faTransaction.getIsBooked()) {
                                dph[j].setAmount(dph[j].getAmount().negate());
                            } else {
                                dph[j].setAmount(dch.getAmount());
                            }
                            allDepreciations.add(dph[j]);
                        }
                    }
                    faTransaction.makeSaveable();
                    if (faTransaction.getIsBooked()) {
                        faTransaction.setIsCanceled(true);
                        cancelationTransaction = new FixedAssetTransaction(faTransaction);
                        cancelationTransaction.setIsBooked(false);
                        cancelationTransaction.setIsCanceled(false);
                        cancelationTransaction.setIsCancelation(true);
                        cancelationTransaction.setAmount(cancelationTransaction.getAmount().negate());
                        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)cancelationTransaction.getAmountNotUsedDeprIT())) {
                            cancelationTransaction.setAmountNotUsedDeprIT(cancelationTransaction.getAmountNotUsedDeprIT().negate());
                        }
                        this.createNewTransaction(dch, fixedAsset, printDepreciationProtocol, allDepreciations, transactCacheCopy);
                    } else {
                        faTransaction.setAmount(dch.getAmount());
                        if (faTransaction.getTransactionEnum().value() == 10 && !DateHelper.equal((Date)dch.getProcessingDate(), (Date)faTransaction.getProcessingDate())) {
                            faTransaction.setProcessingDate(dch.getProcessingDate());
                        }
                    }
                }
            } else if (!periodIsClosed) {
                this.createNewTransaction(dch, fixedAsset, printDepreciationProtocol, allDepreciations, transactCacheCopy);
            }
            dch.setMakePersistent(false);
            dch.setIsPersistent(true);
        }
        if (this.mFunction.value() == 1) {
            ArrayList<DepreciationCalculationHelper> transactCacheCancel = new ArrayList<DepreciationCalculationHelper>();
            for (int k = 0; k < transactCache.size(); ++k) {
                DepreciationCalculationHelper dchi = (DepreciationCalculationHelper)transactCache.get(k);
                if (dchi == null) continue;
                transactCacheCancel.add(dchi);
            }
            Collections.sort(transactCacheCancel);
            DepreciationCalculationHelper.createAccumulations(transactCacheCancel, (boolean)this.mIsDeprPreview, (boolean)this.mFaArea.getDepBelowZero());
            this.createOrUpdateDisposalTransactions(transactCacheCancel, finYearForFixedAsset);
            this.mTransactCache = transactCacheCancel;
        } else {
            this.createOrUpdateDisposalTransactions(transactCacheCopy, finYearForFixedAsset);
        }
    }

    private void createOrUpdateDisposalTransactions(List<DepreciationCalculationHelper> transactCache, FAFinancialYear finYearForFixedAsset) {
        LOGGER.debug("createOrUpdateDisposalTransactions(...)");
        Object[] dchs = new DepreciationCalculationHelper[transactCache.size()];
        transactCache.toArray(dchs);
        Arrays.sort(dchs);
        for (int i = 0; i < dchs.length; ++i) {
            FixedAssetTransaction faTransaction;
            FAFinancialPeriodDetail detail;
            FAFinancialPeriod finPeriod;
            if (finYearForFixedAsset != null && DateHelper.before((Date)dchs[i].getProcessingDate(), (Date)finYearForFixedAsset.getValidFrom()) && !StringMapper.isNullString((String)dchs[i].getOidFATransaction())) continue;
            boolean periodIsClosed = dchs[i].getFinancialYear().getYearClosed();
            if (!periodIsClosed && (finPeriod = FAFinancialPeriod.getFAFinancialPeriodForDate((FAFinancialPeriod[])dchs[i].getFinancialYear().getFinancialPeriods(), (Date)dchs[i].getProcessingDate())) != null && (detail = FAFinancialPeriod.getFinancialPeriodDetailsForDeprArea((FAFinancialPeriodDetail[])finPeriod.getFinancialPeriodDetails(), (DepreciationArea)this.mDeprArea)) != null) {
                periodIsClosed = detail.getDeprAreaClosed();
            }
            if (!(dchs[i].getTransactionType().value() != 19 && dchs[i].getTransactionType().value() != 20 || dchs[i].getIsCancelation() || periodIsClosed || StringMapper.isNullString((String)dchs[i].getOidFATransaction()))) {
                faTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)dchs[i].getOidFATransaction());
                this.calculateDisposalsForTransactions(faTransaction, (DepreciationCalculationHelper)dchs[i]);
            }
            if (!(dchs[i].getTransactionType().value() != 5 && dchs[i].getTransactionType().value() != 25 && dchs[i].getTransactionType().value() != 6 || dchs[i].getIsCancelation() || periodIsClosed)) {
                faTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)dchs[i].getOidFATransaction());
                if (dchs[i].getOidFixedAsset().equals(dchs[i].getOidFixedAssetTransferFrom())) {
                    this.calculateRepostsForTransactions(faTransaction, (DepreciationCalculationHelper)dchs[i]);
                }
                if (ISoftware.getDepreciationForAdditionsWithValueLastDayOfMonth() && faTransaction != null && dchs[i].getTransactionType().value() == 25 && dchs[i].getProcessingDate() != null && DateHelper.equal((Date)faTransaction.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)faTransaction.getProcessingDate())) && DateHelper.before((Date)dchs[i].getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)faTransaction.getProcessingDate()))) {
                    faTransaction.setProcessingDate(dchs[i].getProcessingDate());
                    faTransaction.makeSaveable();
                }
            }
            if (dchs[i].getTransactionType().value() != 4 || dchs[i].getIsCancelation() || periodIsClosed || StringMapper.isNullString((String)dchs[i].getOidFATransaction())) continue;
            faTransaction = FixedAssetTransactionPersistencyManager.getFixedAssetTransaction((String)dchs[i].getOidFATransaction());
            this.calculateCreditNoteForTransactions(faTransaction, (DepreciationCalculationHelper)dchs[i]);
        }
    }

    private void createNewTransaction(DepreciationCalculationHelper dch, FixedAssetData fixedAsset, boolean printDepreciationProtocol, List<DepreciationPostingAndProtocolHelper> allDepreciations, List<DepreciationCalculationHelper> transactCacheCopy) throws BusinessDomainException {
        FixedAssetTransaction faTransaction = new FixedAssetTransaction();
        faTransaction.setAmount(dch.getAmount());
        if (dch.getDeprPlanIT() != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)dch.getDeprPlanIT().getNonUsedPercentage())) {
            faTransaction.setAmountNotUsedDeprIT(dch.getAmount().multiply(dch.getDeprPlanIT().getNonUsedPercentage()).divide(dch.getDeprPlanIT().getNonUsedPercentage().add(dch.getDeprPlanIT().getReducedPercent()), 2, RoundingMode.HALF_EVEN));
        }
        faTransaction.setOidCompany(fixedAsset.getAccountCompany().getObjectid());
        faTransaction.setTransactionEnum(dch.getTransactionType());
        faTransaction.setTransactionSeqNumber(FATransactionSequenceNoPersistencyManager.getNextNumber((AccountingCompany)this.mCompany));
        faTransaction.setFixedAsset(fixedAsset);
        faTransaction.setDeprArea(this.mDeprArea);
        faTransaction.setProcessingDate(dch.getProcessingDate());
        faTransaction.setDocumentDate(this.mDocumentDate);
        faTransaction.setTransactionDate(this.mDocumentDate);
        VDate vdate = new VDate(dch.getProcessingDate());
        Object refNumber = String.valueOf(vdate.getYear());
        if (this.mDeprArea.getDepreciationFrequencies().value() == 0) {
            refNumber = (String)refNumber + "/" + (vdate.getMonth() + 1);
        }
        faTransaction.setReferenceNumber((String)refNumber);
        faTransaction.setSequenceNumber("");
        faTransaction.setOrderNumber("");
        faTransaction.setAssetAccount(null);
        faTransaction.setQuantity(null);
        faTransaction.setQuantityUnit(null);
        switch (faTransaction.getTransactionEnum().value()) {
            case 10: {
                faTransaction.setPostingText(TransactionMapper.toString((Language)this.mGlobalLanguage, (TransactionEnum)TransactionEnum.TRE_AUTOMATIC_DEPR));
                faTransaction.setAutomaticDepreciationType(dch.getAutomDeprType());
                faTransaction.setPartDisposalPercent(this.depreciationPercent);
                break;
            }
            case 12: {
                faTransaction.setPostingText(TransactionMapper.toString((Language)this.mGlobalLanguage, (TransactionEnum)TransactionEnum.TRE_AUTOMATIC_SPEC_DEPR));
                break;
            }
            case 18: {
                faTransaction.setPostingText(TransactionMapper.toString((Language)this.mGlobalLanguage, (TransactionEnum)TransactionEnum.TRE_INTERESTS));
                break;
            }
            case 20: {
                faTransaction.setPostingText(TransactionMapper.toString((Language)this.mGlobalLanguage, (TransactionEnum)TransactionEnum.TRE_FULL_DISPOSAL));
                faTransaction.setSalesAmount(dch.getSalesAmount());
                if (this.mFaArea.getStatus() != StatusEnum.STE_LOW_VALUE || !this.mDeprArea.getDispInYearOfAcqu()) break;
                faTransaction.setAccumDepr(dch.getAccumAutomDeprValueDisposalForPosting().add(dch.getAccumManualDeprValueDisposalForPosting().add(dch.getAccumGrantDisposalForPosting().add(dch.getAccumWriteDownDisposalForPosting().add(dch.getAccumWriteUpDisposalForPosting())))).negate());
                faTransaction.setAccumSpecDepr(dch.getAccumAutomSpecDeprValueDisposalForPosting().add(dch.getAccumManualSpecDeprValueDisposalForPosting()).negate());
                faTransaction.setAmount(dch.getAccumAcquisitionValueDisposal());
                if (StringMapper.isNullString((String)fixedAsset.getOidQuantityUnit())) break;
                faTransaction.setQuantityUnit(QuantityUnitPersistencyManager.getQuantityUnit((String)fixedAsset.getOidQuantityUnit()));
                faTransaction.setQuantity(BigDecimalMapper.toString((BigDecimal)BigDecimalMapper.toBigDecimal((String)fixedAsset.getQuantity()).negate()));
                fixedAsset.setQuantity(BigDecimalMapper.toString((BigDecimal)BigDecimal.ZERO));
            }
        }
        faTransaction.setPersonalAccount(null);
        faTransaction.setFinancialYear(dch.getFinancialYear());
        faTransaction.setFixedAsset(fixedAsset);
        faTransaction.setCalcMethod(this.mCalcMethod);
        faTransaction.setFullDisposDeprecUntil(FullDisposDeprecUntilEnum.DUE_NO_DEPRECIATION);
        faTransaction.setPartialDisposDeprecUntil(DepreciationFromUntilEnum.DFUE_BEGIN_FINANCIAL_YEAR);
        if (((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).getUseAnalysisCodesForAssetAccPostings() && this.mPosACforFA > 0 && this.mPosACforFAT > 0) {
            String[] analysisCodesFAT = new String[10];
            analysisCodesFAT[this.mPosACforFAT - 1] = fixedAsset.getAnalysisCodes()[this.mPosACforFA - 1];
            faTransaction.setAnalysisCodes(analysisCodesFAT);
        }
        DepreciationCalculationHelper newDch = new DepreciationCalculationHelper();
        newDch.setOidFATransaction(faTransaction.getObjectid());
        newDch.setDocumentDate(faTransaction.getDocumentDate());
        newDch.setProcessingDate(faTransaction.getProcessingDate());
        newDch.setTransactionType(faTransaction.getTransactionEnum());
        newDch.setFinancialYear(faTransaction.getFinancialYear());
        newDch.setAmount(faTransaction.getAmount());
        newDch.setAmountNotRounded(faTransaction.getAmount());
        newDch.setAcquisitionAmount(faTransaction.getAcquisitionAmount());
        newDch.setDepreciationAmount(faTransaction.getDepreciationAmount());
        newDch.setSpecDepreciationAmount(faTransaction.getSpecDepreciationAmount());
        if (faTransaction.getDeprArea().getCalculative() && faTransaction.getDeprArea().getImputedInterest()) {
            newDch.setInterestAmount(faTransaction.getSpecDepreciationAmount());
        } else {
            newDch.setInterestAmount(BigDecimal.ZERO);
        }
        newDch.setGrant(faTransaction.getGrant());
        newDch.setPartDisposalPercent(faTransaction.getPartDisposalPercent());
        newDch.setPartDisposalNetBookValue(faTransaction.getPartDisposalNetBookValue());
        newDch.setReserveAmount(faTransaction.getReserveAmount());
        newDch.setSalesAmount(faTransaction.getSalesAmount());
        newDch.setIsBooked(faTransaction.getIsBooked());
        newDch.setIsCanceled(faTransaction.getIsCanceled());
        newDch.setIsCancelation(faTransaction.getIsCancelation());
        newDch.setIsPersistent(true);
        newDch.setBaseForReducingBalanceDepreciation(faTransaction.getNetBookValueBeginFY());
        newDch.setLastDeprDate(faTransaction.getLastDeprDate());
        newDch.setLastInterestCalcDate(faTransaction.getLastDeprDate());
        newDch.setIndex(transactCacheCopy.size());
        newDch.setUsefullLifeInMonth((int)this.mFaArea.getUsefullLifeInMonth());
        newDch.setUsefullLifeInDays(this.getUsefullLifeInDays());
        newDch.setDeprStartDate(this.mFaArea.getDeprStartDate());
        newDch.setOidFixedAsset(fixedAsset.getObjectid());
        newDch.setOidFixedAssetTransferFrom("");
        newDch.setOidFixedAssetTransferTo("");
        newDch.setAutomDeprType(faTransaction.getAutomaticDepreciationTyp());
        newDch.setAnalysisCodes(faTransaction.getAnalysisCodes());
        newDch.setNoDeprCorrection(dch.getNoDeprCorrection());
        if (this.mFunction.value() == 1 && DateHelper.afterOrEqual((Date)faTransaction.getProcessingDate(), (Date)this.mCancellationUntilDate)) {
            if (faTransaction.getTransactionEnum().value() == 10 && !faTransaction.getIsCancelation() && !faTransaction.getIsCanceled()) {
                newDch.setMakeCancelation(true);
                newDch.setMakePersistent(true);
            }
            if (faTransaction.getTransactionEnum().value() == 20 || faTransaction.getTransactionEnum().value() == 19) {
                newDch.setMakeCancelation(true);
                newDch.setMakePersistent(true);
            }
        } else {
            newDch.setMakeCancelation(false);
            newDch.setMakePersistent(false);
        }
        transactCacheCopy.add(newDch);
        if (printDepreciationProtocol && (faTransaction.getTransactionEnum().value() == 10 || faTransaction.getTransactionEnum().value() == 12 || faTransaction.getTransactionEnum().value() == 18)) {
            DepreciationPostingAndProtocol.setAccounts((FixedAssetArea)this.mFaArea);
            DepreciationPostingAndProtocolHelper[] dph = DepreciationPostingAndProtocol.postingsForOthers((Date)faTransaction.getDocumentDate(), (AssetaccountingSetup)this.mAASetup, (FixedAssetTransaction)faTransaction, (Language)this.mGlobalLanguage, (Boolean)this.mDeprArea.getTransferDataFin(), (Boolean)this.mDeprArea.getTransferDataCost());
            for (int j = 0; j < dph.length; ++j) {
                allDepreciations.add(dph[j]);
            }
        }
    }

    private void setLastDeprDate(List<DepreciationCalculationHelper> transactCache, FixedAssetArea faArea, Date depreciationUntilDate, boolean specRes) {
        LOGGER.debug("setLastDeprDate(...)");
        Date lastDeprDate = null;
        if (this.mFunction.value() == 0) {
            for (int i = transactCache.size() - 1; i >= 0 && lastDeprDate == null; --i) {
                DepreciationCalculationHelper dch = transactCache.get(i);
                if (dch.getIsCancelation() || dch.getIsCanceled()) continue;
                if (dch.getTransactionType().value() == 10 && dch.getIsPersistent()) {
                    lastDeprDate = dch.getProcessingDate();
                    continue;
                }
                if (dch.getTransactionType().value() == 11) {
                    if (!DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)depreciationUntilDate)) continue;
                    lastDeprDate = dch.getProcessingDate();
                    continue;
                }
                if (dch.getTransactionType().value() != 1) continue;
                lastDeprDate = dch.getLastDeprDate();
            }
        } else if (this.mFunction.value() == 1) {
            DepreciationCalculationHelper dch = transactCache.get(0);
            if (!(dch.getTransactionType().value() != 1 || dch.getLastDeprDate() == null || !DateHelper.afterOrEqual((Date)dch.getLastDeprDate(), (Date)depreciationUntilDate) || FixedAssetTransactionPersistencyManager.checkDepreciationsExistenceFromMigration((FixedAsset)faArea.getFixedAsset(), (DepreciationArea)faArea.getDeprArea()) && dch.getDerivation().equals("Import"))) {
                lastDeprDate = dch.getLastDeprDate();
            } else if (faArea.getLastDeprDate() != null) {
                if (specRes) {
                    lastDeprDate = faArea.getLastDeprDate();
                }
                if (DateHelper.afterOrEqual((Date)faArea.getLastDeprDate(), (Date)depreciationUntilDate)) {
                    lastDeprDate = DateHelper.yesterday((Date)depreciationUntilDate);
                }
            }
            if (lastDeprDate != null) {
                if (faArea.getDeprStartDate() != null) {
                    if (DateHelper.beforeOrEqual((Date)lastDeprDate, (Date)faArea.getDeprStartDate())) {
                        lastDeprDate = null;
                    }
                } else {
                    lastDeprDate = null;
                }
            }
        }
        if (!DateHelper.equal((Date)faArea.getLastDeprDate(), lastDeprDate) || this.mTriggerIsNewTransaction) {
            int resDays;
            int resMonth;
            faArea.makeSaveable();
            faArea.setLastDeprDateWithouProtocol(lastDeprDate);
            if (this.mFromTransaction && this.mIsTransactTypeIsFullDisposal) {
                if (!(this.mIsTransactionCancellation || faArea.getIsFullDisposed() && faArea.getProcessingDate() != null && faArea.getLastDeprDate() != null && DateHelper.after((Date)faArea.getProcessingDate(), (Date)faArea.getLastDeprDate()))) {
                    faArea.setProcessingDate(lastDeprDate);
                }
            } else {
                faArea.setProcessingDate(lastDeprDate);
            }
            if (lastDeprDate != null) {
                resMonth = FixedAssetArea.calculateResidualLifeInMonth(faArea.getUsefullLifeInMonth(), faArea.getDeprStartDate(), lastDeprDate);
                resDays = FixedAssetArea.calculateResLifeInDays(this.getUsefullLifeInDays(), faArea.getDeprStartDate(), lastDeprDate, true);
            } else {
                resMonth = faArea.getUsefullLifeInMonth();
                resDays = faArea.getUsefullLifeInDays();
            }
            faArea.setResPeriodInYearsWithoutProtocol((short)(resMonth / 12));
            faArea.setResPeriodInMonthWithoutProtocol((short)(resMonth % 12));
            faArea.setUsefullLifeInDays(this.getUsefullLifeInDays());
            faArea.setResLifeInDays(resDays);
        }
    }

    private void setReplacementValue(List<DepreciationCalculationHelper> transactCache, FixedAssetArea faArea, boolean isAlreadyDeprciated) {
        LOGGER.debug("setReplacementValue(...)");
        DepreciationCalculationHelper dch = null;
        Date untilDate = null;
        if (this.mFunction.value() != 1) {
            untilDate = this.mDepreciationUntilDate;
        } else {
            untilDate = this.mCancellationUntilDate;
            if (DateHelper.equal((Date)this.mCancellationUntilDate, (Date)this.mFinYearForFixedAsset.getValidFrom())) {
                untilDate = DateHelper.yesterday((Date)this.mFinYearForFixedAsset.getValidFrom());
            }
        }
        for (int i = transactCache.size() - 1; i >= 0; --i) {
            dch = transactCache.get(i);
            if (dch.getIsCancelation() || dch.getIsCanceled()) continue;
            if (!this.mTriggerIsNewTransaction) {
                if (!DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)untilDate)) continue;
                i = -1;
                continue;
            }
            if (faArea.getProcessingDate() == null || !DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)faArea.getProcessingDate())) continue;
            i = -1;
        }
        if (this.mTriggerIsNewTransaction) {
            if (faArea.getDeprStartDate() == null) {
                untilDate = faArea.getProcessingDate();
            } else if (dch != null) {
                if (isAlreadyDeprciated) {
                    untilDate = faArea.getProcessingDate();
                } else if (faArea.getLastDeprDate() != null && faArea.getProcessingDate() != null && DateHelper.after((Date)dch.getProcessingDate(), (Date)faArea.getLastDeprDate())) {
                    untilDate = faArea.getProcessingDate();
                }
            }
        }
        boolean isCancellation = false;
        if (this.mFunction.value() == 1) {
            isCancellation = true;
        }
        BigDecimal replValue = DepreciationCalculation.calculateReplacementValue(dch, faArea, untilDate, null, false, this.mGlobalLanguage, this.mFinYearForFixedAsset, isCancellation);
        faArea.setReplacementValue(replValue);
    }

    private void setLastInterestCalcDate(List<DepreciationCalculationHelper> transactCache, FixedAssetArea faArea, Date depreciationUntilDate) {
        LOGGER.debug("setLastInterestCalcDate(...)");
        Date lastInterestCalcDate = null;
        if (this.mFunction.value() == 0) {
            for (int i = transactCache.size() - 1; i >= 0 && lastInterestCalcDate == null; --i) {
                DepreciationCalculationHelper dch = transactCache.get(i);
                if (dch.getIsCancelation() || dch.getIsCanceled()) continue;
                if (dch.getTransactionType().value() == 18) {
                    lastInterestCalcDate = dch.getProcessingDate();
                    continue;
                }
                if (dch.getTransactionType().value() != 1) continue;
                lastInterestCalcDate = dch.getLastInterestCalcDate();
            }
        } else if (this.mFunction.value() == 1) {
            DepreciationCalculationHelper dch = transactCache.get(0);
            if (dch.getTransactionType().value() == 1 && dch.getLastInterestCalcDate() != null && DateHelper.afterOrEqual((Date)dch.getLastInterestCalcDate(), (Date)depreciationUntilDate)) {
                lastInterestCalcDate = dch.getLastInterestCalcDate();
            } else if (faArea.getLastInterestCalcDate() != null && DateHelper.afterOrEqual((Date)faArea.getLastInterestCalcDate(), (Date)depreciationUntilDate)) {
                lastInterestCalcDate = DateHelper.yesterday((Date)depreciationUntilDate);
            }
            if (lastInterestCalcDate != null) {
                if (faArea.getDeprStartDate() != null) {
                    if (DateHelper.beforeOrEqual((Date)lastInterestCalcDate, (Date)faArea.getDeprStartDate())) {
                        lastInterestCalcDate = null;
                    }
                } else {
                    lastInterestCalcDate = null;
                }
            }
        }
        if (!DateHelper.equal((Date)faArea.getLastInterestCalcDate(), lastInterestCalcDate) || this.mTriggerIsNewTransaction) {
            faArea.makeSaveable();
            faArea.setLastInterestCalcDate(lastInterestCalcDate);
        }
    }

    public static DepreciationCalculationHelper getDeprCalcHelperForDate(List<DepreciationCalculationHelper> transactCache, Date date, TransactionEnum transactionType) {
        if (date != null) {
            for (int i = transactCache.size() - 1; i >= 0; --i) {
                DepreciationCalculationHelper dch = transactCache.get(i);
                if (DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)date)) {
                    if (transactionType != null) {
                        if (dch.getTransactionType().value() != transactionType.value()) continue;
                        return dch;
                    }
                    return dch;
                }
                if (dch.getTransactionType().value() != 10 || !DateHelper.before((Date)dch.getProcessingDate(), (Date)DateHelper.getLastDayOfMonth((Date)date)) || !DateHelper.after((Date)dch.getProcessingDate(), (Date)DateHelper.getFirstDayOfMonth((Date)date))) continue;
                return dch;
            }
            return null;
        }
        return null;
    }

    public static DepreciationCalculationHelper getDeprCalcHelperForTransactOID(List<DepreciationCalculationHelper> transactCache, String oidTransaction) {
        if (!StringMapper.isNullString((String)oidTransaction)) {
            for (int i = 0; i < transactCache.size(); ++i) {
                DepreciationCalculationHelper dch = transactCache.get(i);
                if (!dch.getOidFATransaction().equals(oidTransaction)) continue;
                return dch;
            }
        }
        return null;
    }

    public static DepreciationCalculationHelper getDeprCalcHelperBeforeOrEqualDate(List<DepreciationCalculationHelper> transactCache, Date date, boolean fromReport, boolean sortWithDocumentDate) {
        DepreciationCalculationHelper result = null;
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (sortWithDocumentDate && fromReport) {
                if (dch.getDocumentDate() != null && date != null && DateHelper.beforeOrEqual((Date)dch.getDocumentDate(), (Date)date)) {
                    result = dch;
                }
            } else if (dch.getProcessingDate() != null && date != null && DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)date)) {
                result = dch;
            }
            if (dch.getTransactionType().value() != 20 && (dch.getTransactionType().value() != 6 || BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValueRepost(), (BigDecimal)BigDecimal.ZERO) >= 0 || fromReport) || dch.getIsCancelation() || dch.getIsCanceled()) continue;
            i = transactCache.size();
        }
        return result;
    }

    public static DepreciationCalculationHelper getDeprCalcHelperBeforeOrEqualDateAT(List<DepreciationCalculationHelper> transactCache, Date date, boolean fromReport) {
        DepreciationCalculationHelper dch;
        DepreciationCalculationHelper result = null;
        Date dateInitialAddition = date;
        for (int m = 0; m < transactCache.size(); ++m) {
            dch = transactCache.get(m);
            if (dch.getTransactionType().value() != 0 && dch.getTransactionType().value() != 1) continue;
            dateInitialAddition = DateHelper.getLastDayOfMonth((Date)dch.getProcessingDate());
            break;
        }
        for (int i = 0; i < transactCache.size(); ++i) {
            dch = transactCache.get(i);
            if (dch.getProcessingDate() != null && dateInitialAddition != null && DateHelper.beforeOrEqual((Date)dch.getProcessingDate(), (Date)dateInitialAddition)) {
                result = dch;
            }
            if (dch.getTransactionType().value() != 20 && (dch.getTransactionType().value() != 6 || BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValueRepost(), (BigDecimal)BigDecimal.ZERO) >= 0 || fromReport) || dch.getIsCancelation() || dch.getIsCanceled()) continue;
            i = transactCache.size();
        }
        return result;
    }

    public static Date getDisposalDate(List<DepreciationCalculationHelper> transactCache, Date fromDate, Date toDate) {
        Date disposalDate = null;
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (dch.getTransactionType().value() != 20 || !DateHelper.between((Date)dch.getProcessingDate(), (Date)fromDate, (Date)toDate)) continue;
            disposalDate = dch.getProcessingDate();
            break;
        }
        return disposalDate;
    }

    public static DepreciationCalculationHelper getDeprCalcHelperBeforeOrEqualRepostDate(List<DepreciationCalculationHelper> transactCache, Date date, boolean fromReport) {
        DepreciationCalculationHelper result = null;
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (dch.getDocumentDate() != null && date != null && DateHelper.beforeOrEqual((Date)dch.getDocumentDate(), (Date)date)) {
                result = dch;
                if (DateHelper.equal((Date)dch.getDocumentDate(), (Date)date) && (dch.getTransactionType().value() == 8 || dch.getTransactionType().value() == 21)) break;
            }
            if (dch.getTransactionType().value() != 20 && (dch.getTransactionType().value() != 6 || BigDecimalMapper.compareTo((BigDecimal)dch.getAccumAcquisitionValueRepost(), (BigDecimal)BigDecimal.ZERO) >= 0 || fromReport) || dch.getIsCancelation() || dch.getIsCanceled()) continue;
            i = transactCache.size();
        }
        return result;
    }

    private static DepreciationCalculationHelper[] getDeprCalcHelperForPeriod(List<DepreciationCalculationHelper> transactCache, FAFinancialPeriod finPeriod) {
        if (finPeriod != null) {
            ArrayList<DepreciationCalculationHelper> dchs = new ArrayList<DepreciationCalculationHelper>();
            for (int i = 0; i < transactCache.size(); ++i) {
                DepreciationCalculationHelper dch = transactCache.get(i);
                if (dch.getProcessingDate().before(finPeriod.getValidFrom()) || dch.getProcessingDate().after(finPeriod.getValidUntil())) continue;
                dchs.add(dch);
            }
            if (!dchs.isEmpty()) {
                DepreciationCalculationHelper[] arr = new DepreciationCalculationHelper[dchs.size()];
                return dchs.toArray(arr);
            }
            return new DepreciationCalculationHelper[0];
        }
        return new DepreciationCalculationHelper[0];
    }

    private static BigDecimal getManualDepreciationForPeriod(List<DepreciationCalculationHelper> transactCache, Date fromDate, Date untilDate) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (dch.getProcessingDate().before(fromDate) || dch.getProcessingDate().after(untilDate) || dch.getTransactionType().value() != 11 && dch.getTransactionType().value() != 13) continue;
            result = result.add(dch.getAmount());
        }
        return result;
    }

    private static BigDecimal getAdditionsAndDisposalForPeriod(List<DepreciationCalculationHelper> transactCache, Date fromDate, Date untilDate) {
        BigDecimal result = BigDecimal.ZERO;
        for (int i = 0; i < transactCache.size(); ++i) {
            DepreciationCalculationHelper dch = transactCache.get(i);
            if (dch.getProcessingDate().before(fromDate) || dch.getProcessingDate().after(untilDate)) continue;
            if (dch.getTransactionType().value() == 2 || dch.getTransactionType().value() == 3) {
                result = result.add(dch.getAmount());
            }
            if (dch.getTransactionType().value() != 6 && dch.getTransactionType().value() != 5 && dch.getTransactionType().value() != 25 || BigDecimalMapper.compareTo((BigDecimal)dch.getPartDisposalNetBookValue(), (BigDecimal)BigDecimalMapper.ZERO) <= 0) continue;
            result = result.add(dch.getPartDisposalNetBookValue());
        }
        return result;
    }

    private void calculateDisposalsForTransactions(FixedAssetTransaction faTransaction, DepreciationCalculationHelper dch) {
        BigDecimal newAccumDepr = BigDecimal.ZERO;
        BigDecimal newAccumSpecDepr = BigDecimal.ZERO;
        BigDecimal newIncExp = BigDecimal.ZERO;
        faTransaction.makeSaveable();
        if (dch.getMakeCancelation() || dch.getIsCanceled()) {
            if (!dch.getIsBooked() && dch.getMakeCancelation()) {
                newAccumDepr = dch.getAccumAutomDeprValueDisposalForPosting().add(dch.getAccumManualDeprValueDisposalForPosting().add(dch.getAccumGrantDisposalForPosting().add(dch.getAccumWriteDownDisposalForPosting().add(dch.getAccumWriteUpDisposalForPosting())))).negate();
                newAccumSpecDepr = dch.getAccumAutomSpecDeprValueDisposalForPosting().add(dch.getAccumManualSpecDeprValueDisposalForPosting()).negate();
                newIncExp = dch.getSalesAmount().add(dch.getNetBookValueDisposal());
                faTransaction.setAccumDepr(newAccumDepr);
                faTransaction.setAccumSpecDepr(newAccumSpecDepr);
                faTransaction.setIncomeOrExpense(newIncExp);
                faTransaction.setAccumDeprCancel(BigDecimal.ZERO);
                faTransaction.setAccumSpecDeprCancel(BigDecimal.ZERO);
                faTransaction.setIncomeOrExpenseCancel(BigDecimal.ZERO);
            } else if (!faTransaction.getShowAsAddition()) {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setIncomeOrExpenseCancel(faTransaction.getIncomeOrExpense().negate());
                faTransaction.setAccumDepr(BigDecimal.ZERO);
                faTransaction.setAccumSpecDepr(BigDecimal.ZERO);
                faTransaction.setIncomeOrExpense(BigDecimal.ZERO);
                faTransaction.setIsBooked(false);
                if (dch.getIsCanceled()) {
                    faTransaction.setShowAsAddition(true);
                }
            }
        } else {
            if (dch.getTransactionType().value() == 19) {
                if (dch.getDeterminationDisposalValueType().value() == 3) {
                    if (BigDecimalMapper.compareTo((BigDecimal)dch.getPartDisposalNetBookValue(), (BigDecimal)dch.getNetBookValue()) > 0) {
                        dch.setPartDisposalNetBookValue(dch.getNetBookValue());
                    }
                    newAccumDepr = dch.getAmount().subtract(dch.getPartDisposalNetBookValue());
                    newIncExp = dch.getSalesAmount().add(dch.getPartDisposalNetBookValue());
                } else {
                    newAccumDepr = dch.getAccumAutomDeprValueDisposalForPosting().add(dch.getAccumManualDeprValueDisposalForPosting().add(dch.getAccumGrantDisposalForPosting().add(dch.getAccumWriteDownDisposalForPosting().add(dch.getAccumWriteUpDisposalForPosting())))).negate();
                    newAccumSpecDepr = dch.getAccumAutomSpecDeprValueDisposalForPosting().add(dch.getAccumManualSpecDeprValueDisposalForPosting()).negate();
                    newIncExp = dch.getSalesAmount().add(dch.getNetBookValueDisposal());
                }
            } else {
                newAccumDepr = dch.getAccumAutomDeprValueDisposalForPosting().add(dch.getAccumManualDeprValueDisposalForPosting().add(dch.getAccumGrantDisposalForPosting().add(dch.getAccumWriteDownDisposalForPosting().add(dch.getAccumWriteUpDisposalForPosting())))).negate();
                newAccumSpecDepr = dch.getAccumAutomSpecDeprValueDisposalForPosting().add(dch.getAccumManualSpecDeprValueDisposalForPosting()).negate();
                newIncExp = dch.getSalesAmount().add(dch.getNetBookValueDisposal());
            }
            if (!faTransaction.getIsBooked()) {
                faTransaction.setAccumDepr(newAccumDepr);
                faTransaction.setAccumSpecDepr(newAccumSpecDepr);
                faTransaction.setIncomeOrExpense(newIncExp);
            } else if (!(dch.getTransactionType().value() == 19 && faTransaction.getDerivation().equals("Import Guide") || faTransaction.getAccumDepr().compareTo(newAccumDepr) == 0 && faTransaction.getAccumSpecDepr().compareTo(newAccumSpecDepr) == 0)) {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setIncomeOrExpenseCancel(faTransaction.getIncomeOrExpense().negate());
                faTransaction.setAccumDepr(newAccumDepr);
                faTransaction.setAccumSpecDepr(newAccumSpecDepr);
                faTransaction.setIncomeOrExpense(newIncExp);
                faTransaction.setIsBooked(false);
            }
        }
    }

    private void calculateRepostsForTransactions(FixedAssetTransaction faTransaction, DepreciationCalculationHelper dch) {
        BigDecimal newDeprAmount = BigDecimal.ZERO;
        BigDecimal newSpecDeprAmount = BigDecimal.ZERO;
        faTransaction.makeSaveable();
        if (dch.getMakeCancelation()) {
            if (!faTransaction.getIsBooked()) {
                faTransaction.setAccumDepr(BigDecimal.ZERO);
                faTransaction.setAccumSpecDepr(BigDecimal.ZERO);
            } else {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setAccumDepr(BigDecimal.ZERO);
                faTransaction.setAccumSpecDepr(BigDecimal.ZERO);
                faTransaction.setIsBooked(false);
            }
        } else {
            if (dch.getTransactionType().value() == 25) {
                newDeprAmount = dch.getDepreciationAmountRepostAddition().add(dch.getGrantRepostAddition().add(dch.getWriteDownRepostAddition().add(dch.getWriteUpRepostAddition()))).negate();
                newSpecDeprAmount = dch.getSpecDepreciationAmountRepostAddition().negate();
            } else {
                newDeprAmount = dch.getDepreciationAmountRepost().add(dch.getGrantRepost().add(dch.getWriteDownRepost().add(dch.getWriteUpRepost()))).negate();
                newSpecDeprAmount = dch.getSpecDepreciationAmountRepost().negate();
            }
            if (!faTransaction.getIsBooked()) {
                faTransaction.setAccumDepr(newDeprAmount);
                faTransaction.setAccumSpecDepr(newSpecDeprAmount);
            } else if (faTransaction.getAccumDepr().compareTo(newDeprAmount) != 0 || faTransaction.getAccumSpecDepr().compareTo(newSpecDeprAmount) != 0) {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setAccumDepr(newDeprAmount);
                faTransaction.setAccumSpecDepr(newSpecDeprAmount);
                faTransaction.setIsBooked(false);
            }
        }
    }

    private void calculateCreditNoteForTransactions(FixedAssetTransaction faTransaction, DepreciationCalculationHelper dch) {
        LOGGER.debug("calculateCreditNoteForTransactions(...)");
        BigDecimal newAccumDepr = BigDecimal.ZERO;
        BigDecimal newAccumSpecDepr = BigDecimal.ZERO;
        faTransaction.makeSaveable();
        if (dch.getMakeCancelation() || dch.getIsCanceled()) {
            if (!faTransaction.getIsBooked()) {
                faTransaction.setAccumDepr(BigDecimal.ZERO);
                faTransaction.setAccumSpecDepr(BigDecimal.ZERO);
                faTransaction.setIncomeOrExpense(BigDecimal.ZERO);
            } else {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setIncomeOrExpenseCancel(faTransaction.getIncomeOrExpense().negate());
                faTransaction.setAccumDepr(BigDecimal.ZERO);
                faTransaction.setAccumSpecDepr(BigDecimal.ZERO);
                faTransaction.setIncomeOrExpense(BigDecimal.ZERO);
                faTransaction.setIsBooked(false);
            }
        } else {
            newAccumDepr = dch.getAutomDeprValueDisposal().add(dch.getManualDeprValueDisposal().add(dch.getGrantValueDisposal().add(dch.getWriteDownValueDisposal().add(dch.getWriteUpValueDisposal())))).negate();
            newAccumSpecDepr = dch.getAutomSpecDeprValueDisposal().add(dch.getManualSpecDeprValueDisposal()).negate();
            if (!faTransaction.getIsBooked()) {
                faTransaction.setAccumDepr(newAccumDepr);
                faTransaction.setAccumSpecDepr(newAccumSpecDepr);
            } else if (faTransaction.getAccumDepr().compareTo(newAccumDepr) != 0 || faTransaction.getAccumSpecDepr().compareTo(newAccumSpecDepr) != 0) {
                faTransaction.setAccumDeprCancel(faTransaction.getAccumDepr().negate());
                faTransaction.setAccumSpecDeprCancel(faTransaction.getAccumSpecDepr().negate());
                faTransaction.setAccumDepr(newAccumDepr);
                faTransaction.setAccumSpecDepr(newAccumSpecDepr);
                faTransaction.setIsBooked(false);
            }
        }
    }

    public static String getAutomaticPostingText(Language language) {
        return mAADepreciationList.getString((ILanguage)language, 0);
    }

    public List<DepreciationCalculationHelper> getTransactionsCache() {
        return this.mTransactCache;
    }

    public static FAFinancialYear[] getFAFinancialYears(AccountingCompany company, boolean isDeprPreview, Date previewUntilDate) throws BusinessDomainException {
        ArrayList<FAFinancialYear> finYearsList = new ArrayList<FAFinancialYear>(Arrays.asList(FAFinancialYear.getFAFinancialYears((AccountingCompany)company)));
        FAFinancialYear lastFinYear = (FAFinancialYear)finYearsList.get(finYearsList.size() - 1);
        if (isDeprPreview) {
            while (DateHelper.after((Date)previewUntilDate, (Date)lastFinYear.getValidUntil())) {
                FAFinancialYear newFinYear = new FAFinancialYear(company);
                newFinYear.makeReadOnly();
                newFinYear.setYearClosed(false);
                newFinYear.setValidFrom(DateHelper.tomorrow((Date)lastFinYear.getValidUntil()));
                newFinYear.setValidUntil(DateHelper.yesterday((Date)new VDate(newFinYear.getValidFrom()).addYears(1).getDate()));
                if (new VDate(newFinYear.getValidFrom()).getYear() != new VDate(newFinYear.getValidUntil()).getYear()) {
                    newFinYear.setCode(new VDate(newFinYear.getValidFrom()).getYear() + " / " + new VDate(newFinYear.getValidUntil()).getYear());
                } else {
                    newFinYear.setCode(String.valueOf(new VDate(newFinYear.getValidFrom()).getYear()));
                }
                FAFinancialPeriod[] finPeriods = new FAFinancialPeriod[12];
                finPeriods[0] = new FAFinancialPeriod(true);
                finPeriods[0].setValidFrom(newFinYear.getValidFrom());
                finPeriods[0].setValidUntil(DateHelper.getLastDayOfMonth((Date)newFinYear.getValidFrom()));
                for (int i = 1; i < finPeriods.length; ++i) {
                    finPeriods[i] = new FAFinancialPeriod(true);
                    finPeriods[i].setValidFrom(DateHelper.tomorrow((Date)finPeriods[i - 1].getValidUntil()));
                    finPeriods[i].setValidUntil(DateHelper.getLastDayOfMonth((Date)finPeriods[i].getValidFrom()));
                    finPeriods[i].setCode(String.valueOf(new VDate(finPeriods[i].getValidUntil()).getMonth() + 1));
                }
                finPeriods[finPeriods.length - 1].setYearEndPeriod(true);
                newFinYear.setFinancialPeriods(finPeriods);
                finYearsList.add(newFinYear);
                lastFinYear = newFinYear;
            }
        }
        FAFinancialYear[] finYears = new FAFinancialYear[finYearsList.size()];
        finYearsList.toArray(finYears);
        return finYears;
    }

    private static Date calculateTechnicalDisposalDate(FAFinancialYear finYear, FAFinancialPeriod finPeriod, DepreciationArea deprArea, Date fullDisposalDate) {
        switch (deprArea.getCompleteRetirement().value()) {
            case 0: {
                return DateHelper.yesterday((Date)finYear.getValidFrom());
            }
            case 1: {
                return DateHelper.yesterday((Date)finPeriod.getValidFrom());
            }
            case 2: {
                return DateHelper.getLastDayOfMonth((Date)fullDisposalDate);
            }
            case 3: {
                return DateHelper.getLastDayOfYear((Date)fullDisposalDate);
            }
            case 4: {
                return DateHelper.getLastDayOfHalfYear((Date)fullDisposalDate);
            }
            case 5: {
                return fullDisposalDate;
            }
            case 6: {
                return DateHelper.getLastDayOfMonth((Date)fullDisposalDate);
            }
            case 7: {
                return fullDisposalDate;
            }
        }
        return fullDisposalDate;
    }

    private static void removeIsDepreciatedWhenPerformanceDepr(FixedAssetTransaction faTransaction, FixedAssetArea faArea) {
        LOGGER.debug("removeIsDepreciatedWhenPerformanceDepr(...)");
        PeriodUnits periodUnit = null;
        PerformanceUnits unit = PerformanceUnits.getPerformanceUnitForYear((FixedAssetArea)faArea, (FAFinancialYear)faTransaction.getFinancialYear());
        if (unit != null && (periodUnit = PeriodUnitsPersistencyManager.getPeriodUnitsForDate((PerformanceUnits)unit, (Date)faTransaction.getProcessingDate())) != null && periodUnit.getIsDepreciated()) {
            periodUnit.setIsDepreciated(false);
            periodUnit.setDepreciation(BigDecimal.ZERO);
            periodUnit.makeSaveable();
        }
    }

    public static BigDecimal calculateReplacementValue(DepreciationCalculationHelper dch, FixedAssetArea faArea, Date processDate, List<DepreciationProtocolMessages> protocolMessages, boolean isDeprPreview, Language language, FAFinancialYear finYear, boolean isCancallation) {
        LOGGER.debug("calculateReplacementValue(...)");
        if (faArea.getReplacementIndex() == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal baseValue = null;
        BigDecimal indexBaseValue = null;
        BigDecimal indexCurrentValue = null;
        IndexSeries indSeries = faArea.getReplacementIndex();
        switch (faArea.getReplacementIndex().getBaseForCalc().value()) {
            case 0: {
                baseValue = dch.getAccumAcquisitionValue();
                break;
            }
            case 1: {
                baseValue = faArea.getHistoricalAcquisitionValue();
                break;
            }
            case 4: {
                baseValue = faArea.getReplacementValue();
            }
        }
        if (BigDecimalMapper.isZeroOrNull(baseValue)) {
            return BigDecimal.ZERO;
        }
        Date acquDate = ((FixedAssetData)faArea.getFixedAsset()).getAcquisitionDate();
        if (processDate != null) {
            if (isCancallation && faArea.getReplacementIndex().getBaseForCalc().value() == 4 && finYear != null) {
                processDate = finYear.getValidFrom();
            }
            if (DateHelper.before((Date)processDate, (Date)acquDate)) {
                processDate = acquDate;
            }
        } else {
            processDate = acquDate;
        }
        switch (faArea.getReplacementIndex().getSeriesType().value()) {
            case 0: {
                indexBaseValue = indSeries.getIndexValueForDate(acquDate);
                indexCurrentValue = indSeries.getIndexValueForDate(processDate);
                break;
            }
            case 1: {
                if (indSeries.getIndexValues().length > 0) {
                    indexBaseValue = indSeries.getIndexValues()[0].getIndexValue();
                }
                int baseYear = new VDate(((FixedAssetData)faArea.getFixedAsset()).getAcquisitionDate()).getYear();
                int currentYear = new VDate(processDate).getYear();
                int years = currentYear - baseYear;
                if (years >= indSeries.getIndexValues().length) break;
                indexCurrentValue = indSeries.getIndexValues()[years].getIndexValue();
            }
        }
        if (indexBaseValue == null) {
            if (protocolMessages != null) {
                String message = mAADepreciationList.getString((ILanguage)language, 1) + " " + faArea.getFixedAsset().getCode() + ", " + mAADepreciationList.getString((ILanguage)language, 2) + " " + new VDate(processDate).getYear() + ": " + mAADepreciationList.getString((ILanguage)language, 3);
                protocolMessages.add(new DepreciationProtocolMessages(0, message));
            }
            return BigDecimal.ZERO;
        }
        if (isDeprPreview && indexCurrentValue == null) {
            indexCurrentValue = indSeries.getIndexValues()[indSeries.getIndexValues().length - 1].getIndexValue();
        }
        if (indexCurrentValue == null) {
            if (protocolMessages != null) {
                String message = mAADepreciationList.getString((ILanguage)language, 1) + " " + faArea.getFixedAsset().getCode() + ", " + mAADepreciationList.getString((ILanguage)language, 2) + " " + new VDate(processDate).getYear() + ": " + mAADepreciationList.getString((ILanguage)language, 4);
                protocolMessages.add(new DepreciationProtocolMessages(0, message));
            }
            return BigDecimal.ZERO;
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)indexBaseValue) || BigDecimalMapper.isZeroOrNull((BigDecimal)indexCurrentValue) || BigDecimalMapper.isZeroOrNull((BigDecimal)baseValue)) {
            return BigDecimal.ZERO;
        }
        if (isCancallation && faArea.getReplacementIndex().getBaseForCalc().value() == 4) {
            BigDecimal tempValue = indexBaseValue;
            indexBaseValue = indexCurrentValue;
            indexCurrentValue = tempValue;
        }
        return BigDecimalMapper.toBigDecimal((BigDecimal)baseValue).multiply(indexCurrentValue).divide(indexBaseValue, 2, RoundingMode.HALF_EVEN);
    }

    private void checkSpecialReserves(List<DepreciationPostingAndProtocolHelper> allDepreciations, SpecialReserve[] specialReserves) throws BusinessDomainException {
        block4: for (int i = 0; i < specialReserves.length; ++i) {
            SpecialReserve specReserve = specialReserves[i];
            SpecialReserveCalculation specResCalc = null;
            switch (this.mFunction.value()) {
                case 0: {
                    if (specReserve.getStartConsumptionDate() == null || this.mDepreciationUntilDate == null || !DateHelper.beforeOrEqual((Date)specReserve.getStartConsumptionDate(), (Date)this.mDepreciationUntilDate)) continue block4;
                    specResCalc = new SpecialReserveCalculation(this.mCompany, specReserve, this.mDepreciationUntilDate, this.mCancellationUntilDate, this.mIsDeprPreview, this.mPrintDepreciationProtocol, this.mDocumentDate, this.mFunction, this.mGlobalLanguage, this.mFaArea, this.mCalcMethod, this.mProtocolMessages, false);
                    specResCalc.specialReserveProcessing(allDepreciations, null);
                    continue block4;
                }
                case 1: {
                    this.mLastDepr = false;
                    if (this.mFaArea.getProcessingDate() == null) {
                        if (this.mFaArea.getLastDeprDate() != null) {
                            this.mLastDepr = DateHelper.beforeOrEqual((Date)this.mCancellationUntilDate, (Date)this.mFaArea.getLastDeprDate());
                        }
                    } else {
                        this.mLastDepr = DateHelper.beforeOrEqual((Date)this.mCancellationUntilDate, (Date)this.mFaArea.getProcessingDate());
                    }
                    if (!this.mLastDepr) continue block4;
                    specResCalc = new SpecialReserveCalculation(this.mCompany, specReserve, this.mDepreciationUntilDate, this.mCancellationUntilDate, this.mIsDeprPreview, this.mPrintDepreciationProtocol, this.mDocumentDate, this.mFunction, this.mGlobalLanguage, this.mFaArea, this.mCalcMethod, this.mProtocolMessages, false);
                    specResCalc.cancelSpecialReserveConsumption(allDepreciations);
                }
            }
        }
    }

    public static void checkPreset(DepreciationStruct deprPresStruct) throws BusinessDomainException {
        if (deprPresStruct.faFinancialYear.discriminator() && deprPresStruct.faFinancialYear.yearShort().yearClosed) {
            throw DepreciationPresetExceptionMapper.makeYearClosedDomainException((String)"DepreciationCalculation.checkPreset");
        }
        if (deprPresStruct.faPeriod.discriminator()) {
            FAFinancialPeriodDetailStruct[] periodDetails = deprPresStruct.faPeriod.period().periodDetails;
            FAFinancialPeriodDetailStruct detail = null;
            for (int i = 0; i < periodDetails.length; ++i) {
                if (!periodDetails[i].areaShort.oidTs.objectid.equals(deprPresStruct.area.oidTs.objectid)) continue;
                detail = periodDetails[i];
            }
            if (detail != null && detail.deprAreaClosed) {
                throw DepreciationPresetExceptionMapper.makePeriodClosedDomainException((String)"DepreciationCalculation.checkPreset");
            }
        }
    }

    private void calculateDepreciationValue(FixedAssetArea faArea, DepreciationCalculationHelper dch, List<DepreciationCalculationHelper> transactCache, BigDecimal[][] periodValues, int periodIndex, FAFinancialPeriod[] finPeriods) {
        Calendar cal2;
        Date lastProcDate;
        int i;
        LOGGER.debug("calculateDepreciationValue(...)");
        DepreciationCalculationHelper[] dcHelpersOrg = new DepreciationCalculationHelper[transactCache.size()];
        transactCache.toArray(dcHelpersOrg);
        ArrayList<DepreciationCalculationHelper> dcHelpersList = new ArrayList<DepreciationCalculationHelper>();
        for (int i2 = 0; i2 < dcHelpersOrg.length; ++i2) {
            if (dcHelpersOrg[i2].getIsCancelation() || dcHelpersOrg[i2].getIsCanceled()) continue;
            dcHelpersList.add(dcHelpersOrg[i2].clone());
        }
        DepreciationCalculationHelper[] dcHelpers = new DepreciationCalculationHelper[dcHelpersList.size()];
        dcHelpersList.toArray(dcHelpers);
        SimplePeriod period = new SimplePeriod(DateHelper.getFirstDayOfMonth((Date)dch.getProcessingDate()), DateHelper.getLastDayOfMonth((Date)dch.getProcessingDate()));
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal deprAmount = BigDecimal.ZERO;
        Calendar cal = DateHelper.toCalendar((String)DateMapper.toString((Date)faArea.getDeprStartDate()));
        Calendar cal1 = DateHelper.toCalendar((String)DateMapper.toString((Date)faArea.getDeprStartDate()));
        int usefullLifeInDays = 0;
        if (this.mFaArea.getUsefullLifeInDays() == Integer.MIN_VALUE || this.mFaArea.getUsefullLifeInDays() == 0) {
            if (this.mFaArea.getUsefullLifeInMonth() > 0) {
                usefullLifeInDays = this.mFixedAsset == null ? FixedAssetArea.calculateLifeInDays(((FixedAssetData)this.mFaArea.getFixedAsset()).getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth()) : FixedAssetArea.calculateLifeInDays(this.mFixedAsset.getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth());
            }
        } else {
            usefullLifeInDays = this.mFaArea.getUsefullLifeInDays();
        }
        cal.add(5, usefullLifeInDays);
        cal1.add(2, faArea.getUsefullLifeInMonth());
        Date endDate = cal.getTime();
        AutomaticDepreciationTypeEnum automDeprTypeOld = null;
        AutomaticDepreciationTypeEnum automDeprTypeNew = null;
        int divisor = 12;
        if (dch.getUsefullLifeInMonth() < divisor) {
            divisor = dch.getUsefullLifeInMonth();
        }
        for (i = 0; i < dcHelpers.length; ++i) {
            int resLifeInDays = 0;
            if (!DateHelper.before((Date)endDate, (Date)DateHelper.tomorrow((Date)dcHelpers[i].getProcessingDate()))) {
                resLifeInDays = DateHelper.getDiffInDays((Date)endDate, (Date)DateHelper.tomorrow((Date)dcHelpers[i].getProcessingDate()));
            }
            Date currProcessDate = dcHelpers[i].getProcessingDate();
            if (dcHelpers[i].getTransactionType() == TransactionEnum.TRE_POST_CAPITALIZATION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_CREDIT_NOTE || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_EXISTING_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION_SPLIT || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_DISPOSAL || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_REPOST || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_REPOST_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_FULL_DISPOSAL || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_FULL_REPOST || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_WRITE_DOWN_CURR_VALUE || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_WRITE_UP || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_REVALUATION) {
                currProcessDate = DateHelper.yesterday((Date)dcHelpers[i].getProcessingDate());
                resLifeInDays = !DateHelper.before((Date)endDate, (Date)DateHelper.tomorrow((Date)dcHelpers[i].getProcessingDate())) ? DateHelper.getDiffInDays((Date)endDate, (Date)dcHelpers[i].getProcessingDate()) : 0;
            }
            dcHelpers[i].setResLifeInDaysTemp(resLifeInDays);
            Date nextProcessDate = null;
            if (i < dcHelpers.length - 1 && dcHelpers[i + 1] != null) {
                nextProcessDate = dcHelpers[i + 1].getProcessingDate();
                if ((dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_POST_CAPITALIZATION || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_CREDIT_NOTE || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_EXISTING_ADDITION || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_PARTIAL_ADDITION || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION_SPLIT || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_PARTIAL_DISPOSAL || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_PARTIAL_REPOST || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_REPOST_ADDITION || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_FULL_DISPOSAL || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_FULL_REPOST || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_WRITE_DOWN_CURR_VALUE || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_WRITE_UP || dcHelpers[i + 1].getTransactionType() == TransactionEnum.TRE_REVALUATION) && DateHelper.after((Date)nextProcessDate, (Date)currProcessDate)) {
                    nextProcessDate = DateHelper.yesterday((Date)nextProcessDate);
                }
            }
            if (dcHelpers[i].getTransactionType() == TransactionEnum.TRE_POST_CAPITALIZATION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_CREDIT_NOTE || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_EXISTING_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_NEW_ADDITION_SPLIT || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_DISPOSAL || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_PARTIAL_REPOST || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_REPOST_ADDITION || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_FULL_DISPOSAL || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_FULL_REPOST || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_WRITE_DOWN_CURR_VALUE || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_WRITE_UP || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_REVALUATION) {
                if (nextProcessDate == null || DateHelper.after((Date)nextProcessDate, (Date)DateHelper.getLastDayOfMonth((Date)dcHelpers[i].getProcessingDate()))) {
                    nextProcessDate = DateHelper.getLastDayOfMonth((Date)dcHelpers[i].getProcessingDate());
                }
            } else if (nextProcessDate == null) {
                nextProcessDate = DateHelper.getLastDayOfMonth((Date)DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)dcHelpers[i].getProcessingDate())));
            }
            dcHelpers[i].setPartUseInDays(DateHelper.getDiffInDays((Date)nextProcessDate, (Date)currProcessDate));
        }
        for (i = 0; i < dcHelpers.length; ++i) {
            if (i > 0 && dcHelpers[i - 1].getAutomDeprType() != null) {
                automDeprTypeOld = dcHelpers[i - 1].getAutomDeprType();
            }
            if (dcHelpers[i].getAutomDeprType() != null) {
                automDeprTypeNew = dcHelpers[i].getAutomDeprType();
            }
            if (automDeprTypeOld == null && (automDeprTypeOld = automDeprTypeNew) == null) {
                CalcMethod calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)this.mFaArea.getOidDepreciationMethod());
                automDeprTypeOld = FixedAssetTransaction.determineAutomaticDepreciationType((CalcMethod)calcMethod);
            }
            if (automDeprTypeNew == null) {
                automDeprTypeNew = automDeprTypeOld;
            }
            if ((!DateHelper.between((Date)dcHelpers[i].getProcessingDate(), (Date)period.getValidFrom(), (Date)period.getValidUntil()) || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_AUTOMATIC_DEPR || dcHelpers[i].getTransactionType() == TransactionEnum.TRE_MANUAL_DEPR) && (!DateHelper.equal((Date)DateHelper.tomorrow((Date)dcHelpers[i].getProcessingDate()), (Date)period.getValidFrom()) || dcHelpers[i].getTransactionType() != TransactionEnum.TRE_AUTOMATIC_DEPR && dcHelpers[i].getTransactionType() != TransactionEnum.TRE_MANUAL_DEPR)) continue;
            deprAmount = automDeprTypeOld == AutomaticDepreciationTypeEnum.ADTE_STRAIGHT_LINE ? dcHelpers[i].getAccumAcquisitionValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(DAYSOFAYEAR, 18, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(dcHelpers[i].getPartUseInDays())) : (automDeprTypeOld == AutomaticDepreciationTypeEnum.ADTE_DECLINING_BAL ? dcHelpers[i].getNetBookValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(DAYSOFAYEAR, 18, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(dcHelpers[i].getPartUseInDays())) : (this.mCalcMethod.getBaseForCalc().value() == 4 && BigDecimalMapper.compareTo((BigDecimal)dcHelpers[i].getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0 ? dcHelpers[i].getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)).multiply(BigDecimal.valueOf(dcHelpers[i].getPartUseInDays())).divide(BigDecimal.valueOf(dcHelpers[i].getResLifeInDaysTemp()), 2, RoundingMode.HALF_DOWN) : dcHelpers[i].getNetBookValue().multiply(BigDecimal.valueOf(dcHelpers[i].getPartUseInDays())).divide(BigDecimal.valueOf(dcHelpers[i].getResLifeInDaysTemp()), 2, RoundingMode.HALF_DOWN)));
            result = result.add(deprAmount);
            for (int j = i; j < dcHelpers.length; ++j) {
                dcHelpers[j].setNetBookValue(dcHelpers[j].getNetBookValue().subtract(deprAmount));
            }
        }
        periodValues[periodIndex][1] = result;
        Date interruptDeprToDate = this.mFaArea.getInterruptDeprToDate();
        if (interruptDeprToDate == null) {
            interruptDeprToDate = DateHelper.tomorrow((Date)this.mDepreciationUntilDate);
        }
        if (automDeprTypeNew == AutomaticDepreciationTypeEnum.ADTE_STRAIGHT_LINE) {
            if (this.mDeprArea.getAverage()) {
                for (int j = periodIndex + 1; j < periodValues.length; ++j) {
                    if (this.mFaArea.getInterruptDeprFromDate() != null) {
                        if (j < finPeriods.length && DateHelper.between((Date)finPeriods[j].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                            periodValues[j][1] = BigDecimal.ZERO;
                            continue;
                        }
                        periodValues[j][1] = dch.getAccumAcquisitionValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(BigDecimal.valueOf(divisor), 2, RoundingMode.HALF_DOWN);
                        continue;
                    }
                    periodValues[j][1] = dch.getAccumAcquisitionValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(BigDecimal.valueOf(divisor), 2, RoundingMode.HALF_DOWN);
                }
            } else {
                for (int j = periodIndex + 1; j < periodValues.length; ++j) {
                    lastProcDate = DateHelper.getFirstDayOfMonth((Date)dcHelpers[dcHelpers.length - 1].getProcessingDate());
                    cal2 = DateHelper.toCalendar((String)DateMapper.toString((Date)lastProcDate));
                    cal2.add(2, j - periodIndex);
                    BigDecimal periodDays = BigDecimal.valueOf(DateHelper.getDate((Date)DateHelper.getLastDayOfMonth((Date)cal2.getTime())));
                    if (this.mFaArea.getInterruptDeprFromDate() != null) {
                        if (j < finPeriods.length && DateHelper.between((Date)finPeriods[j].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                            periodValues[j][1] = BigDecimal.ZERO;
                            continue;
                        }
                        periodValues[j][1] = dch.getAccumAcquisitionValue().multiply(this.mFaArea.getDepreciationPercent()).multiply(periodDays).divide(HUNDRED).divide(DAYSOFAYEAR, 2, RoundingMode.HALF_DOWN);
                        continue;
                    }
                    periodValues[j][1] = dch.getAccumAcquisitionValue().multiply(this.mFaArea.getDepreciationPercent()).multiply(periodDays).divide(HUNDRED).divide(DAYSOFAYEAR, 2, RoundingMode.HALF_DOWN);
                }
            }
        } else if (automDeprTypeNew == AutomaticDepreciationTypeEnum.ADTE_DECLINING_BAL) {
            if (this.mDeprArea.getAverage()) {
                for (int j = periodIndex + 1; j < periodValues.length; ++j) {
                    if (this.mFaArea.getInterruptDeprFromDate() != null) {
                        if (j < finPeriods.length && DateHelper.between((Date)finPeriods[j].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                            periodValues[j][1] = BigDecimal.ZERO;
                            continue;
                        }
                        periodValues[j][1] = dch.getNetBookValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(BigDecimal.valueOf(divisor), 2, RoundingMode.HALF_DOWN);
                        continue;
                    }
                    periodValues[j][1] = dch.getNetBookValue().multiply(this.mFaArea.getDepreciationPercent()).divide(HUNDRED).divide(BigDecimal.valueOf(divisor), 2, RoundingMode.HALF_DOWN);
                }
            } else {
                for (int j = periodIndex + 1; j < periodValues.length; ++j) {
                    lastProcDate = DateHelper.getFirstDayOfMonth((Date)dcHelpers[dcHelpers.length - 1].getProcessingDate());
                    cal2 = DateHelper.toCalendar((String)DateMapper.toString((Date)lastProcDate));
                    cal2.add(2, j - periodIndex);
                    BigDecimal periodDays = BigDecimal.valueOf(DateHelper.getDate((Date)DateHelper.getLastDayOfMonth((Date)cal2.getTime())));
                    if (this.mFaArea.getInterruptDeprFromDate() != null) {
                        if (j < finPeriods.length && DateHelper.between((Date)finPeriods[j].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                            periodValues[j][1] = BigDecimal.ZERO;
                            continue;
                        }
                        periodValues[j][1] = dch.getNetBookValue().multiply(this.mFaArea.getDepreciationPercent()).multiply(periodDays).divide(HUNDRED).divide(DAYSOFAYEAR, 2, RoundingMode.HALF_DOWN);
                        continue;
                    }
                    periodValues[j][1] = dch.getNetBookValue().multiply(this.mFaArea.getDepreciationPercent()).multiply(periodDays).divide(HUNDRED).divide(DAYSOFAYEAR, 2, RoundingMode.HALF_DOWN);
                }
            }
        } else {
            int resDays = dcHelpers[dcHelpers.length - 1].getResLifeInDaysTemp();
            lastProcDate = DateHelper.getFirstDayOfMonth((Date)dcHelpers[dcHelpers.length - 1].getProcessingDate());
            BigDecimal amountPerDay = BigDecimal.ZERO;
            amountPerDay = this.mCalcMethod.getBaseForCalc().value() == 4 && BigDecimalMapper.compareTo((BigDecimal)dcHelpers[dcHelpers.length - 1].getNetBookValue(), (BigDecimal)DepreciationCalculation.getDepResValue(this.mFaArea)) > 0 ? dcHelpers[dcHelpers.length - 1].getNetBookValue().subtract(DepreciationCalculation.getDepResValue(this.mFaArea)).divide(BigDecimal.valueOf(resDays), RoundingMode.HALF_DOWN) : dcHelpers[dcHelpers.length - 1].getNetBookValue().divide(BigDecimal.valueOf(resDays), RoundingMode.HALF_DOWN);
            for (int j = periodIndex + 1; j < periodValues.length; ++j) {
                Calendar cal22 = DateHelper.toCalendar((String)DateMapper.toString((Date)lastProcDate));
                cal22.add(2, j - periodIndex);
                int periodDays = DateHelper.getDate((Date)DateHelper.getLastDayOfMonth((Date)cal22.getTime()));
                if (this.mFaArea.getInterruptDeprFromDate() != null) {
                    if (j < finPeriods.length && DateHelper.between((Date)finPeriods[j].getValidUntil(), (Date)this.mFaArea.getInterruptDeprFromDate(), (Date)interruptDeprToDate)) {
                        periodValues[j][1] = BigDecimal.ZERO;
                        continue;
                    }
                    periodValues[j][1] = amountPerDay.multiply(BigDecimal.valueOf(periodDays));
                    continue;
                }
                periodValues[j][1] = amountPerDay.multiply(BigDecimal.valueOf(periodDays));
            }
        }
    }

    private int getUsefullLifeInDays() {
        int usefullLifeInDays = 0;
        if (this.mFaArea.getUsefullLifeInDays() == Integer.MIN_VALUE || this.mFaArea.getUsefullLifeInDays() == 0) {
            if (this.mFaArea.getUsefullLifeInMonth() > 0) {
                usefullLifeInDays = this.mFixedAsset == null ? FixedAssetArea.calculateLifeInDays(((FixedAssetData)this.mFaArea.getFixedAsset()).getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth()) : FixedAssetArea.calculateLifeInDays(this.mFixedAsset.getAcquisitionDate(), this.mFaArea.getDeprStartDate(), this.mFaArea.getUsefullLifeInMonth());
            }
        } else {
            usefullLifeInDays = this.mFaArea.getUsefullLifeInDays();
        }
        return usefullLifeInDays;
    }

    public static BigDecimal getNewMonthlyDepreciation(Boolean baseForDeprIsAcquisitionValue, BigDecimal baseAmount, FixedAssetArea faArea, short resLifeInMonth) {
        BigDecimal yearDeprAmount = BigDecimal.ZERO;
        if (baseForDeprIsAcquisitionValue.booleanValue()) {
            if (!BigDecimalMapper.isZero((BigDecimal)faArea.getDepreciationPercent()) && !BigDecimalMapper.isZero((BigDecimal)baseAmount)) {
                yearDeprAmount = baseAmount.multiply(faArea.getDepreciationPercent()).divide(HUNDRED, 2, RoundingMode.HALF_EVEN);
                return yearDeprAmount.divide(new BigDecimal("12.00"), 2, RoundingMode.HALF_EVEN);
            }
            return BigDecimal.ZERO;
        }
        if (resLifeInMonth > 0 && !BigDecimalMapper.isZero((BigDecimal)baseAmount)) {
            return baseAmount.divide(new BigDecimal(resLifeInMonth), 2, RoundingMode.HALF_EVEN);
        }
        return BigDecimal.ZERO;
    }

    private static BigDecimal getDepResValue(FixedAssetArea faArea) {
        return faArea.getDepResValue() != null ? faArea.getDepResValue() : BigDecimal.ZERO;
    }

    static {
        mAADepreciationList = TranslateableResourceList.createTranslateableResourceList((String)"AADepreciationList", (String[])new String[]{"Automatic Posting from Asset Accounting", "Fixed Asset", "Year", "Der Indexwert f\u00fcr das Anschaffungsjahr ist nicht vorhanden. Es erfolgt keine Berechnung des Wiederbeschaffungswertes !", "Der Indexwert f\u00fcr das aktuelle Gesch\u00e4ftsjahr ist nicht vorhanden. Es erfolgt keine Berechnung des Wiederbeschaffungswertes !", "Der automatische GWG Vollabgang wird nicht generiert, da nach dem Abgangsdatum noch manuelle Bewegungen existieren !", "Der automatische GWG Vollabgang wird nicht generiert, da die Abgangsperiode (Monat nach dem Datum der letzten Abschreibung) bereits geschlossen ist !"});
    }
}

