/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.ecsaleslist;

import com.varial.accounting.domain.archivetransactiondata.StatusHolder;
import com.varial.accounting.domain.ecsaleslist.ECSalesListExceptionMapper;
import com.varial.accounting.domain.ecsaleslist.IVATCheckEntry;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.base.callback.AbstractAsynchronousPrintCommand;
import com.varial.base.callback.TransactionMode;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.VATNumberFactory;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckManager;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import com.varial.framework.domain.printservice.PrintProgress;
import com.varial.framework.domain.printservice.ProgressInterface;
import com.varial.interfaces.IAccountingCompany;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.query.AllCallbackOperations;
import com.varial.serverbase.query.PutDataException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractQualifiedVATCheckCallbackImpl
extends AbstractAsynchronousPrintCommand<ReportFileStructCallback> {
    private final String oidCompany;
    private final ProgressInterface checkingProgress;

    public AbstractQualifiedVATCheckCallbackImpl(AuthorizationToken token, ReportFileStructCallback callback, String oidCompany) {
        super(token, (AllCallbackOperations)callback, TransactionMode.NONE);
        this.oidCompany = oidCompany;
        this.checkingProgress = new PrintProgress(callback);
    }

    public void execute() throws BusinessDomainException, PutDataException {
        StatusHolder holder = new StatusHolder(false);
        try {
            holder.startTransaction();
            IVATCheckEntry[] entries = this.getVATCheckEntries();
            if (entries == null || entries.length == 0) {
                throw ECSalesListExceptionMapper.makeNoDataAvailableForQualifiedVATCheckDomainException();
            }
            this.checkingProgress.updateProgress(1, 2, "", 1, 2, false);
            AccountingCompany company = AccountingCompanyPersistencyManager.getAccountingCompany((String)this.oidCompany);
            VATQualifiedCheckManager checkManager = VATQualifiedCheckManager.getVATQualifiedCheckManager((ICompany)company);
            Map<String, List<IVATCheckEntry>> entriesGroupedByRequest = Arrays.stream(entries).collect(Collectors.groupingBy(this::getVATQualifiedCheckRequestKey));
            int count = entriesGroupedByRequest.size();
            int currentNo = 0;
            for (Map.Entry<String, List<IVATCheckEntry>> entry : entriesGroupedByRequest.entrySet()) {
                List<IVATCheckEntry> entriesWithSameCheckRequest = entry.getValue();
                VATQualifiedCheckRequest vatQualifiedCheckRequest = this.getVATQualifiedCheckRequest(entriesWithSameCheckRequest.get(0));
                VATQualifiedCheck response = checkManager.checkVat(vatQualifiedCheckRequest, (IAccountingCompany)company);
                entriesWithSameCheckRequest.forEach(e -> e.setVatQualifiedCheck(response));
                this.checkingProgress.updateProgress(currentNo, count, "", 2, 2, false);
                ++currentNo;
            }
            holder.getContext().flush();
            holder.commit();
        }
        catch (RuntimeException e2) {
            ExceptionMapper.printException((Throwable)e2);
            holder.rollback((Throwable)e2);
            throw e2;
        }
        catch (Error e3) {
            ExceptionMapper.printException((Throwable)e3);
            holder.rollback((Throwable)e3);
            throw e3;
        }
        catch (BusinessDomainException | PutDataException e4) {
            ExceptionMapper.printException((Throwable)e4);
            holder.rollback(e4);
            throw e4;
        }
        finally {
            holder.endService();
        }
    }

    private VATQualifiedCheckRequest getVATQualifiedCheckRequest(IVATCheckEntry vatCheckEntry) {
        VATQualifiedCheckRequest request = new VATQualifiedCheckRequest();
        VATNumber lookupVAT = new VATNumberFactory().create(StringMapper.toStringWithTrim((String)vatCheckEntry.getEcCountryCode()) + StringMapper.toStringWithTrim((String)vatCheckEntry.getVatNumber()));
        request.setLookupVAT(lookupVAT);
        request.setTraderCity(vatCheckEntry.getPersonalAccountTown());
        request.setTraderName(vatCheckEntry.getPersonalAccountName());
        request.setTraderPostcode(vatCheckEntry.getPersonalAccountPostcode());
        request.setTraderStreet(vatCheckEntry.getPersonalAccountStreet());
        request.setWithCofirmationLetter(vatCheckEntry.isConfirmLetter());
        return request;
    }

    private String getVATQualifiedCheckRequestKey(IVATCheckEntry vatCheckEntry) {
        VATQualifiedCheckRequest request = this.getVATQualifiedCheckRequest(vatCheckEntry);
        return request.getLookupVAT().toString() + "/" + StringMapper.toStringWithTrim((String)request.getTraderCity()) + "/" + StringMapper.toStringWithTrim((String)request.getTraderName()) + "/" + StringMapper.toStringWithTrim((String)request.getTraderPostcode()) + "/" + StringMapper.toStringWithTrim((String)request.getTraderStreet()) + "/" + StringMapper.toStringWithTrim((String)BooleanMapper.toString((boolean)request.isWithCofirmationLetter()));
    }

    protected abstract IVATCheckEntry[] getVATCheckEntries();
}

