/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.primerevenue;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringExportFactory;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringFileNameContext;
import com.varial.accounting.domain.payment.reversefactoring.primerevenue.PrimeRevenueReverseFactoringLineGeneratorImpl;
import com.varial.accounting.domain.payment.reversefactoring.primerevenue.PrimeRevenueUtils;
import com.varial.base.exception.BusinessDomainException;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;

public class PrimeRevenueFactory
implements ReverseFactoringExportFactory {
    private final String buyerId;
    private final Date creationDate;

    public PrimeRevenueFactory(String buyerId, Date creationDate) {
        this.buyerId = buyerId;
        this.creationDate = creationDate;
    }

    @Override
    public LineGenerator createLineGenerator(GeneratePayment payment) throws BusinessDomainException {
        return new PrimeRevenueReverseFactoringLineGeneratorImpl(payment, this.buyerId);
    }

    @Override
    public String createFileName(GeneratePayment payment, ReverseFactoringFileNameContext context) {
        return this.buyerId + "_" + DateMapper.toYYYYMMDDString((Date)this.creationDate) + "_" + PrimeRevenueUtils.toSequenceNumber(context.getIndex()) + ".csv";
    }
}

