/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.format;

import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormattingStrategy;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.converter.OutputTextCleaner;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;

public class DefaultFormattingStrategy
implements ReverseFactoringFormattingStrategy {
    @Override
    public String formatText(String value, char fieldSeparatorCharacter) {
        if (StringMapper.isNullString((String)value)) {
            return "";
        }
        String cleaned = OutputTextCleaner.cleanControlChars((String)value);
        StringBuilder result = new StringBuilder(cleaned.length());
        for (char c : cleaned.toCharArray()) {
            if (c == fieldSeparatorCharacter) {
                result.append(' ');
                continue;
            }
            result.append(c);
        }
        return result.toString().trim();
    }

    @Override
    public String formatAmount(BigDecimal amount, ICurrency currency) {
        return FactoringHelper.getFormatAmountWithComma((ICurrency)currency, (BigDecimal)amount);
    }

    @Override
    public String formatDate(Date date) {
        return DateMapper.toDDMMYYYYPointSeparationString((Date)date);
    }
}

