/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.eurofactor;

import com.varial.accounting.domain.factoringbase.FactoringHelper;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.ReverseFactoringHelper;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringLineGeneratorImpl;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatType;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatterFactory;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.FieldSeparatorType;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.List;

public class EurofactorReverseFactoringLineGeneratorImpl
extends ReverseFactoringLineGeneratorImpl {
    public EurofactorReverseFactoringLineGeneratorImpl(GeneratePayment generatePayment) {
        super(generatePayment, FieldSeparatorType.SEMICOLON, ReverseFactoringFormatterFactory.createFormatter(ReverseFactoringFormatType.EUROFACTOR));
    }

    @Override
    protected List<OutputField> createHeaderLineFields() {
        return List.of(this.createDateField(ReverseFactoringHelper.getDepositDate((GeneratePayment)this.payment)));
    }

    @Override
    protected List<OutputField> createOpenItemExportFields(GeneratePaymentRemittance remittance) {
        return List.of(this.createDepositNumberField(remittance), this.createNumberAtFactoringCompanyField(), this.createReferenceNumberField(remittance), this.createDocumentDateField(remittance), this.createDueDateField(remittance), this.createGrossAmountField(remittance), this.createDiscountAmountField(remittance), this.createPaymentAmountField(remittance));
    }

    private OutputField createDocumentDateField(GeneratePaymentRemittance remittance) {
        return this.createDateField(remittance.getOpenItem().getDocumentDate());
    }

    private OutputField createDepositNumberField(GeneratePaymentRemittance remittance) {
        return new TextField(StringMapper.toStringWithTrim((String)ReverseFactoringHelper.getDepositNumber((GeneratePayment)remittance.getGeneratePayment())));
    }

    private OutputField createNumberAtFactoringCompanyField() {
        return new TextField(this.payment.getNumberAtFactoringCompany());
    }

    private OutputField createReferenceNumberField(GeneratePaymentRemittance remittance) {
        return new TextField(remittance.getOpenItem().getReferenceNumber());
    }

    private OutputField createDueDateField(GeneratePaymentRemittance remittance) {
        return this.createDateField(this.getDueDate(remittance));
    }

    private OutputField createGrossAmountField(GeneratePaymentRemittance remittance) {
        BigDecimal grossAmount = remittance.getOpenItem().getOriginalAmount();
        return new TextField(this.getAmount(grossAmount, this.getCurrency(remittance), remittance.isCreditNote()));
    }

    private OutputField createDiscountAmountField(GeneratePaymentRemittance remittance) {
        BigDecimal discountAmount = BigDecimalMapper.abs((BigDecimal)remittance.getDiscountAmount());
        return new TextField(this.getAmount(discountAmount, this.getCurrency(remittance), remittance.isCreditNote()));
    }

    private OutputField createPaymentAmountField(GeneratePaymentRemittance remittance) {
        BigDecimal paymentAmount = BigDecimalMapper.abs((BigDecimal)remittance.getAmountOfPayment());
        return new TextField(this.getAmount(paymentAmount, this.getCurrency(remittance), remittance.isCreditNote()));
    }

    private String getAmount(BigDecimal amount, ICurrency currency, boolean isCreditNote) {
        return FactoringHelper.getFormatAmountWithComma((ICurrency)currency, (BigDecimal)(isCreditNote ? amount.negate() : amount));
    }

    private ICurrency getCurrency(GeneratePaymentRemittance remittance) {
        return remittance.getOpenItem().getEnteredCurrency();
    }
}

