/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.creditagricole;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.base.configuration.Configuration;
import com.varial.base.types.date.DateHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class CreditAgricoleReverseFactoringUtils {
    private CreditAgricoleReverseFactoringUtils() {
    }

    public static String getContractNumber(GeneratePayment generatePayment, Configuration configuration) {
        return CreditAgricoleReverseFactoringUtils.getContractNumberByAnalysisCode(generatePayment, configuration);
    }

    public static String getSupplierId(GeneratePayment generatePayment, Configuration configuration) {
        return CreditAgricoleReverseFactoringUtils.getSupplierIdByAnalysisCode(generatePayment, configuration);
    }

    private static String getContractNumberByAnalysisCode(GeneratePayment generatePayment, Configuration configuration) {
        return CreditAgricoleReverseFactoringUtils.extractAnalysisCode(CreditAgricoleReverseFactoringUtils.getAnalysisCodes(generatePayment), configuration.getCreditAgricoleContractNumberByAnalysisCode());
    }

    private static String getSupplierIdByAnalysisCode(GeneratePayment generatePayment, Configuration configuration) {
        return CreditAgricoleReverseFactoringUtils.extractAnalysisCode(CreditAgricoleReverseFactoringUtils.getAnalysisCodes(generatePayment), configuration.getCreditAgricolePersonalAccountIDByAnalysisCode());
    }

    private static String extractAnalysisCode(String[] analysisCodes, int analysisCodeIndex) {
        if (analysisCodes != null && analysisCodeIndex != 0 && analysisCodeIndex - 1 < analysisCodes.length && analysisCodeIndex - 1 >= 0) {
            return StringMapper.toStringWithTrim((String)analysisCodes[analysisCodeIndex - 1]);
        }
        return "";
    }

    private static String[] getAnalysisCodes(GeneratePayment generatePayment) {
        return generatePayment.getPersonalAccount().getAnalysisCodes();
    }

    public static Date getUploadDate() {
        return DateHelper.today();
    }
}

