/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring.creditagricole;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringLineGeneratorImpl;
import com.varial.accounting.domain.payment.reversefactoring.creditagricole.CreditAgricolePaymentContext;
import com.varial.accounting.domain.payment.reversefactoring.creditagricole.CreditAgricoleReverseFactoringContractType;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatType;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatterFactory;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.FieldSeparatorType;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class CreditAgricoleReverseFactoringLineGeneratorImpl
extends ReverseFactoringLineGeneratorImpl {
    private static final OutputField EMPTY_FIELD = new TextField("");
    private static final int MAX_TEXT_LENGTH = 20;
    private final CreditAgricolePaymentContext context;
    private final ICurrency currency;

    public CreditAgricoleReverseFactoringLineGeneratorImpl(GeneratePayment payment, CreditAgricolePaymentContext context) {
        super(payment, FieldSeparatorType.SEMICOLON, ReverseFactoringFormatterFactory.createFormatter(ReverseFactoringFormatType.CREDIT_AGRICOLE));
        this.context = context;
        this.currency = payment.getCurrency();
    }

    @Override
    protected List<OutputField> createHeaderLineFields() {
        return List.of(this.createHeaderLineTypeField(), this.createContractTypeField(), this.createCountryTypeField(), this.createContractNumberField(), this.createClientIDNumberField(), this.createCurrencyField(), EMPTY_FIELD, this.createUploadDateField(), this.createNumberOfLinesField(), this.createTotalOfInvoicesField(), this.createTotalOfCreditNotesField());
    }

    private OutputField createClientIDNumberField() {
        return new TextField(this.context.getSupplierId());
    }

    private OutputField createNumberOfLinesField() {
        return new TextField(String.valueOf(this.getNumberOfLines()));
    }

    private OutputField createTotalOfInvoicesField() {
        return this.createAmountField(this.calculateTotalOfInvoices(), this.currency);
    }

    private OutputField createTotalOfCreditNotesField() {
        return this.createAmountField(this.calculateTotalOfCreditNotes(), this.currency);
    }

    private int getNumberOfLines() {
        return this.payment.getGeneratePaymentRemittances().length + 1;
    }

    private OutputField createHeaderLineTypeField() {
        return this.createFixedTextField("01");
    }

    private OutputField createOpenItemLineTypeField() {
        return this.createFixedTextField("02");
    }

    private OutputField createCurrencyField() {
        return this.createTextField(this.currency.getSwift());
    }

    private OutputField createContractTypeField() {
        return this.createFixedTextField(this.context.getContractType().exportValue());
    }

    private OutputField createCountryTypeField() {
        return this.createFixedTextField("EFAG-REV");
    }

    private OutputField createContractNumberField() {
        return new TextField(this.context.getContractNumber());
    }

    private OutputField createUploadDateField() {
        return this.createDateField(this.context.getUploadDate());
    }

    @Override
    protected List<OutputField> createOpenItemExportFields(GeneratePaymentRemittance remittance) {
        return List.of(this.createOpenItemLineTypeField(), this.createDebitorNumberField(remittance), EMPTY_FIELD, this.createReferenceNumberField(remittance), this.createDocumentDateField(remittance), this.createDueDateField(remittance), this.createOpenItemCurrencyField(remittance), this.createGrossAmountField(remittance), this.createPaymentAmountField(remittance), this.createOpenItemTypeField(remittance));
    }

    private OutputField createOpenItemTypeField(GeneratePaymentRemittance remittance) {
        return this.createFixedTextField(remittance.isCreditNote() ? "C" : "D");
    }

    private OutputField createOpenItemCurrencyField(GeneratePaymentRemittance remittance) {
        return this.createTextField(this.getOriginalCurrency(remittance).getSwift());
    }

    private OutputField createDebitorNumberField(GeneratePaymentRemittance remittance) {
        return this.createLimitedTextField(this.getDebitorNumber(remittance), 20);
    }

    private String getDebitorNumber(GeneratePaymentRemittance remittance) {
        return remittance.getGeneratePayment().getNumberAtFactoringCompany();
    }

    private OutputField createDueDateField(GeneratePaymentRemittance remittance) {
        return this.createDateField(this.getDueDate(remittance));
    }

    private OutputField createReferenceNumberField(GeneratePaymentRemittance remittance) {
        return this.createLimitedTextField(remittance.getOpenItem().getReferenceNumber(), 20);
    }

    private OutputField createGrossAmountField(GeneratePaymentRemittance remittance) {
        return this.createAmountField(this.getOriginalAmount(remittance), this.getOriginalCurrency(remittance));
    }

    private OutputField createPaymentAmountField(GeneratePaymentRemittance remittance) {
        return this.createAmountField(this.getPaymentAmount(remittance), this.getOriginalCurrency(remittance));
    }

    private OutputField createDocumentDateField(GeneratePaymentRemittance remittance) {
        return this.createDateField(remittance.getOpenItem().getDocumentDate());
    }

    private ICurrency getOriginalCurrency(GeneratePaymentRemittance remittance) {
        return remittance.getOpenItem().getEnteredCurrency();
    }

    @Override
    protected Date getDueDate(GeneratePaymentRemittance paymentRemittance) {
        return paymentRemittance.isCreditNote() ? null : super.getDueDate(paymentRemittance);
    }

    private BigDecimal calculateTotalOfCreditNotes() {
        return this.calculateTotalOfPaymentRemittances(this.isCreditNote());
    }

    private BigDecimal calculateTotalOfPaymentRemittances(Predicate<GeneratePaymentRemittance> predicate) {
        return Stream.of(this.payment.getGeneratePaymentRemittances()).filter(predicate).map(this::getAmountByContractType).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private Predicate<GeneratePaymentRemittance> isCreditNote() {
        return GeneratePaymentRemittance::isCreditNote;
    }

    private BigDecimal calculateTotalOfInvoices() {
        return this.calculateTotalOfPaymentRemittances(Predicate.not(this.isCreditNote()));
    }

    private BigDecimal getAmountByContractType(GeneratePaymentRemittance paymentRemittance) {
        return this.context.getContractType() == CreditAgricoleReverseFactoringContractType.INHOUSE ? this.getPaymentAmount(paymentRemittance) : this.getOriginalAmount(paymentRemittance);
    }

    private BigDecimal getOriginalAmount(GeneratePaymentRemittance paymentRemittance) {
        return BigDecimalMapper.abs((BigDecimal)paymentRemittance.getOpenItem().getOriginalAmount());
    }

    private BigDecimal getPaymentAmount(GeneratePaymentRemittance paymentRemittance) {
        return BigDecimalMapper.abs((BigDecimal)paymentRemittance.getAmountOfPayment());
    }
}

