/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v3.credit.foreign;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.payment.iso20022.common.util.IsoPaymentUtil;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoChargesType;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.foreign.IsoForeignPaymentUtils;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common.CreditSchemaMapper;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common.PartyIdentificationBuilder3;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common.PostalAddressBuilder3;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.schema.AddressFormatMode;
import iso.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4;
import iso.sepa.version3.credit.CashAccount16;
import iso.sepa.version3.credit.ClearingSystemMemberIdentification2;
import iso.sepa.version3.credit.FinancialInstitutionIdentification7;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.PostalAddress6;
import java.util.Optional;

public class ForeignPaymentCreditSchemaMapper
extends CreditSchemaMapper {
    private final IsoPaymentProfile profile;

    public ForeignPaymentCreditSchemaMapper(IsoPaymentProfile profile) {
        this.profile = profile;
    }

    @Override
    protected Optional<BranchAndFinancialInstitutionIdentification4> getCreditorAgent(PaymentData payment) {
        return Optional.of(new ForeignPaymentCreditorAgentMapper().map(payment));
    }

    @Override
    protected Optional<IsoChargesType> getChargesType(PaymentData payment, PaymentInfoData paymentInfo) {
        return Optional.of(IsoChargesType.getChargesTypeForNonSepaForeignPayment((PaymentData)payment, (String)paymentInfo.getBankAccountCountry().getIsoCode()));
    }

    @Override
    protected Optional<Boolean> getBtchBookgValue() {
        return Optional.of(false);
    }

    @Override
    protected PartyIdentification32 mapDebtor(PaymentInfoData paymentInfo) {
        return new PartyIdentificationBuilder3(paymentInfo).build();
    }

    @Override
    protected PartyIdentification32 mapInitiatingParty(PartyData initiatingParty) {
        return new PartyIdentificationBuilder3(initiatingParty).build();
    }

    @Override
    protected PartyIdentification32 mapCreditor(PartyData creditor) {
        return new PartyIdentificationBuilder3(creditor).withStructuredPostalAddress(creditor).build();
    }

    @Override
    protected CashAccount16 getDebtorAccount(PaymentInfoData paymentInfo) {
        CashAccount16 account = this.getCashAccountIBAN(paymentInfo.getCompanyIban());
        if (account != null && this.profile == IsoPaymentProfile.FOREIGN_DE) {
            IsoPaymentUtil.getBankAccountCurrencyCode(paymentInfo).ifPresent(arg_0 -> ((CashAccount16)account).setCcy(arg_0));
        }
        return account;
    }

    @Override
    protected boolean useIntermediaryAccount() {
        return true;
    }

    private class ForeignPaymentCreditorAgentMapper {
        private ForeignPaymentCreditorAgentMapper() {
        }

        private BranchAndFinancialInstitutionIdentification4 map(PaymentData dto) {
            BranchAndFinancialInstitutionIdentification4 result = new BranchAndFinancialInstitutionIdentification4();
            result.setFinInstnId(this.getFinancialInstitutionIdentification(dto));
            return result;
        }

        private FinancialInstitutionIdentification7 getFinancialInstitutionIdentification(PaymentData dto) {
            ClearingSystemMemberIdentification2 clrSysMbId;
            FinancialInstitutionIdentification7 instID = new FinancialInstitutionIdentification7();
            if (StringUtil.isNotEmpty((String)dto.getBic())) {
                instID.setBIC(dto.getBic());
            }
            if (this.withClearingSystemMemberIdentification(dto) && (clrSysMbId = this.getClearingSystemMemberIdentification(dto)) != null) {
                instID.setClrSysMmbId(clrSysMbId);
                instID.setNm(dto.getBankName());
                instID.setPstlAdr((PostalAddress6)new PostalAddressBuilder3(dto.getBankAddress()).setFormatMode(AddressFormatMode.STRUCTURED).build());
            }
            return instID;
        }

        private boolean withClearingSystemMemberIdentification(PaymentData dto) {
            return IsoForeignPaymentUtils.needsBankSortingCode((PaymentData)dto);
        }

        private ClearingSystemMemberIdentification2 getClearingSystemMemberIdentification(PaymentData dto) {
            if (StringUtil.isEmpty((String)dto.getBankSortingCode()) && StringUtil.isEmpty((String)dto.getAbaNumber())) {
                return null;
            }
            ClearingSystemMemberIdentification2 result = new ClearingSystemMemberIdentification2();
            String memberID = StringUtil.isNotEmpty((String)dto.getAbaNumber()) ? dto.getAbaNumber() : dto.getBankSortingCode();
            result.setMmbId(memberID);
            return result;
        }
    }
}

