/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common;

import com.varial.accounting.domain.payment.export.xml.XmlPaymentDataUtils;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoChargesType;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common.AmountMapper;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.common.PartyIdentificationBuilder3;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaHeaderData;
import com.varial.framework.domain.payment.sepa.schema.PaymentSchemaMapper;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.version3.credit.AccountIdentification4Choice;
import iso.sepa.version3.credit.AccountSchemeName1Choice;
import iso.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4;
import iso.sepa.version3.credit.CashAccount16;
import iso.sepa.version3.credit.ChargeBearerType1Code;
import iso.sepa.version3.credit.CreditTransferTransactionInformation10;
import iso.sepa.version3.credit.CustomerCreditTransferInitiationV03;
import iso.sepa.version3.credit.FinancialInstitutionIdentification7;
import iso.sepa.version3.credit.GenericAccountIdentification1;
import iso.sepa.version3.credit.GroupHeader32;
import iso.sepa.version3.credit.LocalInstrument2Choice;
import iso.sepa.version3.credit.PartyIdentification32;
import iso.sepa.version3.credit.PaymentIdentification1;
import iso.sepa.version3.credit.PaymentInstructionInformation3;
import iso.sepa.version3.credit.PaymentMethod3Code;
import iso.sepa.version3.credit.PaymentTypeInformation19;
import iso.sepa.version3.credit.RegulatoryReporting3;
import iso.sepa.version3.credit.RemittanceInformation5;
import iso.sepa.version3.credit.ServiceLevel8Choice;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Optional;

public abstract class CreditSchemaMapper
implements PaymentSchemaMapper<CustomerCreditTransferInitiationV03> {
    public CustomerCreditTransferInitiationV03 toSchema(SepaData sepaData) {
        CustomerCreditTransferInitiationV03 noun = new CustomerCreditTransferInitiationV03();
        noun.setGrpHdr(this.mapHeader(sepaData.getHeader()));
        Iterator iter = sepaData.getPaymentInfos().iterator();
        while (iter.hasNext()) {
            noun.getPmtInf().add(this.mapPaymentInformation((PaymentInfoData)iter.next()));
        }
        return noun;
    }

    private GroupHeader32 mapHeader(SepaHeaderData header) {
        GroupHeader32 result = new GroupHeader32();
        result.setCreDtTm(new DateAdapter().getCalendarInYYYYMMDDHHmmSS(header.getCreationDateTime()));
        result.setInitgPty(this.mapInitiatingParty(header.getInitiatingParty()));
        result.setMsgId(header.getMessageID());
        result.setNbOfTxs(Integer.toString(header.getNumberOfTransactions()));
        this.getControlSum(header).ifPresent(arg_0 -> ((GroupHeader32)result).setCtrlSum(arg_0));
        return result;
    }

    private PaymentInstructionInformation3 mapPaymentInformation(PaymentInfoData paymentInfo) {
        PaymentInstructionInformation3 result = new PaymentInstructionInformation3();
        result.setPmtInfId(paymentInfo.getPaymentInfoID());
        result.setPmtMtd(PaymentMethod3Code.TRF);
        result.setReqdExctnDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfo.getRequestedExecutionDate()));
        this.getControlSum(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setCtrlSum(arg_0));
        this.getNumberOfTransactions(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setNbOfTxs(arg_0));
        this.getBtchBookgValue().ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setBtchBookg(arg_0));
        result.setPmtTpInf(this.mapPaymentTypeInformation(paymentInfo));
        result.setDbtr(this.mapDebtor(paymentInfo));
        result.setDbtrAcct(this.getDebtorAccount(paymentInfo));
        this.getDebtorAgent(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setDbtrAgt(arg_0));
        this.getUltimateDebtor(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setUltmtDbtr(arg_0));
        this.getDebtorChargeBearer(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setChrgBr(arg_0));
        this.getChargesAccount(paymentInfo).ifPresent(arg_0 -> ((PaymentInstructionInformation3)result).setChrgsAcct(arg_0));
        for (PaymentData tx : paymentInfo.getPayments()) {
            result.getCdtTrfTxInf().add(this.getTxInfo(tx, paymentInfo));
        }
        return result;
    }

    protected Optional<BigDecimal> getControlSum(SepaHeaderData header) {
        return Optional.of(header.getControlSum());
    }

    protected Optional<BigDecimal> getControlSum(PaymentInfoData paymentInfo) {
        return Optional.of(paymentInfo.getControlSum());
    }

    protected Optional<String> getNumberOfTransactions(PaymentInfoData paymentInfo) {
        return Optional.of(String.valueOf(paymentInfo.getNumberOfTransactions()));
    }

    private Optional<ChargeBearerType1Code> getDebtorChargeBearer(PaymentInfoData paymentInfo) {
        if (XmlPaymentDataUtils.isUnicreditMulticashBGPaymentFormat((PaymentInfoData)paymentInfo)) {
            return Optional.of(ChargeBearerType1Code.SLEV);
        }
        return Optional.empty();
    }

    private Optional<CashAccount16> getChargesAccount(PaymentInfoData paymentInfo) {
        if (this.isSepaChargesIBANSet(paymentInfo)) {
            return Optional.of(this.getCashAccountIBAN(XmlPaymentDataUtils.getChargesIBAN((PaymentInfoData)paymentInfo)));
        }
        return Optional.empty();
    }

    protected boolean isSepaChargesIBANSet(PaymentInfoData paymentInfo) {
        return false;
    }

    private CreditTransferTransactionInformation10 getTxInfo(PaymentData payment, PaymentInfoData paymentInfo) {
        CreditTransferTransactionInformation10 result = new CreditTransferTransactionInformation10();
        result.setPmtId(this.getPaymentIdentification(payment));
        result.setAmt(new AmountMapper().toAmountType3Choice(payment.getAmount(), payment.getCurrencyCode()));
        this.getChargeBearerType(payment, paymentInfo).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setChrgBr(arg_0));
        this.getCreditorAgent(payment).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setCdtrAgt(arg_0));
        result.setCdtrAcct(this.getCreditorAccount(payment));
        result.setCdtr(this.mapCreditor(payment.getPartyData()));
        this.getUltimateCreditor(payment).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setUltmtCdtr(arg_0));
        result.setRmtInf(this.getRemittanceInfo(payment));
        this.mapRegulatoryReporting(payment).ifPresent(result.getRgltryRptg()::add);
        if (this.useIntermediaryAccount()) {
            this.getFinancialInstitutionByBic(payment.getIntermediaryAgentBic1()).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setIntrmyAgt1(arg_0));
            result.setIntrmyAgt1Acct(this.getCashAccountIBAN(payment.getIntermediaryAgentAccount1()));
            this.getFinancialInstitutionByBic(payment.getIntermediaryAgentBic2()).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setIntrmyAgt2(arg_0));
            result.setIntrmyAgt2Acct(this.getCashAccountIBAN(payment.getIntermediaryAgentAccount2()));
            this.getFinancialInstitutionByBic(payment.getIntermediaryAgentBic3()).ifPresent(arg_0 -> ((CreditTransferTransactionInformation10)result).setIntrmyAgt3(arg_0));
            result.setIntrmyAgt3Acct(this.getCashAccountIBAN(payment.getIntermediaryAgentAccount3()));
        }
        return result;
    }

    protected abstract Optional<BranchAndFinancialInstitutionIdentification4> getCreditorAgent(PaymentData var1);

    protected Optional<PartyIdentification32> getUltimateCreditor(PaymentData payment) {
        return Optional.ofNullable(payment.getDeviatingOwner()).filter(owner -> !StringMapper.isNullString((String)owner)).map(owner -> new PartyIdentificationBuilder3(owner).build());
    }

    protected Optional<PartyIdentification32> getUltimateDebtor(PaymentInfoData paymentInfo) {
        return Optional.empty();
    }

    protected Optional<RegulatoryReporting3> mapRegulatoryReporting(PaymentData payment) {
        return Optional.empty();
    }

    private PaymentTypeInformation19 mapPaymentTypeInformation(PaymentInfoData paymentInfo) {
        PaymentTypeInformation19 result = new PaymentTypeInformation19();
        result.setSvcLvl(this.getServiceLevel(paymentInfo));
        this.getLocalInstrument().ifPresent(value -> result.setLclInstrm(value));
        return result;
    }

    protected Optional<LocalInstrument2Choice> getLocalInstrument() {
        return Optional.empty();
    }

    private ServiceLevel8Choice getServiceLevel(PaymentInfoData paymentInfo) {
        ServiceLevel8Choice level = new ServiceLevel8Choice();
        level.setCd(paymentInfo.getServiceLevelType().getCode());
        return level;
    }

    protected CashAccount16 getCreditorAccount(PaymentData payment) {
        if (!StringMapper.isNullString((String)payment.getIban())) {
            return this.getCashAccountIBAN(payment.getIban());
        }
        return this.getCashAccountBBAN(payment.getBankAccountNumber());
    }

    protected CashAccount16 getDebtorAccount(PaymentInfoData paymentInfo) {
        return this.getCashAccountIBAN(paymentInfo.getCompanyIban());
    }

    protected Optional<BranchAndFinancialInstitutionIdentification4> getDebtorAgent(PaymentInfoData paymentInfo) {
        return this.getFinancialInstitutionByBic(paymentInfo.getCompanyBic());
    }

    protected Optional<BranchAndFinancialInstitutionIdentification4> getFinancialInstitutionByBic(String bic) {
        return Optional.ofNullable(bic).filter(b -> !StringMapper.isNullString((String)b)).map(validBic -> {
            FinancialInstitutionIdentification7 instID = new FinancialInstitutionIdentification7();
            instID.setBIC(validBic);
            BranchAndFinancialInstitutionIdentification4 result = new BranchAndFinancialInstitutionIdentification4();
            result.setFinInstnId(instID);
            return result;
        });
    }

    protected CashAccount16 getCashAccountIBAN(String iban) {
        if (StringMapper.isNullString((String)iban)) {
            return null;
        }
        CashAccount16 account = new CashAccount16();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        id.setIBAN(iban);
        account.setId(id);
        return account;
    }

    private CashAccount16 getCashAccountBBAN(String bban) {
        CashAccount16 account = new CashAccount16();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        GenericAccountIdentification1 genericAccountIdentification = new GenericAccountIdentification1();
        AccountSchemeName1Choice accountSchemeName1Choice = new AccountSchemeName1Choice();
        accountSchemeName1Choice.setCd("BBAN");
        genericAccountIdentification.setId(bban);
        genericAccountIdentification.setSchmeNm(accountSchemeName1Choice);
        id.setOthr(genericAccountIdentification);
        account.setId(id);
        return account;
    }

    protected abstract Optional<IsoChargesType> getChargesType(PaymentData var1, PaymentInfoData var2);

    private Optional<ChargeBearerType1Code> getChargeBearerType(PaymentData payment, PaymentInfoData paymentInfo) {
        return this.getChargesType(payment, paymentInfo).map(this::mapToChargeBearerType);
    }

    private ChargeBearerType1Code mapToChargeBearerType(IsoChargesType chargesType) {
        switch (chargesType) {
            case SHAR: {
                return ChargeBearerType1Code.SHAR;
            }
            case DEBT: {
                return ChargeBearerType1Code.DEBT;
            }
            case CRED: {
                return ChargeBearerType1Code.CRED;
            }
            case SLEV: {
                return ChargeBearerType1Code.SLEV;
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)chargesType));
    }

    protected abstract Optional<Boolean> getBtchBookgValue();

    protected abstract PartyIdentification32 mapInitiatingParty(PartyData var1);

    protected abstract PartyIdentification32 mapCreditor(PartyData var1);

    protected abstract PartyIdentification32 mapDebtor(PaymentInfoData var1);

    private RemittanceInformation5 getRemittanceInfo(PaymentData payment) {
        RemittanceInformation5 ri = new RemittanceInformation5();
        ri.getUstrd().add(payment.getUnstructuredRemittanceInfoID());
        return ri;
    }

    private PaymentIdentification1 getPaymentIdentification(PaymentData payment) {
        PaymentIdentification1 result = new PaymentIdentification1();
        result.setEndToEndId(payment.getPaymentEndToEndID());
        this.getPaymentInstrId(payment).ifPresent(instrId -> result.setInstrId(instrId));
        return result;
    }

    protected Optional<String> getPaymentInstrId(PaymentData payment) {
        return !StringMapper.isNullString((String)payment.getPaymentInstrID()) ? Optional.of(payment.getPaymentInstrID()) : Optional.empty();
    }

    protected PartyData getDebtor(PaymentInfoData paymentInfo) {
        return paymentInfo.getPartyData();
    }

    protected abstract boolean useIntermediaryAccount();
}

