/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common;

import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.BatchBookingStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.CashAccountStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.ChargesStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.DebtorStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.InitiatingPartyStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.IntermediaryAccountStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.factory.DebtorAccountCurrencyPresenceFactory;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoCreDtTmStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoPostalAddressPresenceFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CashAccountStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPostalAddressStrategyFactory10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditSchemaMappingContext;

public class CreditSchemaMappingContextFactory {
    public CreditSchemaMappingContext createForeignPaymentContext(IsoPaymentProfile profile) {
        return CreditSchemaMappingContext.builder().setIntermediaryAccountStrategy((IntermediaryAccountStrategy)new IntermediaryAccountStrategy.ForeignPaymentIntermediaryAccountStrategy()).setChargesStrategy((ChargesStrategy)new ChargesStrategy.ForeignPaymentChargesStrategy()).setBatchBookingStrategy((BatchBookingStrategy)new BatchBookingStrategy.ForeignPaymentBatchBookingStrategy()).setCreditorAddressStrategy(new CreditPostalAddressStrategyFactory10().createForForeignPayment(profile)).setCashAccountStrategy(new CashAccountStrategyFactory().createForForeignPayment(profile)).setCreDtTmStrategy(IsoCreDtTmStrategyFactory.createForForeignPayment()).setDebtorAccountCurrencyPresenceStrategy(DebtorAccountCurrencyPresenceFactory.createForForeignPayment(profile)).build();
    }

    public CreditSchemaMappingContext createSepaContext(IsoPaymentProfile profile) {
        return CreditSchemaMappingContext.builder().setIntermediaryAccountStrategy((IntermediaryAccountStrategy)new IntermediaryAccountStrategy.SepaIntermediaryAccountStrategy()).setChargesStrategy((ChargesStrategy)new ChargesStrategy.SepaCreditChargesStrategy(profile)).setBatchBookingStrategy((BatchBookingStrategy)new BatchBookingStrategy.SepaBatchBookingStrategy(profile)).setCreditorAddressStrategy(new CreditPostalAddressStrategyFactory10().createForSepa(profile)).setCashAccountStrategy((CashAccountStrategy)new CashAccountStrategy.CashAccountWithSchemeNameStrategy()).setDebtorStrategy((DebtorStrategy)new DebtorStrategy.SepaDebtorStrategy(profile)).setInitiatingPartyStrategy((InitiatingPartyStrategy)new InitiatingPartyStrategy.SepaInitiatingPartyStrategy(profile)).setCreDtTmStrategy(IsoCreDtTmStrategyFactory.createForSepa(profile)).setDebtorAddressPresenceStrategy(IsoPostalAddressPresenceFactory.createForSepaCreditDebtor(profile)).build();
    }
}

