/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common;

import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPostalAddressBuilder10;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.data.LocationData;
import com.varial.framework.domain.payment.sepa.schema.AddressFormatMode;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressBuilder;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressStrategy;
import iso.sepa.version10.credit.PostalAddress24;
import java.util.Map;
import java.util.function.Function;

public class CreditPostalAddressStrategyFactory10 {
    private static final Function<LocationData, PostalAddressBuilder<PostalAddress24>> BUILDER = CreditPostalAddressBuilder10::new;
    private static final Map<IsoPaymentProfile, AddressFormatMode> FORMAT_MAP = Map.of(IsoPaymentProfile.SEPA_AT, AddressFormatMode.STRUCTURED, IsoPaymentProfile.SEPA_NL, AddressFormatMode.STRUCTURED, IsoPaymentProfile.FOREIGN_DE, AddressFormatMode.HYBRID);

    public PostalAddressStrategy<PostalAddress24> createForSepa(IsoPaymentProfile paymentProfile) {
        return this.create(paymentProfile, AddressFormatMode.UNSTRUCTURED);
    }

    public PostalAddressStrategy<PostalAddress24> createForForeignPayment(IsoPaymentProfile paymentProfile) {
        return this.create(paymentProfile, AddressFormatMode.STRUCTURED);
    }

    private PostalAddressStrategy<PostalAddress24> create(IsoPaymentProfile paymentProfile, AddressFormatMode defaultMode) {
        AddressFormatMode mode = FORMAT_MAP.getOrDefault((Object)paymentProfile, defaultMode);
        return this.toStrategy(mode);
    }

    private PostalAddressStrategy<PostalAddress24> toStrategy(AddressFormatMode mode) {
        switch (mode) {
            case STRUCTURED: {
                return PostalAddressStrategy.structured(BUILDER);
            }
            case UNSTRUCTURED: {
                return PostalAddressStrategy.unstructured(BUILDER);
            }
            case HYBRID: {
                return PostalAddressStrategy.hybrid(BUILDER);
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)mode));
    }
}

