/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.foreign;

import com.varial.accounting.domain.payment.export.xml.schemaversion.CountryServiceProvider;
import com.varial.accounting.domain.payment.export.xml.schemaversion.SchemaType;
import com.varial.accounting.domain.payment.export.xml.schemaversion.SchemaVersion;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.foreign.ForeignPaymentCreditService10;
import com.varial.accounting.domain.payment.iso20022.schema.v3.credit.foreign.ForeignPaymentCreditService3;
import com.varial.framework.domain.payment.sepa.base.SepaService;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import java.util.Date;
import java.util.Optional;
import java.util.function.Function;

public enum IsoForeignSchemaVersion implements CountryServiceProvider
{
    ISO_FOREIGN_V3(Optional.empty(), "2022-11-19", Optional.of("#ISO_FOREIGN_03"), Optional.of(profile -> new ForeignPaymentCreditService3((IsoPaymentProfile)((Object)profile)))),
    ISO_FOREIGN_V10(Optional.of(ISO_FOREIGN_V3), VDate.getDateMaxAsString(), Optional.of("#ISO_FOREIGN_10"), Optional.of(profile -> new ForeignPaymentCreditService10(profile)));

    private final Optional<SchemaVersion> previousVersion;
    private final Date validUntil;
    private final Optional<String> versionByBankAccount;
    private final Optional<Function<IsoPaymentProfile, SepaService>> creditServiceSupplier;

    private IsoForeignSchemaVersion(Optional<SchemaVersion> previousVersion, String validUntil, Optional<String> versionByBankAccount, Optional<Function<IsoPaymentProfile, SepaService>> creditServiceSupplier) {
        this.previousVersion = previousVersion;
        this.validUntil = DateMapper.toDate((String)validUntil);
        this.versionByBankAccount = versionByBankAccount;
        this.creditServiceSupplier = creditServiceSupplier;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public Optional<String> getVersionByBankAccount() {
        return this.versionByBankAccount;
    }

    public SchemaType getSchemaType() {
        return SchemaType.ISO_FOREIGN;
    }

    public Optional<SchemaVersion> getPreviousVersion() {
        return this.previousVersion;
    }

    public Optional<SepaService> getDebitService(IsoPaymentProfile paymentProfile) {
        return Optional.empty();
    }

    public Optional<SepaService> getCreditService(IsoPaymentProfile paymentProfile) {
        return this.creditServiceSupplier.map(supplier -> (SepaService)supplier.apply(paymentProfile));
    }
}

