/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.core.schema;

import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.export.xml.schemaversion.SchemaType;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Map;

public class IsoPaymentProfileFactory {
    private static final Map<String, IsoPaymentProfile> SEPA_MAP = Map.of("LU", IsoPaymentProfile.SEPA_LU, "ES", IsoPaymentProfile.SEPA_ES, "PL", IsoPaymentProfile.SEPA_PL, "FI", IsoPaymentProfile.SEPA_FI, "NL", IsoPaymentProfile.SEPA_NL);
    private static final Map<String, IsoPaymentProfile> FOREIGN_MAP = Map.of("DE", IsoPaymentProfile.FOREIGN_DE);

    private IsoPaymentProfileFactory() {
    }

    public static IsoPaymentProfile getPaymentProfile(FinancePaymentSession session, SchemaType schemaType) {
        String countryIsoCode = session.getIBankAccount().getCountry().getIsoCode();
        return schemaType.isSepa() ? IsoPaymentProfileFactory.forSepa(countryIsoCode) : IsoPaymentProfileFactory.forForeignPayment(countryIsoCode);
    }

    public static IsoPaymentProfile forSepa(String countryIsoCode) {
        if (StringMapper.isNullString((String)countryIsoCode)) {
            return IsoPaymentProfile.SEPA_STANDARD;
        }
        return SEPA_MAP.getOrDefault(countryIsoCode, IsoPaymentProfile.SEPA_STANDARD);
    }

    public static IsoPaymentProfile forForeignPayment(String countryIsoCode) {
        if (StringMapper.isNullString((String)countryIsoCode)) {
            return IsoPaymentProfile.FOREIGN_STANDARD;
        }
        return FOREIGN_MAP.getOrDefault(countryIsoCode, IsoPaymentProfile.FOREIGN_STANDARD);
    }
}

