/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.nominaltransactionbase.VatAmounts;
import com.varial.accounting.domain.openitem.EsrPayment;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.IOpenItemDiscount;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemDiscountManager;
import com.varial.accounting.domain.openitem.OpenItemType;
import com.varial.accounting.domain.openitem.SwissReferenceType;
import com.varial.accounting.domain.openitem.SwissReferenceTypeBuilder;
import com.varial.accounting.domain.payment.CurrencyPaymentTypeCreditNotes;
import com.varial.accounting.domain.payment.CurrencyPaymentTypeOpenItems;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentBankAccountManager;
import com.varial.accounting.domain.payment.GeneratePaymentDataSelector;
import com.varial.accounting.domain.payment.GeneratePaymentErrorlistMapper;
import com.varial.accounting.domain.payment.GeneratePaymentISoftware;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentAssociation;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.PersonalAccountOpenItems;
import com.varial.accounting.domain.payment.SplitAsOfNumberOfItemsManager;
import com.varial.accounting.domain.payment.SplitPayment;
import com.varial.accounting.domain.payment.SplitPaymentCalculator;
import com.varial.accounting.domain.payment.SplitPaymentCalculatorImpl;
import com.varial.accounting.domain.payment.SplitPaymentForeignCurrencyAmounts;
import com.varial.accounting.domain.payment.SplitPaymentHelper;
import com.varial.accounting.domain.payment.SplitPaymentType;
import com.varial.accounting.domain.payment.UrgentPaymentHelper;
import com.varial.accounting.domain.personalaccount.IPersonalAccount;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountAssociation;
import com.varial.accounting.domain.personalaccount.PersonalAccountAssociationPersistencyManager;
import com.varial.accounting.domain.personalaccount.PersonalAccountBankAddressUtils;
import com.varial.accounting.domain.personalaccount.ReverseFactoring;
import com.varial.accounting.domain.personalaccount.Supplier;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.accounting.payment.GeneratePaymentErrorlistStruct;
import com.varial.accounting.payment.GeneratePaymentErrormessageEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ConversionRateMapper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.country.CountryHelper;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.ConversionTable;
import com.varial.framework.domain.currency.ExchangeRatePersistencyManager;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.paymentbase.SepaDirectDebitTypeEnum;
import com.varial.interfaces.IAccountingCompany;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratePaymentManager {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)GeneratePaymentManager.class.getName());
    private final GeneratePaymentBankAccountManager bankAccountManager = new GeneratePaymentBankAccountManager();
    private final SplitPaymentCalculator splitPaymentCalculator = new SplitPaymentCalculatorImpl();
    private final GeneratePaymentSession session;
    private final boolean generatePaymentsWithCreditNotes;
    private final Map<String, OpenItem> ignoredCreditNotesMap;
    private final Map<String, ConversionRate> conversionRateMap = new HashMap<String, ConversionRate>();
    private final Map<String, PaymentAssociation> paymentAssociationMap;
    private final GeneratePaymentISoftware iSoftware;

    public GeneratePaymentManager(GeneratePaymentSession session) {
        this.session = session;
        this.paymentAssociationMap = new HashMap<String, PaymentAssociation>();
        this.ignoredCreditNotesMap = new HashMap<String, OpenItem>();
        this.generatePaymentsWithCreditNotes = session.getCheckBalance() && !session.isCustomerSession() && session.isPayment() && !session.getIsAssociation() && session.getNoDownPaymentRequests();
        this.iSoftware = new GeneratePaymentISoftware(session);
    }

    /*
     * WARNING - void declaration
     */
    public List<GeneratePaymentErrorlistStruct> createGeneratePayments() throws BusinessDomainException {
        void var7_16;
        GeneratePaymentErrormessageEnum error;
        this.session.setNewFilter(true);
        ArrayList<GeneratePaymentErrorlistStruct> errorList = new ArrayList<GeneratePaymentErrorlistStruct>();
        PersonalAccount[] selectedAccounts = this.session.getPersonalAccounts();
        HashMap<String, PersonalAccount> personalAccountCheckList = null;
        if (selectedAccounts != null && selectedAccounts.length > 0) {
            personalAccountCheckList = new HashMap<String, PersonalAccount>();
            for (PersonalAccount personalAccount : selectedAccounts) {
                GeneratePaymentErrormessageEnum err = this.checkAccount(personalAccount);
                if (err == null) {
                    personalAccountCheckList.put(personalAccount.getObjectid(), personalAccount);
                    continue;
                }
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IPersonalAccount)personalAccount, (GeneratePaymentErrormessageEnum)err));
            }
        }
        boolean associationFilter = false;
        HashMap<String, PersonalAccountAssociation> associationCheckList = null;
        if (this.session.getIsAssociation()) {
            PersonalAccountAssociation[] associations = this.session.getPersonalAccountAssociations();
            if (associations != null && associations.length > 0) {
                associationFilter = true;
            } else {
                associations = PersonalAccountAssociationPersistencyManager.getPersonalAccountAssociations((AccountingCompany)this.session.getAccountingCompany());
            }
            if (associations != null) {
                associationCheckList = new HashMap<String, PersonalAccountAssociation>();
                for (PersonalAccountAssociation association : associations) {
                    PaymentAssociation pAssociation = new PaymentAssociation(association, this.session.isCustomerSession());
                    error = this.checkAssociation(pAssociation);
                    if (error == null) {
                        associationCheckList.put(association.getObjectid(), association);
                        this.addToCorporateAccounts(pAssociation);
                        continue;
                    }
                    if (!associationFilter) continue;
                    errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((PersonalAccountAssociation)association, (GeneratePaymentErrormessageEnum)error));
                }
            }
        }
        OpenItem[] selectedOpenItems = this.session.getOpenItems();
        Object var7_14 = null;
        if (selectedOpenItems != null && selectedOpenItems.length > 0) {
            HashMap<String, OpenItem> hashMap = new HashMap<String, OpenItem>();
            for (OpenItem openItem : selectedOpenItems) {
                error = this.checkOpenItem(openItem);
                if (error != null) {
                    errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IOpenItem)openItem, (GeneratePaymentErrormessageEnum)error));
                    continue;
                }
                hashMap.put(openItem.getObjectid(), openItem);
            }
        }
        ArrayList<GeneratePayment> paymentList = new ArrayList<GeneratePayment>();
        Map<String, PersonalAccountOpenItems> openItems = this.getOpenItems(associationCheckList, (Map<String, OpenItem>)var7_16, errorList);
        this.createPayments(paymentList, openItems, personalAccountCheckList, associationCheckList, (Map<String, OpenItem>)var7_16, errorList, false);
        if (this.generatePaymentsWithCreditNotes) {
            Map<String, PersonalAccountOpenItems> personalAccountCreditNotesMap = this.getAllCreditNotes(paymentList, (Map<String, OpenItem>)var7_16, errorList);
            this.createPayments(paymentList, personalAccountCreditNotesMap, personalAccountCheckList, associationCheckList, (Map<String, OpenItem>)var7_16, errorList, true);
        }
        if (personalAccountCheckList != null) {
            for (PersonalAccount pa : personalAccountCheckList.values()) {
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IPersonalAccount)pa, (GeneratePaymentErrormessageEnum)GeneratePaymentErrormessageEnum.GPET_HAS_NO_OPENITEMS));
            }
        }
        if (associationFilter && associationCheckList != null) {
            for (PersonalAccountAssociation ass : associationCheckList.values()) {
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((PersonalAccountAssociation)ass, (GeneratePaymentErrormessageEnum)GeneratePaymentErrormessageEnum.GPET_HAS_NO_OPENITEMS));
            }
        }
        if (var7_16 != null) {
            for (OpenItem openItem : var7_16.values()) {
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IOpenItem)openItem, (GeneratePaymentErrormessageEnum)GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_SELECTION_DOES_NOT_CORRESPOND_TO_OTHER_SELECTED_CRITERIA));
            }
        }
        Payment[] result = paymentList.toArray(new GeneratePayment[0]);
        if (this.session.getIsDirectDebit()) {
            this.checkForBlock((GeneratePayment[])result);
        }
        this.session.setPayments(result);
        return errorList;
    }

    public void createPayments(PersonalAccount personalAccount, PersonalAccountAssociation association, OpenItem[] paOpenItems, OpenItem[] creditNotes, List<GeneratePayment> paymentList, Map<String, PersonalAccount> personalAccountCheckList, Map<String, PersonalAccountAssociation> associationCheckList, Map<String, OpenItem> openItemCheckList, boolean addPaymentManually) throws BusinessDomainException {
        Object key;
        HashMap<String, CurrencyPaymentTypeOpenItems> paymentTypes = new HashMap<String, CurrencyPaymentTypeOpenItems>();
        for (OpenItem openItem : paOpenItems) {
            ModeOfPayment paymentType = this.getPaymentType(this.session, openItem, personalAccount);
            IPersonalAccountBankAddress bankAddress = this.getBankAddress(paymentType, openItem, personalAccount, addPaymentManually);
            EsrPayment esrPayment = null;
            boolean isEsrPayment = this.isEsrPayment(paymentType, openItem);
            if (isEsrPayment) {
                esrPayment = this.getEsrPaymentWithCountry(openItem);
            }
            Date dueDate = null;
            if (this.session.getPaymentPerOpenItem() && creditNotes.length == 0 || isEsrPayment || this.withSwissStructuredReference(paymentType, openItem, bankAddress) || creditNotes.length == 0 && SplitPaymentHelper.isSplitPayment((GeneratePaymentSession)this.session, (PersonalAccount)personalAccount, (OpenItem)openItem, (ICountry)PersonalAccountBankAddressUtils.getBankCountry((IPersonalAccountBankAddress)bankAddress), (ModeOfPayment)paymentType)) {
                key = openItem.getObjectid();
            } else {
                dueDate = this.getDueDate(openItem, paymentType);
                key = this.getOiSplitKey(paymentType, openItem.getEnteredCurrency(), bankAddress, openItem.getPaymentSessionBankAccount(), dueDate);
                if (!this.session.getNoDownPaymentRequests()) {
                    key = (String)key + "/" + StringMapper.toString((String)openItem.getProcessID());
                }
                if (this.session.getFinanceSetup().getCostingForConstructionWork(personalAccount)) {
                    key = (String)key + "/" + PersistentObjectUtils.getObjectidForIDLMapper((IPersistentObject)openItem.getCostUnit());
                }
            }
            CurrencyPaymentTypeOpenItems tmp = (CurrencyPaymentTypeOpenItems)paymentTypes.get(key);
            if (tmp == null) {
                tmp = new CurrencyPaymentTypeOpenItems(openItem.getEnteredCurrency(), paymentType, bankAddress, dueDate, openItem.getPaymentSessionBankAccount(), esrPayment);
                paymentTypes.put((String)key, tmp);
            }
            tmp.add(openItem);
        }
        HashMap<String, CurrencyPaymentTypeCreditNotes> paymentTypesCN = new HashMap<String, CurrencyPaymentTypeCreditNotes>();
        for (OpenItem creditNote : creditNotes) {
            ModeOfPayment paymentType = this.getPaymentType(this.session, creditNote, personalAccount);
            IPersonalAccountBankAddress bankAddress = this.getBankAddress(paymentType, creditNote, personalAccount, addPaymentManually);
            Date dueDate = this.getDueDate(creditNote, paymentType);
            key = this.getOiSplitKey(paymentType, creditNote.getEnteredCurrency(), bankAddress, creditNote.getPaymentSessionBankAccount(), dueDate);
            CurrencyPaymentTypeCreditNotes tmp = (CurrencyPaymentTypeCreditNotes)paymentTypesCN.get(key);
            if (tmp == null) {
                tmp = new CurrencyPaymentTypeCreditNotes();
                paymentTypesCN.put((String)key, tmp);
            }
            tmp.add(creditNote);
        }
        for (CurrencyPaymentTypeOpenItems ptOpenItems : paymentTypes.values()) {
            OpenItem[] paymentCreditNotes;
            GeneratePayment payment = this.createPayment(personalAccount, association, ptOpenItems.getPaymentType(), ptOpenItems.getBankAddress(), ptOpenItems.getForeignCurrency(), ptOpenItems.getPaymentSessionBankAccount(), addPaymentManually, ptOpenItems.getEsrPayment(), ptOpenItems.getDueDate());
            OpenItem[] openItems = ptOpenItems.getOpenItems();
            if (personalAccount.getOneOffAccount()) {
                this.fillAddress(payment, openItems[0]);
            }
            GeneratePaymentRemittance[] invoiceRemittances = new GeneratePaymentRemittance[openItems.length];
            for (int i = 0; i < invoiceRemittances.length; ++i) {
                invoiceRemittances[i] = this.createRemittance(payment, openItems[i]);
            }
            payment.setGeneratePaymentRemittances(invoiceRemittances);
            boolean stop = false;
            CurrencyPaymentTypeCreditNotes ptCN = null;
            if (ptOpenItems.getEsrPayment() != null) {
                paymentCreditNotes = new OpenItem[]{};
            } else {
                String creditNoteKey = this.getOiSplitKey(ptOpenItems.getPaymentType(), ptOpenItems.getForeignCurrency(), ptOpenItems.getBankAddress(), ptOpenItems.getPaymentSessionBankAccount(), ptOpenItems.getDueDate());
                ptCN = (CurrencyPaymentTypeCreditNotes)paymentTypesCN.get(creditNoteKey);
                if (ptCN == null) {
                    paymentCreditNotes = new OpenItem[]{};
                } else {
                    paymentCreditNotes = ptCN.getOpenItems();
                    if (this.generatePaymentsWithCreditNotes) {
                        paymentTypesCN.remove(creditNoteKey);
                    }
                }
            }
            Date ptOisDueDate = ptOpenItems.getDueDate();
            for (int i = 0; i < paymentCreditNotes.length; ++i) {
                Date dueDateCN;
                if (paymentCreditNotes[i] == null) continue;
                if (ptOisDueDate != null) {
                    dueDateCN = ptOisDueDate;
                } else {
                    dueDateCN = paymentCreditNotes[i].getDueDate();
                    if (dueDateCN == null) {
                        dueDateCN = paymentCreditNotes[i].getDocumentDate();
                    }
                }
                if (ptOisDueDate != null && !DateHelper.beforeOrEqual((Date)dueDateCN, (Date)ptOisDueDate)) continue;
                GeneratePaymentRemittance creditNoteRemittance = this.createRemittance(payment, paymentCreditNotes[i]);
                payment.addRemittance(creditNoteRemittance);
                if (openItemCheckList != null) {
                    openItemCheckList.remove(paymentCreditNotes[i].getObjectid());
                }
                if (ptCN != null) {
                    ptCN.remove(paymentCreditNotes[i]);
                }
                paymentCreditNotes[i] = null;
            }
            if (invoiceRemittances.length == 1 && payment.getGeneratePaymentRemittances().length == 1 && this.isSplitPayment(payment, invoiceRemittances[0])) {
                OpenItem openItem = invoiceRemittances[0].getOpenItem();
                VatAmounts splitPaymentVatAmounts = this.splitPaymentCalculator.getSplitPaymentVatAmounts((IOpenItem)openItem, invoiceRemittances[0].getSettlementAmount());
                invoiceRemittances[0].setSplitPaymentBaseVatAmount(splitPaymentVatAmounts.getTaxAmountBC());
                invoiceRemittances[0].setIsSplitPayment(true);
                payment.setIsSplitPayment(true);
                if (SplitPaymentHelper.isForeignCurrencySplitPayment((GeneratePaymentSession)this.session, (IOpenItem)openItem)) {
                    SplitPaymentForeignCurrencyAmounts splitPaymentAmounts = this.splitPaymentCalculator.getSplitPaymentForeignCurrencyAmounts((IOpenItem)openItem, splitPaymentVatAmounts, invoiceRemittances[0].getDiscountPercent());
                    invoiceRemittances[0].setSplitPaymentNetAmount(splitPaymentAmounts.getNetAmount());
                    invoiceRemittances[0].setSplitPaymentNetDiscountAmount(splitPaymentAmounts.getNetDiscountAmount());
                    invoiceRemittances[0].setSplitPaymentBaseVatDiscountAmount(splitPaymentAmounts.getBaseVatDiscountAmount());
                    invoiceRemittances[0].setPaymentAmountType(SplitPaymentType.FOREIGN_CURRENCY.getPaymentAmountType());
                    payment.setSplitPayment(this.createSplitPayment(payment, splitPaymentAmounts.getAmountOfVatPayment()));
                }
            }
            payment.calculatePaymentDetails();
            if (!this.session.getIsForeignPayment() && payment.getTypeOfPayment() == ModeOfPayment.BACS) {
                this.checkLimitBacsTransfer(payment, addPaymentManually);
            }
            if (addPaymentManually) {
                this.bankAccountManager.addGeneratePayment(this.session, payment);
            } else {
                this.validatePayment(payment);
                if (payment.getBankAccount() != null && (payment.isReverseBill() || payment.isBill())) {
                    Date dueDate = this.getDueDateOfBillOfExchange(payment, this.session.getBaseDatePayment());
                    payment.setDueDate(dueDate);
                    payment.setZ5a(false);
                }
            }
            if (payment.hasNoRemittances() || payment.getBankAccount() == null && !this.session.getIsReverseFactoring()) {
                LOGGER.debug("--- dropping payment ---");
                payment.destroy();
                continue;
            }
            LOGGER.debug("--- adding payment ---");
            paymentList.addAll(new SplitAsOfNumberOfItemsManager().split(payment));
            if (personalAccountCheckList != null && !personalAccountCheckList.isEmpty()) {
                personalAccountCheckList.remove(payment.getPersonalAccount().getObjectid());
            }
            if (associationCheckList == null || associationCheckList.isEmpty()) continue;
            associationCheckList.remove(payment.getPersonalAccountAssociation().getObjectid());
        }
        if (this.generatePaymentsWithCreditNotes) {
            for (CurrencyPaymentTypeCreditNotes ptCNOis : paymentTypesCN.values()) {
                this.addToIgnoredCreditNotes(ptCNOis.getOpenItems());
            }
        }
    }

    private Date getDueDate(OpenItem openItem, ModeOfPayment paymentType) {
        if (this.session.getPaymentPerOpenItem()) {
            return null;
        }
        Date dueDate = null;
        if (this.session.getIsDirectDebit() && this.session.isIT()) {
            if (this.isRibaCash(paymentType) || ISoftware.getGroupOpenItemsByDueDateInCollectPaymentsIT()) {
                dueDate = openItem.getDueDate();
            }
        } else if (this.iSoftware.getGeneratePaymentPerDueDate(paymentType)) {
            dueDate = this.calculateDueDate(openItem);
        }
        return dueDate;
    }

    private Date calculateDueDate(OpenItem openItem) {
        Date dueDate = this.getDiscountDueDate(openItem);
        if (dueDate == null) {
            dueDate = openItem.getDueDate();
        }
        if (dueDate == null || DateHelper.before((Date)dueDate, (Date)DateHelper.today())) {
            dueDate = this.session.getExecuteDate();
        }
        return dueDate;
    }

    private Map<String, PersonalAccountOpenItems> getOpenItems(Map<String, PersonalAccountAssociation> associationCheckList, Map<String, OpenItem> openItemCheckList, List<GeneratePaymentErrorlistStruct> errorList) throws BusinessDomainException {
        OpenItem[] openItems = GeneratePaymentDataSelector.getOpenItems((GeneratePaymentSession)this.session, associationCheckList);
        LOGGER.debug("++++++ invoices {}", (Object)openItems.length);
        HashMap<String, PersonalAccountOpenItems> result = new HashMap<String, PersonalAccountOpenItems>();
        for (OpenItem openItem : openItems) {
            PaymentAssociation pAssociation = this.getPaymentAssociation(openItem);
            if (this.session.getIsAssociation() && pAssociation == null) continue;
            PersonalAccount payer = this.getPayer(openItem, pAssociation);
            openItem.setPayer(payer);
            GeneratePaymentErrormessageEnum errorOpenItem = this.keepOpenItem(openItem, true);
            if (errorOpenItem == null) {
                String oidPersonalAccount = payer.getObjectid();
                PersonalAccountOpenItems temp = (PersonalAccountOpenItems)result.get(oidPersonalAccount);
                if (temp == null) {
                    temp = new PersonalAccountOpenItems(payer, pAssociation);
                    result.put(oidPersonalAccount, temp);
                }
                temp.add(openItem);
            } else if (openItemCheckList != null) {
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IOpenItem)openItem, (GeneratePaymentErrormessageEnum)errorOpenItem));
            }
            if (openItemCheckList == null) continue;
            openItemCheckList.remove(openItem.getObjectid());
        }
        return result;
    }

    private Map<String, PersonalAccountOpenItems> getAllCreditNotes(List<GeneratePayment> paymentList, Map<String, OpenItem> openItemCheckList, List<GeneratePaymentErrorlistStruct> errorList) throws BusinessDomainException {
        OpenItem[] allCreditNotes = GeneratePaymentDataSelector.getOpenItems((GeneratePaymentSession)this.session, (boolean)false, (boolean)this.iSoftware.isConsiderAllCreditNotesInCollectPaymentsSession());
        LOGGER.debug("all creditNotes <{}>", (Object)allCreditNotes.length);
        Map<String, String> personalAccountsWithPaymentMap = this.getPersonalAccountsWithPayments(paymentList);
        HashMap<String, PersonalAccountOpenItems> result = new HashMap<String, PersonalAccountOpenItems>();
        for (OpenItem creditNote : allCreditNotes) {
            GeneratePaymentErrormessageEnum error = this.checkCreditNote(creditNote, personalAccountsWithPaymentMap);
            if (error == null) {
                PersonalAccount personalAccount = creditNote.getPersonalAccount();
                String oidPersonalAccount = personalAccount.getObjectid();
                PersonalAccountOpenItems temp = (PersonalAccountOpenItems)result.get(oidPersonalAccount);
                if (temp == null) {
                    temp = new PersonalAccountOpenItems(personalAccount, null);
                    result.put(oidPersonalAccount, temp);
                }
                temp.add(creditNote);
                creditNote.setPayer(personalAccount);
            } else if (openItemCheckList != null) {
                errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IOpenItem)creditNote, (GeneratePaymentErrormessageEnum)error));
            }
            if (openItemCheckList == null) continue;
            openItemCheckList.remove(creditNote.getObjectid());
        }
        return result;
    }

    private Map<String, String> getPersonalAccountsWithPayments(List<GeneratePayment> paymentList) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (GeneratePayment generatePayment : paymentList) {
            CustSupAddress oneOffAddress = null;
            if (generatePayment.getPersonalAccount().getOneOffAccount()) {
                oneOffAddress = generatePayment.getOneOffAddress();
            }
            String mapKey = this.getPersonalAccountKey(generatePayment.getPersonalAccount(), oneOffAddress);
            result.put(mapKey, generatePayment.getPersonalAccount().getObjectid());
        }
        return result;
    }

    private GeneratePaymentErrormessageEnum checkCreditNote(OpenItem creditNote, Map<String, String> personalAccountsWithPaymentMap) throws BusinessDomainException {
        if (this.isIgnoredCreditNote(creditNote)) {
            return null;
        }
        if (personalAccountsWithPaymentMap.get(this.getPersonalAccountKey(creditNote.getPersonalAccount(), creditNote.getOneOffAccountAddress())) != null) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_SELECTION_DOES_NOT_CORRESPOND_TO_OTHER_SELECTED_CRITERIA;
        }
        return this.keepOpenItem(creditNote, false);
    }

    private void createPayments(List<GeneratePayment> paymentList, Map<String, PersonalAccountOpenItems> personalAccountsOpenItems, Map<String, PersonalAccount> personalAccountCheckList, Map<String, PersonalAccountAssociation> associationCheckList, Map<String, OpenItem> openItemCheckList, List<GeneratePaymentErrorlistStruct> errorList, boolean withoutCreditNotes) throws BusinessDomainException {
        Map<String, PersonalAccountOpenItems> personalAccountsCreditNotes = this.getCreditNotes(withoutCreditNotes);
        for (PersonalAccountOpenItems ois : personalAccountsOpenItems.values()) {
            OpenItem[] creditNotes;
            OpenItem[] paOpenItems;
            PersonalAccount pa = ois.getPersonalAccount();
            if (pa.getOneOffAccount()) {
                paOpenItems = ois.getOpenItems();
                Map<String, List<OpenItem>> addressMap = this.groupByAddress(paOpenItems);
                for (List<OpenItem> oiList : addressMap.values()) {
                    OpenItem[] creditNotes2;
                    OpenItem[] adrOpenItems = new OpenItem[oiList.size()];
                    oiList.toArray(adrOpenItems);
                    CustSupAddress address = adrOpenItems[0].getOneOffAccountAddress();
                    if (withoutCreditNotes) {
                        creditNotes2 = new OpenItem[]{};
                    } else {
                        creditNotes2 = this.getCreditNotes(pa, address, personalAccountsCreditNotes);
                        creditNotes2 = this.sortOutCreditNotes(creditNotes2, pa, errorList, openItemCheckList);
                    }
                    this.sortOneOffAccountBankAddresses(adrOpenItems, creditNotes2);
                    this.createPayments(pa, null, adrOpenItems, creditNotes2, paymentList, personalAccountCheckList, associationCheckList, openItemCheckList, false);
                }
                continue;
            }
            paOpenItems = ois.getOpenItems();
            if (withoutCreditNotes) {
                creditNotes = new OpenItem[]{};
            } else {
                creditNotes = this.getCreditNotes(pa, ois.getPaymentAssociation(), personalAccountsCreditNotes);
                creditNotes = this.sortOutCreditNotes(creditNotes, ois.getPayer(), errorList, openItemCheckList);
            }
            this.createPayments(pa, ois.getPersonalAccountAssociation(), paOpenItems, creditNotes, paymentList, personalAccountCheckList, associationCheckList, openItemCheckList, false);
        }
    }

    private OpenItem[] getCreditNotes(PersonalAccount account, PaymentAssociation pAssociation, Map<String, PersonalAccountOpenItems> personalAccountsCreditNotes) {
        PersonalAccount[] personalAccounts = this.getPersonalAccounts(account, pAssociation);
        return this.getCreditNotes(personalAccounts, personalAccountsCreditNotes);
    }

    private PersonalAccount[] getPersonalAccounts(PersonalAccount account, PaymentAssociation pAssociation) {
        PersonalAccount[] result;
        if (pAssociation != null) {
            result = pAssociation.getAccounts();
        } else if (this.session.getWithSubAccounts() && account.getIsParentAccount()) {
            ArrayList<PersonalAccount> tmp = new ArrayList<PersonalAccount>();
            tmp.add(account);
            tmp.addAll(account.getChildAccounts());
            result = new PersonalAccount[tmp.size()];
            tmp.toArray(result);
        } else {
            result = new PersonalAccount[]{account};
        }
        return result;
    }

    private OpenItem[] getCreditNotes(PersonalAccount pa, CustSupAddress oneOffAddress, Map<String, PersonalAccountOpenItems> personalAccountsCreditNotes) {
        OpenItem[] creditNotes = this.getCreditNotes(new PersonalAccount[]{pa}, personalAccountsCreditNotes);
        ArrayList<OpenItem> listCN = new ArrayList<OpenItem>();
        for (OpenItem creditNote : creditNotes) {
            if (creditNote.getOneOffAccountAddress() == null || !StringMapper.equalWithTrim((String)oneOffAddress.getObjectid(), (String)creditNote.getOneOffAccountAddress().getObjectid())) continue;
            listCN.add(creditNote);
        }
        OpenItem[] result = new OpenItem[listCN.size()];
        listCN.toArray(result);
        return result;
    }

    private OpenItem[] getCreditNotes(PersonalAccount[] personalAccounts, Map<String, PersonalAccountOpenItems> personalAccountsCreditNotes) {
        if (personalAccountsCreditNotes == null) {
            return new OpenItem[0];
        }
        ArrayList<OpenItem> creditNotes = new ArrayList<OpenItem>();
        for (PersonalAccount personalAccount : personalAccounts) {
            OpenItem[] ois;
            PersonalAccountOpenItems paOis = personalAccountsCreditNotes.get(personalAccount.getObjectid());
            if (paOis == null) continue;
            for (OpenItem oi : ois = paOis.getOpenItems()) {
                creditNotes.add(oi);
            }
        }
        return creditNotes.toArray(new OpenItem[0]);
    }

    private void validatePayment(GeneratePayment payment) throws BusinessDomainException {
        if (this.session.getMinAmountPayment() != null && this.session.getMinAmountPayment().compareTo(payment.getBaseAmount()) > 0) {
            payment.setPaymentSessionBankAccount(null);
        } else {
            this.bankAccountManager.checkPaymentSessionBankAccount(this.session, payment);
        }
    }

    private Map<String, PersonalAccountOpenItems> getCreditNotes(boolean withoutCreditNotes) throws BusinessDomainException {
        if (withoutCreditNotes) {
            return null;
        }
        OpenItem[] creditNotes = GeneratePaymentDataSelector.getOpenItems((GeneratePaymentSession)this.session, (boolean)false, (boolean)this.iSoftware.isConsiderAllCreditNotesInCollectPaymentsSession());
        HashMap<String, PersonalAccountOpenItems> result = new HashMap<String, PersonalAccountOpenItems>();
        for (OpenItem openItem : creditNotes) {
            PaymentAssociation pAssociation = this.getPaymentAssociation(openItem);
            if (this.session.getIsAssociation() && pAssociation == null) continue;
            PersonalAccount payer = this.getPayer(openItem, pAssociation);
            openItem.setPayer(payer);
            String oidPersonalAccount = payer.getObjectid();
            PersonalAccountOpenItems temp = (PersonalAccountOpenItems)result.get(oidPersonalAccount);
            if (temp == null) {
                temp = new PersonalAccountOpenItems(payer, pAssociation);
                result.put(oidPersonalAccount, temp);
            }
            temp.add(openItem);
        }
        return result;
    }

    private boolean isRibaCash(ModeOfPayment paymentType) {
        return this.session.isIT() && !this.session.getIsDirectDebitAnticipated() && (paymentType == ModeOfPayment.DIRECT_DEBIT || paymentType == ModeOfPayment.DIRECT_DEBIT_ANTICIPATED);
    }

    private GeneratePayment createPayment(PersonalAccount personalAccount, PersonalAccountAssociation association, ModeOfPayment paymentType, IPersonalAccountBankAddress bankAddress, ICurrency currency, PaymentSessionBankAccount paymentSessionBankAccount, boolean addPayment, EsrPayment esrPayment, Date dueDate) throws BusinessDomainException {
        ReverseFactoring reverseFactoring;
        GeneratePayment payment = new GeneratePayment(this.session);
        payment.setPaymentSessionBankAccount(paymentSessionBankAccount);
        payment.setPersonalAccountBankAddress(bankAddress);
        payment.setPersonalAccount(personalAccount);
        payment.setPersonalAccountAssociation(association);
        boolean withSubAccounts = this.session.getWithSubAccounts() && personalAccount.getIsParentAccount();
        payment.setWithSubAccounts(withSubAccounts);
        payment.setDocumentDate(this.session.getBaseDatePayment());
        payment.setSequenceNumber(null);
        payment.setNote(null);
        payment.setAmount(null);
        payment.setBaseAmount(null);
        payment.setForcedPayment(false);
        payment.setDueDate(null);
        payment.setPostalAddress(null);
        payment.setEsrPayment(esrPayment);
        if (paymentType == null) {
            paymentType = esrPayment != null ? ModeOfPayment.BACS : personalAccount.getPaymentType();
        }
        payment.setTypeOfPayment(paymentType);
        payment.setCurrency(currency);
        ConversionRate conversionRate = this.getConversionRate(currency, addPayment);
        payment.setConversionRate(conversionRate);
        payment.setPaymentNote(null);
        payment.setStop(false);
        if (personalAccount.getOneOffAccount()) {
            this.fillPostalAddress(payment, null);
            this.clearBankData(payment);
        } else {
            this.fillPostalAddress(payment);
            if (bankAddress == null) {
                bankAddress = this.getDefaultBankAddress(personalAccount, paymentType, currency, payment.getBankAccount());
            }
            if (bankAddress != null && !payment.isCheque()) {
                IBankData bankData = bankAddress.getBankData();
                IPostalAddress postalAddress = bankData.getPostalAddress();
                if (postalAddress != null && (payment.getTypeOfPayment() == ModeOfPayment.BILL_OF_EXCHANGE || payment.getTypeOfPayment() == ModeOfPayment.BILL_WITHOUT_ACCEPTANCE)) {
                    payment.setPostalAddress(postalAddress);
                }
                this.fillBankAddress(payment, bankAddress);
            } else {
                this.clearBankData(payment);
            }
        }
        if (esrPayment != null) {
            this.clearBankData(payment);
            payment.setBankCountry(esrPayment.getCountry());
        }
        payment.setFactoringSupplier(null);
        payment.setNumberAtFactoringCompany(null);
        if (this.iSoftware.getGeneratePaymentPerDueDate(paymentType)) {
            payment.setExecuteDate(dueDate);
        }
        if (this.session.getIsReverseFactoring() && personalAccount.isSupplier() && (reverseFactoring = ((Supplier)personalAccount).getReverseFactoring()) != null) {
            payment.setFactoringSupplier(reverseFactoring.getFactoringSupplier());
            payment.setNumberAtFactoringCompany(reverseFactoring.getNumberAtFactoringCompany());
        }
        payment.setPurposeCode(this.getPurposeCode(payment.getBankCountry(), payment.getCurrency(), payment.getPersonalAccount()));
        payment.setUrgentPayment(this.getUrgentPayment(paymentType));
        return payment;
    }

    private boolean getUrgentPayment(ModeOfPayment modeOfPayment) {
        return this.session.isUrgentPayment() && UrgentPaymentHelper.isModeOfPaymentAllowed((ModeOfPayment)modeOfPayment);
    }

    private String getPurposeCode(ICountry bankCountry, ICurrency paymentCurrency, PersonalAccount personalAccount) {
        if (this.session.getIsForeignPayment() && this.isAE(bankCountry) && this.isAED(paymentCurrency)) {
            return personalAccount.getPaymentDetailsCode();
        }
        return null;
    }

    private boolean isAE(ICountry bankCountry) {
        return bankCountry != null && StringMapper.equalWithTrim((String)bankCountry.getIsoCode(), (String)"AE");
    }

    private boolean isAED(ICurrency currency) {
        return currency != null && StringMapper.equalWithTrim((String)currency.getCode(), (String)"AED");
    }

    private void clearBankData(GeneratePayment payment) throws BusinessDomainException {
        payment.setBankName(null);
        payment.setBankSortingCode(null, null);
        payment.setBankAccountNumber(null, null);
        payment.setShortAddressOwner(null);
        payment.setSwift(null);
        payment.setPostChequeAccount(null);
        payment.setBIC(null);
        payment.setBankCountry(null);
        payment.setSepaMandate(null);
        payment.setSepaMandateDate(null);
        payment.setSepaDirectDebitType(SepaDirectDebitTypeEnum.SDDTE_COMPANY);
        payment.setIsSepaOneOffDirectDebit(false);
        payment.setSepaLastUsage(null);
        payment.setValidUntil(null);
        payment.setPurposeCode(null);
        payment.setUrgentPayment(false);
    }

    private IPersonalAccountBankAddress getDefaultBankAddress(PersonalAccount personalAccount, ModeOfPayment paymentType, ICurrency currency, BankAccount bankAccount) {
        if (this.session.getIsReverseFactoring()) {
            return null;
        }
        IPersonalAccountBankAddress bankAddress = null;
        if (paymentType == personalAccount.getPaymentType() && (personalAccount.isSupplier() || paymentType == ModeOfPayment.BILL_OF_EXCHANGE || paymentType == ModeOfPayment.BILL_WITHOUT_ACCEPTANCE)) {
            bankAddress = personalAccount.getBankAddress(currency);
            if (bankAddress == null) {
                bankAddress = personalAccount.getDefaultBankAddress();
            }
            if (bankAddress != null) {
                IBankData bankData = bankAddress.getBankData();
                if (bankData != null) {
                    if (bankAccount.getBankData().getCountry().equals(bankData.getCountry())) {
                        if (this.session.getIsForeignPayment()) {
                            bankAddress = null;
                        }
                    } else if (!this.session.getIsForeignPayment()) {
                        bankAddress = null;
                    }
                } else {
                    bankAddress = null;
                }
            }
        }
        return bankAddress;
    }

    private GeneratePaymentRemittance createRemittance(GeneratePayment payment, OpenItem openItem) {
        GeneratePaymentRemittance result = new GeneratePaymentRemittance(payment);
        result.setOpenItem(openItem);
        BigDecimal settlementAmount = openItem.getOpenAmount();
        BigDecimal discountPercent = this.getDiscountPercent(openItem);
        BigDecimal discountAmount = this.getDiscountAmount(openItem, settlementAmount, discountPercent);
        boolean isCreditNote = PaymentHelper.isCreditNote(this.session, openItem);
        if (isCreditNote) {
            settlementAmount = settlementAmount.negate();
            discountAmount = discountAmount.negate();
        }
        result.setSettlementAmount(settlementAmount);
        result.setDiscountAmount(discountAmount);
        result.setDiscountPercent(discountPercent);
        return result;
    }

    private BigDecimal getDiscountPercent(IOpenItem openItem) {
        IOpenItemDiscount discount;
        if (!openItem.isPaymentReceipt() && (discount = OpenItemDiscountManager.getOpenItemDiscount((IOpenItem)openItem, (Date)this.session.getBaseDateSettlementDiscount())) != null) {
            return discount.getPercent();
        }
        return BigDecimalMapper.ZERO;
    }

    private BigDecimal getDiscountAmount(IOpenItem openItem, BigDecimal settlementAmount, BigDecimal discountPercent) {
        return !BigDecimalMapper.isZeroOrNull((BigDecimal)discountPercent) ? this.calculateDiscountAmount(openItem, settlementAmount) : BigDecimalMapper.ZERO;
    }

    private BigDecimal calculateDiscountAmount(IOpenItem openItem, BigDecimal settlementAmount) {
        BigDecimal discountAmount = OpenItemDiscountManager.calculateSettlementDiscount((IOpenItem)openItem, (Date)this.session.getBaseDateSettlementDiscount());
        if (this.session.getRoundPaymentAmount().value() != 0 && !BigDecimalMapper.isZeroOrNull((BigDecimal)discountAmount)) {
            BigDecimal paymentAmount = settlementAmount.subtract(discountAmount);
            BigDecimal paymentAmountAfterRound = this.roundPaymentAmount(paymentAmount);
            BigDecimal diff = paymentAmount.subtract(paymentAmountAfterRound);
            discountAmount = discountAmount.add(diff);
        }
        return discountAmount;
    }

    private BigDecimal roundPaymentAmount(BigDecimal paymentAmount) {
        switch (this.session.getRoundPaymentAmount().value()) {
            case 1: {
                return paymentAmount.setScale(1, RoundingMode.DOWN);
            }
            case 2: {
                return paymentAmount.setScale(0, RoundingMode.DOWN);
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)this.session.getRoundPaymentAmount().value()));
    }

    private void fillAddress(GeneratePayment payment, IOpenItem openItem) throws BusinessDomainException {
        this.fillPostalAddress(payment, openItem);
        IPersonalAccountBankAddress bankAddress = openItem.getPaymentBankAddress();
        if (bankAddress == null) {
            this.clearBankData(payment);
        } else {
            this.fillBankAddress(payment, bankAddress);
            payment.setEsrPayment(null);
        }
    }

    private void fillBankAddress(FinancePayment payment, IPersonalAccountBankAddress bankAddress) throws BusinessDomainException {
        payment.setBankName(bankAddress.getBankData().getBankName());
        payment.setBankSortingCode(bankAddress.getBankData().getBankSortingCode(), null);
        payment.setShortAddressOwner(bankAddress.getBankData().getOtherReference(), false);
        payment.setSwift(bankAddress.getBankData().getSwift());
        payment.setBIC(bankAddress.getBankData().getBIC());
        payment.setBankCountry(bankAddress.getBankData().getCountry());
        payment.setPostChequeAccount(bankAddress.getPostChequeAccount());
        payment.setBankAccountNumber(bankAddress.getAccountNumber(), null);
        payment.setSepaDirectDebitType(SepaDirectDebitTypeEnum.SDDTE_COMPANY);
        payment.setValidUntil(bankAddress.getValidUntil());
        if (payment.isDirectDebit()) {
            payment.setSepaMandate(bankAddress.getSepaMandate());
            payment.setSepaMandateDate(bankAddress.getSepaMandateDate());
            payment.setSepaDirectDebitType(bankAddress.getSepaDirectDebitType());
            payment.setIsSepaOneOffDirectDebit(bankAddress.getOneOffDirectDebit());
            payment.setSepaLastUsage(bankAddress.getSepaLastUsage());
        }
    }

    private void fillPostalAddress(GeneratePayment payment) {
        PostalAddress paymentAddress = null;
        PersonalAccount pa = payment.getPersonalAccount();
        if (payment.isCheque() && pa.getDeviatingAddress() != null) {
            paymentAddress = pa.getDeviatingAddress().getPostalAddress();
        } else if (pa.getAddress() != null) {
            paymentAddress = pa.getAddress().getPostalAddress();
        }
        payment.setPostalAddress((IPostalAddress)paymentAddress);
    }

    private void fillPostalAddress(GeneratePayment payment, IOpenItem openItem) {
        if (openItem != null && openItem.getOneOffAccountAddress() != null) {
            payment.setPostalAddress(openItem.getOneOffAccountAddress().getPostalAddress());
        } else {
            payment.setPostalAddress((IPostalAddress)new PostalAddress(null, null, null, null, null, null, null, null));
        }
    }

    private IPersonalAccountBankAddress getBankAddress(ModeOfPayment paymentType, OpenItem openItem, PersonalAccount pa, boolean addPayment) {
        if (this.isEsrPayment(paymentType, openItem) || this.session.getIsReverseFactoring()) {
            return null;
        }
        if (this.withSwissStructuredReference(paymentType, openItem, openItem.getBankAddress())) {
            IPersonalAccountBankAddress openItemBankAddress = openItem.getBankAddress();
            openItem.setPaymentBankAddress(openItemBankAddress);
            return openItemBankAddress;
        }
        IPersonalAccountBankAddress bankAddress = null;
        if (pa.getOneOffAccount()) {
            if (addPayment) {
                bankAddress = openItem.getBankAddress();
                openItem.setPaymentBankAddress(bankAddress);
            } else {
                bankAddress = openItem.getPaymentBankAddress();
            }
        } else {
            if (paymentType == ModeOfPayment.BACS || paymentType == ModeOfPayment.BANK_COLLECTION || paymentType == ModeOfPayment.DIRECT_DEBIT || paymentType == ModeOfPayment.BILL_OF_EXCHANGE || paymentType == ModeOfPayment.BILL_WITHOUT_ACCEPTANCE || paymentType == ModeOfPayment.BACS_CHECK || paymentType == ModeOfPayment.DIRECT_DEBIT_ANTICIPATED || paymentType == ModeOfPayment.BACS_BILL_OF_EXCHANGE) {
                bankAddress = openItem.getBankAddress();
                if (this.iSoftware.getAssignmentAccordingToOriginalCurrency() || this.session.getWithSubAccounts() && pa.getIsParentAccount() || paymentType == ModeOfPayment.BANK_COLLECTION && this.iSoftware.isConsiderAllCreditNotesInCollectPaymentsSession()) {
                    bankAddress = null;
                }
                if (bankAddress == null && (bankAddress = pa.getBankAddress(openItem.getEnteredCurrency())) == null) {
                    bankAddress = pa.getDefaultBankAddress();
                }
            }
            openItem.setPaymentBankAddress(bankAddress);
        }
        return bankAddress;
    }

    private ICountry getCountryForEsrPayment(OpenItem openItem) throws BusinessDomainException {
        ICountry country = this.session.getAccountingCompany().getCountry();
        if (CountryHelper.isCH((ICountry)country)) {
            return country;
        }
        PersonalAccount personalAccount = openItem.getPersonalAccount();
        CustSupAddress persAccAddress = personalAccount.getOneOffAccount() ? openItem.getCustSupAddress() : personalAccount.getAddress();
        if (persAccAddress != null && persAccAddress.getPostalAddress() != null) {
            country = persAccAddress.getPostalAddress().getCountry();
        }
        if (CountryHelper.isCH((ICountry)country)) {
            return country;
        }
        IPersonalAccountBankAddress bankAddress = personalAccount.getDefaultBankAddress();
        if (bankAddress != null && bankAddress.getBankData() != null) {
            country = bankAddress.getBankData().getCountry();
        }
        if (country == null) {
            country = this.session.getAccountingCompany().getCountry();
        }
        return country;
    }

    private ICountry getPersonalAccountCountry(PersonalAccount payer, ModeOfPayment paymentType, IPersonalAccountBankAddress bankAddress, OpenItem openItem) throws BusinessDomainException {
        if (this.isEsrPayment(paymentType, openItem)) {
            return this.getCountryForEsrPayment(openItem);
        }
        ICountry result = null;
        if (bankAddress != null && bankAddress.getBankData() != null) {
            result = bankAddress.getBankData().getCountry();
        }
        if (result == null && (paymentType == ModeOfPayment.CHECK || paymentType == ModeOfPayment.CHECK_BILL_OF_EXCHANGE) && payer.getDeviatingAddress() != null && payer.getDeviatingAddress().getPostalAddress() != null) {
            result = payer.getDeviatingAddress().getPostalAddress().getCountry();
        }
        if (result == null) {
            CustSupAddress address = payer.getOneOffAccount() ? openItem.getOneOffAccountAddress() : payer.getAddress();
            result = address.getPostalAddress().getCountry();
        }
        return result;
    }

    private String getOiSplitKey(ModeOfPayment paymentType, ICurrency foreignCurrency, IPersonalAccountBankAddress bankAddress, PaymentSessionBankAccount paymentSessionBankAccount, Date dueDate) {
        int sortNo = 0;
        if (paymentSessionBankAccount != null) {
            sortNo = paymentSessionBankAccount.getSortNo();
        }
        return foreignCurrency.getObjectid() + "/" + PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)paymentType) + "/" + PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bankAddress) + "/" + sortNo + "/" + DateMapper.toString((Date)dueDate);
    }

    private boolean isEsrPayment(ModeOfPayment paymentType, OpenItem openItem) {
        return openItem.getEsrPayment() != null && !this.session.getIsForeignPayment() && paymentType == ModeOfPayment.BACS && openItem.getPersonalAccount().isSupplier() && openItem.getPersonalAccountEntry() != null && openItem.getOpenItemType() == OpenItemType.INVOICE;
    }

    private void checkLimitBacsTransfer(GeneratePayment payment, boolean addPayment) throws BusinessDomainException {
        if (this.session.getShiftAmountForCheque() != null && payment.getPersonalAccount().getPaymentType() == ModeOfPayment.BACS_CHECK && payment.getTypeOfPayment() == ModeOfPayment.BACS && payment.getBaseAmount().compareTo(this.session.getShiftAmountForCheque()) >= 0) {
            payment.setTypeOfPayment(ModeOfPayment.CHECK);
            if (payment.getPersonalAccount().getOneOffAccount()) {
                GeneratePaymentRemittance[] s = payment.getGeneratePaymentRemittances();
                OpenItem oi = null;
                if (s != null && s.length > 0) {
                    oi = s[0].getOpenItem();
                }
                this.fillPostalAddress(payment, oi);
            } else {
                this.fillPostalAddress(payment);
            }
            payment.setEsrPayment(null);
            this.clearBankData(payment);
            if (!addPayment && !this.bankAccountManager.isValidBankAccount(payment.getPaymentSessionBankAccount(), this.session, payment)) {
                payment.setPaymentSessionBankAccount(null);
            }
        }
    }

    private ModeOfPayment getPaymentType(GeneratePaymentSession session, OpenItem openItem, PersonalAccount pa) {
        ModeOfPayment paymentType = null;
        paymentType = session.getIsAssociation() || session.getWithSubAccounts() && pa.getIsParentAccount() ? pa.getPaymentType() : openItem.getPaymentType();
        if (paymentType == null) {
            paymentType = ModeOfPayment.UNKNOWN;
        }
        switch (session.getGeneratePaymentFormType().value()) {
            case 5: {
                paymentType = ModeOfPayment.REVERSE_FACTORING;
                break;
            }
            case 0: {
                if (paymentType == ModeOfPayment.UNKNOWN) {
                    paymentType = pa.getPaymentType();
                }
                if (session.getIsForeignPayment()) {
                    if (paymentType == ModeOfPayment.BACS || paymentType == ModeOfPayment.CHECK || paymentType == ModeOfPayment.BACS_BILL_OF_EXCHANGE || paymentType == ModeOfPayment.CHECK_BILL_OF_EXCHANGE) break;
                    paymentType = ModeOfPayment.UNKNOWN;
                    break;
                }
                if (paymentType != ModeOfPayment.BACS && paymentType != ModeOfPayment.CHECK && paymentType != ModeOfPayment.BACS_CHECK && paymentType != ModeOfPayment.BACS_BILL_OF_EXCHANGE && paymentType != ModeOfPayment.CHECK_BILL_OF_EXCHANGE) {
                    paymentType = ModeOfPayment.UNKNOWN;
                }
                if (paymentType != ModeOfPayment.BACS_CHECK) break;
                paymentType = ModeOfPayment.BACS;
                break;
            }
            case 2: {
                paymentType = pa.getPaymentType();
                if (paymentType == ModeOfPayment.BANK_COLLECTION || paymentType == ModeOfPayment.DIRECT_DEBIT || paymentType == ModeOfPayment.DIRECT_DEBIT_ANTICIPATED) {
                    paymentType = ModeOfPayment.BACS;
                }
                if (paymentType != ModeOfPayment.BACS && paymentType != ModeOfPayment.CHECK) {
                    paymentType = ModeOfPayment.UNKNOWN;
                }
                if (paymentType != ModeOfPayment.UNKNOWN) break;
                IPersonalAccountBankAddress bankAddress = pa.getBankAddress(openItem.getEnteredCurrency());
                if (bankAddress == null) {
                    bankAddress = pa.getDefaultBankAddress();
                }
                if (bankAddress != null) {
                    paymentType = ModeOfPayment.BACS;
                    break;
                }
                paymentType = ModeOfPayment.CHECK;
                break;
            }
            case 1: {
                if (paymentType == ModeOfPayment.UNKNOWN) {
                    paymentType = pa.getPaymentType();
                }
                if (paymentType != ModeOfPayment.BANK_COLLECTION && paymentType != ModeOfPayment.DIRECT_DEBIT && paymentType != ModeOfPayment.DIRECT_DEBIT_ANTICIPATED) {
                    paymentType = PaymentHelper.isCreditNote(session, openItem) && pa.getPaymentType() == ModeOfPayment.BANK_COLLECTION && this.iSoftware.isConsiderAllCreditNotesInCollectPaymentsSession() ? ModeOfPayment.BANK_COLLECTION : ModeOfPayment.UNKNOWN;
                }
                if (paymentType != ModeOfPayment.DIRECT_DEBIT_ANTICIPATED) break;
                paymentType = ModeOfPayment.DIRECT_DEBIT;
                break;
            }
            case 3: 
            case 4: {
                if (paymentType == ModeOfPayment.BILL_OF_EXCHANGE || paymentType == ModeOfPayment.BILL_WITHOUT_ACCEPTANCE) break;
                paymentType = ModeOfPayment.BILL_OF_EXCHANGE;
                break;
            }
        }
        return paymentType;
    }

    private PaymentSessionBankAccount getValidBankAccount(OpenItem openItem) throws BusinessDomainException {
        PersonalAccount payer = openItem.getPayer();
        ModeOfPayment paymentType = this.getPaymentType(this.session, openItem, payer);
        IPersonalAccountBankAddress bankAddress = this.getBankAddress(paymentType, openItem, payer, true);
        ICountry openItemCountry = this.getPersonalAccountCountry(payer, paymentType, bankAddress, openItem);
        ICurrency openItemCurrency = openItem.getEnteredCurrency();
        PaymentSessionBankAccount result = null;
        PaymentSessionBankAccount[] sessionBankAccounts = this.session.getPaymentSessionBankAccounts();
        for (int i = 0; i < sessionBankAccounts.length; ++i) {
            if (sessionBankAccounts[i].isSplitPayment() || !this.bankAccountManager.isValidBankAccount(sessionBankAccounts[i], openItemCurrency, openItemCountry, this.session, paymentType)) continue;
            result = sessionBankAccounts[i];
            break;
        }
        return result;
    }

    private GeneratePaymentErrormessageEnum checkOpenItem(OpenItem openItem) {
        if (this.session.getNoDownPaymentRequests() && openItem.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_IS_A_DOWN_PAYMENT_REQUEST;
        }
        if (!this.session.getNoDownPaymentRequests() && openItem.getOpenItemType() != OpenItemType.DOWN_PAYMENT_REQUEST) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_IS_NOT_A_DOWN_PAYMENT_REQUEST;
        }
        if (openItem.getInProcessing()) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_IS_IN_PROGRESS;
        }
        if (openItem.getPurchaseInvoiceRegisterStatus() == PurchaseInvoiceRegisterStatus.POSTED_WITHOUT_VERIFICATION && this.session.getFinanceSetup().getBlockPurchaseRegisterInvoices()) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_POSTED_WHITOUT_VERIFICATION_IS_BLOCKED;
        }
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)openItem.getOpenAmount())) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_IS_BALANCED;
        }
        return null;
    }

    private GeneratePaymentErrormessageEnum keepOpenItem(OpenItem openItem, boolean isInvoice) throws BusinessDomainException {
        if (this.session.getFinanceSetup().getBlockPurchaseRegisterInvoices() && openItem.getPurchaseInvoiceRegisterStatus() == PurchaseInvoiceRegisterStatus.POSTED_WITHOUT_VERIFICATION) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_POSTED_WHITOUT_VERIFICATION_IS_BLOCKED;
        }
        PersonalAccount payer = openItem.getPayer();
        GeneratePaymentErrormessageEnum checkPayer = this.checkAccount(payer);
        if (checkPayer != null) {
            return checkPayer;
        }
        boolean checkSelectedCriteria = this.checkSelectedCriteria(openItem, isInvoice);
        if (!checkSelectedCriteria) {
            return GeneratePaymentErrormessageEnum.GPET_OPEN_ITEM_SELECTION_DOES_NOT_CORRESPOND_TO_OTHER_SELECTED_CRITERIA;
        }
        if (!this.session.getIsReverseFactoring()) {
            PaymentSessionBankAccount paymentSessionBankAccount = this.getValidBankAccount(openItem);
            if (paymentSessionBankAccount == null) {
                return GeneratePaymentErrormessageEnum.GPET_NO_MATCHING_BANK_ACCOUNT_FOUND;
            }
            openItem.setPaymentSessionBankAccount(paymentSessionBankAccount);
        }
        return null;
    }

    private boolean checkSelectedCriteria(OpenItem openItem, boolean isInvoice) {
        if (this.session.getIgnorePayments() && !isInvoice && openItem.isPaymentReceipt()) {
            return false;
        }
        PersonalAccount payer = openItem.getPayer();
        if (this.session.getIsDirectDebit() && openItem.getPaymentType() == ModeOfPayment.UNKNOWN && payer.getPaymentType() != ModeOfPayment.DIRECT_DEBIT && payer.getPaymentType() != ModeOfPayment.BANK_COLLECTION) {
            return false;
        }
        if (this.session.getIsAssociation() && openItem.getBankAddress() != null) {
            if (!openItem.getPersonalAccount().equals((Object)payer)) {
                return false;
            }
            IPersonalAccountBankAddress defaultBankAddress = payer.getDefaultBankAddress();
            if (defaultBankAddress == null || !defaultBankAddress.equals(openItem.getBankAddress())) {
                return false;
            }
        }
        if (isInvoice && this.session.getForcedPayments() && !openItem.getForcedPayment()) {
            return false;
        }
        BigDecimal percentDiscount = this.getDiscountPercent(openItem);
        if (isInvoice) {
            if (this.session.getInvoicesOverdue() && !this.isInvoiceOverdue(openItem, isInvoice) && (!this.session.getInvoicesDueWithDiscount() || this.session.getInvoicesDueWithDiscount() && !this.isInvoiceWithDiscount(percentDiscount, isInvoice))) {
                return false;
            }
            if (this.session.getInvoicesDueWithDiscount() && !this.isInvoiceWithDiscount(percentDiscount, isInvoice) && (!this.session.getInvoicesOverdue() || this.session.getInvoicesOverdue() && !this.isInvoiceOverdue(openItem, isInvoice))) {
                return false;
            }
        }
        if (!this.checkDueDate(openItem, isInvoice, percentDiscount)) {
            return false;
        }
        return !this.session.getIsReverseFactoring() || openItem.getEnteredCurrency().equals(this.session.getFinanceSetup().getBaseCurrency());
    }

    private Date getDiscountDueDate(OpenItem openItem) {
        IOpenItemDiscount openItemDiscount = OpenItemDiscountManager.getOpenItemDiscount((IOpenItem)openItem, (Date)this.session.getBaseDateSettlementDiscount());
        return openItemDiscount != null ? openItemDiscount.getDueDate() : null;
    }

    private boolean checkDueDate(OpenItem openItem, boolean isInvoice, BigDecimal percentDiscount) {
        Date dueDate = openItem.getDueDate();
        if (isInvoice || !this.session.getCreditNotesDueImmediately()) {
            if (this.session.getNextDatePayment() != null) {
                if (!BigDecimalMapper.isZero((BigDecimal)percentDiscount)) {
                    BigDecimal percentNext = OpenItemDiscountManager.getPercentDiscount((IOpenItem)openItem, (Date)this.session.getNextDatePayment());
                    if (percentDiscount.compareTo(percentNext) <= 0) {
                        LOGGER.debug("---openitem skipped due to discount {}/{} ---", (Object)openItem.getObjectid(), (Object)openItem.getReferenceNumber());
                        return false;
                    }
                } else if (dueDate != null && DateHelper.beforeOrEqual((Date)this.session.getNextDatePayment(), (Date)dueDate)) {
                    LOGGER.debug("---openitem skipped due to not due {}/{} ---", (Object)openItem.getObjectid(), (Object)openItem.getReferenceNumber());
                    return false;
                }
            }
            if (dueDate != null && (this.session.getDueFromDate() != null || this.session.getDueToDate() != null) && (this.session.getDueFromDate() != null && DateHelper.before((Date)dueDate, (Date)this.session.getDueFromDate()) || this.session.getDueToDate() != null && DateHelper.after((Date)dueDate, (Date)this.session.getDueToDate()))) {
                return false;
            }
        }
        return true;
    }

    private boolean isInvoiceOverdue(OpenItem openItem, boolean isInvoice) {
        return isInvoice && openItem.getDueDate() != null && DateHelper.before((Date)openItem.getDueDate(), (Date)this.session.getBaseDatePayment());
    }

    private boolean isInvoiceWithDiscount(BigDecimal percentDiscount, boolean isInvoice) {
        return isInvoice && !BigDecimalMapper.isZero((BigDecimal)percentDiscount);
    }

    private OpenItem[] sortOutCreditNotes(OpenItem[] creditNotes, PersonalAccount personalAccount, List<GeneratePaymentErrorlistStruct> errorList, Map<String, OpenItem> openItemCheckList) throws BusinessDomainException {
        if (creditNotes == null || creditNotes.length == 0) {
            return creditNotes;
        }
        ArrayList<OpenItem> creditNoteList = new ArrayList<OpenItem>();
        for (OpenItem creditNote : creditNotes) {
            creditNote.setPayer(personalAccount);
            GeneratePaymentErrormessageEnum error = this.keepOpenItem(creditNote, false);
            if (error == null) {
                creditNoteList.add(creditNote);
                continue;
            }
            if (openItemCheckList == null) continue;
            errorList.add(GeneratePaymentErrorlistMapper.toErrorStruct((IOpenItem)creditNote, (GeneratePaymentErrormessageEnum)error));
            openItemCheckList.remove(creditNote.getObjectid());
        }
        if (creditNoteList.size() == creditNotes.length) {
            return creditNotes;
        }
        OpenItem[] result = new OpenItem[creditNoteList.size()];
        creditNoteList.toArray(result);
        return result;
    }

    private Date getDueDateOfBillOfExchange(GeneratePayment payment, Date baseDatePayment) throws BusinessDomainException {
        Date dueDate = null;
        GeneratePaymentRemittance[] s = payment.getGeneratePaymentRemittances();
        if (s != null && s.length > 0) {
            if (s.length == 1) {
                OpenItem oi = s[0].getOpenItem();
                dueDate = oi.getDueDate();
            } else {
                ITermOfPayment term = payment.getPersonalAccount().getTermOfPaymentForBillOfExchange();
                if (term != null) {
                    dueDate = payment.getPersonalAccount().getDueDate(term, baseDatePayment);
                } else {
                    for (int i = 0; i < s.length; ++i) {
                        OpenItem oi = s[i].getOpenItem();
                        if (s[i].isCreditNote() || dueDate != null && (oi.getDueDate() == null || !DateHelper.after((Date)oi.getDueDate(), (Date)dueDate))) continue;
                        dueDate = oi.getDueDate();
                    }
                }
            }
        }
        return dueDate;
    }

    private String getPersonalAccountKey(PersonalAccount account, CustSupAddress oneOffAddress) {
        String key = oneOffAddress != null ? account.getObjectid() + "/" + oneOffAddress.getObjectid() : account.getObjectid() + "/";
        return key;
    }

    private void checkForBlock(GeneratePayment[] payments) {
        for (GeneratePayment payment : payments) {
            GeneratePaymentRemittance[] remittances = payment.getGeneratePaymentRemittances();
            boolean mustBlock = false;
            for (int i = 0; i < remittances.length && !mustBlock; ++i) {
                if (!remittances[i].isCreditNote()) continue;
                OpenItem openItem = remittances[i].getOpenItem();
                OpenItemType openItemType = openItem.getOpenItemType();
                if (openItemType == OpenItemType.RECEIPT || openItemType == OpenItemType.REPOSTED_RECEIPT) {
                    if (this.iSoftware.getDoNotSetAutomaticBlock()) continue;
                    mustBlock = true;
                    continue;
                }
                ModeOfPayment paymentType = openItem.getPaymentType();
                mustBlock = paymentType != ModeOfPayment.DIRECT_DEBIT && paymentType != ModeOfPayment.BANK_COLLECTION && paymentType != ModeOfPayment.VIA_GROUP_ACCOUNTS && paymentType != ModeOfPayment.DIRECT_DEBIT_ANTICIPATED && !this.iSoftware.isConsiderAllCreditNotesInCollectPaymentsSession();
            }
            if (!mustBlock) continue;
            payment.setStop(true);
        }
    }

    private Map<String, List<OpenItem>> groupByAddress(OpenItem[] paOpenItems) {
        HashMap<String, List<OpenItem>> addressMap = new HashMap<String, List<OpenItem>>();
        for (OpenItem openItem : paOpenItems) {
            CustSupAddress address = openItem.getOneOffAccountAddress();
            ArrayList<OpenItem> addressList = (ArrayList<OpenItem>)addressMap.get(address.getObjectid());
            if (addressList == null) {
                addressList = new ArrayList<OpenItem>();
                addressMap.put(address.getObjectid(), addressList);
            }
            addressList.add(openItem);
        }
        return addressMap;
    }

    private GeneratePaymentErrormessageEnum checkAccount(PersonalAccount personalAccount) {
        if (this.session.isCustomerSession() && !personalAccount.isCustomer()) {
            return GeneratePaymentErrormessageEnum.GPET_THIS_IS_NOT_A_CUSTOMER;
        }
        if (!this.session.isCustomerSession() && !personalAccount.isSupplier()) {
            return GeneratePaymentErrormessageEnum.GPET_THIS_IS_NOT_A_SUPPLIER;
        }
        if (this.session.getWithSubAccounts() && personalAccount.getIsChildAccount()) {
            return GeneratePaymentErrormessageEnum.GPET_IT_IS_A_SUBACCOUNT;
        }
        if (personalAccount.getWithhold() && !this.session.getIsCustomerRepayment()) {
            if (personalAccount.isCustomer()) {
                return GeneratePaymentErrormessageEnum.GPET_CUSTOMER_BLOCKED;
            }
            return GeneratePaymentErrormessageEnum.GPET_SUPPLIER_BLOCKED;
        }
        if (this.session.getIsCustomerRepayment() && this.session.getCheckBalance() && personalAccount.isCustomer() && !this.isBalanceNegative(personalAccount)) {
            return GeneratePaymentErrormessageEnum.GPET_HAS_POSITIVE_BALANCE;
        }
        if (personalAccount.isDateInPeriodFreeFromPayments(this.session.getBaseDatePayment())) {
            return GeneratePaymentErrormessageEnum.GPET_BASEDATEPAYMENT_NOT_IN_FREEPERIOD;
        }
        return null;
    }

    private GeneratePaymentErrormessageEnum checkAssociation(PaymentAssociation pAssociation) {
        PersonalAccount payer = pAssociation.getPayer();
        if (payer == null) {
            return GeneratePaymentErrormessageEnum.GPET_ASSOCIATION_HAS_NO_HEADOFFICE;
        }
        if (!payer.getAccountingCompany().equals((Object)this.session.getAccountingCompany())) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_NOT_IN_COMPANY;
        }
        if (payer.isCustomer() && !this.session.isCustomerSession()) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_NO_SUPPLIER;
        }
        if (payer.isSupplier() && this.session.isCustomerSession()) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_NO_CUSTOMER;
        }
        if (payer.getWithhold() && !this.session.getIsCustomerRepayment()) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_BLOCKED;
        }
        if (payer.isDateInPeriodFreeFromPayments(this.session.getBaseDatePayment())) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_FREE_FROM_PAYMENTS;
        }
        if (this.paymentAssociationMap.get(payer.getObjectid()) != null) {
            return GeneratePaymentErrormessageEnum.GPET_HEADOFFICE_ALREADY_IN_ANOTHER_ASSOCIATION;
        }
        return null;
    }

    private ConversionRate getConversionRate(ICurrency currency, boolean addPayment) throws BusinessDomainException {
        ConversionRate result = null;
        if (!this.session.getIsReverseFactoring()) {
            if (currency.equals(this.session.getFinanceSetup().getBaseCurrency())) {
                result = ConversionRateMapper.ONE;
            } else {
                if (addPayment) {
                    GeneratePayment[] payments = this.session.getGeneratePayments();
                    for (int i = 0; i < payments.length; ++i) {
                        if (payments[i].getPersonalAccount().getNegotiatedExchangeRate() || !currency.equals(payments[i].getCurrency())) continue;
                        result = payments[i].getConversionRate();
                        break;
                    }
                }
                if (result == null) {
                    result = this.getConversionRate(currency);
                }
            }
        }
        return result;
    }

    private boolean isBalanceNegative(PersonalAccount personalAccount) {
        BigDecimal result;
        try {
            result = personalAccount.getBaseBalance(this.session.getFinancialYear(), this.session.getFinanceSetup().getBaseCurrency());
        }
        catch (BusinessDomainException de) {
            result = null;
        }
        return result != null && result.signum() < 0;
    }

    private void sortOneOffAccountBankAddresses(OpenItem[] openItems, OpenItem[] creditNotes) {
        HashMap<String, IPersonalAccountBankAddress> bankAddressMap = new HashMap<String, IPersonalAccountBankAddress>();
        this.sortOneOffAccountBankAddresses(openItems, bankAddressMap);
        this.sortOneOffAccountBankAddresses(creditNotes, bankAddressMap);
    }

    private void sortOneOffAccountBankAddresses(OpenItem[] openItems, Map<String, IPersonalAccountBankAddress> bankAddressMap) {
        if (openItems == null || openItems.length == 0) {
            return;
        }
        for (OpenItem openItem : openItems) {
            IPersonalAccountBankAddress openItemBankAddress = openItem.getBankAddress();
            if (openItemBankAddress == null) continue;
            String key = this.getOneOffAccountBankAddressKey(openItemBankAddress);
            IPersonalAccountBankAddress bankAddress = bankAddressMap.get(key);
            if (bankAddress == null) {
                bankAddress = openItemBankAddress;
                bankAddressMap.put(key, openItemBankAddress);
            }
            openItem.setPaymentBankAddress(bankAddress);
        }
    }

    private String getOneOffAccountBankAddressKey(IPersonalAccountBankAddress bankAddress) {
        String oidBankCountry = "";
        if (bankAddress.getBankData().getCountry() != null) {
            oidBankCountry = bankAddress.getBankData().getCountry().getObjectid();
        }
        String result = oidBankCountry + "/" + StringMapper.toStringWithTrim((String)bankAddress.getBankData().getBankSortingCode()) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getAccountNumber()) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getBankData().getSwift()) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getBankData().getOtherReference()) + "/" + StringMapper.toStringWithTrim((String)StringMapper.toUpperCase((String)bankAddress.getBankData().getBankName())) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getDeviatingOwner()) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getSepaMandate()) + "/" + DateMapper.toString((Date)bankAddress.getSepaMandateDate()) + "/" + BooleanMapper.toString((boolean)bankAddress.getBasicDirectDebit()) + "/" + BooleanMapper.toString((boolean)bankAddress.getOneOffDirectDebit()) + "/" + StringMapper.toStringWithTrim((String)bankAddress.getCreditorIdentifier()) + "/" + StringMapper.toString((String)bankAddress.getBankData().getPcCode());
        return result;
    }

    private PersonalAccount getPayer(OpenItem openItem, PaymentAssociation pAssociation) {
        PersonalAccount personalAccount;
        if (pAssociation != null) {
            personalAccount = pAssociation.getPayer();
        } else {
            personalAccount = openItem.getPersonalAccount();
            if (this.session.getWithSubAccounts() && personalAccount.getIsChildAccount()) {
                personalAccount = personalAccount.getParentAccount();
            }
        }
        return personalAccount;
    }

    private PaymentAssociation getPaymentAssociation(OpenItem openItem) {
        PaymentAssociation pAssociation = null;
        if (this.session.getIsAssociation()) {
            pAssociation = this.paymentAssociationMap.get(openItem.getPersonalAccount().getObjectid());
        }
        return pAssociation;
    }

    private void addToCorporateAccounts(PaymentAssociation pAssociation) {
        PersonalAccount[] accounts;
        for (PersonalAccount personalAccount : accounts = pAssociation.getAssociation().getPersonalAccounts()) {
            if (this.paymentAssociationMap.get(personalAccount.getObjectid()) != null) continue;
            this.paymentAssociationMap.put(personalAccount.getObjectid(), pAssociation);
            pAssociation.addAccount(personalAccount);
        }
    }

    private void addToIgnoredCreditNotes(OpenItem[] creditNotes) {
        for (OpenItem creditNote : creditNotes) {
            this.ignoredCreditNotesMap.put(creditNote.getObjectid(), creditNote);
        }
    }

    private boolean isIgnoredCreditNote(OpenItem creditNote) {
        return this.ignoredCreditNotesMap != null && this.ignoredCreditNotesMap.get(creditNote.getObjectid()) != null;
    }

    private ConversionRate getConversionRate(ICurrency currency) throws BusinessDomainException {
        ConversionRate conversionRate = this.conversionRateMap.get(currency.getObjectid());
        if (conversionRate == null) {
            conversionRate = ExchangeRatePersistencyManager.getConversionRate((boolean)true, (ConversionTable)this.session.getFinanceSetup().getBankRatesTable(), (ICurrency)currency, (ICurrency)this.session.getFinanceSetup().getBaseCurrency(), (Date)this.getRatesAsOf());
            this.conversionRateMap.put(currency.getObjectid(), conversionRate);
        }
        return conversionRate;
    }

    private Date getRatesAsOf() {
        if (this.session.getTransactionDate() != null && ISoftware.getUseTransactionDateToCalculateExchangeRatesInPaymentSession()) {
            return this.session.getTransactionDate();
        }
        return this.session.getBaseDatePayment();
    }

    private EsrPayment getEsrPaymentWithCountry(OpenItem openItem) throws BusinessDomainException {
        EsrPayment esrPayment = openItem.getEsrPayment();
        if (esrPayment != null) {
            ICountry country = this.getCountryForEsrPayment(openItem);
            esrPayment.setCountry(country);
        }
        return esrPayment;
    }

    private boolean isSplitPayment(GeneratePayment payment, GeneratePaymentRemittance generatePaymentRemittance) {
        return SplitPaymentHelper.isSplitPayment((GeneratePaymentSession)this.session, (PersonalAccount)payment.getPersonalAccount(), (OpenItem)generatePaymentRemittance.getOpenItem(), (ICountry)payment.getBankCountry(), (ModeOfPayment)payment.getTypeOfPayment());
    }

    private boolean withSwissStructuredReference(ModeOfPayment modeOfPayment, IOpenItem openItem, IPersonalAccountBankAddress bankAddress) {
        SwissReferenceTypeBuilder referenceTypeBuilder = new SwissReferenceTypeBuilder((IAccountingCompany)openItem.getPersonalAccount().getAccountingCompany()).withBankAddress(bankAddress).withModeOfPayment(modeOfPayment).withReference(openItem).withOpenItemType(openItem).withCurrency(openItem.getEnteredCurrency()).withPaymentSession(this.session);
        return SwissReferenceType.isStructuredReference((SwissReferenceType)referenceTypeBuilder.build());
    }

    private SplitPayment createSplitPayment(GeneratePayment paymentOfNetAmount, BigDecimal baseTaxAmount) throws BusinessDomainException {
        SplitPayment result = new SplitPayment(paymentOfNetAmount);
        PersonalAccount personalAccount = paymentOfNetAmount.getPersonalAccount();
        result.setPersonalAccount(personalAccount);
        result.setAmount(baseTaxAmount);
        result.setBaseAmount(baseTaxAmount);
        result.setCurrency(this.session.getFinanceSetup().getBaseCurrency());
        result.setConversionRate(ConversionRateMapper.ONE);
        result.setDocumentDate(paymentOfNetAmount.getDocumentDate());
        IPersonalAccountBankAddress splitPaymentBankAddress = SplitPaymentHelper.getBankAddressForSplitPayment((IPersonalAccount)paymentOfNetAmount.getPersonalAccount(), (IPersonalAccountBankAddress)paymentOfNetAmount.getPersonalAccountBankAddress());
        if (splitPaymentBankAddress != null) {
            this.fillBankAddress((FinancePayment)result, splitPaymentBankAddress);
        }
        result.setPostalAddress(paymentOfNetAmount.getPostalAddress());
        result.setBankAccount(SplitPaymentHelper.getBankAccountForSplitPayment((BankAccount)paymentOfNetAmount.getBankAccount()));
        result.setTypeOfPayment(ModeOfPayment.BACS);
        result.setWhitelistCheckRequired();
        return result;
    }
}

