/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.basictypes.filter.OpenItemSelection;
import com.varial.accounting.basictypes.filter.OpenItemSelectionPersistencyManager;
import com.varial.accounting.basictypes.filter.PersonalAccountSelection;
import com.varial.accounting.basictypes.filter.PersonalAccountSelectionPersistencyManager;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.batch.BatchPersistencyManager;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.payment.AdvancePaymentSession;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentSessionData;
import com.varial.accounting.domain.payment.IFinancePaymentSessionPersistencyManager;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountPersistencyManager;
import com.varial.accounting.domain.payment.RoundPaymentAmountMapper;
import com.varial.accounting.domain.payment.SplitPaymentTypeMapper;
import com.varial.accounting.domain.personalaccount.RemittanceType;
import com.varial.accounting.domain.personalaccount.RemittanceTypeMapper;
import com.varial.accounting.domain.sequenceno.SequenceNo;
import com.varial.accounting.domain.sequenceno.SequenceNoPersistencyManager;
import com.varial.accounting.payment.RoundPaymentAmountEnum;
import com.varial.accounting.payment.SplitPaymentTypeEnum;
import com.varial.accounting.personalaccount.RemittanceTypeEnum;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.MatchMode;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.common.persistency.payment.IPaymentsessionDao;
import com.varial.common.persistency.payment.PaymentsessionContainer;
import com.varial.framework.domain.advisor.Advisor;
import com.varial.framework.domain.advisor.AdvisorPersistencyManager;
import com.varial.framework.domain.correspondencetext.CorrespondenceText;
import com.varial.framework.domain.correspondencetext.CorrespondenceTextPersistencyManager;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.framework.domain.paymentbase.PaymentSessionPersistencyManager;
import com.varial.framework.domain.paymentbase.PaymentWorkflow;
import com.varial.framework.domain.paymentbase.PaymentWorkflowPersistencyManager;
import com.varial.framework.mapper.PaymentCountryMapper;
import com.varial.framework.paymentbase.GeneratePaymentFormTypeEnum;
import com.varial.framework.paymentbase.PaymentCountryEnum;
import com.varial.serverbase.domain.filter.ExtendedFilter;
import com.varial.serverbase.domain.filter.IExtendedFilterPersistencyManager;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.mapper.TimestampMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.util.Date;
import org.springframework.beans.factory.InitializingBean;

public class FinancePaymentSessionPersistencyManager
implements InitializingBean,
IFinancePaymentSessionPersistencyManager {
    private IPaymentsessionDao dao;
    private IExtendedFilterPersistencyManager extendedFilterPersistencyManager;

    public void setDao(IPaymentsessionDao dao) {
        this.dao = dao;
    }

    public void setExtendedFilterPersistencyManager(IExtendedFilterPersistencyManager extendedFilterPersistencyManager) {
        this.extendedFilterPersistencyManager = extendedFilterPersistencyManager;
    }

    public void afterPropertiesSet() {
        if (this.dao == null) {
            throw new IllegalArgumentException(TextFactory.makeArgumentNotSet((String)"dao"));
        }
        if (this.extendedFilterPersistencyManager == null) {
            throw new IllegalArgumentException(TextFactory.makeArgumentNotSet((String)"extendedFilterPersistencyManager"));
        }
    }

    public FinancePaymentSession[] getSessionsFreeForPayment(boolean isDirectDebit, AccountingCompany company, String name, Date creationDateFrom, Date creationDateTo) {
        Conjunction criterion = Restrictions.conjunction();
        criterion.add(Restrictions.eq((String)"oidcompany", (String)company.getObjectid()));
        if (isDirectDebit) {
            criterion.add(Restrictions.eq((String)"paysessiontype", (String)Integer.toString(2)));
        } else {
            criterion.add(Restrictions.in((String)"paysessiontype", (String[])new String[]{Integer.toString(1), Integer.toString(0), Integer.toString(3), Integer.toString(4)}));
        }
        criterion.add(Restrictions.isNotNull((String)"oidpaymentsposted"));
        criterion.add(Restrictions.isNull((String)"oidisdone"));
        if (!StringMapper.isNullString((String)name)) {
            criterion.add(Restrictions.like((String)"name", (String)name, (MatchMode)MatchMode.START));
        }
        if (creationDateFrom != null && creationDateTo != null && DateHelper.equal((Date)creationDateFrom, (Date)creationDateTo)) {
            criterion.add(Restrictions.eq((String)"creationdate", (String)DateMapper.toString((Date)creationDateFrom)));
        } else {
            if (creationDateFrom != null) {
                criterion.add(Restrictions.ge((String)"creationdate", (String)DateMapper.toString((Date)creationDateFrom)));
            }
            if (creationDateTo != null) {
                criterion.add(Restrictions.le((String)"creationdate", (String)DateMapper.toString((Date)creationDateTo)));
            }
        }
        return this.query(new Order[]{Order.desc((String)"objectts")}, (Criterion)criterion);
    }

    private FinancePaymentSession[] query(Order[] order, Criterion criterion) {
        try {
            PaymentsessionContainer[] containers = this.dao.getRows(order, criterion);
            int count = containers.length;
            FinancePaymentSession[] result = new FinancePaymentSession[count];
            for (int i = 0; i < count; ++i) {
                result[i] = this.buildSessionFromContainer(containers[i], true);
            }
            return result;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public FinancePaymentSession getFinancePaymentSession(String objectid, String objectts) {
        PaymentsessionContainer container = null;
        try {
            container = this.dao.getRowByObjectID(objectid);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container != null) {
            if (objectts != null) {
                FinancePaymentSession result = this.buildSessionFromContainer(container, false);
                result.setTimestamp(TimestampMapper.toDate((String)objectts));
                return result;
            }
            return this.buildSessionFromContainer(container, true);
        }
        throw ExceptionMapper.makeDataNotFoundPersistencyException((String)objectid);
    }

    public FinancePaymentSession[] getFinancePaymentSessionsForDate(AccountingCompany accountingCompany, int paymentSessionType, Date fromDate, Date toDate) {
        return this.query(new Order[]{Order.desc((String)"CREATIONDATE")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"OIDCOMPANY", (String)accountingCompany.getObjectid()), Restrictions.eq((String)"PAYSESSIONTYPE", (String)Integer.toString(paymentSessionType)), Restrictions.ge((String)"CREATIONDATE", (String)DateMapper.toString((Date)fromDate)), Restrictions.le((String)"CREATIONDATE", (String)DateMapper.toString((Date)toDate))}));
    }

    public FinancePaymentSession[] getPaymentSessionsForSequenceNo(SequenceNo sequenceNo) {
        return this.query(new Order[]{Order.desc((String)"NAME")}, Restrictions.eq((String)"OIDSEQUENCENO", (String)sequenceNo.getObjectid()));
    }

    public void load(AdvancePaymentSession bo) {
        PaymentsessionContainer container = null;
        try {
            container = this.dao.getRowByObjectID(bo.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)bo.getObjectid());
        }
        this.fillAdvancePaymentSession(bo, container);
    }

    public void delete(AdvancePaymentSession s) {
        try {
            PaymentSessionBankAccountPersistencyManager.delete((FinancePaymentSession)s);
            this.dao.delete(SessionContext.getInstance().getSession().getUserCode(), s.getObjectid(), s.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public void save(AdvancePaymentSession bo) {
        PaymentsessionContainer container = this.dao.getInitializedInstance();
        this.fillContainer(container, bo);
        try {
            container = bo.isNew() ? this.dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : this.dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        bo.setObjectid(container.getObjectid());
        bo.setTimestamp(container.getObjectTS());
        bo.setLastuser(container.getLastUserid());
        bo.setVersion(container.getVersion());
    }

    public void load(GeneratePaymentSession bo) {
        PaymentsessionContainer container = null;
        try {
            container = this.dao.getRowByObjectID(bo.getObjectid());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        if (container == null) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)bo.getObjectid());
        }
        this.fillGeneratePaymentSession(bo, container);
    }

    public void delete(GeneratePaymentSession bo) {
        try {
            OpenItemPersistencyManager.freePaymentSession((GeneratePaymentSession)bo);
            PaymentSessionBankAccountPersistencyManager.delete((FinancePaymentSession)bo);
            this.dao.delete(SessionContext.getInstance().getSession().getUserCode(), bo.getObjectid(), bo.getVersion());
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public void save(GeneratePaymentSession bo) {
        PaymentsessionContainer container = this.dao.getInitializedInstance();
        this.fillContainer(container, bo);
        try {
            container = bo.isNew() ? this.dao.insert(SessionContext.getInstance().getSession().getUserCode(), container) : this.dao.update(SessionContext.getInstance().getSession().getUserCode(), container);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        bo.setObjectid(container.getObjectid());
        bo.setTimestamp(container.getObjectTS());
        bo.setLastuser(container.getLastUserid());
        bo.setVersion(container.getVersion());
    }

    private void fillContainerBase(PaymentsessionContainer container, FinancePaymentSession bo) {
        PaymentSessionPersistencyManager.fillContainerBase((PaymentsessionContainer)container, (PaymentSession)bo);
        container.oidcompany = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getAccountingCompany());
        container.oidremittanceadv = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getRemittanceAdvice());
        container.oidpaymentsposted = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getPaymentsPosted());
        container.oidbatch = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getBatch());
        container.oidbillprinted = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getReverseBills());
        container.generatesepa = bo.getGenerateSepa();
        container.oidcheckwhitelist = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getWhiteListChecked());
    }

    private void fillContainer(PaymentsessionContainer container, AdvancePaymentSession bo) {
        this.fillContainerBase(container, (FinancePaymentSession)bo);
        container.paysessiontype = 1;
        container.defaultsendtype = RemittanceTypeMapper.toInt((RemittanceTypeEnum)RemittanceTypeEnum.RTE_NOREMITTANCE);
    }

    private void fillContainer(PaymentsessionContainer container, GeneratePaymentSession bo) {
        this.fillContainerBase(container, (FinancePaymentSession)bo);
        container.paysessiontype = this.getPaymentSessionType((FinancePaymentSession)bo);
        container.transactiondate = bo.getTransactionDate();
        container.nextdatepayment = bo.getNextDatePayment();
        container.basedatepayment = bo.getBaseDatePayment();
        container.basedatediscount = bo.getBaseDateSettlementDiscount();
        container.duefromdate = bo.getDueFromDate();
        container.duetodate = bo.getDueToDate();
        container.allinvoices = bo.getNoDownPaymentRequests();
        container.postdownpayments = bo.getPostDownPayments();
        container.roundpayamount = RoundPaymentAmountMapper.toInt((RoundPaymentAmountEnum)bo.getRoundPaymentAmount());
        container.invoicesduewdisc = bo.getInvoicesDueWithDiscount();
        container.forcedpayments = bo.getForcedPayments();
        container.invoicesdue = bo.getInvoicesDue();
        container.invoicesoverdue = bo.getInvoicesOverdue();
        container.limitamount = bo.getLimitAmount();
        container.minamountinvoice = bo.getMinAmountInvoice();
        container.maxamountinvoice = bo.getMaxAmountInvoice();
        container.maxamountpayment = bo.getMaxAmountPayment();
        container.minamountpayment = bo.getMinAmountPayment();
        container.paymentperoi = bo.getPaymentPerOpenItem();
        container.useopenitemstatus = bo.getUseOpenItemStatus();
        container.splitectransfer = bo.getSplitEcTransfer();
        String[] analysisCodes = bo.getAnalysisCodes();
        container.ac0 = StringMapper.extractValue((String[])analysisCodes, (int)0);
        container.ac1 = StringMapper.extractValue((String[])analysisCodes, (int)1);
        container.ac2 = StringMapper.extractValue((String[])analysisCodes, (int)2);
        container.ac3 = StringMapper.extractValue((String[])analysisCodes, (int)3);
        container.ac4 = StringMapper.extractValue((String[])analysisCodes, (int)4);
        container.ac5 = StringMapper.extractValue((String[])analysisCodes, (int)5);
        container.ac6 = StringMapper.extractValue((String[])analysisCodes, (int)6);
        container.ac7 = StringMapper.extractValue((String[])analysisCodes, (int)7);
        container.ac8 = StringMapper.extractValue((String[])analysisCodes, (int)8);
        container.ac9 = StringMapper.extractValue((String[])analysisCodes, (int)9);
        container.oidcorrespondtext = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getCorrespondenceText());
        container.entrylimit = bo.getEntryLimit();
        container.splitpaymenttype = SplitPaymentTypeMapper.toInt((SplitPaymentTypeEnum)bo.getSplitPaymentType());
        container.considersepaarea = bo.getConsiderSepaArea();
        container.isassociation = bo.getIsAssociation();
        container.shiftamforcheque = bo.getShiftAmountForCheque();
        container.executedate = bo.getExecuteDate();
        container.discountexecdate = bo.getExecuteDateForDiscount();
        container.oidpersaccselect = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getPersonalAccountSelection());
        container.oidopenitemselect = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getOpenItemSelection());
        container.checkbalance = bo.getCheckBalance();
        container.isdirdebanticip = bo.getIsDirectDebitAnticipated();
        container.creditnoteimmediat = bo.getCreditNotesDueImmediately();
        container.ignorepayments = bo.getIgnorePayments();
        container.billrevissuedate = bo.getIssueDateReverseBill();
        container.sendtypeallletter = bo.getSendTypeAllLetter();
        container.sendtypemail = bo.getSendTypeMail();
        container.sendtypemailletter = bo.getSendTypeMailLetter();
        container.sendtypefax = bo.getSendTypeFax();
        container.sendtypefaxletter = bo.getSendTypeFaxLetter();
        container.sendtypeletter = bo.getSendTypeLetter();
        container.defaultsendtype = PersistableEnumUtils.toPersistentValue((PersistableEnum)bo.getDefaultSendType());
        container.oidadvisor = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getAdvisor());
        container.advisoremail = bo.getAdvisorMail();
        container.advisorphone = bo.getAdvisorPhone();
        container.oidsequenceno = PersistentObjectUtils.getObjectidForContainer((IPersistentObject)bo.getSequenceNo());
        container.withsubaccounts = bo.getWithSubAccounts();
        container.ignorecorpacc = bo.getIgnoreCorpAcc();
        container.usedeviatingaddres = bo.getSendToDeviatingAddress();
        container.advicedate = bo.getRemittanceAdviceDate();
        container.preseturgentpaym = bo.isUrgentPayment();
        container.issplitpayment = bo.isSplitPayment();
    }

    private void fillFinancePaymentSession(FinancePaymentSession bo, PaymentsessionContainer container) {
        AccountingCompany company = null;
        if (!StringMapper.isNullString((String)container.oidcompany)) {
            company = AccountingCompanyPersistencyManager.getAccountingCompany((String)container.oidcompany);
        }
        PaymentWorkflow freeForPayment = null;
        if (!StringMapper.isNullString((String)container.oidfreeforpayment)) {
            freeForPayment = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidfreeforpayment);
        }
        PaymentWorkflow remittanceAdvice = null;
        if (!StringMapper.isNullString((String)container.oidremittanceadv)) {
            remittanceAdvice = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidremittanceadv);
        }
        PaymentWorkflow paymentsPosted = null;
        if (!StringMapper.isNullString((String)container.oidpaymentsposted)) {
            paymentsPosted = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidpaymentsposted);
        }
        PaymentWorkflow cheques = null;
        if (!StringMapper.isNullString((String)container.oidcheques)) {
            cheques = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidcheques);
        }
        PaymentWorkflow bacs = null;
        if (!StringMapper.isNullString((String)container.oidbacs)) {
            bacs = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidbacs);
        }
        PaymentWorkflow isDone = null;
        if (!StringMapper.isNullString((String)container.oidisdone)) {
            isDone = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidisdone);
        }
        Batch batch = null;
        if (!StringMapper.isNullString((String)container.oidbatch)) {
            batch = BatchPersistencyManager.getBatch((String)container.oidbatch);
        }
        PaymentWorkflow reverseBills = null;
        if (!StringMapper.isNullString((String)container.oidbillprinted)) {
            reverseBills = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidbillprinted);
        }
        PaymentWorkflow whiteListChecked = null;
        if (!StringMapper.isNullString((String)container.oidcheckwhitelist)) {
            whiteListChecked = PaymentWorkflowPersistencyManager.getPaymentWorkflow((String)container.oidcheckwhitelist);
        }
        bo.setData(company, container.name, container.creator, container.creationdate, container.note, freeForPayment, remittanceAdvice, paymentsPosted, cheques, bacs, isDone, batch, PaymentCountryMapper.toPaymentCountry((int)container.suppliercountry), reverseBills, container.generatesepa, whiteListChecked, container.paysessiontype);
        bo.setObjectid(container.getObjectid());
        bo.setTimestamp(container.getObjectTS());
        bo.setLastuser(container.getLastUserid());
        bo.setVersion(container.getVersion());
    }

    private void fillAdvancePaymentSession(AdvancePaymentSession s, PaymentsessionContainer container) {
        this.fillFinancePaymentSession((FinancePaymentSession)s, container);
    }

    public FinancePaymentSession buildSessionFromContainer(PaymentsessionContainer container, boolean readOnly) {
        if (container.paysessiontype == 1) {
            AdvancePaymentSession result = new AdvancePaymentSession(readOnly);
            this.fillAdvancePaymentSession(result, container);
            return result;
        }
        if (container.paysessiontype == 4 || container.paysessiontype == 0 || container.paysessiontype == 2 || container.paysessiontype == 3 || container.paysessiontype == 5 || container.paysessiontype == 6 || container.paysessiontype == 9) {
            GeneratePaymentSession result = new GeneratePaymentSession(readOnly, (IFinancePaymentSessionPersistencyManager)this);
            this.fillGeneratePaymentSession(result, container);
            return result;
        }
        return null;
    }

    private void fillGeneratePaymentSession(GeneratePaymentSession bo, PaymentsessionContainer container) {
        this.fillFinancePaymentSession((FinancePaymentSession)bo, container);
        CorrespondenceText text = null;
        if (!StringMapper.isNullString((String)container.oidcorrespondtext)) {
            text = CorrespondenceTextPersistencyManager.getTextByOid((String)container.oidcorrespondtext);
        }
        String[] analcodes = new String[]{container.ac0, container.ac1, container.ac2, container.ac3, container.ac4, container.ac5, container.ac6, container.ac7, container.ac8, container.ac9};
        ExtendedFilter extendedFilter = null;
        if (!StringMapper.isNullString((String)container.oidanalcodefilter)) {
            extendedFilter = this.extendedFilterPersistencyManager.getExtendedFilter(container.oidanalcodefilter);
        }
        Advisor advisor = null;
        if (!StringMapper.isNullString((String)container.oidadvisor)) {
            advisor = AdvisorPersistencyManager.getAdvisor((String)container.oidadvisor);
        }
        PersonalAccountSelection personalAccountSelection = null;
        if (!StringMapper.isNullString((String)container.oidpersaccselect)) {
            personalAccountSelection = PersonalAccountSelectionPersistencyManager.getPersonalAccountSelection((String)container.oidpersaccselect);
        }
        OpenItemSelection openItemSelection = null;
        if (!StringMapper.isNullString((String)container.oidopenitemselect)) {
            openItemSelection = OpenItemSelectionPersistencyManager.getOpenItemSelection((String)container.oidopenitemselect);
        }
        SequenceNo sequenceNo = null;
        if (!StringMapper.isNullString((String)container.oidsequenceno)) {
            sequenceNo = SequenceNoPersistencyManager.getSequenceNo((String)container.oidsequenceno);
        }
        GeneratePaymentSessionData data = new GeneratePaymentSessionData();
        data.setGeneratePaymentFormType(this.getGeneratePaymentFormType(container.paysessiontype));
        data.setTransactionDate(container.transactiondate);
        data.setNextDatePayment(container.nextdatepayment);
        data.setBaseDatePayment(container.basedatepayment);
        data.setBaseDateSettlementDiscount(container.basedatediscount);
        data.setDueFromDate(container.duefromdate);
        data.setDueToDate(container.duetodate);
        data.setNoDownPaymentRequests(container.allinvoices);
        data.setInvoicesDueWithDiscount(container.invoicesduewdisc);
        data.setForcedPayments(container.forcedpayments);
        data.setInvoicesDue(container.invoicesdue);
        data.setInvoicesOverdue(container.invoicesoverdue);
        data.setLimitAmount(container.limitamount);
        data.setMinAmountInvoice(container.minamountinvoice);
        data.setMaxAmountInvoice(container.maxamountinvoice);
        data.setMaxAmountPayment(container.maxamountpayment);
        data.setMinAmountPayment(container.minamountpayment);
        data.setPaymentPerOpenItem(container.paymentperoi);
        data.setUseOpenItemStatus(container.useopenitemstatus);
        data.setCorrText(text);
        data.setAnalysisCodes(analcodes);
        data.setEntryLimit(container.entrylimit);
        data.setSplitPaymentType(SplitPaymentTypeMapper.toSplitPaymentType((int)container.splitpaymenttype));
        data.setSplitEcTransfer(container.splitectransfer);
        data.setShiftAmountForCheque(container.shiftamforcheque);
        data.setExecuteDate(container.executedate);
        data.setExecuteDateForDiscount(container.discountexecdate);
        data.setCheckBalance(container.checkbalance);
        data.setExtFilter(extendedFilter);
        data.setGenerateSepa(container.generatesepa);
        data.setDirectDebitAnticipated(container.isdirdebanticip);
        data.setIssueDateReverseBill(container.billrevissuedate);
        data.setCreditNotesDueImmediately(container.creditnoteimmediat);
        data.setIgnorePayments(container.ignorepayments);
        data.setPostDownPayments(container.postdownpayments);
        data.setRoundPaymentAmount(RoundPaymentAmountMapper.toRoundPaymentAmount((int)container.roundpayamount));
        data.setSendTypeAllLetter(container.sendtypeallletter);
        data.setSendTypeMail(container.sendtypemail);
        data.setSendTypeMailLetter(container.sendtypemailletter);
        data.setSendTypeFax(container.sendtypefax);
        data.setSendTypeFaxLetter(container.sendtypefaxletter);
        data.setSendTypeLetter(container.sendtypeletter);
        data.setDefaultSendType((RemittanceType)PersistableEnumUtils.toEnum(RemittanceType.class, (int)container.defaultsendtype));
        data.setAdvisor(advisor);
        data.setAdvisorMail(container.advisoremail);
        data.setAdvisorPhone(container.advisorphone);
        data.setPersonalAccountSelection(personalAccountSelection);
        data.setOpenItemSelection(openItemSelection);
        data.setSequenceNo(sequenceNo);
        data.setWithSubAccounts(container.withsubaccounts);
        data.setConsiderSepaArea(container.considersepaarea);
        data.setIgnoreCorpAcc(container.ignorecorpacc);
        data.setSendToDeviatingAddress(container.usedeviatingaddres);
        data.setRemittanceAdviceDate(container.advicedate);
        data.setUrgentPayment(container.preseturgentpaym);
        data.setIsSplitPayment(container.issplitpayment);
        bo.setData(data);
    }

    public long checkName(FinancePaymentSession paymentSession) {
        try {
            long count = this.dao.getRowCount((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"name", (String)paymentSession.getName()), Restrictions.eq((String)"creationdate", (String)DateMapper.toString((Date)paymentSession.getCreationDate())), Restrictions.eq((String)"paysessiontype", (String)Integer.toString(this.getPaymentSessionType(paymentSession))), Restrictions.eq((String)"oidcompany", (String)paymentSession.getAccountingCompany().getObjectid())}));
            return count;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public FinancePaymentSession[] getSessionsByOpenItem(OpenItem openItem) {
        return this.query(null, Restrictions.sqlRestriction((String)"objectid IN (Select oidsession from Genpayremittance_T where oidopenitem = ?)", (String)openItem.getObjectid()));
    }

    private int getPaymentSessionType(FinancePaymentSession session) {
        int paymentSessionType;
        if (session.isAdvancePaymentSession()) {
            paymentSessionType = 1;
        } else {
            GeneratePaymentSession s = (GeneratePaymentSession)session;
            paymentSessionType = this.getGeneratePaymentSessionType(s.getGeneratePaymentFormType(), s.getPaymentCountry());
        }
        return paymentSessionType;
    }

    public int getGeneratePaymentSessionType(GeneratePaymentFormTypeEnum formType, PaymentCountryEnum paymentCountry) {
        int paymentType;
        if (formType.value() == 1) {
            paymentType = 2;
        } else if (formType.value() == 2) {
            paymentType = 4;
        } else if (formType.value() == 3) {
            paymentType = 5;
        } else if (formType.value() == 4) {
            paymentType = 6;
        } else if (formType.value() == 5) {
            paymentType = 9;
        } else if (formType.value() == 0) {
            paymentType = paymentCountry.value() == 0 ? 0 : 3;
        } else {
            throw ExceptionMapper.makeApplicationException((String)"unknown payment form type");
        }
        return paymentType;
    }

    public GeneratePaymentFormTypeEnum getGeneratePaymentFormType(int paysessiontype) {
        GeneratePaymentFormTypeEnum formType = paysessiontype == 2 ? GeneratePaymentFormTypeEnum.PFTE_DIRECT_DEBIT : (paysessiontype == 5 ? GeneratePaymentFormTypeEnum.PFTE_BILL_PAYABLE : (paysessiontype == 6 ? GeneratePaymentFormTypeEnum.PFTE_BILL_RECEIVABLE : (paysessiontype == 4 ? GeneratePaymentFormTypeEnum.PFTE_CUSTOMER_REPAYMENT : (paysessiontype == 9 ? GeneratePaymentFormTypeEnum.PFTE_REVERSE_FACTORING : GeneratePaymentFormTypeEnum.PFTE_GENERATE_PAYMENT))));
        return formType;
    }

    public FinancePaymentSession[] getSessionsByOpenItemAllocation(OpenItemAllocation openItemAllocation) {
        return this.query(null, Restrictions.sqlRestriction((String)"objectid IN (Select oidsession from Genpayremittance_T where OIDREVFACTALLOC = ?)", (String)openItemAllocation.getObjectid()));
    }

    public GeneratePaymentSession getGeneratePaymentSession(String objectid) {
        return new GeneratePaymentSession(objectid, (IFinancePaymentSessionPersistencyManager)this);
    }
}

