/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountPersistencyManager;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountUtils;
import com.varial.accounting.domain.payment.PaymentSessionPostingManager;
import com.varial.accounting.domain.sequenceno.SequenceNoMappingManager;
import com.varial.accounting.servantimpl.paymentrun.PaymentRunSessionMapper;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.Company;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentExceptionMapper;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.framework.domain.paymentbase.PaymentWorkflow;
import com.varial.framework.paymentbase.PaymentCountryEnum;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class FinancePaymentSession
extends PaymentSession {
    private PaymentWorkflow mWhitelistChecked;
    private PaymentWorkflow mRemittanceAdvice;
    private PaymentWorkflow mPaymentsPosted;
    private PaymentWorkflow mReverseBills;
    private Batch mBatch;
    private FinancePayment[] mFinancePayments;
    private PaymentSessionBankAccount[] mPaymentSessionBankAccounts;
    private boolean mGenerateSepa;
    private SequenceNoMappingManager mSequenceNoMappingManager;
    private FinanceSetup mFinanceSetup;
    private ICurrency mCurrency;
    private boolean whitelistChecking = false;
    private boolean withoutWhitelistCheck;
    private boolean withoutWhitelistCheckCalculated = false;
    private int mPaySessionType;

    protected FinancePaymentSession(AccountingCompany company) {
        super((Company)company);
    }

    protected FinancePaymentSession(String objectid) {
        super(objectid);
    }

    protected FinancePaymentSession(String objectid, int version) {
        super(objectid, version);
    }

    protected FinancePaymentSession(boolean readonly) {
        super(readonly);
    }

    protected void checkForDestroy() throws BusinessDomainException {
        this.requireLoaded();
        if (this.isGeneratePaymentSession() && !this.getUseOpenItemStatus() && this.getPaymentsPosted() != null && this.getIsDone() == null) {
            throw PaymentExceptionMapper.makeDeletingSessionNotAllowedDomainException();
        }
        this.checkForDestroy(this.mWhitelistChecked);
        this.checkForDestroy(this.mRemittanceAdvice);
        this.checkForDestroy(this.mPaymentsPosted);
        super.checkForDestroy();
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected void check() throws BusinessDomainException {
        if (this.whitelistChecking) {
            return;
        }
        if (this.getFreeForPayment() != null && this.getPaymentsPosted() == null) {
            this.checkFreeForPayment();
        }
        if (this.getPaymentsPosted() != null && this.getFreeForPayment() == null) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        if (this.getCheques() != null && this.checkForPosted()) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        if (this.getBacs() != null && this.getFreeForPayment() == null) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        if (this.getIsDone() != null && this.checkForPosted()) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
    }

    private void checkFreeForPayment() throws BusinessDomainException {
        FinancePayment[] payments = this.getFinancePayments();
        if (payments.length == 0) {
            throw FinancePaymentExceptionMapper.makeNoPaymentsDomainException();
        }
        List allPayments = PaymentRunSessionMapper.getPayments((FinancePaymentSession)this);
        for (FinancePayment payment : allPayments) {
            payment.checkFreeForPayment();
        }
    }

    protected void setData(AccountingCompany company, String name, String creator, Date creationDate, String note, PaymentWorkflow freeForPayment, PaymentWorkflow remittanceAdvice, PaymentWorkflow paymentsPosted, PaymentWorkflow cheques, PaymentWorkflow bacs, PaymentWorkflow isDone, Batch batch, PaymentCountryEnum paymentCountry, PaymentWorkflow reverseBills, boolean generateSepa, PaymentWorkflow whitelistChecked, int paySessionType) {
        super.setData((Company)company, null, name, creator, creationDate, note, freeForPayment, cheques, bacs, isDone, paymentCountry);
        this.mRemittanceAdvice = remittanceAdvice;
        this.mPaymentsPosted = paymentsPosted;
        this.mReverseBills = reverseBills;
        this.mBatch = batch;
        this.mGenerateSepa = generateSepa;
        this.mWhitelistChecked = whitelistChecked;
        this.mPaySessionType = paySessionType;
        this.mBacsAlreadySet = bacs != null || this.mRemittanceAdvice != null;
    }

    public PaymentSessionBankAccount[] getPaymentSessionBankAccounts() {
        this.requireLoaded();
        if (this.mPaymentSessionBankAccounts == null) {
            if (!this.isNew()) {
                this.mPaymentSessionBankAccounts = PaymentSessionBankAccountPersistencyManager.getPaymentSessionBankAccounts((FinancePaymentSession)this);
            }
            if (this.mPaymentSessionBankAccounts == null) {
                this.mPaymentSessionBankAccounts = new PaymentSessionBankAccount[0];
            }
        }
        return this.mPaymentSessionBankAccounts;
    }

    public void setPaymentSessionBankAccounts(PaymentSessionBankAccount[] paymentSessionBankAccounts) throws BusinessDomainException {
        if (this.getIsReverseFactoring()) {
            return;
        }
        if (paymentSessionBankAccounts == null || paymentSessionBankAccounts.length == 0) {
            throw FinancePaymentExceptionMapper.makeBankAccountMissingDomainException();
        }
        if (paymentSessionBankAccounts.length > 1 && !ISoftware.getAllowMultipleSelectionOfBankAccountsInPaymentSessions()) {
            this.checkMultipleSelectionOfBankAccounts(PaymentSessionBankAccountUtils.getPaymentSessionBankAccounts((PaymentSessionBankAccount[])paymentSessionBankAccounts, (Payment.PaymentType)Payment.PaymentType.GENERATE_PAYMENT));
            this.checkMultipleSelectionOfBankAccounts(PaymentSessionBankAccountUtils.getPaymentSessionBankAccounts((PaymentSessionBankAccount[])paymentSessionBankAccounts, (Payment.PaymentType)Payment.PaymentType.SPLIT_PAYMENT));
        }
        this.mPaymentSessionBankAccounts = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getPaymentSessionBankAccounts(), (IPersistentObject[])paymentSessionBankAccounts).toArray(new PaymentSessionBankAccount[0]);
    }

    private void checkMultipleSelectionOfBankAccounts(PaymentSessionBankAccount[] paymentSessionBankAccounts) throws BusinessDomainException {
        HashMap<String, BankAccount> bankAccountMap = new HashMap<String, BankAccount>();
        for (PaymentSessionBankAccount paymentSessionBankAccount : paymentSessionBankAccounts) {
            BankAccount bankAccount = paymentSessionBankAccount.getBankAccount();
            if (bankAccountMap.get(bankAccount.getObjectid()) != null) {
                throw FinancePaymentExceptionMapper.makeBankAccountAlreadySelectedDomainException((String)bankAccount.getCode());
            }
            bankAccountMap.put(bankAccount.getObjectid(), bankAccount);
        }
    }

    public void addPaymentSessionBankAccount(PaymentSessionBankAccount paymentSessionBankAccount) {
        ArrayList<PaymentSessionBankAccount> paymentSessionBankAccounts = new ArrayList<PaymentSessionBankAccount>(Arrays.asList(this.getPaymentSessionBankAccounts()));
        paymentSessionBankAccounts.add(paymentSessionBankAccount);
        this.mPaymentSessionBankAccounts = paymentSessionBankAccounts.toArray(new PaymentSessionBankAccount[0]);
    }

    public SequenceNoMappingManager getSequenceNoMappingManager() {
        if (this.mSequenceNoMappingManager == null) {
            this.mSequenceNoMappingManager = new SequenceNoMappingManager(this.getAccountingCompany());
        }
        return this.mSequenceNoMappingManager;
    }

    public FinanceSetup getFinanceSetup() {
        if (this.mFinanceSetup == null) {
            this.mFinanceSetup = this.getAccountingCompany().getFinanceSetup();
        }
        return this.mFinanceSetup;
    }

    public AccountingCompany getAccountingCompany() {
        this.requireLoaded();
        return (AccountingCompany)this.getCompany();
    }

    public PaymentWorkflow getRemittanceAdvice() {
        this.requireLoaded();
        return this.mRemittanceAdvice;
    }

    public void setRemittanceAdvice(PaymentWorkflow remittanceAdvice) throws BusinessDomainException {
        this.requireLoaded();
        this.protocol("remittanceadvice", (IPersistentObject)this.mRemittanceAdvice, (IPersistentObject)remittanceAdvice);
        if (remittanceAdvice == null) {
            this.checkForDestroy(this.mRemittanceAdvice);
        }
        this.mRemittanceAdvice = remittanceAdvice;
    }

    public PaymentWorkflow getPaymentsPosted() {
        this.requireLoaded();
        return this.mPaymentsPosted;
    }

    public void setPaymentsPosted(PaymentWorkflow paymentsPosted) throws BusinessDomainException {
        this.requireLoaded();
        this.protocol("paymentsposted", (IPersistentObject)this.mPaymentsPosted, (IPersistentObject)paymentsPosted);
        if (paymentsPosted == null) {
            this.checkForDestroy(this.mPaymentsPosted);
        }
        if (paymentsPosted != null) {
            this.getPaymentSessionBankAccounts();
            for (int i = 0; i < this.mPaymentSessionBankAccounts.length; ++i) {
                this.mPaymentSessionBankAccounts[i].makeSaveable();
                this.mPaymentSessionBankAccounts[i].setIsPosted(true);
            }
        }
        this.mPaymentsPosted = paymentsPosted;
    }

    public void printCheques() throws BusinessDomainException {
        this.requireLoaded();
        if (this.checkForPosted()) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        super.printCheques();
    }

    public void printBills() throws BusinessDomainException {
        this.requireLoaded();
        super.printCheques();
    }

    public void printReverseBills() throws BusinessDomainException {
        this.requireLoaded();
        PaymentWorkflow reverseBills = this.getReverseBills();
        if (reverseBills == null) {
            reverseBills = new PaymentWorkflow();
        } else {
            reverseBills.makeSaveable();
        }
        reverseBills.setIdent(SessionContext.getInstance().getSession().getUserCode());
        reverseBills.setOk(true);
        reverseBills.setDate(DateHelper.today());
        this.setReverseBills(reverseBills);
    }

    public PaymentWorkflow getReverseBills() {
        this.requireLoaded();
        return this.mReverseBills;
    }

    public void setReverseBills(PaymentWorkflow reverseBills) throws BusinessDomainException {
        this.requireLoaded();
        this.protocol("reverseBills", (IPersistentObject)this.mReverseBills, (IPersistentObject)reverseBills);
        if (reverseBills == null) {
            this.checkForDestroy(this.mReverseBills);
        }
        this.mReverseBills = reverseBills;
    }

    public void postPayments() throws BusinessDomainException {
        this.requireLoaded();
        if (this.getFreeForPayment() == null) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        if (this.mPaymentsPosted != null) {
            throw FinancePaymentExceptionMapper.makeSessionAlreadyPostedDomainException();
        }
        PaymentWorkflow posted = new PaymentWorkflow();
        posted.setIdent(SessionContext.getInstance().getSession().getUserCode());
        posted.setOk(true);
        posted.setDate(new VDate().getDate());
        this.setPaymentsPosted(posted);
        PaymentSessionPostingManager manager = new PaymentSessionPostingManager(this);
        this.mBatch = manager.post();
    }

    public void setDone() throws BusinessDomainException {
        this.requireLoaded();
        if (this.checkForPosted()) {
            throw FinancePaymentExceptionMapper.makeSessionNotYetPostedDomainException();
        }
        if (this.mBatch != null && !this.mBatch.getIsClosed() && !this.mBatch.isEmpty()) {
            this.mBatch.makeSaveable();
            this.mBatch.close();
        }
        super.setDone();
    }

    public Batch getBatch() {
        this.requireLoaded();
        return this.mBatch;
    }

    public void exportPayment() throws BusinessDomainException {
        this.requireLoaded();
        if (this.getFreeForPayment() == null) {
            throw PaymentExceptionMapper.makeWorkFlowNotInOrderDomainException();
        }
        super.exportPayment();
    }

    public boolean checkForPosted() {
        return this.getPaymentsPosted() == null;
    }

    public boolean couldBePosted() {
        return true;
    }

    public boolean chequesCouldBePrinted() {
        if (this.getIsDirectDebit() || this.getIsForeignPayment() || this.getIsReverseFactoring()) {
            return false;
        }
        if (this.getPaymentsPosted() == null) {
            return false;
        }
        if (this.getCheques() != null) {
            return true;
        }
        return super.chequesCouldBePrinted();
    }

    public boolean bacsCouldBePrinted() {
        return this.getFreeForPayment() != null;
    }

    public boolean bacsAdviceCouldBePrinted() {
        return this.bacsCouldBePrinted();
    }

    public boolean reverseBillsCouldBePrinted() {
        if (this.getIsDirectDebit() || this.getIsForeignPayment() || this.getIsReverseFactoring()) {
            return false;
        }
        if (this.getPaymentsPosted() == null) {
            return false;
        }
        if (this.getReverseBills() != null) {
            return true;
        }
        Payment[] payments = this.getPayments();
        if (payments != null) {
            for (int i = 0; i < payments.length; ++i) {
                if (payments[i].getTypeOfPayment() != ModeOfPayment.BILL_OF_EXCHANGE && payments[i].getTypeOfPayment() != ModeOfPayment.CHECK_BILL_OF_EXCHANGE) continue;
                return true;
            }
        }
        return false;
    }

    public void printRemittanceAdvice() throws BusinessDomainException {
        this.requireLoaded();
        PaymentWorkflow advice = this.getRemittanceAdvice();
        if (advice == null) {
            advice = new PaymentWorkflow();
        } else {
            advice.makeSaveable();
        }
        advice.setIdent(SessionContext.getInstance().getSession().getUserCode());
        advice.setOk(true);
        advice.setDate(DateHelper.today());
        this.setRemittanceAdvice(advice);
    }

    public FinancePayment[] getFinancePayments() {
        if (this.mFinancePayments == null) {
            Payment[] payments = this.getPayments();
            this.mFinancePayments = new FinancePayment[payments.length];
            System.arraycopy(payments, 0, this.mFinancePayments, 0, payments.length);
        }
        return this.mFinancePayments;
    }

    public void setFinancePayments(List<FinancePayment> payments) throws BusinessDomainException {
        this.mFinancePayments = payments.toArray(new FinancePayment[0]);
        super.setPayments((Payment[])this.mFinancePayments);
    }

    public abstract FinancePayment[] getFinancePaymentsForPosting();

    public boolean getUseOpenItemStatus() {
        return false;
    }

    protected void checkValueDate() throws BusinessDomainException {
    }

    public boolean getGenerateSepa() {
        this.requireLoaded();
        return this.mGenerateSepa;
    }

    public void setGenerateSepa(boolean generateSepa) {
        this.protocol("generatesepa", this.mGenerateSepa, generateSepa);
        this.mGenerateSepa = generateSepa;
    }

    public abstract boolean isGeneratePaymentSession();

    public abstract boolean isAdvancePaymentSession();

    public boolean getIsDirectDebit() {
        return false;
    }

    public boolean getIsReverseFactoring() {
        return false;
    }

    public ICurrency getCurrency() {
        return this.mCurrency;
    }

    public void setCurrency(ICurrency currency) {
        this.mCurrency = currency;
    }

    public PaymentWorkflow getWhiteListChecked() {
        this.requireLoaded();
        return this.mWhitelistChecked;
    }

    public void setWhitelistChecked(PaymentWorkflow whitelistChecked) throws BusinessDomainException {
        this.requireLoaded();
        this.protocol("whitelistchecked", (IPersistentObject)this.mWhitelistChecked, (IPersistentObject)whitelistChecked);
        if (whitelistChecked == null) {
            this.checkForDestroy(this.mWhitelistChecked);
        }
        this.mWhitelistChecked = whitelistChecked;
    }

    public void checkedWhitelist() throws BusinessDomainException {
        this.requireLoaded();
        PaymentWorkflow whitelistChecked = this.getWhiteListChecked();
        if (whitelistChecked == null) {
            whitelistChecked = new PaymentWorkflow();
        } else {
            whitelistChecked.makeSaveable();
        }
        whitelistChecked.setIdent(SessionContext.getInstance().getSession().getUserCode(), true);
        whitelistChecked.setOk(true);
        whitelistChecked.setDate(DateHelper.today(), true);
        this.setWhitelistChecked(whitelistChecked);
    }

    public ICountry getCompanyCountry() {
        return this.getAccountingCompany().getCurrentAddress() != null && this.getAccountingCompany().getCurrentAddress().getPostalAddress() != null ? this.getAccountingCompany().getCurrentAddress().getPostalAddress().getCountry() : null;
    }

    public void setWhitelistChecking() {
        this.whitelistChecking = true;
    }

    public boolean getGeneratePaymentsWithoutWhitelistCheck() {
        if (this.withoutWhitelistCheckCalculated) {
            return this.withoutWhitelistCheck;
        }
        Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
        this.withoutWhitelistCheck = configuration.getBoolean("com.varial.server.GeneratePaymentsWithoutWhitelistCheck", false);
        this.withoutWhitelistCheckCalculated = true;
        return this.withoutWhitelistCheck;
    }

    public boolean isSplitPayment() {
        return false;
    }

    public int getPaySessionType() {
        return this.mPaySessionType;
    }
}

