/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.openitem.EsrPayment;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.BigDecimalMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class CurrencyPaymentTypeOpenItems {
    private final ICurrency foreignCurrency;
    private final ModeOfPayment paymentType;
    private final IPersonalAccountBankAddress bankAddress;
    private final Date dueDate;
    private final List<OpenItem> openItemList;
    private BigDecimal openAmount;
    private final PaymentSessionBankAccount paymentSessionBankAccount;
    private final EsrPayment esrPayment;

    CurrencyPaymentTypeOpenItems(ICurrency foreignCurrency, ModeOfPayment paymentType, IPersonalAccountBankAddress bankAddress, Date dueDate, PaymentSessionBankAccount paymentSessionBankAccount, EsrPayment esrPayment) {
        this.foreignCurrency = foreignCurrency;
        this.paymentType = paymentType;
        this.bankAddress = bankAddress;
        this.dueDate = dueDate;
        this.openItemList = new ArrayList<OpenItem>();
        this.openAmount = null;
        this.paymentSessionBankAccount = paymentSessionBankAccount;
        this.esrPayment = esrPayment;
    }

    EsrPayment getEsrPayment() {
        return this.esrPayment;
    }

    ICurrency getForeignCurrency() {
        return this.foreignCurrency;
    }

    Date getDueDate() {
        return this.dueDate;
    }

    ModeOfPayment getPaymentType() {
        return this.paymentType;
    }

    IPersonalAccountBankAddress getBankAddress() {
        return this.bankAddress;
    }

    PaymentSessionBankAccount getPaymentSessionBankAccount() {
        return this.paymentSessionBankAccount;
    }

    void add(OpenItem oi) {
        this.openItemList.add(oi);
        this.openAmount = null;
    }

    OpenItem[] getOpenItems() {
        OpenItem[] result = new OpenItem[this.openItemList.size()];
        this.openItemList.toArray(result);
        return result;
    }

    public BigDecimal getOpenAmount() {
        if (this.openAmount == null) {
            this.openAmount = BigDecimalMapper.ZERO;
            for (OpenItem o : this.openItemList) {
                this.openAmount = this.openAmount.add(o.getOpenAmount());
            }
        }
        return this.openAmount;
    }
}

